/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.IModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.ui.DataSourceControl;
import cerent.util.IObservableManager;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import java.util.Observable;
import java.util.Observer;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public abstract class AbstractProvTableModel
extends AbstractTableModel
implements Observer,
DataSourceControl {
    public static final String CONTACT_CLOSED = "Closed";
    public static final String CONTACT_OPEN = "Open";
    protected IModel[] cmsModels;
    protected int numLines;
    protected IObservableManager observableManager;
    protected boolean[] rowDirty;
    protected String[] columnNames;
    protected String prefix;
    protected boolean enabled = true;

    public AbstractProvTableModel(IModel[] iModelArray, boolean bl, String string) {
        this.prefix = string;
        this.observableManager = new ObservableManager(this, bl);
        this.setModels(iModelArray);
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    public int getRowCount() {
        return this.numLines;
    }

    public Class getColumnClass(int n) {
        return Object.class;
    }

    public String getPrintableContactStatus(boolean bl) {
        if (bl) {
            return CONTACT_CLOSED;
        }
        return CONTACT_OPEN;
    }

    public Boolean getBoolean(boolean bl) {
        if (bl) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void setModels(IModel[] iModelArray) {
        this.cmsModels = iModelArray != null ? iModelArray : new IModel[]{};
        this.numLines = this.cmsModels.length;
        this.rowDirty = new boolean[this.numLines];
        Observable[] observableArray = new Observable[this.numLines];
        for (int i = 0; i < this.numLines; ++i) {
            observableArray[i] = (Observable)iModelArray[i];
        }
        this.observableManager.setObservable(observableArray);
    }

    public void refreshFromModel() throws Exception {
        this.fireTableDataChanged();
    }

    public void refreshFromModel(int n) throws Exception {
        this.refreshFromModel();
    }

    public boolean isDirty() {
        for (int i = 0; i < this.rowDirty.length; ++i) {
            if (!this.rowDirty[i]) continue;
            return true;
        }
        return false;
    }

    public IObservableManager getObservableManager() {
        return this.observableManager;
    }

    public void disposeDataSource() {
        if (this.observableManager != null) {
            this.observableManager.reset();
        }
    }

    public boolean validateData() {
        return true;
    }

    public void setDirty(boolean bl) {
        if (!bl) {
            for (int i = 0; i < this.numLines; ++i) {
                this.rowDirty[i] = false;
            }
        }
    }

    public void update(Observable observable, Object object) {
        try {
            if (object instanceof Integer && (Integer)object == ModelUpdateType.DELETED) {
                return;
            }
            this.refreshFromModel();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void fireTableChanged(TableModelEvent tableModelEvent) {
        SwingUtilities.invokeLater(new DispatchSwing(this, tableModelEvent));
    }

    void _fireTableChanged(TableModelEvent tableModelEvent) {
        super.fireTableChanged(tableModelEvent);
    }

    protected void printStackTrace(Exception exception) {
        SDebug.printStackTrace((Throwable)exception);
    }

    static class DispatchSwing
    implements Runnable {
        private TableModelEvent e;
        private AbstractProvTableModel _apt;

        DispatchSwing(AbstractProvTableModel abstractProvTableModel, TableModelEvent tableModelEvent) {
            this._apt = abstractProvTableModel;
            this.e = tableModelEvent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this._apt._fireTableChanged(this.e);
            }
            finally {
                this.e = null;
                this._apt = null;
            }
        }
    }
}

