/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.loader.ElementFactoryFinder;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOnePlusOneModel;
import cerent.cms.model.IRevertiveBehavior;
import cerent.cms.model.ITdmPortModel;
import cerent.cms.model.ITermConnectionModel;
import cerent.cms.model.LinkModel;
import cerent.cms.model.UniDirectionalNotSupported;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.ui.AndNodePane;
import cerent.cms.ui.AndPortPane;
import cerent.cms.ui.AndStepPane;
import cerent.cms.ui.IEntityCellRenderer;
import cerent.cms.ui.WizardDialog;
import cerent.cms.ui.network.NetworkMap;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.gui.CerentDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

public class AddNode2OnePlusOneDialog
extends WizardDialog {
    private static final SDebug db = new SDebug("AddNode2OnePlusOneDialog");
    private static final int VIGN_WIDTH = 250;
    private static final int WIDTH = 930;
    static final int SHORT = 340;
    String newNodeName = "";
    String newHostName = "";
    String srcNodeName = "";
    String dstNodeName = "";
    String srcPrtName;
    String dstPrtName;
    private String nodePageTitle = "Step 1: Select Node to Add to Protection";
    private String portPage = "Step 2: Select Protection Group Ports on ";
    private String fullPortPageTitle = "";
    private String disableProtectTitle = "Step 2: Disable Traffic Protection";
    private String refiberProtectTitle = "Step 3: Re-fiber the Protect Path";
    private String unreachablePaneTitle = "";
    AndStepPane infoUnreachable;
    AndStepPane refiberProtectPane;
    AndStepPane disableProtectPane;
    AndNodePane andNodePane;
    AndPortPane andPortPane;
    private String statusText = "";
    INetLink netLink;
    LinkModel linkModel;
    IRevertiveBehavior rbr;
    boolean isBidirectional;
    INetElement newNetElement;
    INodeModel srcNodeModel;
    INodeModel dstNodeModel;
    ITermConnectionModel srcTermConnModel;
    ITermConnectionModel dstTermConnModel;
    IOnePlusOneModel sopo;
    IOnePlusOneModel dopo;
    IOnePlusOneModel addOpo1 = null;
    IOnePlusOneModel addOpo2 = null;
    IEntityModel workModel1;
    IEntityModel workModel2;
    IEntityModel protectModel1;
    IEntityModel protectModel2;
    IEntityModel srcWorkModel;
    IEntityModel dstWorkModel;
    IEntityModel srcProtectModel;
    IEntityModel dstProtectModel;
    int srcWorkIndex;
    int srcProtectIndex;
    int dstWorkIndex;
    int dstProtectIndex;
    int srcWorkSlot;
    int srcProtectSlot;
    int dstWorkSlot;
    int dstProtectSlot;
    String srcWorkPort;
    String srcProtectPort;
    String dstWorkPort;
    String dstProtectPort;
    boolean protectionRestored = false;
    boolean nodeUnreachable = false;
    boolean isLdccLink = false;
    IEntityCellRenderer entityCellRenderer;
    TDMTerminology tdmTerm;
    NetworkMap nmap;
    private String[] titleUnreachable = new String[]{"Step 4: Update Circuit(s) on ", "Step 5: Restore Traffic Protection", "Step 6: Force Traffic to Protect Path", "Step 7: Re-fiber the Working Path", "Step 8: Force Traffic to Working Path", "Step 9: Completed"};
    private String[] titleReachable = new String[]{"Step 4: Update Circuit(s) on ", "Step 5: Force Traffic to Protect Path", "Step 6: Re-fiber the Working Path", "Step 7: Force Traffic to Working Path", "Step 8: Completed"};

    public static AddNode2OnePlusOneDialog instance(JComponent jComponent, NetworkMap networkMap, INetLink iNetLink, String string) {
        Frame frame = JOptionPane.getFrameForComponent(jComponent);
        return new AddNode2OnePlusOneDialog(frame, networkMap, iNetLink, string);
    }

    public AddNode2OnePlusOneDialog(Frame frame, NetworkMap networkMap, INetLink iNetLink, String string) {
        super(frame, string);
        this.netLink = iNetLink;
        this.nmap = networkMap;
        this.init();
        this.reset();
        this.createPanes();
        this.setLocationRelativeTo(frame);
    }

    public void init() {
        block3: {
            this.srcNodeName = this.netLink.getSrc().getName();
            this.dstNodeName = this.netLink.getDst().getName();
            this.linkModel = (LinkModel)this.netLink.getLinkModel();
            this.sopo = (IOnePlusOneModel)this.linkModel.getEndElementModel(true);
            this.dopo = (IOnePlusOneModel)this.linkModel.getEndElementModel(false);
            this.srcNodeModel = this.linkModel.src();
            this.dstNodeModel = this.linkModel.dst();
            this.srcPrtName = this.sopo.getName();
            this.dstPrtName = this.dopo.getName();
            this.srcWorkIndex = this.linkModel.getOnePlusOneSrcWorkingCardEntityIndex();
            this.srcProtectIndex = this.linkModel.getOnePlusOneSrcProtectCardEntityIndex();
            this.dstWorkIndex = this.linkModel.getOnePlusOneDstWorkingCardEntityIndex();
            this.dstProtectIndex = this.linkModel.getOnePlusOneDstProtectCardEntityIndex();
            this.srcTermConnModel = this.srcNodeModel.getDccTermConnectionModel();
            this.dstTermConnModel = this.dstNodeModel.getDccTermConnectionModel();
            this.srcWorkModel = this.linkModel.getEntityModel(this.srcNodeModel, this.srcWorkIndex);
            this.dstWorkModel = this.linkModel.getEntityModel(this.dstNodeModel, this.dstWorkIndex);
            this.srcProtectModel = this.linkModel.getEntityModel(this.srcNodeModel, this.srcProtectIndex);
            this.dstProtectModel = this.linkModel.getEntityModel(this.dstNodeModel, this.dstProtectIndex);
            this.srcWorkSlot = this.srcWorkModel.getSlot();
            this.dstWorkSlot = this.dstWorkModel.getSlot();
            this.srcProtectSlot = this.srcProtectModel.getSlot();
            this.dstProtectSlot = this.dstProtectModel.getSlot();
            this.entityCellRenderer = ElementFactoryFinder.getElementFactory(this.srcNodeModel).createEntityCellRenderer(this.srcNodeModel, "slot ");
            this.srcWorkPort = this.entityCellRenderer.getPortString(this.srcWorkModel, false);
            this.dstWorkPort = this.entityCellRenderer.getPortString(this.dstWorkModel, false);
            this.srcProtectPort = this.entityCellRenderer.getPortString(this.srcProtectModel, false);
            this.dstProtectPort = this.entityCellRenderer.getPortString(this.dstProtectModel, false);
            ITermConnectionModel iTermConnectionModel = this.srcNodeModel.getLdccTermConnectionModel();
            this.isLdccLink = iTermConnectionModel.entityExistsInTerminations(this.linkModel.getEndEntityModel(true));
            this.addOpo1 = null;
            this.addOpo2 = null;
            this.rbr = this.sopo.getReversion();
            this.isBidirectional = this.sopo.isBidirectional();
            if (this.isBidirectional) {
                try {
                    this.sopo.setBidirectional(false);
                    this.dopo.setBidirectional(false);
                }
                catch (UniDirectionalNotSupported uniDirectionalNotSupported) {
                    db.println("Caught UniDirectionalNotSupported in init!");
                    if (!db.on()) break block3;
                    SDebug.printStackTrace((Throwable)uniDirectionalNotSupported);
                }
            }
        }
        this.tdmTerm = this.srcNodeModel.getTDMTerminology();
    }

    public void sanityCheck() throws Exception {
        if (this.sopo.isBidirectional() != this.dopo.isBidirectional()) {
            throw new Exception("Bidirectional setting mismatch for the selected 1+1 protection");
        }
        IEntityModel iEntityModel = this.linkModel.getEndEntityModel(true);
        IEntityModel iEntityModel2 = this.linkModel.getEndEntityModel(false);
        if (iEntityModel == null || iEntityModel2 == null) {
            throw new Exception("The source and/or destination ports are not fully specified.");
        }
        if (iEntityModel instanceof ITdmPortModel && iEntityModel2 instanceof ITdmPortModel) {
            if (!((ITdmPortModel)iEntityModel).isPortActive() || !((ITdmPortModel)iEntityModel2).isPortActive()) {
                throw new Exception("Traffic must be forced to the working port(s) before upgrading.");
            }
            if (!((ITdmPortModel)iEntityModel).isSonetDccTermination() || !((ITdmPortModel)iEntityModel2).isSonetDccTermination()) {
                throw new Exception("Both source and destination ports must have DCC termination enabled.");
            }
        } else {
            throw new Exception("The source and/or destination ports must be provisioned as " + this.tdmTerm.getTermForAddCard(0) + " ports.");
        }
        List list = ((ITdmPortModel)iEntityModel).getITdmLineModel().getOhConnectionsList();
        this.nmap.warnOhCircuit(list, this);
    }

    public void setNodeUnreachable(boolean bl) {
        this.nodeUnreachable = bl;
    }

    public boolean isNodeUnreachable() {
        return this.nodeUnreachable;
    }

    public String getSrcNodeName() {
        return this.srcNodeName;
    }

    public String getDstNodeName() {
        return this.dstNodeName;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public void setStatusText(String string) {
        this.statusText = string;
    }

    private void createPanes() {
        if (AddNode2OnePlusOneDialog.db.on) {
            db.println("createPanes() called");
        }
        this.addStatusPanel(new WizardDialog.StatusPanel(this, "/images/CTC_dialogVignette.gif", new Dimension(250, 340)));
        this.addPage(new AndStepPane("Information", this, 100));
        this.andNodePane = new AndNodePane(this.nodePageTitle, this);
        this.addPage(this.andNodePane);
    }

    public void addPortPane() {
        this.fullPortPageTitle = this.portPage + this.newNodeName;
        this.andPortPane = new AndPortPane(this.fullPortPageTitle, this);
        this.addPage(this.andPortPane);
    }

    public void addUnreachableInfoPane(String string) {
        this.unreachablePaneTitle = string;
        this.infoUnreachable = new AndStepPane(string, this, 101);
        this.addPage(this.infoUnreachable);
    }

    public void addDisableProtectPane() {
        this.disableProtectPane = new AndStepPane(this.disableProtectTitle, this, 2);
        this.addPage(this.disableProtectPane);
    }

    public void addUnreachableNodePanes() {
        int n = 4;
        int n2 = 9;
        this.addPage(new AndStepPane(this.titleUnreachable[0] + this.newNodeName, this, n));
        for (int i = n + 1; i <= n2; ++i) {
            this.addPage(new AndStepPane(this.titleUnreachable[i - n], this, i));
        }
    }

    protected void addRefiberProtectPane() {
        this.refiberProtectPane = new AndStepPane(this.refiberProtectTitle, this, 3);
        this.addPage(this.refiberProtectPane);
    }

    public void addReachableNodePanes() {
        int n = 4;
        int n2 = 8;
        this.addPage(new AndStepPane(this.titleReachable[0] + this.newNodeName, this, n));
        for (int i = n + 1; i <= n2; ++i) {
            this.addPage(new AndStepPane(this.titleReachable[i - n], this, i));
        }
    }

    protected void apply() {
    }

    protected void reset() {
        if (AddNode2OnePlusOneDialog.db.on) {
            db.println("reset() called");
        }
        this.setHeight(340);
        if (this.getStatusPanel() != null) {
            this.getStatusPanel().reset();
        }
        this.setFinishEnabled(false);
        super.reset();
    }

    void setHeight(int n) {
        this.setSize(new Dimension(930, n));
        this.invalidate();
    }

    protected void handleBack(String string) {
        super.handleBack(string);
        if (string.compareTo(this.unreachablePaneTitle) == 0) {
            this.removePage(this.infoUnreachable);
        } else if (string.compareTo(this.disableProtectTitle) == 0) {
            this.removePage(this.disableProtectPane);
        } else if (string.compareTo(this.fullPortPageTitle) == 0) {
            this.removePage(this.andPortPane);
        } else if (string.compareTo(this.refiberProtectTitle) == 0) {
            this.removePage(this.refiberProtectPane);
            this.refiberProtectPane.handleCancel();
        }
    }

    protected void finishUpgrade() {
        if (this.isBidirectional) {
            try {
                this.sopo.setBidirectional(true);
                this.dopo.setBidirectional(true);
                if (this.addOpo1 != null) {
                    this.addOpo1.setBidirectional(true);
                    this.addOpo1 = null;
                }
                if (this.addOpo2 != null) {
                    this.addOpo2.setBidirectional(true);
                    this.addOpo2 = null;
                }
            }
            catch (Exception exception) {
                CerentDialog.errorDialog((Component)this, (Exception)exception, (String)"Error In Finishing");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    public void dispose() {
        this.finishUpgrade();
        super.dispose();
    }
}

