/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ShellDebugManager;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.AbstractViewController;
import cerent.cms.ui.CSHelpButtonPane;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.TabbedView;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;

public class DiagMaintPane
extends AbstractPane
implements ActionListener {
    private AbstractViewController avc = null;
    private IModel paneModel;
    protected static final SDebug db = new SDebug((KDebug)db, "DiagMaintPane");
    protected JComboBox ospfDumpNodesCB;
    protected JComboBox ospfLSDBCB;
    protected JButton ospfDNClearB;
    protected JButton ospfDNRetrieveB;
    protected JButton ospfLSDBB;
    protected JTextArea ospfDumpNodesTA;
    protected JTextArea ospfLSDBTA;
    private UScrollPane scrollPaneLSDB;
    private UScrollPane scrollPaneDNodes;
    protected static final int DUMP_NODES_CMD = 0;
    protected static final String SELECT_NODE = " Select Node: ";
    protected static final String NODE_INFO = "OSPF Node Information";
    protected static final String LSDB = "OSPF Link-State Database";
    protected static final String CLEAR = "Clear";
    protected static final String RETRIEVE = "Retrieve";
    protected static final String CLEAR_TIP = "Clear the text area below";
    protected static final String RETRIEVE_TIP = "Retrieve OSPF Node Information";
    ShellDebugManager sdm;

    public DiagMaintPane(String string, IModel iModel, TabbedView tabbedView) {
        super(string, iModel, tabbedView);
        this.paneModel = iModel;
        this.sdm = ShellDebugManager.instance();
        this.sdm.addObserver((Observer)((Object)this));
    }

    private JPanel createDumpNodesPane(INodeModel[] iNodeModelArray) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(NODE_INFO));
        this.ospfDumpNodesTA = new JTextArea();
        this.ospfDumpNodesTA.setEditable(false);
        this.ospfDumpNodesTA.setMargin(new Insets(5, 5, 5, 0));
        this.scrollPaneDNodes = new UScrollPane((Component)this.ospfDumpNodesTA);
        jPanel.add((Component)this.scrollPaneDNodes);
        CSHelpButtonPane cSHelpButtonPane = new CSHelpButtonPane(NetCSHelpConst.DiagMaintPane);
        cSHelpButtonPane.addLeft(new JLabel(SELECT_NODE));
        this.ospfDumpNodesCB = new JComboBox<INodeModel>(iNodeModelArray);
        this.ospfDumpNodesCB.setRenderer(new NMCRenderer());
        this.ospfDumpNodesCB.setEditable(false);
        this.ospfDumpNodesCB.addActionListener(this);
        cSHelpButtonPane.addLeft(this.ospfDumpNodesCB);
        this.ospfDNRetrieveB = new JButton(RETRIEVE);
        this.ospfDNRetrieveB.setEnabled(true);
        this.ospfDNRetrieveB.addActionListener(this);
        this.ospfDNRetrieveB.setToolTipText(RETRIEVE_TIP);
        cSHelpButtonPane.addLeft(this.ospfDNRetrieveB);
        this.ospfDNClearB = new JButton(CLEAR);
        this.ospfDNClearB.setEnabled(true);
        this.ospfDNClearB.addActionListener(this);
        this.ospfDNClearB.setToolTipText(CLEAR_TIP);
        cSHelpButtonPane.addLeft(this.ospfDNClearB);
        jPanel.add((Component)cSHelpButtonPane, "South");
        return jPanel;
    }

    private JPanel createLSDBPane(INodeModel[] iNodeModelArray) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(LSDB));
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 5));
        jPanel2.add(new JLabel(SELECT_NODE));
        this.ospfLSDBCB = new JComboBox<INodeModel>(iNodeModelArray);
        this.ospfLSDBCB.setRenderer(new NMCRenderer());
        this.ospfLSDBCB.setEditable(false);
        this.ospfLSDBCB.addActionListener(this);
        jPanel2.add(this.ospfLSDBCB);
        this.ospfLSDBB = new JButton(CLEAR);
        this.ospfLSDBB.setEnabled(true);
        this.ospfLSDBB.addActionListener(this);
        jPanel2.add((Component)this.ospfLSDBB, "East");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        this.ospfLSDBTA = new JTextArea(10, 35);
        this.ospfLSDBTA.setEditable(false);
        this.scrollPaneLSDB = new UScrollPane((Component)this.ospfLSDBTA);
        jPanel3.add((Component)this.scrollPaneLSDB);
        jPanel.add((Component)jPanel2, "North");
        jPanel.add(jPanel3);
        return jPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enteringPage() {
        try {
            this.setCursor(3);
            if (this.ospfDumpNodesCB == null) {
                this.init();
            }
        }
        finally {
            this.setCursor(0);
        }
    }

    public void leavingPage() {
    }

    protected void init() {
        if (db.on()) {
            db.println("<init>: start");
        }
        INodeModel[] iNodeModelArray = this.sdm.getKnownNodes();
        this.setLayout(new BorderLayout());
        this.add(this.createDumpNodesPane(iNodeModelArray), "Center");
        this.registerWithModel();
        if (db.on()) {
            db.println("<init>: finish");
        }
    }

    public void update(Observable observable, Object object) {
        if (db.on()) {
            db.println("Got an Update Message from " + observable + " arg: " + object);
        }
        if (observable instanceof ShellDebugManager) {
            this.requestRefresh(observable, this.getRefreshThread());
        }
    }

    private Runnable getRefreshThread() {
        return new Runnable(){

            public void run() {
                DiagMaintPane.this.refresh();
            }
        };
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object var2_2 = null;
        Object object = actionEvent.getSource();
        String string = "";
        if (object == this.ospfDNRetrieveB) {
            INodeModel iNodeModel = (INodeModel)this.ospfDumpNodesCB.getSelectedItem();
            string = this.sdm.shellDebugCommand(iNodeModel, 0);
            if (string.length() > 0) {
                this.ospfDumpNodesTA.setText(string);
                this.ospfDumpNodesTA.revalidate();
            }
        } else if (object == this.ospfDNClearB) {
            this.ospfDumpNodesTA.setText(null);
            this.ospfDumpNodesTA.revalidate();
        }
    }

    public void destroy() {
        super.destroy();
    }

    public void refresh() {
        ArrayList<INodeModel> arrayList;
        if (db.on()) {
            db.println("refresh: start");
        }
        if (this.ospfDumpNodesCB != null && !(arrayList = new ArrayList<INodeModel>(Arrays.asList(this.sdm.getKnownNodes()))).isEmpty()) {
            this.ospfDumpNodesCB.removeAllItems();
            Iterator<INodeModel> iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                INodeModel iNodeModel = iterator.next();
                this.ospfDumpNodesCB.addItem(iNodeModel);
            }
        }
        if (db.on()) {
            db.println("refresh: finish");
        }
    }

    public CSHelpID getHelpID() {
        return NetCSHelpConst.DiagMaintPane;
    }

    private class NMCRenderer
    extends JLabel
    implements ListCellRenderer {
        public NMCRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = object.toString();
            if (object instanceof INodeModel) {
                string = ((INodeModel)object).getName();
            }
            this.setText(string);
            Color color = new Color(205, 205, 255);
            this.setBackground(bl ? color : Color.white);
            this.setForeground(Color.black);
            return this;
        }
    }
}

