/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.ConnectionInRoll;
import cerent.cms.model.IModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOSConsoleDisabledException;
import cerent.cms.model.NetAdminState;
import cerent.cms.model.NetSecurityModel;
import cerent.cms.model.NetworkModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetRoll;
import cerent.cms.ncp.OchncCircuit;
import cerent.cms.ncp.RollManager;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.AddNodeDialog;
import cerent.cms.ui.CSHelpMenuItem;
import cerent.cms.ui.DetailedLogCollector;
import cerent.cms.ui.DuplicateItemException;
import cerent.cms.ui.ErrorReportButton;
import cerent.cms.ui.ExportHandler;
import cerent.cms.ui.HandlerUtils;
import cerent.cms.ui.IApplicationMenus;
import cerent.cms.ui.IUiToolkit;
import cerent.cms.ui.IosSlotSelDialog;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.NetworkDefaults;
import cerent.cms.ui.NetworkViewController;
import cerent.cms.ui.NoSuchItemException;
import cerent.cms.ui.Pane;
import cerent.cms.ui.PreferencesDialog;
import cerent.cms.ui.PrintHandler;
import cerent.cms.ui.UiToolkit;
import cerent.cms.ui.blsr.RingCreationDialog;
import cerent.cms.ui.circuits.BulkRollDialog;
import cerent.cms.ui.circuits.CircuitMergeDialog;
import cerent.cms.ui.circuits.CircuitRepairDialog;
import cerent.cms.ui.circuits.CircuitStateDialog;
import cerent.cms.ui.circuits.CircuitsPane;
import cerent.cms.ui.circuits.CircuitsTabbedView;
import cerent.cms.ui.circuits.PathSelectorDialog;
import cerent.cms.ui.circuits.RollsPane;
import cerent.cms.ui.helper.ViewHelper;
import cerent.cms.ui.ohcircuits.IpTunnelRepairDialog;
import cerent.cms.ui.tl1.TL1ClientPanel;
import cerent.cms.ui.vlan.VlanSetDialog;
import cerent.cms.vlan.VlanSetManager;
import cerent.util.BusEvent;
import cerent.util.CoreSoftwareUpgradeInstaller;
import cerent.util.DebugConsole;
import cerent.util.DebugWindow;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.EventBus;
import cerent.util.EventMaskUtil;
import cerent.util.HelpMgr;
import cerent.util.NEMC;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.gui.ActionOrganizer;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.IOSTelnetFrame;
import cerent.util.gui.StatusBar;
import cerent.util.gui.UFrame;
import cerent.util.gui.UToolBar;
import cerent.util.gui.WindowHelper;
import cerent.util.job.IJobControl;
import cerent.util.job.IJobListener;
import cerent.util.job.JobController;
import cerent.util.job.JobControllerFactory;
import cerent.util.job.JobGroup;
import cerent.util.job.JobStatus;
import cerent.util.stats.StatsWindow;
import cerent.version.NetworkVersionMonitor;
import com.cisco.ctc.CtcApplication;
import com.cisco.ctc.ui.AboutDialog;
import com.cisco.ctc.ui.sot.SoTl1Frame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MenuListener;
import lib.LicenseManager;

public class MainPanel
extends UFrame
implements Observer,
ActionListener,
MenuKeyListener,
IApplicationMenus {
    private static final String PROP_GEN_PATH = "ctc";
    private static final String PROP_WIN = "ctc.window";
    private static final String PROP_SB = "statusbar";
    private static final String PROP_TB = "toolbar";
    private static final String APPLICATION_ICON = "/images/icons/CTC_icon.gif";
    private static final String LOCK_ICON = "/images/icons/securitylock16.gif";
    private static final String EXIT_ICON = "/images/icons/Exit16.gif";
    private static final String EXPORT_ICON = "/images/icons/export16.gif";
    private static final String PRINT_ICON = "/images/icons/print16.gif";
    private static final String TELNET_ICON = "/images/icons/telnet16.gif";
    private static final String IOS_ICON = "/images/icons/IOS16.gif";
    private static final String PREFERENCES_ICON = "/images/icons/preferences16.gif";
    private static final String ADDNODE_ICON = "/images/icons/16x16-addnode.gif";
    private static final String DELNODE_ICON = "/images/icons/16x16-delnode.gif";
    private static Preferences preferences = Preferences.instance();
    private CtcApplication parent = null;
    private NetworkViewController nvc = null;
    private static final SDebug db = new SDebug("MainPanel");
    private Container contentPane;
    private Container innerContentPane;
    private UToolBar toolBar;
    private TriggerMenuBar menuBar;
    private JMenu helpMenu;
    private JPanel thePanel;
    private StatusBar statusBar = StatusBar.instance();
    private UiToolkit uiToolkit = UiToolkit.instance();
    private AbstractButton prefsIconButton;
    private AbstractButton prefsMenuButton;
    private boolean checkNeeded = false;
    private INodeModel cmsHost;
    private TDMTerminology terms;
    private IJobControl upgradeCtcJob = null;
    private static String BLSR_TERM;
    private static String UPSR_TERM;
    private static final String ACTION_LOCK = "Lock CTC";
    private static final String ACTION_PRINT = "Print...";
    private static final String ACTION_EXPORT = "Export...";
    private static final String ACTION_EXIT = "Exit";
    private static final String ACTION_UPGRADE = "Update CTC";
    private static final String ACTION_CANCEL = "Cancel CTC Update";
    private static final String ACTION_PREF = "Preferences...";
    private static final String ACTION_SOTL1 = "Manage TL1 Tunnels...";
    private static final String ACTION_VLANS = "Manage VLANs...";
    private static final String ACTION_REPAIR_CKT = "Repair Circuits...";
    private static final String ACTION_RECONFIGURE_CKT = "Reconfigure Circuits...";
    private static final String ACTION_IP_TUNNEL_REPAIR = "Repair IP Tunnels...";
    private static final String ACTION_TL1 = "Open TL1 Connection...";
    private static final String ACTION_PATHSEL = "Set Path Selector Attributes...";
    private static final String ACTION_SET_CIRCUIT_STATE = "Set Circuit State...";
    private static final String ACTION_ROLL_CIRCUIT = "Roll Circuit...";
    private static final String ACTION_BULK_ROLL = "Bulk Roll...";
    private static final String ACTION_IOS = "Open IOS Connection...";
    private static final String ACTION_DELETEROLLS = "Delete Rolls...";
    private static final String ACTION_UPGRADE_OCHNC = "Upgrade OCHNC";
    private static String ACTION_UPSR2BLSR;
    private static String ACTION_UNPROTECTED2UPSR;
    private static final String ACTION_CONTENTS_AND_INDEX = "Contents and Index";
    private static final String ACTION_ABOUT = "About CTC...";
    private static final String ACTION_ADD = "Add Node...";
    private static final String ACTION_DEL = "Delete Selected Node";
    private static final String CIRCUITS_MENU = "Circuits";
    private static final String OH_CIRCUITS_MENU = "Overhead Circuits";
    private static final String TOPO_UPGRADE_MENU = "Topology Upgrade";
    private static int EDIT_PATH_SELECTORS;
    private static int EDIT_CIRCUIT_STATES;
    private int modifiers;
    private HashSet protectedThreads = new HashSet();
    private ActionOrganizer myMenus = null;
    private static final int STATUSBAR = 0;
    private static final int TOOLBAR = 1;

    public MainPanel(CtcApplication ctcApplication) {
        super(null, "Cisco Transport Controller", true, APPLICATION_ICON);
        LicenseManager licenseManager = new LicenseManager();
        licenseManager.register();
        this.contentPane = this.getContentPane();
        this.contentPane.setLayout(new BorderLayout());
        this.innerContentPane = new JPanel();
        this.innerContentPane.setLayout(new BorderLayout());
        this.contentPane.add((Component)this.innerContentPane, "Center");
        this.setDefaultCloseOperation(0);
        CerentDialog.init();
        ViewHelper.init((IUiToolkit)UiToolkit.instance());
        this.parent = ctcApplication;
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                if (MainPanel.this.toolBar != null) {
                    MainPanel.this.toolBar.revalidate();
                }
            }
        });
        EventBus.instance().addObserver((Observer)this, (Object)"ACTIVE_OBJECT");
    }

    protected boolean updateProvision() {
        return this.allowProvision();
    }

    private boolean allowProvision() {
        boolean bl = false;
        try {
            INodeModel iNodeModel = NetworkModel.instance().getCmsHostModel();
            if (iNodeModel != null) {
                bl = AbstractPane.isUserAuthorized((IModel)iNodeModel, SecurityLevel.PROVISIONING);
                if (db.on()) {
                    db.println("user authorized on " + iNodeModel.getName() + " =" + bl);
                }
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        return bl;
    }

    public void initialize() {
        this.nvc = new NetworkViewController(this.uiToolkit);
        String string = preferences.getProperty(PROP_GEN_PATH, PROP_SB, "true");
        String string2 = preferences.getProperty(PROP_GEN_PATH, PROP_TB, "true");
        boolean bl = Boolean.valueOf(string);
        boolean bl2 = Boolean.valueOf(string2);
        this.cmsHost = NetworkModel.instance().getCmsHostModel();
        this.terms = this.cmsHost.getTDMTerminology();
        BLSR_TERM = this.terms.getRingTerms(1);
        UPSR_TERM = this.terms.getRingTerms(0);
        ACTION_UPSR2BLSR = "Convert " + UPSR_TERM + " to " + BLSR_TERM + "...";
        ACTION_UNPROTECTED2UPSR = "Convert Unprotected to " + UPSR_TERM + "...";
        this.myMenus = new ActionOrganizer(this);
        this.menuBar = this.createMenuBar(bl, bl2);
        this.setJMenuBar(this.menuBar);
        this.toolBar = this.createToolBar();
        this.toolBar.setName("CTC ToolBar");
        this.showStatusBar(bl);
        this.showToolBar(bl2);
        this.updateProvision();
        NetSecurityModel.instance().addObserver(this);
        this.nvc.addObserver(this);
        this.validate();
    }

    private void awtSetView(JPanel jPanel) {
        if (jPanel != null && this.thePanel != jPanel) {
            if (this.thePanel != null) {
                this.innerContentPane.remove(this.thePanel);
            }
            this.innerContentPane.add((Component)jPanel, "Center");
            this.validate();
            jPanel.revalidate();
            jPanel.repaint();
            this.thePanel = jPanel;
        }
        if (this.isVisible()) {
            this.show();
            CerentDialog.toFront();
        }
    }

    private void setView(JPanel jPanel) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.awtSetView(jPanel);
        } else {
            SetViewJob setViewJob = new SetViewJob(jPanel);
            SwingUtilities.invokeLater(setViewJob);
        }
    }

    public void update(Observable observable, Object object) {
        BusEvent busEvent;
        if (db.on()) {
            db.println("received notify msg from " + observable);
        }
        if (observable instanceof NetSecurityModel) {
            this.checkNeeded = true;
        } else if (observable instanceof NetworkViewController) {
            if (db.on()) {
                db.println("installing new JPanel");
            }
            this.setView((JPanel)object);
        } else if (object instanceof BusEvent && (busEvent = (BusEvent)object).getSource() == "ACTIVE_OBJECT") {
            if (busEvent.getEvent() != null) {
                this.myMenus.setEnabled(ACTION_DEL, true);
            } else {
                this.myMenus.setEnabled(ACTION_DEL, false);
            }
        }
    }

    public JMenuBar getJMenuBar() {
        return this.menuBar;
    }

    public JToolBar getJToolBar() {
        return this.toolBar;
    }

    public void showToolBar(boolean bl) {
        SetViewJob setViewJob = new SetViewJob(1, bl);
        SwingUtilities.invokeLater(setViewJob);
        preferences.setProperty(PROP_GEN_PATH, PROP_TB, Boolean.valueOf(bl).toString());
    }

    public void showStatusBar(boolean bl) {
        SetViewJob setViewJob = new SetViewJob(0, bl);
        SwingUtilities.invokeLater(setViewJob);
        preferences.setProperty(PROP_GEN_PATH, PROP_SB, Boolean.valueOf(bl).toString());
    }

    public void setStatusBar(String string) {
        this.statusBar.setText(string);
    }

    private UToolBar createToolBar() {
        UToolBar uToolBar = new UToolBar();
        uToolBar.setFloatable(false);
        this.myMenus.addToolbar((JToolBar)uToolBar, ADDNODE_ICON, ACTION_ADD);
        this.myMenus.addToolbar((JToolBar)uToolBar, DELNODE_ICON, ACTION_DEL);
        uToolBar.addSeparator();
        this.myMenus.addToolbar((JToolBar)uToolBar, LOCK_ICON, ACTION_LOCK);
        uToolBar.addSeparator();
        this.myMenus.addToolbar((JToolBar)uToolBar, PRINT_ICON, ACTION_PRINT);
        this.myMenus.addToolbar((JToolBar)uToolBar, EXPORT_ICON, ACTION_EXPORT);
        uToolBar.addSeparator();
        this.prefsIconButton = this.myMenus.addToolbar((JToolBar)uToolBar, PREFERENCES_ICON, ACTION_PREF);
        uToolBar.addSeparator();
        this.nvc.initToolbar((JToolBar)uToolBar);
        uToolBar.addSeparator();
        this.myMenus.addToolbar((JToolBar)uToolBar, TELNET_ICON, ACTION_TL1);
        this.myMenus.setEnabled(ACTION_TL1, true);
        uToolBar.addSeparator();
        this.myMenus.addToolbar((JToolBar)uToolBar, IOS_ICON, ACTION_IOS);
        this.myMenus.setEnabled(ACTION_IOS, this.allowProvision());
        uToolBar.add((Component)new ErrorReportButton(), UToolBar.RIGHT_SYSTEM_AREA);
        return uToolBar;
    }

    private TriggerMenuBar createMenuBar(boolean bl, boolean bl2) {
        TriggerMenuBar triggerMenuBar = new TriggerMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        this.myMenus.addMenuItem((JComponent)triggerMenuBar, jMenu, null, "File");
        this.myMenus.addMenuItem((JComponent)jMenu, ADDNODE_ICON, ACTION_ADD, 65);
        this.myMenus.addMenuItem((JComponent)jMenu, DELNODE_ICON, ACTION_DEL, 68);
        jMenu.addSeparator();
        this.myMenus.addMenuItem((JComponent)jMenu, LOCK_ICON, ACTION_LOCK, 76);
        jMenu.addSeparator();
        this.myMenus.addMenuItem((JComponent)jMenu, PRINT_ICON, ACTION_PRINT, 80);
        this.myMenus.addMenuItem((JComponent)jMenu, EXPORT_ICON, ACTION_EXPORT, 79);
        jMenu.addSeparator();
        this.myMenus.addMenuItem((JComponent)jMenu, EXIT_ICON, ACTION_EXIT, 81);
        jMenu.addMenuListener(new MenuListener(){

            public void menuSelected(MenuEvent menuEvent) {
                JTable jTable = HandlerUtils.getDisplayedTable(MainPanel.this.nvc);
                String string = HandlerUtils.getDisplayedHtmlReport(MainPanel.this.nvc);
                MainPanel.this.myMenus.getMenuItem(MainPanel.ACTION_EXPORT).setEnabled(jTable != null || string != null);
            }

            public void menuCanceled(MenuEvent menuEvent) {
            }

            public void menuDeselected(MenuEvent menuEvent) {
            }
        });
        JMenu jMenu2 = new JMenu("Edit");
        jMenu2.setMnemonic(69);
        this.myMenus.addMenuItem((JComponent)triggerMenuBar, jMenu2, null, "Edit");
        this.prefsMenuButton = this.myMenus.addMenuItem((JComponent)jMenu2, PREFERENCES_ICON, ACTION_PREF, 82);
        JMenu jMenu3 = this.nvc.createViewsMenu(bl, bl2);
        this.myMenus.addMenuItem((JComponent)triggerMenuBar, jMenu3, null, "View");
        JMenu jMenu4 = new JMenu("Tools");
        jMenu4.setMnemonic(84);
        JMenu jMenu5 = new JMenu(CIRCUITS_MENU);
        jMenu5.setMnemonic(67);
        JMenu jMenu6 = new JMenu(OH_CIRCUITS_MENU);
        jMenu6.setMnemonic(79);
        JMenu jMenu7 = new JMenu(TOPO_UPGRADE_MENU);
        jMenu7.setMnemonic(84);
        jMenu4.add(jMenu5);
        jMenu4.add(jMenu6);
        jMenu4.add(jMenu7);
        jMenu4.addMenuListener(new MenuListener(){

            public void menuSelected(MenuEvent menuEvent) {
                CircuitsPane circuitsPane = MainPanel.this.getCircuitPane();
                boolean bl = circuitsPane != null;
                boolean bl2 = bl && circuitsPane.isCircuitSelected();
                boolean bl3 = MainPanel.this.allowProvision();
                MainPanel.this.myMenus.setEnabled(MainPanel.ACTION_VLANS, bl3 && VlanSetManager.instance().isVlanEnabledNetwork());
                MainPanel.this.myMenus.setEnabled(MainPanel.ACTION_REPAIR_CKT, bl3 && !RollManager.instance().hasRollsInNetwork());
                MainPanel.this.myMenus.setEnabled(MainPanel.ACTION_RECONFIGURE_CKT, bl3 && bl && bl2);
                MainPanel.this.myMenus.setEnabled(MainPanel.ACTION_PATHSEL, bl3 && bl);
                MainPanel.this.myMenus.setEnabled(MainPanel.ACTION_SET_CIRCUIT_STATE, bl3 && bl);
                MainPanel.this.myMenus.setEnabled(MainPanel.ACTION_ROLL_CIRCUIT, bl3 && bl && RollManager.instance().isRollEnabledNetwork());
                MainPanel.this.myMenus.setEnabled(MainPanel.ACTION_DELETEROLLS, bl3 && bl && RollManager.instance().isRollEnabledNetwork());
                MainPanel.this.myMenus.setEnabled(MainPanel.ACTION_UPGRADE_OCHNC, bl3 && bl2 && MainPanel.this.isSelectedCircuitOchncUpgradeable(circuitsPane));
                MainPanel.this.myMenus.setEnabled(ACTION_UNPROTECTED2UPSR, bl3 && bl2 && MainPanel.this.isSelectedCircuitUpgradeable(circuitsPane));
                MainPanel.this.myMenus.setEnabled(ACTION_UPSR2BLSR, bl3);
                MainPanel.this.myMenus.setEnabled(MainPanel.ACTION_IOS, bl3);
                MainPanel.this.myMenus.setEnabled(MainPanel.ACTION_IP_TUNNEL_REPAIR, bl3);
                if (NetworkVersionMonitor.instance().isVersionMonitoringSupported()) {
                    boolean bl4 = CoreSoftwareUpgradeInstaller.instance().isUpgradeInProgress();
                    if (bl4) {
                        AbstractButton abstractButton = MainPanel.this.myMenus.getMenuItem(MainPanel.ACTION_CANCEL);
                        if (abstractButton == null) {
                            abstractButton = MainPanel.this.myMenus.getMenuItem(MainPanel.ACTION_UPGRADE);
                        }
                        abstractButton.setText(MainPanel.ACTION_CANCEL);
                        abstractButton.setActionCommand(MainPanel.ACTION_CANCEL);
                        abstractButton.setMnemonic(85);
                        abstractButton.setEnabled(true);
                    } else {
                        boolean bl5 = NetworkVersionMonitor.instance().isLaterVersionAvailable() && !bl4;
                        AbstractButton abstractButton = MainPanel.this.myMenus.getMenuItem(MainPanel.ACTION_UPGRADE);
                        if (abstractButton == null) {
                            abstractButton = MainPanel.this.myMenus.getMenuItem(MainPanel.ACTION_CANCEL);
                        }
                        abstractButton.setText(MainPanel.ACTION_UPGRADE);
                        abstractButton.setActionCommand(MainPanel.ACTION_UPGRADE);
                        abstractButton.setMnemonic(85);
                        abstractButton.setEnabled(bl5);
                    }
                }
            }

            public void menuCanceled(MenuEvent menuEvent) {
            }

            public void menuDeselected(MenuEvent menuEvent) {
            }
        });
        this.myMenus.addMenuItem((JComponent)triggerMenuBar, jMenu4, null, "Tools");
        this.myMenus.addMenuItem((JComponent)jMenu4, null, ACTION_VLANS, 86);
        this.myMenus.addMenuItem((JComponent)jMenu4, null, ACTION_SOTL1, 84);
        this.myMenus.addMenuItem((JComponent)jMenu5, null, ACTION_REPAIR_CKT, 82);
        this.myMenus.addMenuItem((JComponent)jMenu5, null, ACTION_RECONFIGURE_CKT, 67);
        this.myMenus.addMenuItem((JComponent)jMenu4, TELNET_ICON, ACTION_TL1, 76);
        this.myMenus.addMenuItem((JComponent)jMenu4, IOS_ICON, ACTION_IOS, 73);
        if (NetworkVersionMonitor.instance().isVersionMonitoringSupported()) {
            jMenu4.addSeparator();
            this.myMenus.addMenuItem((JComponent)jMenu4, null, ACTION_UPGRADE, 85);
        }
        this.myMenus.setEnabled(ACTION_TL1, true);
        this.myMenus.addMenuItem((JComponent)jMenu5, null, ACTION_PATHSEL, 80);
        this.myMenus.addMenuItem((JComponent)jMenu5, null, ACTION_SET_CIRCUIT_STATE, 83);
        this.myMenus.addMenuItem((JComponent)jMenu5, null, ACTION_ROLL_CIRCUIT, 79);
        this.myMenus.addMenuItem((JComponent)jMenu5, null, ACTION_DELETEROLLS, 68);
        this.myMenus.addMenuItem((JComponent)jMenu5, null, ACTION_UPGRADE_OCHNC, 85);
        this.myMenus.addMenuItem((JComponent)jMenu6, null, ACTION_IP_TUNNEL_REPAIR, 82);
        this.myMenus.addMenuItem((JComponent)jMenu7, null, ACTION_UPSR2BLSR, 85);
        this.myMenus.addMenuItem((JComponent)jMenu7, null, ACTION_UNPROTECTED2UPSR, 80);
        this.helpMenu = new JMenu("Help");
        this.helpMenu.setMnemonic(72);
        this.helpMenu.addMenuListener(new MenuListener(){

            public void menuSelected(MenuEvent menuEvent) {
                MainPanel.this.addHelpRelatedMenuItems(MainPanel.this.helpMenu);
            }

            public void menuCanceled(MenuEvent menuEvent) {
            }

            public void menuDeselected(MenuEvent menuEvent) {
            }
        });
        this.myMenus.addMenuItem((JComponent)triggerMenuBar, this.helpMenu, null, "Help");
        this.addHelpRelatedMenuItems(this.helpMenu);
        this.helpMenu.addSeparator();
        this.myMenus.addMenuItem((JComponent)this.helpMenu, null, ACTION_ABOUT, 65);
        ((JMenuItem)this.myMenus.getAbstractButton(ACTION_ABOUT)).addMenuKeyListener(this);
        return triggerMenuBar;
    }

    private void addHelpRelatedMenuItems(JMenu jMenu) {
        JMenuItem jMenuItem;
        if (jMenu == null) {
            return;
        }
        int n = jMenu.getItemCount();
        for (int i = 0; i < n; ++i) {
            try {
                jMenuItem = jMenu.getItem(i);
                if (jMenuItem == null || !jMenuItem.getActionCommand().equals(ACTION_CONTENTS_AND_INDEX) && !jMenuItem.getActionCommand().equals("User Manuals")) continue;
                jMenu.remove(i);
                --i;
                --n;
                continue;
            }
            catch (Exception exception) {
                if (!db.on()) continue;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        CSHelpMenuItem cSHelpMenuItem = new CSHelpMenuItem(ACTION_CONTENTS_AND_INDEX, NetCSHelpConst.Introduction);
        cSHelpMenuItem.setMnemonic(67);
        jMenu.insert(cSHelpMenuItem, 0);
        jMenuItem = HelpMgr.getHelpMenu();
        jMenu.insert(jMenuItem, 1);
    }

    private void reconfigureSelectedCircuits() {
        String string;
        CircuitsPane circuitsPane = this.getCircuitPane();
        INetCircuit[] iNetCircuitArray = circuitsPane.getSelectedCircuits("Reconfigure", false);
        String string2 = "CTC will reconfigure " + iNetCircuitArray.length + " selected circuit" + (iNetCircuitArray.length > 1 ? "s" : "") + " into one " + "or more circuits." + "\nTraffic will not be affected." + "\n\nOK to continue?";
        if (CerentDialog.yesNoDialog((Component)this, (String)string2, (String)(string = "Reconfigure Circuits"))) {
            new CircuitMergeDialog((Component)this, Arrays.asList(iNetCircuitArray), 2);
        }
    }

    private void deleteRolls() {
        Pane pane = this.getNetworkViewController().getCurrentTabbedView().getCurrentPane();
        RollsPane rollsPane = null;
        if (pane instanceof CircuitsTabbedView) {
            pane = ((CircuitsTabbedView)pane).getSubTabs().getCurrentPane();
        }
        if (pane instanceof RollsPane) {
            rollsPane = (RollsPane)pane;
        }
        if (rollsPane == null) {
            ErrorMsg.displayError((Component)this, (EID)NEMC.EID_NO_ROLLS_SELECTED_PARAM_1, (Object)"");
            return;
        }
        NetRoll[] netRollArray = rollsPane.getSelectedRolls("All");
        if (netRollArray.length > 0 && CerentDialog.yesNoDialog((Component)this, (String)ErrorMsg.getString((EID)NEMC.WID_DELETE_ROLL), (String)"Delete rolls")) {
            for (int i = 0; i < netRollArray.length; ++i) {
                try {
                    netRollArray[i].rollDelete();
                    continue;
                }
                catch (ConnectionInRoll connectionInRoll) {
                    SDebug.printStackTrace((Throwable)connectionInRoll);
                    ErrorMsg.displayError((Component)this, (EID)NEMC.EID_ROLLS_CANT_DELETE);
                    continue;
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                    ErrorMsg.displayError((Component)this, (EID)NEMC.EID_ERROR_DELETING_ROLL_PARAM_1, (Object)exception.getMessage());
                }
            }
        }
    }

    private void upgradeCtc() {
        JobController jobController = JobControllerFactory.createJC((int)1);
        this.upgradeCtcJob = CoreSoftwareUpgradeInstaller.instance().createCoreSoftwareUpgradeJob();
        jobController.submitJob(new JobGroup(this.upgradeCtcJob, (IJobListener)new UpgradeCtcJobListener(), (Object)jobController));
    }

    private void cancelCtcUpgrade() {
        this.upgradeCtcJob.abortJob();
        this.upgradeCtcJob = null;
    }

    private void finishJob(JobStatus jobStatus, JobController jobController) {
        if (jobStatus.value() == 3) {
            CerentDialog.infoDialog((Component)this, (String)"CTC software upgrade cancelled.", (String)"Cancelled");
        } else if (jobStatus.value() == 2) {
            Exception exception = (Exception)jobStatus.getResult();
            db.println("Software Upgrade JobStatus.FAILED");
            if (db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
        } else if (jobStatus.value() == 4 && db.on()) {
            db.println("JobStatus.COMPLETE Software Upgrade");
        }
        if (jobController != null && jobController.isIdle()) {
            JobControllerFactory.disposeJC((JobController)jobController);
        }
    }

    private void startUpsrToBlsrConversionWizard() {
        RingCreationDialog ringCreationDialog = RingCreationDialog.instance(this, this.cmsHost, 1, this.terms);
        ringCreationDialog.show();
        if (MainPanel.db.on) {
            db.println("<<< startUpsrToBlsrConversionWizard()");
        }
    }

    private boolean isSelectedCircuitUpgradeable(CircuitsPane circuitsPane) {
        boolean bl = false;
        INetCircuit[] iNetCircuitArray = circuitsPane.getSelectedCircuits("TopoUpgrade", false);
        if (iNetCircuitArray.length == 1 && iNetCircuitArray[0] instanceof NetCcatCircuit) {
            bl = !((NetCcatCircuit)iNetCircuitArray[0]).getCircuitTypeObj().isLAPCircuitType();
        }
        return bl;
    }

    private boolean isSelectedCircuitOchncUpgradeable(CircuitsPane circuitsPane) {
        boolean bl = false;
        INetCircuit[] iNetCircuitArray = circuitsPane.getSelectedCircuits("TopoUpgrade", false);
        if (iNetCircuitArray.length == 1) {
            bl = iNetCircuitArray[0].getCircuitTypeObj().isOchncType() && !iNetCircuitArray[0].hasNullCircuitId();
        }
        return bl;
    }

    private void startUnprotectedToUPSRConversion(boolean bl) {
        CircuitsPane circuitsPane = this.getCircuitPane();
        if (circuitsPane == null) {
            return;
        }
        INetCircuit[] iNetCircuitArray = circuitsPane.getSelectedCircuits("TopoUpgrade", false);
        if (iNetCircuitArray.length == 0) {
            return;
        }
        if (iNetCircuitArray.length > 1) {
            ErrorMsg.displayError((Component)this, (EID)NEMC.EID_ONE_CIRCUIT_A_TIME);
        } else {
            circuitsPane.upgradeCircuit(iNetCircuitArray[0], bl);
        }
    }

    private void startUpgradeOchnc(boolean bl) {
        CircuitsPane circuitsPane = this.getCircuitPane();
        if (circuitsPane == null) {
            return;
        }
        INetCircuit[] iNetCircuitArray = circuitsPane.getSelectedCircuits("TopoUpgrade", false);
        if (iNetCircuitArray.length == 0) {
            return;
        }
        if (iNetCircuitArray.length > 1) {
            ErrorMsg.displayError((Component)this, (EID)NEMC.EID_ONE_CIRCUIT_A_TIME);
        } else {
            OchncCircuit ochncCircuit = (OchncCircuit)iNetCircuitArray[0];
            if (!ochncCircuit.isBidirectional()) {
                ErrorMsg.displayError((Component)this, (EID)NEMC.EID_ERROR_UPGRADE_OCHNC_BIDI);
            } else {
                circuitsPane.upgradeOchncCircuit(ochncCircuit, bl);
            }
        }
    }

    private void createTL1Panel() {
        String string = this.getNetworkViewController().getSelectedNodeName();
        Object[] objectArray = this.getNetworkViewController().getNodeNames();
        if (objectArray.length <= 0) {
            CerentDialog.infoDialog((Component)this.uiToolkit.getApplicationFrame(), (String)"There are no nodes which support TL1", (String)"Select Node");
            return;
        }
        Object object = CerentDialog.inputDialog((Component)this.uiToolkit.getApplicationFrame(), (String)"Select Node for TL1 session", (String)"Select Node", (Object[])objectArray, (Object)string);
        if (object == null) {
            return;
        }
        INodeModel iNodeModel = this.getNetworkViewController().getNodeModel((String)object);
        if (iNodeModel != null) {
            String string2 = iNodeModel.getName();
            if (iNodeModel.isInited() && iNodeModel.getConnectionState()) {
                TL1ClientPanel tL1ClientPanel = new TL1ClientPanel(iNodeModel.getHostName(), iNodeModel.getTl1TcpPort(), iNodeModel.doesTl1UseSsh());
                UFrame uFrame = new UFrame(tL1ClientPanel, string2 + " - TL1", false){

                    protected Rectangle getDefaultBounds() {
                        return new Rectangle(-1, -1, 750, 575);
                    }
                };
                uFrame.addWindowListener(tL1ClientPanel);
                uFrame.display();
                try {
                    tL1ClientPanel.connect();
                }
                catch (IOException iOException) {
                    if (db.on()) {
                        db.println("createTL1Panel: tcp.connect() raised " + iOException.toString());
                    }
                }
            } else {
                ErrorMsg.displayWarning((Component)this, (EID)NEMC.WID_NODE_NOT_INITIALIZED_PARAM_1, string2);
            }
        }
    }

    private void openIOSSession() {
        INodeModel iNodeModel = this.getNetworkViewController().getNodeModel(this.getNetworkViewController().getSelectedNodeName());
        IosSlotSelDialog iosSlotSelDialog = new IosSlotSelDialog(this, iNodeModel);
        if (iosSlotSelDialog.isOk()) {
            IModuleModel iModuleModel = iosSlotSelDialog.getModuleModel();
            if (iModuleModel != null) {
                try {
                    IOSTelnetFrame iOSTelnetFrame = IOSTelnetFrame.instance((IModuleModel)iModuleModel);
                    iOSTelnetFrame.pack();
                    iOSTelnetFrame.setVisible(true);
                }
                catch (IOSConsoleDisabledException iOSConsoleDisabledException) {
                    ErrorMsg.displayError((Component)this, (EID)NEMC.EID_IOS_CONSOLE_DISABLED, (Object)new Integer(iModuleModel.getSlot()));
                }
            } else {
                ErrorMsg.displayError((Component)this, (EID)NEMC.EID_NO_IOS_SLOT_SELECTED);
            }
        }
    }

    public void dispose() {
        if (db.on()) {
            db.println("destroying network view");
        }
        NetSecurityModel.instance().deleteObserver(this);
        this.nvc.deleteObserver(this);
        this.nvc.destroy();
        if (db.on()) {
            db.println("saving window positions");
        }
        WindowHelper.persistBounds((Component)this, (String)PROP_WIN);
        DetailedLogCollector.instance().dispose();
        EventBus.instance().deleteObserver((Observer)this, (Object)"ACTIVE_OBJECT");
        super.dispose();
    }

    protected Rectangle getDefaultBounds() {
        return WindowHelper.getPersistedBounds((String)PROP_WIN, (Rectangle)new Rectangle(-1, -1, 900, 700));
    }

    public synchronized void addProtectedThread() {
        this.protectedThreads.add(Thread.currentThread());
    }

    public synchronized void removeProtectedThread() {
        this.protectedThreads.remove(Thread.currentThread());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        boolean bl = EventMaskUtil.isCtrlShiftPressed(actionEvent);
        if (db.on()) {
            db.println("actionPerformed, cs_pressed=" + bl);
        }
        if ((string = actionEvent.getActionCommand()).equals(ACTION_ABOUT)) {
            if (this.modifiers == 3) {
                DebugWindow.instance().display();
            } else if (this.modifiers == 1) {
                StatsWindow.instance().display();
            } else if (this.modifiers == 2 && !this.uiToolkit.isSysOutBlocking()) {
                DebugConsole.startInstance();
            } else {
                AboutDialog.instance(this, "About CTC").show();
            }
            this.modifiers = 0;
        } else if (string.equals(ACTION_EXIT)) {
            try {
                this.parent.exitCtc(true);
            }
            catch (Exception exception) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        } else if (string.equals(ACTION_LOCK)) {
            this.parent.lockCtc();
        } else if (string.equals(ACTION_UPGRADE)) {
            this.upgradeCtc();
        } else if (string.equals(ACTION_CANCEL)) {
            this.cancelCtcUpgrade();
        } else if (string.equals(ACTION_PREF)) {
            new PreferencesDialog(this);
        } else if (string.equals(ACTION_TL1)) {
            this.createTL1Panel();
        } else if (string.equals(ACTION_IOS)) {
            this.openIOSSession();
        } else if (string.equals(ACTION_PRINT)) {
            PrintHandler printHandler = new PrintHandler(this.nvc);
            printHandler.print();
        } else if (string.equals(ACTION_EXPORT)) {
            ExportHandler exportHandler = new ExportHandler(this.nvc);
            exportHandler.export();
        } else if (string.equals(ACTION_VLANS)) {
            VlanSetDialog.instance(this).show();
        } else if (string.equals(ACTION_REPAIR_CKT)) {
            if (!this.parent.checkCktMgtMode()) {
                return;
            }
            new CircuitRepairDialog(this).show();
        } else if (string.equals(ACTION_RECONFIGURE_CKT)) {
            this.reconfigureSelectedCircuits();
        } else if (string.equals(ACTION_IP_TUNNEL_REPAIR)) {
            new IpTunnelRepairDialog(this).show();
        } else if (string.equals(ACTION_VLANS)) {
            VlanSetDialog.instance(this).show();
        } else if (string.equals(ACTION_SOTL1)) {
            SoTl1Frame.instance(this).setVisible(true);
        } else if (string.equals(ACTION_PATHSEL)) {
            if (!this.parent.checkCktMgtMode()) {
                return;
            }
            this.doSetPathSelectorAttrs();
        } else if (string.equals(ACTION_SET_CIRCUIT_STATE)) {
            if (!this.parent.checkCktMgtMode()) {
                return;
            }
            this.doSetCircuitState();
        } else if (string.equals(ACTION_ROLL_CIRCUIT)) {
            if (!this.parent.checkCktMgtMode()) {
                return;
            }
            this.doRollCircuit(bl);
        } else if (string.equals(ACTION_BULK_ROLL)) {
            BulkRollDialog.instance(this).show();
        } else if (string.equals(ACTION_ADD)) {
            AddNodeDialog.instance(this).show();
        } else if (string.equals(ACTION_DEL)) {
            this.nvc.getNetworkMap().deleteSelectedNetElement();
        } else if (string.equals(ACTION_DELETEROLLS)) {
            this.deleteRolls();
        } else if (string.equals(ACTION_UPGRADE_OCHNC)) {
            this.startUpgradeOchnc(bl);
        } else if (string.equals(ACTION_UPSR2BLSR)) {
            this.startUpsrToBlsrConversionWizard();
        } else if (string.equals(ACTION_UNPROTECTED2UPSR)) {
            this.startUnprotectedToUPSRConversion(bl);
        }
    }

    private void doSetPathSelectorAttrs() {
        INetCircuit[] iNetCircuitArray = this.getCircuitsForEdit(EDIT_PATH_SELECTORS);
        if (iNetCircuitArray.length > 0) {
            PathSelectorDialog.instance(this, iNetCircuitArray).show();
        }
    }

    private void doSetCircuitState() {
        INetCircuit[] iNetCircuitArray = this.getCircuitsForEdit(EDIT_CIRCUIT_STATES);
        if (iNetCircuitArray.length > 0) {
            new CircuitStateDialog((Frame)this, iNetCircuitArray);
        }
    }

    private void doRollCircuit(boolean bl) {
        CircuitsPane circuitsPane = this.getCircuitPane();
        if (circuitsPane == null) {
            return;
        }
        INetCircuit[] iNetCircuitArray = circuitsPane.getSelectedCircuits("Roll", false);
        if (iNetCircuitArray.length > 0) {
            circuitsPane.rollSelectedCircuits(iNetCircuitArray, bl);
        }
    }

    private CircuitsPane getCircuitPane() {
        CircuitsPane circuitsPane = null;
        try {
            Pane pane = this.getNetworkViewController().getCurrentTabbedView().getCurrentPane();
            circuitsPane = pane instanceof CircuitsTabbedView ? ((CircuitsTabbedView)pane).getCircuitsPane() : (CircuitsPane)pane;
        }
        catch (Exception exception) {
            if (MainPanel.db.on) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return null;
        }
        return circuitsPane;
    }

    private INetCircuit[] getCircuitsForEdit(int n) {
        String string;
        String string2;
        int[] nArray;
        CircuitsPane circuitsPane = this.getCircuitPane();
        if (circuitsPane == null) {
            return new INetCircuit[0];
        }
        boolean bl = false;
        if (n == EDIT_PATH_SELECTORS) {
            nArray = PathSelectorDialog.circuitStatusesAllowPathSelectorEdit();
            string2 = "Circuit status must be " + this.getCircuitStatusesString(nArray) + "\nto edit path selectors.";
            string = "Edit Path Selector Attributes";
        } else if (n == EDIT_CIRCUIT_STATES) {
            nArray = NetAdminState.circuitStatusesAllowsAdminStateEdit();
            string2 = "Circuit status must be " + this.getCircuitStatusesString(nArray) + "\nto edit circuit state.";
            string = "Edit Circuit State";
        } else {
            throw new IllegalArgumentException("Unanticipated editType: " + n);
        }
        INetCircuit[] iNetCircuitArray = circuitsPane.getSelectedCircuits(string, false);
        Arrays.sort(nArray);
        for (int i = 0; i < iNetCircuitArray.length; ++i) {
            if (Arrays.binarySearch(nArray, iNetCircuitArray[i].getState()) >= 0) continue;
            ErrorMsg.displayError(this, NEMC.EID_ERROR_EDITING_CKTS_PARAM_2, string, string2);
            return new INetCircuit[0];
        }
        return iNetCircuitArray;
    }

    private String getCircuitStatusesString(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(i < nArray.length - 1 ? ", " : " or ");
            }
            stringBuffer.append(NetworkDefaults.circuitStateToString(nArray[i]));
        }
        return stringBuffer.toString();
    }

    public void windowClosing(WindowEvent windowEvent) {
        try {
            this.parent.exitCtc(true);
        }
        catch (Exception exception) {
            db.finer("Exception in windowClosing, windowEvent=" + windowEvent + " " + exception);
        }
    }

    public NetworkViewController getNetworkViewController() {
        return this.nvc;
    }

    public void menuKeyTyped(MenuKeyEvent menuKeyEvent) {
    }

    public void menuKeyPressed(MenuKeyEvent menuKeyEvent) {
        this.modifiers = menuKeyEvent.getModifiers() & 3;
    }

    public void menuKeyReleased(MenuKeyEvent menuKeyEvent) {
        this.modifiers = 0;
    }

    public void addMenuItem(String string, JMenuItem jMenuItem, String string2) throws NoSuchItemException, DuplicateItemException {
        if (this.myMenus.getAbstractButton(string2) != null) {
            throw new DuplicateItemException("Item with this \"name\" already exists");
        }
        this.myMenus.addMenuItem((JComponent)this.myMenus.getAbstractButton(string), jMenuItem, null, string2);
    }

    public void addToolbarButton(JButton jButton, String string) throws DuplicateItemException {
        throw new DuplicateItemException("Operation not implemented");
    }

    public void removeMenuItem(String string, String string2) throws NoSuchItemException {
        if (this.myMenus.getAbstractButton(string2) == null) {
            throw new NoSuchItemException("No item " + string2 + " found");
        }
        this.myMenus.removeMenuItem((JMenuItem)this.myMenus.getAbstractButton(string), string2);
    }

    public void removeToolbarButton(String string) throws NoSuchItemException {
        throw new NoSuchItemException("Operation not implemented");
    }

    public IApplicationMenus getApplicationMenus() {
        return this;
    }

    static {
        EDIT_PATH_SELECTORS = 1;
        EDIT_CIRCUIT_STATES = 2;
    }

    protected class UpgradeCtcJobListener
    implements IJobListener {
        protected UpgradeCtcJobListener() {
        }

        public void jobWaiting(JobGroup jobGroup, IJobControl iJobControl, JobStatus jobStatus, Object object) {
        }

        public void jobRunning(JobGroup jobGroup, IJobControl iJobControl, JobStatus jobStatus, Object object) {
        }

        public void jobFinished(JobGroup jobGroup, IJobControl iJobControl, final JobStatus jobStatus, final Object object) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MainPanel.this.finishJob(jobStatus, (JobController)object);
                }
            });
        }
    }

    private class SetViewJob
    implements Runnable {
        private JPanel panel = null;
        private boolean sbVisible;
        private int type;

        SetViewJob(int n, boolean bl) {
            this.panel = null;
            this.type = n;
            this.sbVisible = bl;
        }

        SetViewJob(JPanel jPanel) {
            this.panel = jPanel;
        }

        public void run() {
            if (this.panel != null) {
                MainPanel.this.awtSetView(this.panel);
            } else {
                if (this.type == 0) {
                    if (this.sbVisible) {
                        MainPanel.this.innerContentPane.add((Component)MainPanel.this.statusBar, "South");
                    } else {
                        MainPanel.this.innerContentPane.remove(MainPanel.this.statusBar);
                    }
                } else if (this.sbVisible) {
                    MainPanel.this.contentPane.add((Component)MainPanel.this.toolBar, "North");
                } else {
                    MainPanel.this.contentPane.remove((Component)MainPanel.this.toolBar);
                }
                MainPanel.this.innerContentPane.invalidate();
                MainPanel.this.contentPane.invalidate();
                MainPanel.this.innerContentPane.validate();
                MainPanel.this.contentPane.validate();
            }
        }
    }

    public class TriggerMenuBar
    extends JMenuBar {
        public void menuSelectionChanged(boolean bl) {
            super.menuSelectionChanged(bl);
            if (MainPanel.this.checkNeeded) {
                MainPanel.this.updateProvision();
                MainPanel.this.checkNeeded = false;
            }
        }
    }
}

