/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.CircuitType;
import cerent.cms.model.Feature;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.INodeModel;
import cerent.cms.model.OchPortsHelper;
import cerent.cms.model.OchTrailHelper;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.route.DropPrefs;
import cerent.cms.route.MemberGroupPrefs;
import cerent.cms.route.RoutePrefs;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.Network;
import cerent.cms.ui.NodeCellRenderer;
import cerent.util.SDebug;
import cerent.util.gui.UComboBox;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.JComboBox;

public class NodeSelector
extends UComboBox {
    private TreeSet treeSet;
    private static SDebug db = new SDebug("NodeSelector");

    public NodeSelector() {
        this.setRenderer(new NodeCellRenderer());
        CircuitCreatInfo circuitCreatInfo = new CircuitCreatInfo(1, 1, 0);
        this.updateNodeList(circuitCreatInfo, null);
    }

    public void updatePGNodeList() {
        this.updateNodeList(new CircuitCreatInfo(4, 12, 0), null);
    }

    public void updateNodeList(CircuitCreatInfo circuitCreatInfo, INetCircuit iNetCircuit) {
        Object object;
        Object object2;
        INetElement[] iNetElementArray;
        int n = 120;
        int n2 = 8;
        boolean bl = false;
        if (iNetCircuit != null && circuitCreatInfo.isDiag()) {
            int n3;
            INodeModel iNodeModel = iNetCircuit.getSrcCircuitNode().getNodeModel();
            this.removeAllItems();
            this.addItem(iNodeModel);
            String string = NodeCellRenderer.getName(iNodeModel);
            if (string != null && (n3 = n2 * string.length()) > n) {
                NodeSelector.setPreferredWidth((JComboBox)((Object)this), (int)n3);
            }
            return;
        }
        ICircuitType iCircuitType = CircuitType.getCircuitType((int)circuitCreatInfo.type());
        if (iNetCircuit == null) {
            iNetElementArray = Network.instance().getElements().toArray(new INetElement[0]);
        } else {
            Object object3;
            object2 = new RoutePrefs();
            ((RoutePrefs)object2).setSrc(iNetCircuit.getSrcNetElement());
            ((RoutePrefs)object2).setCircuitSize(iNetCircuit.getCircuitSize());
            ((RoutePrefs)object2).setCircuitType(iNetCircuit.getCircuitType());
            ((RoutePrefs)object2).setRequiredSpans(iNetCircuit.getRequiredSpans());
            ((RoutePrefs)object2).setPathOnly(false);
            if (iNetCircuit.getCircuitTypeObj().isVcatCircuitType()) {
                int n4 = iNetCircuit.getCircuitType();
                if (n4 == 10) {
                    ((RoutePrefs)object2).setCircuitType(1);
                } else if (n4 == 12) {
                    ((RoutePrefs)object2).setCircuitType(4);
                } else if (n4 == 11) {
                    ((RoutePrefs)object2).setCircuitType(2);
                } else if (n4 == 13) {
                    ((RoutePrefs)object2).setCircuitType(5);
                }
                object3 = ((RoutePrefs)object2).getFwdDropPrefs();
                ((DropPrefs)object3).setCommonFiber(false);
                object = ((DropPrefs)object3).getFirstMemberGroupPrefs();
                ((MemberGroupPrefs)object).setMemberBandwidth(iNetCircuit.getCircuitSize());
                ((MemberGroupPrefs)object).setMemberCount(circuitCreatInfo.forwardMembers());
            }
            if (iCircuitType.isOchncType() || iCircuitType.isOchccCircuitType()) {
                Collection collection = Network.instance().getElements();
                object3 = collection.iterator();
                while (object3.hasNext()) {
                    object = (INetElement)object3.next();
                    if (object.getNodeId() != iNetCircuit.getSrcCircuitNode().getNetElement().getNodeId()) continue;
                    object3.remove();
                    break;
                }
                iNetElementArray = collection.toArray(new INetElement[0]);
            } else {
                iNetElementArray = Network.instance().getAvailDropNodes((RoutePrefs)object2);
            }
        }
        this.treeSet = new TreeSet(new NodeComparator());
        if (this.getItemCount() > 0) {
            this.removeAllItems();
        }
        object2 = NetCircuitManager.instance();
        boolean bl2 = iCircuitType.isLoCircuitType() || iCircuitType.isLoVcatCircuitType() || iCircuitType.isTunnelCircuitType() || iCircuitType.isLAPCircuitType() && iNetCircuit != null;
        for (int i = 0; i < iNetElementArray.length; ++i) {
            object = iNetElementArray[i];
            INodeModel iNodeModel = object.getNodeModel();
            if (iCircuitType.isOchncType()) {
                if (iNodeModel.provides(Feature.OCH_TRAIL_PROVISIONING) && circuitCreatInfo.cktOptDir() == -1) {
                    boolean bl3;
                    int n5 = circuitCreatInfo.cktOptChannel();
                    boolean bl4 = bl3 = circuitCreatInfo.dir() == 1;
                    if (iNetCircuit == null) {
                        if (!OchPortsHelper.isAvailableForOchncSource(iNodeModel, n5, bl3)) continue;
                        this.treeSet.add(iNodeModel);
                        continue;
                    }
                    if (!OchPortsHelper.isAvailableForOchncDrop(iNodeModel, n5, bl3)) continue;
                    this.treeSet.add(iNodeModel);
                    continue;
                }
                if (iNodeModel.provides(Feature.OCH_TRAIL_PROVISIONING) || circuitCreatInfo.cktOptDir() == -1) continue;
                if (iNetCircuit == null) {
                    try {
                        if (circuitCreatInfo.dir() == 0) {
                            if (!iNodeModel.getOchncPathAvailability(circuitCreatInfo.cktOptChannel(), circuitCreatInfo.cktOptDir(), 0)) continue;
                            this.treeSet.add(iNodeModel);
                            continue;
                        }
                        if (!iNodeModel.getOchncPathAvailability(circuitCreatInfo.cktOptChannel(), circuitCreatInfo.cktOptDir(), 0) || !iNodeModel.getOchncPathAvailability(circuitCreatInfo.cktOptChannel(), circuitCreatInfo.cktOptDir() == 0 ? 1 : 0, 1)) continue;
                        this.treeSet.add(iNodeModel);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                try {
                    if (circuitCreatInfo.dir() == 0) {
                        if (!iNodeModel.getOchncPathAvailability(circuitCreatInfo.cktOptChannel(), circuitCreatInfo.cktOptDir(), 1)) continue;
                        this.treeSet.add(iNodeModel);
                        continue;
                    }
                    if (!iNodeModel.getOchncPathAvailability(circuitCreatInfo.cktOptChannel(), circuitCreatInfo.cktOptDir(), 1) || !iNodeModel.getOchncPathAvailability(circuitCreatInfo.cktOptChannel(), circuitCreatInfo.cktOptDir() == 0 ? 1 : 0, 0)) continue;
                    this.treeSet.add(iNodeModel);
                }
                catch (Exception exception) {}
                continue;
            }
            if (iCircuitType.isOchccCircuitType()) {
                List list = OchTrailHelper.filterNodeForOchTrail(circuitCreatInfo, iNetCircuit, iNodeModel);
                if (list.size() <= 0) continue;
                this.treeSet.add(iNodeModel);
                continue;
            }
            if (object.canSupportCircuitSize(circuitCreatInfo.size()) && (!bl2 || object.loXCon())) {
                if (iCircuitType.isLoCircuitType() && ((NetCircuitManager)object2).canAddToNodeList(iNodeModel, iNetCircuit, circuitCreatInfo)) {
                    this.treeSet.add(iNodeModel);
                    continue;
                }
                if (!iCircuitType.isLoCircuitType() && !iCircuitType.isLAPCircuitType()) {
                    this.treeSet.add(iNodeModel);
                    continue;
                }
                if (!iCircuitType.isLAPCircuitType() || !iNodeModel.provides(Feature.VT_GROOMING)) continue;
                this.treeSet.add(iNodeModel);
                continue;
            }
            if (!((NetCircuitManager)object2).canAddToNodeList(iNodeModel, iNetCircuit, circuitCreatInfo)) continue;
            this.treeSet.add(iNodeModel);
        }
        Iterator iterator = this.treeSet.iterator();
        while (iterator.hasNext()) {
            int n6;
            object = (INodeModel)iterator.next();
            this.addItem(object);
            String string = NodeCellRenderer.getName((INodeModel)object);
            if (string == null || (n6 = n2 * string.length()) <= n) continue;
            n = n6;
            bl = true;
        }
        if (bl) {
            NodeSelector.setPreferredWidth((JComboBox)((Object)this), (int)n);
        }
    }

    private class NodeComparator
    implements Comparator {
        private NodeComparator() {
        }

        public int compare(Object object, Object object2) {
            INodeModel iNodeModel = (INodeModel)object;
            INodeModel iNodeModel2 = (INodeModel)object2;
            return iNodeModel.getName().compareTo(iNodeModel2.getName());
        }
    }
}

