/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.LetterOrDigitTextField;
import cerent.util.gui.TL1PasswordField;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PasswordChangePanel
extends JPanel {
    static final int MIN_CHARS = 6;
    static final int MARGIN = 5;
    protected LetterOrDigitTextField nameTF;
    protected TL1PasswordField oldPasswordTF;
    protected TL1PasswordField newPasswordTF;
    protected TL1PasswordField confirmedNewPasswordTF;

    public PasswordChangePanel(String string, boolean bl) {
        this.setLayout(new GridLayout(0, 2, 5, 5));
        this.add(new JLabel("Name: ", 4));
        this.nameTF = new LetterOrDigitTextField(20);
        this.add(this.nameTF);
        if (string != null) {
            this.nameTF.setText(string);
            this.nameTF.setEnabled(false);
        }
        if (bl) {
            this.add(new JLabel("Old Password: ", 4));
            this.oldPasswordTF = new TL1PasswordField(20);
            this.add(this.oldPasswordTF);
        }
        this.add(new JLabel("New Password: ", 4));
        this.newPasswordTF = new TL1PasswordField(20);
        this.add(this.newPasswordTF);
        this.add(new JLabel("Confirm New Password: ", 4));
        this.confirmedNewPasswordTF = new TL1PasswordField(20);
        this.add(this.confirmedNewPasswordTF);
    }

    public String getUserName() {
        return this.nameTF.getText();
    }

    public String getOldPassword() {
        String string = null != this.oldPasswordTF ? new String(this.oldPasswordTF.getPassword()) : new String();
        return string;
    }

    public String getNewPassword() {
        return new String(this.newPasswordTF.getPassword());
    }

    public boolean validatePassword() {
        String string = this.getUserName();
        if (string.length() < 6) {
            String string2 = "Password length must be at least 6 characters long.";
            ErrorMsg.displayError((Component)this, (EID)NEMC.EID_ILLEGAL_PASSWORD_PARAM_1, (Object)string2);
            return false;
        }
        try {
            this.newPasswordTF.isNotTooSimple(string);
        }
        catch (Exception exception) {
            ErrorMsg.displayError((Component)this, (EID)NEMC.EID_ILLEGAL_PASSWORD_PARAM_1, (Object)exception.getMessage());
            return false;
        }
        String string3 = this.getNewPassword();
        if (string3.compareTo(this.getConfirmPassword()) != 0) {
            ErrorMsg.displayError((Component)this, (EID)NEMC.EID_PASSWORD_MISMATCH);
            return false;
        }
        if (string3.length() > 10) {
            return CerentDialog.yesNoDialog((Component)this, (String)"The new password exceeds 10 characters \nand certain management functions will be disabled.\nOK to continue?", (String)"Password Illegal For TL1");
        }
        return true;
    }

    private String getConfirmPassword() {
        return new String(this.confirmedNewPasswordTF.getPassword());
    }
}

