/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.ui.AbstractPrefsPropertyPane;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.util.ColorUtil;
import cerent.util.Preferences;
import cerent.util.gui.AbstractPropertySheet;
import cerent.util.gui.BooleanPropertyEditor;
import cerent.util.gui.ColorPropertyEditor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PrefsCircuitPropertyPane
extends AbstractPrefsPropertyPane
implements ActionListener {
    private static Color ACTIVE = Color.green;
    private static Color STANDBY = new Color(128, 0, 192);
    private static final String ACTIVE_SPAN = "Active:";
    private static final String STANDBY_SPAN = "Standby:";
    private static String PREFS_ACTIVE_SPAN = "activespan";
    private static String PREFS_STANDBY_SPAN = "standbyspan";
    private ColorPropertyEditor actSpanEditor;
    private ColorPropertyEditor stbySpanEditor;
    private JButton resetButton = new JButton("Reset to Defaults");
    private BooleanPropertyEditor useDetailedMapEdit;

    public PrefsCircuitPropertyPane(String string, AbstractPropertySheet abstractPropertySheet, Preferences preferences) {
        super(string, abstractPropertySheet, preferences);
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)this.makePanes(), "North");
        this.notifyAllPropertyEditors(this);
        this.load();
    }

    private JPanel makePanes() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.makeColorPane(), "North");
        jPanel.add((Component)this.makeCircuitPrefsPane(), "South");
        return jPanel;
    }

    private JPanel makeColorPane() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Span Colors"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        jPanel2.setLayout(new GridBagLayout());
        this.actSpanEditor = new ColorPropertyEditor("", Color.red);
        this.stbySpanEditor = new ColorPropertyEditor("", Color.green);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints2.anchor = 17;
        jPanel2.add((Component)new JLabel(ACTIVE_SPAN), gridBagConstraints);
        jPanel2.add((Component)this.actSpanEditor, gridBagConstraints2);
        jPanel2.add((Component)new JLabel(STANDBY_SPAN), gridBagConstraints);
        jPanel2.add((Component)this.stbySpanEditor, gridBagConstraints2);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridwidth = 0;
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.anchor = 17;
        jPanel2.add((Component)this.resetButton, gridBagConstraints3);
        this.resetButton.addActionListener(this);
        jPanel.add((Component)jPanel2, "West");
        return jPanel;
    }

    private JPanel makeCircuitPrefsPane() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.useDetailedMapEdit = new BooleanPropertyEditor("Show Detailed Circuit Map by default");
        jPanel.add(Box.createVerticalStrut(15), "North");
        jPanel.add((Component)this.useDetailedMapEdit, "West");
        return jPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.resetButton) {
            this.actSpanEditor.setValue(ColorUtil.getRGBString(ACTIVE));
            this.stbySpanEditor.setValue(ColorUtil.getRGBString(STANDBY));
            this.actSpanEditor.setDirty(true);
            this.stbySpanEditor.setDirty(true);
        }
    }

    public void store() {
        this.store("ctc.circuits", PREFS_ACTIVE_SPAN, this.actSpanEditor);
        this.store("ctc.circuits", PREFS_STANDBY_SPAN, this.stbySpanEditor);
        this.store("ctc", "map.usedetailed", this.useDetailedMapEdit);
    }

    public void load() {
        String string = this.prefs.getProperty("ctc.circuits", PREFS_ACTIVE_SPAN, null);
        if (string == null) {
            string = ColorUtil.getRGBString(ACTIVE);
            this.prefs.setProperty("ctc.circuits", PREFS_ACTIVE_SPAN, string);
        }
        this.actSpanEditor.setValue(string);
        string = this.prefs.getProperty("ctc.circuits", PREFS_STANDBY_SPAN, null);
        if (string == null) {
            string = ColorUtil.getRGBString(STANDBY);
            this.prefs.setProperty("ctc.circuits", PREFS_STANDBY_SPAN, string);
        }
        this.stbySpanEditor.setValue(string);
        this.load("ctc", "map.usedetailed", this.useDetailedMapEdit);
    }

    public CSHelpID getHelpID() {
        return NetCSHelpConst.PrefsCircuitPropertyPane;
    }
}

