/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.ui.AbstractPrefsPropertyPane;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.JreInfoPane;
import cerent.cms.ui.NetCSHelpConst;
import cerent.util.CtcRuntime;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.gui.AbstractPropertySheet;
import cerent.util.gui.FilePropertyEditor;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PrefsJrePropertyPane
extends AbstractPrefsPropertyPane {
    private static final SDebug db = new SDebug("PrefsJrePropertyPane");
    private FilePropertyEditor jreFileEditor;
    private AbstractPropertySheet parentSheet;
    private Preferences launcherPrefs;
    private String jvm = "";
    private JreInfoPane jrePane;
    private String cachedJre;
    private static final String sep = File.separator;
    private static final String SYS_JRE = System.getProperty("java.home");

    public PrefsJrePropertyPane(String string, AbstractPropertySheet abstractPropertySheet, Preferences preferences) {
        super(string, abstractPropertySheet, preferences);
        this.parentSheet = abstractPropertySheet;
        this.launcherPrefs = Preferences.instance((String)Preferences.getDefaultLauncherPrefsFileName());
        this.cachedJre = this.launcherPrefs.getProperty("ctc.launcher", CtcRuntime.getJREPreferencesKey(), "");
        try {
            this.initialize();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    protected boolean onValidate(Container container) {
        boolean bl = false;
        this.jvm = (String)this.jreFileEditor.getValue();
        if (this.jvm.equals("")) {
            return true;
        }
        this.jvm = CtcRuntime.adjustUserJre((String)this.jvm);
        try {
            bl = CtcRuntime.isValidUserJre((String)this.jvm);
        }
        catch (IOException iOException) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)iOException);
            }
            bl = false;
        }
        if (!bl) {
            ErrorMsg.displayError((Component)this, (EID)NEMC.EID_UNSUPPORTED_JRE);
        }
        return bl;
    }

    public void store() {
        if (!this.jvm.equals("")) {
            this.launcherPrefs.setProperty("ctc.launcher", CtcRuntime.getJREPreferencesKey(), this.jvm);
        } else {
            this.launcherPrefs.setProperty("ctc.launcher", CtcRuntime.getJREPreferencesKey(), this.jrePane.getJreDir());
        }
        Preferences.storeAllPreferences();
    }

    public void load() {
        if (this.launcherPrefs != null) {
            this.cachedJre = this.launcherPrefs.getProperty("ctc.launcher", CtcRuntime.getJREPreferencesKey(), "");
            this.jreFileEditor.setValue(this.sameJre(this.cachedJre) ? "" : this.cachedJre);
        }
    }

    private boolean sameJre(String string) {
        if (string.equals("")) {
            return false;
        }
        if (string.startsWith(SYS_JRE)) {
            return true;
        }
        int n = SYS_JRE.lastIndexOf(sep + "jre");
        if (n > -1) {
            String string2 = SYS_JRE.substring(0, n);
            if (string.length() >= n && string.substring(0, n).equals(string2)) {
                return true;
            }
        }
        return false;
    }

    private void initialize() throws Exception {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(15, 5, 15, 5));
        this.add((Component)jPanel, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        this.jrePane = new JreInfoPane();
        jPanel.add((Component)this.jrePane, gridBagConstraints);
        this.jrePane.setJreVersion(System.getProperty("java.version"));
        this.jrePane.setJreDir(this.sameJre(this.cachedJre) ? this.cachedJre : SYS_JRE);
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)new JLabel("  Select a different JRE (effective when CTC is restarted):"), gridBagConstraints);
        this.jreFileEditor = new FilePropertyEditor("");
        this.jreFileEditor.setFileSelectionMode(1);
        this.jreFileEditor.setEditorSize(30);
        gridBagConstraints.gridy = 3;
        jPanel.add((Component)this.jreFileEditor, gridBagConstraints);
        this.load();
        this.notifyAllPropertyEditors(this);
        this.parentSheet.resetApply();
    }

    public CSHelpID getHelpID() {
        return NetCSHelpConst.PrefsJrePropertyPane;
    }
}

