/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.ISecurityPolicy;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.NodeSelectPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.SecurityPolicyPanel;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.gui.UDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class SecurityPolicyEditDialog
extends UDialog
implements ActionListener,
PropertyChangeListener {
    public static final String TITLE = "Edit Security Policy";
    private SecurityPolicyPanel securityPolicyPanel;
    private JButton okButton;
    private JButton cancelButton;
    private Pane parent;
    private boolean ok = false;
    private List nodeModelList;
    private NodeSelectPane nodeSelPane;
    private static final SDebug db = new SDebug("SecurityPolicyEditDialog");

    public static SecurityPolicyEditDialog instance(Pane pane, List list, ISecurityPolicy iSecurityPolicy) {
        Object[] objectArray = new Object[]{pane, list, iSecurityPolicy};
        Frame frame = JOptionPane.getFrameForComponent((Component)pane);
        return new SecurityPolicyEditDialog(frame, TITLE, objectArray);
    }

    private SecurityPolicyEditDialog(Frame frame, String string, Object object) {
        super(frame, string, true, object);
    }

    protected void initContentPane(JPanel jPanel, Object object) {
        this.ok = false;
        Object[] objectArray = (Object[])object;
        this.parent = (Pane)objectArray[0];
        this.nodeModelList = (List)objectArray[1];
        this.setSize(new Dimension(400, 250));
        if (this.nodeModelList != null && this.nodeModelList.size() > 1) {
            this.securityPolicyPanel = new SecurityPolicyPanel(this);
            jPanel.add((Component)this.securityPolicyPanel, "North");
            this.nodeSelPane = new NodeSelectPane(this.nodeModelList);
            jPanel.add((Component)this.nodeSelPane, "Center");
        } else {
            this.securityPolicyPanel = new SecurityPolicyPanel(this);
            jPanel.add((Component)this.securityPolicyPanel, "Center");
            this.nodeSelPane = null;
        }
        this.securityPolicyPanel.setSecurityPolicy((ISecurityPolicy)objectArray[2]);
        jPanel.add((Component)this.getButtonPanel(), "South");
        jPanel.revalidate();
    }

    public List getSelectedList() {
        if (this.nodeSelPane != null) {
            return this.nodeSelPane.getSelectedList();
        }
        return this.nodeModelList;
    }

    public void dispose() {
        this.parent = null;
        super.dispose();
    }

    public boolean isDirty() {
        return this.securityPolicyPanel.isDirty();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            if (this.getSelectedList().size() == 0) {
                ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_NO_APPLICABLE_NODES_SELECTED);
                return;
            }
            this.ok = true;
            this.dispose();
        } else if (object == this.cancelButton) {
            this.dispose();
        }
    }

    public boolean ok() {
        return this.ok;
    }

    public ISecurityPolicy getSecurityPolicy() {
        return this.securityPolicyPanel.getSecurityPolicy();
    }

    public boolean isMinChangedCharsInPwdDirty() {
        return this.securityPolicyPanel.isMinChangedCharsInPwdDirty();
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        this.okButton = this.makeActionButton("OK");
        jPanel.add(this.okButton);
        this.okButton.setEnabled(false);
        this.cancelButton = this.makeActionButton("Cancel");
        jPanel.add(this.cancelButton);
        jPanel.add(new CSHelpButton(NetCSHelpConst.SecurityPolicyEditDialog));
        return jPanel;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.okButton != null) {
            this.okButton.setEnabled(true);
        }
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }
}

