/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.Feature;
import cerent.cms.model.IModel;
import cerent.cms.model.IUserInfoModel;
import cerent.cms.model.NetworkModel;
import cerent.cms.model.NodeModel;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.Network;
import cerent.util.ComparisonUtil;
import cerent.util.EnumStrings;
import cerent.util.SDebug;
import cerent.util.gui.row.AbstractRowDataSource;
import cerent.util.gui.row.ColumnRenderer;
import cerent.util.gui.row.SortableRowTableModel;
import java.awt.Component;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTable;
import javax.swing.SwingUtilities;

class SecurityUsersDataSource
extends AbstractRowDataSource {
    private IModel _model;
    private ArrayList _values;
    private ArrayList _data;
    private static final String[] _columnNames = new String[]{"User", "Security Level", "Last Login Time", "Last Login Node", "Failed Logins", "Locked Out", "Disabled", "Password Change On Next Login"};
    private static final Class[] _columnClasses = new Class[]{String.class, String.class, String.class, String.class, Integer.class, String.class, String.class, String.class};
    private static final SDebug db = new SDebug("SecurityUsersDataSource");
    static /* synthetic */ Class class$cerent$cms$model$SecurityLevel;

    SecurityUsersDataSource(IModel iModel) {
        this._model = iModel;
        this._values = new ArrayList();
        this._data = new ArrayList();
        if (db.on()) {
            db.println("empty");
        }
    }

    private void fetchValues(NodeModel nodeModel, HashMap hashMap, ArrayList arrayList) {
        if (nodeModel.provides(Feature.SEC_GET_USERS)) {
            try {
                IUserInfoModel[] iUserInfoModelArray = nodeModel.getSecurityModel().getUsers();
                for (int i = 0; i < iUserInfoModelArray.length; ++i) {
                    String string = iUserInfoModelArray[i].getName();
                    UserInfo userInfo = (UserInfo)hashMap.get(string);
                    if (userInfo == null) {
                        if (db.on()) {
                            db.println("adding: " + string);
                        }
                        hashMap.put(string, new UserInfo(nodeModel, iUserInfoModelArray[i]));
                    } else {
                        if (db.on()) {
                            db.println("update: " + string);
                        }
                        userInfo.update(nodeModel, iUserInfoModelArray[i]);
                    }
                    arrayList.add(new UserEntry(nodeModel, iUserInfoModelArray[i]));
                }
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                // empty catch block
            }
        }
    }

    private NodeModel nodeModel(Object object) {
        if (object instanceof INetElement) {
            return (NodeModel)((INetElement)object).getNodeModel();
        }
        return (NodeModel)object;
    }

    List getNodes() {
        ArrayList<NodeModel> arrayList = new ArrayList<NodeModel>();
        if (this._model instanceof NetworkModel) {
            Iterator iterator = Network.instance().getElements().iterator();
            while (iterator.hasNext()) {
                arrayList.add(this.nodeModel(iterator.next()));
            }
        } else {
            arrayList.add(this.nodeModel(this._model));
        }
        return arrayList;
    }

    synchronized List getNodes(String string) {
        ArrayList<NodeModel> arrayList = new ArrayList<NodeModel>();
        if (this._model instanceof NetworkModel) {
            Iterator iterator = this._data.iterator();
            while (iterator.hasNext()) {
                UserEntry userEntry = (UserEntry)iterator.next();
                if (!userEntry.userMatches(string)) continue;
                arrayList.add(userEntry.getNode());
            }
        } else {
            arrayList.add(this.nodeModel(this._model));
        }
        return arrayList;
    }

    synchronized List filterSecurityLevel(List list, String string, int n) {
        ArrayList<NodeModel> arrayList = new ArrayList<NodeModel>();
        Iterator iterator = list.iterator();
        block0: while (iterator.hasNext()) {
            NodeModel nodeModel = (NodeModel)iterator.next();
            Iterator iterator2 = this._data.iterator();
            while (iterator2.hasNext()) {
                UserEntry userEntry = (UserEntry)iterator2.next();
                if (!userEntry.matches(nodeModel, string) || userEntry.getPermissionLevel() == n) continue;
                arrayList.add(nodeModel);
                continue block0;
            }
        }
        return arrayList;
    }

    synchronized List filterLockedOut(List list, String string, boolean bl) {
        ArrayList<NodeModel> arrayList = new ArrayList<NodeModel>();
        Iterator iterator = list.iterator();
        block0: while (iterator.hasNext()) {
            NodeModel nodeModel = (NodeModel)iterator.next();
            Iterator iterator2 = this._data.iterator();
            while (iterator2.hasNext()) {
                UserEntry userEntry = (UserEntry)iterator2.next();
                if (!userEntry.matches(nodeModel, string) || userEntry.getLockedOut() == bl) continue;
                arrayList.add(nodeModel);
                continue block0;
            }
        }
        return arrayList;
    }

    synchronized List filterUserDisabled(List list, String string, boolean bl) {
        ArrayList<NodeModel> arrayList = new ArrayList<NodeModel>();
        Iterator iterator = list.iterator();
        block0: while (iterator.hasNext()) {
            NodeModel nodeModel = (NodeModel)iterator.next();
            Iterator iterator2 = this._data.iterator();
            while (iterator2.hasNext()) {
                UserEntry userEntry = (UserEntry)iterator2.next();
                if (!userEntry.matches(nodeModel, string) || userEntry.getUserDisabled() == bl) continue;
                arrayList.add(nodeModel);
                continue block0;
            }
        }
        return arrayList;
    }

    synchronized List filterUserForcePasswordChange(List list, String string, boolean bl) {
        ArrayList<NodeModel> arrayList = new ArrayList<NodeModel>();
        Iterator iterator = list.iterator();
        block0: while (iterator.hasNext()) {
            NodeModel nodeModel = (NodeModel)iterator.next();
            Iterator iterator2 = this._data.iterator();
            while (iterator2.hasNext()) {
                UserEntry userEntry = (UserEntry)iterator2.next();
                if (!userEntry.matches(nodeModel, string) || userEntry.getUserForcePasswordChange() == bl) continue;
                arrayList.add(nodeModel);
                continue block0;
            }
        }
        return arrayList;
    }

    void refreshFromModel(SortableRowTableModel sortableRowTableModel) {
        block5: {
            try {
                HashMap hashMap = new HashMap();
                ArrayList arrayList = new ArrayList();
                if (this._model instanceof NetworkModel) {
                    Iterator iterator = Network.instance().getElements().iterator();
                    while (iterator.hasNext()) {
                        this.fetchValues(this.nodeModel(iterator.next()), hashMap, arrayList);
                    }
                } else {
                    this.fetchValues(this.nodeModel(this._model), hashMap, arrayList);
                }
                SwingUtilities.invokeAndWait(new Refresher(sortableRowTableModel, hashMap, arrayList));
            }
            catch (Exception exception) {
                if (!db.on()) break block5;
                db.println("exception: " + exception);
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    boolean nodeDoesNotSupportGetUsers() {
        if (this._model instanceof NetworkModel) {
            Iterator iterator = Network.instance().getElements().iterator();
            while (iterator.hasNext()) {
                if (this.nodeModel(iterator.next()).provides(Feature.SEC_GET_USERS)) continue;
                return true;
            }
        } else if (!this.nodeModel(this._model).provides(Feature.SEC_GET_USERS)) {
            return true;
        }
        return false;
    }

    boolean nodeSupportClearSecurityIntrusionAlarm() {
        if (this._model instanceof NetworkModel) {
            Iterator iterator = Network.instance().getElements().iterator();
            while (iterator.hasNext()) {
                if (!this.nodeModel(iterator.next()).provides(Feature.SEC_CLR_VIOLATION_ALM)) continue;
                return true;
            }
        } else if (this.nodeModel(this._model).provides(Feature.SEC_CLR_VIOLATION_ALM)) {
            return true;
        }
        return false;
    }

    ColumnRenderer[] getRenderers() {
        ColumnRenderer[] columnRendererArray = new ColumnRenderer[_columnNames.length];
        for (int i = 0; i < _columnNames.length; ++i) {
            columnRendererArray[i] = new Renderer(i);
        }
        return columnRendererArray;
    }

    public synchronized Object getObjectAtRow(int n) {
        return this._values.get(n);
    }

    public synchronized int getRowCount() {
        return this._values.size();
    }

    public Class getRowObjectClass() {
        return UserInfo.class;
    }

    private class Renderer
    implements ColumnRenderer {
        private final int _column;

        Renderer(int n) {
            this._column = n;
        }

        public String getName() {
            return _columnNames[this._column];
        }

        public int getWidth() {
            return 96;
        }

        public int getAlignment() {
            return 2;
        }

        public boolean isResizable() {
            return true;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            return jTable.getDefaultRenderer(_columnClasses[this._column]).getTableCellRendererComponent(jTable, ((UserInfo)object).getValueAt(n2), bl, bl2, n, n2);
        }

        public int compareColumn(Object object, Object object2, int n) {
            if (object instanceof UserInfo) {
                if (object2 instanceof UserInfo) {
                    return ((UserInfo)object).cmpValueAt((UserInfo)object2, n);
                }
                return -1;
            }
            return 1;
        }
    }

    private class Refresher
    implements Runnable {
        private SortableRowTableModel _tm;
        private HashMap _newValues;
        private ArrayList _newData;

        Refresher(SortableRowTableModel sortableRowTableModel, HashMap hashMap, ArrayList arrayList) {
            this._tm = sortableRowTableModel;
            this._newValues = hashMap;
            this._newData = arrayList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ArrayList arrayList = new ArrayList();
            Iterator iterator = this._newValues.entrySet().iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next().getValue());
            }
            SecurityUsersDataSource securityUsersDataSource = SecurityUsersDataSource.this;
            synchronized (securityUsersDataSource) {
                SecurityUsersDataSource.this._values = arrayList;
                SecurityUsersDataSource.this._data = this._newData;
            }
            this._tm.dataSourceChanged();
            this._tm = null;
            this._newValues = null;
            this._newData = null;
        }
    }

    static class UserInfo {
        private static final SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss z");
        private static final String _suffix = " (partial)";
        private IUserInfoModel _user;
        private String _username;
        private String _securityLevel;
        private int _securityLevelValue;
        private boolean _securityLevelConsistent;
        private Date _lastLoginTime;
        private String _lastLoginNode;
        private Integer _failedLogins;
        private String _lockedOut;
        private Boolean _lockedOutValue;
        private boolean _lockedOutConsistent;
        private String _disabled;
        private Boolean _disabledValue;
        private boolean _disabledConsistent;
        private String _passwordChange;
        private Boolean _passwordChangeValue;
        private boolean _passwordChangeConsistent;

        UserInfo(NodeModel nodeModel, IUserInfoModel iUserInfoModel) {
            this._user = iUserInfoModel;
            this._username = iUserInfoModel.getName();
            this.updateSecurityLevel(nodeModel, iUserInfoModel);
            this.updateLastLogin(nodeModel, iUserInfoModel);
            this.updateFailedLogins(nodeModel, iUserInfoModel);
            this.updateLockedOut(nodeModel, iUserInfoModel);
            this.updateUserDisabled(nodeModel, iUserInfoModel);
            this.updateUserForcePasswordChange(nodeModel, iUserInfoModel);
        }

        IUserInfoModel getUser() {
            return this._user;
        }

        String getUsername() {
            return this._username;
        }

        String getSecurityLevel() {
            return this._securityLevel;
        }

        int getSecurityLevelValue() {
            return this._securityLevelValue;
        }

        Date getLastLoginTime() {
            return this._lastLoginTime;
        }

        String getLastLoginNode() {
            return this._lastLoginNode;
        }

        Integer getFailedLogins() {
            return this._failedLogins;
        }

        String getLockedOut() {
            return this._lockedOut;
        }

        Boolean getLockedOutValue() {
            return this._lockedOutValue;
        }

        String getUserDisabled() {
            return this._disabled;
        }

        Boolean getUserDisabledValue() {
            return this._disabledValue;
        }

        String getUserForcePasswordChange() {
            return this._passwordChange;
        }

        Boolean getUserForcePasswordChangeValue() {
            return this._passwordChangeValue;
        }

        private String getSecurityString(IUserInfoModel iUserInfoModel) {
            return EnumStrings.getString((Class)(class$cerent$cms$model$SecurityLevel == null ? (class$cerent$cms$model$SecurityLevel = SecurityUsersDataSource.class$("cerent.cms.model.SecurityLevel")) : class$cerent$cms$model$SecurityLevel), (int)iUserInfoModel.getPermissionLevel());
        }

        void updateSecurityLevel(NodeModel nodeModel, IUserInfoModel iUserInfoModel) {
            if (this._securityLevel != null) {
                if (this._securityLevelConsistent && iUserInfoModel.getPermissionLevel() != this._securityLevelValue) {
                    this._securityLevelConsistent = false;
                    this._securityLevel = this._securityLevel + _suffix;
                }
                if (!this._securityLevelConsistent && iUserInfoModel.getPermissionLevel() > this._securityLevelValue) {
                    this._securityLevelValue = iUserInfoModel.getPermissionLevel();
                    this._securityLevel = this.getSecurityString(iUserInfoModel) + _suffix;
                }
            } else {
                this._securityLevelValue = iUserInfoModel.getPermissionLevel();
                this._securityLevel = this.getSecurityString(iUserInfoModel);
                this._securityLevelConsistent = true;
            }
        }

        void updateLastLogin(NodeModel nodeModel, IUserInfoModel iUserInfoModel) {
            Date date;
            if (nodeModel.provides(Feature.SECURITY_USER_STATUS) && (date = iUserInfoModel.getLastLoginTime()) != null && (this._lastLoginTime == null || date.compareTo(this._lastLoginTime) > 0)) {
                this._lastLoginTime = date;
                this._lastLoginNode = nodeModel.getName();
            }
        }

        void updateFailedLogins(NodeModel nodeModel, IUserInfoModel iUserInfoModel) {
            int n = nodeModel.provides(Feature.SECURITY_USER_STATUS) ? iUserInfoModel.getFailedLoginCount() : 0;
            if (n > 0) {
                if (this._failedLogins != null) {
                    n += this._failedLogins.intValue();
                }
                this._failedLogins = new Integer(n);
            } else if (this._failedLogins == null) {
                this._failedLogins = new Integer(0);
            }
        }

        void updateLockedOut(NodeModel nodeModel, IUserInfoModel iUserInfoModel) {
            boolean bl = nodeModel.provides(Feature.SECURITY_USER_STATUS) ? iUserInfoModel.getLockedOut() : false;
            if (this._lockedOut != null) {
                if (this._lockedOutConsistent && bl != this._lockedOutValue) {
                    this._lockedOutConsistent = false;
                    this._lockedOut = this._lockedOut + _suffix;
                }
                if (!this._lockedOutConsistent) {
                    this._lockedOut = "Yes (partial)";
                    this._lockedOutValue = Boolean.TRUE;
                }
            } else {
                if (bl) {
                    this._lockedOut = "Yes";
                    this._lockedOutValue = Boolean.TRUE;
                } else {
                    this._lockedOut = "No";
                    this._lockedOutValue = Boolean.FALSE;
                }
                this._lockedOutConsistent = true;
            }
        }

        void updateUserDisabled(NodeModel nodeModel, IUserInfoModel iUserInfoModel) {
            boolean bl = nodeModel.provides(Feature.SEC_DISABLE_USERID) ? iUserInfoModel.getUserDisabled() : false;
            if (this._disabled != null) {
                if (this._disabledConsistent && bl != this._disabledValue) {
                    this._disabledConsistent = false;
                    this._disabled = this._disabled + _suffix;
                }
                if (!this._disabledConsistent) {
                    this._disabled = "Yes (partial)";
                    this._disabledValue = Boolean.TRUE;
                }
            } else {
                if (bl) {
                    this._disabled = "Yes";
                    this._disabledValue = Boolean.TRUE;
                } else {
                    this._disabled = "No";
                    this._disabledValue = Boolean.FALSE;
                }
                this._disabledConsistent = true;
            }
        }

        void updateUserForcePasswordChange(NodeModel nodeModel, IUserInfoModel iUserInfoModel) {
            boolean bl = nodeModel.provides(Feature.SEC_FORCE_PASSWD_CHANGE) ? iUserInfoModel.getUserForcePasswordChange() : false;
            if (this._passwordChange != null) {
                if (this._passwordChangeConsistent && bl != this._passwordChangeValue) {
                    this._passwordChangeConsistent = false;
                    this._passwordChange = this._passwordChange + _suffix;
                }
                if (!this._passwordChangeConsistent) {
                    this._passwordChange = "Yes (partial)";
                    this._passwordChangeValue = Boolean.TRUE;
                }
            } else {
                if (bl) {
                    this._passwordChange = "Yes";
                    this._passwordChangeValue = Boolean.TRUE;
                } else {
                    this._passwordChange = "No";
                    this._passwordChangeValue = Boolean.FALSE;
                }
                this._passwordChangeConsistent = true;
            }
        }

        void update(NodeModel nodeModel, IUserInfoModel iUserInfoModel) {
            this.updateSecurityLevel(nodeModel, iUserInfoModel);
            this.updateLastLogin(nodeModel, iUserInfoModel);
            this.updateFailedLogins(nodeModel, iUserInfoModel);
            this.updateLockedOut(nodeModel, iUserInfoModel);
            this.updateUserDisabled(nodeModel, iUserInfoModel);
            this.updateUserForcePasswordChange(nodeModel, iUserInfoModel);
        }

        Object getValueAt(int n) {
            switch (n) {
                case 0: {
                    return this.getUsername();
                }
                case 1: {
                    return this.getSecurityLevel();
                }
                case 2: {
                    return this.getLastLoginTime() == null ? "" : sdf.format(this.getLastLoginTime());
                }
                case 3: {
                    return this.getLastLoginNode();
                }
                case 4: {
                    return this.getFailedLogins();
                }
                case 5: {
                    return this.getLockedOut();
                }
                case 6: {
                    return this.getUserDisabled();
                }
                case 7: {
                    return this.getUserForcePasswordChange();
                }
            }
            return null;
        }

        int cmpValueAt(UserInfo userInfo, int n) {
            switch (n) {
                case 0: {
                    return this.getUsername().compareTo(userInfo.getUsername());
                }
                case 1: {
                    return this.getSecurityLevel().compareTo(userInfo.getSecurityLevel());
                }
                case 2: {
                    if (this.getLastLoginTime() == null) {
                        return 1;
                    }
                    if (userInfo.getLastLoginTime() == null) {
                        return -1;
                    }
                    return this.getLastLoginTime().compareTo(userInfo.getLastLoginTime());
                }
                case 3: {
                    if (this.getLastLoginNode() == null) {
                        return 1;
                    }
                    if (userInfo.getLastLoginNode() == null) {
                        return -1;
                    }
                    return this.getLastLoginNode().compareTo(userInfo.getLastLoginNode());
                }
                case 4: {
                    return this.getFailedLogins().compareTo(userInfo.getFailedLogins());
                }
                case 5: {
                    return ComparisonUtil.compare((boolean)this.getLockedOutValue(), (boolean)userInfo.getLockedOutValue());
                }
                case 6: {
                    return ComparisonUtil.compare((boolean)this.getUserDisabledValue(), (boolean)userInfo.getUserDisabledValue());
                }
                case 7: {
                    return ComparisonUtil.compare((boolean)this.getUserForcePasswordChangeValue(), (boolean)userInfo.getUserForcePasswordChangeValue());
                }
            }
            return -1;
        }
    }

    static class UserEntry {
        private NodeModel _node;
        private IUserInfoModel _user;

        UserEntry(NodeModel nodeModel, IUserInfoModel iUserInfoModel) {
            this._node = nodeModel;
            this._user = iUserInfoModel;
        }

        NodeModel getNode() {
            return this._node;
        }

        int getPermissionLevel() {
            return this._user.getPermissionLevel();
        }

        boolean getLockedOut() {
            return this._node.provides(Feature.SECURITY_USER_STATUS) ? this._user.getLockedOut() : false;
        }

        boolean getUserDisabled() {
            return this._node.provides(Feature.SEC_DISABLE_USERID) ? this._user.getUserDisabled() : false;
        }

        boolean getUserForcePasswordChange() {
            return this._node.provides(Feature.SEC_FORCE_PASSWD_CHANGE) ? this._user.getUserForcePasswordChange() : false;
        }

        boolean nodeMatches(NodeModel nodeModel) {
            return this._node.getHostName().equals(nodeModel.getHostName());
        }

        boolean userMatches(String string) {
            return this._user.getName().equals(string);
        }

        boolean matches(NodeModel nodeModel, String string) {
            return this.nodeMatches(nodeModel) && this.userMatches(string);
        }
    }
}

