/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.Feature;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ISwUpgradeModel;
import cerent.cms.model.ISwUpgradeUpdate;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.Operation;
import cerent.cms.model.SecurityLevel;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.Network;
import cerent.cms.ui.AbstractViewController;
import cerent.cms.ui.BackupRestoreDialog;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.NodeVersionInfo;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.ViewName;
import cerent.cms.ui.download.AbstractSoftMaintPane;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.job.IJobProgressControl;
import com.cisco.ctc.CtcApplication;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;

public class SoftMaintPane
extends AbstractSoftMaintPane
implements Observer,
MouseListener {
    private Network networkModel = null;
    private AbstractViewController avc = null;
    private IModel paneModel;
    private ISwUpgradeModel swUpgradeModel = null;
    private boolean supportsDetailedUpgrade = false;
    private final int FLM_SW_NOT_ACCEPTED = 10;

    public SoftMaintPane(String string, INodeModel iNodeModel, TabbedView tabbedView) {
        super(string, iNodeModel, tabbedView);
        this.paneModel = iNodeModel;
        this.getTableColumnsPrefs();
        try {
            if (this.nodeModel == null) {
                this.table.addMouseListener(this);
                this.avc = CtcApplication.instance().getMainPanel().getNetworkViewController();
            } else {
                this.supportsDetailedUpgrade = iNodeModel.provides(Feature.DETAILED_SW_UPGRADE);
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    public void enteringPage() {
        if (this.networkModel == null) {
            this.init();
        }
        super.enteringPage();
        this.getTableColumnsPrefs();
        db.println("In enteringPage - about to get the sw upgrade model.");
        if (this.supportsDetailedUpgrade) {
            this.swUpgradeModel = ((INodeModel)this.paneModel).getSwUpgradeModel();
            db.println("In enteringPage - swUpgradeModel = " + this.swUpgradeModel);
            if (this.swUpgradeModel != null) {
                this.swUpgradeModel.init();
                this.swUpgradeModel.addObserver((Observer)this);
            }
            this.syncButtons();
        }
    }

    public void leavingPage() throws Exception {
        super.leavingPage();
        this.setTableColumnsPrefs();
        if (this.supportsDetailedUpgrade && this.swUpgradeModel != null) {
            this.swUpgradeModel.deleteObserver((Observer)this);
            this.swUpgradeModel = null;
        }
    }

    public void refresh() {
        if (this.supportsDetailedUpgrade && this.swUpgradeModel != null) {
            this.syncButtons();
        } else {
            this.toggleButtons();
        }
    }

    private void syncButtons() {
        if (this.swUpgradeModel.isOperationAllowed(3)) {
            this.enableComponent(this.downloadButton, this.uiModel, SecurityLevel.MAINTENANCE);
        } else {
            this.downloadButton.setEnabled(false);
        }
        if (this.swUpgradeModel.isOperationAllowed("Cancel")) {
            this.enableComponent(this.cancelButton, this.uiModel, SecurityLevel.MAINTENANCE);
        } else {
            this.cancelButton.setEnabled(false);
        }
        SecurityLevel securityLevel = null;
        db.finest("Node " + this.swUpgradeModel.getNodeModel().getName() + " is using version " + this.swUpgradeModel.getNodeModel().getSwVersion() + ". It " + (this.swUpgradeModel.getNodeModel().provides(Feature.SUPER_GRANT_PERMISSION_PROV) ? "supports " : "does not support ") + Feature.SUPER_GRANT_PERMISSION_PROV.toString() + " feature");
        securityLevel = this.swUpgradeModel.getNodeModel().provides(Feature.SUPER_GRANT_PERMISSION_PROV) || this.swUpgradeModel.getNodeModel().getSwVersion().startsWith("07.00") ? this.secModel.getOperationPrivilege(Operation.ACTIVATE_REVERT_SW) : SecurityLevel.SUPERUSER;
        if (this.swUpgradeModel.isOperationAllowed(4)) {
            this.enableComponent(this.activateButton, this.uiModel, securityLevel);
        } else {
            this.activateButton.setEnabled(false);
        }
        if (this.swUpgradeModel.isOperationAllowed(5)) {
            this.enableComponent(this.revertButton, this.uiModel, securityLevel);
        } else {
            this.revertButton.setEnabled(false);
        }
        if (this.swUpgradeModel.isOperationAllowed("Accept")) {
            this.enableComponent(this.acceptButton, this.uiModel, securityLevel);
        } else {
            this.acceptButton.setEnabled(false);
        }
    }

    private void init() {
        this.networkModel = Network.instance();
        this.networkModel.getNetElementCreationNotifier().addObserver(this);
        Iterator iterator = this.networkModel.getElements().iterator();
        while (iterator.hasNext()) {
            INetElement iNetElement = (INetElement)iterator.next();
            INodeModel iNodeModel = iNetElement.getNodeModel();
            this.dataSource.addNode(iNodeModel);
            if (!iNodeModel.provides(Feature.DETAILED_SW_UPGRADE)) continue;
            iNodeModel.getSwUpgradeModel().setJobProgressControl((IJobProgressControl)this.dataSource.getNodeVerInfo(iNodeModel));
        }
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof Network.NetElementCreationNotifier) {
            INodeModel iNodeModel = ((INetElement)object).getNodeModel();
            this.dataSource.addNode(iNodeModel);
            if (iNodeModel.provides(Feature.DETAILED_SW_UPGRADE)) {
                iNodeModel.getSwUpgradeModel().setJobProgressControl((IJobProgressControl)this.dataSource.getNodeVerInfo(iNodeModel));
            }
        }
        if (!(object instanceof Integer) || !((Integer)object).equals(ModelUpdateType.DELETED)) {
            this.refresh();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        NodeVersionInfo nodeVersionInfo;
        int n;
        if (mouseEvent.getClickCount() == 2 && (n = this.table.rowAtPoint(mouseEvent.getPoint())) != -1 && (nodeVersionInfo = (NodeVersionInfo)this.table.getModel().getValueAt(n, 0)) != null && nodeVersionInfo.getNodeModel().getConnectionState() && this.avc != null) {
            this.avc.tryJumpView(new ViewName(nodeVersionInfo.getNodeModel().getNodeId()));
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void destroy() {
        this.setTableColumnsPrefs();
        this.table.removeMouseListener(this);
        if (this.networkModel != null && this.networkModel.getNetElementCreationNotifier() != null) {
            this.networkModel.getNetElementCreationNotifier().deleteObserver(this);
        }
        if (this.supportsDetailedUpgrade && this.swUpgradeModel != null) {
            this.swUpgradeModel.deleteObserver((Observer)this);
            this.swUpgradeModel = null;
        }
        super.destroy();
    }

    private void getTableColumnsPrefs() {
        if (this.paneModel instanceof INodeModel) {
            TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName() + "_shelf");
        } else {
            TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName() + "_network");
        }
    }

    private void setTableColumnsPrefs() {
        if (this.paneModel instanceof INodeModel) {
            TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName() + "_shelf");
        } else {
            TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName() + "_network");
        }
    }

    protected void displayFlashInfo() {
        ISwUpgradeUpdate iSwUpgradeUpdate = this.swUpgradeModel.getSwUpgradeUpdateInfo();
        String string = "TSC A Working = " + String.valueOf(iSwUpgradeUpdate.getWorkingSwVerControllerA());
        string = string + "\nTSC A Protect = " + String.valueOf(iSwUpgradeUpdate.getProtectSwVerControllerA());
        string = string + "\nTSC B Working = " + String.valueOf(iSwUpgradeUpdate.getWorkingSwVerControllerB());
        string = string + "\nTSC B Protect = " + String.valueOf(iSwUpgradeUpdate.getProtectSwVerControllerB());
        CerentDialog.infoDialog((Component)((Object)this), (String)string, (String)"Current Software Info");
    }

    protected void handleCancelPressDetailed() {
        ISwUpgradeUpdate iSwUpgradeUpdate = this.swUpgradeModel.getSwUpgradeUpdateInfo();
        if (iSwUpgradeUpdate.getSwUpgradeState() == 1 && iSwUpgradeUpdate.getSwUpgradeActivity() == 1) {
            this.handleCancelPress();
        } else {
            this.cancelSwUpgrade();
        }
    }

    protected void handleRevertPressDetailed() {
        INodeModel iNodeModel = (INodeModel)this.getUiModel();
        int n = this.swUpgradeModel.getSpecialRevertDisallowedReason(this.dataSource.getNodeVerInfo(iNodeModel).getProtectVersion());
        if (n == 1) {
            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_NO_SW_DOWNGRADE_WITH_SSXC);
        } else if (n == 2) {
            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_NO_SW_DOWNGRADE);
        } else {
            BackupRestoreDialog backupRestoreDialog = new BackupRestoreDialog(this, iNodeModel, 2, true);
            backupRestoreDialog.show();
        }
    }

    public void cancelSwUpgrade() {
        block4: {
            boolean bl;
            ISwUpgradeUpdate iSwUpgradeUpdate = this.swUpgradeModel.getSwUpgradeUpdateInfo();
            int n = iSwUpgradeUpdate.getSwUpgradeState();
            int n2 = iSwUpgradeUpdate.getSwUpgradeActivity();
            if (n == 3 && n2 == 0 && !(bl = CerentDialog.yesNoWarningDialog((Component)((Object)this), (String)"Are you sure?", (String)"Confirm Cancel"))) {
                return;
            }
            if (!(n != 4 && n != 3 || n2 != 5 || (bl = CerentDialog.yesNoWarningDialog((Component)((Object)this), (String)(ErrorMsg.getString((EID)NEMC.WID_TSC_ACQUIRING_CLOCK_SW_UPGRADE) + "\n\nAre you sure?"), (String)"Confirm Cancel")))) {
                return;
            }
            try {
                this.swUpgradeModel.cancelSwUpgrade();
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
                ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_SW_UPGRADE_CANCEL);
                if (!db.on()) break block4;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    public void acceptSw() {
        block4: {
            if (db.on()) {
                db.println("About to invoke acceptSwUpgrade for 15600");
            }
            try {
                int n = this.swUpgradeModel.acceptSwUpgrade();
                if (n == 10) {
                    CerentDialog.infoDialog((Component)((Object)this), (String)"NE has already accepted the new software", (String)"Software Accepted");
                }
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
                ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_SW_FAIL_ACCEPT_LOAD);
                if (!db.on()) break block4;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    public CSHelpID getHelpID() {
        return NetCSHelpConst.SoftMaintPane;
    }
}

