/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.NodeModel;
import cerent.cms.ui.NodeSelectPane;
import cerent.cms.ui.Pane;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.gui.UDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class UserDeletionDialog
extends UDialog
implements ActionListener {
    public static final String TITLE = "Delete User";
    private JTextField nameTF;
    private JCheckBox logoutBeforeDelete;
    private JButton okButton;
    private JButton cancelButton;
    private Pane parent;
    private String userName = "";
    private boolean ok = false;
    private static List nodeModelList;
    private static NodeSelectPane nodeSelPane;

    public static UserDeletionDialog instance(Pane pane, String string, List list) {
        Object[] objectArray = new Object[]{pane, string, list};
        Frame frame = JOptionPane.getFrameForComponent((Component)pane);
        return new UserDeletionDialog(frame, TITLE, objectArray);
    }

    private UserDeletionDialog(Frame frame, String string, Object object) {
        super(frame, string, true, object);
    }

    protected void initContentPane(JPanel jPanel, Object object) {
        this.ok = false;
        Object[] objectArray = (Object[])object;
        this.parent = (Pane)objectArray[0];
        this.userName = (String)objectArray[1];
        this.setSize(new Dimension(500, 250));
        nodeModelList = (List)objectArray[2];
        if (nodeModelList != null && nodeModelList.size() > 1) {
            jPanel.add((Component)this.getNamePanel(), "North");
            nodeSelPane = new NodeSelectPane(nodeModelList);
            jPanel.add((Component)nodeSelPane, "Center");
        } else {
            if (nodeModelList != null && nodeModelList.size() > 0) {
                NodeModel nodeModel = (NodeModel)nodeModelList.get(0);
                jPanel.add((Component)new JLabel("Delete from " + nodeModel.getName()), "North");
            }
            nodeSelPane = null;
            jPanel.add((Component)this.getNamePanel(), "Center");
        }
        jPanel.add((Component)this.getButtonPanel(), "South");
        if (this.userName != null && !this.userName.equals("")) {
            this.nameTF.setEnabled(false);
        }
    }

    public List getSelectedList() {
        if (nodeSelPane != null) {
            return nodeSelPane.getSelectedList();
        }
        return nodeModelList;
    }

    public void dispose() {
        this.parent = null;
        super.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            if (this.apply()) {
                this.ok = true;
                this.dispose();
            }
        } else if (object == this.cancelButton) {
            this.dispose();
        } else {
            throw new IllegalArgumentException("actionPerformed: unexpected source " + object);
        }
    }

    private boolean apply() {
        this.userName = this.nameTF.getText();
        if (this.userName == null || this.userName.length() == 0) {
            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_NO_USER_NAME_SPECIFIED);
            return false;
        }
        return true;
    }

    public boolean ok() {
        return this.ok;
    }

    public String getUserName() {
        return this.userName;
    }

    public boolean getLogoutBeforeDelete() {
        return this.logoutBeforeDelete.isSelected();
    }

    private JPanel getNamePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 2, 5, 5));
        jPanel.add(new JLabel("Name: ", 4));
        this.nameTF = new JTextField(20);
        jPanel.add(this.nameTF);
        if (this.userName != null) {
            this.nameTF.setText(this.userName);
            this.nameTF.setEnabled(false);
        }
        jPanel.add(new JLabel("Logout before delete?", 4));
        this.logoutBeforeDelete = new JCheckBox();
        jPanel.add(this.logoutBeforeDelete);
        this.logoutBeforeDelete.setSelected(false);
        return jPanel;
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        this.okButton = this.makeActionButton("OK");
        jPanel.add(this.okButton);
        this.cancelButton = this.makeActionButton("Cancel");
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }
}

