/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.loader.ElementFactoryFinder;
import cerent.cms.model.DuplicateLocalVlinkId;
import cerent.cms.model.DuplicateRemoteVlinkId;
import cerent.cms.model.EndPointInUse;
import cerent.cms.model.Feature;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.VirtualLinksDirector;
import cerent.cms.model.WarningMessageException;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.VirtualLinkPane;
import cerent.util.ComparisonUtil;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.DigitTextField;
import cerent.util.gui.UDialog;
import cerent.util.gui.UScrollPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class VirtualLinkCreationDialog
extends UDialog
implements ActionListener,
ListSelectionListener,
DocumentListener,
Observer {
    protected JButton okButton;
    protected JButton cancelButton;
    protected JCheckBox separateTxRxCB;
    protected JComboBox localNodeCB;
    protected JComboBox remoteNodeCB;
    protected NMCellEditor localNodeCE;
    protected NMCellEditor remoteNodeCE;
    protected DigitTextField localTxVLIDTF;
    protected DigitTextField remoteTxVLIDTF;
    protected DigitTextField localRxVLIDTF;
    protected DigitTextField remoteRxVLIDTF;
    protected DefaultListModel localTxVLModel;
    protected DefaultListModel localRxVLModel;
    protected JList localTxTermList;
    protected JList localRxTermList;
    protected DefaultListModel remoteTxVLModel;
    protected DefaultListModel remoteRxVLModel;
    protected JList remoteTxTermList;
    protected JList remoteRxTermList;
    protected DefaultComboBoxModel localTxComboModel;
    protected DefaultComboBoxModel localRxComboModel;
    protected DefaultComboBoxModel remoteTxComboModel;
    protected DefaultComboBoxModel remoteRxComboModel;
    protected JComboBox remoteTxShelfCombo;
    protected JComboBox remoteRxShelfCombo;
    protected JComboBox localTxShelfCombo;
    protected JComboBox localRxShelfCombo;
    private JLabel localTxShelfLabel;
    private JLabel localRxShelfLabel;
    private JLabel remoteTxShelfLabel;
    private JLabel remoteRxShelfLabel;
    private JPanel localPanel;
    private JPanel localTxPanel;
    private JPanel localRxPanel;
    private JPanel remotePanel;
    private JPanel remoteTxPanel;
    private JPanel remoteRxPanel;
    private INodeModel shelfNode;
    private boolean shelfMode = false;
    private boolean isProtected = false;
    private boolean protectMode = false;
    private YCableCacheBundle yCableCache = null;
    private static final Dimension JLIST_DIM = new Dimension(145, 170);
    private static final String TITLE = "Create Provisionable Patchcord";
    private static final String ORIG_NODE = "Origination Node";
    private static final String TERM_NODE = "Termination Node";
    private static final String PROVISION_PEER_QUESTION = "Endpoints of this provisionable patchcord are members of a protection group.\nWould you like to provision its peer patchcord?";
    private static final int SHELFID_NOT_SELECTED = -1;
    VirtualLinksDirector vld;
    protected static final SDebug db = new SDebug("VirtualLinkCreationDialog");

    public static VirtualLinkCreationDialog instance(VirtualLinkPane virtualLinkPane, Object object) {
        Frame frame = JOptionPane.getFrameForComponent((Component)((Object)virtualLinkPane));
        return new VirtualLinkCreationDialog(frame, TITLE, object);
    }

    protected VirtualLinkCreationDialog(Frame frame, String string, Object object) {
        super(frame, string, true, object);
    }

    protected void initContentPane(JPanel jPanel, Object object) {
        Object object2;
        this.vld = VirtualLinksDirector.instance();
        if (object != null && (object2 = (Object[])object)[0] instanceof Boolean) {
            this.shelfMode = (Boolean)object2[0];
            if (object2[1] instanceof INodeModel) {
                this.shelfNode = (INodeModel)object2[1];
            }
        }
        this.setSize(new Dimension(300, 300));
        object2 = new JPanel(new BorderLayout());
        ((Container)object2).add((Component)this.getLocalPanel(), "West");
        ((Container)object2).add((Component)this.getRemotePanel(), "East");
        jPanel.add((Component)object2, "Center");
        jPanel.add((Component)this.getButtonPanel(), "South");
        this.vld.addObserver(this);
        ActionEvent actionEvent = new ActionEvent(this.localNodeCB, 1, "changed");
        this.actionPerformed(actionEvent);
        ActionEvent actionEvent2 = new ActionEvent(this.remoteNodeCB, 1, "changed");
        this.actionPerformed(actionEvent2);
    }

    protected JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel(new FlowLayout(1, 5, 5));
        this.okButton = this.makeActionButton("OK");
        jPanel2.add(this.okButton);
        this.okButton.setEnabled(false);
        this.cancelButton = this.makeActionButton("Cancel");
        jPanel2.add(this.cancelButton);
        this.separateTxRxCB = new JCheckBox("Separate TX/RX");
        this.separateTxRxCB.addActionListener(this);
        jPanel2.add(this.separateTxRxCB);
        jPanel.add(jPanel2);
        return jPanel;
    }

    protected JPanel getLocalPanel() {
        Object object;
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(ORIG_NODE));
        JPanel jPanel2 = new JPanel(new GridLayout(2, 1));
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 5, 5));
        INodeModel[] iNodeModelArray = this.vld.getKnownNodes();
        this.localNodeCB = new JComboBox<INodeModel>(iNodeModelArray);
        this.localNodeCB.setEditable(true);
        this.localNodeCB.setRenderer(new NMCellRenderer());
        this.localNodeCE = new NMCellEditor(iNodeModelArray[0]);
        this.localNodeCB.setEditor(this.localNodeCE);
        if (this.shelfMode) {
            for (int i = 0; i < this.localNodeCB.getItemCount(); ++i) {
                object = (INodeModel)this.localNodeCB.getItemAt(i);
                if (object.getNodeId() != this.shelfNode.getNodeId()) continue;
                this.localNodeCB.setSelectedItem(object);
                break;
            }
            this.localNodeCB.setEnabled(false);
        }
        this.localNodeCB.addActionListener(this);
        jPanel3.add(this.localNodeCB);
        JPanel jPanel4 = new JPanel(new FlowLayout(0, 5, 5));
        this.localTxComboModel = new DefaultComboBoxModel();
        this.localTxShelfCombo = new JComboBox(this.localTxComboModel);
        this.localTxShelfCombo.setPreferredSize(new Dimension(50, 20));
        this.localTxShelfCombo.setRenderer(new NMCellRenderer());
        this.localRxComboModel = new DefaultComboBoxModel();
        this.localRxShelfCombo = new JComboBox(this.localRxComboModel);
        this.localRxShelfCombo.setPreferredSize(new Dimension(50, 20));
        this.localRxShelfCombo.setRenderer(new NMCellRenderer());
        this.localTxShelfLabel = new JLabel("Shelf: Tx");
        this.localRxShelfLabel = new JLabel("Shelf: Rx");
        jPanel4.add(this.localTxShelfLabel);
        jPanel4.add(this.localTxShelfCombo);
        jPanel4.add(this.localRxShelfLabel);
        jPanel4.add(this.localRxShelfCombo);
        this.localTxShelfLabel.setVisible(false);
        this.localRxShelfLabel.setVisible(false);
        this.localTxShelfCombo.setVisible(false);
        this.localRxShelfCombo.setVisible(false);
        this.localTxPanel = VirtualLinkCreationDialog.createVerticalPanel("TX/RX");
        object = new JPanel(new FlowLayout(0, 5, 5));
        ((Container)object).add(new JLabel("ID: "));
        this.localTxVLIDTF = new DigitTextField(10);
        this.localTxVLIDTF.getDocument().addDocumentListener(this);
        ((Container)object).add(this.localTxVLIDTF);
        this.localTxPanel.add((Component)object);
        this.localTxPanel.add(Box.createVerticalGlue());
        this.localTxPanel.add(this.getLocalTxListPanel());
        this.localRxPanel = VirtualLinkCreationDialog.createVerticalPanel("RX");
        object = new JPanel(new FlowLayout(0, 5, 5));
        ((Container)object).add(new JLabel("ID: "));
        this.localRxVLIDTF = new DigitTextField(10);
        this.localRxVLIDTF.getDocument().addDocumentListener(this);
        ((Container)object).add(this.localRxVLIDTF);
        this.localRxPanel.add((Component)object);
        this.localRxPanel.add(Box.createVerticalGlue());
        this.localRxPanel.add(this.getLocalRxListPanel());
        this.localPanel = VirtualLinkCreationDialog.createHorizontalPanel(null);
        this.localPanel.add(this.localTxPanel);
        jPanel2.add(jPanel3);
        jPanel2.add(jPanel4);
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)this.localPanel, "Center");
        this.localTxShelfCombo.addItemListener(this.getChassisItemListener(this.localTxShelfCombo));
        this.localRxShelfCombo.addItemListener(this.getChassisItemListener(this.localRxShelfCombo));
        return jPanel;
    }

    protected JPanel getRemotePanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(TERM_NODE));
        JPanel jPanel2 = new JPanel(new GridLayout(2, 1));
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 5, 5));
        INodeModel[] iNodeModelArray = this.vld.getKnownNodes();
        this.remoteNodeCB = new JComboBox<INodeModel>(iNodeModelArray);
        this.remoteNodeCB.setEditable(true);
        this.remoteNodeCB.setRenderer(new NMCellRenderer());
        this.remoteNodeCE = new NMCellEditor(iNodeModelArray[0]);
        this.remoteNodeCB.setEditor(this.remoteNodeCE);
        this.remoteNodeCB.addActionListener(this);
        jPanel3.add(this.remoteNodeCB);
        JPanel jPanel4 = new JPanel(new FlowLayout(0, 5, 5));
        this.remoteTxComboModel = new DefaultComboBoxModel();
        this.remoteTxShelfCombo = new JComboBox(this.remoteTxComboModel);
        this.remoteTxShelfCombo.setPreferredSize(new Dimension(50, 20));
        this.remoteTxShelfCombo.setRenderer(new NMCellRenderer());
        this.remoteRxComboModel = new DefaultComboBoxModel();
        this.remoteRxShelfCombo = new JComboBox(this.remoteRxComboModel);
        this.remoteRxShelfCombo.setPreferredSize(new Dimension(50, 20));
        this.remoteRxShelfCombo.setRenderer(new NMCellRenderer());
        this.remoteTxShelfLabel = new JLabel("Shelf: Tx");
        this.remoteRxShelfLabel = new JLabel("Shelf: Rx");
        this.remoteTxShelfLabel.setVisible(false);
        this.remoteTxShelfCombo.setVisible(false);
        this.remoteRxShelfCombo.setVisible(false);
        jPanel4.add(this.remoteTxShelfLabel);
        jPanel4.add(this.remoteTxShelfCombo);
        jPanel4.add(this.remoteRxShelfLabel);
        jPanel4.add(this.remoteRxShelfCombo);
        this.remoteTxPanel = VirtualLinkCreationDialog.createVerticalPanel("TX/RX");
        JPanel jPanel5 = new JPanel(new FlowLayout(0, 5, 5));
        jPanel5.add(new JLabel("ID: "));
        this.remoteTxVLIDTF = new DigitTextField(10);
        this.remoteTxVLIDTF.getDocument().addDocumentListener(this);
        jPanel5.add(this.remoteTxVLIDTF);
        this.remoteTxPanel.add(jPanel5);
        this.remoteTxPanel.add(Box.createVerticalGlue());
        this.remoteTxPanel.add(this.getRemoteTxListPanel());
        this.remoteRxPanel = VirtualLinkCreationDialog.createVerticalPanel("RX");
        jPanel5 = new JPanel(new FlowLayout(0, 5, 5));
        jPanel5.add(new JLabel("ID: "));
        this.remoteRxVLIDTF = new DigitTextField(10);
        this.remoteRxVLIDTF.getDocument().addDocumentListener(this);
        jPanel5.add(this.remoteRxVLIDTF);
        this.remoteRxPanel.add(jPanel5);
        this.remoteRxPanel.add(Box.createVerticalGlue());
        this.remoteRxPanel.add(this.getRemoteRxListPanel());
        this.remotePanel = VirtualLinkCreationDialog.createHorizontalPanel(null);
        this.remotePanel.add(this.remoteTxPanel);
        jPanel2.add(jPanel3);
        jPanel2.add(jPanel4);
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)this.remotePanel, "Center");
        this.remoteTxShelfCombo.addItemListener(this.getChassisItemListener(this.remoteTxShelfCombo));
        this.remoteRxShelfCombo.addItemListener(this.getChassisItemListener(this.remoteRxShelfCombo));
        return jPanel;
    }

    private ItemListener getChassisItemListener(JComboBox jComboBox) {
        return new ChassisItemListener(jComboBox);
    }

    private JComponent getLocalTxListPanel() {
        this.localTxVLModel = new DefaultListModel();
        this.localTxTermList = new JList(this.localTxVLModel);
        this.localTxTermList.setVisibleRowCount(10);
        this.localTxTermList.setSelectionMode(0);
        this.localTxTermList.addListSelectionListener(this);
        this.localTxTermList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && !VirtualLinkCreationDialog.this.separateTxRxCB.isSelected() && VirtualLinkCreationDialog.this.localTxTermList.getSelectedValue() != null) {
                    VirtualLinkCreationDialog.this.ok();
                }
            }
        });
        UScrollPane uScrollPane = new UScrollPane((Component)this.localTxTermList);
        uScrollPane.setPreferredSize(JLIST_DIM);
        return uScrollPane;
    }

    private JComponent getLocalRxListPanel() {
        this.localRxVLModel = new DefaultListModel();
        this.localRxTermList = new JList(this.localRxVLModel);
        this.localRxTermList.setVisibleRowCount(10);
        this.localRxTermList.setSelectionMode(0);
        this.localRxTermList.addListSelectionListener(this);
        this.localRxTermList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && VirtualLinkCreationDialog.this.localTxTermList.getSelectedValue() != null && VirtualLinkCreationDialog.this.localRxTermList.getSelectedValue() != null) {
                    VirtualLinkCreationDialog.this.ok();
                }
            }
        });
        UScrollPane uScrollPane = new UScrollPane((Component)this.localRxTermList);
        uScrollPane.setPreferredSize(JLIST_DIM);
        return uScrollPane;
    }

    private JComponent getRemoteTxListPanel() {
        this.remoteTxVLModel = new DefaultListModel();
        this.remoteTxTermList = new JList(this.remoteTxVLModel);
        this.remoteTxTermList.setVisibleRowCount(10);
        this.remoteTxTermList.setSelectionMode(0);
        this.remoteTxTermList.addListSelectionListener(this);
        this.remoteTxTermList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && !VirtualLinkCreationDialog.this.separateTxRxCB.isSelected() && VirtualLinkCreationDialog.this.remoteTxTermList.getSelectedValue() != null) {
                    VirtualLinkCreationDialog.this.ok();
                }
            }
        });
        UScrollPane uScrollPane = new UScrollPane((Component)this.remoteTxTermList);
        uScrollPane.setPreferredSize(JLIST_DIM);
        return uScrollPane;
    }

    private JComponent getRemoteRxListPanel() {
        this.remoteRxVLModel = new DefaultListModel();
        this.remoteRxTermList = new JList(this.remoteRxVLModel);
        this.remoteRxTermList.setVisibleRowCount(10);
        this.remoteRxTermList.setSelectionMode(0);
        this.remoteRxTermList.addListSelectionListener(this);
        this.remoteRxTermList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && VirtualLinkCreationDialog.this.remoteTxTermList.getSelectedValue() != null && VirtualLinkCreationDialog.this.remoteRxTermList.getSelectedValue() != null) {
                    VirtualLinkCreationDialog.this.ok();
                }
            }
        });
        UScrollPane uScrollPane = new UScrollPane((Component)this.remoteRxTermList);
        uScrollPane.setPreferredSize(JLIST_DIM);
        return uScrollPane;
    }

    public void update(Observable observable, Object object) {
        if (observable == this.vld && object == ModelUpdateType.CHANGED) {
            Object object2;
            INodeModel iNodeModel;
            int n;
            ArrayList<INodeModel> arrayList = new ArrayList<INodeModel>(Arrays.asList(this.vld.getKnownNodes()));
            if (!this.shelfMode) {
                for (n = 0; n < this.localNodeCB.getItemCount(); ++n) {
                    iNodeModel = (INodeModel)this.localNodeCB.getItemAt(n);
                    if (!arrayList.contains(iNodeModel)) continue;
                    arrayList.remove(iNodeModel);
                }
                if (!arrayList.isEmpty()) {
                    Object object3 = arrayList.iterator();
                    while (object3.hasNext()) {
                        iNodeModel = object3.next();
                        this.localNodeCB.addItem(iNodeModel);
                        object2 = this.localNodeCE.getItem();
                        if (!(object2 instanceof String) || !iNodeModel.getName().equals((String)object2) && !iNodeModel.getHostName().equals((String)object2)) continue;
                        this.localNodeCE.setItem(iNodeModel);
                    }
                    object3 = new ActionEvent(this.localNodeCB, 1, "changed");
                    this.actionPerformed((ActionEvent)object3);
                }
            }
            arrayList = new ArrayList<INodeModel>(Arrays.asList(this.vld.getKnownNodes()));
            for (n = 0; n < this.remoteNodeCB.getItemCount(); ++n) {
                iNodeModel = (INodeModel)this.remoteNodeCB.getItemAt(n);
                if (!arrayList.contains(iNodeModel)) continue;
                arrayList.remove(iNodeModel);
            }
            if (!arrayList.isEmpty()) {
                Object object4 = arrayList.iterator();
                while (object4.hasNext()) {
                    iNodeModel = object4.next();
                    this.remoteNodeCB.addItem(iNodeModel);
                    object2 = this.remoteNodeCE.getItem();
                    if (!(object2 instanceof String) || !iNodeModel.getName().equals((String)object2) && !iNodeModel.getHostName().equals((String)object2)) continue;
                    this.remoteNodeCE.setItem(iNodeModel);
                }
                object4 = new ActionEvent(this.remoteNodeCB, 1, "changed");
                this.actionPerformed((ActionEvent)object4);
            }
        }
    }

    public void setShelfMode(INodeModel iNodeModel) {
        this.shelfNode = iNodeModel;
        this.shelfMode = true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        db.fine("actionPerformed from " + object);
        if (object == this.okButton) {
            this.ok();
        } else if (object == this.cancelButton) {
            this.dispose();
        } else if (object == this.separateTxRxCB) {
            final boolean bl = this.separateTxRxCB.isSelected();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (bl) {
                        VirtualLinkCreationDialog.this.localTxPanel.setBorder(BorderFactory.createTitledBorder("TX"));
                        VirtualLinkCreationDialog.this.remoteTxPanel.setBorder(BorderFactory.createTitledBorder("TX"));
                        VirtualLinkCreationDialog.this.localPanel.add(VirtualLinkCreationDialog.this.localRxPanel);
                        VirtualLinkCreationDialog.this.remotePanel.add(VirtualLinkCreationDialog.this.remoteRxPanel);
                        VirtualLinkCreationDialog.this.setLocalShelfVisible(((INodeModel)VirtualLinkCreationDialog.this.localNodeCE.getItem()).isMultishelf());
                        VirtualLinkCreationDialog.this.setRemoteShelfVisible(((INodeModel)VirtualLinkCreationDialog.this.remoteNodeCE.getItem()).isMultishelf());
                    } else {
                        VirtualLinkCreationDialog.this.localTxPanel.setBorder(BorderFactory.createTitledBorder("TX/RX"));
                        VirtualLinkCreationDialog.this.remoteTxPanel.setBorder(BorderFactory.createTitledBorder("TX/RX"));
                        VirtualLinkCreationDialog.this.localPanel.remove(VirtualLinkCreationDialog.this.localRxPanel);
                        VirtualLinkCreationDialog.this.remotePanel.remove(VirtualLinkCreationDialog.this.remoteRxPanel);
                        VirtualLinkCreationDialog.this.setLocalShelfVisible(((INodeModel)VirtualLinkCreationDialog.this.localNodeCE.getItem()).isMultishelf());
                        VirtualLinkCreationDialog.this.setRemoteShelfVisible(((INodeModel)VirtualLinkCreationDialog.this.remoteNodeCE.getItem()).isMultishelf());
                    }
                    VirtualLinkCreationDialog.this.updateListModels(bl);
                    VirtualLinkCreationDialog.this.pack();
                    VirtualLinkCreationDialog.this.center();
                }
            });
        } else if (object == this.localNodeCB) {
            this.localTxVLModel.removeAllElements();
            this.localRxVLModel.removeAllElements();
            Object object2 = this.localNodeCE.getItem();
            if (object2 instanceof String && actionEvent.getActionCommand().equals("comboBoxEdited")) {
                String string = (String)object2;
                final INodeModel iNodeModel = this.vld.getNodeModelFromString(string);
                if (iNodeModel != null) {
                    if (db.on()) {
                        db.println("Node " + string + " already in nodes list - Just select it");
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            VirtualLinkCreationDialog.this.localNodeCB.setSelectedItem(iNodeModel);
                        }
                    });
                    return;
                }
                if (db.on()) {
                    db.println("Trying to add node " + string);
                }
                try {
                    this.vld.addNode(string);
                    CerentDialog.infoDialog((Component)((Object)this), (String)("Attempting to add " + string + ". This may take several minutes."), (String)("Adding " + string));
                }
                catch (UnknownHostException unknownHostException) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_ERROR_ADDING_UNKNOWN_HOST_PARAM_1, (Object)string);
                }
            } else if (object2 instanceof INodeModel) {
                IEntityModel iEntityModel;
                INodeModel iNodeModel = (INodeModel)object2;
                int n = -1;
                if (this.isMSNode(iNodeModel)) {
                    Object e;
                    this.setLocalShelfVisible(true);
                    iEntityModel = this.vld.getKnownShelfIds(iNodeModel);
                    this.updateShelfList((Integer[])iEntityModel, this.localTxComboModel);
                    this.updateShelfList((Integer[])iEntityModel, this.localRxComboModel);
                    Object e2 = this.localTxShelfCombo.getItemAt(0);
                    if (e2 != null) {
                        this.localTxShelfCombo.setSelectedItem(e2);
                        n = (Integer)e2;
                    }
                    if ((e = this.localRxShelfCombo.getItemAt(0)) != null) {
                        this.localRxShelfCombo.setSelectedItem(e);
                        if (n < 0) {
                            n = (Integer)e;
                        }
                    }
                } else {
                    this.setLocalShelfVisible(false);
                }
                this.localTxVLModel.removeAllElements();
                this.localRxVLModel.removeAllElements();
                this.updateListModel(this.separateTxRxCB.isSelected(), this.localTxVLModel, this.localRxVLModel, n, iNodeModel);
                if (this.localTxTermList.getModel().getSize() > 0) {
                    this.localTxTermList.setSelectedIndex(0);
                    iEntityModel = (IEntityModel)this.localTxTermList.getSelectedValue();
                    this.localTxTermList.setCellRenderer(ElementFactoryFinder.getElementFactory(iNodeModel).createEntityCellRenderer(iNodeModel, "slot "));
                    this.localRxTermList.setCellRenderer(ElementFactoryFinder.getElementFactory(iNodeModel).createEntityCellRenderer(iNodeModel, "slot "));
                }
            }
        } else if (object == this.remoteNodeCB) {
            this.remoteTxVLModel.removeAllElements();
            this.remoteRxVLModel.removeAllElements();
            Object object3 = this.remoteNodeCE.getItem();
            if (object3 instanceof String && actionEvent.getActionCommand().equals("comboBoxEdited")) {
                String string = (String)object3;
                final INodeModel iNodeModel = this.vld.getNodeModelFromString(string);
                if (iNodeModel != null) {
                    if (db.on()) {
                        db.println("Node " + string + " already in nodes list - Just select it");
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            VirtualLinkCreationDialog.this.remoteNodeCB.setSelectedItem(iNodeModel);
                        }
                    });
                    return;
                }
                if (db.on()) {
                    db.println("Trying to add node " + string);
                }
                try {
                    this.vld.addNode(string);
                    CerentDialog.infoDialog((Component)((Object)this), (String)("Attempting to add " + string + ". This may take several minutes."), (String)("Adding " + string));
                }
                catch (UnknownHostException unknownHostException) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_ERROR_ADDING_UNKNOWN_HOST_PARAM_1, (Object)string);
                }
            } else if (object3 instanceof INodeModel) {
                IEntityModel iEntityModel;
                INodeModel iNodeModel = (INodeModel)object3;
                int n = -1;
                if (this.isMSNode(iNodeModel)) {
                    this.setRemoteShelfVisible(true);
                    iEntityModel = this.vld.getKnownShelfIds(iNodeModel);
                    this.updateShelfList((Integer[])iEntityModel, this.remoteTxComboModel);
                    this.updateShelfList((Integer[])iEntityModel, this.remoteRxComboModel);
                    Object e = this.remoteTxShelfCombo.getItemAt(0);
                    Object e3 = this.remoteRxShelfCombo.getItemAt(0);
                    if (e != null) {
                        this.remoteTxShelfCombo.setSelectedItem(e);
                        n = (Integer)e;
                    }
                    if (e3 != null) {
                        this.remoteRxShelfCombo.setSelectedItem(e3);
                        if (n < 0) {
                            n = (Integer)e3;
                        }
                    }
                } else {
                    this.setRemoteShelfVisible(false);
                }
                this.remoteTxVLModel.removeAllElements();
                this.remoteRxVLModel.removeAllElements();
                this.updateListModel(this.separateTxRxCB.isSelected(), this.remoteTxVLModel, this.remoteRxVLModel, n, iNodeModel);
                if (this.remoteTxTermList.getModel().getSize() > 0) {
                    this.remoteTxTermList.setSelectedIndex(0);
                    iEntityModel = (IEntityModel)this.remoteTxTermList.getSelectedValue();
                    this.remoteTxTermList.setCellRenderer(ElementFactoryFinder.getElementFactory(iNodeModel).createEntityCellRenderer(iNodeModel, "slot "));
                    this.remoteRxTermList.setCellRenderer(ElementFactoryFinder.getElementFactory(iNodeModel).createEntityCellRenderer(iNodeModel, "slot "));
                }
            }
        }
    }

    private void setLocalShelfVisible(boolean bl) {
        this.localTxShelfCombo.setVisible(bl);
        if (this.separateTxRxCB.isSelected()) {
            this.localTxShelfLabel.setText("Shelf: Tx");
        } else {
            this.localTxShelfLabel.setText("Shelf: ");
        }
        this.localTxShelfLabel.setVisible(bl);
        if (this.separateTxRxCB.isSelected()) {
            this.localRxShelfCombo.setVisible(bl);
            this.localRxShelfLabel.setVisible(bl);
        } else {
            this.localRxShelfCombo.setVisible(false);
            this.localRxShelfLabel.setVisible(false);
        }
    }

    private void setRemoteShelfVisible(boolean bl) {
        this.remoteTxShelfCombo.setVisible(bl);
        if (this.separateTxRxCB.isSelected()) {
            this.remoteTxShelfLabel.setText("Shelf: Tx");
        } else {
            this.remoteTxShelfLabel.setText("Shelf: ");
        }
        this.remoteTxShelfLabel.setVisible(bl);
        if (this.separateTxRxCB.isSelected()) {
            this.remoteRxShelfCombo.setVisible(bl);
            this.remoteRxShelfLabel.setVisible(bl);
        } else {
            this.remoteRxShelfCombo.setVisible(false);
            this.remoteRxShelfLabel.setVisible(false);
        }
    }

    private void updateOk() {
        boolean bl = (this.localTxTermList.getSelectionModel().isSelectionEmpty() || this.remoteTxTermList.getSelectionModel().isSelectionEmpty()) && !this.separateTxRxCB.isSelected() || (this.localTxTermList.getSelectionModel().isSelectionEmpty() || this.localRxTermList.getSelectionModel().isSelectionEmpty() || this.remoteRxTermList.getSelectionModel().isSelectionEmpty() || this.remoteTxTermList.getSelectionModel().isSelectionEmpty()) && this.separateTxRxCB.isSelected();
        boolean bl2 = !this.separateTxRxCB.isSelected() && this.localTxVLIDTF.getText().compareTo("") != 0 && this.remoteTxVLIDTF.getText().compareTo("") != 0 || this.separateTxRxCB.isSelected() && this.localTxVLIDTF.getText().compareTo("") != 0 && this.remoteTxVLIDTF.getText().compareTo("") != 0 && this.localRxVLIDTF.getText().compareTo("") != 0 && this.remoteRxVLIDTF.getText().compareTo("") != 0;
        this.okButton.setEnabled(!bl && bl2);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateOk();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateOk();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateOk();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            Object object = listSelectionEvent.getSource();
            this.updateOk();
            if (!this.separateTxRxCB.isSelected()) {
                try {
                    IEntityModel iEntityModel = (IEntityModel)this.localTxTermList.getSelectedValue();
                    IEntityModel iEntityModel2 = (IEntityModel)this.remoteTxTermList.getSelectedValue();
                    if (iEntityModel != null && (iEntityModel.getEqType() == 139 || iEntityModel.getEqType() == 141) || iEntityModel2 != null && (iEntityModel2.getEqType() == 139 || iEntityModel2.getEqType() == 141)) {
                        this.separateTxRxCB.setSelected(true);
                        ActionEvent actionEvent = new ActionEvent(this.separateTxRxCB, 1, "changed");
                        this.actionPerformed(actionEvent);
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    SDebug.printStackTrace((Throwable)arrayIndexOutOfBoundsException);
                }
            } else {
                try {
                    IEntityModel iEntityModel = (IEntityModel)this.localTxTermList.getSelectedValue();
                    IEntityModel iEntityModel3 = (IEntityModel)this.localRxTermList.getSelectedValue();
                    IEntityModel iEntityModel4 = (IEntityModel)this.remoteTxTermList.getSelectedValue();
                    IEntityModel iEntityModel5 = (IEntityModel)this.remoteRxTermList.getSelectedValue();
                    if (object == this.localTxTermList) {
                        if (iEntityModel != null && iEntityModel.getEqType() != 139 && iEntityModel.getEqType() != 141 && iEntityModel != iEntityModel3) {
                            this.localRxTermList.setSelectedValue(iEntityModel, true);
                        }
                    } else if (object == this.localRxTermList) {
                        if (iEntityModel3 != null && iEntityModel3.getEqType() != 139 && iEntityModel3.getEqType() != 141 && iEntityModel3 != iEntityModel) {
                            this.localTxTermList.setSelectedValue(iEntityModel3, true);
                        }
                    } else if (object == this.remoteTxTermList) {
                        if (iEntityModel4 != null && iEntityModel4.getEqType() != 139 && iEntityModel4.getEqType() != 141 && iEntityModel4 != iEntityModel5) {
                            this.remoteRxTermList.setSelectedValue(iEntityModel4, true);
                        }
                    } else if (object == this.remoteRxTermList) {
                        if (iEntityModel5 != null && iEntityModel5.getEqType() != 139 && iEntityModel5.getEqType() != 141 && iEntityModel5 != iEntityModel4) {
                            this.remoteTxTermList.setSelectedValue(iEntityModel5, true);
                        }
                    } else {
                        db.severe("Error in valueChanged, unknown src: " + object);
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    SDebug.printStackTrace((Throwable)arrayIndexOutOfBoundsException);
                }
            }
        }
        this.updateSeparateCBState();
    }

    public void dispose() {
        this.vld.deleteObserver(this);
        ((DefaultListModel)this.localTxTermList.getModel()).removeAllElements();
        ((DefaultListModel)this.localRxTermList.getModel()).removeAllElements();
        ((DefaultListModel)this.remoteTxTermList.getModel()).removeAllElements();
        ((DefaultListModel)this.remoteRxTermList.getModel()).removeAllElements();
        this.protectMode = false;
        this.isProtected = false;
        this.yCableCache = null;
        super.dispose();
    }

    protected JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }

    protected void ok() {
        boolean bl = true;
        IEntityModel iEntityModel = (IEntityModel)this.localTxTermList.getSelectedValue();
        IEntityModel iEntityModel2 = (IEntityModel)this.remoteTxTermList.getSelectedValue();
        IEntityModel iEntityModel3 = this.separateTxRxCB.isSelected() ? (IEntityModel)this.localRxTermList.getSelectedValue() : null;
        IEntityModel iEntityModel4 = this.separateTxRxCB.isSelected() ? (IEntityModel)this.remoteRxTermList.getSelectedValue() : null;
        try {
            if (this.separateTxRxCB.isSelected() && iEntityModel == iEntityModel3 && iEntityModel2 == iEntityModel4) {
                if (db.on()) {
                    db.println("The user selected ports which are not unidirectional.\nDe-selecting the 'Separate Tx/Rx' check-box and continuing.");
                }
                this.separateTxRxCB.setSelected(false);
            }
            short s = Short.parseShort(this.localTxVLIDTF.getText());
            short s2 = Short.parseShort(this.remoteTxVLIDTF.getText());
            short s3 = this.separateTxRxCB.isSelected() ? (short)Short.parseShort(this.localRxVLIDTF.getText()) : (short)-1;
            short s4 = this.separateTxRxCB.isSelected() ? (short)Short.parseShort(this.remoteRxVLIDTF.getText()) : (short)-1;
            INodeModel iNodeModel = (INodeModel)this.localNodeCB.getSelectedItem();
            INodeModel iNodeModel2 = (INodeModel)this.remoteNodeCB.getSelectedItem();
            try {
                VirtualLinksDirector.sanityCheck(iNodeModel, s, s3, iEntityModel, iEntityModel3, iNodeModel2, s2, s4, iEntityModel2, iEntityModel4);
            }
            catch (WarningMessageException warningMessageException) {
                CerentDialog.warningDialog((Component)((Object)this), (String)warningMessageException.getMessage());
            }
            if (this.vld.isProtected(iEntityModel) != null || this.vld.isProtected(iEntityModel2) != null) {
                this.isProtected = true;
            }
            this.vld.createVirtualLink(s, iNodeModel, iEntityModel, s2, iNodeModel2);
            bl = false;
            this.vld.createVirtualLink(s2, iNodeModel2, iEntityModel2, s, iNodeModel);
            if (this.separateTxRxCB.isSelected()) {
                this.vld.createVirtualLink(s3, iNodeModel, iEntityModel3, s4, iNodeModel2);
                this.vld.createVirtualLink(s4, iNodeModel2, iEntityModel4, s3, iNodeModel);
            }
            if (!this.protectMode && this.isProtected && CerentDialog.yesNoDialog((Component)((Object)this), (String)PROVISION_PEER_QUESTION, (String)"Provision Peer Patchcord", (int)0)) {
                IEntityModel iEntityModel5;
                ActionEvent actionEvent = new ActionEvent(this.localNodeCB, 1, "changed");
                this.actionPerformed(actionEvent);
                ActionEvent actionEvent2 = new ActionEvent(this.remoteNodeCB, 1, "changed");
                this.actionPerformed(actionEvent2);
                short s5 = (short)Math.max(s, Math.max(s2, Math.max(s3, s4)));
                short s6 = this.vld.obtainUnusedVLID((INodeModel)this.localNodeCB.getSelectedItem(), s5);
                this.localTxVLIDTF.setText(Short.toString(s6));
                s6 = this.vld.obtainUnusedVLID((INodeModel)this.remoteNodeCB.getSelectedItem(), s6);
                this.remoteTxVLIDTF.setText(Short.toString(s6));
                if (this.separateTxRxCB.isSelected()) {
                    s6 = this.vld.obtainUnusedVLID((INodeModel)this.localNodeCB.getSelectedItem(), s6);
                    this.localRxVLIDTF.setText(Short.toString(s6));
                    s6 = this.vld.obtainUnusedVLID((INodeModel)this.remoteNodeCB.getSelectedItem(), s6);
                    this.remoteRxVLIDTF.setText(Short.toString(s6));
                }
                if ((iEntityModel5 = this.vld.isProtected(iEntityModel)) != null && this.localTxTermList.getModel().getSize() > 0) {
                    this.localTxTermList.setSelectedValue(iEntityModel5, true);
                    if (this.vld.isYCableProtected(iEntityModel) != null) {
                        this.yCableCache = new YCableCacheBundle(iEntityModel2, this.remoteTxTermList);
                    }
                }
                if ((iEntityModel5 = this.vld.isProtected(iEntityModel2)) != null && this.remoteTxTermList.getModel().getSize() > 0) {
                    this.remoteTxTermList.setSelectedValue(iEntityModel5, true);
                    if (this.vld.isYCableProtected(iEntityModel2) != null) {
                        this.yCableCache = new YCableCacheBundle(iEntityModel, this.localTxTermList);
                    }
                }
                this.protectMode = true;
                this.updateListModels(this.separateTxRxCB.isSelected());
            } else {
                this.dispose();
            }
        }
        catch (NoSuchInterface noSuchInterface) {
            this.rollback();
            SDebug.printStackTrace((Throwable)noSuchInterface);
            INodeModel iNodeModel = (INodeModel)this.localNodeCB.getSelectedItem();
            String string = ElementFactoryFinder.getElementFactory(iNodeModel).createEntityCellRenderer(iEntityModel.getModuleModel()).getString((Object)iEntityModel, "slot ");
            if (!bl) {
                string = ElementFactoryFinder.getElementFactory(iNodeModel).createEntityCellRenderer(iEntityModel2.getModuleModel()).getString((Object)iEntityModel2, "slot ");
                iNodeModel = (INodeModel)this.remoteNodeCB.getSelectedItem();
            }
            ErrorMsg.displayDetailed((Component)((Object)this), NEMC.EID_NO_SUCHINTERFACE, noSuchInterface.getMessage() + ". Cannot find " + string + " on " + iNodeModel.getName());
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            this.rollback();
            SDebug.printStackTrace((Throwable)wrongInterfaceType);
            INodeModel iNodeModel = (INodeModel)this.localNodeCB.getSelectedItem();
            String string = ElementFactoryFinder.getElementFactory(iNodeModel).createEntityCellRenderer(iEntityModel.getModuleModel()).getString((Object)iEntityModel, "slot ");
            if (!bl) {
                string = ElementFactoryFinder.getElementFactory(iNodeModel).createEntityCellRenderer(iEntityModel2.getModuleModel()).getString((Object)iEntityModel2, "slot ");
                iNodeModel = (INodeModel)this.remoteNodeCB.getSelectedItem();
            }
            ErrorMsg.displayDetailed((Component)((Object)this), NEMC.EID_WRONG_INTERFACE_TYPE, wrongInterfaceType.getMessage() + ". " + string + " on " + iNodeModel.getName() + " is not of the correct type.");
        }
        catch (ProvisionError provisionError) {
            this.rollback();
            SDebug.printStackTrace((Throwable)provisionError);
            INodeModel iNodeModel = (INodeModel)this.localNodeCB.getSelectedItem();
            String string = ElementFactoryFinder.getElementFactory(iNodeModel).createEntityCellRenderer(iEntityModel.getModuleModel()).getString((Object)iEntityModel, "slot ");
            if (!bl) {
                string = ElementFactoryFinder.getElementFactory(iNodeModel).createEntityCellRenderer(iEntityModel2.getModuleModel()).getString((Object)iEntityModel2, "slot ");
                iNodeModel = (INodeModel)this.remoteNodeCB.getSelectedItem();
            }
            ErrorMsg.displayDetailed((Component)((Object)this), NEMC.EID_PROVISION_ERROR, provisionError.getMessage() + ". Unable to provision patchcord on " + string + " at node " + iNodeModel.getName());
        }
        catch (EndPointInUse endPointInUse) {
            this.rollback();
            SDebug.printStackTrace((Throwable)endPointInUse);
            INodeModel iNodeModel = (INodeModel)this.localNodeCB.getSelectedItem();
            String string = ElementFactoryFinder.getElementFactory(iNodeModel).createEntityCellRenderer(iEntityModel.getModuleModel()).getString((Object)iEntityModel, "slot ");
            if (!bl) {
                string = ElementFactoryFinder.getElementFactory(iNodeModel).createEntityCellRenderer(iEntityModel2.getModuleModel()).getString((Object)iEntityModel2, "slot ");
                iNodeModel = (INodeModel)this.remoteNodeCB.getSelectedItem();
            }
            ErrorMsg.displayDetailed((Component)((Object)this), NEMC.EID_END_POINT_INUSE, endPointInUse.getMessage() + ". The endpoint, " + string + " on node " + iNodeModel.getName() + " is already in use.");
        }
        catch (FeatureUnsupported featureUnsupported) {
            this.rollback();
            SDebug.printStackTrace((Throwable)featureUnsupported);
            INodeModel iNodeModel = (INodeModel)this.localNodeCB.getSelectedItem();
            if (!bl) {
                iNodeModel = (INodeModel)this.remoteNodeCB.getSelectedItem();
            }
            ErrorMsg.displayDetailed((Component)((Object)this), NEMC.EID_UNSUPPORTED_OPERATION, featureUnsupported.getMessage() + ". The node " + iNodeModel.getName() + " does not support provisionable patchcords.");
        }
        catch (UnknownHostException unknownHostException) {
            this.rollback();
            SDebug.printStackTrace((Throwable)unknownHostException);
            INodeModel iNodeModel = (INodeModel)this.localNodeCB.getSelectedItem();
            if (!bl) {
                iNodeModel = (INodeModel)this.remoteNodeCB.getSelectedItem();
            }
            ErrorMsg.displayDetailed((Component)((Object)this), NEMC.EID_UNABLE_TO_LOCATE_HOST, unknownHostException.getMessage() + ". The node " + iNodeModel.getName() + " does not exist.");
        }
        catch (DuplicateLocalVlinkId duplicateLocalVlinkId) {
            this.rollback();
            SDebug.printStackTrace((Throwable)duplicateLocalVlinkId);
            short s = -1;
            INodeModel iNodeModel = null;
            EID eID = null;
            if (bl) {
                s = Short.parseShort(this.localTxVLIDTF.getText());
                iNodeModel = (INodeModel)this.localNodeCB.getSelectedItem();
                eID = NEMC.EID_DUP_LOCAL_VLINK_ID;
            } else {
                s = Short.parseShort(this.remoteTxVLIDTF.getText());
                iNodeModel = (INodeModel)this.remoteNodeCB.getSelectedItem();
                eID = NEMC.EID_DUP_REMOTE_VLINK_ID;
            }
            ErrorMsg.displayDetailed((Component)((Object)this), eID, duplicateLocalVlinkId.getMessage() + ". The patchcord identifier, " + Short.toString(s) + ", is already in use on node " + iNodeModel.getName());
        }
        catch (DuplicateRemoteVlinkId duplicateRemoteVlinkId) {
            this.rollback();
            SDebug.printStackTrace((Throwable)duplicateRemoteVlinkId);
            short s = -1;
            INodeModel iNodeModel = null;
            EID eID = null;
            if (bl) {
                s = Short.parseShort(this.remoteTxVLIDTF.getText());
                iNodeModel = (INodeModel)this.remoteNodeCB.getSelectedItem();
                eID = NEMC.EID_DUP_REMOTE_VLINK_ID;
            } else {
                s = Short.parseShort(this.localTxVLIDTF.getText());
                iNodeModel = (INodeModel)this.localNodeCB.getSelectedItem();
                eID = NEMC.EID_DUP_LOCAL_VLINK_ID;
            }
            ErrorMsg.displayDetailed((Component)((Object)this), eID, duplicateRemoteVlinkId.getMessage() + ". The patchcord identifier, " + Short.toString(s) + ", is already in use on node " + iNodeModel.getName());
        }
        catch (NumberFormatException numberFormatException) {
            CerentDialog.errorDialog((Component)((Object)this), (String)("The maximum supported ID is " + Short.toString((short)Short.MAX_VALUE) + "\n" + numberFormatException.getMessage()), (String)"Error Parsing ID");
        }
        catch (Exception exception) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            CerentDialog.errorDialog((Component)((Object)this), (String)exception.getMessage(), (String)"Error");
        }
    }

    private void updateListModels(boolean bl) {
        Integer n;
        INodeModel iNodeModel = (INodeModel)this.localNodeCB.getSelectedItem();
        IEntityModel iEntityModel = null;
        IEntityModel iEntityModel2 = (IEntityModel)this.localTxTermList.getSelectedValue();
        IEntityModel iEntityModel3 = (IEntityModel)this.localRxTermList.getSelectedValue();
        if (this.isMSNode(iNodeModel)) {
            n = (Integer)this.localTxShelfCombo.getSelectedItem();
            if (n != null && n != -1) {
                this.updateListModel(bl, this.localTxVLModel, this.localRxVLModel, n, iNodeModel);
            } else {
                this.localTxVLModel.removeAllElements();
                this.localRxVLModel.removeAllElements();
            }
        } else {
            this.updateListModel(bl, this.localTxVLModel, this.localRxVLModel, -1, iNodeModel);
        }
        if (this.protectMode && this.yCableCache != null && this.yCableCache.list == this.localTxTermList) {
            this.localTxVLModel.removeAllElements();
            this.localTxVLModel.setSize(1);
            this.localTxVLModel.setElementAt(this.yCableCache.entity, 0);
            this.localTxTermList.setSelectedValue(this.yCableCache.entity, true);
            iEntityModel2 = null;
            iEntityModel3 = null;
        }
        if (iEntityModel2 != null) {
            if (this.localTxVLModel.contains(iEntityModel2)) {
                this.localTxTermList.setSelectedValue(iEntityModel2, true);
                this.localTxTermList.ensureIndexIsVisible(this.localTxVLModel.indexOf(iEntityModel2));
            } else if (this.localRxVLModel.contains(iEntityModel2)) {
                this.localRxTermList.setSelectedValue(iEntityModel2, true);
                this.localRxTermList.ensureIndexIsVisible(this.localRxVLModel.indexOf(iEntityModel2));
            }
        }
        if (iEntityModel3 != null) {
            if (this.localTxVLModel.contains(iEntityModel3)) {
                this.localTxTermList.setSelectedValue(iEntityModel3, true);
                this.localTxTermList.ensureIndexIsVisible(this.localTxVLModel.indexOf(iEntityModel3));
            } else if (this.localRxVLModel.contains(iEntityModel3)) {
                this.localRxTermList.setSelectedValue(iEntityModel3, true);
                this.localRxTermList.ensureIndexIsVisible(this.localRxVLModel.indexOf(iEntityModel3));
            }
        }
        if ((iEntityModel = (IEntityModel)this.localTxTermList.getSelectedValue()) != null) {
            this.localTxTermList.setCellRenderer(ElementFactoryFinder.getElementFactory(iNodeModel).createEntityCellRenderer(iNodeModel, "slot "));
            this.localRxTermList.setCellRenderer(ElementFactoryFinder.getElementFactory(iNodeModel).createEntityCellRenderer(iNodeModel, "slot "));
        }
        iNodeModel = (INodeModel)this.remoteNodeCB.getSelectedItem();
        iEntityModel2 = (IEntityModel)this.remoteTxTermList.getSelectedValue();
        iEntityModel3 = (IEntityModel)this.remoteRxTermList.getSelectedValue();
        if (this.isMSNode(iNodeModel)) {
            n = (Integer)this.remoteTxShelfCombo.getSelectedItem();
            Integer n2 = (Integer)this.remoteRxShelfCombo.getSelectedItem();
            if (n != null && n != -1) {
                this.updateListModel(bl, this.remoteTxVLModel, this.remoteRxVLModel, n, iNodeModel);
            } else {
                this.remoteTxVLModel.removeAllElements();
                this.remoteRxVLModel.removeAllElements();
            }
            if (n2 != null && n2 != -1) {
                this.updateListModel(bl, this.remoteTxVLModel, this.remoteRxVLModel, n2, iNodeModel);
            } else {
                this.remoteTxVLModel.removeAllElements();
                this.remoteRxVLModel.removeAllElements();
            }
        } else {
            this.updateListModel(bl, this.remoteTxVLModel, this.remoteRxVLModel, -1, iNodeModel);
        }
        if (this.protectMode && this.yCableCache != null && this.yCableCache.list == this.remoteTxTermList) {
            this.remoteTxVLModel.removeAllElements();
            this.remoteTxVLModel.setSize(1);
            this.remoteTxVLModel.setElementAt(this.yCableCache.entity, 0);
            this.remoteTxTermList.setSelectedValue(this.yCableCache.entity, true);
            if (bl) {
                this.remoteRxVLModel.removeAllElements();
                this.remoteRxVLModel.setSize(1);
                this.remoteRxVLModel.setElementAt(this.yCableCache.entity, 0);
                this.remoteTxTermList.setSelectedValue(this.yCableCache.entity, true);
            }
            iEntityModel2 = null;
            iEntityModel3 = null;
        }
        if (iEntityModel2 != null) {
            if (this.remoteTxVLModel.contains(iEntityModel2)) {
                this.remoteTxTermList.setSelectedValue(iEntityModel2, true);
                this.remoteTxTermList.ensureIndexIsVisible(this.remoteTxVLModel.indexOf(iEntityModel2));
            } else if (this.remoteRxVLModel.contains(iEntityModel2)) {
                this.remoteRxTermList.setSelectedValue(iEntityModel2, true);
                this.remoteRxTermList.ensureIndexIsVisible(this.remoteRxVLModel.indexOf(iEntityModel2));
            }
        }
        if (iEntityModel3 != null) {
            if (this.remoteTxVLModel.contains(iEntityModel3)) {
                this.remoteTxTermList.setSelectedValue(iEntityModel3, true);
                this.remoteTxTermList.ensureIndexIsVisible(this.remoteTxVLModel.indexOf(iEntityModel3));
            } else if (this.remoteRxVLModel.contains(iEntityModel3)) {
                this.remoteRxTermList.setSelectedValue(iEntityModel3, true);
                this.remoteRxTermList.ensureIndexIsVisible(this.remoteRxVLModel.indexOf(iEntityModel3));
            }
        }
        if ((iEntityModel = (IEntityModel)this.remoteTxTermList.getSelectedValue()) != null) {
            this.remoteTxTermList.setCellRenderer(ElementFactoryFinder.getElementFactory(iNodeModel).createEntityCellRenderer(iNodeModel, "slot "));
            this.remoteRxTermList.setCellRenderer(ElementFactoryFinder.getElementFactory(iNodeModel).createEntityCellRenderer(iNodeModel, "slot "));
        }
    }

    private void updateShelfList(Integer[] integerArray, DefaultComboBoxModel defaultComboBoxModel) {
        defaultComboBoxModel.removeAllElements();
        if (integerArray != null) {
            for (int i = 0; i < integerArray.length; ++i) {
                if (integerArray[i] == null) continue;
                defaultComboBoxModel.insertElementAt(integerArray[i], i);
            }
        }
    }

    private void updateListModel(boolean bl, DefaultListModel defaultListModel, DefaultListModel defaultListModel2, int n, INodeModel iNodeModel) {
        block16: {
            int n2;
            ArrayList<IEntityModel> arrayList;
            IEntityModel[] iEntityModelArray;
            block15: {
                iEntityModelArray = this.vld.getVirtualLinkCandidates(iNodeModel);
                if (n != -1) {
                    arrayList = new ArrayList<IEntityModel>();
                    for (int i = 0; i < iEntityModelArray.length; ++i) {
                        if (iEntityModelArray[i].getShelfId() != n) continue;
                        arrayList.add(iEntityModelArray[i]);
                    }
                    iEntityModelArray = arrayList.toArray(new IEntityModel[arrayList.size()]);
                }
                Arrays.sort(iEntityModelArray, new PortComparator());
                if (bl) break block15;
                if (defaultListModel != null) {
                    defaultListModel.setSize(iEntityModelArray.length);
                }
                if (defaultListModel2 != null) {
                    defaultListModel2.setSize(iEntityModelArray.length);
                }
                for (int i = 0; i < iEntityModelArray.length; ++i) {
                    if (defaultListModel != null) {
                        defaultListModel.setElementAt(iEntityModelArray[i], i);
                    }
                    if (defaultListModel2 == null) continue;
                    defaultListModel2.setElementAt(iEntityModelArray[i], i);
                }
                break block16;
            }
            arrayList = new ArrayList();
            ArrayList<IEntityModel> arrayList2 = new ArrayList<IEntityModel>();
            for (n2 = 0; n2 < iEntityModelArray.length; ++n2) {
                IEntityModel iEntityModel = iEntityModelArray[n2];
                if (iEntityModel.getEqType() != 139 && iEntityModel.getEqType() != 141) {
                    arrayList.add(iEntityModel);
                    arrayList2.add(iEntityModel);
                    continue;
                }
                IModuleModel iModuleModel = iEntityModel.getModuleModel();
                if (iModuleModel.getEqType() == 131 || iModuleModel.getEqType() == 191 || iModuleModel.getEqType() == 242) {
                    arrayList2.add(iEntityModel);
                    continue;
                }
                if (iModuleModel.getEqType() == 132 || iModuleModel.getEqType() == 192 || iModuleModel.getEqType() == 241) {
                    arrayList.add(iEntityModel);
                    continue;
                }
                if (iModuleModel.getEqType() == 133 || iEntityModel.getEqType() == 141) {
                    if (iEntityModel.getPositionInParent() % 2 == 0) {
                        arrayList.add(iEntityModel);
                        continue;
                    }
                    arrayList2.add(iEntityModel);
                    continue;
                }
                db.severe("ERROR: Don't know how to deal with " + iEntityModel + " from card eqType: " + iModuleModel.getEqType());
            }
            iEntityModelArray = arrayList.toArray(new IEntityModel[0]);
            if (defaultListModel != null) {
                defaultListModel.setSize(arrayList.size());
                for (n2 = 0; n2 < iEntityModelArray.length; ++n2) {
                    defaultListModel.setElementAt(iEntityModelArray[n2], n2);
                }
            }
            iEntityModelArray = arrayList2.toArray(new IEntityModel[0]);
            if (defaultListModel2 == null) break block16;
            defaultListModel2.setSize(arrayList2.size());
            for (n2 = 0; n2 < iEntityModelArray.length; ++n2) {
                defaultListModel2.setElementAt(iEntityModelArray[n2], n2);
            }
        }
    }

    private void updateSeparateCBState() {
        boolean bl = false;
        IEntityModel iEntityModel = (IEntityModel)this.localTxTermList.getSelectedValue();
        IEntityModel iEntityModel2 = (IEntityModel)this.localRxTermList.getSelectedValue();
        IEntityModel iEntityModel3 = (IEntityModel)this.remoteTxTermList.getSelectedValue();
        IEntityModel iEntityModel4 = (IEntityModel)this.remoteRxTermList.getSelectedValue();
        if (iEntityModel != null && this.isOch(iEntityModel)) {
            bl = true;
        } else if (iEntityModel2 != null && this.isOch(iEntityModel2)) {
            bl = true;
        } else if (iEntityModel3 != null && this.isOch(iEntityModel3)) {
            bl = true;
        } else if (iEntityModel4 != null && this.isOch(iEntityModel4)) {
            bl = true;
        }
        this.separateTxRxCB.setEnabled(!bl);
    }

    private boolean isOch(IEntityModel iEntityModel) {
        return iEntityModel.getEqType() == 139 || iEntityModel.getEqType() == 141;
    }

    private void rollback() {
        block3: {
            short s = Short.parseShort(this.localTxVLIDTF.getText());
            short s2 = Short.parseShort(this.remoteTxVLIDTF.getText());
            try {
                INodeModel iNodeModel = this.vld.getNodeModelFromString((String)this.localNodeCB.getSelectedItem());
                this.vld.deleteVirtualLink(iNodeModel, s);
                INodeModel iNodeModel2 = this.vld.getNodeModelFromString((String)this.remoteNodeCB.getSelectedItem());
                this.vld.deleteVirtualLink(iNodeModel2, s2);
                if (this.separateTxRxCB.isSelected()) {
                    short s3 = Short.parseShort(this.localRxVLIDTF.getText());
                    short s4 = Short.parseShort(this.remoteRxVLIDTF.getText());
                    this.vld.deleteVirtualLink(iNodeModel, s3);
                    this.vld.deleteVirtualLink(iNodeModel2, s4);
                }
            }
            catch (Exception exception) {
                db.println("Caught " + exception + " during rollback.");
                if (!db.on()) break block3;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    public static JPanel createHorizontalPanel(String string) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        if (string != null) {
            jPanel.setBorder(BorderFactory.createTitledBorder(string));
        }
        return jPanel;
    }

    public static JPanel createVerticalPanel(String string) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        if (string != null) {
            jPanel.setBorder(BorderFactory.createTitledBorder(string));
        }
        return jPanel;
    }

    private boolean isMSNode(INodeModel iNodeModel) {
        boolean bl = false;
        if (Feature.provides((INodeModel)iNodeModel, (Feature)Feature.MULTISHELF)) {
            bl = iNodeModel.isMultishelf();
        }
        return bl;
    }

    private class NMCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public NMCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = "";
            if (object instanceof INodeModel) {
                string = ((INodeModel)object).getName();
            } else if (object instanceof Integer) {
                string = ((Integer)object).toString();
            }
            this.setText(string);
            Color color = new Color(205, 205, 255);
            this.setBackground(bl ? color : Color.white);
            this.setForeground(Color.black);
            return this;
        }
    }

    private class NMCellEditor
    extends JTextField
    implements ComboBoxEditor {
        private INodeModel nm = null;

        public NMCellEditor() {
            this("");
        }

        public NMCellEditor(Object object) {
            this.setOpaque(true);
            this.setItem(object);
            this.setColumns(12);
        }

        public Component getEditorComponent() {
            return this;
        }

        public void setItem(Object object) {
            String string = object.toString();
            if (object instanceof INodeModel) {
                this.nm = (INodeModel)object;
                string = this.nm.getName();
            } else {
                this.nm = null;
            }
            this.setText(string);
        }

        public Object getItem() {
            if (this.nm != null && this.nm.getName().equals(this.getText())) {
                return this.nm;
            }
            return this.getText();
        }
    }

    private class YCableCacheBundle {
        public final IEntityModel entity;
        public final JList list;

        public YCableCacheBundle(IEntityModel iEntityModel, JList jList) {
            this.entity = iEntityModel;
            this.list = jList;
        }
    }

    protected class PortComparator
    implements Comparator {
        protected PortComparator() {
        }

        public int compare(Object object, Object object2) {
            return ComparisonUtil.compare((int)((IEntityModel)object).getEntityIndex(), (int)((IEntityModel)object2).getEntityIndex());
        }
    }

    private class ChassisItemListener
    implements ItemListener {
        private boolean _isTx = true;
        private boolean _islocal = true;

        public ChassisItemListener(JComboBox jComboBox) {
            if (jComboBox.equals(VirtualLinkCreationDialog.this.localTxShelfCombo)) {
                this._isTx = true;
                this._islocal = true;
            } else if (jComboBox.equals(VirtualLinkCreationDialog.this.localRxShelfCombo)) {
                this._isTx = false;
                this._islocal = true;
            } else if (jComboBox.equals(VirtualLinkCreationDialog.this.remoteTxShelfCombo)) {
                this._isTx = true;
                this._islocal = false;
            } else if (jComboBox.equals(VirtualLinkCreationDialog.this.remoteRxShelfCombo)) {
                this._isTx = false;
                this._islocal = false;
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (this.getActualCombo().getSelectedItem() == null) {
                return;
            }
            VirtualLinkCreationDialog.this.updateListModel(VirtualLinkCreationDialog.this.separateTxRxCB.isSelected(), this.getlistVLModel(true), this.getlistVLModel(false), (Integer)this.getActualCombo().getSelectedItem(), this.getActualNode());
            this.updatecellrenderer();
        }

        private JComboBox getActualCombo() {
            if (this._isTx && this._islocal) {
                return VirtualLinkCreationDialog.this.localTxShelfCombo;
            }
            if (!this._isTx && this._islocal) {
                return VirtualLinkCreationDialog.this.localRxShelfCombo;
            }
            if (this._isTx && !this._islocal) {
                return VirtualLinkCreationDialog.this.remoteTxShelfCombo;
            }
            if (!this._isTx && !this._islocal) {
                return VirtualLinkCreationDialog.this.remoteRxShelfCombo;
            }
            return null;
        }

        private INodeModel getActualNode() {
            if (this._islocal) {
                return (INodeModel)VirtualLinkCreationDialog.this.localNodeCE.getItem();
            }
            return (INodeModel)VirtualLinkCreationDialog.this.remoteNodeCE.getItem();
        }

        private DefaultListModel getlistVLModel(boolean bl) {
            if (this._isTx && this._islocal && bl) {
                return VirtualLinkCreationDialog.this.localTxVLModel;
            }
            if (!this._isTx && this._islocal && !bl) {
                return VirtualLinkCreationDialog.this.localRxVLModel;
            }
            if (this._isTx && !this._islocal && bl) {
                return VirtualLinkCreationDialog.this.remoteTxVLModel;
            }
            if (!(this._isTx || this._islocal || bl)) {
                return VirtualLinkCreationDialog.this.remoteRxVLModel;
            }
            return null;
        }

        private void updatecellrenderer() {
        }

        private ListCellRenderer getcellrenderer(INodeModel iNodeModel) {
            return ElementFactoryFinder.getElementFactory(iNodeModel).createEntityCellRenderer(iNodeModel, "slot ");
        }
    }
}

