/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.WzDialog;
import cerent.cms.ui.WzStatusPanel;
import cerent.util.CEMC;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.gui.GridPanel;
import cerent.util.gui.MultiLineLabelUI;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.LabelUI;

public abstract class WzPane
extends JPanel
implements ActionListener {
    protected WzDiagDebug db;
    protected WzDialog parent;
    private String name;
    public boolean goingForward = true;
    private boolean inited = false;
    protected boolean isOkToPostValidate = true;
    public static final int MARGIN = 5;

    public WzPane(WzDialog wzDialog, WzDiagDebug wzDiagDebug, String string) {
        this.parent = wzDialog;
        this.name = string;
        this.db = wzDiagDebug;
        wzDiagDebug.setPane(this);
    }

    public final String getName() {
        return this.name;
    }

    public String getShortName() {
        return this.getName();
    }

    protected void resetOkToPostValidate() {
        this.isOkToPostValidate = true;
    }

    public boolean isOkToPostValidate() {
        return this.isOkToPostValidate;
    }

    public String handleNext() {
        try {
            this.resetOkToPostValidate();
            this.validatePage();
            if (!this.isOkToPostValidate()) {
                return null;
            }
            this.handlePostValidate();
        }
        catch (Exception exception) {
            this.handleNextException(exception);
            return null;
        }
        this.parent.pushStatusInfo(this.getStatusComponent());
        return this.getNextPaneName();
    }

    public void handleApply() {
    }

    protected void handleNextException(Exception exception) {
        WzDiagDebug.printStackTrace((Throwable)exception);
        ErrorMsg.displayError((Component)this, (EID)CEMC.EID_FAIL_WIZARD_VALIDATION_PARAM_1, (Object)exception.getMessage());
    }

    public abstract void validatePage() throws Exception;

    protected void handlePostValidate() {
    }

    protected abstract String getNextPaneName();

    public boolean handleBack() {
        this.parent.popStatusInfo();
        return true;
    }

    public void enteringPane() {
        if (this.db.on()) {
            this.db.fine("enteringPane() " + this.name + ", going in forward direction? " + this.goingForward);
        }
        if (this.parent != null) {
            this.parent.clearStatusLabelText();
            this.parent.setButtonsEnabled(true, false);
        }
        if (!this.inited) {
            this.initPane();
            this.inited = true;
        }
        if (this.goingForward) {
            this.revalidateData();
        }
    }

    protected abstract void initPane();

    protected boolean isInited() {
        return this.inited;
    }

    public void revalidateData() {
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    protected JComponent getStatusComponent() {
        return WzPane.getTextHolder(this.getStatusText());
    }

    protected String getStatusText() {
        return "";
    }

    protected static JLabel getTextHolder(String string) {
        JLabel jLabel = new JLabel(string.trim());
        jLabel.setHorizontalAlignment(2);
        jLabel.setUI((LabelUI)new MultiLineLabelUI());
        return jLabel;
    }

    protected static GridPanel getGridPanel(List list) {
        GridPanel gridPanel = new GridPanel(2, 0, 0, 0);
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                String[] stringArray;
                Object e = list.get(i);
                if (!(e instanceof String[]) || (stringArray = (String[])e).length != 2) continue;
                JLabel jLabel = new JLabel(stringArray[0]);
                JLabel jLabel2 = new JLabel(stringArray[1]);
                jLabel.setUI((LabelUI)new MultiLineLabelUI());
                jLabel2.setUI((LabelUI)new MultiLineLabelUI());
                jLabel.setFont(WzStatusPanel.STATUS_FONT);
                jLabel2.setFont(WzStatusPanel.STATUS_FONT);
                gridPanel.addRow((JComponent)jLabel, (JComponent)jLabel2);
            }
        }
        return gridPanel;
    }

    public abstract CSHelpID getHelpID();

    public void dispose() {
        this.parent = null;
    }

    public void removeListeners() {
    }

    public static JPanel createHorizontalPanel(String string) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        if (string != null) {
            jPanel.setBorder(BorderFactory.createTitledBorder(string));
        }
        return jPanel;
    }

    public static JPanel createVerticalPanel(String string) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        if (string != null) {
            jPanel.setBorder(BorderFactory.createTitledBorder(string));
        }
        return jPanel;
    }

    public String getDiagString() {
        String string = "\nName: " + this.name + "\n" + "Inited? " + this.inited + "\n" + "Going Forward? " + this.goingForward + "\n";
        return string;
    }
}

