/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.blsr;

import cerent.cms.model.IModel;
import cerent.cms.model.NetworkModel;
import cerent.cms.model.NodeModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.blsr.BlsrRingModel;
import cerent.cms.model.blsr.BlsrSpan;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.Network;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.blsr.BlsrMapLink;
import cerent.cms.ui.blsr.BlsrMapNode;
import cerent.cms.ui.network.AbstractNetworkMap;
import cerent.cms.ui.network.MapPersist;
import cerent.cms.ui.network.NetMapLink;
import cerent.util.ColorUtil;
import cerent.util.Preferences;
import cerent.util.SDebug;
import com.cisco.ctc.util.map.IMapFactory;
import com.cisco.ctc.util.map.MapLink;
import com.cisco.ctc.util.map.MapNode;
import com.cisco.ctc.util.map.Node;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.Observable;
import javax.swing.SwingUtilities;

public abstract class AbstractBlsrMap
extends AbstractNetworkMap
implements PropertyChangeListener {
    private static SDebug db = new SDebug("AbstractBlsrMap");
    private Network network;
    public static String PREFS_CIRCUIT_KEY = "ctc.circuits";
    public static String PREFS_ACTIVE_SPAN = "activespan";
    public static String PREFS_STANDBY_SPAN = "standbyspan";
    public static String PREFS_KEY = "ctc.blsrmap";
    public static final Color COLOR_DEFAULT_ACTIVE = Color.green;
    public static final Color COLOR_DEFAULT_STANDBY = new Color(128, 0, 192);

    public AbstractBlsrMap(SDebug sDebug, int n, IMapFactory iMapFactory) {
        super(sDebug, n, iMapFactory);
        Preferences.instance().addPropertyChangeListener((PropertyChangeListener)this);
        NetMapLink.LINK_ACTIVE_COLOR = AbstractBlsrMap.getPrefColor(PREFS_ACTIVE_SPAN);
        NetMapLink.LINK_STANDBY_COLOR = AbstractBlsrMap.getPrefColor(PREFS_STANDBY_SPAN);
        this.updateView();
        this.network = Network.instance();
    }

    protected abstract BlsrRingModel getRingModel();

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals(PREFS_STANDBY_SPAN) || string.equals(PREFS_ACTIVE_SPAN)) {
            NetMapLink.LINK_ACTIVE_COLOR = AbstractBlsrMap.getPrefColor(PREFS_ACTIVE_SPAN);
            NetMapLink.LINK_STANDBY_COLOR = AbstractBlsrMap.getPrefColor(PREFS_STANDBY_SPAN);
            if (AbstractBlsrMap.db.on) {
                db.println("propertyChange:  propertyName is:" + string + ", ACTIVE set to:" + NetMapLink.LINK_ACTIVE_COLOR + ", STANDBY set to:" + NetMapLink.LINK_STANDBY_COLOR);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AbstractBlsrMap.this.updateView();
            }
        });
    }

    public void dispose() {
        if (AbstractBlsrMap.db.on) {
            db.println("dispose() called");
        }
        Preferences.instance().removePropertyChangeListener((PropertyChangeListener)this);
        this.network = null;
        super.dispose();
    }

    public static Color getPrefColor(String string) {
        String string2 = Preferences.instance().getProperty(PREFS_CIRCUIT_KEY, string, null);
        if (string.equals(PREFS_ACTIVE_SPAN)) {
            return ColorUtil.getColor(string2, COLOR_DEFAULT_ACTIVE);
        }
        return ColorUtil.getColor(string2, COLOR_DEFAULT_STANDBY);
    }

    public NodeModel getRealNodeModel(int n) {
        return (NodeModel)Network.instance().getNetElem(n).getNodeModel();
    }

    public void updateReceived(MapNode mapNode, Observable observable, Object object) {
    }

    protected INetLink getNetLink(BlsrSpan blsrSpan) {
        INetLink iNetLink = null;
        if (null != blsrSpan) {
            iNetLink = blsrSpan.getOriginalLink();
            if (iNetLink == null) {
                iNetLink = blsrSpan.getReverseLink();
            }
        } else if (AbstractBlsrMap.db.on) {
            db.println("BlsrSpan sent as argument is null!");
        }
        return iNetLink;
    }

    public BlsrMapLink getBlsrMapLink(INetLink iNetLink) {
        BlsrMapLink blsrMapLink = null;
        MapLink mapLink = this.getMapLink(iNetLink);
        if (null != mapLink) {
            if (mapLink instanceof BlsrMapLink) {
                blsrMapLink = (BlsrMapLink)mapLink;
            } else if (AbstractBlsrMap.db.on) {
                db.println("MapLink for INetLink (" + iNetLink + ") is not an instance of BlsrMapLink.  It is a: " + mapLink.getClass());
            }
        } else if (AbstractBlsrMap.db.on) {
            db.println("MapLink for INetLink (" + iNetLink + ") is null.");
        }
        return blsrMapLink;
    }

    protected BlsrMapNode getBlsrMapNode(NodeModel nodeModel) {
        BlsrMapNode blsrMapNode = null;
        MapNode mapNode = this.getMapNode(nodeModel);
        if (null != mapNode) {
            if (mapNode instanceof BlsrMapNode) {
                blsrMapNode = (BlsrMapNode)mapNode;
            } else if (AbstractBlsrMap.db.on) {
                db.println("MapNode for NodeModel (" + nodeModel + ") is not an instance of BlsrMapNode.  It is a: " + mapNode.getClass());
            }
        } else if (AbstractBlsrMap.db.on) {
            db.println("MapNode for NodeModel (" + nodeModel + ") is null.");
        }
        return blsrMapNode;
    }

    protected BlsrMapLink getBlsrMapLink(BlsrSpan blsrSpan) {
        BlsrMapLink blsrMapLink = null;
        if (blsrSpan != null) {
            if (AbstractBlsrMap.db.on) {
                db.println("====================================");
                db.println("looking for BlsrMapLink for BlsrSpan: " + blsrSpan);
            }
            Collection collection = this.getLinkUserObjects();
            boolean bl = false;
            MapLink mapLink = null;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext() && !bl) {
                Object e = iterator.next();
                mapLink = this.getMapLink(e);
                if (mapLink instanceof BlsrMapLink) {
                    if (AbstractBlsrMap.db.on) {
                        db.println("comparing with " + ((BlsrMapLink)mapLink).getBlsrSpan());
                    }
                    if (!blsrSpan.equals(((BlsrMapLink)mapLink).getBlsrSpan())) continue;
                    blsrMapLink = (BlsrMapLink)mapLink;
                    bl = true;
                    if (!AbstractBlsrMap.db.on) continue;
                    db.println("found it!");
                    continue;
                }
                if (!AbstractBlsrMap.db.on) continue;
                db.println("tempLink is not a BlsrMapLink: " + mapLink);
            }
        } else if (AbstractBlsrMap.db.on) {
            db.println("getBlsrMapLink called with null argument");
        }
        return blsrMapLink;
    }

    protected boolean isMaintenanceAllowed() {
        return AbstractPane.isUserAuthorized((IModel)NetworkModel.instance().getCmsHostModel(), SecurityLevel.MAINTENANCE);
    }

    protected boolean getNodeCoordinatesFromCache(Node node) {
        String string;
        if (node == null) {
            return false;
        }
        boolean bl = true;
        String string2 = MapPersist.buildLongitudePrefStr(node);
        string2 = string2.substring(4);
        String string3 = MapPersist.buildLatitudePrefStr(node);
        string3 = string3.substring(4);
        Double d = null;
        Double d2 = null;
        Preferences preferences = Preferences.instance();
        String string4 = preferences.getProperty(PREFS_KEY, string2, null);
        if (string4 != null && !string4.equals("")) {
            try {
                d = new Double(string4);
            }
            catch (NumberFormatException numberFormatException) {
                d = null;
            }
        }
        if ((string = preferences.getProperty(PREFS_KEY, string3, null)) != null && !string.equals("")) {
            try {
                d2 = new Double(string);
            }
            catch (NumberFormatException numberFormatException) {
                d2 = null;
            }
        }
        if (d != null && d2 != null) {
            node.setCoordinates(d, d2);
        } else {
            bl = MapPersist.getPersistProperty(node, 101);
            if (bl) {
                this.saveNodeCoordinatesToCache(node);
            }
        }
        return bl;
    }

    protected void saveNodeCoordinatesToCache(Node node) {
        if (node == null) {
            return;
        }
        String string = MapPersist.buildLongitudePrefStr(node);
        string = string.substring(4);
        String string2 = MapPersist.buildLatitudePrefStr(node);
        string2 = string2.substring(4);
        Preferences preferences = Preferences.instance();
        preferences.setProperty(PREFS_KEY, string, new Double(node.getCenterX()).toString());
        preferences.setProperty(PREFS_KEY, string2, new Double(node.getCenterY()).toString());
    }
}

