/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.blsr;

import cerent.cms.model.IRevertiveBehavior;
import cerent.cms.model.RevertiveBehavior;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.RevertiveBehaviorCellEditor;
import cerent.cms.ui.RevertiveBehaviorRenderer;
import cerent.cms.ui.blsr.AbstractBlsrWizardPane;
import cerent.cms.ui.blsr.RingCreationDialog;
import cerent.cms.ui.helper.EqTypeHelper;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.gui.GridBagPanel;
import cerent.util.gui.LetterOrDigitTextField;
import cerent.util.gui.UComboBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;

public class RcdAttrsPane
extends AbstractBlsrWizardPane
implements ActionListener {
    private RingCreationDialog parent;
    private TDMTerminology tdmTerminology;
    private static String OC12_STRING = null;
    private static String OC48_STRING = null;
    private static String OC192_STRING = null;
    private JLabel typeLabel = new JLabel("Type:");
    private JRadioButton twoFiberButton = null;
    private JRadioButton fourFiberButton = null;
    private ButtonGroup fiberRadioButtonGroup = null;
    private JLabel speedLabel = new JLabel("Speed:");
    private String[] blsrSpeedStrs = null;
    private UComboBox speedCB = null;
    private JLabel ringIdLabel = new JLabel("Ring Name:");
    private LetterOrDigitTextField ringIdTF = new LetterOrDigitTextField(6);
    private JLabel ringRevLabel = new JLabel("Ring Reversion:");
    private JLabel spanRevLabel = new JLabel("Span Reversion:");
    private UComboBox ringRevCB = RevertiveBehaviorCellEditor.getComboBox(true);
    private UComboBox spanRevCB = RevertiveBehaviorCellEditor.getComboBox(true);
    private static SDebug db = new SDebug("RcdAttrsPane");

    public RcdAttrsPane(String string, RingCreationDialog ringCreationDialog, TDMTerminology tDMTerminology) {
        super(string, ringCreationDialog);
        this.parent = ringCreationDialog;
        this.tdmTerminology = tDMTerminology;
        try {
            OC12_STRING = EqTypeHelper.eqTypeToName((TDMTerminology)tDMTerminology, (int)10);
            OC48_STRING = EqTypeHelper.eqTypeToName((TDMTerminology)tDMTerminology, (int)11);
            OC192_STRING = EqTypeHelper.eqTypeToName((TDMTerminology)tDMTerminology, (int)60);
        }
        catch (Exception exception) {
            if (RcdAttrsPane.db.on) {
                SDebug.printStackTrace((Throwable)exception);
            }
            OC12_STRING = "*OC12*";
            OC48_STRING = "*OC48*";
            OC192_STRING = "*OC192*";
        }
        this.blsrSpeedStrs = new String[3];
        this.blsrSpeedStrs[0] = OC12_STRING;
        this.blsrSpeedStrs[1] = OC48_STRING;
        this.blsrSpeedStrs[2] = OC192_STRING;
        this.speedCB = new UComboBox((Object[])this.blsrSpeedStrs);
        this.twoFiberButton = new JRadioButton("2 Fiber");
        this.twoFiberButton.setActionCommand("twoFiberButton");
        this.twoFiberButton.addActionListener(this);
        this.twoFiberButton.setSelected(true);
        this.fourFiberButton = new JRadioButton("4 Fiber");
        this.fourFiberButton.setActionCommand("fourFiberButton");
        this.fourFiberButton.addActionListener(this);
        this.fourFiberButton.setSelected(false);
        this.fiberRadioButtonGroup = new ButtonGroup();
        GridBagPanel gridBagPanel = new GridBagPanel();
        gridBagPanel.anchor(17);
        gridBagPanel.inset(5, 10);
        gridBagPanel.add((Component)this.typeLabel, 1, 1);
        gridBagPanel.add((Component)this.twoFiberButton, 2, 1);
        gridBagPanel.add((Component)this.fourFiberButton, 3, 1);
        this.fiberRadioButtonGroup.add(this.twoFiberButton);
        this.fiberRadioButtonGroup.add(this.fourFiberButton);
        this.twoFiberButton.setSelected(true);
        gridBagPanel.add((Component)this.speedLabel, 1, 2);
        gridBagPanel.add((Component)this.speedCB, 2, 2);
        gridBagPanel.add((Component)this.ringIdLabel, 1, 3);
        gridBagPanel.add((Component)this.ringIdTF, 2, 3);
        gridBagPanel.add((Component)this.ringRevLabel, 1, 4);
        gridBagPanel.add((Component)this.ringRevCB, 2, 4);
        this.ringRevCB.addActionListener((ActionListener)this);
        gridBagPanel.add((Component)this.spanRevLabel, 1, 5);
        gridBagPanel.add((Component)this.spanRevCB, 2, 5);
        this.spanRevCB.addActionListener((ActionListener)this);
        this.spanRevCB.setEnabled(false);
        this.setLayout(new BorderLayout());
        this.add(gridBagPanel, "Center");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        int n = this.speedCB.getSelectedIndex();
        if (object == this.twoFiberButton) {
            this.spanRevCB.setEnabled(false);
            if (this.speedCB.getItemAt(0).equals(OC48_STRING)) {
                this.speedCB.insertItemAt((Object)OC12_STRING, 0);
                ++n;
            }
        } else if (object == this.fourFiberButton) {
            this.spanRevCB.setEnabled(true);
            if (this.speedCB.getItemAt(0).equals(OC12_STRING)) {
                this.speedCB.removeItemAt(0);
                if (--n < 0) {
                    n = 0;
                }
            }
        } else if (object == this.ringRevCB || object == this.spanRevCB) {
            this.parent.setRevModified(true);
        }
        this.speedCB.setSelectedIndex(n);
    }

    protected boolean okToProceed() {
        return true;
    }

    public void validatePage() throws Exception {
        boolean bl;
        if (RcdAttrsPane.db.on) {
            db.println("validatePage() called");
        }
        if (bl = this.fourFiberButton.isSelected()) {
            this.parent.setRingType(3);
        } else {
            this.parent.setRingType(2);
        }
        int n = this.speedCB.getSelectedIndex();
        if (bl) {
            ++n;
        }
        switch (n) {
            case 0: {
                if (bl && this.speedCB.getItemAt(0).equals(OC12_STRING)) {
                    throw new Exception("Cannot have Four Fiber " + OC12_STRING + " ring...");
                }
                this.parent.setRingSpeed(1);
                break;
            }
            case 1: {
                this.parent.setRingSpeed(2);
                break;
            }
            case 2: {
                this.parent.setRingSpeed(3);
            }
        }
        String string = this.ringIdTF.getText().toUpperCase().trim();
        if (string.equalsIgnoreCase("all")) {
            throw new Exception("'All' is a TL1 keyword and can not be used as the ring name");
        }
        this.parent.setRingName(string);
        RevertiveBehavior revertiveBehavior = (RevertiveBehavior)this.ringRevCB.getSelectedItem();
        this.parent.setRingReversion(revertiveBehavior);
        if (bl) {
            revertiveBehavior = (RevertiveBehavior)this.spanRevCB.getSelectedItem();
            this.parent.setSpanReversion(revertiveBehavior);
        } else {
            this.parent.setSpanReversion(null);
        }
    }

    protected String getStatusText() {
        if (RcdAttrsPane.db.on) {
            db.println("getStatusText() called");
        }
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Ring Type: ");
        if (this.parent.getRingType() == 2) {
            stringBuffer.append("2-Fiber");
        } else {
            stringBuffer.append("4-Fiber");
            bl = true;
        }
        stringBuffer.append("\nSpeed: ");
        this.parent.getRingSpeed();
        switch (this.parent.getRingSpeed()) {
            case 1: {
                stringBuffer.append(OC12_STRING);
                break;
            }
            case 2: {
                stringBuffer.append(OC48_STRING);
                break;
            }
            case 3: {
                stringBuffer.append(OC192_STRING);
            }
        }
        stringBuffer.append("\nRing Name: ");
        stringBuffer.append(this.parent.getRingName());
        boolean bl2 = false;
        float f = 0.0f;
        stringBuffer.append("\nRing Reversion: ");
        stringBuffer.append(RevertiveBehaviorRenderer.getString(this.parent.getRingReversion()));
        if (bl) {
            stringBuffer.append("\nSpan Reversion: ");
            stringBuffer.append(RevertiveBehaviorRenderer.getString(this.parent.getSpanReversion()));
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public void refresh() {
        boolean bl;
        if (RcdAttrsPane.db.on) {
            db.println("refresh");
        }
        this.parent.setNextEnabled(true);
        boolean bl2 = bl = this.parent.getRingType() == 3;
        if (bl) {
            this.fourFiberButton.setSelected(true);
            if (this.speedCB.getItemAt(0).equals(OC12_STRING)) {
                this.speedCB.removeItemAt(0);
            }
        } else {
            this.twoFiberButton.setSelected(true);
            if (this.speedCB.getItemAt(0).equals(OC48_STRING)) {
                this.speedCB.insertItemAt((Object)OC12_STRING, 0);
            }
        }
        switch (this.parent.getRingSpeed()) {
            case 1: {
                this.speedCB.setSelectedIndex(0);
                break;
            }
            case 2: {
                if (bl) {
                    this.speedCB.setSelectedIndex(0);
                    break;
                }
                this.speedCB.setSelectedIndex(1);
                break;
            }
            case 3: {
                if (bl) {
                    this.speedCB.setSelectedIndex(1);
                    break;
                }
                this.speedCB.setSelectedIndex(2);
            }
        }
        this.ringIdTF.setText("");
        IRevertiveBehavior iRevertiveBehavior = this.parent.getRingReversion();
        if (iRevertiveBehavior != null) {
            this.ringRevCB.setSelectedItem((Object)iRevertiveBehavior);
        } else {
            this.ringRevCB.setSelectedIndex(10);
        }
        IRevertiveBehavior iRevertiveBehavior2 = this.parent.getSpanReversion();
        if (iRevertiveBehavior2 != null) {
            this.spanRevCB.setSelectedItem((Object)iRevertiveBehavior2);
        } else {
            this.spanRevCB.setSelectedIndex(10);
        }
        this.spanRevCB.setEnabled(this.fourFiberButton.isSelected());
    }

    public void dispose() {
        if (RcdAttrsPane.db.on) {
            db.println("dispose() called");
        }
        this.ringRevCB = null;
        this.spanRevCB = null;
        this.parent = null;
        this.tdmTerminology = null;
        super.dispose();
    }

    public CSHelpID getHelpID() {
        CSHelpID cSHelpID = this.parent.getWizardMode() == 0 ? NetCSHelpConst.RcdAttrsPane : NetCSHelpConst.UpsrToBlsrAttrsPane;
        return cSHelpID;
    }

    public void setEnabledFourFiberButton(boolean bl) {
        this.fourFiberButton.setEnabled(bl);
    }
}

