/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.blsr;

import cerent.cms.model.IEntityModel;
import cerent.cms.model.ITdmPortModel;
import cerent.cms.model.blsr.BlsrNode;
import cerent.cms.model.blsr.BlsrRingModel;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.blsr.AbstractBlsrWizardDialog;
import cerent.cms.ui.blsr.AbstractBlsrWizardPane;
import cerent.cms.ui.blsr.BlsrMapPort;
import cerent.cms.ui.blsr.RcdProtectPortTableModel;
import cerent.util.ComparisonUtil;
import cerent.util.SDebug;
import cerent.util.gui.UComboBox;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;

public class RcdProtectPortPane
extends AbstractBlsrWizardPane
implements TableModelListener {
    private AbstractBlsrWizardDialog parent;
    private BlsrRingModel ringModel;
    private RcdProtectPortTableModel tableModel;
    private UScrollPane scrollPane;
    private boolean inited = false;
    public static String noSelection = "No selection";
    private static final SDebug db = new SDebug("RcdProtectPortPane");

    public RcdProtectPortPane(String string, AbstractBlsrWizardDialog abstractBlsrWizardDialog) {
        super(string, abstractBlsrWizardDialog);
        this.parent = abstractBlsrWizardDialog;
        this.setLayout(new BorderLayout());
    }

    protected boolean okToProceed() {
        return true;
    }

    public void validatePage() throws Exception {
        if (RcdProtectPortPane.db.on) {
            db.println("validatePage() called.");
        }
        BlsrNode[] blsrNodeArray = this.ringModel.getBlsrNodes();
        ITdmPortModel[] iTdmPortModelArray = this.tableModel.getEastProtectPorts();
        ITdmPortModel[] iTdmPortModelArray2 = this.tableModel.getWestProtectPorts();
        for (int i = 0; i < blsrNodeArray.length; ++i) {
            BlsrNode blsrNode = blsrNodeArray[i];
            if (iTdmPortModelArray2[i] == null) {
                throw new Exception("West Protect Port is not set for node: " + blsrNode);
            }
            if (iTdmPortModelArray[i] == null) {
                throw new Exception("East Protect Port is not set for node: " + blsrNode);
            }
            if (iTdmPortModelArray2[i] != iTdmPortModelArray[i]) continue;
            throw new Exception("East and West protect ports cannot be the same for node: " + blsrNode);
        }
    }

    public void refresh() throws Exception {
        if (RcdProtectPortPane.db.on) {
            db.println("refresh() called");
        }
        this.localDispose();
        this.ringModel = this.parent.getBlsrRingModel();
        this.tableModel = new RcdProtectPortTableModel(this.ringModel);
        this.tableModel.addTableModelListener(this);
        this.table.setModel(this.tableModel);
        this.table.setDefaultRenderer(ITdmPortModel.class, new TdmPortModelRenderer(this.ringModel));
        this.table.setDefaultEditor(ITdmPortModel.class, new ProtectPortEditor(this.ringModel));
        this.table.setDefaultEditor(String.class, new ProtectPortEditor(this.ringModel));
        this.parent.setFinishEnabled(this.allProtectPortsSelected());
    }

    public void dispose() {
        if (RcdProtectPortPane.db.on) {
            db.println("dispose() called");
        }
        this.removeAll();
        this.localDispose();
        if (this.table != null) {
            this.table = null;
        }
        if (this.tableModel != null) {
            this.tableModel = null;
        }
        if (this.scrollPane != null) {
            this.scrollPane = null;
        }
        if (this.ringModel != null) {
            this.ringModel = null;
        }
        this.parent = null;
        super.dispose();
    }

    private void localDispose() {
        if (this.tableModel != null) {
            this.tableModel.removeTableModelListener(this);
        }
    }

    public void printInfo() {
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            ITdmPortModel iTdmPortModel = null;
            if (this.tableModel.getValueAt(i, 3) instanceof ITdmPortModel) {
                iTdmPortModel = (ITdmPortModel)this.tableModel.getValueAt(i, 3);
            }
            ITdmPortModel iTdmPortModel2 = null;
            if (this.tableModel.getValueAt(i, 4) instanceof ITdmPortModel) {
                iTdmPortModel2 = (ITdmPortModel)this.tableModel.getValueAt(i, 4);
            }
            db.println("For Node: " + this.tableModel.getValueAt(i, 0) + " West Prot=" + BlsrMapPort.asSlashSeparatedString(iTdmPortModel, null) + " East Prot=" + BlsrMapPort.asSlashSeparatedString(iTdmPortModel2, null));
        }
    }

    public void enteringPage() throws Exception {
        super.enteringPage();
        if (!this.inited) {
            this.initialize();
        }
        if (null != this.tableModel) {
            this.tableModel.refreshFromModel();
        }
        this.parent.setFinishEnabled(this.allProtectPortsSelected());
    }

    private void initialize() {
        if (RcdProtectPortPane.db.on) {
            db.println("initialize() called");
        }
        this.table = new UTable(null);
        this.scrollPane = new UScrollPane((Component)this.table);
        this.add((Component)this.scrollPane, "Center");
        this.inited = true;
    }

    public void apply() throws Exception {
        if (this.tableModel != null) {
            this.tableModel.applyToModel();
        }
    }

    public void unapply() throws Exception {
        if (this.tableModel != null) {
            this.tableModel.unapplyToModel();
        }
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.allProtectPortsSelected()) {
            this.parent.setFinishEnabled(true);
        } else {
            this.parent.setFinishEnabled(false);
        }
    }

    private boolean allProtectPortsSelected() {
        boolean bl = true;
        if (RcdProtectPortPane.db.on) {
            db.println("allProtectPortsSelected() called.");
        }
        if (this.ringModel != null) {
            BlsrNode[] blsrNodeArray = this.ringModel.getBlsrNodes();
            ITdmPortModel[] iTdmPortModelArray = this.tableModel.getEastProtectPorts();
            ITdmPortModel[] iTdmPortModelArray2 = this.tableModel.getWestProtectPorts();
            for (int i = 0; i < blsrNodeArray.length; ++i) {
                if (iTdmPortModelArray[i] != null && iTdmPortModelArray2[i] != null && !blsrNodeArray[i].getEastPort().equals(iTdmPortModelArray[i]) && !blsrNodeArray[i].getWestPort().equals(iTdmPortModelArray2[i])) continue;
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public CSHelpID getHelpID() {
        return NetCSHelpConst.RcdProtectPortPane;
    }

    private class TdmPortModelRenderer
    extends DefaultTableCellRenderer {
        BlsrNode[] nodes = new BlsrNode[0];

        public TdmPortModelRenderer(BlsrRingModel blsrRingModel) {
            this.nodes = blsrRingModel.getBlsrNodes();
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (object == null || n >= this.nodes.length) {
                this.setText(noSelection);
            } else if (object instanceof ITdmPortModel) {
                ITdmPortModel iTdmPortModel = (ITdmPortModel)object;
                if (n2 == 2 && iTdmPortModel.equals(this.nodes[n].getWestPort()) || n2 == 4 && iTdmPortModel.equals(this.nodes[n].getEastPort())) {
                    this.setText(noSelection);
                } else {
                    this.setText(BlsrMapPort.asSlashSeparatedString(iTdmPortModel, null));
                }
            } else {
                this.setText(object.toString());
            }
            return this;
        }
    }

    private class ProtectPortEditor
    extends DefaultCellEditor {
        private DefaultComboBoxModel choices;
        private BlsrRingModel ringModel;
        private BlsrNode[] nodes;

        public ProtectPortEditor(BlsrRingModel blsrRingModel) {
            super((JComboBox<?>)new UComboBox());
            this.ringModel = blsrRingModel;
            this.nodes = blsrRingModel.getBlsrNodes();
            if (db.on) {
                db.println("A NEW ProtectPortEditor was created for ringModel: " + blsrRingModel);
                db.println("The nodes involved number:" + this.nodes.length);
                for (int i = 0; i < this.nodes.length; ++i) {
                    db.println("node " + i + " is: " + this.nodes[i]);
                }
            }
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            super.getTableCellEditorComponent(jTable, object, bl, n, n2);
            UComboBox uComboBox = (UComboBox)this.getComponent();
            BlsrNode blsrNode = this.nodes[n];
            if (blsrNode != null) {
                uComboBox.setRenderer((ListCellRenderer)new TdmPortListCellRenderer());
                TreeSet treeSet = new TreeSet(new EntityComparator());
                treeSet.addAll(this.ringModel.getAvailableProtectPorts(blsrNode.getNodeModel()));
                if (!blsrNode.is15600Node()) {
                    int n3 = blsrNode.getWestPort().getSlot();
                    int n4 = blsrNode.getEastPort().getSlot();
                    Iterator iterator = treeSet.iterator();
                    while (iterator.hasNext()) {
                        IEntityModel iEntityModel = (IEntityModel)iterator.next();
                        if (iEntityModel.getSlot() != n3 && iEntityModel.getSlot() != n4) continue;
                        iterator.remove();
                    }
                }
                this.choices = new DefaultComboBoxModel<Object>(treeSet.toArray());
                uComboBox.setModel((ComboBoxModel)this.choices);
                uComboBox.insertItemAt((Object)noSelection, 0);
                if (n2 == 2) {
                    ITdmPortModel iTdmPortModel = blsrNode.getWestProtectPort();
                    if (!blsrNode.getWestPort().equals(iTdmPortModel) && iTdmPortModel != null) {
                        uComboBox.setSelectedItem((Object)iTdmPortModel);
                    } else {
                        uComboBox.setSelectedIndex(0);
                    }
                } else if (n2 == 4) {
                    ITdmPortModel iTdmPortModel = blsrNode.getEastProtectPort();
                    if (!blsrNode.getEastPort().equals(iTdmPortModel) && iTdmPortModel != null) {
                        uComboBox.setSelectedItem((Object)iTdmPortModel);
                    } else {
                        uComboBox.setSelectedIndex(0);
                    }
                } else {
                    uComboBox.setSelectedIndex(0);
                }
            }
            return uComboBox;
        }

        private class TdmPortListCellRenderer
        extends DefaultListCellRenderer {
            private TdmPortListCellRenderer() {
            }

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                if (object == null) {
                    this.setText(noSelection);
                } else if (object instanceof ITdmPortModel) {
                    ITdmPortModel iTdmPortModel = (ITdmPortModel)object;
                    this.setText(BlsrMapPort.asSlashSeparatedString(iTdmPortModel, null));
                } else {
                    this.setText(object.toString());
                }
                return this;
            }
        }
    }

    private class EntityComparator
    implements Comparator {
        private EntityComparator() {
        }

        public int compare(Object object, Object object2) {
            return ComparisonUtil.compare((int)((IEntityModel)object).getEntityIndex(), (int)((IEntityModel)object2).getEntityIndex());
        }
    }
}

