/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.blsr;

import cerent.cms.model.event.EventFilter;
import cerent.cms.model.event.NetworkAlarmStore;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.blsr.AbstractBlsrWizardPane;
import cerent.cms.ui.blsr.RingCreationDialog;
import cerent.cms.ui.event.EventPanel;
import cerent.util.TDMTerminology;
import cerent.util.gui.MultiLineLabelUI;
import cerent.util.gui.row.RowDataSource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.LabelUI;

public class RcdUpsr2BlsrPane
extends AbstractBlsrWizardPane {
    public static final int FORCE_PAGE = 1;
    public static final int CONVERT_PAGE = 2;
    private final String UPSR_TERM;
    private final String BLSR_TERM;
    private RingCreationDialog parent;
    private JPanel descPane;
    private int step;
    private NetworkAlarmStore nas;
    private boolean isEnabled;
    private boolean isActive;

    public RcdUpsr2BlsrPane(String string, RingCreationDialog ringCreationDialog, int n) {
        super(string, ringCreationDialog);
        this.parent = ringCreationDialog;
        this.step = n;
        this.nas = NetworkAlarmStore.instance();
        TDMTerminology tDMTerminology = RingCreationDialog.tdmTerm;
        this.UPSR_TERM = tDMTerminology.getRingTerms(0);
        this.BLSR_TERM = tDMTerminology.getRingTerms(1);
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.descPane = this.getDescPane();
        this.add(this.descPane);
    }

    public void enteringPage() {
        EventFilter eventFilter = this.nas.getEventFilter();
        this.isEnabled = eventFilter.isEnabled();
        this.isActive = eventFilter.isActive();
        if (this.step == 2) {
            this.updatePane();
        }
        Dimension dimension = this.parent.getSize();
        this.parent.setSize(new Dimension(dimension.width, 375));
        this.revalidate();
        this.parent.validate();
    }

    public void leavingPage() {
        EventFilter eventFilter = this.nas.getEventFilter();
        eventFilter.setEnabled(this.isEnabled);
        eventFilter.setActive(this.isActive);
        eventFilter.refreshCriteria();
    }

    private void updatePane() {
        this.removeAll();
        if (this.hasSAAlarms()) {
            this.add(this.buildSAPane());
        } else {
            this.add(this.descPane);
        }
    }

    private boolean hasSAAlarms() {
        ArrayList arrayList = this.nas.getAlarmByService(true);
        return arrayList.size() > 0;
    }

    private JPanel buildSAPane() {
        JPanel jPanel = new JPanel();
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("Force has been applied to the shortest " + this.UPSR_TERM + " paths.\n");
        stringBuffer.append("There are service affecting alarms currently raised:");
        StringBuffer stringBuffer2 = new StringBuffer("");
        stringBuffer2.append("If the service affecting alarms shown above are not ");
        stringBuffer2.append("related to this UPSR to\nBLSR conversion, then you may ");
        stringBuffer2.append("proceed. Otherwise, it is recommended that you Cancel\n");
        stringBuffer2.append("this upgrade and resolve the service affecting issues.\n\n");
        stringBuffer2.append("The system is about to convert the circuit protection from ");
        stringBuffer2.append(this.UPSR_TERM + " to 2F-" + this.BLSR_TERM + ".\n");
        stringBuffer2.append("The longer of the " + this.UPSR_TERM);
        stringBuffer2.append(" paths will be removed and a 2F-" + this.BLSR_TERM);
        stringBuffer2.append(" ring will be created.\n");
        stringBuffer2.append("Traffic will be unprotected for a brief moment during the ");
        stringBuffer2.append(this.UPSR_TERM + " to 2F-" + this.BLSR_TERM + " conversion.\n\n");
        stringBuffer2.append("When you are ready, click Finish.");
        EventFilter eventFilter = this.nas.getEventFilter();
        eventFilter.setActive(true);
        eventFilter.buildAndSetMatchers(eventFilter.readSeverityFromPreferences(), eventFilter.readTimeFromPreferences(), eventFilter.readConditionFromPreferences(), eventFilter.createSAMatcher(true));
        JLabel jLabel = this.createMultiLineLabel(stringBuffer.toString());
        EventPanel eventPanel = new EventPanel((RowDataSource)this.nas, null, 193);
        JLabel jLabel2 = this.createMultiLineLabel(stringBuffer2.toString());
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jLabel, "North");
        jPanel.add((Component)eventPanel, "Center");
        jPanel.add((Component)jLabel2, "South");
        return jPanel;
    }

    private JPanel getDescPane() {
        JPanel jPanel = new JPanel();
        JLabel jLabel = this.createMultiLineLabel(this.getDesc());
        jPanel.add(jLabel);
        return jPanel;
    }

    private String getDesc() {
        String string = "";
        switch (this.step) {
            case 1: {
                string = "The system is about to force traffic to the shortest " + this.UPSR_TERM + " paths.\n \n" + "When you are ready, click Next.";
                break;
            }
            case 2: {
                string = "Force has been applied to the shortest " + this.UPSR_TERM + " paths.\n" + "There are no service affecting alarms currently raised.\n\n" + "The system is about to convert the circuit protection from " + this.UPSR_TERM + " to 2F-" + this.BLSR_TERM + ".\n" + "The longer of the " + this.UPSR_TERM + " paths will be removed and a 2F-" + this.BLSR_TERM + " ring will be created.\n" + "Traffic will be unprotected for a brief moment during the " + this.UPSR_TERM + " to 2F-" + this.BLSR_TERM + " conversion.\n \n" + "When you are ready, click Finish.";
            }
        }
        return string;
    }

    public void validatePage() throws Exception {
        switch (this.step) {
            case 1: {
                this.performForceTraffic();
            }
        }
    }

    private void performForceTraffic() throws Exception {
        this.parent.switchTrafficToShortestPath();
        if (!this.parent.rcdCreationPane.okToProceed()) {
            throw new Exception("Unable to proceed until would-be PCA circuits are deleted.");
        }
        Thread.sleep(5000L);
    }

    protected boolean okToProceed() {
        return true;
    }

    public void refresh() {
        if (this.step == 2) {
            this.parent.setFinishEnabled(true);
        }
    }

    private JLabel createMultiLineLabel(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setUI((LabelUI)new MultiLineLabelUI());
        return jLabel;
    }

    public CSHelpID getHelpID() {
        CSHelpID cSHelpID = null;
        switch (this.step) {
            case 1: {
                cSHelpID = NetCSHelpConst.UpsrToBlsrForceTrafficPane;
                break;
            }
            case 2: {
                cSHelpID = NetCSHelpConst.UpsrToBlsrConversionPane;
            }
        }
        return cSHelpID;
    }
}

