/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.INodeModel;
import cerent.cms.model.blsr.BlsrRingManager;
import cerent.cms.model.blsr.BlsrRingModel;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.Network;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.WzStatusPanel;
import cerent.cms.ui.circuits.CircuitMapUtil;
import cerent.cms.ui.circuits.RoutingConstraint;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.gui.GridPanel;
import cerent.util.gui.UOptionDialog;
import com.cisco.ctc.util.map.MapNode;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class BlsrDriDialog
extends UOptionDialog {
    static final SDebug db = new SDebug("BlsrDriDialog");
    static String USE_RIP_STRING = "Use ring interworking on protection (RIP) bandwidth on secondary path";
    static String SELECT_A_NODE_STRING = "< Please Select a Node >";
    static String SELECT_A_NODE_STRING_OPT = "< Please Select a Node (Optional) >";
    protected static final int NOT_OK = 0;
    protected static final int OK_TRADITIONAL = 1;
    protected static final int OK_NONTRADITIONAL = 2;
    protected static final int RINGS_VALID_FOR_15600 = 0;
    protected static final int RINGS_NOT_VALID_FOR_15600 = 1;
    JComboBox instanceP1CB;
    JComboBox instanceS1CB;
    JComboBox instanceP2CB;
    JComboBox instanceS2CB;
    JComboBox instanceRing1CB;
    JComboBox instanceRing2CB;
    boolean instanceAllowRipAndRings;

    private static INetElement getNetElement(MapNode mapNode) {
        if (mapNode == null) {
            return null;
        }
        INodeModel iNodeModel = (INodeModel)mapNode.getUserObject();
        return Network.instance().getNetElem(iNodeModel.getNodeId());
    }

    public static RoutingConstraint getRoutingConstraint(Vector vector, final boolean bl, JDialog jDialog) {
        String string;
        Object object;
        JPanel jPanel;
        final DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        final DefaultComboBoxModel<String> defaultComboBoxModel2 = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement(CircuitMapUtil.UPSR_TERM);
        defaultComboBoxModel2.addElement(CircuitMapUtil.UPSR_TERM);
        final JComboBox<Object> jComboBox = new JComboBox<Object>(defaultComboBoxModel);
        final JComboBox<Object> jComboBox2 = new JComboBox<Object>(defaultComboBoxModel2);
        BlsrDriRingCellRenderer blsrDriRingCellRenderer = new BlsrDriRingCellRenderer();
        jComboBox.setRenderer(blsrDriRingCellRenderer);
        jComboBox2.setRenderer(blsrDriRingCellRenderer);
        RoutingConstraint routingConstraint = null;
        if (vector == null) {
            return null;
        }
        if (vector.size() < 2) {
            String string2 = "There are not enough available nodes to add a(n) " + CircuitMapUtil.BLSRDRI_TERM + ".";
            ErrorMsg.displayDetailed((Component)jDialog, NEMC.EID_NODE_SELECTION_ERROR, string2);
            return null;
        }
        Vector vector2 = (Vector)vector.clone();
        vector2.add(SELECT_A_NODE_STRING);
        Vector vector3 = (Vector)vector.clone();
        vector3.add(SELECT_A_NODE_STRING_OPT);
        StringAndMapNodeComparator stringAndMapNodeComparator = new StringAndMapNodeComparator();
        Collections.sort(vector2, stringAndMapNodeComparator);
        Collections.sort(vector3, stringAndMapNodeComparator);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        GridPanel gridPanel = new GridPanel();
        GridPanel gridPanel2 = new GridPanel();
        jPanel2.add((Component)gridPanel, "West");
        jPanel2.add((Component)gridPanel2, "East");
        jPanel2.add(Box.createVerticalStrut(5), "South");
        final JComboBox jComboBox3 = new JComboBox(vector2);
        final JComboBox jComboBox4 = new JComboBox(vector2);
        jComboBox3.setSelectedItem(SELECT_A_NODE_STRING);
        jComboBox4.setSelectedItem(SELECT_A_NODE_STRING);
        JCheckBox jCheckBox = new JCheckBox(USE_RIP_STRING);
        gridPanel.setBorder(BorderFactory.createEmptyBorder());
        gridPanel.addRow("Primary Node:", jComboBox3);
        gridPanel.addRow("Secondary Node:", jComboBox4);
        gridPanel2.setBorder((Border)BorderFactory.createTitledBorder("For Traditional " + CircuitMapUtil.BLSRDRI2_TERM + "s Only"));
        final JComboBox jComboBox5 = new JComboBox(vector3);
        final JComboBox jComboBox6 = new JComboBox(vector3);
        jComboBox5.setSelectedItem(SELECT_A_NODE_STRING_OPT);
        jComboBox6.setSelectedItem(SELECT_A_NODE_STRING_OPT);
        JLabel jLabel = new JLabel("Primary Node #2:");
        JLabel jLabel2 = new JLabel("Secondary Node #2:");
        gridPanel2.addRow((JComponent)jLabel, jComboBox5);
        gridPanel2.addRow((JComponent)jLabel2, jComboBox6);
        JPanel jPanel3 = null;
        if (bl) {
            jPanel3 = new JPanel();
            jPanel3.setLayout(new BorderLayout());
            jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            jPanel.add((Component)jCheckBox, "West");
            jCheckBox.setVisible(bl);
            object = new JPanel();
            ((Container)object).setLayout(new GridLayout(1, 2));
            string = new GridPanel();
            string.addRow("The first ring is ", jComboBox);
            string.addRow("The second ring is ", jComboBox2);
            ((Container)object).add((Component)((Object)string));
            ((Container)object).add(new JPanel());
            jPanel3.add((Component)jPanel, "South");
            jPanel3.add((Component)object, "North");
        }
        if (vector.size() < 4) {
            jComboBox5.setEnabled(false);
            jComboBox6.setEnabled(false);
            jLabel.setEnabled(false);
            jLabel2.setEnabled(false);
        }
        jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)WzStatusPanel.encapsulateComponent(jPanel2, null, "Node Options"), "North");
        if (jPanel3 != null) {
            jPanel.add((Component)WzStatusPanel.encapsulateComponent(jPanel3, null, "Ring and Path Options"), "Center");
        }
        object = "OK";
        string = "Cancel";
        Object[] objectArray = new Object[]{jPanel};
        Object[] objectArray2 = new Object[]{object, string, CSHelpButton.getCaption()};
        JOptionPane jOptionPane = new JOptionPane(objectArray, -1, 0, null, objectArray2, objectArray2[0]);
        ArrayList<Serializable> arrayList = new ArrayList<Serializable>();
        arrayList.add(jOptionPane);
        arrayList.add(jComboBox3);
        arrayList.add(jComboBox4);
        arrayList.add(jComboBox5);
        arrayList.add(jComboBox6);
        arrayList.add(jComboBox);
        arrayList.add(jComboBox2);
        arrayList.add(new Boolean(bl));
        BlsrDriDialog blsrDriDialog = BlsrDriDialog.instance(jDialog, true, CircuitMapUtil.BLSRDRI_TERM + " Options", arrayList);
        final JButton jButton = BlsrDriDialog.getStringButton(jOptionPane, (String)object);
        if (jButton != null) {
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = BlsrDriDialog.validateComboBoxes(jComboBox3, jComboBox4, jComboBox5, jComboBox6, jComboBox, jComboBox2, bl);
                    if (bl) {
                        int n2;
                        LinkedList linkedList;
                        INetElement iNetElement;
                        INetElement iNetElement2;
                        MapNode mapNode;
                        MapNode mapNode2;
                        Object object = jComboBox.getSelectedItem();
                        Object object2 = jComboBox2.getSelectedItem();
                        defaultComboBoxModel.removeAllElements();
                        defaultComboBoxModel.addElement(CircuitMapUtil.UPSR_TERM);
                        defaultComboBoxModel2.removeAllElements();
                        if (jComboBox3.getSelectedItem() instanceof MapNode && jComboBox4.getSelectedItem() instanceof MapNode) {
                            mapNode2 = (MapNode)jComboBox3.getSelectedItem();
                            mapNode = (MapNode)jComboBox4.getSelectedItem();
                            iNetElement2 = BlsrDriDialog.getNetElement(mapNode2);
                            iNetElement = BlsrDriDialog.getNetElement(mapNode);
                            linkedList = BlsrDriDialog.getBlsrRings(iNetElement2, iNetElement);
                            for (n2 = 0; n2 < linkedList.size(); ++n2) {
                                defaultComboBoxModel.addElement(linkedList.get(n2));
                            }
                        }
                        if (jComboBox5.getSelectedItem() instanceof MapNode && jComboBox6.getSelectedItem() instanceof MapNode) {
                            defaultComboBoxModel2.addElement(CircuitMapUtil.UPSR_TERM);
                            mapNode2 = (MapNode)jComboBox5.getSelectedItem();
                            mapNode = (MapNode)jComboBox6.getSelectedItem();
                            iNetElement2 = BlsrDriDialog.getNetElement(mapNode2);
                            iNetElement = BlsrDriDialog.getNetElement(mapNode);
                            linkedList = BlsrDriDialog.getBlsrRings(iNetElement2, iNetElement);
                            for (n2 = 0; n2 < linkedList.size(); ++n2) {
                                defaultComboBoxModel2.addElement(linkedList.get(n2));
                            }
                        } else {
                            for (int i = 0; i < defaultComboBoxModel.getSize(); ++i) {
                                defaultComboBoxModel2.addElement(defaultComboBoxModel.getElementAt(i));
                            }
                        }
                        jComboBox.setSelectedItem(object);
                        if (jComboBox.getSelectedItem() == null) {
                            jComboBox.setSelectedItem(CircuitMapUtil.UPSR_TERM);
                        }
                        jComboBox2.setSelectedItem(object2);
                        if (jComboBox2.getSelectedItem() == null) {
                            jComboBox2.setSelectedItem(CircuitMapUtil.UPSR_TERM);
                        }
                    } else if (db.on()) {
                        db.println("No Ring1+2CB action because allowRipAndRings is FALSE");
                    }
                    jButton.setEnabled(n == 1 || n == 2);
                }
            };
            jComboBox3.addActionListener(actionListener);
            jComboBox4.addActionListener(actionListener);
            jComboBox5.addActionListener(actionListener);
            jComboBox6.addActionListener(actionListener);
            jComboBox.addActionListener(actionListener);
            jComboBox2.addActionListener(actionListener);
            jButton.setEnabled(false);
        } else if (db.on()) {
            db.println("Could not get the OK Button object! Smart-OK disable not turned on; but validation will still be done when clicking OK.");
        }
        blsrDriDialog.show();
        if (jOptionPane.getValue().equals(object)) {
            int n = BlsrDriDialog.validateComboBoxes(jComboBox3, jComboBox4, jComboBox5, jComboBox6, jComboBox, jComboBox2, bl);
            boolean bl2 = n == 1;
            int n2 = bl2 ? 2 : 3;
            MapNode mapNode = (MapNode)jComboBox3.getSelectedItem();
            MapNode mapNode2 = (MapNode)jComboBox4.getSelectedItem();
            MapNode mapNode3 = bl2 ? (MapNode)jComboBox5.getSelectedItem() : null;
            MapNode mapNode4 = bl2 ? (MapNode)jComboBox6.getSelectedItem() : null;
            String string3 = "       ";
            int n3 = BlsrDriDialog.validateFor15600(mapNode, mapNode2, mapNode3, mapNode4, jComboBox.getSelectedItem(), jComboBox2.getSelectedItem(), n);
            if (n3 == 1) {
                ErrorMsg.displayError((Component)((Object)blsrDriDialog), NEMC.EID_RINGS_NOT_VALID_FOR_15600, CircuitMapUtil.BLSRDRI_TERM, CircuitMapUtil.BLSRDRI_TERM);
                return null;
            }
            String string4 = (bl2 ? "Traditional" : "Non-Traditional") + " " + CircuitMapUtil.BLSRDRI_TERM;
            string4 = string4 + "\n" + string3 + "Pri #1= " + ((INodeModel)mapNode.getUserObject()).getName() + ", Sec #1=" + ((INodeModel)mapNode2.getUserObject()).getName();
            if (bl2) {
                string4 = string4 + "\n" + string3 + "Pri #2=" + ((INodeModel)mapNode3.getUserObject()).getName() + ", Sec #2=" + ((INodeModel)mapNode4.getUserObject()).getName();
            }
            routingConstraint = new RoutingConstraint(n2);
            routingConstraint.setUsePca(jCheckBox.isSelected());
            routingConstraint.addElementConstraint(BlsrDriDialog.getNetElement(mapNode), BlsrDriDialog.getNetElement(mapNode2));
            if (bl2) {
                routingConstraint.addElementConstraint(BlsrDriDialog.getNetElement(mapNode3), BlsrDriDialog.getNetElement(mapNode4));
            }
            if (jCheckBox.isSelected()) {
                string4 = string4 + "\n" + string3 + USE_RIP_STRING;
            }
            if (bl) {
                string4 = string4 + "\n" + string3 + "First Ring: ";
                if (jComboBox.getSelectedItem() instanceof BlsrRingModel) {
                    routingConstraint.setFirstRingModel((BlsrRingModel)jComboBox.getSelectedItem());
                    string4 = string4 + routingConstraint.getFirstRingModel().getBlsrRingInfo().getRingName();
                } else {
                    routingConstraint.setFirstRingModel(null);
                    string4 = string4 + "<" + CircuitMapUtil.UPSR_TERM + ">";
                }
                string4 = string4 + ", Second Ring: ";
                if (jComboBox2.getSelectedItem() instanceof BlsrRingModel) {
                    routingConstraint.setSecondRingModel((BlsrRingModel)jComboBox2.getSelectedItem());
                    string4 = string4 + routingConstraint.getSecondRingModel().getBlsrRingInfo().getRingName();
                } else {
                    routingConstraint.setSecondRingModel(null);
                    string4 = string4 + "<" + CircuitMapUtil.UPSR_TERM + ">";
                }
            }
            routingConstraint.setLabel(string4);
            if (db.on()) {
                RoutingConstraint.dump(routingConstraint, db);
            }
        }
        return routingConstraint;
    }

    private static LinkedList getBlsrRings(INetElement iNetElement, INetElement iNetElement2) {
        INodeModel iNodeModel = iNetElement.getNodeModel();
        INodeModel iNodeModel2 = iNetElement2.getNodeModel();
        BlsrRingModel[] blsrRingModelArray = BlsrRingManager.instance().getBlsrRingModels(iNodeModel);
        BlsrRingModel[] blsrRingModelArray2 = BlsrRingManager.instance().getBlsrRingModels(iNodeModel2);
        LinkedList<BlsrRingModel> linkedList = new LinkedList<BlsrRingModel>();
        for (int i = 0; i < blsrRingModelArray.length; ++i) {
            for (int j = 0; j < blsrRingModelArray2.length; ++j) {
                if (blsrRingModelArray[i] != blsrRingModelArray2[j]) continue;
                linkedList.add(blsrRingModelArray[i]);
            }
        }
        return linkedList;
    }

    static BlsrDriDialog instance(Component component, boolean bl, String string, List list) {
        Frame frame = JOptionPane.getFrameForComponent(component);
        BlsrDriDialog blsrDriDialog = (BlsrDriDialog)BlsrDriDialog.getRecycledDialog((Frame)frame, (String)string, (Class)BlsrDriDialog.class, (Object)list);
        if (blsrDriDialog == null) {
            blsrDriDialog = new BlsrDriDialog(frame, string, bl, list);
        }
        return blsrDriDialog;
    }

    BlsrDriDialog(Frame frame, String string, boolean bl, List list) {
        super(frame, string, bl, list);
    }

    private static boolean is15600(MapNode mapNode) {
        if (mapNode == null) {
            return false;
        }
        return BlsrDriDialog.getNetElement(mapNode).getNodeModel().getChassis().getEqType() == 92;
    }

    private static boolean isFourFiber(Object object) {
        if (object != null && object instanceof BlsrRingModel) {
            return ((BlsrRingModel)object).getBlsrRingInfo().isFourFiber();
        }
        return false;
    }

    static int validateFor15600(MapNode mapNode, MapNode mapNode2, MapNode mapNode3, MapNode mapNode4, Object object, Object object2, int n) {
        if (!BlsrDriDialog.isFourFiber(object) && !BlsrDriDialog.isFourFiber(object2)) {
            return 0;
        }
        if (n == 1) {
            if (BlsrDriDialog.isFourFiber(object) && (BlsrDriDialog.is15600(mapNode) || BlsrDriDialog.is15600(mapNode2)) || BlsrDriDialog.isFourFiber(object2) && (BlsrDriDialog.is15600(mapNode3) || BlsrDriDialog.is15600(mapNode4))) {
                return 1;
            }
        } else if (n == 2) {
            boolean bl;
            boolean bl2;
            boolean bl3 = bl2 = object == CircuitMapUtil.UPSR_TERM;
            if (bl2 && BlsrDriDialog.isFourFiber(object2) && (BlsrDriDialog.is15600(mapNode) || BlsrDriDialog.is15600(mapNode2))) {
                return 1;
            }
            boolean bl4 = bl = object2 == CircuitMapUtil.UPSR_TERM;
            if (BlsrDriDialog.isFourFiber(object) && bl && (BlsrDriDialog.is15600(mapNode) || BlsrDriDialog.is15600(mapNode2))) {
                return 1;
            }
            if ((BlsrDriDialog.isFourFiber(object) || BlsrDriDialog.isFourFiber(object2)) && (BlsrDriDialog.is15600(mapNode) || BlsrDriDialog.is15600(mapNode2))) {
                return 1;
            }
        }
        return 0;
    }

    static int validateComboBoxes(JComboBox jComboBox, JComboBox jComboBox2, JComboBox jComboBox3, JComboBox jComboBox4, JComboBox jComboBox5, JComboBox jComboBox6, boolean bl) {
        Object object;
        Object object2;
        if (bl) {
            object2 = jComboBox5.getSelectedItem();
            object = jComboBox6.getSelectedItem();
            if (object2 == CircuitMapUtil.UPSR_TERM && object == CircuitMapUtil.UPSR_TERM) {
                return 0;
            }
            if (object2 == object) {
                return 0;
            }
        }
        object2 = jComboBox.getSelectedItem();
        object = jComboBox2.getSelectedItem();
        Object object3 = jComboBox3.getSelectedItem();
        Object object4 = jComboBox4.getSelectedItem();
        boolean bl2 = object2 != SELECT_A_NODE_STRING;
        boolean bl3 = object != SELECT_A_NODE_STRING;
        boolean bl4 = object3 != SELECT_A_NODE_STRING_OPT;
        boolean bl5 = object4 != SELECT_A_NODE_STRING_OPT;
        HashSet<Object> hashSet = new HashSet<Object>();
        if (!bl2 || !bl3) {
            return 0;
        }
        hashSet.add(object2);
        if (hashSet.contains(object)) {
            return 0;
        }
        hashSet.add(object);
        if (!bl4 && bl5 || !bl5 && bl4) {
            return 0;
        }
        if (bl4 && bl5) {
            if (hashSet.contains(object3)) {
                return 0;
            }
            hashSet.add(object3);
            if (hashSet.contains(object4)) {
                return 0;
            }
            return 1;
        }
        return 2;
    }

    protected static JButton getStringButton(JOptionPane jOptionPane, String string) {
        Component[] componentArray = jOptionPane.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Component[] componentArray2 = ((JPanel)componentArray[i]).getComponents();
            for (int j = 0; j < componentArray2.length; ++j) {
                if (!(componentArray2[j] instanceof JButton) || !((JButton)componentArray2[j]).getText().equals(string)) continue;
                return (JButton)componentArray2[j];
            }
        }
        return null;
    }

    protected void setValuesFromList(List list) {
        super.setValuesFromList(list);
        this.instanceP1CB = (JComboBox)list.get(1);
        this.instanceS1CB = (JComboBox)list.get(2);
        this.instanceP2CB = (JComboBox)list.get(3);
        this.instanceS2CB = (JComboBox)list.get(4);
        this.instanceRing1CB = (JComboBox)list.get(5);
        this.instanceRing2CB = (JComboBox)list.get(6);
        this.instanceAllowRipAndRings = (Boolean)list.get(7);
    }

    protected void checkOtherOptionValues(String string) {
        if (string.equals(CSHelpButton.getCaption())) {
            CSHelpButton cSHelpButton = new CSHelpButton();
            cSHelpButton.launchHelp((Window)((Object)this), NetCSHelpConst.BlsrDriDialog);
        } else {
            int n;
            if (string.equals("OK") && (n = BlsrDriDialog.validateComboBoxes(this.instanceP1CB, this.instanceS1CB, this.instanceP2CB, this.instanceS2CB, this.instanceRing1CB, this.instanceRing2CB, this.instanceAllowRipAndRings)) == 0) {
                String string2 = "Please select a valid node combination";
                ErrorMsg.displayDetailed((Component)((Object)this), NEMC.EID_NODE_SELECTION_ERROR, string2);
                this.jopane.setValue(null);
                return;
            }
            this.confirmExit();
        }
    }

    protected void confirmCancel() {
        this.confirmExit();
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.jopane.setValue(null);
    }

    static class BlsrDriRingCellRenderer
    extends DefaultListCellRenderer {
        public BlsrDriRingCellRenderer() {
            this.setOpaque(true);
        }

        private static String calculateRingString(BlsrRingModel blsrRingModel) {
            return CircuitMapUtil.BLSR_TERM + ": " + blsrRingModel.getRingName() + " (" + blsrRingModel.getBlsrRingInfo().getRingTypeString() + " " + blsrRingModel.getBlsrRingInfo().getRingSpeedString() + ")";
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof BlsrRingModel) {
                this.setText(BlsrDriRingCellRenderer.calculateRingString((BlsrRingModel)object));
            } else {
                this.setText(object.toString());
            }
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(Color.white);
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(Color.black);
            }
            return this;
        }
    }

    static class StringAndMapNodeComparator
    implements Comparator {
        StringAndMapNodeComparator() {
        }

        public int compare(Object object, Object object2) {
            String string = object.toString();
            String string2 = object2.toString();
            if (object instanceof MapNode) {
                string = ((MapNode)object).getName();
            }
            if (object2 instanceof MapNode) {
                string2 = ((MapNode)object2).getName();
            }
            return string.compareTo(string2);
        }

        public boolean equals(Object object) {
            return this.equals(object);
        }
    }
}

