/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.CircuitType;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.IRevertiveBehavior;
import cerent.cms.route.INetLinkSpan;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.NetLink;
import cerent.cms.ui.RevertiveBehaviorPanel;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.circuits.AbstractCircuitDialog;
import cerent.cms.ui.circuits.AutorangeInfo;
import cerent.cms.ui.circuits.CcdVcatRoutePane;
import cerent.cms.ui.circuits.CircuitDesignMap;
import cerent.cms.ui.circuits.CircuitMapUtil;
import cerent.cms.ui.circuits.VcatMemberTableData;
import cerent.cms.ui.circuits.WzCcdPane;
import cerent.cms.ui.network.NetMapLink;
import cerent.util.Preferences;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.IgnorableDialog;
import cerent.util.gui.MultiLineLabelUI;
import cerent.util.gui.OrderedListListener;
import cerent.util.gui.OrderedListModel;
import cerent.util.gui.UTable;
import com.cisco.ctc.util.map.MapGraph;
import com.cisco.ctc.util.map.MapLink;
import com.cisco.ctc.util.map.MapNode;
import com.cisco.ctc.util.map.Node;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.SortedMap;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.LabelUI;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public abstract class CcdCircuitDesignPane
extends WzCcdPane
implements OrderedListListener {
    protected static final int DEFAULT_HEIGHT = 550;
    public static final String ADD_SPAN = "Add Span";
    public static final String ADD = "Add";
    protected static final String REMOVE = "Remove";
    private static final String PREF = "ctc.CircuitDesignPane";
    protected static final String WIDTH = "w";
    protected static final String HEIGHT = "h";
    protected static String LEFT_BORDER = "Included Spans:";
    protected static String RIGHT_BORDER = "Selected Circuit Spans:";
    protected static String NODE_BORDER = "Selected Node:";
    protected CircuitDesignMap circuitMap;
    protected Dimension dim;
    protected JPanel topPanel;
    protected JPanel bottomPanel;
    protected JPanel buttonWrapPanel;
    protected JPanel buttonPanel;
    protected JPanel nodePanel;
    protected JPanel linkPanel;
    protected JPanel displayPanel;
    protected JPanel leftPanel;
    protected JPanel rightPanel;
    protected JPanel b;
    protected JPanel titlePanel;
    protected JPanel arrowPanel;
    protected JLabel nodeLB;
    protected JButton addButton;
    protected JButton addSpanButton;
    protected AbstractButton upButton;
    protected AbstractButton downButton;
    protected AbstractButton removeButton;
    protected SortedMap pathMap;
    protected GridBagLayout gridbag;
    protected JSplitPane mainSplitPane;
    protected DefaultListModel selectedSpanListModel;
    protected INetLinkSpan[] spanList = null;
    protected OrderedListModel olm;
    UTable membersTable;
    MemTableModel membersTableModel;
    String BLSRDRI_NONREVERTIVE_VALUE = "warnNonRevertiveBlsrDri";
    String BLSRDRI_NONREVERTIVE_DESCR = "Warn if BLSR-DRI is non-revertive";
    private boolean addedTable = false;
    public static final String memTableTitle = "VCAT Member Table";
    private final int COL0 = 0;
    private final int COL1 = 1;
    private final int COL2 = 2;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;

    public abstract void actionPerformed(ActionEvent var1);

    abstract boolean setLink(NetMapLink var1);

    abstract void unSetLink();

    abstract boolean setNode(MapNode var1);

    abstract void getMoreUIs();

    abstract void linkSelected(MapLink var1, boolean var2);

    abstract void nodeSelected(MapNode var1, boolean var2);

    abstract void clicked(MapLink var1);

    abstract void domainDisplayed(MapNode var1);

    public CcdCircuitDesignPane(AbstractCircuitDialog abstractCircuitDialog, WzDiagDebug wzDiagDebug, String string, boolean bl) {
        super(abstractCircuitDialog, wzDiagDebug, string);
        this.olm = new OrderedListModel(this, bl);
    }

    void reset() {
        if (this.db.on()) {
            this.db.println("reset()");
        }
        if (this.circuitMap != null) {
            this.cleanup();
        }
    }

    protected void cleanup() {
        if (this.circuitMap != null) {
            ICircuitType iCircuitType = CircuitType.getCircuitType((int)this.getAbstractCktDlg().getCircuitType());
            boolean bl = false;
            if (iCircuitType.isLoCircuitType() || iCircuitType.isLoVcatCircuitType()) {
                bl = true;
            }
            this.resetLinks(bl, this.getAbstractCktDlg().isPca());
            this.circuitMap.resetMarkers(true);
            this.circuitMap.updateView();
        }
    }

    protected void resetLinks(boolean bl, boolean bl2) {
        this.circuitMap.resetLinks(bl, bl2);
    }

    public void validatePage() throws Exception {
    }

    public void revalidateData() {
    }

    protected boolean isNull(Object object, String string) {
        return object == null;
    }

    public boolean handleBack() {
        this.leavingPane();
        if (this.addedTable) {
            JComponent jComponent = this.parent.popStatusInfo();
            this.addedTable = false;
        }
        return super.handleBack();
    }

    void handleFinish() {
        this.resetHeight();
        super.handleFinish();
    }

    protected void resetHeight() {
        if (this.parent != null) {
            Dimension dimension = this.parent.getSize();
            if (dimension.height > 550) {
                Preferences preferences = Preferences.instance();
                preferences.setProperty(PREF, WIDTH, Integer.toString(dimension.width));
                preferences.setProperty(PREF, HEIGHT, Integer.toString(dimension.height));
            }
            this.parent.setSize(this.dim);
        } else if (this.db.on()) {
            this.db.println("tried to resetHeight(), but parent was null.");
        }
    }

    public void leavingPane() {
        this.resetHeight();
        this.getAbstractCktDlg().setFinishEnabled(false);
        this.revalidate();
        this.parent.validate();
    }

    protected void handlePostValidate() {
        IRevertiveBehavior iRevertiveBehavior;
        Object object;
        if (this.addedTable) {
            object = this.parent.popStatusInfo();
            this.addedTable = false;
        }
        if ((object = this.getAutorangeInfo()) != null && (iRevertiveBehavior = this.getAbstractCktDlg().getUpsrReversion()) != null) {
            ((AutorangeInfo)object).upsrReversion = iRevertiveBehavior;
            if (this.db.on()) {
                this.db.println("Autorange UPSR Reversion changed to: " + iRevertiveBehavior);
            }
        }
    }

    public void setViewToCenter() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MapNode mapNode;
                MapGraph mapGraph = CcdCircuitDesignPane.this.circuitMap.getMapGraph();
                Node[] nodeArray = new MapNode[]{mapGraph.getMapNode(CcdCircuitDesignPane.this.getAbstractCktDlg().getSourceNode()), mapGraph.getMapNode(CcdCircuitDesignPane.this.getAbstractCktDlg().getDestNode())};
                if (CcdCircuitDesignPane.this.circuitMap.isNodesInView(nodeArray)) {
                    return;
                }
                Rectangle2D rectangle2D = CcdCircuitDesignPane.this.circuitMap.getRect(nodeArray);
                Rectangle2D rectangle2D2 = CcdCircuitDesignPane.this.circuitMap.getViewRect();
                if ((rectangle2D.getWidth() > rectangle2D2.getWidth() || rectangle2D.getHeight() > rectangle2D2.getHeight()) && (mapNode = mapGraph.getMapNode(CcdCircuitDesignPane.this.getAbstractCktDlg().getSourceNode())) != null) {
                    nodeArray = new MapNode[]{mapNode};
                }
                CcdCircuitDesignPane.this.circuitMap.centerView(nodeArray);
            }
        });
    }

    public void enteringPane() {
        Object object;
        super.enteringPane();
        if (this.circuitMap == null) {
            this.circuitMap = new CircuitDesignMap(this.getAbstractCktDlg());
        }
        this.circuitMap.reInitMap();
        this.circuitMap.showCircuitObjects();
        this.circuitMap.init(this);
        JComponent jComponent = this.circuitMap.getGraphWindow();
        jComponent.setBorder(BorderFactory.createLoweredBevelBorder());
        this.topPanel = new JPanel(new BorderLayout());
        this.topPanel.add((Component)jComponent, "Center");
        this.mainSplitPane.setTopComponent(this.topPanel);
        this.add((Component)this.mainSplitPane, "Center");
        if (CircuitType.getCircuitType((int)this.getAbstractCktDlg().getCircuitType()).isVcatCircuitType()) {
            if (!this.addedTable) {
                this.membersTableModel = new MemTableModel();
                this.membersTable = new UTable((TableModel)this.membersTableModel);
                this.membersTableModel.tabData = this.getAbstractCktDlg().getVcatMemberPrefs();
                this.membersTable.setRowSelectionAllowed(false);
                this.membersTable.setCellSelectionEnabled(false);
                object = new JPanel();
                ((Container)object).setLayout(new BorderLayout());
                ((Container)object).add((Component)this.membersTable.getTableHeader(), "North");
                ((Container)object).add((Component)this.membersTable, "Center");
                this.parent.pushStatusInfo((JComponent)object, memTableTitle);
                this.addedTable = true;
            }
            this.setVcatProtectionType(0);
        }
        this.dim = this.parent.getSize();
        object = Preferences.instance();
        int n = object.getInt(PREF, WIDTH, this.dim.width);
        int n2 = object.getInt(PREF, HEIGHT, Math.max(this.dim.height, 550));
        this.parent.setSize(new Dimension(n, n2));
        this.getAbstractCktDlg().setFinishEnabled(true);
        this.setViewToCenter();
        this.revalidate();
        this.parent.validate();
        this.mainSplitPane.setDividerLocation(0.5);
    }

    protected void setupBottomPanel() {
        this.bottomPanel = CcdCircuitDesignPane.createHorizontalPanel(null);
        this.mainSplitPane.setBottomComponent(this.bottomPanel);
    }

    protected void initPane() {
        this.setLayout(new BorderLayout(1, 1));
        this.mainSplitPane = new JSplitPane(0);
        this.setupBottomPanel();
        this.bottomPanel.setLayout(new BorderLayout());
        this.leftPanel = CcdCircuitDesignPane.createVerticalPanel(null);
        this.bottomPanel.add((Component)this.leftPanel, "Center");
        this.rightPanel = CcdCircuitDesignPane.createVerticalPanel(null);
        this.bottomPanel.add((Component)this.rightPanel, "East");
        this.rightPanel.setLayout(new BorderLayout());
        this.buttonWrapPanel = CcdCircuitDesignPane.createVerticalPanel(null);
        this.rightPanel.add((Component)this.buttonWrapPanel, "West");
        this.displayPanel = CcdCircuitDesignPane.createVerticalPanel(null);
        this.rightPanel.add((Component)this.displayPanel, "Center");
        this.leftPanel.setBorder(BorderFactory.createTitledBorder(LEFT_BORDER));
        this.leftPanel.add(new JScrollPane(this.olm.getJList()));
        this.gridbag = new GridBagLayout();
        this.buttonWrapPanel.setLayout(this.gridbag);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        this.gridbag.setConstraints(this.buttonWrapPanel, gridBagConstraints);
        this.buttonPanel = CcdCircuitDesignPane.createHorizontalPanel(null);
        this.buttonWrapPanel.add(this.buttonPanel);
        this.displayPanel.setLayout(new BorderLayout());
        this.nodePanel = CcdCircuitDesignPane.createHorizontalPanel(null);
        this.displayPanel.add((Component)this.nodePanel, "North");
        this.linkPanel = CcdCircuitDesignPane.createHorizontalPanel(null);
        this.displayPanel.add((Component)this.linkPanel, "Center");
        this.nodePanel.setBorder(BorderFactory.createTitledBorder(NODE_BORDER));
        JLabel jLabel = new JLabel("Node Name: ", 2);
        this.nodePanel.add(jLabel);
        this.nodeLB = new JLabel("  ", 4);
        this.nodePanel.add(this.nodeLB);
        this.getMoreUIs();
    }

    public void recycle() {
        if (this.db.on()) {
            this.db.println("recycle");
        }
        if (this.circuitMap != null) {
            this.circuitMap.dispose();
            this.circuitMap = null;
            this.remove(this.topPanel);
            this.topPanel = null;
        }
        if (this.membersTable != null) {
            this.membersTable = null;
        }
        if (this.membersTableModel != null) {
            this.membersTableModel = null;
        }
    }

    protected boolean isLoCircuit() {
        ICircuitType iCircuitType = CircuitType.getCircuitType((int)this.getAbstractCktDlg().getCircuitInfo().type());
        return iCircuitType.isLoCircuitType() || iCircuitType.isLoVcatCircuitType();
    }

    protected void selectVnodes(MapNode mapNode) {
        MapNode[] mapNodeArray;
        if (mapNode == null) {
            return;
        }
        if (mapNode.isVirtual()) {
            mapNode = mapNode.getRealNode();
        }
        if ((mapNodeArray = mapNode.getVNodes()) != null) {
            for (int i = 0; i < mapNodeArray.length; ++i) {
                if (this.db.on()) {
                    this.db.println("select vnode: " + mapNodeArray[i]);
                }
                if (mapNodeArray[i].isSelected()) continue;
                this.circuitMap.setSelected(mapNodeArray[i], true);
            }
        }
    }

    protected void unSelectVnodes(MapNode mapNode) {
        MapNode[] mapNodeArray;
        if (mapNode == null) {
            return;
        }
        if (mapNode.isVirtual()) {
            mapNode = mapNode.getRealNode();
        }
        if ((mapNodeArray = mapNode.getVNodes()) != null) {
            for (int i = 0; i < mapNodeArray.length; ++i) {
                if (this.db.on()) {
                    this.db.println("unselect vnode: " + mapNodeArray[i]);
                }
                if (!mapNodeArray[i].isSelected()) continue;
                this.circuitMap.setSelected(mapNodeArray[i], false);
            }
        }
    }

    protected boolean continueNonRevertive(INetLink iNetLink) {
        if (iNetLink instanceof NetLink && ((NetLink)iNetLink).isNonRevertivePca() && this.getAbstractCktDlg().isPca()) {
            return CerentDialog.yesNoDialog((Component)this, (String)("This link is on a non-revertive " + CircuitMapUtil.BLSR_TERM + "." + "\nThe circuit may be pre-empted indefinitely.\n\n" + "OK to continue?"), (String)("Non-Revertive " + CircuitMapUtil.BLSR_TERM));
        }
        return true;
    }

    protected void validateUpsrReversion() throws Exception {
        if (this.parent == null) {
            if (this.db.on()) {
                this.db.println("validate reversion returned without exception as parent was null.");
            }
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        IRevertiveBehavior iRevertiveBehavior = this.getAbstractCktDlg().getUpsrReversion();
        if (iRevertiveBehavior == null) {
            if (this.db.on()) {
                this.db.println("validate reversion returned without exception as behavior object was null.");
            }
            return;
        }
        if (iRevertiveBehavior.getReversionMode() == 1) {
            bl = true;
        }
        if (bl || bl2) {
            String string = "";
            if (bl2) {
                string = string + "Circuit attributes did not specify switching on PDI-P.\nBLSR-DRI circuits must switch on PDI-P.\n \n";
            }
            if (bl) {
                string = string + "This circuit is currently configured as non-revertive.\nIt is suggested BLSR-DRI circuits initially be revertive.\n \nThe circuit will use the following reversion settings:";
            }
            JPanel jPanel = new JPanel();
            JLabel jLabel = new JLabel(string);
            jLabel.setUI((LabelUI)new MultiLineLabelUI());
            JCheckBox jCheckBox = null;
            JPanel jPanel2 = null;
            RevertiveBehaviorPanel revertiveBehaviorPanel = null;
            if (bl) {
                revertiveBehaviorPanel = new RevertiveBehaviorPanel(null);
            }
            if (bl2) {
                jPanel2 = new JPanel();
                jPanel2.setLayout(new FlowLayout(0, 5, 5));
                jCheckBox = new JCheckBox("Switch on PDI-P", true);
                jCheckBox.setEnabled(false);
                jPanel2.add(jCheckBox);
            }
            jPanel.setLayout(new BorderLayout());
            jPanel.add((Component)jLabel, "North");
            JPanel jPanel3 = new JPanel();
            if (revertiveBehaviorPanel != null && jPanel2 != null) {
                jPanel3.setLayout(new GridLayout(2, 1));
                jPanel3.add(jPanel2);
                jPanel3.add(revertiveBehaviorPanel);
            } else if (revertiveBehaviorPanel != null) {
                jPanel3 = revertiveBehaviorPanel;
            } else if (jPanel2 != null) {
                jPanel3 = jPanel2;
            }
            jPanel3.setBorder(BorderFactory.createLoweredBevelBorder());
            jPanel.add((Component)jPanel3, "Center");
            IgnorableDialog.warningDialog((Component)this, (Component)jPanel, (String)"This Circuit Is Configured As Non-Revertive", (String)this.BLSRDRI_NONREVERTIVE_VALUE, (String)this.BLSRDRI_NONREVERTIVE_DESCR);
            if (revertiveBehaviorPanel != null) {
                iRevertiveBehavior = revertiveBehaviorPanel.getRevertiveBehavior();
                this.getAbstractCktDlg().setUpsrReversion(iRevertiveBehavior);
            }
            if (jCheckBox != null) {
                this.getAbstractCktDlg().setUpsrSwitchOnPdip(jCheckBox.isSelected());
            }
        }
    }

    protected void setVcatProtectionType(int n) {
        VcatMemberTableData vcatMemberTableData;
        if (this.membersTableModel == null) {
            return;
        }
        try {
            vcatMemberTableData = (VcatMemberTableData)this.membersTableModel.tabData.get(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (this.db.on()) {
                WzDiagDebug.printStackTrace((Throwable)indexOutOfBoundsException);
            }
            return;
        }
        if (vcatMemberTableData.protectionType == 6 || vcatMemberTableData.protectionType == 0) {
            this.getAbstractCktDlg().setPathProt(true);
            this.getAbstractCktDlg().setPca(false);
        } else if (vcatMemberTableData.protectionType == 4) {
            this.getAbstractCktDlg().setPca(true);
            this.getAbstractCktDlg().setPathProt(false);
        } else {
            this.getAbstractCktDlg().setPca(false);
            this.getAbstractCktDlg().setPathProt(false);
        }
    }

    protected int getMemProtectionType(int n) {
        if (this.membersTableModel == null) {
            return 3;
        }
        Iterator iterator = this.membersTableModel.tabData.iterator();
        while (iterator.hasNext()) {
            VcatMemberTableData vcatMemberTableData = (VcatMemberTableData)iterator.next();
            if (vcatMemberTableData.memberNumber != n) continue;
            return vcatMemberTableData.protectionType;
        }
        return 3;
    }

    public void removeListeners() {
    }

    public void dispose() {
        if (this.circuitMap != null) {
            this.circuitMap.dispose();
            this.circuitMap = null;
        }
        this.dim = null;
        this.selectedSpanListModel = null;
        this.olm = null;
        this.membersTable = null;
        this.membersTableModel = null;
        if (this.pathMap != null) {
            this.pathMap.clear();
            this.pathMap = null;
        }
        super.dispose();
    }

    public String getDiagString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer(super.getDiagString());
        stringBuffer.append("OLM (Ordered List Model): " + this.olm + "\n");
        if (this.olm != null) {
            stringBuffer.append("\tSize= " + this.olm.getSize() + "\n");
            for (n = 0; n < this.olm.getSize(); ++n) {
                stringBuffer.append("\tElement #" + (n + 1) + " " + this.olm.getElementAt(n) + "\n");
            }
        }
        stringBuffer.append("CircuitMap: " + this.circuitMap + "\n");
        stringBuffer.append("Members table model: " + this.membersTableModel + "\n");
        if (this.membersTableModel != null) {
            stringBuffer.append("\tSize= " + this.membersTableModel.getRowCount() + "\n");
            for (n = 0; n < this.membersTableModel.getRowCount(); ++n) {
                stringBuffer.append("\tRow " + (n + 1) + ": ");
                for (int i = 0; i < this.membersTableModel.getColumnCount(); ++i) {
                    stringBuffer.append(this.membersTableModel.getValueAt(n, i) + "\t");
                }
                stringBuffer.append("\n");
            }
        }
        stringBuffer.append("SpanList : " + this.spanList + "\n");
        if (this.spanList != null) {
            stringBuffer.append("\tSize= " + this.spanList.length + "\n");
            for (n = 0; n < this.spanList.length; ++n) {
                stringBuffer.append("\tSpan #" + (n + 1) + " " + this.spanList[n] + "\n");
            }
        }
        return stringBuffer.toString();
    }

    class MemTableModel
    extends AbstractTableModel {
        final String[] columnNames = new String[]{"Mem #", "Name", "Protection"};
        ArrayList tabData = new ArrayList();

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.tabData.size();
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public Object getValueAt(int n, int n2) {
            if (this.tabData.size() == 0) {
                return null;
            }
            Object[] objectArray = this.tabData.toArray();
            switch (n2) {
                case 0: {
                    return ((VcatMemberTableData)objectArray[n]).memberNumber;
                }
                case 1: {
                    return ((VcatMemberTableData)objectArray[n]).memberName;
                }
                case 2: {
                    return CcdVcatRoutePane.getProtectionString(((VcatMemberTableData)objectArray[n]).protectionType);
                }
            }
            return null;
        }

        public void setValueAt(Object object, int n, int n2) {
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return class$java$lang$Integer == null ? (class$java$lang$Integer = CcdCircuitDesignPane.class$("java.lang.Integer")) : class$java$lang$Integer;
                }
                case 1: {
                    return class$java$lang$String == null ? (class$java$lang$String = CcdCircuitDesignPane.class$("java.lang.String")) : class$java$lang$String;
                }
                case 2: {
                    return class$java$lang$String == null ? (class$java$lang$String = CcdCircuitDesignPane.class$("java.lang.String")) : class$java$lang$String;
                }
            }
            return class$java$lang$Object == null ? (class$java$lang$Object = CcdCircuitDesignPane.class$("java.lang.Object")) : class$java$lang$Object;
        }
    }
}

