/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.CircuitType;
import cerent.cms.model.Feature;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IML2PosLineModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.NetAdminState;
import cerent.cms.model.ObjNotFound;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.IncorrectCircuitState;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.Network;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.NodeSelector;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.WzPane;
import cerent.cms.ui.circuits.AbstractCcdEndpointPanel;
import cerent.cms.ui.circuits.AbstractCircuitDialog;
import cerent.cms.ui.circuits.AutorangeInfo;
import cerent.cms.ui.circuits.CcdOCHNCEndpointPanel;
import cerent.cms.ui.circuits.RollEndpointsPane;
import cerent.cms.ui.circuits.SdhAu3CcdEndpointPanel;
import cerent.cms.ui.circuits.SdhAu4CcdEndpointPanel;
import cerent.cms.ui.circuits.SonetCcdEndpointPanel;
import cerent.cms.ui.circuits.WzCcdPane;
import cerent.util.AnnotatedException;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.IHoNum;
import cerent.util.NEMC;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.IgnorableDialog;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class CcdEndpointsPane
extends WzCcdPane {
    public static final String ALT_PREFIX = "Secondary ";
    private JPanel leftPanel;
    private JPanel rightPanel;
    Component lfiller = Box.createHorizontalGlue();
    Component rfiller = Box.createHorizontalGlue();
    private JPanel altNodePanel;
    protected NodeSelector nodeCB;
    protected NodeSelector altNodeCB;
    protected JCheckBox useAltCB;
    protected AbstractCcdEndpointPanel mainPanel;
    protected AbstractCcdEndpointPanel altPanel;
    private String endpointName;
    private boolean needEndpoints;
    CcdEndpointsPane excludePane;
    protected INodeModel nodeModel;
    protected INodeModel lastNodeModel;
    private INodeModel altNodeModel;
    private INodeModel lastAltNodeModel;
    boolean ethergroupChoiceAllowed;
    private boolean warnedDri = false;
    List availPorts;
    List altAvailPorts;
    boolean showSecondary = true;
    boolean isEmbedded = false;
    NodeChangedObservable nodeChangeObservable = new NodeChangedObservable();
    private static final String WARN_SECONDARY_NODE_VALUE = "warnDiffSecondaryNode";
    private static final String WARN_SECONDARY_NODE_DESCR = "Warning of Different Secondary Node";

    public CcdEndpointsPane(AbstractCircuitDialog abstractCircuitDialog, WzDiagDebug wzDiagDebug, String string, String string2) {
        this(abstractCircuitDialog, wzDiagDebug, string, string2, true, false);
    }

    public CcdEndpointsPane(AbstractCircuitDialog abstractCircuitDialog, WzDiagDebug wzDiagDebug, String string, String string2, boolean bl, boolean bl2) {
        super(abstractCircuitDialog, wzDiagDebug, string);
        this.endpointName = string2;
        this.showSecondary = bl;
        this.isEmbedded = bl2;
        this.lastNodeModel = null;
        this.lastAltNodeModel = null;
    }

    public WzDiagDebug getDbg() {
        return this.db;
    }

    protected void initPane() {
        JPanel jPanel;
        if (!this.inSourcePane() && !this.isEmbedded) {
            jPanel = (CcdEndpointsPane)this.parent.getPaneByName("Source");
            this.excludeEndpoints((CcdEndpointsPane)jPanel);
        }
        this.setLayout(new GridLayout(1, 0));
        this.leftPanel = CcdEndpointsPane.createVerticalPanel(null);
        this.add(this.leftPanel);
        this.rightPanel = CcdEndpointsPane.createVerticalPanel(null);
        this.add(this.rightPanel);
        jPanel = null;
        jPanel = CcdEndpointsPane.createHorizontalPanel(null);
        jPanel.add(this.lfiller);
        jPanel.add(new JLabel("Node: ", 4));
        this.nodeCB = new NodeSelector();
        jPanel.add((Component)((Object)this.nodeCB));
        this.nodeCB.addActionListener(this);
        ICircuitType iCircuitType = CircuitType.getCircuitType((int)this.getCircuitInfo().type());
        if (iCircuitType.isOchncType() || iCircuitType.isOchccCircuitType()) {
            jPanel.add(this.rfiller);
        }
        this.leftPanel.add(jPanel);
        this.useAltCB = new JCheckBox("Use Secondary " + this.endpointName);
        this.rightPanel.add(this.useAltCB);
        this.useAltCB.setAlignmentX(0.5f);
        this.useAltCB.addActionListener(this);
        this.altNodePanel = CcdEndpointsPane.createHorizontalPanel(null);
        this.altNodePanel.add(Box.createHorizontalGlue());
        this.altNodePanel.add(new JLabel("Node: ", 4));
        this.altNodeCB = new NodeSelector();
        this.altNodePanel.add((Component)((Object)this.altNodeCB));
        this.altNodeCB.addActionListener(this);
        this.rightPanel.add(this.altNodePanel);
        if (!this.showSecondary) {
            this.remove(this.rightPanel);
            this.setAlignmentX(0.0f);
        }
        this.reset();
    }

    public CSHelpID getHelpID() {
        if (this.endpointName.equals("Source")) {
            return NetCSHelpConst.CcdSrcEndpointsPane;
        }
        return NetCSHelpConst.CcdDstEndpointsPane;
    }

    void reset() {
        if (!this.isInited()) {
            return;
        }
        this.useAltCB.setSelected(false);
        if (this.altPanel != null) {
            this.altPanel.setVisible(false);
        }
        if (this.altNodePanel != null) {
            this.altNodePanel.setVisible(false);
        }
        this.needEndpoints = false;
        if (this.db.on()) {
            this.db.println(this.endpointName + " reset: nodeModel = null");
        }
        this.nodeModel = null;
        this.altNodeModel = null;
        this.altAvailPorts = new ArrayList();
        this.availPorts = new ArrayList();
        if (this.mainPanel != null) {
            this.mainPanel.reset();
        }
        if (this.altPanel != null) {
            this.altPanel.reset();
        }
        this.nodeCB.setEnabled(true);
        if (this.altNodeCB != null) {
            this.altNodeCB.setEnabled(true);
        }
    }

    void presetNodeSelector(INodeModel iNodeModel) {
        this.nodeCB.setSelectedItem(iNodeModel);
        this.nodeCB.setEnabled(false);
    }

    public CircuitCreatInfo getCircuitInfo() {
        return this.parent == null ? null : this.getAbstractCktDlg().getCircuitInfo();
    }

    public boolean getMonitor() {
        return this.getCircuitInfo().monitor();
    }

    public INetCircuit getCircuit() {
        return this.parent == null ? null : this.getAbstractCktDlg().getCircuit();
    }

    public boolean getDropProtection() {
        return this.parent == null ? false : this.getAbstractCktDlg().getDropProtection();
    }

    public boolean getPortGrouping() {
        return this.parent == null ? false : this.getAbstractCktDlg().getPortGrouping();
    }

    public INodeModel getNodeModel() {
        return this.nodeModel;
    }

    public INodeModel getAltNodeModel() {
        return this.altNodeModel;
    }

    public INetCircuitEnd getMainPanelEndpoint() {
        if (this.getMainPanel() != null) {
            return this.getMainPanel().endpoint;
        }
        return null;
    }

    public INetCircuitEnd getAltPanelEndpoint() {
        if (this.getAltPanel() != null) {
            return this.getAltPanel().endpoint;
        }
        return null;
    }

    boolean isEtherGroup() {
        boolean bl = false;
        if (this.getMainPanel() != null) {
            bl = this.getMainPanel().slot == "Ethergroup";
        }
        return bl;
    }

    public void setLastNode(INodeModel iNodeModel) {
        this.lastNodeModel = iNodeModel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.nodeCB) {
            this.setNode((INodeModel)this.nodeCB.getSelectedItem(), false);
            this.nodeChangeObservable.forceChanged();
            this.nodeChangeObservable.notifyObservers();
        } else if (object == this.useAltCB || object == this.altNodeCB) {
            this.updateRightPanel();
            this.nodeChangeObservable.forceChanged();
            this.nodeChangeObservable.notifyObservers();
        }
    }

    protected void setEndpointPanel(INodeModel iNodeModel) {
        if (iNodeModel == null) {
            return;
        }
        if (this.getCircuitInfo().isEnhancedOchnc() || this.getCircuitInfo().type() == 14) {
            if (this.mainPanel != null) {
                this.leftPanel.remove(this.mainPanel);
            }
            this.mainPanel = new CcdOCHNCEndpointPanel(this.endpointName, this.getAbstractCktDlg(), this);
            this.leftPanel.add(this.mainPanel);
            if (this.altPanel != null) {
                this.altPanel.setVisible(false);
            }
        } else if (iNodeModel.getFramingType() == 0) {
            this.mainPanel = new SonetCcdEndpointPanel(this.endpointName, this.getAbstractCktDlg(), this);
            this.leftPanel.add(this.mainPanel);
            this.altPanel = new SonetCcdEndpointPanel(ALT_PREFIX + this.endpointName, this.getAbstractCktDlg(), this);
            this.rightPanel.add(this.altPanel);
            this.altPanel.setVisible(this.useAltCB.isSelected());
        } else if (iNodeModel.getFramingType() == 1) {
            this.mainPanel = new SdhAu4CcdEndpointPanel(this.endpointName, this.getAbstractCktDlg(), this);
            this.leftPanel.add(this.mainPanel);
            this.altPanel = new SdhAu4CcdEndpointPanel(ALT_PREFIX + this.endpointName, this.getAbstractCktDlg(), this);
            this.rightPanel.add(this.altPanel);
            this.altPanel.setVisible(this.useAltCB.isSelected());
        } else if (iNodeModel.getFramingType() == 2) {
            this.mainPanel = new SdhAu3CcdEndpointPanel(this.endpointName, this.getAbstractCktDlg(), this);
            this.leftPanel.add(this.mainPanel);
            this.mainPanel = new SdhAu3CcdEndpointPanel(ALT_PREFIX + this.endpointName, this.getAbstractCktDlg(), this);
            this.rightPanel.add(this.mainPanel);
            this.altPanel.setVisible(this.useAltCB.isSelected());
        }
        this.updateEndpointPanel(this.needEndpoints);
    }

    public void setFinishedEnabled(boolean bl) {
        if (!this.isEmbedded) {
            this.getAbstractCktDlg().setFinishEnabled(bl);
        }
    }

    void setNode(INodeModel iNodeModel, boolean bl) {
        ICircuitType iCircuitType;
        if (!bl) {
            if (iNodeModel == this.nodeModel) {
                if (this.db.on()) {
                    this.db.println(this.endpointName + " setNode: NOP, returning");
                }
                return;
            }
            this.nodeModel = iNodeModel;
            if (this.db.on()) {
                this.db.println(this.endpointName + " setNode: nodeModel = " + this.nodeModel);
            }
        } else {
            if (iNodeModel == this.altNodeModel) {
                if (this.db.on()) {
                    this.db.println(this.endpointName + " setNode (alt): NOP, returning");
                }
                return;
            }
            this.altNodeModel = iNodeModel;
            if (this.db.on()) {
                this.db.println(this.endpointName + " setNode (alt): altNodeModel = " + this.altNodeModel);
            }
        }
        if (this.parent != null && !(iCircuitType = CircuitType.getCircuitType((int)this.getCircuitInfo().type())).isOchncType() && !iCircuitType.isOchccCircuitType()) {
            this.setFinishEnabled();
        }
        if (iNodeModel != null && !iNodeModel.getConnectionState()) {
            if (this.db.on()) {
                this.db.println(this.endpointName + " setNode: " + iNodeModel + " is disconnected");
            }
            this.clearNode(iNodeModel.getName() + " is disconnected: no endpoints are available");
        } else if (this.needEndpoints) {
            try {
                this.updateAvailPorts(iNodeModel, bl);
                if ((this.mainPanel == null || this.altPanel == null) && iNodeModel != null) {
                    this.setEndpointPanel(iNodeModel);
                }
                if (!bl) {
                    if (this.mainPanel != null) {
                        this.mainPanel.setNode(iNodeModel);
                    }
                    if (this.altPanel != null && !this.altNodePanel.isVisible()) {
                        this.setNode(iNodeModel, true);
                    }
                } else if (this.altPanel != null) {
                    this.altPanel.setNode(iNodeModel);
                }
            }
            catch (AnnotatedException annotatedException) {
                this.clearNode((Object)annotatedException);
            }
        }
    }

    private void clearNode(Object object) {
        if (this.db.on()) {
            this.db.println(this.endpointName + " clearNode: " + object.toString());
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (CcdEndpointsPane.this.db.on()) {
                    CcdEndpointsPane.this.db.println(CcdEndpointsPane.this.endpointName + " Runnable: clearing node");
                }
                if (CcdEndpointsPane.this.nodeModel != null) {
                    String string = "Node Selection Error";
                    CcdEndpointsPane.this.nodeCB.setSelectedItem(null);
                    ErrorMsg.displayError((Component)CcdEndpointsPane.this, (EID)NEMC.EID_NODE_SELECTION_ERROR);
                }
            }
        });
    }

    public void excludeEndpoints(CcdEndpointsPane ccdEndpointsPane) {
        this.excludePane = ccdEndpointsPane;
    }

    public AbstractCcdEndpointPanel getMainPanel() {
        return this.mainPanel;
    }

    public String getEndpointName() {
        return this.endpointName;
    }

    public AbstractCcdEndpointPanel getAltPanel() {
        return this.useAltCB.isSelected() ? this.altPanel : null;
    }

    public JComboBox getNodeCB() {
        return this.nodeCB;
    }

    void setAltPanelEnabled(boolean bl) {
        this.useAltCB.setEnabled(bl);
        if (!bl) {
            this.useAltCB.setSelected(false);
            if (this.altPanel != null) {
                this.altPanel.setVisible(false);
            }
        }
    }

    boolean isAltPanelEnabled() {
        return this.useAltCB.isEnabled();
    }

    public void setDropProtection(boolean bl) {
        if (this.mainPanel != null) {
            this.mainPanel.endpoint.setDropProt(bl);
        }
        if (this.altPanel != null) {
            this.altPanel.endpoint.setDropProt(bl);
        }
    }

    private void checkLap(INodeModel iNodeModel, IEntityModel iEntityModel, IHoNum iHoNum, INodeModel iNodeModel2, IEntityModel iEntityModel2, IHoNum iHoNum2) throws Exception {
        INetCircuit iNetCircuit = this.findLap(iNodeModel, iEntityModel, iHoNum);
        if (iNetCircuit == null) {
            iNetCircuit = this.findLap(iNodeModel2, iEntityModel2, iHoNum2);
        }
        if (iNetCircuit != null) {
            String string = "The circuit that uses an aggregation circuit cannot have both primary and secondary source/destination.";
            throw new Exception(string);
        }
    }

    private INetCircuit findLap(INodeModel iNodeModel, IEntityModel iEntityModel, IHoNum iHoNum) {
        INetCircuit iNetCircuit = null;
        try {
            iNetCircuit = NetCircuitManager.instance().getLAPHo(iNodeModel, iEntityModel, iHoNum);
        }
        catch (Exception exception) {
            iNetCircuit = null;
        }
        return iNetCircuit;
    }

    public boolean inSourcePane() {
        return this.getName().equals("Source");
    }

    public boolean handleBack() {
        if (this.inSourcePane()) {
            if (this.db.on()) {
                this.db.println("...deleting circuit");
            }
            this.getAbstractCktDlg().destroyCircuit();
        } else {
            this.getAbstractCktDlg().destroyCircuit();
        }
        return super.handleBack();
    }

    protected String getNextPaneName() {
        if (this.inSourcePane()) {
            return "Destination";
        }
        try {
            if (this.getAbstractCktDlg().isVlanCapable()) {
                return "Circuit VLAN Selection";
            }
            if (this.getAbstractCktDlg().isVcatType()) {
                return "VCat Circuit Routing Preferences";
            }
            return "Circuit Routing Preferences";
        }
        catch (IncorrectCircuitState incorrectCircuitState) {
            return null;
        }
    }

    public boolean isDestPane() {
        return this.endpointName.equals("Destination");
    }

    public void validatePage() throws Exception {
        Object object;
        if (this.nodeModel == null) {
            throw new Exception(this.endpointName + " node must be selected");
        }
        this.lastNodeModel = this.nodeModel;
        if (this.useAltCB.isSelected()) {
            this.lastAltNodeModel = this.altNodeModel;
        } else {
            this.altNodeModel = null;
            this.lastAltNodeModel = null;
        }
        if (this.needEndpoints) {
            this.mainPanel.validatePage();
            if (this.altPanel != null && this.useAltCB.isSelected()) {
                this.altPanel.validatePage();
                if (this.mainPanel.endpoint.equals(this.altPanel.endpoint)) {
                    String string = this.endpointName + "s can't be identical";
                    throw new Exception(string);
                }
            }
        }
        if (this.endpointName.equals("Source")) {
            object = this.getAbstractCktDlg().getAltSourceNode();
            if (object != null) {
                this.checkLap(this.getAbstractCktDlg().getSourceNode(), this.getAbstractCktDlg().getSource().getEntityModel(), this.getAbstractCktDlg().getSource().getHoNum(), this.getAbstractCktDlg().getAltSourceNode(), this.getAbstractCktDlg().getAltSource().getEntityModel(), this.getAbstractCktDlg().getAltSource().getHoNum());
            }
        } else if (this.endpointName.equals("Destination") && (object = this.getAbstractCktDlg().getAltDestNode()) != null) {
            this.checkLap(this.getAbstractCktDlg().getDestNode(), this.getAbstractCktDlg().getDest().getEntityModel(), this.getAbstractCktDlg().getDest().getHoNum(), this.getAbstractCktDlg().getAltDestNode(), this.getAbstractCktDlg().getAltDest().getEntityModel(), this.getAbstractCktDlg().getAltDest().getHoNum());
        }
        if (this.endpointName.equals("Destination")) {
            object = this.getAbstractCktDlg().getSourceNode();
            INodeModel iNodeModel = this.getAbstractCktDlg().getAltSourceNode();
            INodeModel iNodeModel2 = this.getAbstractCktDlg().getDestNode();
            INodeModel iNodeModel3 = this.getAbstractCktDlg().getAltDestNode();
            if (object != null && iNodeModel != null && iNodeModel2 != null && iNodeModel3 != null && object != iNodeModel && object != iNodeModel2 && object != iNodeModel3 && iNodeModel != iNodeModel2 && iNodeModel != iNodeModel3 && iNodeModel2 != iNodeModel3) {
                if (this.db.on()) {
                    this.db.println("validate src1= " + object.getName());
                    this.db.println("validate src2= " + iNodeModel.getName());
                    this.db.println("validate dst1= " + iNodeModel2.getName());
                    this.db.println("validate dst2= " + iNodeModel3.getName());
                }
                String string = "Circuit creation does not permit four unique nodes to be designated \nas endpoints. Please modify the sources and/or destinations so that\nthe endpoints consist of three or fewer unique nodes.";
                throw new Exception(string);
            }
        }
        if (this.getMainPanel() != null) {
            if (this.getMainPanel().slot == "Ethergroup") {
                this.maybeModifyEthergroupAdminState();
            }
            try {
                if (this.altPanel != null && this.useAltCB.isSelected()) {
                    this.checkDataCardAdminState(this.mainPanel.endpoint, this.altPanel.endpoint);
                } else {
                    this.checkDataCardAdminState(this.mainPanel.endpoint, null);
                }
            }
            catch (ObjNotFound objNotFound) {
                WzDiagDebug.printStackTrace((Throwable)objNotFound);
            }
            try {
                this.checkRPRValidateCircuitSize(this.mainPanel.endpoint);
            }
            catch (ObjNotFound objNotFound) {
                WzDiagDebug.printStackTrace((Throwable)objNotFound);
            }
        }
        if ((object = this.getCircuit()) != null && this.parent != null && !this.isEmbedded) {
            this.getAbstractCktDlg().addDestination(false);
        }
    }

    protected void maybeModifyEthergroupAdminState() {
        int n = this.getCircuitInfo().adminState();
        if (n != 0) {
            this.getCircuitInfo().setAdminState(0);
            String string = NetAdminState.getAdminStateStringFromAdminState(n);
            IgnorableDialog.warningDialog((Component)this, (String)ErrorMsg.getString((EID)NEMC.WID_ETHER_CIRCUIT_STATELESS_PARAM_1, (Object)string), (String)"Warning", (String)"Warn non-applicable State applied to Ethergroup");
        }
    }

    private void checkRPRValidateCircuitSize(INetCircuitEnd iNetCircuitEnd) throws ObjNotFound {
        if (this.getAbstractCktDlg() == null) {
            return;
        }
        if (this.isEtherGroup()) {
            return;
        }
        IEntityModel iEntityModel = this.mainPanel.endpoint.getEntityModel();
        INodeModel iNodeModel = iEntityModel.getNodeModel();
        if (iEntityModel != null && iNodeModel != null && Feature.provides((INodeModel)iNodeModel, (Feature)Feature.RPR_802_17) && iEntityModel.inRPRMode()) {
            this.mainPanel.validateRPRCircuitSize();
        }
    }

    private void checkDataCardAdminState(INetCircuitEnd iNetCircuitEnd, INetCircuitEnd iNetCircuitEnd2) throws ObjNotFound {
        int n = this.getCircuitInfo().adminState();
        if (this.getAbstractCktDlg() == null) {
            return;
        }
        if (!this.getAbstractCktDlg().applyDropPorts || n != 3) {
            return;
        }
        IEntityModel iEntityModel = iNetCircuitEnd.getEntityModel();
        IEntityModel iEntityModel2 = iNetCircuitEnd2 != null ? iNetCircuitEnd2.getEntityModel() : null;
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.cantSupportAINS(iEntityModel)) {
            stringBuffer.append(this.endpointName + " card type (" + iEntityModel.getParent().getEqTypeName() + ") ");
        }
        if (this.cantSupportAINS(iEntityModel2)) {
            if (stringBuffer.length() > 0) {
                bl = true;
                stringBuffer.append(" and ");
            }
            stringBuffer.append("Secondary  " + this.endpointName + " card type (" + iEntityModel2.getParent().getEqTypeName() + ") ");
        }
        if (stringBuffer.length() > 0) {
            String string = NetAdminState.getAdminStateStringFromAdminState(3);
            IgnorableDialog.warningDialog((Component)this, (String)("Warning: Current state of " + string + " cannot be applied\nto the drop ports for the " + stringBuffer.toString() + "."), (String)"Warning", (String)("Warn " + string + " to be applied to drop ports."));
        }
    }

    private boolean cantSupportAINS(IEntityModel iEntityModel) {
        if (iEntityModel != null) {
            if (iEntityModel.getEqType() == 105) {
                return true;
            }
            if (iEntityModel instanceof IML2PosLineModel && iEntityModel.getParent().getEqType() == 164) {
                return true;
            }
        }
        return false;
    }

    protected void handlePostValidate() {
        AutorangeInfo autorangeInfo;
        if (this.inSourcePane()) {
            try {
                if (this.db.on()) {
                    this.db.println("...creating circuit");
                }
                this.getAbstractCktDlg().createCircuit();
            }
            catch (Exception exception) {
                CerentDialog.errorDialog((Component)this, (Exception)exception, (String)(this.getName() + " Error"));
            }
        }
        if ((autorangeInfo = this.getAutorangeInfo()) != null) {
            boolean bl;
            boolean bl2 = bl = this.getAltPanel() != null && this.isAltPanelEnabled();
            if (this.inSourcePane()) {
                autorangeInfo.clearSources();
                autorangeInfo.isEther = this.isEtherGroup();
                autorangeInfo.sourceNode = this.getNodeModel();
                if (bl) {
                    autorangeInfo.altSourceNode = this.getAltNodeModel();
                }
                if (!autorangeInfo.isEther && !autorangeInfo.isTunnel) {
                    autorangeInfo.priSource = this.getMainPanelEndpoint();
                    autorangeInfo.priSourcePortList = this.mainPanel.getOtherPortsList();
                    autorangeInfo.priSourceList = this.mainPanel.getEndpointsList();
                    autorangeInfo.priSourceList.removeAll(this.getUpTo(autorangeInfo.priSourceList, autorangeInfo.priSource));
                    if (bl) {
                        autorangeInfo.secSource = this.getAltPanelEndpoint();
                        autorangeInfo.secSourcePortList = this.altPanel.getOtherPortsList();
                        autorangeInfo.secSourceList = this.altPanel.getEndpointsList();
                        autorangeInfo.secSourceList.removeAll(this.getUpTo(autorangeInfo.secSourceList, autorangeInfo.secSource));
                    }
                }
            } else {
                autorangeInfo.clearDests();
                autorangeInfo.destNode = this.getNodeModel();
                if (bl) {
                    autorangeInfo.altDestNode = this.getAltNodeModel();
                }
                if (!autorangeInfo.isEther && !autorangeInfo.isTunnel) {
                    autorangeInfo.priDest = this.getMainPanelEndpoint();
                    autorangeInfo.priDestPortList = this.mainPanel.getOtherPortsList();
                    autorangeInfo.priDestList = this.mainPanel.getEndpointsList();
                    autorangeInfo.priDestList.removeAll(this.getUpTo(autorangeInfo.priDestList, autorangeInfo.priDest));
                    if (bl) {
                        autorangeInfo.secDest = this.getAltPanelEndpoint();
                        autorangeInfo.secDestPortList = this.altPanel.getOtherPortsList();
                        autorangeInfo.secDestList = this.altPanel.getEndpointsList();
                        autorangeInfo.secDestList.removeAll(this.getUpTo(autorangeInfo.secDestList, autorangeInfo.secDest));
                    }
                }
            }
        }
    }

    private ArrayList getUpTo(List list, Object object) {
        ArrayList arrayList = new ArrayList();
        boolean bl = false;
        for (int i = 0; i < list.size(); ++i) {
            Object e = list.get(i);
            if (e.equals(object)) {
                bl = true;
                break;
            }
            arrayList.add(e);
        }
        if (bl) {
            return arrayList;
        }
        return new ArrayList();
    }

    protected JComponent getStatusComponent() {
        boolean bl;
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        String string = this.nodeModel.getName();
        boolean bl2 = bl = this.altNodeModel != null;
        if (this.needEndpoints) {
            string = string + "/" + this.mainPanel.getStatusText();
            arrayList.add(new String[]{null, string});
            if (this.useAltCB.isSelected()) {
                string = this.altNodeModel != null ? this.altNodeModel.getName() + "/" : "";
                string = string + this.altPanel.getStatusText();
                arrayList.add(new String[]{null, string + " (secondary)"});
            }
        } else {
            if (this.altNodeModel != null) {
                string = this.altNodeModel.getName();
            }
            arrayList.add(new String[]{null, string});
        }
        try {
            INetElement iNetElement;
            if (!this.inSourcePane() && this.getCircuit().isVlanCapable() && (iNetElement = Network.instance().findNetElem(this.getAbstractCktDlg().getSourceNode())) != null) {
                arrayList.add(new String[]{"VLAN Topo Id#", String.valueOf(iNetElement.getTopoId())});
            }
        }
        catch (IncorrectCircuitState incorrectCircuitState) {
            if (this.db.on()) {
                this.db.info("Unable to determine if VLAN capable.");
            }
            WzDiagDebug.printStackTrace((Throwable)incorrectCircuitState);
        }
        return CcdEndpointsPane.getGridPanel(arrayList);
    }

    protected String getStatusText() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.inSourcePane() ? "\nFrom: " : "\nTo: ");
        stringBuffer.append(this.nodeModel.getName());
        if (this.needEndpoints) {
            stringBuffer.append("/");
            stringBuffer.append(this.mainPanel.getStatusText());
            if (this.useAltCB.isSelected()) {
                stringBuffer.append("\n and ");
                if (this.altNodeModel != null && this.altNodeModel != this.nodeModel) {
                    stringBuffer.append(this.altNodeModel.getName() + "/");
                }
                stringBuffer.append(this.altPanel.getStatusText());
            }
        } else if (this.altNodeModel != null) {
            stringBuffer.append(", " + this.altNodeModel.getName());
        }
        try {
            INetElement iNetElement;
            if (!this.inSourcePane() && this.getCircuit().isVlanCapable() && (iNetElement = Network.instance().findNetElem(this.getAbstractCktDlg().getSourceNode())) != null) {
                stringBuffer.append("\nCircuit VLAN Selection - Topo Id " + iNetElement.getTopoId() + "\n");
            }
        }
        catch (IncorrectCircuitState incorrectCircuitState) {
            if (this.db.on()) {
                this.db.info("Unable to determine if VLAN capable.");
            }
            WzDiagDebug.printStackTrace((Throwable)incorrectCircuitState);
        }
        return stringBuffer.toString();
    }

    public void revalidateData() {
        ICircuitType iCircuitType = CircuitType.getCircuitType((int)this.getCircuitInfo().type());
        this.needEndpoints = iCircuitType.isHoCircuitType() || iCircuitType.isLoCircuitType() || iCircuitType.isEthernetCircuitType() || iCircuitType.isVcatCircuitType() || this.getCircuitInfo().isEnhancedOchnc() || iCircuitType.isOchccCircuitType() || iCircuitType.isLAPCircuitType() && this.endpointName.equals("Source");
        this.updateRightPanel();
        if (this.getPortGrouping()) {
            this.needEndpoints = true;
            this.useAltCB.setEnabled(false);
            this.useAltCB.setVisible(false);
        } else {
            this.useAltCB.setVisible(true);
        }
        if (this.getCircuitInfo().isDiag()) {
            this.useAltCB.setEnabled(false);
            this.useAltCB.setVisible(false);
        }
        List list = this.availPorts;
        this.updateNodeList();
        if (this.lastNodeModel != null) {
            if (this.db.on()) {
                this.db.println(this.endpointName + " revalidateData: lastNodeModel = " + this.lastNodeModel);
            }
            if (((DefaultComboBoxModel)this.nodeCB.getModel()).getIndexOf(this.lastNodeModel) < 0) {
                if (this.db.on()) {
                    this.db.println("The original node is not available any more.");
                }
                this.lastNodeModel = null;
            }
            this.nodeCB.setSelectedItem(this.lastNodeModel);
        } else {
            if (this.db.on()) {
                this.db.println(this.endpointName + " revalidateData: nodeModel = " + this.nodeModel);
            }
            this.nodeCB.setSelectedItem(this.nodeModel);
        }
        if (this.lastAltNodeModel != null) {
            if (this.db.on()) {
                this.db.println(this.endpointName + " revalidateData: lastAltNodeModel = " + this.lastAltNodeModel);
            }
            this.altNodeCB.setSelectedItem(this.lastAltNodeModel);
        } else {
            if (this.db.on()) {
                this.db.println(this.endpointName + " revalidateData: altNodeModel = " + this.altNodeModel);
            }
            this.altNodeCB.setSelectedItem(this.altNodeModel);
        }
        if (!iCircuitType.isOchncType() || this.getCircuitInfo().isEnhancedOchnc() || iCircuitType.isOchccCircuitType()) {
            if (list == this.availPorts) {
                if (this.db.on) {
                    this.db.println(this.endpointName + " revalidateData: calling updateAvailPorts");
                }
                try {
                    this.updateAvailPorts(this.nodeModel, false);
                    this.updateAvailPorts(this.altNodeModel, true);
                }
                catch (AnnotatedException annotatedException) {
                    this.clearNode((Object)annotatedException);
                }
            }
            list = null;
        }
        if (this.needEndpoints) {
            this.updateEndpointPanel(this.needEndpoints);
            if (this.mainPanel != null) {
                this.mainPanel.refresh();
            }
            if (this.altPanel != null) {
                this.altPanel.refresh();
            }
            if ((iCircuitType.isOchncType() || iCircuitType.isOchccCircuitType()) && !this.isEmbedded && this.parent != null) {
                this.getAbstractCktDlg().setFinishEnabled(!this.inSourcePane());
                this.getAbstractCktDlg().setNextEnabled(this.inSourcePane());
            }
        } else {
            if (this.mainPanel != null) {
                this.mainPanel.setVisible(false);
            }
            this.rightPanel.setVisible(false);
            this.setAltPanelEnabled(false);
            if (this.excludePane != null && (iCircuitType.isTunnelCircuitType() || iCircuitType.isLAPCircuitType() || iCircuitType.isOchncType() && !this.getCircuitInfo().isEnhancedOchnc() || iCircuitType.isOchccCircuitType())) {
                this.nodeCB.removeItem(this.excludePane.nodeModel);
                if (this.altNodeCB != null) {
                    this.altNodeCB.removeItem(this.excludePane.nodeModel);
                }
            }
            if (this.excludePane != null && (iCircuitType.isOchncType() || iCircuitType.isOchccCircuitType()) && !this.isEmbedded && this.parent != null) {
                this.getAbstractCktDlg().setFinishEnabled(true);
                this.getAbstractCktDlg().setNextEnabled(false);
            }
        }
        if (this.excludePane == null) {
            this.nodeCB.setEnabled(!this.getMonitor());
            this.setAltPanelEnabled(!this.getMonitor() && !iCircuitType.isLAPCircuitType());
        }
    }

    private void updateRightPanel() {
        if (this.useAltCB.isSelected()) {
            ICircuitType iCircuitType = CircuitType.getCircuitType((int)this.getCircuitInfo().type());
            this.altNodePanel.setVisible(!iCircuitType.isLAPCircuitType());
            if (!this.altNodePanel.isVisible()) {
                this.setNode((INodeModel)this.nodeCB.getSelectedItem(), true);
            } else {
                this.setNode((INodeModel)this.altNodeCB.getSelectedItem(), true);
                if (this.altNodeCB.getSelectedItem() != null && this.altNodeModel != this.nodeModel && !this.warnedDri && !iCircuitType.isLAPCircuitType()) {
                    IgnorableDialog.warningDialog((Component)this, (String)ErrorMsg.getString((EID)NEMC.WID_DIFFERENT_SECONDARY_NODE_PARAM_1, (Object)this.endpointName.toLowerCase()), (String)WARN_SECONDARY_NODE_VALUE, (String)WARN_SECONDARY_NODE_DESCR);
                    this.warnedDri = true;
                }
            }
            if (this.altPanel != null) {
                this.altPanel.setVisible(this.needEndpoints && this.altNodeModel != null);
                this.altPanel.refresh();
            }
            if (this.mainPanel != null) {
                this.mainPanel.refresh();
            }
        } else {
            this.setNode(null, true);
            this.altNodePanel.setVisible(false);
            if (this.altPanel != null) {
                this.altPanel.setVisible(false);
            }
        }
    }

    private void updateEndpointPanel(boolean bl) {
        ICircuitType iCircuitType = CircuitType.getCircuitType((int)this.getCircuitInfo().type());
        if (bl) {
            if (this.mainPanel != null) {
                this.mainPanel.setVisible(true);
            }
            if (iCircuitType.isLAPCircuitType() && this.endpointName.equals("Source")) {
                this.rightPanel.setVisible(false);
            } else {
                this.rightPanel.setVisible(true);
            }
            if (this.excludePane != null) {
                if (this.excludePane.getAltPanel() == null && this.getCircuitInfo().dir() == 0) {
                    if (this.mainPanel != null) {
                        this.mainPanel.setExcludedEndpoints(new ArrayList());
                    }
                    if (this.altPanel != null) {
                        this.altPanel.setExcludedEndpoints(new ArrayList());
                    }
                } else {
                    if (this.mainPanel != null) {
                        this.mainPanel.setExcludedEndpoints(this.excludePane.getEndpoints());
                    }
                    if (this.altPanel != null) {
                        this.altPanel.setExcludedEndpoints(this.excludePane.getEndpoints());
                    }
                }
                this.setAltPanelEnabled(!this.getMonitor());
            } else if (this instanceof RollEndpointsPane) {
                this.mainPanel.setExcludedEndpoints(this.getEndpoints());
            }
        }
    }

    public void enteringPane() {
        this.setFinishEnabled();
        ICircuitType iCircuitType = CircuitType.getCircuitType((int)this.getCircuitInfo().type());
        this.rfiller.setVisible(iCircuitType.isOchncType() || iCircuitType.isOchccCircuitType());
        super.enteringPane();
    }

    private void setFinishEnabled() {
        if (!this.isEmbedded && this.parent != null) {
            boolean bl;
            block6: {
                bl = false;
                if (this.excludePane != null && CcdEndpointsPane.areAllNodesSame(this.excludePane, this)) {
                    try {
                        INetCircuitEnd iNetCircuitEnd = this.getAbstractCktDlg().getSource();
                        IEntityModel iEntityModel = iNetCircuitEnd.getEntityModel();
                        boolean bl2 = bl = iEntityModel.getEqType() != 14 && iEntityModel.getEqType() != 15 && iEntityModel.getEqType() != 63 && iEntityModel.getEqType() != 105;
                        if (this.getAbstractCktDlg().isVcatType()) {
                            bl = false;
                        }
                    }
                    catch (Exception exception) {
                        if (!this.db.on()) break block6;
                        WzDiagDebug.printStackTrace((Throwable)exception);
                    }
                }
            }
            if (!this.inSourcePane() && this.getCircuitInfo().isDiag()) {
                bl = true;
                this.getAbstractCktDlg().setNextEnabled(false);
            }
            this.getAbstractCktDlg().setFinishEnabled(bl);
        }
    }

    protected List getEndpoints() {
        ArrayList<INetCircuitEnd> arrayList = new ArrayList<INetCircuitEnd>(2);
        if (this.needEndpoints) {
            arrayList.add(this.mainPanel.endpoint);
            if (this.useAltCB.isSelected()) {
                arrayList.add(this.altPanel.endpoint);
            }
        }
        return arrayList;
    }

    public void setNodeList(List list) {
        this.nodeCB.removeActionListener(this);
        this.nodeCB.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
        this.nodeCB.addActionListener(this);
        this.nodeCB.setSelectedItem(null);
    }

    public void removeNodesFromNodeList(List list) {
        if (this.nodeCB != null && this.nodeCB.getModel() != null) {
            DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.nodeCB.getModel();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e == null || !(e instanceof INodeModel)) continue;
                INodeModel iNodeModel = (INodeModel)e;
                defaultComboBoxModel.removeElement(iNodeModel);
            }
        }
    }

    protected void updateAvailPorts(INodeModel iNodeModel, boolean bl) throws AnnotatedException {
        if (this.db.on()) {
            this.db.println(this.endpointName + " updateAvailPorts, NM= " + iNodeModel + ", alt? " + bl);
        }
        if (bl) {
            this.altAvailPorts = new ArrayList();
        } else {
            this.availPorts = new ArrayList();
        }
        ICircuitType iCircuitType = CircuitType.getCircuitType((int)this.getCircuitInfo().type());
        if (iNodeModel == null) {
            if (this.db.on()) {
                this.db.println(this.endpointName + " updateAvailPorts: got 0 ports from null nodeModel");
            }
            return;
        }
        try {
            if (this.getCircuit() == null) {
                if (bl) {
                    this.altAvailPorts = NetCircuitManager.instance().getAvailSourcePorts(iNodeModel, this.getCircuitInfo(), this.getDropProtection());
                } else {
                    this.availPorts = NetCircuitManager.instance().getAvailSourcePorts(iNodeModel, this.getCircuitInfo(), this.getDropProtection());
                }
                this.ethergroupChoiceAllowed = true;
                this.db.fine(this.endpointName + " updateAvailPorts: ethergroup allowed on null circuit");
            } else if (this.excludePane != null) {
                if (this.getPortGrouping()) {
                    if (bl) {
                        this.altAvailPorts = NetCircuitManager.instance().getAvailSourcePorts(iNodeModel, this.getCircuitInfo(), this.getDropProtection());
                    } else {
                        this.availPorts = NetCircuitManager.instance().getAvailSourcePorts(iNodeModel, this.getCircuitInfo(), this.getDropProtection());
                    }
                } else {
                    this.ethergroupChoiceAllowed = this.excludePane.getMainPanel() != null && this.excludePane.getMainPanel().slot == "Ethergroup";
                    if (this.ethergroupChoiceAllowed) {
                        if (bl) {
                            this.altAvailPorts = new ArrayList();
                        } else {
                            this.availPorts = new ArrayList();
                        }
                    } else if (bl) {
                        this.altAvailPorts = this.getCircuit().getAvailDropPorts(iNodeModel, this.getCircuitInfo(), this.getDropProtection());
                    } else {
                        this.availPorts = this.getCircuit().getAvailDropPorts(iNodeModel, this.getCircuitInfo(), this.getDropProtection());
                    }
                }
            } else if (!iCircuitType.isEthernetCircuitType()) {
                if (bl) {
                    this.altAvailPorts = this.getCircuit().getAvailDropPorts(iNodeModel, this.getCircuitInfo(), this.getDropProtection());
                } else {
                    this.availPorts = this.getCircuit().getAvailDropPorts(iNodeModel, this.getCircuitInfo(), this.getDropProtection());
                }
                this.ethergroupChoiceAllowed = false;
                this.db.fine(this.endpointName + " updateAvailPorts: not ethernetCircuitType");
            }
            if (this.getCircuitInfo().isDiag()) {
                this.availPorts = NetCircuitManager.instance().getAvailSourcePorts(iNodeModel, this.getCircuitInfo(), this.getDropProtection());
            }
            this.db.fine(this.endpointName + "updateAvailPorts: got " + (this.ethergroupChoiceAllowed ? "" : "no ") + "ethergroup before asking NCP");
            this.ethergroupChoiceAllowed &= NetCircuitManager.instance().canCreateStitchedCircuit(iNodeModel, this.getCircuitInfo());
            if (this.db.on()) {
                this.db.info(this.endpointName + " updateAvailPorts: got " + this.availPorts.size() + " ports" + (this.ethergroupChoiceAllowed ? " + " : "; no ") + "Ethergroup");
                this.db.info(this.endpointName + " available ports " + ((AbstractCollection)((Object)this.availPorts)).toString());
                if (bl) {
                    this.db.println(this.endpointName + " updateAvailPorts: got " + this.altAvailPorts.size() + " alt ports" + (this.ethergroupChoiceAllowed ? " + " : "; no ") + "Ethergroup");
                    this.db.println(this.endpointName + "altAvailable ports " + ((AbstractCollection)((Object)this.altAvailPorts)).toString());
                }
            }
        }
        catch (Exception exception) {
            WzDiagDebug.printStackTrace((Throwable)exception);
            throw new AnnotatedException("Failure getting list of available ports from " + iNodeModel.getName(), exception);
        }
    }

    public void close() {
        if (this.nodeCB != null) {
            this.nodeCB.hidePopup();
        }
        if (this.altNodeCB != null) {
            this.altNodeCB.hidePopup();
        }
        if (this.mainPanel != null) {
            this.mainPanel.close();
        }
        if (this.altPanel != null) {
            this.altPanel.close();
        }
        if (this.availPorts != null) {
            this.availPorts.clear();
        }
        if (this.altAvailPorts != null) {
            this.altAvailPorts.clear();
        }
    }

    public void recycle() {
        this.excludePane = null;
        if (this.mainPanel != null) {
            this.mainPanel.recycle();
            this.mainPanel = null;
        }
        if (this.altPanel != null) {
            this.altPanel.recycle();
            this.altPanel = null;
        }
        if (this.availPorts != null) {
            this.availPorts.clear();
        }
        if (this.altAvailPorts != null) {
            this.altAvailPorts.clear();
        }
        this.nodeModel = null;
        this.altNodeModel = null;
        this.lastNodeModel = null;
        this.lastAltNodeModel = null;
        this.parent = null;
        if (this.nodeCB != null) {
            this.nodeCB.removeActionListener(this);
            this.nodeCB.removeAll();
            this.nodeCB = null;
        }
        if (this.altNodeCB != null) {
            this.altNodeCB.removeActionListener(this);
            this.altNodeCB.removeAll();
            this.altNodeCB = null;
        }
        this.removeAll();
    }

    protected void updateNodeList() {
        this.nodeCB.removeActionListener(this);
        if (this.getPortGrouping()) {
            this.nodeCB.updatePGNodeList();
        } else {
            this.nodeCB.updateNodeList(this.getCircuitInfo(), this.getCircuit());
        }
        this.nodeCB.addActionListener(this);
        this.nodeCB.setSelectedItem(null);
        if (this.altNodeCB != null && this.useAltCB.isSelected()) {
            this.altNodeCB.removeActionListener(this);
            this.altNodeCB.updateNodeList(this.getCircuitInfo(), this.getCircuit());
            this.altNodeCB.addActionListener(this);
            this.altNodeCB.setSelectedItem(null);
        }
    }

    private static boolean areAllNodesSame(CcdEndpointsPane ccdEndpointsPane, CcdEndpointsPane ccdEndpointsPane2) {
        HashSet<INodeModel> hashSet = new HashSet<INodeModel>();
        hashSet.add(ccdEndpointsPane.nodeModel);
        hashSet.add(ccdEndpointsPane2.nodeModel);
        if (ccdEndpointsPane.altNodeModel != null) {
            hashSet.add(ccdEndpointsPane.altNodeModel);
        }
        if (ccdEndpointsPane2.altNodeModel != null) {
            hashSet.add(ccdEndpointsPane2.altNodeModel);
        }
        return hashSet.size() == 1;
    }

    public void removeListeners() {
        if (this.nodeCB != null) {
            this.nodeCB.removeActionListener(this);
        }
        if (this.useAltCB != null) {
            this.useAltCB.removeActionListener(this);
        }
        super.removeListeners();
    }

    public void dispose() {
        this.nodeChangeObservable = null;
        this.nodeModel = null;
        this.altNodeModel = null;
        this.lastNodeModel = null;
        this.lastAltNodeModel = null;
        if (this.availPorts != null) {
            this.availPorts.clear();
            this.availPorts = null;
        }
        if (this.altAvailPorts != null) {
            this.altAvailPorts.clear();
            this.altAvailPorts = null;
        }
        super.dispose();
    }

    public String getDiagString() {
        StringBuffer stringBuffer = new StringBuffer(super.getDiagString());
        stringBuffer.append("[ NOTE: Future/ can add the endpoint panels contents too ]\n");
        stringBuffer.append("Endpoint Name: " + this.endpointName + "\n");
        stringBuffer.append("Need Endpoints: " + this.needEndpoints + "\n");
        stringBuffer.append("Exclude Pane: ");
        if (this.excludePane != null && this.excludePane instanceof WzPane) {
            stringBuffer.append(this.excludePane.getName());
        } else {
            stringBuffer.append(this.excludePane);
        }
        stringBuffer.append("\n");
        stringBuffer.append("Node Model: " + this.nodeModel + "\n");
        stringBuffer.append("Last Node Model: " + this.lastNodeModel + "\n");
        stringBuffer.append("Alt Node Model: " + this.altNodeModel + "\n");
        stringBuffer.append("Last Alt Node Model: " + this.lastAltNodeModel + "\n");
        stringBuffer.append("Ether Group Choice allowed: " + this.ethergroupChoiceAllowed + "\n");
        stringBuffer.append("Show secondary: " + this.showSecondary + "\n");
        stringBuffer.append("Is this an embedded pane: " + this.isEmbedded + "\n");
        return stringBuffer.toString();
    }

    public class NodeChangedObservable
    extends Observable {
        public void forceChanged() {
            this.setChanged();
        }
    }
}

