/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.Attribute;
import cerent.cms.model.NetAdminState;
import cerent.cms.ui.AbstractProvPane;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.CircuitOptDir;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.OpticalChannelAttr;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.WzPane;
import cerent.cms.ui.circuits.AbstractAdminStatePanel;
import cerent.cms.ui.circuits.AbstractCcdAttrsPane;
import cerent.cms.ui.circuits.CircuitCreationDialog;
import cerent.cms.ui.circuits.IAdminStatePanel;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.gui.IgnorableDialog;
import cerent.util.gui.UComboBox;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CcdOCHNCAttrsPane
extends AbstractCcdAttrsPane {
    public static final int HORIZ_OPT_DIR_MARGIN = 20;
    private OpticalChannelAttr optChannel;
    private OptDir optDir;
    protected GridBagConstraints paneGc;

    public CcdOCHNCAttrsPane(CircuitCreationDialog circuitCreationDialog, WzDiagDebug wzDiagDebug, String string) {
        super(circuitCreationDialog, wzDiagDebug, string);
    }

    protected void initPane() {
        this.setLayout(new GridBagLayout());
        this.paneGc = new GridBagConstraints();
        this.paneGc.anchor = 18;
        this.paneGc.gridx = 0;
        this.paneGc.gridy = 0;
        this.paneGc.gridwidth = 1;
        this.paneGc.gridheight = 1;
        this.paneGc.weightx = 0.0;
        this.paneGc.weighty = 0.0;
        this.paneGc.fill = 1;
        this.paneGc.insets = new Insets(5, 5, 0, 0);
        this.addLeftPane();
        this.paneGc.gridx = 1;
        this.paneGc.gridy = 0;
        this.paneGc.gridwidth = 1;
        this.paneGc.gridheight = 1;
        this.paneGc.weightx = 0.0;
        this.paneGc.weighty = 0.0;
        this.paneGc.fill = 1;
        this.paneGc.insets = new Insets(5, 5, 0, 0);
        this.addRightPane();
    }

    protected void addLeftPane() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        jPanel.setBorder(BorderFactory.createTitledBorder("Circuit"));
        this.circuitNameAttr = new AbstractCcdAttrsPane.CircuitNameAttr();
        jPanel.add((Component)this.circuitNameAttr.getUI(), gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)new JPanel(), gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.circuitTypeAttr = new AbstractCcdAttrsPane.CircuitTypeAttr(this.getCircuitType());
        jPanel.add((Component)this.circuitTypeAttr.getUI(), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.setCircuitSize(19);
        this.circuitSizeAttr = this.getCircuitSizeAttr();
        this.circuitSizeAttr.setEnabled(false);
        jPanel.add((Component)this.circuitSizeAttr.getUI(), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.optChannel = this.getOpticalChannelAttr();
        jPanel.add((Component)this.optChannel.getUI(), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.biDirAttr = new AbstractCcdAttrsPane.BiDirAttr();
        jPanel.add((Component)this.biDirAttr.getUI(), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.addOptDir(jPanel, gridBagConstraints);
        this.paneGc.gridheight = 4;
        this.add((Component)jPanel, this.paneGc);
        this.paneGc.gridy = 4;
        this.paneGc.gridheight = 2;
        this.paneGc.anchor = 16;
        this.adminStateAttr = this.getAdminStateAttr();
        this.add((Component)this.adminStateAttr.getUI(), this.paneGc);
        this.paneGc.gridy = 6;
        this.paneGc.weightx = 1.0;
        this.paneGc.weighty = 1.0;
        this.paneGc.gridheight = 0;
        this.add(Box.createVerticalGlue(), this.paneGc);
    }

    protected void addRightPane() {
        this.paneGc.weighty = 1.0;
        this.paneGc.weightx = 1.0;
        this.paneGc.gridheight = 0;
        this.add(Box.createHorizontalGlue(), this.paneGc);
    }

    protected void addOptDir(JPanel jPanel, GridBagConstraints gridBagConstraints) {
        this.optDir = new OptDir();
        jPanel.add((Component)this.optDir.getUI(), gridBagConstraints);
    }

    protected OpticalChannelAttr getOpticalChannelAttr() {
        return new OpticalChannelAttr(1);
    }

    protected AbstractCcdAttrsPane.AdminStateAttr getAdminStateAttr() {
        this.adminStateAttr = new OchncAdminStateAttr();
        return this.adminStateAttr;
    }

    protected void parseAdminAttr(ArrayList arrayList) {
        if (!this.optDir.useCktOptDir()) {
            arrayList.add(this.parseAttr(this.adminStateAttr.getStateString()));
        }
    }

    protected AbstractCcdAttrsPane.CircuitSizeAttr getCircuitSizeAttr() {
        return new AbstractCcdAttrsPane.CircuitSizeAttr(this.getCircuitType());
    }

    public void revalidateData() {
        super.revalidateData();
    }

    public void validatePage() throws Exception {
        super.validatePage();
        if (this.optChannel != null) {
            this.getCircuitInfo().setCktOptChannel(this.optChannel.getChannel());
        }
        if (this.optDir != null) {
            this.getCircuitInfo().setCktOptDir(this.optDir.getCktOptDir());
        }
    }

    protected ArrayList getAttrPairs() {
        ArrayList arrayList = super.getAttrPairs();
        if (this.optChannel != null) {
            arrayList.add(this.parseAttr(this.optChannel));
        }
        if (this.optDir != null) {
            arrayList.add(this.parseAttr(this.optDir));
        }
        return arrayList;
    }

    protected String getStatusText() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.getStatusText());
        if (this.optChannel != null) {
            stringBuffer.append("\n" + this.optChannel.toString());
        }
        if (this.optDir != null) {
            stringBuffer.append("\n" + this.optDir.toString());
        }
        return stringBuffer.toString();
    }

    public int getAdminState() {
        if (this.adminStateAttr.getUI().isVisible()) {
            return super.getAdminState();
        }
        return 3;
    }

    public CSHelpID getHelpID() {
        return NetCSHelpConst.CcdOCHNCAttrsPane;
    }

    public void dispose() {
        this.optChannel = null;
        this.optDir = null;
        super.dispose();
    }

    public String getDiagString() {
        StringBuffer stringBuffer = new StringBuffer(super.getDiagString());
        stringBuffer.append("Opt Wavelength:  " + this.optChannel + "\n");
        stringBuffer.append("Opt Direction: " + this.optDir + "\n");
        return stringBuffer.toString();
    }

    class OptDir
    implements ActionListener {
        private static final String PREF_LINE_DIR_VALUE = "warnOchncLineDir";
        private static final String PREF_LINE_DIR_DESCR = "Circuit Creation: OCHNC with line direction";
        protected JCheckBox useOptDirCB;
        protected JLabel optDirL;
        protected UComboBox optDirCB;
        private JPanel p = new JPanel();
        private JPanel bottom;

        OptDir() {
            this.p.setLayout(new BoxLayout(this.p, 1));
            JPanel jPanel = WzPane.createHorizontalPanel(null);
            jPanel.setAlignmentX(0.0f);
            this.useOptDirCB = new JCheckBox("Use OCHNC Direction", false);
            jPanel.add(this.useOptDirCB);
            this.p.add(jPanel);
            this.bottom = WzPane.createHorizontalPanel(null);
            this.bottom.setAlignmentX(0.0f);
            this.bottom.add(Box.createHorizontalStrut(20));
            this.optDirL = new JLabel("OCHNC Direction: ");
            this.bottom.add(this.optDirL);
            this.optDirCB = new UComboBox((Object[])CircuitOptDir.getCircuitOptDirAttrs());
            this.bottom.add((Component)this.optDirCB);
            this.p.add(this.bottom);
            this.useOptDirCB.addActionListener(this);
            this.setOptDirVisible(false);
        }

        public JPanel getUI() {
            return this.p;
        }

        public boolean useCktOptDir() {
            return this.useOptDirCB.isSelected();
        }

        public int getCktOptDir() {
            if (this.useCktOptDir()) {
                return ((Attribute)this.optDirCB.getSelectedItem()).getIntValue();
            }
            return -1;
        }

        public String toString() {
            if (this.useCktOptDir()) {
                return "OCHNC Direction: " + CircuitOptDir.getCktOptDirStringFromCktOptDir(this.getCktOptDir());
            }
            return "";
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.useOptDirCB.isSelected()) {
                IgnorableDialog.warningDialog((Component)CcdOCHNCAttrsPane.this, (String)ErrorMsg.getString((EID)NEMC.WID_OCHNC_CREAT_LINE_DIR), (String)PREF_LINE_DIR_VALUE, (String)PREF_LINE_DIR_DESCR);
            }
            this.setOptDirVisible(this.useOptDirCB.isSelected());
            this.setAdminStateVisible(!this.useOptDirCB.isSelected());
            this.setupOpticalChannelMode();
        }

        private void setOptDirVisible(boolean bl) {
            this.bottom.setVisible(bl);
        }

        private void setAdminStateVisible(boolean bl) {
            CcdOCHNCAttrsPane.this.adminStateAttr.getUI().setVisible(bl);
        }

        private void setupOpticalChannelMode() {
            int n = this.useOptDirCB.isSelected() ? 0 : 1;
            CcdOCHNCAttrsPane.this.optChannel.setMode(n);
        }
    }

    static class OchncAdminStatePanel
    extends AbstractAdminStatePanel
    implements IAdminStatePanel {
        protected JLabel adminStateLB;
        protected Attribute[] adminStateAttrs;

        public OchncAdminStatePanel() {
            this(false);
        }

        public OchncAdminStatePanel(boolean bl) {
            this.setLayout(new BoxLayout(this, 1));
            this.setBorder(BorderFactory.createTitledBorder("State"));
            JPanel jPanel = AbstractProvPane.createHorizontalPanel(null);
            jPanel.setAlignmentX(0.0f);
            this.adminStateLB = new JLabel("State: ");
            jPanel.add(this.adminStateLB);
            this.adminStateAttrs = this.getAdminAttrs(bl);
            this.adminStateCB = new UComboBox((Object[])this.adminStateAttrs);
            jPanel.add((Component)this.adminStateCB);
            this.add(jPanel);
            this.setAdminState(bl ? -2 : 3);
        }

        Attribute[] getAdminAttrs(boolean bl) {
            Attribute[] attributeArray = NetAdminState.getAdminStateAttrs();
            ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
            for (int i = 0; i < attributeArray.length; ++i) {
                int n = attributeArray[i].getIntValue();
                if (n == 4 || n != 3 && n != 1 && (n == 0 || n == 2)) continue;
                arrayList.add(attributeArray[i]);
            }
            if (bl) {
                arrayList.add(NetAdminState.NO_CHANGE_ATTR);
            }
            return arrayList.toArray(new Attribute[0]);
        }

        public void setAdminState(int n) {
            if (this.getAdminState() == n) {
                return;
            }
            for (int i = 0; i < this.adminStateAttrs.length; ++i) {
                if (this.adminStateAttrs[i].getIntValue() != n) continue;
                this.adminStateCB.setSelectedItem((Object)this.adminStateAttrs[i]);
            }
        }

        public void disableAll() {
            this.adminStateCB.setEnabled(false);
            this.adminStateLB.setEnabled(false);
        }

        public void enableAll() {
            this.adminStateCB.setEnabled(true);
            this.adminStateLB.setEnabled(true);
        }

        public boolean getApplyDropPorts() {
            return false;
        }

        public void setApplyDropPorts(boolean bl) {
        }

        public void setApplyDropPortsApplicable(boolean bl) {
        }

        public boolean isDropPortsSelected() {
            return false;
        }
    }

    class OchncAdminStateAttr
    extends AbstractCcdAttrsPane.AdminStateAttr {
        OchncAdminStateAttr() {
            this.adminStatePanel = new OchncAdminStatePanel();
        }

        public String toString() {
            return this.getStateString();
        }
    }
}

