/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.Attribute;
import cerent.cms.model.FramingType;
import cerent.cms.model.IRevertiveBehavior;
import cerent.cms.model.NetAdminState;
import cerent.cms.model.OchTrailHelper;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.topo.Network;
import cerent.cms.ui.NetworkDefaults;
import cerent.cms.ui.OpticalChannelAttr;
import cerent.cms.ui.RevertiveBehaviorPanel;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.WzPane;
import cerent.cms.ui.circuits.AbstractAdminStatePanel;
import cerent.cms.ui.circuits.AbstractCcdAttrsPane;
import cerent.cms.ui.circuits.CcdOCHNCAttrsPane;
import cerent.cms.ui.circuits.CircuitCreationDialog;
import cerent.cms.ui.circuits.IAdminStatePanel;
import cerent.util.gui.UComboBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CcdOCHTrailAttrsPane
extends CcdOCHNCAttrsPane {
    public static final String[] sonetPayloadTypes = new String[]{"SONET", "Ethernet", "FC/FICON", "Data Storage", "Video", "Other"};
    public static final String[] sdhPayloadTypes = new String[]{"SDH", "Ethernet", "FC/FICON", "Data Storage", "Video", "Other"};
    public static HashMap cktSizesMap = new HashMap();
    public static final int FEC_DISABLE = 0;
    public static final int FEC_ENABLE = 1;
    public static final int FEC_ENHANCED = 2;
    public static FecAttribute[] fecValues;
    public static final int MAP_ASYNCH = 1;
    public static final int MAP_SYNCH = 2;
    public static MappingAttribute[] mappingValues;
    protected ProtectionAttr protectionAttr;
    protected TrunkAttr trunkAttr;

    public CcdOCHTrailAttrsPane(CircuitCreationDialog circuitCreationDialog, WzDiagDebug wzDiagDebug, String string) {
        super(circuitCreationDialog, wzDiagDebug, string);
    }

    protected void addLeftPane() {
        super.addLeftPane();
        this.biDirAttr.setEnabled(false);
        this.circuitSizeAttr.setEnabled(true);
    }

    protected void addRightPane() {
        this.paneGc.gridheight = 2;
        this.protectionAttr = new ProtectionAttr();
        this.add((Component)this.protectionAttr.getUI(), this.paneGc);
        this.paneGc.gridy = 2;
        this.paneGc.gridheight = 4;
        this.paneGc.anchor = 16;
        this.trunkAttr = new TrunkAttr();
        this.add((Component)this.trunkAttr.getUI(), this.paneGc);
        this.paneGc.anchor = 18;
        this.paneGc.gridy = 6;
        this.paneGc.weightx = 1.0;
        this.paneGc.weighty = 1.0;
        this.paneGc.gridheight = 0;
        this.add(Box.createVerticalGlue(), this.paneGc);
        this.paneGc.gridx = 2;
        this.paneGc.gridy = 0;
        this.paneGc.weightx = 1.0;
        this.paneGc.weighty = 1.0;
        this.paneGc.gridwidth = 0;
        this.add(Box.createHorizontalGlue(), this.paneGc);
    }

    protected void addOptDir(JPanel jPanel, GridBagConstraints gridBagConstraints) {
    }

    protected OpticalChannelAttr getOpticalChannelAttr() {
        return new OpticalChannelAttr(2);
    }

    protected AbstractCcdAttrsPane.AdminStateAttr getAdminStateAttr() {
        this.adminStateAttr = new OchTrailAdminStateAttr();
        return this.adminStateAttr;
    }

    protected void parseAdminAttr(ArrayList arrayList) {
        arrayList.add(this.parseAttr(this.adminStateAttr.getStateString()));
        arrayList.add(this.parseAttr(this.adminStateAttr.getShortApplyDropString()));
        OchTrailAdminStateAttr ochTrailAdminStateAttr = (OchTrailAdminStateAttr)this.adminStateAttr;
        if (this.adminStateAttr.adminStatePanel.getApplyDropPorts()) {
            arrayList.add(this.parseAttr(ochTrailAdminStateAttr.getPortsStateString()));
        }
    }

    public void validatePage() throws Exception {
        int n;
        super.validatePage();
        OchTrailCircuitSizeAttr ochTrailCircuitSizeAttr = (OchTrailCircuitSizeAttr)this.circuitSizeAttr;
        String string = ochTrailCircuitSizeAttr.getPayloadType();
        if (!string.equals(sonetPayloadTypes[0]) && !string.equals(sdhPayloadTypes[0]) && (n = this.getPortAdminState()) == 3) {
            throw new Exception("This admin state is applicable to OCHCC\nports only for SONET/SDH payloads");
        }
        this.getCircuitInfo().setSpecificSize(ochTrailCircuitSizeAttr.getOchccCircuitSize().intValue());
        this.getCircuitInfo().setProtectionInfo(new CircuitCreatInfo.ProtectionInfo(this.isProtected(), this.getRevertiveBehavior()));
        this.getCircuitInfo().setTrunkInfo(new CircuitCreatInfo.TrunkInfo(this.isG709(), this.getFECMode(), this.getSfBer(), this.getSdBer(), this.getMappingType()));
    }

    public int getPortAdminState() {
        OchTrailAdminStatePanel ochTrailAdminStatePanel = (OchTrailAdminStatePanel)this.adminStateAttr.adminStatePanel;
        Attribute attribute = (Attribute)ochTrailAdminStatePanel.portStateCB.getSelectedItem();
        return attribute.getIntValue();
    }

    public boolean isProtected() {
        return this.protectionAttr.isProtected();
    }

    public boolean isRevertive() {
        return this.protectionAttr.isRevertive();
    }

    public IRevertiveBehavior getRevertiveBehavior() {
        return this.protectionAttr.getRevertiveBehavior();
    }

    public int getRevertiveTimeMin() {
        return this.protectionAttr.getRevertiveTime() / 60;
    }

    public boolean isG709() {
        return this.trunkAttr.isG709();
    }

    public int getFECMode() {
        return this.trunkAttr.getFECMode();
    }

    public int getSfBer() {
        return this.trunkAttr.getSfBer();
    }

    public int getSdBer() {
        return this.trunkAttr.getSdBer();
    }

    public int getMappingType() {
        return this.trunkAttr.getMappingType();
    }

    protected AbstractCcdAttrsPane.CircuitSizeAttr getCircuitSizeAttr() {
        return new OchTrailCircuitSizeAttr(this.getCircuitType());
    }

    protected ArrayList getAttrPairs() {
        ArrayList arrayList = super.getAttrPairs();
        if (this.isProtected()) {
            arrayList.add(this.parseAttr("Protection: Required"));
            if (this.isRevertive()) {
                arrayList.add(this.parseAttr("Reversion time: " + this.getRevertiveTimeMin() + " min"));
            } else {
                arrayList.add(this.parseAttr("Reversion: Non revertive"));
            }
        } else {
            arrayList.add(this.parseAttr("Protection: Non protected"));
        }
        if (this.isG709()) {
            arrayList.add(this.parseAttr("G.709 OTN: Enabled"));
            arrayList.add(this.parseAttr("FEC: " + this.trunkAttr.fecCB.getSelectedItem().toString()));
            arrayList.add(this.parseAttr("SF BER: " + this.trunkAttr.sfBerTF.getText()));
            arrayList.add(this.parseAttr("SD BER: " + this.trunkAttr.sdBerCB.getSelectedItem().toString()));
            arrayList.add(this.parseAttr("Mapping: " + this.trunkAttr.mappingCB.getSelectedItem().toString()));
        } else {
            arrayList.add(this.parseAttr("OTN: Disabled"));
        }
        return arrayList;
    }

    protected String getStatusText() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.getStatusText());
        if (this.isProtected()) {
            stringBuffer.append("Protection: Required");
            if (this.isRevertive()) {
                stringBuffer.append("Reversion time: " + this.getRevertiveTimeMin() + " min");
            } else {
                stringBuffer.append("Reversion: Non revertive");
            }
        } else {
            stringBuffer.append("Protection: None");
        }
        if (this.isG709()) {
            stringBuffer.append("OTN: Enabled");
            stringBuffer.append("FEC: " + this.trunkAttr.fecCB.getSelectedItem().toString());
            stringBuffer.append("SF BER: " + this.trunkAttr.sfBerTF.getText());
            stringBuffer.append("SD BER: " + this.trunkAttr.sdBerCB.getSelectedItem().toString());
            stringBuffer.append("Mapping: " + this.trunkAttr.mappingCB.getSelectedItem().toString());
        } else {
            stringBuffer.append("OTN: Disabled");
        }
        return stringBuffer.toString();
    }

    static {
        OchTrailHelper.OchccCircuitSize[] ochccCircuitSizeArray = new OchTrailHelper.OchccCircuitSize[]{OchTrailHelper.OchccCircuitSize.SIZE_OCHCC_OC_192, OchTrailHelper.OchccCircuitSize.SIZE_OCHCC_OC_48, OchTrailHelper.OchccCircuitSize.SIZE_OCHCC_OC_12, OchTrailHelper.OchccCircuitSize.SIZE_OCHCC_OC_3};
        cktSizesMap.put(sonetPayloadTypes[0], ochccCircuitSizeArray);
        ochccCircuitSizeArray = new OchTrailHelper.OchccCircuitSize[]{OchTrailHelper.OchccCircuitSize.SIZE_OCHCC_STM_64, OchTrailHelper.OchccCircuitSize.SIZE_OCHCC_STM_16, OchTrailHelper.OchccCircuitSize.SIZE_OCHCC_STM_4, OchTrailHelper.OchccCircuitSize.SIZE_OCHCC_STM_1};
        cktSizesMap.put(sdhPayloadTypes[0], ochccCircuitSizeArray);
        ochccCircuitSizeArray = new OchTrailHelper.OchccCircuitSize[]{OchTrailHelper.OchccCircuitSize.SIZE_OCHCC_10_GE, OchTrailHelper.OchccCircuitSize.SIZE_OCHCC_1_GE};
        cktSizesMap.put(sonetPayloadTypes[1], ochccCircuitSizeArray);
        ochccCircuitSizeArray = new OchTrailHelper.OchccCircuitSize[]{OchTrailHelper.OchccCircuitSize.SIZE_OCHCC_10_GFC, OchTrailHelper.OchccCircuitSize.SIZE_OCHCC_4_GFC, OchTrailHelper.OchccCircuitSize.SIZE_OCHCC_2_GFC, OchTrailHelper.OchccCircuitSize.SIZE_OCHCC_1_GFC, OchTrailHelper.OchccCircuitSize.SIZE_OCHCC_4_GFICON, OchTrailHelper.OchccCircuitSize.SIZE_OCHCC_2_GFICON, OchTrailHelper.OchccCircuitSize.SIZE_OCHCC_1_GFICON};
        cktSizesMap.put(sonetPayloadTypes[2], ochccCircuitSizeArray);
        ochccCircuitSizeArray = new OchTrailHelper.OchccCircuitSize[]{OchTrailHelper.OchccCircuitSize.SIZE_OCHCC_ESCON, OchTrailHelper.OchccCircuitSize.SIZE_OCHCC_ETR_CLO, OchTrailHelper.OchccCircuitSize.SIZE_OCHCC_ISC_PEER, OchTrailHelper.OchccCircuitSize.SIZE_OCHCC_ISC3_PEER_1G, OchTrailHelper.OchccCircuitSize.SIZE_OCHCC_ISC3_PEER_2G, OchTrailHelper.OchccCircuitSize.SIZE_OCHCC_ISC_COMPAT};
        cktSizesMap.put(sonetPayloadTypes[3], ochccCircuitSizeArray);
        ochccCircuitSizeArray = new OchTrailHelper.OchccCircuitSize[]{OchTrailHelper.OchccCircuitSize.SIZE_OCHCC_HDTV, OchTrailHelper.OchccCircuitSize.SIZE_OCHCC_SD1_D1, OchTrailHelper.OchccCircuitSize.SIZE_OCHCC_DV6000};
        cktSizesMap.put(sonetPayloadTypes[4], ochccCircuitSizeArray);
        ochccCircuitSizeArray = new OchTrailHelper.OchccCircuitSize[]{OchTrailHelper.OchccCircuitSize.SIZE_OCHCC_PASSTROUGH};
        cktSizesMap.put(sonetPayloadTypes[5], ochccCircuitSizeArray);
        fecValues = new FecAttribute[]{new FecAttribute("Disabled", 0), new FecAttribute("Enabled", 1), new FecAttribute("Enhanced", 2)};
        mappingValues = new MappingAttribute[]{new MappingAttribute("Asynchronous", 1), new MappingAttribute("Synchronous", 2)};
    }

    class OchTrailCircuitSizeAttr
    extends AbstractCcdAttrsPane.CircuitSizeAttr
    implements ActionListener {
        protected UComboBox typeCB;

        OchTrailCircuitSizeAttr(int n) {
            this.p = WzPane.createHorizontalPanel(null);
            this.p.setAlignmentX(0.0f);
            int n2 = 180;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 18;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(5, 5, 0, 0);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            this.lbl = new JLabel("Size: ");
            this.lbl.setPreferredSize(new Dimension(45, this.lbl.getHeight()));
            jPanel.add((Component)this.lbl, gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.typeCB = new UComboBox((ComboBoxModel)this.getCircuitSizeTypeCBModel(), n2);
            jPanel.add((Component)this.typeCB, gridBagConstraints);
            ++gridBagConstraints.gridy;
            this.sizeCB = new UComboBox((ComboBoxModel)this.getCircuitSizeCBModel(), n2);
            jPanel.add((Component)this.sizeCB, gridBagConstraints);
            ++gridBagConstraints.gridx;
            gridBagConstraints.weightx = 1.0;
            CcdOCHTrailAttrsPane.this.paneGc.gridwidth = 1;
            jPanel.add((Component)new JPanel(), gridBagConstraints);
            this.p.add(jPanel);
            this.typeCB.addActionListener((ActionListener)this);
            this.sizeCB.setRenderer((ListCellRenderer)new AbstractCcdAttrsPane.CircuitSizeCBRenderer());
        }

        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            this.typeCB.setEnabled(bl);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.sizeCB.setModel((ComboBoxModel)this.getCircuitSizeCBModel());
            this.sizeCB.setEnabled(this.typeCB.getSelectedItem() != null);
        }

        protected DefaultComboBoxModel getCircuitSizeTypeCBModel() {
            String[] stringArray = null;
            FramingType[] framingTypeArray = Network.instance().getSupportedFramingTypes();
            for (int i = 0; stringArray == null && i < framingTypeArray.length; ++i) {
                if (framingTypeArray[i].isSonet()) {
                    stringArray = sonetPayloadTypes;
                    continue;
                }
                if (!framingTypeArray[i].isSdh()) continue;
                stringArray = sdhPayloadTypes;
            }
            DefaultComboBoxModel defaultComboBoxModel = stringArray != null ? new DefaultComboBoxModel(stringArray) : new DefaultComboBoxModel();
            return defaultComboBoxModel;
        }

        protected DefaultComboBoxModel getCircuitSizeCBModel() {
            String string = (String)this.typeCB.getSelectedItem();
            if (string != null) {
                OchTrailHelper.OchccCircuitSize[] ochccCircuitSizeArray = (OchTrailHelper.OchccCircuitSize[])cktSizesMap.get(string);
                DefaultComboBoxModel<OchTrailHelper.OchccCircuitSize> defaultComboBoxModel = new DefaultComboBoxModel<OchTrailHelper.OchccCircuitSize>(ochccCircuitSizeArray);
                return defaultComboBoxModel;
            }
            DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
            return defaultComboBoxModel;
        }

        public String getPayloadType() {
            return (String)this.typeCB.getSelectedItem();
        }

        public int getCircuitSize() {
            return 31;
        }

        public OchTrailHelper.OchccCircuitSize getOchccCircuitSize() {
            return (OchTrailHelper.OchccCircuitSize)this.sizeCB.getSelectedItem();
        }

        public String toString() {
            OchTrailHelper.OchccCircuitSize ochccCircuitSize = this.getOchccCircuitSize();
            return "Size: " + this.getPayloadType() + "/" + ochccCircuitSize.toString();
        }
    }

    class TrunkAttr
    implements ActionListener {
        protected JCheckBox g709CB;
        protected UComboBox fecCB;
        protected JTextField sfBerTF;
        protected UComboBox sdBerCB;
        protected UComboBox mappingCB;
        private JPanel p;

        TrunkAttr() {
            int n = 120;
            int n2 = 160;
            this.p = new JPanel();
            this.p.setBorder(BorderFactory.createTitledBorder("Trunk"));
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.p.setLayout(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 18;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(5, 5, 0, 0);
            gridBagConstraints.gridwidth = 2;
            this.g709CB = new JCheckBox("G.709 OTN");
            this.p.add((Component)this.g709CB, gridBagConstraints);
            this.g709CB.setSelected(false);
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridwidth = 1;
            JLabel jLabel = new JLabel("FEC: ");
            jLabel.setPreferredSize(new Dimension(n, jLabel.getHeight()));
            this.p.add((Component)jLabel, gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.fecCB = new UComboBox((Object[])fecValues, n2);
            this.p.add((Component)this.fecCB, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            ++gridBagConstraints.gridy;
            jLabel = new JLabel("SF BER: ");
            jLabel.setPreferredSize(new Dimension(n, jLabel.getHeight()));
            this.p.add((Component)jLabel, gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.sfBerTF = new JTextField("1E-5");
            this.p.add((Component)this.sfBerTF, gridBagConstraints);
            this.sfBerTF.setEditable(false);
            this.sfBerTF.setEnabled(false);
            gridBagConstraints.gridx = 0;
            ++gridBagConstraints.gridy;
            jLabel = new JLabel("SD BER: ");
            jLabel.setPreferredSize(new Dimension(n, jLabel.getHeight()));
            this.p.add((Component)jLabel, gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.sdBerCB = new UComboBox((ComboBoxModel)this.getSdBerCBModel(), n2);
            this.p.add((Component)this.sdBerCB, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            ++gridBagConstraints.gridy;
            jLabel = new JLabel("Mapping: ");
            jLabel.setPreferredSize(new Dimension(n, jLabel.getHeight()));
            this.p.add((Component)jLabel, gridBagConstraints);
            ++gridBagConstraints.gridx;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            this.mappingCB = new UComboBox((Object[])mappingValues, n2);
            this.p.add((Component)this.mappingCB, gridBagConstraints);
            ++gridBagConstraints.gridx;
            gridBagConstraints.weightx = 1.0;
            CcdOCHTrailAttrsPane.this.paneGc.gridwidth = 0;
            this.p.add(Box.createVerticalGlue(), gridBagConstraints);
            this.g709CB.addActionListener(this);
            this.setupG709();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.setupG709();
        }

        protected void setupG709() {
            this.fecCB.setEnabled(this.g709CB.isSelected());
            this.sdBerCB.setEnabled(this.g709CB.isSelected());
            this.mappingCB.setEnabled(this.g709CB.isSelected());
            if (!this.g709CB.isSelected()) {
                this.fecCB.setSelectedIndex(0);
            }
        }

        public JPanel getUI() {
            return this.p;
        }

        protected DefaultComboBoxModel getSdBerCBModel() {
            Attribute[] attributeArray = NetworkDefaults.getAttributeMap().getAttributeArray("declareSdBerLevel");
            Attribute attribute = null;
            for (int i = 0; attribute == null && i < attributeArray.length; ++i) {
                if (attributeArray[i].getIntValue() != 7) continue;
                attribute = attributeArray[i];
            }
            DefaultComboBoxModel<Attribute> defaultComboBoxModel = new DefaultComboBoxModel<Attribute>(attributeArray);
            defaultComboBoxModel.setSelectedItem(attribute);
            return defaultComboBoxModel;
        }

        public boolean isG709() {
            return this.g709CB.isSelected();
        }

        public int getFECMode() {
            FecAttribute fecAttribute = (FecAttribute)this.fecCB.getSelectedItem();
            return fecAttribute.getFECMode();
        }

        public int getSfBer() {
            return 5;
        }

        public int getSdBer() {
            Attribute attribute = (Attribute)this.sdBerCB.getSelectedItem();
            return attribute.getIntValue();
        }

        public int getMappingType() {
            MappingAttribute mappingAttribute = (MappingAttribute)this.mappingCB.getSelectedItem();
            return mappingAttribute.getMappingType();
        }
    }

    static class MappingAttribute {
        private String label;
        private int mappingType;

        MappingAttribute(String string, int n) {
            this.label = string;
            this.mappingType = n;
        }

        public String toString() {
            return this.label;
        }

        public int getMappingType() {
            return this.mappingType;
        }
    }

    static class FecAttribute {
        private String label;
        private int fecValue;

        FecAttribute(String string, int n) {
            this.label = string;
            this.fecValue = n;
        }

        public String toString() {
            return this.label;
        }

        public int getFECMode() {
            return this.fecValue;
        }
    }

    class ProtectionAttr
    implements ActionListener {
        protected JCheckBox protectionCB;
        RevertiveBehaviorPanel revertiveBehaviorPanel;
        private JPanel p = new JPanel();

        ProtectionAttr() {
            this.p.setLayout(new BorderLayout());
            this.p.setBorder(BorderFactory.createTitledBorder("Protection"));
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout(0));
            this.protectionCB = new JCheckBox("Protection");
            jPanel.add(this.protectionCB);
            this.protectionCB.setSelected(false);
            this.protectionCB.addActionListener(this);
            this.p.add((Component)jPanel, "North");
            this.revertiveBehaviorPanel = new RevertiveBehaviorPanel(null);
            this.p.add((Component)this.revertiveBehaviorPanel, "Center");
            this.setupProtection();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.setupProtection();
        }

        protected void setupProtection() {
            this.revertiveBehaviorPanel.setRevertiveEnabled(this.protectionCB.isSelected());
        }

        public JPanel getUI() {
            return this.p;
        }

        public boolean isProtected() {
            return this.protectionCB.isSelected();
        }

        public boolean isRevertive() {
            IRevertiveBehavior iRevertiveBehavior = this.revertiveBehaviorPanel.getRevertiveBehavior();
            return iRevertiveBehavior.getReversionMode() == 2;
        }

        public int getRevertiveTime() {
            return this.revertiveBehaviorPanel.getReversionTime();
        }

        public IRevertiveBehavior getRevertiveBehavior() {
            return this.revertiveBehaviorPanel.getRevertiveBehavior();
        }
    }

    static class OchTrailAdminStatePanel
    extends AbstractAdminStatePanel
    implements IAdminStatePanel,
    ActionListener,
    ChangeListener {
        private DefaultComboBoxModel adminStateCBModel;
        protected JLabel adminStateLB;
        protected JCheckBox applyToPortsCB;
        protected UComboBox portStateCB;
        protected Attribute[] adminStateAttrs;
        protected Attribute[] portAdminStateAttrs;

        public OchTrailAdminStatePanel() {
            this(false);
        }

        public OchTrailAdminStatePanel(boolean bl) {
            int n;
            this.setLayout(new BoxLayout(this, 1));
            this.setBorder(BorderFactory.createTitledBorder("State"));
            JPanel jPanel = WzPane.createHorizontalPanel(null);
            jPanel.setAlignmentX(0.0f);
            this.adminStateLB = new JLabel("State: ");
            jPanel.add(this.adminStateLB);
            this.adminStateAttrs = this.getAdminAttrs(bl);
            this.adminStateCB = new UComboBox((Object[])this.adminStateAttrs);
            jPanel.add((Component)this.adminStateCB);
            Attribute attribute = null;
            for (n = 0; n < this.adminStateAttrs.length; ++n) {
                if (this.adminStateAttrs[n].getIntValue() != 0) continue;
                attribute = this.adminStateAttrs[n];
            }
            this.adminStateCB.setSelectedItem(attribute);
            this.adminStateCB.addActionListener((ActionListener)this);
            this.add(jPanel);
            jPanel = WzPane.createHorizontalPanel(null);
            jPanel.setAlignmentX(0.0f);
            this.applyToPortsCB = new JCheckBox("Apply to OCHCC ports");
            this.applyToPortsCB.setSelected(false);
            jPanel.add(this.applyToPortsCB);
            this.applyToPortsCB.addChangeListener(this);
            this.portAdminStateAttrs = this.getPortAdminAttrs();
            this.portStateCB = new UComboBox((Object[])this.portAdminStateAttrs);
            attribute = null;
            for (n = 0; n < this.portAdminStateAttrs.length; ++n) {
                if (this.portAdminStateAttrs[n].getIntValue() != 0) continue;
                attribute = this.portAdminStateAttrs[n];
            }
            this.portStateCB.setSelectedItem((Object)attribute);
            jPanel.add((Component)this.portStateCB);
            this.add(jPanel);
            this.setAdminState(bl ? -2 : 3);
            this.enablePortsCB();
            this.adjustPortsCB();
        }

        Attribute[] getAdminAttrs(boolean bl) {
            Attribute[] attributeArray = NetAdminState.getAdminStateAttrs();
            ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
            for (int i = 0; i < attributeArray.length; ++i) {
                int n = attributeArray[i].getIntValue();
                if (n == 4 || n == 3 || n != 1 && n != 0 && n == 2) continue;
                arrayList.add(attributeArray[i]);
            }
            if (bl) {
                arrayList.add(NetAdminState.NO_CHANGE_ATTR);
            }
            return arrayList.toArray(new Attribute[0]);
        }

        Attribute[] getPortAdminAttrs() {
            Attribute[] attributeArray = NetAdminState.getAdminStateAttrs();
            ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
            for (int i = 0; i < attributeArray.length; ++i) {
                int n = attributeArray[i].getIntValue();
                if (n == 4 || n != 3 && n != 1 && n != 0 && n == 2) continue;
                arrayList.add(attributeArray[i]);
            }
            return arrayList.toArray(new Attribute[0]);
        }

        public int getAdminState() {
            return ((Attribute)this.adminStateCB.getSelectedItem()).getIntValue();
        }

        public void setAdminState(int n) {
            if (this.getAdminState() == n) {
                return;
            }
            for (int i = 0; i < this.adminStateAttrs.length; ++i) {
                if (this.adminStateAttrs[i].getIntValue() != n) continue;
                this.adminStateCB.setSelectedItem((Object)this.adminStateAttrs[i]);
            }
        }

        public void disableAll() {
            this.adminStateCB.setEnabled(false);
            this.adminStateLB.setEnabled(false);
            this.applyToPortsCB.setEnabled(false);
            this.portStateCB.setEnabled(false);
        }

        public void enableAll() {
            this.adminStateCB.setEnabled(true);
            this.adminStateLB.setEnabled(true);
            this.enablePortsCB();
        }

        public JPanel getPanel() {
            return this;
        }

        public boolean getApplyDropPorts() {
            return this.applyToPortsCB.isSelected();
        }

        public void setApplyDropPorts(boolean bl) {
            this.applyToPortsCB.setSelected(bl);
        }

        public void setApplyDropPortsApplicable(boolean bl) {
        }

        public boolean isDropPortsSelected() {
            return this.applyToPortsCB.isSelected();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.adminStateCB) {
                this.enablePortsCB();
                this.adjustPortsCB();
            }
        }

        protected void enablePortsCB() {
            int n = this.getAdminState();
            boolean bl = n != -2;
            this.applyToPortsCB.setEnabled(bl);
        }

        protected void adjustPortsCB() {
            this.portStateCB.setEnabled(this.applyToPortsCB.isEnabled() && this.applyToPortsCB.isSelected());
        }

        public int getPortsState() {
            return ((Attribute)this.portStateCB.getSelectedItem()).getIntValue();
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent.getSource() == this.applyToPortsCB) {
                this.adjustPortsCB();
            }
        }
    }

    class OchTrailAdminStateAttr
    extends AbstractCcdAttrsPane.AdminStateAttr {
        OchTrailAdminStateAttr() {
            this.adminStatePanel = new OchTrailAdminStatePanel();
        }

        public String getApplyDropString() {
            String string = this.adminStatePanel.getApplyDropPorts() ? "True" : "False";
            return "Apply to OCHCC ports: " + string;
        }

        public String getShortApplyDropString() {
            return this.getApplyDropString();
        }

        public String getPortsStateString() {
            return "Ports state: " + NetAdminState.getAdminStateStringFromAdminState(((OchTrailAdminStatePanel)this.adminStatePanel).getPortsState());
        }
    }
}

