/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.CircuitSize;
import cerent.cms.model.CircuitType;
import cerent.cms.model.Feature;
import cerent.cms.model.ICircuitSize;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.NetworkModel;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.WzPane;
import cerent.cms.ui.circuits.AbstractCcdAttrsPane;
import cerent.cms.ui.circuits.CircuitCreationDialog;
import cerent.util.SDHTDMTerminology;
import cerent.util.SONETTDMTerminology;
import cerent.util.TDMTerminology;
import cerent.util.gui.IgnorableDialog;
import cerent.util.gui.UComboBox;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ListCellRenderer;

public class CcdVcatAttrsPane
extends AbstractCcdAttrsPane {
    public static final int LCASMODE_UNDEFINED = -1;
    private VcatMemberAttr vcatMemberAttr;
    private final int MODE_NONE = 0;
    private final int MODE_SWLCAS = 1;
    private final int MODE_LCAS = 2;
    private static final String VCAT_TITLE = "VCAT Circuit Creation";
    private static final String PREF_LCAS_MODE_VALUE = "warnLcasModeNone";
    private static final String PREF_LCAS_MODE_DESCR = "VCAT: In none VCAT mode, one member goes down, all members will go down";
    private static final String LCAS_MODE_WARN_MSG = "If VCAT mode is set to none and traffic on\none member goes down, all members will go down.";
    private int vcatTxMembers = 0;
    private int vcatRxMembers = 0;
    private int lcasMode = -1;

    public int getVcatTxMembers() {
        return this.vcatTxMembers;
    }

    public CcdVcatAttrsPane(CircuitCreationDialog circuitCreationDialog, WzDiagDebug wzDiagDebug, String string) {
        super(circuitCreationDialog, wzDiagDebug, string);
    }

    protected void initPane() {
        this.setLayout(new GridLayout(1, 2));
        this.add(this.getLeftPane());
        this.add(this.getRightPane());
    }

    private JPanel getLeftPane() {
        JPanel jPanel = CcdVcatAttrsPane.createVerticalPanel(null);
        JPanel jPanel2 = CcdVcatAttrsPane.createVerticalPanel("Circuit");
        this.circuitNameAttr = new AbstractCcdAttrsPane.CircuitNameAttr();
        jPanel2.add(this.circuitNameAttr.getUI());
        jPanel2.add(Box.createVerticalStrut(5));
        this.circuitTypeAttr = new AbstractCcdAttrsPane.CircuitTypeAttr(this.getCircuitType());
        jPanel2.add(this.circuitTypeAttr.getUI());
        jPanel2.add(Box.createVerticalStrut(5));
        this.biDirAttr = new AbstractCcdAttrsPane.BiDirAttr();
        jPanel2.add(this.biDirAttr.getUI());
        jPanel2.add(Box.createVerticalStrut(5));
        this.tl1ModeAttr = new AbstractCcdAttrsPane.TL1ModeAttr();
        jPanel2.add(this.tl1ModeAttr.getUI());
        jPanel2.add(Box.createVerticalStrut(5));
        this.tl1ModeAttr.tl1ModeCB.addActionListener(this);
        jPanel.add(jPanel2);
        this.adminStateAttr = new AbstractCcdAttrsPane.AdminStateAttr();
        jPanel.add(this.adminStateAttr.getUI());
        jPanel.add(Box.createVerticalGlue());
        return jPanel;
    }

    private JPanel getRightPane() {
        JPanel jPanel = CcdVcatAttrsPane.createVerticalPanel(null);
        this.vcatMemberAttr = new VcatMemberAttr(this.getCircuitType());
        jPanel.add(this.vcatMemberAttr.getUI());
        this.upsrAttr = new AbstractCcdAttrsPane.UpsrAttr();
        jPanel.add(this.upsrAttr.getUI());
        jPanel.add(Box.createVerticalGlue());
        return jPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (this.tl1ModeAttr != null && object == this.tl1ModeAttr.tl1ModeCB) {
            if (this.tl1ModeAttr.tl1ModeCB.isSelected()) {
                this.tl1ModeAttr.displayIgnorableDialog();
            }
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public void validatePage() throws Exception {
        if (this.vcatMemberAttr.getVcatMode() == 0) {
            IgnorableDialog.infoDialog((Component)this, (String)LCAS_MODE_WARN_MSG, (String)VCAT_TITLE, (String)PREF_LCAS_MODE_VALUE, (String)PREF_LCAS_MODE_DESCR);
        }
        super.validatePage();
        this.setCircuitSize(this.vcatMemberAttr.getMemSize());
        this.getCircuitInfo().setSize(this.vcatMemberAttr.getMemSize());
        this.vcatRxMembers = this.vcatTxMembers = this.vcatMemberAttr.getTxMembers();
        this.getCircuitInfo().setForwardMembers(this.vcatTxMembers);
        this.getCircuitInfo().setReverseMembers(this.vcatRxMembers);
        this.lcasMode = this.vcatMemberAttr.getVcatMode();
        this.getCircuitInfo().setLcasMode(this.vcatMemberAttr.getVcatMode());
    }

    protected ArrayList getAttrPairs() {
        ArrayList arrayList = super.getAttrPairs();
        if (this.vcatMemberAttr != null) {
            arrayList.add(this.parseAttr(this.vcatMemberAttr.getSymString()));
            arrayList.add(this.parseAttr(this.vcatMemberAttr.getMemSizeString()));
            arrayList.add(this.parseAttr(this.vcatMemberAttr.getNumMembersString()));
            arrayList.add(this.parseAttr(this.vcatMemberAttr.getModeString()));
        }
        return arrayList;
    }

    protected String getStatusText() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.getStatusText());
        stringBuffer.append(this.vcatMemberAttr.toString());
        return stringBuffer.toString();
    }

    public void revalidateData() {
        int n;
        int n2;
        int n3;
        if (this.db.on) {
            this.db.println("revalidateData");
        }
        super.revalidateData();
        if (this.biDirAttr != null) {
            this.biDirAttr.bidirCB.setSelected(true);
            this.biDirAttr.bidirCB.setEnabled(false);
        }
        if (this.getCircuitInfo() == null) {
            n3 = this.getCircuitSize();
            n2 = this.vcatTxMembers;
            int n4 = this.vcatRxMembers;
            n = this.lcasMode;
        } else {
            n3 = this.getCircuitInfo().size();
            n2 = this.getCircuitInfo().forwardMembers();
            int n5 = this.getCircuitInfo().reverseMembers();
            n = this.getCircuitInfo().lcasMode();
        }
        this.vcatMemberAttr.symmetricCB.setSelected(true);
        this.vcatMemberAttr.symmetricCB.setEnabled(false);
        this.vcatMemberAttr.setMemSize(n3);
        this.vcatMemberAttr.setTxMembers(n2);
        this.vcatMemberAttr.setVcatMode(n);
        int n6 = this.getAbstractCktDlg().getCircuitType();
        switch (n6) {
            case 10: {
                this.upsrAttr.setUpsrComponents((TDMTerminology)SONETTDMTerminology.instance(), true, true, true);
                break;
            }
            case 11: {
                boolean bl = NetworkModel.instance().getCmsHostModel().provides(Feature.UPSR_VT_THRESH);
                this.upsrAttr.setUpsrComponents((TDMTerminology)SONETTDMTerminology.instance(), true, bl, false);
                break;
            }
            case 12: {
                this.upsrAttr.setUpsrComponents((TDMTerminology)SDHTDMTerminology.instance(), true, true, false);
                break;
            }
            case 13: {
                this.upsrAttr.setUpsrComponents((TDMTerminology)SDHTDMTerminology.instance(), true, false, false);
            }
        }
    }

    public CSHelpID getHelpID() {
        ICircuitType iCircuitType = CircuitType.getCircuitType((int)this.getAbstractCktDlg().getCircuitType());
        if (iCircuitType.isHoVcatCircuitType()) {
            return NetCSHelpConst.CcdHoVcatAttrsPane;
        }
        return NetCSHelpConst.CcdLoVcatAttrsPane;
    }

    public void removeListeners() {
        if (this.tl1ModeAttr != null) {
            this.tl1ModeAttr.tl1ModeCB.removeActionListener(this);
        }
        super.removeListeners();
    }

    public void dispose() {
        this.vcatMemberAttr = null;
        super.dispose();
    }

    public String getDiagString() {
        StringBuffer stringBuffer = new StringBuffer(super.getDiagString());
        stringBuffer.append("VCAT Member Attr: " + this.vcatMemberAttr + "\n");
        stringBuffer.append("VCAT TX Members: " + this.vcatTxMembers + "\n");
        stringBuffer.append("VCAT RX Members: " + this.vcatRxMembers + "\n");
        stringBuffer.append("LCAS Mode: " + this.lcasMode + "\n");
        return stringBuffer.toString();
    }

    class VcatMemberAttr {
        private JPanel p;
        protected UComboBox sizeCB;
        protected UComboBox memSizeCB;
        protected UComboBox txMemCB;
        protected JCheckBox symmetricCB;
        protected JRadioButton modeNoneRB;
        protected JRadioButton modeSwLcasRB;
        protected JRadioButton modeLcasRB;
        protected ButtonGroup modeGroup;
        private Integer[] allowedMemNums = new Integer[]{new Integer(2), new Integer(8)};
        private String[] MODE_STRS = new String[]{"None", "SW-LCAS", "LCAS"};

        VcatMemberAttr(int n) {
            this.p = WzPane.createVerticalPanel("VCAT");
            this.p.setAlignmentX(0.0f);
            JPanel jPanel = WzPane.createHorizontalPanel(null);
            jPanel.setAlignmentX(0.0f);
            this.symmetricCB = new JCheckBox("Symmetric", true);
            jPanel.add(this.symmetricCB);
            this.p.add(jPanel);
            this.p.add(Box.createVerticalStrut(5));
            jPanel = WzPane.createHorizontalPanel(null);
            jPanel.setAlignmentX(0.0f);
            jPanel.add(new JLabel("Member size: "));
            this.memSizeCB = new UComboBox();
            jPanel.add((Component)this.memSizeCB);
            this.memSizeCB.setModel((ComboBoxModel)CcdVcatAttrsPane.this.getCircuitSizeCBModel(n));
            this.memSizeCB.setRenderer((ListCellRenderer)new AbstractCcdAttrsPane.CircuitSizeCBRenderer());
            this.p.add(jPanel);
            this.p.add(Box.createVerticalStrut(5));
            jPanel = WzPane.createHorizontalPanel(null);
            jPanel.setAlignmentX(0.0f);
            jPanel.add(new JLabel("Num. of Members: "));
            this.txMemCB = new UComboBox();
            jPanel.add((Component)this.txMemCB);
            for (int i = 1; i < 257; ++i) {
                this.txMemCB.addItem((Object)new Integer(i));
            }
            this.p.add(jPanel);
            this.p.add(Box.createVerticalStrut(5));
            jPanel = WzPane.createHorizontalPanel(null);
            jPanel.setAlignmentX(0.0f);
            this.modeGroup = new ButtonGroup();
            this.modeNoneRB = new JRadioButton("None", true);
            this.modeGroup.add(this.modeNoneRB);
            this.modeSwLcasRB = new JRadioButton("SW-LCAS");
            this.modeGroup.add(this.modeSwLcasRB);
            this.modeLcasRB = new JRadioButton("LCAS");
            this.modeGroup.add(this.modeLcasRB);
            jPanel.add(new JLabel("Mode:      "));
            jPanel.add(this.modeNoneRB);
            jPanel.add(this.modeSwLcasRB);
            jPanel.add(this.modeLcasRB);
            this.p.add(jPanel);
            this.p.add(Box.createVerticalStrut(5));
        }

        public void setMemSize(int n) {
            if (n == CircuitSize.UNDEFINED_TYPE) {
                this.memSizeCB.setSelectedItem(null);
            } else {
                ICircuitSize iCircuitSize = CircuitSize.getCircuitSize((int)n);
                if (((DefaultComboBoxModel)this.memSizeCB.getModel()).getIndexOf(iCircuitSize) >= 0) {
                    this.memSizeCB.setSelectedItem((Object)iCircuitSize);
                }
            }
        }

        public int getMemSize() throws Exception {
            if (this.memSizeCB.getSelectedItem() == null) {
                throw new Exception("Member Size not specified.");
            }
            return ((CircuitSize)this.memSizeCB.getSelectedItem()).getEnum();
        }

        public void setTxMembers(int n) {
            this.txMemCB.setSelectedItem((Object)new Integer(n));
        }

        public void setVcatMode(int n) {
            if (n == 1) {
                this.modeSwLcasRB.setSelected(true);
            } else if (n == 2) {
                this.modeLcasRB.setSelected(true);
            } else {
                this.modeNoneRB.setSelected(true);
            }
        }

        public int getTxMembers() throws Exception {
            if (this.txMemCB.getSelectedItem() == null) {
                throw new Exception("Number of members not selected.");
            }
            return (Integer)this.txMemCB.getSelectedItem();
        }

        public int getVcatMode() {
            if (this.modeNoneRB.isSelected()) {
                return 0;
            }
            if (this.modeSwLcasRB.isSelected()) {
                return 1;
            }
            if (this.modeLcasRB.isSelected()) {
                return 2;
            }
            return 0;
        }

        public JPanel getUI() {
            return this.p;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("\n" + this.getSymString());
            stringBuffer.append("\n" + this.getMemSizeString());
            stringBuffer.append("\n" + this.getNumMembersString());
            stringBuffer.append("\n" + this.getModeString());
            stringBuffer.append("\n");
            return stringBuffer.toString();
        }

        public String getSymString() {
            return "Symmetric: true";
        }

        public String getMemSizeString() {
            try {
                return "Member Size: " + CircuitSize.getCircuitSize((int)this.getMemSize()).getCircuitSizeString();
            }
            catch (Exception exception) {
                return "Member Size: ERROR";
            }
        }

        public String getNumMembersString() {
            try {
                return "# Members: " + this.getTxMembers();
            }
            catch (Exception exception) {
                return "# Members:  + ERROR";
            }
        }

        public String getModeString() {
            return "Mode: " + this.MODE_STRS[this.getVcatMode()];
        }
    }
}

