/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.IEntityModel;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.NetVcatCircuit;
import cerent.cms.route.DropPrefs;
import cerent.cms.route.MemberGroupPrefs;
import cerent.cms.route.MemberPrefs;
import cerent.cms.route.RoutePrefs;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.circuits.AbstractCircuitDialog;
import cerent.cms.ui.circuits.VcatMemberTableData;
import cerent.cms.ui.circuits.WzCcdPane;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.Preferences;
import cerent.util.gui.IgnorableDialog;
import cerent.util.gui.UComboBox;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class CcdVcatRoutePane
extends WzCcdPane
implements ChangeListener {
    Preferences prefs = Preferences.instance();
    UTable table;
    MemTableModel tbModel;
    WzCcdPane.AutoRouteCheckBox autoRouteCB;
    JCheckBox urnCB;
    JCheckBox rrbcCB;
    JRadioButton commonFiberRB;
    JRadioButton independentFiberRB;
    ButtonGroup routing;
    JComboBox protectionCB;
    JComboBox nodeDiverseCB;
    JComboBox memIdsCB;
    UComboBox protectAllCB;
    UComboBox diversePathAllCB;
    JCheckBox extendedBufferChBx;
    boolean isFcmrPort = false;
    boolean isCe1000Port = false;
    List memberCktList;
    static final String PREF_PATH = "ctc.circuit.creation";
    static final String PREF_URN = "useRequiredNodesSpansVcat";
    static final String PREF_RRBC = "reviewRouteBeforeCreationVcat";
    boolean sameNode = false;
    static final String VCAT_TITLE = "VCAT Circuit Creation";
    static final String PREF_FULLY_PROT_VALUE = "warnFullyProtected";
    static final String PREF_FULLY_PROT_DESCR = "VCAT: In common fiber routing, fully-protected members can only be line protected";
    static final String FULLY_PROT_WARN_MSG = "In common-fiber routing, fully-protected\nmembers require line-level fiber protection.";
    protected RoutePrefs routePrefs;
    protected boolean pca = false;
    protected boolean pathProt = false;
    protected boolean rrbc = false;
    protected boolean urn = false;
    protected boolean autoRoute = false;
    protected boolean vcatCommonFiberRouting = true;
    protected ArrayList vcatMemberPrefs;
    protected int driMemCount;
    final int COL0 = 0;
    final int COL1 = 1;
    final int COL2 = 2;
    final int COL3 = 3;
    static String[] protectionChoices = new String[]{"Fully Protected", "PCA", "Unprotected", "DRI"};
    String[] nodeDiverseOptions = new String[]{"Required", "Desired", "Link Diversity Only", "N/A"};
    Integer[] availableMemIds;
    static final int MEM_CKT_NAME_LEN = 48;
    boolean disableURN = false;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;

    public String getShortName() {
        return "VCAT Routing Options";
    }

    public CcdVcatRoutePane(AbstractCircuitDialog abstractCircuitDialog, WzDiagDebug wzDiagDebug, String string) {
        super(abstractCircuitDialog, wzDiagDebug, string);
        this.getRoutePrefs();
    }

    protected void initPane() {
        this.setLayout(new BoxLayout(this, 1));
        this.setAlignmentX(0.0f);
        this.autoRouteCB = new WzCcdPane.AutoRouteCheckBox(this, (AbstractCircuitDialog)this.parent, PREF_PATH, PREF_URN, PREF_RRBC);
        this.add(this.autoRouteCB);
        this.autoRouteCB.init();
        this.autoRoute = this.autoRouteCB.getDefaultAutoRoute();
        this.urn = this.autoRouteCB.getDefaultUrn();
        this.rrbc = this.autoRouteCB.getDefaultRrbc();
        this.autoRouteCB.addChangeListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setAlignmentX(0.0f);
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        jPanel.setLayout(new FlowLayout(0));
        this.urnCB = new JCheckBox("Using Required Nodes/Spans");
        jPanel.add(this.urnCB);
        this.rrbcCB = new JCheckBox("Review Route Before Creation");
        jPanel.add(this.rrbcCB);
        this.urnCB.addChangeListener(this);
        this.rrbcCB.addChangeListener(this);
        this.add(jPanel);
        this.add(Box.createVerticalStrut(10));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setAlignmentX(0.0f);
        jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.commonFiberRB = new JRadioButton("Common Fiber Routing", true);
        jPanel.add(this.commonFiberRB);
        this.commonFiberRB.addActionListener(this);
        this.independentFiberRB = new JRadioButton("Split Routing");
        jPanel.add(this.independentFiberRB);
        this.independentFiberRB.addActionListener(this);
        this.routing = new ButtonGroup();
        this.routing.add(this.commonFiberRB);
        this.routing.add(this.independentFiberRB);
        jPanel.setBorder(BorderFactory.createTitledBorder(""));
        jPanel2.add(jPanel);
        jPanel2.add(Box.createHorizontalStrut(15));
        this.extendedBufferChBx = new JCheckBox("Use Extended Buffer");
        jPanel2.add(this.extendedBufferChBx);
        this.add(jPanel2);
        this.add(Box.createVerticalStrut(5));
        this.add(new JLabel("Member Preferences"));
        this.add(Box.createVerticalStrut(5));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.setAlignmentX(0.0f);
        this.tbModel = new MemTableModel();
        this.table = new UTable((TableModel)this.tbModel);
        Dimension dimension = new Dimension(300, 150);
        this.table.setPreferredScrollableViewportSize(dimension);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        uScrollPane.setAlignmentY(0.0f);
        jPanel3.add((Component)uScrollPane);
        jPanel3.add(Box.createHorizontalStrut(10));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createTitledBorder("Set Preferences for all Members")));
        jPanel4.setAlignmentY(0.0f);
        this.protectAllCB = new UComboBox((Object[])protectionChoices);
        this.protectAllCB.addActionListener((ActionListener)this);
        this.protectAllCB.setAlignmentX(0.0f);
        this.diversePathAllCB = new UComboBox((Object[])this.nodeDiverseOptions);
        this.diversePathAllCB.addActionListener((ActionListener)this);
        this.diversePathAllCB.setAlignmentX(0.0f);
        JLabel jLabel = new JLabel("Protection:");
        jLabel.setAlignmentX(0.0f);
        jPanel4.add(jLabel);
        jPanel4.add((Component)this.protectAllCB);
        jPanel4.add(Box.createVerticalStrut(10));
        jLabel = new JLabel("Node-Diverse Path:");
        jLabel.setAlignmentX(0.0f);
        jPanel4.add(jLabel);
        jPanel4.add((Component)this.diversePathAllCB);
        jPanel3.add(jPanel4);
        jPanel3.add(Box.createHorizontalGlue());
        this.add(jPanel3);
        this.add(Box.createVerticalStrut(5));
        this.availableMemIds = new Integer[256];
        int n = 0;
        while (n < 256) {
            this.availableMemIds[n++] = new Integer(n);
        }
    }

    protected int getVcatTxMembers() {
        return this.getAbstractCktDlg().getVcatTxMembers();
    }

    protected INetCircuit getCircuit() {
        return this.getAbstractCktDlg().getCircuit();
    }

    protected CircuitCreatInfo getCircuitInfo() {
        return this.getAbstractCktDlg().getCircuitInfo();
    }

    protected int getCircuitType() {
        return this.getAbstractCktDlg().getCircuitType();
    }

    protected int getCircuitSize() {
        return this.getAbstractCktDlg().getCircuitSize();
    }

    protected boolean isAutoRoute() {
        return this.autoRoute;
    }

    public boolean isPca() {
        return this.pca;
    }

    public void setPca(boolean bl) {
        this.pca = bl;
    }

    public boolean isPathProt() {
        return this.pathProt;
    }

    public void setPathProt(boolean bl) {
        this.pathProt = bl;
    }

    public boolean isRrbc() {
        return this.rrbc;
    }

    public boolean isUrn() {
        return this.urn;
    }

    public boolean isVcatCommonFiberRouting() {
        return this.vcatCommonFiberRouting;
    }

    public void setVcatCommonFiberRouting(boolean bl) {
        this.vcatCommonFiberRouting = bl;
    }

    public RoutePrefs getRoutePrefs() {
        if (this.routePrefs == null) {
            this.routePrefs = new RoutePrefs();
            this.routePrefs.setPathProt(0);
            this.routePrefs.setDiversityOption(1);
        }
        return this.routePrefs;
    }

    public void setRoutePrefs(RoutePrefs routePrefs) {
        if (routePrefs != null) {
            this.routePrefs = routePrefs;
        }
    }

    public ArrayList getVcatMemberPrefs() {
        return this.vcatMemberPrefs;
    }

    public void enteringPane() {
        this.sameNode = this.getAbstractCktDlg().getSourceNode() == this.getAbstractCktDlg().getDestNode();
        super.enteringPane();
        this.syncButtons();
    }

    public boolean handleBack() {
        try {
            this.getAbstractCktDlg().deleteDestination();
        }
        catch (Exception exception) {
            WzDiagDebug.printStackTrace((Throwable)exception);
            ErrorMsg.displayError((Component)this, (EID)NEMC.EID_DELETE_DESTINATION_FAILED);
        }
        return super.handleBack();
    }

    protected String getNextPaneName() {
        if (!this.urn) {
            if (this.getAbstractCktDlg().isLoCkt()) {
                this.getAbstractCktDlg();
                return AbstractCircuitDialog.WZPANE_GET_LO;
            }
            this.getAbstractCktDlg();
            return "Route Review/Edit";
        }
        this.getAbstractCktDlg();
        return "Circuit Constraints For Automatic Routing";
    }

    public void validatePage() throws Exception {
        Iterator iterator;
        VcatMemberTableData vcatMemberTableData;
        this.db.fine("validatePage()");
        this.stopTableCellEditing();
        this.checkWarningRequired();
        Iterator iterator2 = this.tbModel.tabData.iterator();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        while (iterator2.hasNext()) {
            vcatMemberTableData = (VcatMemberTableData)iterator2.next();
            Integer n = vcatMemberTableData.memberNumber;
            if (n == null) {
                throw new Exception("Please specify a member number");
            }
            if (this.db.on()) {
                this.db.println("validatePage(): current member # is: " + n);
            }
            if (n < 1 || n > 256) {
                throw new Exception("Member numbers have to be in the range 1 to 256 ");
            }
            if (hashSet.contains(n)) {
                throw new Exception("Member numbers have to be unique");
            }
            hashSet.add(n);
            if (vcatMemberTableData.memberName.length() <= 48) continue;
            throw new Exception("Member circuit name is too long (max 48)");
        }
        this.autoRoute = this.autoRouteCB.isSelected();
        this.rrbc = this.rrbcCB.isSelected();
        this.urn = this.urnCB.isSelected();
        this.vcatCommonFiberRouting = this.commonFiberRB.isSelected();
        this.prefs.setBoolean(PREF_PATH, PREF_URN, this.urnCB.isSelected());
        this.prefs.setBoolean(PREF_PATH, PREF_RRBC, this.rrbcCB.isSelected());
        if (this.db.on()) {
            if (this.memberCktList != null) {
                this.db.println("validatePage():MemberCktList size is:" + this.memberCktList.size());
            } else {
                this.db.println("ValidatePage():MemberCktList is null");
            }
        }
        this.vcatMemberPrefs = this.tbModel.tabData;
        this.routePrefs = new RoutePrefs(false);
        this.routePrefs.setCircuitType(this.getCircuitType());
        this.routePrefs.setSrc(this.getAbstractCktDlg().getSource().getNetElement());
        if (this.getAbstractCktDlg().getAltSource() != null) {
            this.routePrefs.setSecSrc(this.getAbstractCktDlg().getAltSource().getNetElement());
        }
        DropPrefs dropPrefs = new DropPrefs(this.routePrefs);
        dropPrefs.setCommonFiber(this.vcatCommonFiberRouting);
        dropPrefs.setDrop(this.getAbstractCktDlg().getDest().getNetElement());
        if (this.getAbstractCktDlg().getAltDest() != null) {
            dropPrefs.setSecondaryDrop(this.getAbstractCktDlg().getAltDest().getNetElement());
        }
        MemberGroupPrefs memberGroupPrefs = null;
        MemberGroupPrefs memberGroupPrefs2 = null;
        MemberGroupPrefs memberGroupPrefs3 = null;
        MemberPrefs memberPrefs = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        INetCircuit iNetCircuit = null;
        this.pathProt = false;
        if (this.vcatCommonFiberRouting) {
            iterator = this.vcatMemberPrefs.iterator();
            while (iterator.hasNext()) {
                vcatMemberTableData = (VcatMemberTableData)iterator.next();
                iNetCircuit = (INetCircuit)this.memberCktList.get(n4);
                if (n4 == 0) {
                    this.pca = vcatMemberTableData.protectionType == 4;
                }
                switch (vcatMemberTableData.protectionType) {
                    case 6: {
                        if (n == 0) {
                            memberGroupPrefs = new MemberGroupPrefs(dropPrefs);
                            memberGroupPrefs.setMemberBandwidth(this.getCircuitSize());
                            memberGroupPrefs.setMemberCount(++n);
                            memberPrefs = memberGroupPrefs.getMemberPrefs();
                            memberPrefs.setPathProtection(vcatMemberTableData.protectionType);
                            memberPrefs.setDir(3);
                            memberPrefs.setMemberId(n4);
                        } else {
                            memberGroupPrefs.setMemberCount(++n);
                        }
                        iNetCircuit.setCircuitName(vcatMemberTableData.memberName);
                        iNetCircuit.setMemberNumber(vcatMemberTableData.memberNumber);
                        iNetCircuit.setMemberPrefs(memberGroupPrefs.getMemberPrefs());
                        break;
                    }
                    case 4: {
                        if (n2 == 0) {
                            memberGroupPrefs2 = new MemberGroupPrefs(dropPrefs);
                            memberGroupPrefs2.setMemberBandwidth(this.getCircuitSize());
                            memberGroupPrefs2.setMemberCount(++n2);
                            memberPrefs = memberGroupPrefs2.getMemberPrefs();
                            memberPrefs.setPathProtection(vcatMemberTableData.protectionType);
                            memberPrefs.setDir(3);
                            memberPrefs.setMemberId(n4);
                        } else {
                            memberGroupPrefs2.setMemberCount(++n2);
                        }
                        iNetCircuit.setCircuitName(vcatMemberTableData.memberName);
                        iNetCircuit.setMemberNumber(vcatMemberTableData.memberNumber);
                        iNetCircuit.setMemberPrefs(memberGroupPrefs2.getMemberPrefs());
                        break;
                    }
                    case 2: {
                        if (memberGroupPrefs3 == null) {
                            memberGroupPrefs3 = new MemberGroupPrefs(dropPrefs);
                            memberGroupPrefs3.setMemberBandwidth(this.getCircuitSize());
                            memberGroupPrefs3.setMemberCount(++n3);
                            memberPrefs = memberGroupPrefs3.getMemberPrefs();
                            memberPrefs.setPathProtection(vcatMemberTableData.protectionType);
                            memberPrefs.setDir(3);
                            memberPrefs.setMemberId(n4);
                        } else {
                            memberGroupPrefs3.setMemberCount(++n3);
                        }
                        iNetCircuit.setCircuitName(vcatMemberTableData.memberName);
                        iNetCircuit.setMemberNumber(vcatMemberTableData.memberNumber);
                        iNetCircuit.setMemberPrefs(memberGroupPrefs3.getMemberPrefs());
                    }
                }
                ++n4;
            }
            if (memberGroupPrefs != null) {
                dropPrefs.addMemberGroupPrefs(memberGroupPrefs);
                this.pathProt = true;
            }
            if (memberGroupPrefs2 != null) {
                dropPrefs.addMemberGroupPrefs(memberGroupPrefs2);
                this.pathProt = false;
            }
            if (memberGroupPrefs3 != null) {
                dropPrefs.addMemberGroupPrefs(memberGroupPrefs3);
                this.pathProt = false;
            }
        } else {
            iterator = this.vcatMemberPrefs.iterator();
            while (iterator.hasNext()) {
                vcatMemberTableData = (VcatMemberTableData)iterator.next();
                iNetCircuit = (INetCircuit)this.memberCktList.get(n4);
                memberGroupPrefs = new MemberGroupPrefs(dropPrefs);
                memberGroupPrefs.setMemberBandwidth(this.getCircuitSize());
                memberGroupPrefs.setMemberCount(1);
                memberPrefs = memberGroupPrefs.getMemberPrefs();
                memberPrefs.setPathProtection(vcatMemberTableData.protectionType);
                memberPrefs.setDir(3);
                memberPrefs.setMemberId(vcatMemberTableData.memberNumber);
                if (vcatMemberTableData.nodeDiverseOption != 0) {
                    memberPrefs.setDiversityOption(vcatMemberTableData.nodeDiverseOption);
                }
                iNetCircuit.setCircuitName(vcatMemberTableData.memberName);
                iNetCircuit.setMemberNumber(vcatMemberTableData.memberNumber);
                iNetCircuit.setMemberPrefs(memberGroupPrefs.getMemberPrefs());
                dropPrefs.addMemberGroupPrefs(memberGroupPrefs);
                ++n4;
            }
        }
        this.routePrefs.setFwdDropPrefs(dropPrefs);
        ((NetVcatCircuit)this.getAbstractCktDlg().ckt).setExtBuffer(this.extendedBufferChBx.isSelected());
        this.addOrRouteNewCircuit();
    }

    protected void addOrRouteNewCircuit() throws Exception {
        if (!this.urn) {
            this.getAbstractCktDlg().deleteDestination();
            if (this.db.on) {
                this.db.println("validatePage: deleteDestination() worked");
            }
            if (!this.getAbstractCktDlg().isLoCkt()) {
                this.getAbstractCktDlg().addDestination(true);
                if (this.db.on) {
                    this.db.println("validatePage: addDestination(true) worked");
                }
            }
        }
    }

    public void revalidateData() {
        this.db.fine("rvalidateData");
        this.autoRouteCB.init();
        this.autoRoute = this.autoRouteCB.getDefaultAutoRoute();
        this.urn = this.autoRouteCB.getDefaultUrn();
        this.rrbc = this.autoRouteCB.getDefaultRrbc();
        this.urnCB.setSelected(this.urn);
        this.rrbcCB.setSelected(this.rrbc);
        this.disableURN = false;
        int n = this.tbModel.tabData.size();
        if (n < this.getVcatTxMembers()) {
            if (this.db.on()) {
                this.db.println("revalidateData(): Member table size increased");
            }
            for (int i = n; i < this.getVcatTxMembers(); ++i) {
                this.tbModel.tabData.add(new VcatMemberTableData(this.availableMemIds[i], "", 6));
            }
            this.tbModel.fireTableStructureChanged();
        }
        if ((n = this.tbModel.tabData.size()) > this.getVcatTxMembers()) {
            if (this.db.on()) {
                this.db.println("revalidateData(): Member table size decreased");
            }
            int n2 = n - this.getVcatTxMembers();
            while (n2 > 0) {
                this.tbModel.tabData.remove(this.getVcatTxMembers() + --n2);
            }
            this.tbModel.fireTableStructureChanged();
        }
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        this.memIdsCB = new JComboBox<Integer>(this.availableMemIds);
        tableColumn.setCellEditor(new DefaultCellEditor(this.memIdsCB));
        int n3 = tableColumn.getPreferredWidth();
        tableColumn.setPreferredWidth(n3 -= 15);
        tableColumn = tableColumnModel.getColumn(2);
        this.protectionCB = new JComboBox<String>(protectionChoices);
        this.protectionCB.setAlignmentY(0.0f);
        tableColumn.setCellEditor(new DefaultCellEditor(this.protectionCB));
        n3 = tableColumn.getPreferredWidth();
        tableColumn.setPreferredWidth(n3 += 25);
        tableColumn = tableColumnModel.getColumn(3);
        this.nodeDiverseCB = new JComboBox<String>(this.nodeDiverseOptions);
        tableColumn.setCellEditor(new DefaultCellEditor(this.nodeDiverseCB));
        n3 = tableColumn.getPreferredWidth();
        tableColumn.setPreferredWidth(n3 += 40);
        if (this.sameNode) {
            this.autoRoute = true;
            this.autoRouteCB.setSelected(this.autoRoute);
            this.autoRouteCB.setEnabled(1);
            this.urnCB.setSelected(false);
            this.urnCB.setEnabled(false);
            this.urn = this.urnCB.isSelected();
            this.rrbcCB.setSelected(false);
            this.rrbcCB.setEnabled(false);
            this.rrbc = this.rrbcCB.isSelected();
            this.db.fine("revalidateData(): same node AutoRoute selected+disabled");
        } else {
            this.autoRouteCB.setSelected(this.autoRoute);
            this.autoRouteCB.setEnabled(true);
            this.db.fine("revalidateData(): multi node : AutoRoute " + this.autoRoute);
            if (!this.autoRoute) {
                this.urnCB.setSelected(false);
                this.urnCB.setEnabled(false);
                this.urn = false;
                this.rrbcCB.setSelected(false);
                this.rrbcCB.setEnabled(false);
                this.rrbc = false;
            }
        }
        if (!((NetVcatCircuit)this.getAbstractCktDlg().ckt).isSplitRoutingAllowed()) {
            this.independentFiberRB.setEnabled(false);
            this.commonFiberRB.setEnabled(false);
            this.commonFiberRB.setSelected(true);
            this.extendedBufferChBx.setVisible(false);
        } else {
            this.independentFiberRB.setEnabled(true);
            this.commonFiberRB.setEnabled(true);
            INetCircuitEnd iNetCircuitEnd = this.getAbstractCktDlg().getSource();
            try {
                IEntityModel iEntityModel = iNetCircuitEnd.getEntityModel();
                this.isFcmrPort = iEntityModel.getEqType() == 144;
                boolean bl = this.isCe1000Port = iEntityModel.getEqType() == 231;
                if (this.isFcmrPort || this.isCe1000Port) {
                    this.extendedBufferChBx.setVisible(true);
                    this.extendedBufferChBx.setEnabled(false);
                } else {
                    this.extendedBufferChBx.setVisible(false);
                }
            }
            catch (Exception exception) {
                this.db.println("Exception during FCMR port check; remaining false.");
                WzDiagDebug.printStackTrace((Throwable)exception);
            }
        }
        if (this.independentFiberRB.isSelected()) {
            this.diversePathAllCB.setEnabled(true);
        } else {
            this.diversePathAllCB.setEnabled(false);
            if (this.protectionCB.getItemCount() > 3) {
                this.protectionCB.removeItemAt(3);
            }
            if (this.protectAllCB.getItemCount() > 3) {
                this.protectAllCB.removeItemAt(3);
            }
        }
        this.memberCktList = ((NetVcatCircuit)this.getAbstractCktDlg().ckt).getAllMemberCircuits();
    }

    protected JComponent getStatusComponent() {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        String string = this.autoRouteCB.toString();
        arrayList.add(new String[]{"Routing: ", string});
        string = this.commonFiberRB.isSelected() ? "common fiber" : "split routed";
        arrayList.add(new String[]{"Type: ", string});
        return CcdVcatRoutePane.getGridPanel(arrayList);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        int n = -1;
        if (object == this.protectAllCB) {
            this.stopTableCellEditing();
            int n2 = this.protectAllCB.getSelectedIndex();
            boolean bl = false;
            if (protectionChoices[n2] == protectionChoices[0] && this.independentFiberRB.isSelected()) {
                bl = true;
            }
            for (int i = 0; i < this.tbModel.tabData.size(); ++i) {
                n = ((VcatMemberTableData)this.tbModel.tabData.get((int)i)).protectionType;
                this.tbModel.setValueAt(protectionChoices[n2], i, 2);
                if (n == 0) continue;
                if (bl) {
                    this.tbModel.setValueAt(this.nodeDiverseOptions[1], i, 3);
                    continue;
                }
                this.tbModel.setValueAt(this.nodeDiverseOptions[3], i, 3);
            }
            this.tbModel.fireTableDataChanged();
            this.driMemCount = protectionChoices[n2] == protectionChoices[3] ? this.tbModel.tabData.size() : 0;
        } else if (object == this.commonFiberRB && this.commonFiberRB.isSelected()) {
            this.stopTableCellEditing();
            for (int i = 0; i < this.tbModel.tabData.size(); ++i) {
                VcatMemberTableData vcatMemberTableData = (VcatMemberTableData)this.tbModel.tabData.get(i);
                n = vcatMemberTableData.protectionType;
                if (n == 0) {
                    vcatMemberTableData.protectionType = 6;
                } else if (n == 5) {
                    vcatMemberTableData.protectionType = 6;
                    --this.driMemCount;
                }
                vcatMemberTableData.nodeDiverseOption = 0;
            }
            this.tbModel.fireTableDataChanged();
            this.diversePathAllCB.setEnabled(false);
            if ((this.isFcmrPort || this.isCe1000Port) && this.extendedBufferChBx.isVisible()) {
                this.extendedBufferChBx.setSelected(false);
            }
            if (this.autoRouteCB.isSelected()) {
                this.updateUrnForDri();
            }
            if (this.protectionCB.getItemCount() > 3) {
                this.protectionCB.removeItemAt(3);
            }
            if (this.protectAllCB.getItemCount() > 3) {
                this.protectAllCB.removeItemAt(3);
            }
        } else if (object == this.independentFiberRB && this.independentFiberRB.isSelected()) {
            this.stopTableCellEditing();
            for (int i = 0; i < this.tbModel.tabData.size(); ++i) {
                VcatMemberTableData vcatMemberTableData = (VcatMemberTableData)this.tbModel.tabData.get(i);
                n = vcatMemberTableData.protectionType;
                if (n == 6) {
                    vcatMemberTableData.protectionType = 0;
                }
                vcatMemberTableData.nodeDiverseOption = 2;
            }
            this.tbModel.fireTableDataChanged();
            this.diversePathAllCB.setEnabled(true);
            if ((this.isFcmrPort || this.isCe1000Port) && this.extendedBufferChBx.isVisible()) {
                this.extendedBufferChBx.setSelected(true);
            }
            if (this.protectionCB.getItemCount() == 3) {
                this.protectionCB.addItem(protectionChoices[3]);
            }
            if (this.protectAllCB.getItemCount() == 3) {
                this.protectAllCB.addItem((Object)protectionChoices[3]);
            }
        } else if (object == this.diversePathAllCB) {
            this.stopTableCellEditing();
            int n3 = this.diversePathAllCB.getSelectedIndex();
            n = -1;
            for (int i = 0; i < this.tbModel.tabData.size(); ++i) {
                n = ((VcatMemberTableData)this.tbModel.tabData.get((int)i)).protectionType;
                if (n != 0) continue;
                this.tbModel.setValueAt(this.nodeDiverseOptions[n3], i, 3);
            }
            this.tbModel.fireTableDataChanged();
        }
    }

    private void checkWarningRequired() {
        Iterator iterator = this.tbModel.tabData.iterator();
        boolean bl = false;
        boolean bl2 = false;
        while (iterator.hasNext()) {
            VcatMemberTableData vcatMemberTableData = (VcatMemberTableData)iterator.next();
            if (this.commonFiberRB.isSelected() && !bl && vcatMemberTableData.protectionType == 6) {
                IgnorableDialog.infoDialog((Component)this, (String)FULLY_PROT_WARN_MSG, (String)VCAT_TITLE, (String)PREF_FULLY_PROT_VALUE, (String)PREF_FULLY_PROT_DESCR);
                bl = true;
            }
            if (bl2 || vcatMemberTableData.protectionType != 4) continue;
            IgnorableDialog.infoDialog((Component)this, (String)this.getAbstractCktDlg().getPcaWarningMsg(), (String)"PCA Circuit Creation", (String)"warnPca", (String)"CircuitCreation: PCA Circuits are unprotected");
            bl2 = true;
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object == this.autoRouteCB) {
            this.autoRoute = this.autoRouteCB.isSelected();
            if (!this.autoRoute) {
                this.urnCB.setSelected(false);
                this.rrbcCB.setSelected(false);
            }
            this.urnCB.setEnabled(this.autoRoute);
            this.rrbcCB.setEnabled(this.autoRoute);
            if (this.autoRoute && this.driMemCount > 0) {
                this.urnCB.setSelected(true);
                this.urnCB.setEnabled(false);
            }
            if (this.disableURN) {
                this.urnCB.setSelected(false);
                this.urnCB.setEnabled(false);
            }
            this.db.fine("stateChanged: autoRouteCB is " + this.autoRoute);
        } else if (object == this.urnCB) {
            this.urn = this.urnCB.isSelected();
        } else if (object == this.rrbcCB) {
            this.rrbc = this.rrbcCB.isSelected();
        }
        this.syncButtons();
    }

    protected void syncButtons() {
        boolean bl = !this.autoRouteCB.isSelected() || this.autoRouteCB.isSelected() && (this.getAbstractCktDlg().isLoCkt() || this.urnCB.isSelected() || this.rrbcCB.isSelected());
        this.getAbstractCktDlg().setNextEnabled(bl);
        this.getAbstractCktDlg().setFinishEnabled(!bl);
    }

    static String getProtectionString(int n) {
        switch (n) {
            case 0: 
            case 6: {
                return protectionChoices[0];
            }
            case 4: {
                return protectionChoices[1];
            }
            case 2: {
                return protectionChoices[2];
            }
            case 5: {
                return protectionChoices[3];
            }
        }
        return null;
    }

    protected int getProtectionInt(String string) {
        if (string.equals(protectionChoices[0])) {
            if (this.commonFiberRB.isSelected()) {
                return 6;
            }
            return 0;
        }
        if (string.equals(protectionChoices[1])) {
            return 4;
        }
        if (string.equals(protectionChoices[2])) {
            return 2;
        }
        if (string.equals(protectionChoices[3])) {
            return 5;
        }
        return -1;
    }

    public CSHelpID getHelpID() {
        return NetCSHelpConst.CcdVcatRoutePane;
    }

    protected void stopTableCellEditing() {
        if (this.table != null && this.table.getCellEditor() != null) {
            try {
                this.table.getCellEditor().stopCellEditing();
            }
            catch (Exception exception) {
                this.table.getCellEditor().cancelCellEditing();
            }
        }
    }

    public void removeListeners() {
        if (this.autoRouteCB != null) {
            this.autoRouteCB.removeChangeListener(this);
        }
        if (this.urnCB != null) {
            this.urnCB.removeChangeListener(this);
        }
        if (this.rrbcCB != null) {
            this.rrbcCB.removeChangeListener(this);
        }
        if (this.protectAllCB != null) {
            this.protectAllCB.removeActionListener((ActionListener)this);
        }
        if (this.diversePathAllCB != null) {
            this.diversePathAllCB.removeActionListener((ActionListener)this);
        }
        super.removeListeners();
    }

    public void dispose() {
        this.table = null;
        this.routePrefs = null;
        this.tbModel = null;
        if (this.vcatMemberPrefs != null) {
            this.vcatMemberPrefs.clear();
            this.vcatMemberPrefs = null;
        }
        super.dispose();
    }

    protected String getDiversityString(int n) {
        switch (n) {
            case 1: {
                return this.nodeDiverseOptions[0];
            }
            case 2: {
                return this.nodeDiverseOptions[1];
            }
            case 3: {
                return this.nodeDiverseOptions[2];
            }
            case 0: {
                return this.nodeDiverseOptions[3];
            }
        }
        return this.nodeDiverseOptions[3];
    }

    protected int getDiversityInt(String string) {
        if (string.equals(this.nodeDiverseOptions[0])) {
            return 1;
        }
        if (string.equals(this.nodeDiverseOptions[1])) {
            return 2;
        }
        if (string.equals(this.nodeDiverseOptions[2])) {
            return 3;
        }
        return 0;
    }

    public String getDiagString() {
        StringBuffer stringBuffer = new StringBuffer(super.getDiagString());
        stringBuffer.append("Route Prefs: " + this.routePrefs + "\n");
        if (this.routePrefs != null) {
            stringBuffer.append(this.routePrefs.prettyString());
        }
        stringBuffer.append("PCA: " + this.pca + "\n");
        stringBuffer.append("Path Protected: " + this.pathProt + "\n");
        stringBuffer.append("Review Route Before Creation: " + this.rrbc + "\n");
        stringBuffer.append("Use Required Nodes: " + this.urn + "\n");
        stringBuffer.append("Autoroute: " + this.autoRoute + "\n");
        stringBuffer.append("Common Fiber Routing: " + this.vcatCommonFiberRouting + "\n");
        stringBuffer.append("Member Prefs: " + this.vcatMemberPrefs + "\n");
        if (this.vcatMemberPrefs != null) {
            stringBuffer.append("Size= " + this.vcatMemberPrefs.size() + "\n");
            for (int i = 0; i < this.vcatMemberPrefs.size(); ++i) {
                stringBuffer.append("#" + (i + 1) + ": " + this.vcatMemberPrefs.get(i) + "\n");
            }
        }
        return stringBuffer.toString();
    }

    void updateUrnForDri() {
        if (this.driMemCount > 0) {
            this.urnCB.setSelected(true);
            this.urnCB.setEnabled(false);
        } else {
            this.urnCB.setSelected(false);
            this.urnCB.setEnabled(true);
        }
    }

    class MemTableModel
    extends AbstractTableModel {
        final String[] columnNames = new String[]{"Number", " Name ", "  Protection  ", "Node-Diverse Path"};
        ArrayList tabData = new ArrayList();

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.tabData.size();
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public Object getValueAt(int n, int n2) {
            if (this.tabData.size() == 0) {
                return null;
            }
            Object[] objectArray = this.tabData.toArray();
            switch (n2) {
                case 0: {
                    return ((VcatMemberTableData)objectArray[n]).memberNumber;
                }
                case 1: {
                    return ((VcatMemberTableData)objectArray[n]).memberName;
                }
                case 2: {
                    return CcdVcatRoutePane.getProtectionString(((VcatMemberTableData)objectArray[n]).protectionType);
                }
                case 3: {
                    return CcdVcatRoutePane.this.getDiversityString(((VcatMemberTableData)objectArray[n]).nodeDiverseOption);
                }
            }
            return null;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n >= this.tabData.size()) {
                return;
            }
            VcatMemberTableData vcatMemberTableData = (VcatMemberTableData)this.tabData.get(n);
            switch (n2) {
                case 0: {
                    vcatMemberTableData.memberNumber = (Integer)object;
                    this.tabData.set(n, vcatMemberTableData);
                    break;
                }
                case 1: {
                    vcatMemberTableData.memberName = (String)object;
                    this.tabData.set(n, vcatMemberTableData);
                    break;
                }
                case 2: {
                    int n3 = vcatMemberTableData.protectionType;
                    vcatMemberTableData.protectionType = CcdVcatRoutePane.this.getProtectionInt((String)object);
                    if (vcatMemberTableData.protectionType == 0) {
                        this.setValueAt(CcdVcatRoutePane.this.nodeDiverseOptions[1], n, 3);
                    } else {
                        this.setValueAt(CcdVcatRoutePane.this.nodeDiverseOptions[3], n, 3);
                    }
                    if (n3 != vcatMemberTableData.protectionType) {
                        if (n3 == 5) {
                            --CcdVcatRoutePane.this.driMemCount;
                            if (CcdVcatRoutePane.this.autoRouteCB.isSelected()) {
                                CcdVcatRoutePane.this.updateUrnForDri();
                            }
                        } else if (vcatMemberTableData.protectionType == 5) {
                            ++CcdVcatRoutePane.this.driMemCount;
                            if (CcdVcatRoutePane.this.autoRouteCB.isSelected()) {
                                CcdVcatRoutePane.this.updateUrnForDri();
                            }
                        }
                    }
                    this.tabData.set(n, vcatMemberTableData);
                    break;
                }
                case 3: {
                    vcatMemberTableData.nodeDiverseOption = CcdVcatRoutePane.this.getDiversityInt((String)object);
                    this.tabData.set(n, vcatMemberTableData);
                }
            }
            this.fireTableCellUpdated(n, n2);
        }

        public boolean isCellEditable(int n, int n2) {
            if (n2 == 3) {
                if (CcdVcatRoutePane.this.commonFiberRB.isSelected()) {
                    return false;
                }
                Object[] objectArray = this.tabData.toArray();
                int n3 = ((VcatMemberTableData)objectArray[n]).protectionType;
                return n3 == 6 || n3 == 0;
            }
            return true;
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return class$java$lang$Integer == null ? (class$java$lang$Integer = CcdVcatRoutePane.class$("java.lang.Integer")) : class$java$lang$Integer;
                }
                case 1: {
                    return class$java$lang$String == null ? (class$java$lang$String = CcdVcatRoutePane.class$("java.lang.String")) : class$java$lang$String;
                }
                case 2: {
                    return class$java$lang$String == null ? (class$java$lang$String = CcdVcatRoutePane.class$("java.lang.String")) : class$java$lang$String;
                }
                case 3: {
                    return class$java$lang$String == null ? (class$java$lang$String = CcdVcatRoutePane.class$("java.lang.String")) : class$java$lang$String;
                }
            }
            return class$java$lang$Object == null ? (class$java$lang$Object = CcdVcatRoutePane.class$("java.lang.Object")) : class$java$lang$Object;
        }
    }
}

