/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.loader.ElementFactoryFinder;
import cerent.cms.model.CircuitType;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.ObjNotFound;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ui.IEntityCellRenderer;
import cerent.cms.ui.circuits.AbstractCircuitDialog;
import cerent.cms.ui.circuits.CcdConversionCktPane;
import cerent.cms.ui.circuits.CircuitEndCellRenderer;
import cerent.util.AnnotatedException;
import cerent.util.ComparisonUtil;
import cerent.util.ErrorMsg;
import cerent.util.HoLoComparator;
import cerent.util.IHoNum;
import cerent.util.NEMC;
import cerent.util.SDebug;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class CcdXmPortsSelectionPanel
extends JPanel
implements ActionListener {
    protected String[] ds3MappedStsHalves = new String[]{"Circuit Source", "Circuit Dest"};
    protected INetCircuitEnd ds3MappedStsEndpoint;
    protected INetCircuitEnd vtMappedStsEndpoint;
    protected JLabel slotLB;
    protected JLabel ds3StsLB;
    protected JComboBox slotCB;
    protected JComboBox ds3StsCB;
    protected List hoParts = new ArrayList();
    protected IHoNum hoNum;
    protected String slot;
    protected SortablePortString port1;
    protected SortablePortString port2;
    protected INodeModel node;
    protected static int CIRCUIT_NULL_CHOICE = -1;
    protected static int CIRCUIT_SOURCE = 0;
    protected static int CIRCUIT_DEST = 1;
    protected int ds3Sts = CIRCUIT_SOURCE;
    protected SortedMap entityMap;
    protected SortedMap endpointMap;
    protected SortedMap portMap;
    protected CcdConversionCktPane parent;
    protected String title;
    protected GridBagLayout gbl = new GridBagLayout();
    protected GridBagConstraints gbc = new GridBagConstraints();
    protected SortedMap remainingPortsMap = new TreeMap();
    protected static final SDebug db = new SDebug("CcdXmPortsSelectionPanel");

    public CcdXmPortsSelectionPanel(String string, AbstractCircuitDialog abstractCircuitDialog, CcdConversionCktPane ccdConversionCktPane) {
        this.setName(string);
        if (db.on()) {
            db.println(string + "<init>");
        }
        this.parent = ccdConversionCktPane;
        if (string != null) {
            this.setBorder(BorderFactory.createTitledBorder(string));
        }
        this.title = string;
        this.gbl.setConstraints(this, this.gbc);
        this.setLayout(this.gbl);
        this.gbc.fill = 1;
        this.gbc.insets = new Insets(1, 1, 1, 1);
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.gridwidth = 0;
        this.gbc.gridheight = 1;
        this.slotLB = new JLabel("          Slot: ", 4);
        this.slotCB = this.addCB(this.slotLB, "slotCB", this.gbc);
        this.ds3StsLB = new JLabel("DS3 Mapped STS: ", 4);
        this.ds3StsCB = this.addCB(this.ds3StsLB, "ds3StsCB", this.ds3MappedStsHalves, this.gbc);
        this.reset();
    }

    protected void reset() {
        if (db.on()) {
            db.println(this.title + " reset");
        }
        this.vtMappedStsEndpoint = new NetCircuitEnd();
        this.ds3MappedStsEndpoint = new NetCircuitEnd();
        this.slot = null;
        this.port1 = null;
        this.port2 = null;
        this.hoNum = null;
        this.resetComponents();
    }

    protected void resetComponents() {
        this.setCBList(this.slotCB, null);
        this.ds3StsCB.setSelectedIndex(CIRCUIT_NULL_CHOICE);
    }

    protected JComboBox addCB(String string, String string2, GridBagConstraints gridBagConstraints) {
        JComboBox jComboBox = new JComboBox();
        jComboBox.setName(string2);
        jComboBox.addActionListener(this);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 1;
        this.add(jComboBox, gridBagConstraints);
        ++gridBagConstraints.gridy;
        return jComboBox;
    }

    protected JComboBox addCB(JLabel jLabel, String string, GridBagConstraints gridBagConstraints) {
        JComboBox jComboBox = new JComboBox();
        jComboBox.setName(string);
        jComboBox.addActionListener(this);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 1;
        this.add(jComboBox, gridBagConstraints);
        ++gridBagConstraints.gridy;
        return jComboBox;
    }

    protected JComboBox addCB(JLabel jLabel, String string, String[] stringArray, GridBagConstraints gridBagConstraints) {
        JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        jComboBox.setName(string);
        jComboBox.addActionListener(this);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 1;
        this.add(jComboBox, gridBagConstraints);
        ++gridBagConstraints.gridy;
        return jComboBox;
    }

    void setNode(INodeModel iNodeModel) {
        this.node = iNodeModel;
        if (this.vtMappedStsEndpoint.getNodeModel() != iNodeModel || this.ds3MappedStsEndpoint.getNodeModel() != iNodeModel) {
            this.vtMappedStsEndpoint.setNodeModel(iNodeModel);
            this.ds3MappedStsEndpoint.setNodeModel(iNodeModel);
            this.refresh();
        }
    }

    private String getSlotString(IEntityModel iEntityModel) {
        IModuleModel iModuleModel = iEntityModel.getModuleModel();
        IEntityCellRenderer iEntityCellRenderer = ElementFactoryFinder.getElementFactory(this.node).createEntityCellRenderer(iModuleModel);
        return iEntityCellRenderer.getString((Object)iModuleModel, null);
    }

    public void validatePage() throws Exception {
        this.debugEndpoint(this.title + " validatePage: ");
        if (!this.fullySelected()) {
            throw new Exception(this.getName() + " is not fully specified");
        }
        if (db.on()) {
            db.println(this.title + " validatePage: endpoint OK");
        }
    }

    protected boolean fullySelected() {
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = true;
        boolean bl5 = true;
        if (this.slot == null) {
            bl2 = false;
        }
        if (this.hoNum == null) {
            bl = false;
        }
        if (this.port1 == null || this.port2 == null) {
            bl3 = false;
        }
        if (this.slotCB.isEnabled() && this.slotCB.getSelectedIndex() < 0) {
            bl4 = false;
        }
        if (this.ds3StsCB.isEnabled() && this.ds3StsCB.getSelectedIndex() < 0) {
            bl5 = false;
        }
        return bl && bl2 && bl3 && bl4 && bl5;
    }

    protected String getStatusText() {
        return this.slot == "Ethergroup" ? this.slot : CircuitEndCellRenderer.asSlashSeparatedString(this.vtMappedStsEndpoint);
    }

    public void refresh() {
        if (db.on()) {
            db.println(this.title + " refresh");
        }
        this.debugEndpoint(this.title + " refresh: ");
        ICircuitType iCircuitType = CircuitType.getCircuitType((int)this.parent.circuitInfo.type());
        this.vtMappedStsEndpoint.setLoNum(null);
        INodeModel iNodeModel = this.vtMappedStsEndpoint.getNodeModel();
        if (iNodeModel != null) {
            this.getDropPorts();
            TreeSet treeSet = new TreeSet(this.entityMap.keySet());
            Iterator iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (string.indexOf("DS3XM12") == -1) {
                    iterator.remove();
                    continue;
                }
                SortedMap sortedMap = (SortedMap)this.entityMap.get(string);
                IEntityModel iEntityModel = (IEntityModel)sortedMap.get(sortedMap.firstKey());
                IModuleModel iModuleModel = iEntityModel.getModuleModel();
                if (!this.matchMms(iNodeModel, iModuleModel, this.parent.getAbstractCktDlg().getSource()) && !this.matchMms(iNodeModel, iModuleModel, this.parent.getAbstractCktDlg().getAltSource()) && !this.matchMms(iNodeModel, iModuleModel, this.parent.getAbstractCktDlg().getDest()) && !this.matchMms(iNodeModel, iModuleModel, this.parent.getAbstractCktDlg().getAltDest())) continue;
                if (db.on()) {
                    db.println("removing " + string + " because " + "it is a source or destination slot.");
                }
                iterator.remove();
            }
            this.setCBList(this.slotCB, treeSet);
            if (this.slot == null && this.entityMap.keySet().size() == 1) {
                this.slot = (String)this.entityMap.keySet().iterator().next();
            }
            if (this.slot != null) {
                this.slotCB.setSelectedItem(this.slot);
                this.ds3StsCB.setSelectedIndex(CIRCUIT_NULL_CHOICE);
            }
            this.ds3Sts = CIRCUIT_NULL_CHOICE;
            boolean bl = false;
            try {
                if (this.parent.getAbstractCktDlg().getCircuitType() == 7 || this.parent.getAbstractCktDlg().getSource().getEntityModel().getEqType() == 32 || this.parent.getAbstractCktDlg().getDest().getEntityModel().getEqType() == 33) {
                    this.ds3Sts = CIRCUIT_SOURCE;
                    bl = true;
                } else if (this.parent.getAbstractCktDlg().getSource().getEntityModel().getEqType() == 33 || this.parent.getAbstractCktDlg().getDest().getEntityModel().getEqType() == 32) {
                    this.ds3Sts = CIRCUIT_DEST;
                    bl = true;
                }
            }
            catch (ObjNotFound objNotFound) {
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.ds3StsCB.setEnabled(!bl);
            this.ds3StsCB.setSelectedIndex(this.ds3Sts);
        } else {
            this.setCBList(this.slotCB, null);
            this.ds3StsCB.setSelectedIndex(CIRCUIT_NULL_CHOICE);
        }
    }

    private boolean matchMms(INodeModel iNodeModel, IModuleModel iModuleModel, INetCircuitEnd iNetCircuitEnd) {
        INodeModel iNodeModel2;
        boolean bl = false;
        if (iNetCircuitEnd != null && iNodeModel == (iNodeModel2 = iNetCircuitEnd.getNodeModel())) {
            try {
                IEntityModel iEntityModel = iNetCircuitEnd.getEntityModel();
                IModuleModel iModuleModel2 = iEntityModel.getModuleModel();
                if (iModuleModel == iModuleModel2) {
                    bl = true;
                }
            }
            catch (ObjNotFound objNotFound) {
                SDebug.printStackTrace((Throwable)objNotFound);
            }
        }
        return bl;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.slotCB) {
            String string = (String)this.slotCB.getSelectedItem();
            if (this.isNull(string, "newSlot")) {
                return;
            }
            if (db.on()) {
                db.println(this.title + " actionPerformed: slot " + this.slot + " -> " + string);
            }
            this.slot = string;
            this.portMap = (SortedMap)this.entityMap.get(this.slot);
            if (this.portMap.size() == 0) {
                if (db.on()) {
                    db.println(this.title + " portMap is empty");
                }
                return;
            }
            TreeSet treeSet = new TreeSet(this.portMap.keySet());
            this.port1 = null;
            this.port2 = null;
            this.remainingPortsMap = new TreeMap();
            Iterator iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                SortablePortString sortablePortString = (SortablePortString)iterator.next();
                int n = sortablePortString.toPortNum();
                if (n <= 12) continue;
                if (this.port1 == null) {
                    if (n % 2 == 1) {
                        this.port1 = sortablePortString;
                    }
                } else if (n == this.port1.toPortNum() + 1) {
                    this.port2 = sortablePortString;
                }
                if (sortablePortString == this.port1 || sortablePortString == this.port2) continue;
                this.remainingPortsMap.put(new Integer(n), sortablePortString.getEntityModel());
            }
            if (this.isNull(this.port1, "port1") || this.isNull(this.port2, "port2")) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)new Exception());
                }
                this.parent.setFinishedEnabled(false);
                return;
            }
            try {
                this.setEntity((IEntityModel)this.portMap.get(this.port1), (IEntityModel)this.portMap.get(this.port2));
            }
            catch (AnnotatedException annotatedException) {
                if (db.on()) {
                    db.println(this.title + " actionPerformed(portCB): exception in setEntity");
                }
                this.clearEntity(annotatedException, false);
            }
        } else if (object == this.ds3StsCB) {
            this.ds3Sts = this.ds3StsCB.getSelectedIndex();
        }
    }

    protected void clearEntity(final AnnotatedException annotatedException, final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (CcdXmPortsSelectionPanel.this.port1 != null || CcdXmPortsSelectionPanel.this.port2 != null || bl && CcdXmPortsSelectionPanel.this.slot != null) {
                    if (bl) {
                        CcdXmPortsSelectionPanel.this.slot = null;
                        if (db.on()) {
                            db.println(CcdXmPortsSelectionPanel.this.title + " Runnable: clearing slotCB");
                        }
                        CcdXmPortsSelectionPanel.this.slotCB.setSelectedItem(null);
                        if (db.on()) {
                            db.println(CcdXmPortsSelectionPanel.this.title + " Runnable: emptying portCB");
                        }
                        CcdXmPortsSelectionPanel.this.ds3StsCB.setSelectedIndex(CIRCUIT_NULL_CHOICE);
                    }
                    CcdXmPortsSelectionPanel.this.port1 = null;
                    CcdXmPortsSelectionPanel.this.port2 = null;
                    if (db.on()) {
                        db.println(CcdXmPortsSelectionPanel.this.title + " Runnable: clearing portCB");
                    }
                    CcdXmPortsSelectionPanel.this.ds3StsCB.setSelectedIndex(CIRCUIT_NULL_CHOICE);
                    ErrorMsg.displayDetailed((Component)CcdXmPortsSelectionPanel.this, NEMC.EID_ENDPOINT_SELECTION_ERROR, annotatedException.toString());
                    CcdXmPortsSelectionPanel.this.repaint();
                }
            }
        });
    }

    private void getDropPorts() {
        this.slot = null;
        this.port1 = null;
        IEntityModel iEntityModel = this.getEntityModel(this.vtMappedStsEndpoint);
        int n = iEntityModel != null ? iEntityModel.getEqType() : -1;
        IEntityModel iEntityModel2 = null;
        List list = null;
        list = this.parent.availPorts;
        this.entityMap = new TreeMap();
        int n2 = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TreeMap<SortablePortString, IEntityModel> treeMap;
            SortablePortString sortablePortString;
            IModuleModel iModuleModel;
            ++n2;
            IEntityModel iEntityModel3 = (IEntityModel)iterator.next();
            if (iEntityModel3 == null) {
                if (!db.on()) continue;
                db.println(this.title + " getDropPorts: null entity returned from getAvailDropPorts");
                continue;
            }
            if (iEntityModel3.getGenericClass() == 7) {
                iModuleModel = iEntityModel3.getModuleModel();
                sortablePortString = new SortablePortString(iEntityModel3);
            } else if (iEntityModel3.getGenericClass() == 6) {
                iModuleModel = (IModuleModel)iEntityModel3;
                sortablePortString = new SortablePortString();
            } else {
                if (!db.on()) continue;
                db.println(this.title + " getDropPorts: unexpected entity: " + iEntityModel3);
                continue;
            }
            String string = this.getSlotString(iEntityModel3);
            if (iEntityModel3.equals(iEntityModel)) {
                this.slot = string;
                if (iEntityModel3.getGenericClass() == 7) {
                    this.port1 = new SortablePortString(iEntityModel3);
                }
            } else if (iEntityModel2 == null && iEntityModel3 != null && iEntityModel3.getEqType() == n && iEntityModel3.getIndex() == iEntityModel.getIndex() + 1) {
                iEntityModel2 = iEntityModel3;
            }
            if ((treeMap = (TreeMap<SortablePortString, IEntityModel>)this.entityMap.get(string)) == null) {
                treeMap = new TreeMap<SortablePortString, IEntityModel>();
                this.entityMap.put(string, treeMap);
            }
            if (treeMap.put(sortablePortString, iEntityModel3) == null || !db.on()) continue;
            db.println(this.title + " getDropPorts: multiple entities with " + "slot = " + string + ", port1 = " + sortablePortString);
        }
        if (this.slot == null && iEntityModel2 != null) {
            this.slot = this.getSlotString(iEntityModel2);
            if (iEntityModel2.getGenericClass() == 7) {
                this.port1 = new SortablePortString(iEntityModel2);
            }
        }
    }

    protected void setEntity(IEntityModel iEntityModel, IEntityModel iEntityModel2) throws AnnotatedException {
        db.info(this.title + " setEntity: slot = " + this.slot + ", port1 = " + this.port1 + ", port2 = " + this.port2);
        if (!iEntityModel.equals(this.getEntityModel(this.vtMappedStsEndpoint))) {
            this.vtMappedStsEndpoint.setEntityIndex(iEntityModel.getEntityIndex());
            this.vtMappedStsEndpoint.setHoNum(null);
            this.vtMappedStsEndpoint.setLoNum(null);
        }
        if (!iEntityModel2.equals(this.getEntityModel(this.ds3MappedStsEndpoint))) {
            this.ds3MappedStsEndpoint.setEntityIndex(iEntityModel2.getEntityIndex());
            this.ds3MappedStsEndpoint.setHoNum(null);
            this.ds3MappedStsEndpoint.setLoNum(null);
        }
        this.hoNum = null;
        this.getDropPoints();
        IHoNum iHoNum = (IHoNum)this.endpointMap.firstKey();
        if (this.isNull(iHoNum, "newSts")) {
            return;
        }
        this.hoNum = iHoNum;
        IHoNum iHoNum2 = CircuitEndCellRenderer.convertFromExternalHoNumber((IEntityModel)this.portMap.get(this.port1), this.hoNum);
        this.vtMappedStsEndpoint.setHoNum(iHoNum2);
        iHoNum2 = CircuitEndCellRenderer.convertFromExternalHoNumber((IEntityModel)this.portMap.get(this.port2), this.hoNum);
        this.ds3MappedStsEndpoint.setHoNum(iHoNum2);
    }

    protected void getDropPoints() throws AnnotatedException {
        List list;
        try {
            list = this.parent.getCircuit() != null ? this.parent.getCircuit().getAvailDropPoints(this.vtMappedStsEndpoint.getNodeModel(), this.getEntityModel(this.vtMappedStsEndpoint)) : NetCircuitManager.instance().getAvailSourcePoints(this.vtMappedStsEndpoint.getNodeModel(), this.getEntityModel(this.vtMappedStsEndpoint), this.parent.circuitInfo);
        }
        catch (Exception exception) {
            throw new AnnotatedException("Failure getting list of available drop points from " + this.vtMappedStsEndpoint.getNodeModel().getName(), exception);
        }
        this.endpointMap = new TreeMap();
        if (this.isNull(list, "availDropPoints")) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IEntityModel iEntityModel;
            INetCircuitEnd iNetCircuitEnd = (INetCircuitEnd)iterator.next();
            if (iNetCircuitEnd == null) {
                if (!db.on()) continue;
                db.println(this.title + " getDropPoints: null entity returned from getAvailDropPorts");
                continue;
            }
            try {
                iEntityModel = iNetCircuitEnd.getEntityModel();
            }
            catch (ObjNotFound objNotFound) {
                iEntityModel = null;
            }
            IHoNum iHoNum = CircuitEndCellRenderer.convertToExternalHoNumber(iEntityModel, iNetCircuitEnd.getHoNum());
            if (HoLoComparator.instance().isEqual(iNetCircuitEnd.getHoNum(), this.vtMappedStsEndpoint.getHoNum()) && this.hoNum == null) {
                this.hoNum = iHoNum;
            }
            INetCircuitEnd iNetCircuitEnd2 = this.endpointMap.put(iHoNum, iNetCircuitEnd);
        }
    }

    protected void setCBList(List list, Collection collection) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof JComboBox)) continue;
            this.setCBList((JComboBox)e, collection);
        }
    }

    protected void setCBList(JComboBox jComboBox, Collection collection) {
        jComboBox.removeActionListener(this);
        if (collection != null) {
            Object[] objectArray = collection.toArray();
            if (db.on()) {
                db.println(this.title + " setCBList: " + jComboBox.getName() + " choices: " + ((AbstractCollection)collection).toString());
            }
            jComboBox.setModel(new DefaultComboBoxModel<Object>(objectArray));
        }
        if (collection == null || collection.isEmpty()) {
            if (db.on()) {
                db.println(this.title + " setCBList: disabling " + jComboBox.getName());
            }
            jComboBox.setEnabled(false);
        } else {
            jComboBox.setEnabled(true);
            jComboBox.addActionListener(this);
        }
        jComboBox.setSelectedItem(null);
    }

    protected IEntityModel getEntityModel(INetCircuitEnd iNetCircuitEnd) {
        IEntityModel iEntityModel;
        block2: {
            iEntityModel = null;
            try {
                iEntityModel = iNetCircuitEnd.getEntityModel();
            }
            catch (ObjNotFound objNotFound) {
                if (!db.on()) break block2;
                db.println("Can't find the entity model");
            }
        }
        return iEntityModel;
    }

    protected void debugEndpoint(String string) {
        if (db.on()) {
            db.println(string + "vtMappedStsEndpoint.node = " + this.vtMappedStsEndpoint.getNodeModel());
            db.println(string + "vtMappedStsEndpoint.entity = " + this.getEntityModel(this.vtMappedStsEndpoint));
            db.println(string + "ds3MappedStsEndpoint.node = " + this.ds3MappedStsEndpoint.getNodeModel());
            db.println(string + "ds3MappedStsEndpoint.entity = " + this.getEntityModel(this.ds3MappedStsEndpoint));
            db.println(string + "slot = " + this.slot);
            db.println(string + "port1 = " + this.port1);
            db.println(string + "port2 = " + this.port2);
            db.println(string + "vtMappedStsEndpoint.hoNum = " + this.vtMappedStsEndpoint.getHoNum());
            db.println(string + "ds3MappedStsEndpoint.hoNum = " + this.ds3MappedStsEndpoint.getHoNum());
        }
        if (db.on() && this.hoNum != null) {
            db.println(string + "sts = " + this.hoNum.toString());
        }
    }

    protected boolean isNull(Object object, String string) {
        if (object == null) {
            if (db.on()) {
                db.println(this.title + " " + string + " is null");
            }
            return true;
        }
        return false;
    }

    public void close() {
        this.slotCB.hidePopup();
        this.ds3StsCB.hidePopup();
    }

    public void recycle() {
        if (this.endpointMap != null) {
            this.endpointMap.clear();
        }
        if (this.entityMap != null) {
            this.entityMap.clear();
        }
        if (this.portMap != null) {
            this.portMap.clear();
        }
        this.vtMappedStsEndpoint = null;
        if (this.slotCB != null) {
            this.slotCB.removeActionListener(this);
        }
        this.ds3StsCB.removeActionListener(this);
        this.port1 = null;
        this.port2 = null;
        this.parent = null;
        this.hoNum = null;
        this.removeAll();
    }

    public INetCircuitEnd[] getXmCircuitEnds() {
        INetCircuitEnd[] iNetCircuitEndArray = new INetCircuitEnd[2];
        if (this.vtMappedStsEndpoint == null || this.ds3MappedStsEndpoint == null) {
            return null;
        }
        if (this.ds3Sts == 1) {
            iNetCircuitEndArray[0] = this.vtMappedStsEndpoint;
            iNetCircuitEndArray[1] = this.ds3MappedStsEndpoint;
        } else {
            iNetCircuitEndArray[0] = this.ds3MappedStsEndpoint;
            iNetCircuitEndArray[1] = this.vtMappedStsEndpoint;
        }
        return iNetCircuitEndArray;
    }

    int getDs3Sts() {
        return this.ds3Sts;
    }

    List getVtAndDs3MappedList() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.remainingPortsMap.keySet().iterator();
        while (iterator.hasNext()) {
            Object v;
            Integer n = (Integer)iterator.next();
            int n2 = n;
            if (n2 % 2 == 0) {
                if (!this.remainingPortsMap.containsKey(new Integer(n2 - 1))) continue;
                v = this.remainingPortsMap.get(n);
                arrayList.add(v);
                continue;
            }
            if (!this.remainingPortsMap.containsKey(new Integer(n2 + 1))) continue;
            v = this.remainingPortsMap.get(n);
            arrayList.add(v);
        }
        if (db.on()) {
            for (int i = 0; i < arrayList.size(); ++i) {
                db.println("Acceptable Port List #" + i + "= " + arrayList.get(i));
            }
        }
        return arrayList;
    }

    INodeModel getMappedNodeModel() {
        return this.vtMappedStsEndpoint.getNodeModel();
    }

    protected class SortablePortString
    implements Comparable {
        int entityIndex;
        IEntityModel iem;
        String sortablePort = "";
        String port;
        int portNum;

        public IEntityModel getEntityModel() {
            return this.iem;
        }

        SortablePortString(IEntityModel iEntityModel) {
            this.iem = iEntityModel;
            this.entityIndex = iEntityModel.getEntityIndex();
            if (iEntityModel.getGenericClass() == 7) {
                this.sortablePort = CircuitEndCellRenderer.getPortString(iEntityModel, false);
                this.port = CircuitEndCellRenderer.getPortString(iEntityModel, true);
                int[] nArray = ((IPortModel)iEntityModel).getPortNum();
                this.portNum = nArray == null || nArray.length != 1 ? 0 : nArray[0];
            }
        }

        SortablePortString() {
            this.entityIndex = 0;
            this.sortablePort = "";
            this.port = "";
            this.portNum = 0;
        }

        public boolean equals(Object object) {
            return object instanceof SortablePortString && ((SortablePortString)object).port.equals(this.port);
        }

        public String toSortableString() {
            return this.sortablePort;
        }

        public String toString() {
            return this.port;
        }

        public int toPortNum() {
            return this.portNum;
        }

        public int compareTo(Object object) {
            if (object instanceof SortablePortString) {
                SortablePortString sortablePortString = (SortablePortString)object;
                return ComparisonUtil.compare((int)this.entityIndex, (int)sortablePortString.entityIndex);
            }
            return 1;
        }

        boolean isEmpty() {
            return this.port == "";
        }
    }
}

