/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.ICircuitType;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.circuits.NetCircuitModel;
import cerent.cms.model.circuits.NetCircuitNodeDataSource;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.NetVcatCircuit;
import cerent.cms.ui.NetworkDefaults;
import cerent.cms.ui.NetworkProvPane;
import cerent.cms.ui.circuits.AdminStatePanel;
import cerent.cms.ui.circuits.CcdOCHNCAttrsPane;
import cerent.cms.ui.circuits.CcdOCHTrailAttrsPane;
import cerent.cms.ui.circuits.CircuitEditTabbedView;
import cerent.cms.ui.circuits.IAdminStatePanel;
import cerent.cms.ui.circuits.NetCircuitNodeColumnRenderer;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import cerent.util.gui.row.RowDataSource;
import cerent.util.gui.row.RowTableModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observer;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.table.TableModel;

public class CedCircuitStatePane
extends NetworkProvPane
implements ActionListener {
    private INetCircuit ckt;
    private JLabel statusLabel;
    private JLabel serviceStateLabel;
    private IAdminStatePanel adminStatePanel;
    RowTableModel model;
    NetCircuitNodeDataSource source;
    private static final SDebug db = new SDebug("CedCircuitStatePane");

    public CedCircuitStatePane(String string, CircuitEditTabbedView circuitEditTabbedView) {
        super(string, circuitEditTabbedView);
        NetCircuitModel netCircuitModel = (NetCircuitModel)circuitEditTabbedView.getUiModel();
        this.ckt = netCircuitModel.getNetCircuit();
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
        this.source = new NetCircuitNodeDataSource(this.ckt);
        this.model = new RowTableModel((RowDataSource)this.source, NetCircuitNodeColumnRenderer.createTableRenderers(0));
        this.table = new UTable((TableModel)this.model);
        this.model.initTable(this.table);
        this.table.setRowSelectionAllowed(false);
        JPanel jPanel = CedCircuitStatePane.createVerticalPanel(null);
        jPanel.add(this.getStateStatusPanel());
        JPanel jPanel2 = CedCircuitStatePane.createVerticalPanel("Cross-Connections");
        jPanel2.add((Component)new UScrollPane((Component)this.table));
        jPanel.add(jPanel2);
        this.add(jPanel, "Center");
        this.ckt.addObserver((Observer)((Object)this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (db.on()) {
            db.println("dispose");
        }
        this.model.release();
        this.model = null;
        this.source.dispose();
        this.source = null;
        CedCircuitStatePane cedCircuitStatePane = this;
        synchronized (cedCircuitStatePane) {
            this.ckt.deleteObserver((Observer)((Object)this));
            this.ckt = null;
        }
        super.destroy();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.adminStatePanel.getActionEventSource())) {
            this.setDirty(this.adminStatePanel.isDirty());
        }
    }

    public void applyChangesToModel() throws Exception {
        db.info("applyChangesToModel: start");
        Preferences.instance().setBoolean("ctc.circuit.creation", "applyDropPorts", this.adminStatePanel.getApplyDropPorts());
        this.adminStatePanel.applyToCircuit(this.ckt);
        db.info("applyChangesToModel: finish");
    }

    public synchronized void refreshFromModel() throws Exception {
        if (db.on()) {
            db.println("refreshFromModel: start");
        }
        if (this.ckt == null) {
            return;
        }
        this.adminStatePanel.setAdminState(-2);
        if (this.ckt.getCircuitTypeObj().isVcatCircuitType()) {
            int n = ((NetVcatCircuit)this.ckt).getAllMemberCircuits().size();
            this.adminStatePanel.setEnabled(this.ckt, this.isUserAuthorized() && n != 0);
        } else {
            this.adminStatePanel.setEnabled(this.ckt, this.isUserAuthorized());
        }
        this.statusLabel.setText("Circuit Status: " + NetworkDefaults.circuitStateToString(this.ckt.getState()));
        this.serviceStateLabel.setText("Circuit Service State: " + NetworkDefaults.circuitServiceStateToString(this.ckt.getServiceState()));
        if (db.on()) {
            db.println("refreshFromModel: finish");
        }
    }

    private JPanel getStateStatusPanel() {
        JPanel jPanel = CedCircuitStatePane.createHorizontalPanel(null);
        JPanel jPanel2 = CedCircuitStatePane.createVerticalPanel(null);
        this.statusLabel = new JLabel("Circuit Status:");
        jPanel2.add(this.statusLabel);
        jPanel2.add(Box.createVerticalStrut(5));
        this.serviceStateLabel = new JLabel("Circuit Service State: ");
        jPanel2.add(this.serviceStateLabel);
        jPanel.add(jPanel2);
        jPanel.add(Box.createHorizontalGlue());
        db.info(this.ckt.getCircuitName() + " " + this.ckt.isMonitorCircuit());
        this.adminStatePanel = this.getAdminStatePanel();
        jPanel.add(this.adminStatePanel.getPanel());
        if (this.ckt.isMemberOfVcat()) {
            this.adminStatePanel.setApplyDropPortsApplicable(false);
        }
        this.adminStatePanel.setEnabled(this.ckt, this.isUserAuthorized());
        this.adminStatePanel.registerActionListener(this);
        this.adminStatePanel.setApplyDropPorts(Preferences.instance().getBoolean("ctc.circuit.creation", "applyDropPorts", false));
        return jPanel;
    }

    private IAdminStatePanel getAdminStatePanel() {
        ICircuitType iCircuitType = this.ckt.getCircuitTypeObj();
        if (iCircuitType.isOchncType() || iCircuitType.isOchTrailTunnelCircuitType()) {
            return new CcdOCHNCAttrsPane.OchncAdminStatePanel(true);
        }
        if (iCircuitType.isOchccCircuitType()) {
            return new CcdOCHTrailAttrsPane.OchTrailAdminStatePanel(true);
        }
        return new AdminStatePanel(null, this.ckt, true);
    }
}

