/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.NetServiceState;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.VcatNotReconfigurable;
import cerent.cms.model.circuits.NetCircuitModel;
import cerent.cms.model.circuits.VcatMemberCktDataSource;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetVcatTermination;
import cerent.cms.ncp.NetVcatCircuit;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.circuits.AddVcatMembersDialog;
import cerent.cms.ui.circuits.CircuitColumnRenderer;
import cerent.cms.ui.circuits.CircuitEditDialog;
import cerent.cms.ui.circuits.CircuitEditTabbedView;
import cerent.cms.ui.circuits.CircuitMapUtil;
import cerent.cms.ui.circuits.CircuitsByNameTable;
import cerent.cms.ui.circuits.CircuitsTableModel;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.EventMaskUtil;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.IgnorableDialog;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.row.ColumnRenderer;
import cerent.util.gui.row.RowDataSource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CedVcatMembersPane
extends AbstractPane
implements ActionListener,
ListSelectionListener,
MouseListener {
    private CircuitEditTabbedView parent;
    private static final SDebug db = new SDebug("CedVcatMembersPane");
    private static final String EDIT_MEMBER = "Edit Member...";
    private static final String ADD_MEMBER = "Add Member...";
    private static final String DELETE_MEMBER = "Delete Member...";
    private VcatMemberCktDataSource memCktsDataSource;
    private CircuitsTableModel model;
    private ColumnRenderer[] columnRenderers = null;
    private INetCircuit ckt;
    private JButton editMemBn;
    private JButton addMemBtn;
    private JButton delMemBtn;
    private static final int MAX_RECOMMENDED_DIALOGS = 4;
    private boolean vcgReconfigurable = false;
    static final String DELETE_TITLE = "Delete Members";
    static final String PREF_DELETE_VALUE = "warnDeleteMembers";
    static final String PREF_DELETE_DESCR = "VCAT: Deleting members changes the circuit size";
    static final String FULLY_DELETE_WARN_MSG = "Deleting members changes the circuit size.";

    public CedVcatMembersPane(String string, CircuitEditTabbedView circuitEditTabbedView) {
        super(string, circuitEditTabbedView);
        this.parent = circuitEditTabbedView;
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
        NetCircuitModel netCircuitModel = (NetCircuitModel)circuitEditTabbedView.getUiModel();
        this.ckt = netCircuitModel.getNetCircuit();
        this.memCktsDataSource = new VcatMemberCktDataSource(this.ckt);
        this.columnRenderers = CircuitColumnRenderer.createTableRenderers(1);
        this.model = new CircuitsTableModel((RowDataSource)this.memCktsDataSource, this.columnRenderers, INetCircuit.class);
        this.table = new CircuitsByNameTable(this.model);
        this.table.addMouseListener(this);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.setLayout(new BorderLayout());
        this.add((Component)new UScrollPane((Component)this.table), "Center");
        this.editMemBn = new JButton(EDIT_MEMBER);
        this.editMemBn.addActionListener(this);
        this.editMemBn.setEnabled(false);
        this.addMemBtn = new JButton(ADD_MEMBER);
        this.addMemBtn.addActionListener(this);
        this.enableComponent(this.addMemBtn);
        this.delMemBtn = new JButton(DELETE_MEMBER);
        this.delMemBtn.addActionListener(this);
        this.delMemBtn.setEnabled(false);
        JPanel jPanel = new JPanel();
        jPanel.add(this.editMemBn);
        jPanel.add(this.addMemBtn);
        jPanel.add(this.delMemBtn);
        this.add(jPanel, "South");
    }

    public void refresh() {
        if (CedVcatMembersPane.db.on) {
            db.println("refresh");
        }
    }

    public void leavingPage() throws Exception {
        this.memCktsDataSource.setEnabled(false);
    }

    public void destroy() {
        if (this.memCktsDataSource != null) {
            this.memCktsDataSource.dispose();
        }
        super.destroy();
    }

    public void enteringPage() throws Exception {
        this.memCktsDataSource.setEnabled(true);
        this.addMemBtn.setEnabled(false);
        this.delMemBtn.setEnabled(false);
        NetVcatCircuit netVcatCircuit = (NetVcatCircuit)this.ckt;
        INetVcatTermination iNetVcatTermination = null;
        boolean bl = this.vcgReconfigurable = !netVcatCircuit.isOpenEndedVcatCircuit();
        if (!this.vcgReconfigurable) {
            return;
        }
        List list = netVcatCircuit.getAllVcatTerms();
        Iterator iterator = list.iterator();
        while (iterator.hasNext() && this.vcgReconfigurable) {
            iNetVcatTermination = (INetVcatTermination)iterator.next();
            try {
                iNetVcatTermination.getNumOfNewMembersAllowed();
                this.vcgReconfigurable = true;
            }
            catch (VcatNotReconfigurable vcatNotReconfigurable) {
                this.vcgReconfigurable = false;
                if (!db.on()) continue;
                SDebug.printStackTrace((Throwable)vcatNotReconfigurable);
            }
        }
        if (this.vcgReconfigurable) {
            int n = netVcatCircuit.getState();
            int n2 = netVcatCircuit.getAllMemberCircuits().size();
            if (n == 1 || n == 5 || n2 == 0) {
                this.enableComponent(this.addMemBtn);
            }
        }
        this.syncButtons();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        boolean bl;
        if (actionEvent.getSource() == this.editMemBn) {
            this.editSelectedCircuits(this.getSelectedCircuits());
        }
        if (actionEvent.getSource() == this.delMemBtn) {
            bl = true;
            object = this.getSelectedCircuits();
            int[] nArray = ((NetVcatCircuit)this.ckt).memberDeleteCheck((INetCircuit[])object);
            Object object2 = null;
            if (nArray != null) {
                for (int i = 0; i < nArray.length; ++i) {
                    object2 = object[nArray[i]];
                    if (object2.getState() != 8) continue;
                    String string = object[nArray[i]].getCircuitName();
                    bl = false;
                    ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_BRIDGE_AND_ROLL_CANNOT_DELETE_CIRCUIT_PARAM_1, (Object)string);
                }
            } else if (((NetVcatCircuit)this.ckt).requireForceDeletion(this.getSelectedCircuits())) {
                String string = NetServiceState.getServiceStateStringFromServiceState(0);
                String string2 = NetServiceState.getServiceStateStringFromServiceState(1);
                String string3 = CircuitMapUtil.getTDMTerminology(this.ckt).getTermForAdminState(4);
                bl = CerentDialog.yesNoWarningDialog((Component)((Object)this), (String)("Deleting " + string + " or " + string2 + " VCAT members \n" + "will affect the service of entire circuit for\n" + "a certain period of time. \n\n" + (this.isVcatTermLCAS() ? "To avoid traffic loss, place the VCAT members\nin the " + string3 + " state before you delete them.\n\n" : "") + "Continue with member deletion ?"), (String)DELETE_TITLE, (int)1);
            }
            if (bl) {
                IgnorableDialog.infoDialog((Component)((Object)this), (String)FULLY_DELETE_WARN_MSG, (String)DELETE_TITLE, (String)PREF_DELETE_VALUE, (String)PREF_DELETE_DESCR);
                try {
                    ((NetVcatCircuit)this.ckt).destroyMemberCkts(this.getSelectedCircuits());
                }
                catch (Exception exception) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)exception);
                    }
                    ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_VCAT_MEMBER_DELETE_FAILED_PARAM_1, (Object)exception.getMessage());
                }
            }
        }
        if (actionEvent.getSource() == this.addMemBtn) {
            bl = EventMaskUtil.isCtrlShiftPressed(actionEvent);
            object = new AddVcatMembersDialog(JOptionPane.getFrameForComponent((Component)((Object)this)), this.ckt, !bl);
            ((Dialog)object).show();
        }
    }

    private boolean isVcatTermLCAS() {
        List list = ((NetVcatCircuit)this.ckt).getAllVcatTerms();
        if (list.size() == 0) {
            return false;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            INetVcatTermination iNetVcatTermination = (INetVcatTermination)iterator.next();
            if (iNetVcatTermination.getLcasMode() != 2) continue;
            return true;
        }
        return false;
    }

    protected INetCircuit[] getSelectedCircuits() {
        int[] nArray = this.table.getSelectedRows();
        INetCircuit[] iNetCircuitArray = new INetCircuit[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            iNetCircuitArray[i] = (INetCircuit)this.model.getValueAt(nArray[i], 0);
        }
        if (iNetCircuitArray.length == 0) {
            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_CKT_MEMBER_NOT_SELECTED);
            iNetCircuitArray = new INetCircuit[]{};
        }
        return iNetCircuitArray;
    }

    private void editSelectedCircuits(INetCircuit[] iNetCircuitArray) {
        String string;
        if (iNetCircuitArray.length > 4 && !CerentDialog.yesNoDialog((Component)((Object)this), (String)(string = "You have chosen to open " + iNetCircuitArray.length + " Edit Circuit Dialogs at once.\n" + "The recommended maximum is " + 4 + ".\n" + "Are you sure you wish to do this?"), (String)("Open " + iNetCircuitArray.length + " Edit Circuit Dialogs"))) {
            return;
        }
        for (int i = 0; i < iNetCircuitArray.length; ++i) {
            CircuitEditDialog.instance(iNetCircuitArray[i]).show();
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            this.syncButtons();
        }
    }

    protected void syncButtons() {
        int n;
        int n2 = this.table != null ? this.table.getSelectedRowCount() : -1;
        int n3 = n = this.table != null ? this.table.getRowCount() : -1;
        if (db.on()) {
            db.println("syncButtons " + (n2 != -1 && n != -1 ? n2 + "/" + n + " (Sel/Tot)" + (n2 > n ? " !!!" : "") : "table is null"));
        }
        if (this.table != null) {
            boolean bl;
            boolean bl2 = bl = n > 0 && n2 > 0;
            if (bl) {
                this.editMemBn.setEnabled(true);
                if (this.vcgReconfigurable) {
                    this.enableComponent(this.delMemBtn);
                }
            } else {
                this.editMemBn.setEnabled(false);
                this.delMemBtn.setEnabled(false);
            }
        } else {
            this.editMemBn.setEnabled(false);
            this.delMemBtn.setEnabled(false);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n;
        if (mouseEvent.getClickCount() == 2 && (n = this.table.rowAtPoint(mouseEvent.getPoint())) != -1) {
            this.table.setRowSelectionInterval(n, n);
            this.editSelectedCircuits(this.getSelectedCircuits());
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }
}

