/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.Attribute;
import cerent.cms.model.AttributeMaps;
import cerent.cms.model.CircuitSize;
import cerent.cms.model.CircuitType;
import cerent.cms.model.DeprecatedMethodCalled;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IRevertiveBehavior;
import cerent.cms.model.ITdmPortModel;
import cerent.cms.model.IVlanModel;
import cerent.cms.model.NetAdminState;
import cerent.cms.model.NetworkModel;
import cerent.cms.model.NoSuchDefault;
import cerent.cms.model.NoSuchEquipment;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.OchPortsHelper;
import cerent.cms.model.RevertiveBehavior;
import cerent.cms.model.WrongPathType;
import cerent.cms.model.circuits.NetCircuitModel;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.IncorrectCircuitState;
import cerent.cms.ncp.NetCircuitFactory;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.OchccCircuit;
import cerent.cms.ncp.OchncCircuitEnd;
import cerent.cms.ncp.PortGrouping;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.ncp.VlanStpSanityCheckFailed;
import cerent.cms.route.RoutePrefs;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.Network;
import cerent.cms.ui.CircuitOptDir;
import cerent.cms.ui.NetworkDefaults;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.WzPane;
import cerent.cms.ui.circuits.AbstractCcdAttrsPane;
import cerent.cms.ui.circuits.AbstractCircuitDialog;
import cerent.cms.ui.circuits.AdminStatePanel;
import cerent.cms.ui.circuits.AutorangeInfo;
import cerent.cms.ui.circuits.Autoranger;
import cerent.cms.ui.circuits.CcdAttrsPane;
import cerent.cms.ui.circuits.CcdCircuitDesignPane;
import cerent.cms.ui.circuits.CcdConversionCktPane;
import cerent.cms.ui.circuits.CcdEndpointsPane;
import cerent.cms.ui.circuits.CcdLapAttrsPane;
import cerent.cms.ui.circuits.CcdLoPane;
import cerent.cms.ui.circuits.CcdOCHNCAttrsPane;
import cerent.cms.ui.circuits.CcdOCHTrailAttrsPane;
import cerent.cms.ui.circuits.CcdReviewEditPane;
import cerent.cms.ui.circuits.CcdRouteConstraintPane;
import cerent.cms.ui.circuits.CcdRoutePane;
import cerent.cms.ui.circuits.CcdVcatAttrsPane;
import cerent.cms.ui.circuits.CcdVcatReviewEditPane;
import cerent.cms.ui.circuits.CcdVcatRouteConstraintPane;
import cerent.cms.ui.circuits.CcdVcatRoutePane;
import cerent.cms.ui.circuits.CcdVlanPane;
import cerent.cms.ui.circuits.CcdVttAttrsPane;
import cerent.cms.ui.circuits.CcdWizardInfo;
import cerent.cms.ui.circuits.CircuitCreationWizard;
import cerent.cms.ui.circuits.CircuitMapUtil;
import cerent.cms.ui.circuits.WzCcdPane;
import cerent.cms.ui.vlan.VlanStpDialog;
import cerent.cms.vlan.VlanSetManager;
import cerent.util.AnnotatedException;
import cerent.util.DetailedLog;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.Preferences;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.ProgressDialog;
import cerent.util.gui.ProgressDialogControl;
import cerent.util.gui.ProgressDialogResult;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Observer;
import org.omg.CORBA.BAD_PARAM;

public class CircuitCreationDialog
extends AbstractCircuitDialog
implements ProgressDialogControl {
    static final int REVERTIVE_TIME_DEFAULT = 300;
    public static final String UNSPECIFIED_NAME = "<auto-assigned>";
    public static final String PREF_AUTOROUTE = "autoRoute";
    private static final String PREF_TYPE = "type";
    private static final String PREF_SIZE = "size";
    private static final String PREF_MAXAUTORANGED_STS = "maxAutoRangedSts";
    private static final String PREF_MAXAUTORANGED_VT_1_5 = "maxAutoRangedVt1_5";
    private static final String PREF_MAXAUTORANGED_VT_2 = "maxAutoRangedVt2";
    private static final String PREF_MAXAUTORANGED_VC_HO = "maxAutoRangedVcHo";
    private static final String PREF_MAXAUTORANGED_VC_LO_VC3 = "maxAutoRangedVcLoVc3";
    private static final String PREF_MAXAUTORANGED_VC_LO_VC12 = "maxAutoRangedVcLoVc12";
    private static final String PREF_MAXAUTORANGED_VC_LO_VC11 = "maxAutoRangedVcLoVc11";
    static final String PREF_APPLY_DROP_PORTS = "applyDropPorts";
    private static final String PREF_BIDIR = "bidirectional";
    private static final String PREF_COUNT = "count";
    private static final String PREF_PATH_PROT = "pathProtection";
    private static final String PREF_DROP_PROT = "dropProtection";
    private static final String PREF_TL1 = "createTL1Like";
    public static final String VLANSTPVIOLATION_MSG = "The circuit VLAN list cannot be mapped to one spanning tree.\nYou can view the VLAN/Spanning Tree table or reassign VLANs";
    private static boolean tl1LikeDefault;
    private static boolean tl1LikeDefaultInited;
    private int numDropPortsNotSet = 0;
    private StringBuffer dropPortsNotSet = new StringBuffer();
    private boolean stopDriver = false;
    private AutorangeInfo arInfo = null;

    public CircuitCreationDialog(CcdWizardInfo ccdWizardInfo, Frame frame, IModel iModel, boolean bl) {
        this(null, ccdWizardInfo, frame, bl, iModel);
    }

    public CircuitCreationDialog(CircuitCreationWizard circuitCreationWizard, CcdWizardInfo ccdWizardInfo, Frame frame, boolean bl, IModel iModel) {
        super(frame, "Circuit Creation", new WzDiagDebug("CircuitCreationDialog"), bl, true);
        this.wizard = circuitCreationWizard;
        this.wizardInfo = ccdWizardInfo;
        int n = 900;
        int n2 = 450;
        this.setSize(new Dimension(n, n2));
        this.createPanesAndSetCurrent();
        this.setLocationRelativeTo(frame);
    }

    protected void createPanesAndSetCurrent() {
        int n = CircuitType.UNDEFINED_TYPE;
        Preferences preferences = Preferences.instance();
        try {
            n = preferences.getInt("ctc.circuit.creation", PREF_TYPE, this.getCircuitType());
        }
        catch (BAD_PARAM bAD_PARAM) {
            // empty catch block
        }
        if (this.wizardInfo != null) {
            n = this.wizardInfo.circuitType;
        }
        if (this.db.on()) {
            this.db.fine("determined ckt type to " + n);
        }
        if (n == 9) {
            this.wzPaneMap.put("Circuit Attributes", new CcdOCHNCAttrsPane(this, this.makeChildDebug("OCHNCAttrs"), "Circuit Attributes"));
        } else if (n == 14) {
            this.wzPaneMap.put("Circuit Attributes", new CcdOCHTrailAttrsPane(this, this.makeChildDebug("OCHTrailAttrs"), "Circuit Attributes"));
        } else if (n == 3 || n == 6) {
            this.wzPaneMap.put("Circuit Attributes", new CcdVttAttrsPane(this, this.makeChildDebug("VttAttrs"), "Circuit Attributes"));
        } else if (n == 7 || n == 8) {
            this.wzPaneMap.put("Circuit Attributes", new CcdLapAttrsPane(this, this.makeChildDebug("LapAttrs"), "Circuit Attributes"));
        } else if (this.isVcatType(n)) {
            this.wzPaneMap.put("Circuit Attributes", new CcdVcatAttrsPane(this, this.makeChildDebug("VcatAttrs"), "Circuit Attributes"));
        } else {
            this.wzPaneMap.put("Circuit Attributes", new CcdAttrsPane(this, this.makeChildDebug("Attrs"), "Circuit Attributes"));
        }
        if (n == 9 || n == 14) {
            this.wzPaneMap.put("Source", new CcdEndpointsPane(this, this.makeChildDebug("Source"), "Source", "Source", false, false));
        } else {
            this.wzPaneMap.put("Source", new CcdEndpointsPane(this, this.makeChildDebug("Source"), "Source", "Source"));
        }
        if (n == 9 || n == 14) {
            this.wzPaneMap.put("Destination", new CcdEndpointsPane(this, this.makeChildDebug("Dest"), "Destination", "Destination", false, false));
        } else {
            this.wzPaneMap.put("Destination", new CcdEndpointsPane(this, this.makeChildDebug("Dest"), "Destination", "Destination"));
        }
        this.wzPaneMap.put("Circuit VLAN Selection", new CcdVlanPane(this, this.makeChildDebug("Vlan"), "Circuit VLAN Selection"));
        this.wzPaneMap.put("Circuit Routing Preferences", new CcdRoutePane(this, this.makeChildDebug("RoutePrefs"), "Circuit Routing Preferences"));
        this.wzPaneMap.put("Conversion Circuit Constraints For Automatic Routing", new CcdConversionCktPane(this, this.makeChildDebug("XmRoute"), "Conversion Circuit Constraints For Automatic Routing"));
        this.wzPaneMap.put("VCat Circuit Routing Preferences", new CcdVcatRoutePane(this, this.makeChildDebug("VcatRoutePrefs"), "VCat Circuit Routing Preferences"));
        this.wzPaneMap.put(WZPANE_GET_LO, new CcdLoPane(this, this.makeChildDebug("Lo"), WZPANE_GET_LO));
        if (this.isVcatType(n)) {
            this.wzPaneMap.put("Circuit Constraints For Automatic Routing", new CcdVcatRouteConstraintPane(this, this.makeChildDebug("VcatRouteConstr"), "Circuit Constraints For Automatic Routing", true));
            this.wzPaneMap.put("Route Review/Edit", new CcdVcatReviewEditPane(this, this.makeChildDebug("VcatReviewEdit"), "Route Review/Edit", true));
        } else {
            this.wzPaneMap.put("Circuit Constraints For Automatic Routing", new CcdRouteConstraintPane(this, this.makeChildDebug("RouteConstr"), "Circuit Constraints For Automatic Routing", true));
            this.wzPaneMap.put("Route Review/Edit", new CcdReviewEditPane(this, this.makeChildDebug("ReviewEdit"), "Route Review/Edit", true));
        }
        if (this.db.on()) {
            this.db.fine("Successfully added all WzPanes to map.");
        }
        this.initializeLocalVariables();
        this.readCircuitPrefsAndGetCircuitDefaults();
        if (this.wizardInfo != null) {
            this.setCircuitType(this.wizardInfo.circuitType);
            this.setPortGrouping(this.wizardInfo.portGrouping);
            this.autoRange = this.wizardInfo.autoRange;
            if (this.autoRange) {
                this.arInfo = new AutorangeInfo();
                this.arInfo.routePrefs = this.getRoutePrefs();
            }
            this.circuitCount = this.wizardInfo.numCircuits;
        }
        this.setCurrentPane("Circuit Attributes");
    }

    public void setApplyDropPorts(boolean bl) {
        this.applyDropPorts = bl;
    }

    public boolean getPortGrouping() {
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null) {
            return abstractCcdAttrsPane.getPortGrouping();
        }
        this.db.severe("could not get port grouping... returning false");
        return false;
    }

    private void setPortGrouping(boolean bl) {
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null) {
            abstractCcdAttrsPane.setPortGrouping(bl);
        } else {
            this.db.severe("could not set port grouping.");
        }
    }

    public boolean getDropProtection() {
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null) {
            return abstractCcdAttrsPane.getDropProtection();
        }
        this.db.severe("could not get drop protection... returning false");
        return false;
    }

    public boolean isCircuitTL1Compatible() {
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null) {
            return abstractCcdAttrsPane.isCircuitTL1Compatible();
        }
        this.db.severe("could not get if ckt is TL1 compat... returning false");
        return false;
    }

    private void setCircuitTL1Compatible(boolean bl) {
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null) {
            abstractCcdAttrsPane.setCircuitTL1Compatible(bl);
        } else {
            this.db.severe("could not set TL1 Compatibility.");
        }
    }

    public String getCircuitName() {
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null) {
            return abstractCcdAttrsPane.getCircuitName();
        }
        this.db.severe("could not get ckt name... returning UNSPECIFIED_NAME");
        return UNSPECIFIED_NAME;
    }

    public int getCircuitType() {
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null) {
            return abstractCcdAttrsPane.getCircuitType();
        }
        this.db.severe("could not get ckt type... returning UNDEFINED_TYPE");
        return CircuitType.UNDEFINED_TYPE;
    }

    private void setCircuitType(int n) {
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null) {
            abstractCcdAttrsPane.setCircuitType(n);
        } else {
            this.db.severe("could not set circuit type.");
        }
    }

    public int getCircuitSize() {
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null) {
            return abstractCcdAttrsPane.getCircuitSize();
        }
        this.db.severe("could not get ckt size... returning UNDEFINED_SIZE");
        return CircuitSize.UNDEFINED_SIZE;
    }

    private void setCircuitSize(int n) {
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null) {
            abstractCcdAttrsPane.setCircuitSize(n);
        } else {
            this.db.severe("could not set circuit size.");
        }
    }

    public int getAdminState() {
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null) {
            return abstractCcdAttrsPane.getAdminState();
        }
        this.db.severe("could not get admin state... returning IS_AINS");
        return 3;
    }

    public int getPortsState() {
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null) {
            return abstractCcdAttrsPane.getPortsState();
        }
        this.db.severe("could not get ports state... returning IS_AINS");
        return 3;
    }

    private void setAdminState(int n) {
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null) {
            abstractCcdAttrsPane.setAdminState(n);
        } else {
            this.db.severe("could not set admin state");
        }
    }

    public CircuitCreatInfo getCircuitInfo() {
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null) {
            return abstractCcdAttrsPane.getCircuitInfo();
        }
        this.db.severe("could not get circuit info... returning NULL");
        return null;
    }

    public boolean getUpsrGoReturnRouting() {
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null) {
            return abstractCcdAttrsPane.getUpsrGoReturnRouting();
        }
        this.db.severe("could not get UPSR go-ret routing... returning false");
        return false;
    }

    public void setUpsrSwitchOnPdip(boolean bl) {
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null) {
            abstractCcdAttrsPane.setUpsrSwitchOnPdip(bl);
        } else {
            this.db.severe("could not set UPSR switch on Pdip");
        }
    }

    public boolean getUpsrSwitchOnPdip() {
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null) {
            return abstractCcdAttrsPane.getUpsrSwitchOnPdip();
        }
        this.db.severe("could not get UPSR switch... returning false");
        return false;
    }

    private void setUpsrGoReturnRouting(boolean bl) {
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null) {
            abstractCcdAttrsPane.setUpsrGoReturnRouting(bl);
        } else {
            this.db.severe("could not set UPSR return routing.");
        }
    }

    public IRevertiveBehavior getUpsrReversion() {
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null) {
            return abstractCcdAttrsPane.getUpsrReversion();
        }
        this.db.severe("could not get revertive behavior... returning NULL");
        return null;
    }

    public void setUpsrReversion(IRevertiveBehavior iRevertiveBehavior) {
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null) {
            abstractCcdAttrsPane.setUpsrReversion(iRevertiveBehavior);
        } else {
            this.db.severe("could not set upsr revertive behavior");
        }
    }

    public Attribute getUpsrSfBerLevel() {
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null) {
            return abstractCcdAttrsPane.getUpsrSfBerLevel();
        }
        this.db.severe("could not get upsr sf ber level ... returning NULL");
        return null;
    }

    private void setUpsrSfBerLevel(Attribute attribute) {
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null) {
            abstractCcdAttrsPane.setUpsrSfBerLevel(attribute);
        } else {
            this.db.severe("could not set upsr SF Ber Level.");
        }
    }

    public Attribute getUpsrSdBerLevel() {
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null) {
            return abstractCcdAttrsPane.getUpsrSdBerLevel();
        }
        this.db.severe("could not get upsr sd ber level... returning NULL");
        return null;
    }

    private void setUpsrSdBerLevel(Attribute attribute) {
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null) {
            abstractCcdAttrsPane.setUpsrSdBerLevel(attribute);
        } else {
            this.db.severe("could not set upsr SD Ber Level.");
        }
    }

    public int getVcatTxMembers() {
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null) {
            if (abstractCcdAttrsPane instanceof CcdVcatAttrsPane) {
                return ((CcdVcatAttrsPane)abstractCcdAttrsPane).getVcatTxMembers();
            }
            this.db.severe("could not get vcat TX - not CcdVcatAttrs... returning 0");
            return 0;
        }
        this.db.severe("could not get vcat TX...  returning 0");
        return 0;
    }

    public void setCircuitName(String string) {
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null) {
            abstractCcdAttrsPane.setCircuitName(string);
        } else {
            this.db.severe("can't set circuit name " + string);
        }
    }

    public void setCircuitInfo(CircuitCreatInfo circuitCreatInfo) {
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null) {
            abstractCcdAttrsPane.setCircuitInfo(circuitCreatInfo);
        } else {
            this.db.severe("can't set circuit info " + circuitCreatInfo);
        }
    }

    public void setSourceNode(INodeModel iNodeModel) {
        CcdEndpointsPane ccdEndpointsPane = (CcdEndpointsPane)this.wzPaneMap.get("Source");
        if (ccdEndpointsPane != null) {
            ccdEndpointsPane.setLastNode(iNodeModel);
        } else {
            this.db.severe("can't set sourcenode " + iNodeModel);
        }
    }

    public void setDestNode(INodeModel iNodeModel) {
        CcdEndpointsPane ccdEndpointsPane = (CcdEndpointsPane)this.wzPaneMap.get("Destination");
        if (ccdEndpointsPane != null) {
            ccdEndpointsPane.setLastNode(iNodeModel);
        } else {
            this.db.severe("can't set destnode " + iNodeModel);
        }
    }

    public INodeModel getSourceNode() {
        CcdEndpointsPane ccdEndpointsPane = (CcdEndpointsPane)this.wzPaneMap.get("Source");
        if (ccdEndpointsPane != null) {
            return ccdEndpointsPane.getNodeModel();
        }
        this.db.severe("could not get source node.. returning null");
        return null;
    }

    public INodeModel getAltSourceNode() {
        CcdEndpointsPane ccdEndpointsPane = (CcdEndpointsPane)this.wzPaneMap.get("Source");
        if (ccdEndpointsPane != null) {
            return ccdEndpointsPane.getAltNodeModel();
        }
        this.db.severe("could not get alt source node.. returning null");
        return null;
    }

    public INodeModel getDestNode() {
        CcdEndpointsPane ccdEndpointsPane = (CcdEndpointsPane)this.wzPaneMap.get("Destination");
        if (ccdEndpointsPane != null) {
            return ccdEndpointsPane.getNodeModel();
        }
        this.db.severe("could not get dest node.. returning null");
        return null;
    }

    public INodeModel getAltDestNode() {
        CcdEndpointsPane ccdEndpointsPane = (CcdEndpointsPane)this.wzPaneMap.get("Destination");
        if (ccdEndpointsPane != null) {
            return ccdEndpointsPane.getAltNodeModel();
        }
        this.db.severe("could not get alt dest node.. returning null");
        return null;
    }

    public INetCircuitEnd getSource() {
        CcdEndpointsPane ccdEndpointsPane = (CcdEndpointsPane)this.wzPaneMap.get("Source");
        if (ccdEndpointsPane != null) {
            return ccdEndpointsPane.getMainPanelEndpoint();
        }
        this.db.severe("could not get source... returning null");
        return null;
    }

    public INetCircuitEnd getAltSource() {
        CcdEndpointsPane ccdEndpointsPane = (CcdEndpointsPane)this.wzPaneMap.get("Source");
        if (ccdEndpointsPane != null) {
            return ccdEndpointsPane.getAltPanelEndpoint();
        }
        this.db.severe("could not get alt source... returning null");
        return null;
    }

    public INetCircuitEnd getDest() {
        CcdEndpointsPane ccdEndpointsPane = (CcdEndpointsPane)this.wzPaneMap.get("Destination");
        if (ccdEndpointsPane != null) {
            return ccdEndpointsPane.getMainPanelEndpoint();
        }
        this.db.severe("could not get dest... returning null");
        return null;
    }

    public INetCircuitEnd getAltDest() {
        CcdEndpointsPane ccdEndpointsPane = (CcdEndpointsPane)this.wzPaneMap.get("Destination");
        if (ccdEndpointsPane != null) {
            return ccdEndpointsPane.getAltPanelEndpoint();
        }
        this.db.severe("could not get alt dest... returning null");
        return null;
    }

    public INetCircuitEnd getPgEnd() {
        CcdEndpointsPane ccdEndpointsPane = (CcdEndpointsPane)this.wzPaneMap.get("Source");
        if (ccdEndpointsPane != null) {
            return (INetCircuitEnd)ccdEndpointsPane.getEndpoints().get(0);
        }
        this.db.severe("could not get pg end... returning null");
        return null;
    }

    public INetCircuitEnd getDestPgEnd() {
        CcdEndpointsPane ccdEndpointsPane = (CcdEndpointsPane)this.wzPaneMap.get("Destination");
        if (ccdEndpointsPane != null) {
            return (INetCircuitEnd)ccdEndpointsPane.getEndpoints().get(0);
        }
        this.db.severe("could not get dest pg end... returning null");
        return null;
    }

    protected WzPane getRoutePane() {
        if (this.isVcatType()) {
            return (WzPane)this.wzPaneMap.get("VCat Circuit Routing Preferences");
        }
        return (WzPane)this.wzPaneMap.get("Circuit Routing Preferences");
    }

    public INetCircuitEnd[] getXmCircuitEnds() {
        CcdConversionCktPane ccdConversionCktPane = (CcdConversionCktPane)this.wzPaneMap.get("Conversion Circuit Constraints For Automatic Routing");
        return ccdConversionCktPane.getMainPanel() != null ? ccdConversionCktPane.getMainPanel().getXmCircuitEnds() : null;
    }

    public RoutePrefs getRoutePrefs() {
        WzPane wzPane = this.getRoutePane();
        if (wzPane != null) {
            if (this.isVcatType()) {
                return ((CcdVcatRoutePane)wzPane).getRoutePrefs();
            }
            return ((CcdRoutePane)wzPane).getRoutePrefs();
        }
        this.db.severe("could not get route prefs... returning null");
        return null;
    }

    public void setRoutePrefs(RoutePrefs routePrefs) {
        WzPane wzPane = this.getRoutePane();
        if (wzPane != null) {
            if (this.isVcatType()) {
                ((CcdVcatRoutePane)wzPane).setRoutePrefs(routePrefs);
            } else {
                ((CcdRoutePane)wzPane).setRoutePrefs(routePrefs);
            }
        } else {
            this.db.severe("Could not set route prefs " + routePrefs);
        }
    }

    public boolean isPca() {
        WzPane wzPane = this.getRoutePane();
        if (wzPane != null) {
            if (this.isVcatType()) {
                return ((CcdVcatRoutePane)wzPane).isPca();
            }
            return ((CcdRoutePane)wzPane).isPca();
        }
        this.db.severe("could not get pca... returning false");
        return false;
    }

    public void setPca(boolean bl) {
        WzPane wzPane = this.getRoutePane();
        if (wzPane != null) {
            if (this.isVcatType()) {
                ((CcdVcatRoutePane)wzPane).setPca(bl);
            } else {
                ((CcdRoutePane)wzPane).setPca(bl);
            }
        } else {
            this.db.severe("could not set PCA!");
        }
    }

    public boolean isPathProt() {
        WzPane wzPane = this.getRoutePane();
        if (wzPane != null) {
            if (this.isVcatType()) {
                return ((CcdVcatRoutePane)wzPane).isPathProt();
            }
            return ((CcdRoutePane)wzPane).isPathProt();
        }
        this.db.severe("could not get path prot... returning false");
        return false;
    }

    public void setPathProt(boolean bl) {
        WzPane wzPane = this.getRoutePane();
        if (wzPane != null) {
            if (this.isVcatType()) {
                ((CcdVcatRoutePane)wzPane).setPathProt(bl);
            } else {
                ((CcdRoutePane)wzPane).setPathProt(bl);
            }
        } else {
            this.db.severe("could not set path prot with " + bl);
        }
    }

    public boolean isRrbc() {
        WzPane wzPane = this.getRoutePane();
        if (wzPane != null) {
            if (this.isVcatType()) {
                return ((CcdVcatRoutePane)wzPane).isRrbc();
            }
            return ((CcdRoutePane)wzPane).isRrbc();
        }
        this.db.severe("could not get isRrbc... returning false");
        return false;
    }

    public boolean isUrn() {
        WzPane wzPane = this.getRoutePane();
        if (wzPane != null) {
            if (this.isVcatType()) {
                return ((CcdVcatRoutePane)wzPane).isUrn();
            }
            return ((CcdRoutePane)wzPane).isUrn();
        }
        this.db.severe("could not get isUrn... returning false");
        return false;
    }

    public boolean isAutoRoute() {
        WzPane wzPane = this.getRoutePane();
        if (wzPane != null) {
            if (this.isVcatType()) {
                return ((CcdVcatRoutePane)wzPane).isAutoRoute();
            }
            return ((CcdRoutePane)wzPane).isAutoRoute();
        }
        this.db.severe("could not get autoroute... returning false");
        return false;
    }

    public ArrayList getVcatMemberPrefs() {
        WzPane wzPane = this.getRoutePane();
        if (wzPane != null && wzPane instanceof CcdVcatRoutePane) {
            return ((CcdVcatRoutePane)wzPane).getVcatMemberPrefs();
        }
        this.db.severe("could not get vcat member prefs... returning null");
        return null;
    }

    public boolean isVcatCommonFiberRouting() {
        WzPane wzPane = this.getRoutePane();
        if (wzPane != null) {
            if (this.isVcatType()) {
                return ((CcdVcatRoutePane)wzPane).isVcatCommonFiberRouting();
            }
            if (this.db.on()) {
                this.db.println("asked for vcat common fiber routing for non-vcat");
            }
            return false;
        }
        this.db.severe("could not get vcat common fiber routing... returning false");
        return false;
    }

    public void setVcatCommonFiberRouting(boolean bl) {
        WzPane wzPane = this.getRoutePane();
        if (wzPane != null) {
            if (this.isVcatType()) {
                ((CcdVcatRoutePane)wzPane).setVcatCommonFiberRouting(bl);
            } else if (this.db.on()) {
                this.db.println("asked to set vcat common fiber routing for non-vcat");
            }
        } else {
            this.db.severe("could not set vcat common fiber routing!");
        }
    }

    protected void backFromEmptyStack() throws Exception {
        if (this.wizard != null) {
            this.close();
            this.dispose();
            this.wizard.setVisible(true);
        } else {
            super.backFromEmptyStack();
        }
    }

    protected void localValidation(int n) {
        boolean bl = this.currentWzPane.getName().equals("Source");
        if (bl && n == 0) {
            return;
        }
        if (this.isInvalidCircuitState()) {
            this.terminate();
        }
    }

    private void initializeLocalVariables() {
        this.stopDriver = false;
        this.circuitNumber = 1;
        this.circuitCount = 1;
        this.autoRange = false;
        this.numDropPortsNotSet = 0;
        this.dropPortsNotSet = new StringBuffer("The circuit state has not been applied to at least one drop on the following circuits: \n");
    }

    private boolean getDefaultGoReturnRouting() {
        Iterator iterator = Network.instance().getAllElements().iterator();
        while (iterator.hasNext()) {
            if (((INetElement)iterator.next()).getFramingTypeObj().isSdh()) continue;
            return false;
        }
        return true;
    }

    protected void readCircuitPrefs() {
        this.db.info("reading circuit preferences");
        Preferences preferences = Preferences.instance();
        this.setCircuitType(CircuitType.UNDEFINED_TYPE);
        try {
            this.setCircuitType(preferences.getInt("ctc.circuit.creation", PREF_TYPE, this.getCircuitType()));
        }
        catch (BAD_PARAM bAD_PARAM) {
            // empty catch block
        }
        if (this.db.isInfoEnabled()) {
            this.db.info("preferred  circuit type is " + this.getCircuitType());
        }
        this.setCircuitSize(CircuitSize.UNDEFINED_SIZE);
        try {
            this.setCircuitSize(preferences.getInt("ctc.circuit.creation", PREF_SIZE, this.getCircuitSize()));
        }
        catch (BAD_PARAM bAD_PARAM) {
            // empty catch block
        }
        if (this.db.isInfoEnabled()) {
            this.db.info("preferred  circuit size is " + this.getCircuitSize());
        }
        ICircuitType iCircuitType = CircuitType.getCircuitType((int)this.getCircuitType());
        this.applyDropPorts = this.getCircuitType() == 9 ? false : (this.applyDropPortsPref = preferences.getBoolean("ctc.circuit.creation", PREF_APPLY_DROP_PORTS, false));
        if (this.db.isInfoEnabled()) {
            this.db.info("preferred  apply drop ports is " + this.applyDropPorts);
        }
        this.setUpsrGoReturnRouting(preferences.getBoolean("ctc.circuit.creation", "upsrGoReturnRouting", this.getDefaultGoReturnRouting()));
        if (this.db.isInfoEnabled()) {
            this.db.info("preferred go return routing is " + this.getDefaultGoReturnRouting());
        }
        this.maxAutoRangedSts = preferences.getInt("ctc.circuit.creation", PREF_MAXAUTORANGED_STS, 5);
        this.maxAutoRangedVt1_5 = preferences.getInt("ctc.circuit.creation", PREF_MAXAUTORANGED_VT_1_5, 28);
        this.maxAutoRangedVt2 = preferences.getInt("ctc.circuit.creation", PREF_MAXAUTORANGED_VT_2, 21);
        this.maxAutoRangedVcHo = preferences.getInt("ctc.circuit.creation", PREF_MAXAUTORANGED_VC_HO, 5);
        this.maxAutoRangedVcLoVc3 = preferences.getInt("ctc.circuit.creation", PREF_MAXAUTORANGED_VC_LO_VC3, 3);
        this.maxAutoRangedVcLoVc11 = preferences.getInt("ctc.circuit.creation", PREF_MAXAUTORANGED_VC_LO_VC11, 84);
        this.maxAutoRangedVcLoVc12 = preferences.getInt("ctc.circuit.creation", PREF_MAXAUTORANGED_VC_LO_VC12, 63);
        this.maxAutoRangedVcLoVc11 = preferences.getInt("ctc.circuit.creation", PREF_MAXAUTORANGED_VC_LO_VC11, 84);
        this.db.info("done reading circuit preferences");
    }

    private String getDefaultValue(String string, String string2) {
        block3: {
            try {
                INodeModel iNodeModel = NetworkModel.instance().getCmsHostModel();
                string2 = iNodeModel.getDefaultValue(string);
            }
            catch (NoSuchDefault noSuchDefault) {
                this.db.info("getDefaultValue(): using fallback " + string2 + " for " + string);
            }
            catch (Exception exception) {
                if (!this.db.isSevereEnabled()) break block3;
                this.db.severe("getDefaultValue(): using fallback " + string2 + " for " + string + ": " + exception.getMessage());
                WzDiagDebug.printStackTrace((Throwable)exception);
            }
        }
        return string2;
    }

    private void getLikeTl1Default() {
        String string = "FALSE";
        string = this.getDefaultValue("CTC.circuits.CreateLikeTL1", string);
        this.setCircuitTL1Compatible(string.equalsIgnoreCase("TRUE"));
        this.db.info("Default createLikeTl1 is " + string);
    }

    private void getCircuitStateDefault() {
        int n;
        block5: {
            n = 3;
            ICircuitType iCircuitType = CircuitType.getCircuitType((int)this.getCircuitType());
            if (!iCircuitType.isOchncType()) {
                try {
                    n = Integer.parseInt(this.getDefaultValue("NODE.circuits.State", String.valueOf(n)));
                }
                catch (Exception exception) {
                    this.db.info("Can't retrieve NODE.circuits.State: " + exception.getMessage());
                    try {
                        n = Integer.parseInt(this.getDefaultValue("CTC.circuits.State", String.valueOf(n)));
                    }
                    catch (Exception exception2) {
                        if (!this.db.isSevereEnabled()) break block5;
                        this.db.severe("Can't retrieve CTC.circuits.State: " + exception2.getMessage());
                        WzDiagDebug.printStackTrace((Throwable)exception2);
                    }
                }
            }
        }
        this.setAdminState(n);
        this.db.info("Default circuit state is " + n);
    }

    private void getUpsrReversionDefaults() {
        RevertiveBehavior revertiveBehavior;
        block3: {
            revertiveBehavior = new RevertiveBehavior(1, 300);
            try {
                revertiveBehavior.setReversionMode(Integer.parseInt(this.getDefaultValue("NODE.circuits.upsr.Revertive", String.valueOf(1))));
                revertiveBehavior.setReversionTime(Integer.parseInt(this.getDefaultValue("NODE.circuits.upsr.ReversionTime", String.valueOf(300))));
            }
            catch (Exception exception) {
                if (!this.db.isSevereEnabled()) break block3;
                this.db.severe("Can't retrieve default revertive behavior: " + exception.getMessage());
                WzDiagDebug.printStackTrace((Throwable)exception);
            }
        }
        if (revertiveBehavior.getReversionTime() == 0) {
            this.db.severe("Overriding reversion time");
            revertiveBehavior.setReversionTime(30);
        }
        this.setUpsrReversion(revertiveBehavior);
        this.db.info("Default reversion is " + revertiveBehavior.getReversionMode() + " " + revertiveBehavior.getReversionTime());
    }

    private void getUpsrSberDefaults() {
        int n;
        int n2;
        int n3;
        block3: {
            n3 = -1;
            n2 = -1;
            n = 2;
            String string = "NODE.circuits.upsr.STS_SFBER";
            String string2 = "NODE.circuits.upsr.STS_SDBER";
            String string3 = "4";
            String string4 = "6";
            ICircuitType iCircuitType = CircuitType.getCircuitType((int)this.getCircuitType());
            if (iCircuitType.isLoCircuitType()) {
                n = 1;
                string = "NODE.circuits.upsr.VT_SFBER";
                string2 = "NODE.circuits.upsr.VT_SDBER";
                string3 = "4";
                string4 = "6";
            }
            try {
                n3 = Integer.parseInt(this.getDefaultValue(string, string3));
                n2 = Integer.parseInt(this.getDefaultValue(string2, string4));
            }
            catch (Exception exception) {
                if (!this.db.isSevereEnabled()) break block3;
                this.db.severe("Can't get default bers:" + exception);
                WzDiagDebug.printStackTrace((Throwable)exception);
            }
        }
        this.setUpsrSfBerLevel(this.getSfBerAttr(n3, n));
        this.setUpsrSdBerLevel(this.getSdBerAttr(n2, n));
        this.db.info("Default bers are " + n3 + " " + n2);
    }

    private void getUpsrSwitchOnPDIPDefaults() {
        boolean bl = false;
        bl = this.getDefaultValue("NODE.circuits.upsr.SwitchOnPDIP", "FALSE").equalsIgnoreCase("TRUE");
        this.setUpsrSwitchOnPdip(bl);
        this.db.info("Default switchOnPDIP is " + bl);
    }

    protected void getCircuitDefaults() {
        this.db.info("getting circuit defaults");
        this.getLikeTl1Default();
        this.getCircuitStateDefault();
        this.getCircuitStateDefault();
        this.getUpsrReversionDefaults();
        this.getUpsrSberDefaults();
        this.getUpsrSwitchOnPDIPDefaults();
        this.db.info("done getting circuit defaults");
    }

    protected void readCircuitPrefsAndGetCircuitDefaults() {
        this.readCircuitPrefs();
        this.getCircuitDefaults();
    }

    private Attribute getSfBerAttr(int n, int n2) {
        AttributeMaps attributeMaps = NetworkDefaults.getAttributeMap();
        Attribute attribute = attributeMaps.getAttributeForVal("declareSfBerLevel", n);
        if (attribute == null) {
            n = n2 == 2 ? 4 : 3;
            attribute = attributeMaps.getAttributeForVal("declareSfBerLevel", n);
        }
        this.db.info("getSfBerAttr circuitOrder=" + n2 + " SF value = " + n);
        return attribute;
    }

    private Attribute getSdBerAttr(int n, int n2) {
        AttributeMaps attributeMaps = NetworkDefaults.getAttributeMap();
        Attribute attribute = attributeMaps.getAttributeForVal("declareSdBerLevel", n);
        if (attribute == null) {
            n = n2 == 2 ? 6 : 5;
            attribute = attributeMaps.getAttributeForVal("declareSdBerLevel", n);
        }
        this.db.info("getSdBerAttr circuitOrder=" + n2 + " SD value = " + n);
        return attribute;
    }

    void writeCircuitPrefs() {
        Preferences preferences = Preferences.instance();
        preferences.setInt("ctc.circuit.creation", PREF_TYPE, this.getCircuitInfo().type());
        preferences.setInt("ctc.circuit.creation", PREF_SIZE, this.getCircuitInfo().size());
        preferences.setBoolean("ctc.circuit.creation", PREF_APPLY_DROP_PORTS, this.applyDropPortsPref);
        preferences.setInt("ctc.circuit.creation", PREF_MAXAUTORANGED_STS, this.maxAutoRangedSts);
        preferences.setInt("ctc.circuit.creation", PREF_MAXAUTORANGED_VT_1_5, this.maxAutoRangedVt1_5);
        preferences.setInt("ctc.circuit.creation", PREF_MAXAUTORANGED_VT_2, this.maxAutoRangedVt2);
        preferences.setInt("ctc.circuit.creation", PREF_MAXAUTORANGED_VC_HO, this.maxAutoRangedVcHo);
        preferences.setInt("ctc.circuit.creation", PREF_MAXAUTORANGED_VC_LO_VC3, this.maxAutoRangedVcLoVc3);
        preferences.setInt("ctc.circuit.creation", PREF_MAXAUTORANGED_VC_LO_VC11, this.maxAutoRangedVcLoVc11);
        preferences.setInt("ctc.circuit.creation", PREF_MAXAUTORANGED_VC_LO_VC12, this.maxAutoRangedVcLoVc12);
        preferences.setInt("ctc.circuit.creation", PREF_MAXAUTORANGED_VC_LO_VC11, this.maxAutoRangedVcLoVc11);
        preferences.removeProperty("ctc.circuit.creation", PREF_BIDIR);
        preferences.removeProperty("ctc.circuit.creation", PREF_COUNT);
        preferences.removeProperty("ctc.circuit.creation", PREF_PATH_PROT);
        preferences.removeProperty("ctc.circuit.creation", PREF_DROP_PROT);
        preferences.removeProperty("ctc.circuit.creation", PREF_TL1);
        AbstractCcdAttrsPane abstractCcdAttrsPane = (AbstractCcdAttrsPane)this.wzPaneMap.get("Circuit Attributes");
        if (abstractCcdAttrsPane != null && abstractCcdAttrsPane.isGoReturnRoutingSpecified()) {
            preferences.setBoolean("ctc.circuit.creation", "upsrGoReturnRouting", this.getUpsrGoReturnRouting());
        }
        preferences.setBoolean("ctc.circuit.creation", "revertive", this.getUpsrReversion().getReversionMode() == 2);
        preferences.setInt("ctc.circuit.creation", "revertTime", this.getUpsrReversion().getReversionTime());
        try {
            preferences.store();
        }
        catch (FileNotFoundException fileNotFoundException) {
            WzDiagDebug.printStackTrace((Throwable)fileNotFoundException);
            ErrorMsg.displayError((Component)this, (EID)NEMC.EID_CANT_SAVE_CKT_PREFS_PARAM_1, (Object)"File not found.");
        }
        catch (IOException iOException) {
            WzDiagDebug.printStackTrace((Throwable)iOException);
            ErrorMsg.displayError((Component)this, (EID)NEMC.EID_CANT_SAVE_CKT_PREFS_PARAM_1, (Object)"I/O error.");
        }
    }

    String getCircuitModdedName() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getCircuitName();
        boolean bl = string.length() > 0;
        stringBuffer.append(bl ? string : UNSPECIFIED_NAME);
        if (this.circuitCount > 1) {
            if (bl) {
                stringBuffer.append(":");
                stringBuffer.append(CircuitMapUtil.circuitSuffix(this.circuitNumber));
            }
            stringBuffer.append(" (" + this.circuitNumber + " of " + this.circuitCount + ")");
        }
        return stringBuffer.toString();
    }

    protected EID getNoRouteEmcErrorId() {
        return NEMC.EID_CKT_CREATE_ROUTE_ERROR;
    }

    public void createCircuit() throws Exception {
        this.destroyCircuit();
        ICircuitType iCircuitType = CircuitType.getCircuitType((int)this.getCircuitInfo().type());
        boolean bl = false;
        CcdEndpointsPane ccdEndpointsPane = (CcdEndpointsPane)this.wzPaneMap.get("Source");
        if (ccdEndpointsPane != null) {
            bl = ccdEndpointsPane.isEtherGroup();
        }
        if (iCircuitType.isOchncType()) {
            INetCircuitEnd iNetCircuitEnd = null;
            if (!this.getCircuitInfo().isEnhancedOchnc()) {
                if (this.db.on) {
                    this.db.println("createCircuit: (old style) OCHNC circuit");
                }
                iNetCircuitEnd = this.getOchncEndPoint(this.getCircuitInfo().cktOptChannel(), this.getCircuitInfo().cktOptDir(), 0, false);
            } else {
                if (this.db.on) {
                    this.db.println("createCircuit: (enhanced style) OCHNC circuit");
                }
                iNetCircuitEnd = this.getEnhancedOchncEndPoint(this.getCircuitInfo().cktOptChannel(), this.getSource().getNodeModel(), this.getSource().getEntityIndex());
            }
            if (iNetCircuitEnd == null) {
                throw new Exception("The selected Optical Channel is not available");
            }
            this.ckt = NetCircuitFactory.newCircuit(this.getCircuitInfo(), iNetCircuitEnd);
        } else if (iCircuitType.isOchccCircuitType()) {
            if (this.getSource().getEntityModel() instanceof ITdmPortModel) {
                if (this.db.on) {
                    this.db.println("createCircuit: OchTrail Circuit using ITU-T Line card");
                }
                int n = this.getSourceNode().getNodeId();
                INetElement iNetElement = Network.instance().findNetElem(n);
                this.ckt = NetCircuitFactory.newCircuit(this.getCircuitInfo(), iNetElement);
            } else {
                if (this.db.on) {
                    this.db.println("createCircuit: OchTrail Circuit");
                }
                this.ckt = NetCircuitFactory.newCircuit(this.getCircuitInfo(), this.getSource());
            }
        } else if (iCircuitType.isTunnelCircuitType() || bl) {
            if (this.db.on) {
                this.db.println("createCircuit: VT tunnel or Ethergroup circuit");
            }
            int n = this.getSourceNode().getNodeId();
            INetElement iNetElement = Network.instance().findNetElem(n);
            this.ckt = NetCircuitFactory.newCircuit(this.getCircuitInfo(), iNetElement);
        } else if (this.getAltSource() != null) {
            if (this.db.on) {
                this.db.println("createCircuit: V-UPSR (double) source");
            }
            this.ckt = NetCircuitFactory.newCircuit(this.getCircuitInfo(), this.getSource(), this.getAltSource());
        } else {
            if (this.db.on) {
                this.db.println("createCircuit: single source");
            }
            this.ckt = NetCircuitFactory.newCircuit(this.getCircuitInfo(), this.getSource());
        }
        if (this.ckt == null) {
            throw new Exception("createCircuit: newCircuit returned null");
        }
    }

    protected INetCircuitEnd getEnhancedOchncEndPoint(int n, INodeModel iNodeModel, int n2) {
        OchncCircuitEnd ochncCircuitEnd = null;
        ochncCircuitEnd = new OchncCircuitEnd(n);
        ochncCircuitEnd.setNodeModel(iNodeModel);
        ochncCircuitEnd.setEntityIndex(n2);
        return ochncCircuitEnd;
    }

    protected INetCircuitEnd getOchncEndPoint(int n, int n2, int n3, boolean bl) {
        OchncCircuitEnd ochncCircuitEnd;
        IEntityModel iEntityModel;
        block10: {
            INodeModel iNodeModel;
            iEntityModel = null;
            if (n3 == 0) {
                iNodeModel = bl ? this.getDestNode() : this.getSourceNode();
            } else if (n3 == 1) {
                iNodeModel = bl ? this.getSourceNode() : this.getDestNode();
            } else {
                return null;
            }
            ochncCircuitEnd = new OchncCircuitEnd(n);
            ochncCircuitEnd.setNodeModel(iNodeModel);
            try {
                iEntityModel = iNodeModel.getConnectionModels().getEntityForOchncPath(n, n2, n3);
            }
            catch (NoSuchEquipment noSuchEquipment) {
                if (this.db.on()) {
                    this.db.println("getEntityForOchncPath returns NoSuchEquipment");
                }
            }
            catch (WrongPathType wrongPathType) {
                if (!this.db.on()) break block10;
                this.db.println("getEntityForOchncPath has been called with PASSTHROUGH");
            }
        }
        if (iEntityModel == null) {
            return null;
        }
        ochncCircuitEnd.setEntityIndex(iEntityModel.getEntityIndex());
        if (this.db.on()) {
            this.db.println("getEntityForOchncPath returns this entity index: " + iEntityModel.getEntityIndex());
        }
        return ochncCircuitEnd;
    }

    protected void handleCancel() {
        if (this.db.on) {
            this.db.println("handleCancel: cleaning up");
        }
        this.destroyCircuit();
        this.destroyRelatedCircuits();
        this.close();
        AdminStatePanel.showDropPortsFailure(this, this.getAdminState(), this.numDropPortsNotSet, this.dropPortsNotSet);
    }

    private void close() {
        CcdEndpointsPane ccdEndpointsPane = (CcdEndpointsPane)this.wzPaneMap.get("Source");
        if (ccdEndpointsPane != null) {
            ccdEndpointsPane.close();
        }
        if ((ccdEndpointsPane = (CcdEndpointsPane)this.wzPaneMap.get("Destination")) != null) {
            ccdEndpointsPane.close();
        }
    }

    public void destroyCircuit() {
        this.destinationAdded = false;
        if (this.ckt != null) {
            try {
                this.ckt.destroyCircuit();
                this.ckt = null;
                if (this.db.on) {
                    this.db.println("destroyCircuit: ckt.destroy() succeeded");
                }
            }
            catch (IncorrectCircuitState incorrectCircuitState) {
                this.ckt = null;
            }
            catch (Exception exception) {
                WzDiagDebug.printStackTrace((Throwable)exception);
                ErrorMsg.displayError((Component)this, (EID)NEMC.EID_CIRCUIT_DESTROY_FAILED);
            }
        }
    }

    private void addDestinationIfDropIncremented(Exception exception, int n) {
        this.db.println("Checking for a remant drop, because of this exception:");
        WzDiagDebug.printStackTrace((Throwable)exception);
        int n2 = this.ckt.getDrops().size();
        if (n2 > n) {
            if (this.db.on()) {
                this.db.println("Error in addDestination(), but a remnant drop was added, so mark 'destinationAdded' as true.");
            }
            this.destinationAdded = true;
        }
    }

    protected void addDestination(boolean bl) throws Exception {
        if (this.destinationAdded) {
            if (this.db.on) {
                this.db.println("addDestination: destination already added");
            }
            return;
        }
        if (this.ckt == null || this.isInvalidCircuitState()) {
            this.cancel(false);
            throw new Exception("Circuit creation cannot proceed due to changes in\nthe network, which affected the circuit(s) being created.\n\nThe dialog was closed.  Please try again");
        }
        int n = this.ckt.getDrops().size();
        String string = "???";
        if (this.ckt.getCircuitTypeObj().isLoCircuitType() || this.ckt.getCircuitTypeObj().isHoCircuitType() || this.ckt.getCircuitTypeObj().isVcatCircuitType()) {
            String string2 = "addDestination";
            try {
                if (this.isAutoRoute() && bl) {
                    string = "route";
                    if (this.getAltDest() != null) {
                        this.destDebug(string2, string + "/AltDest");
                        this.ckt.routeDrop(this.getDest(), this.getAltDest(), this.getRoutePrefs());
                    } else {
                        this.destDebug(string2, string + "/Dest");
                        this.ckt.routeDrop(this.getDest(), this.getRoutePrefs());
                    }
                } else {
                    string = "add";
                    this.destDebug(string2, string + "/Dest");
                    this.ckt.addDrop(this.getDest(), this.getRoutePrefs());
                    if (this.getAltDest() != null) {
                        this.destDebug(string2, string + "/AltDest");
                        this.ckt.addDrop(this.getAltDest(), this.getRoutePrefs());
                    }
                }
                this.destinationAdded = true;
            }
            catch (Exception exception) {
                this.addDestinationIfDropIncremented(exception, n);
                throw new AnnotatedException("Unable to " + string + " drop", exception);
            }
            if (this.db.on) {
                this.db.println("addDestination: ckt." + string + "Drop(destEnd, routePrefs) succeeded");
            }
        } else if (this.ckt.getCircuitTypeObj().isEthernetCircuitType() || this.ckt.getCircuitTypeObj().isTunnelCircuitType() || this.ckt.getCircuitTypeObj().isLAPCircuitType()) {
            if (this.getSourceNode() == this.getDestNode()) {
                return;
            }
            int n2 = this.getDestNode().getNodeId();
            INetElement iNetElement = Network.instance().findNetElem(n2);
            if (this.isAutoRoute() && bl) {
                string = "route";
                if (this.getAltDestNode() == null) {
                    this.ckt.routeNetElement(iNetElement, this.getRoutePrefs());
                } else {
                    INetElement iNetElement2 = Network.instance().findNetElem(this.getAltDestNode().getNodeId());
                    if (this.db.on()) {
                        this.db.println("addDestination:  altNe = " + iNetElement2.prettyString());
                    }
                    this.ckt.routeNetElement(iNetElement, iNetElement2, this.getRoutePrefs());
                }
            } else {
                string = "add";
                this.ckt.addNetElement(iNetElement, this.getRoutePrefs());
                if (this.getAltDestNode() != null) {
                    INetElement iNetElement3 = Network.instance().findNetElem(this.getAltDestNode().getNodeId());
                    if (this.db.on()) {
                        this.db.println("addDestination:  altNe = " + iNetElement3.prettyString());
                    }
                    if (iNetElement.getNodeId() != iNetElement3.getNodeId()) {
                        this.ckt.addNetElement(iNetElement3, this.getRoutePrefs());
                    }
                }
            }
            this.destinationAdded = true;
            if (this.db.on) {
                this.db.println("addDestination: ckt." + string + "NetElement(ne) succeeded");
            }
        } else if (this.ckt.getCircuitTypeObj().isOchncType()) {
            int n3 = this.getCircuitInfo().cktOptChannel();
            if (!this.ckt.isBidirectional()) {
                try {
                    RoutePrefs routePrefs;
                    INetCircuitEnd iNetCircuitEnd;
                    int n4 = this.getSourceNode().getNodeId();
                    INetElement iNetElement = Network.instance().findNetElem(n4);
                    if (this.getCircuitInfo().isEnhancedOchnc()) {
                        INetCircuitEnd iNetCircuitEnd2 = this.getEnhancedOchncEndPoint(n3, this.getSource().getNodeModel(), this.getSource().getEntityIndex());
                        iNetCircuitEnd = this.getEnhancedOchncEndPoint(n3, this.getDest().getNodeModel(), this.getDest().getEntityIndex());
                        routePrefs = RoutePrefs.getOchncRoutePrefs(this.getCircuitInfo().cktOptChannel(), iNetElement, iNetCircuitEnd2.getEntityIndex(), iNetCircuitEnd.getEntityIndex());
                    } else {
                        iNetCircuitEnd = this.getOchncEndPoint(this.getCircuitInfo().cktOptChannel(), this.getCircuitInfo().cktOptDir(), 1, false);
                        routePrefs = RoutePrefs.getOchncRoutePrefs(this.getCircuitInfo().cktOptChannel(), this.getCircuitInfo().cktOptDir());
                    }
                    this.ckt.routeDrop(iNetCircuitEnd, routePrefs);
                    this.destinationAdded = true;
                }
                catch (Exception exception) {
                    this.addDestinationIfDropIncremented(exception, n);
                    throw new AnnotatedException("Unable to add and route Drop", exception);
                }
                if (this.db.on) {
                    this.db.println("addDestination: OCHNC uni ckt, add and route Drop succeeded");
                }
            } else {
                RoutePrefs routePrefs;
                INetCircuitEnd iNetCircuitEnd;
                INetCircuitEnd iNetCircuitEnd3;
                Object object;
                this.destroyCircuit();
                int n5 = CircuitOptDir.getOppositeCktOptDir(this.getCircuitInfo().cktOptDir());
                INetCircuitEnd iNetCircuitEnd4 = this.getCircuitInfo().isEnhancedOchnc() ? this.getEnhancedOchncEndPoint(n3, this.getSource().getNodeModel(), this.getSource().getEntityIndex()) : this.getOchncEndPoint(n3, this.getCircuitInfo().cktOptDir(), 0, false);
                if (iNetCircuitEnd4 == null) {
                    throw new Exception("Primary SRC endPoint: the selected Optical Channel is not available");
                }
                if (this.db.on) {
                    this.db.println("Primary SRC endPoint: " + iNetCircuitEnd4.getEntityIndex() + " Ckt direction: " + this.getCircuitInfo().cktOptDir());
                }
                if (this.getCircuitInfo().isEnhancedOchnc()) {
                    object = OchPortsHelper.getReversePort(n3, this.getDest().getEntityModel());
                    iNetCircuitEnd3 = this.getEnhancedOchncEndPoint(n3, object.getNodeModel(), object.getEntityIndex());
                } else {
                    iNetCircuitEnd3 = this.getOchncEndPoint(n3, n5, 0, true);
                }
                if (iNetCircuitEnd3 == null) {
                    throw new Exception("Secondary SRC endPoint: the selected Optical Channel is not available");
                }
                if (this.db.on) {
                    this.db.println("Secondary SRC endPoint: " + iNetCircuitEnd3.getEntityIndex() + " Ckt direction: " + n5);
                }
                this.ckt = NetCircuitFactory.newCircuit(this.getCircuitInfo(), iNetCircuitEnd4, iNetCircuitEnd3);
                object = this.getCircuitInfo().isEnhancedOchnc() ? this.getEnhancedOchncEndPoint(n3, this.getDest().getNodeModel(), this.getDest().getEntityIndex()) : this.getOchncEndPoint(n3, this.getCircuitInfo().cktOptDir(), 1, false);
                if (object == null) {
                    throw new Exception("Primary DST endPoint: the selected Optical Channel is not available");
                }
                if (this.db.on) {
                    this.db.println("Primary DST endPoint: " + object.getEntityIndex() + " Ckt direction: " + this.getCircuitInfo().cktOptDir());
                }
                if (this.getCircuitInfo().isEnhancedOchnc()) {
                    IEntityModel iEntityModel = OchPortsHelper.getReversePort(n3, this.getSource().getEntityModel());
                    iNetCircuitEnd = this.getEnhancedOchncEndPoint(n3, iEntityModel.getNodeModel(), iEntityModel.getEntityIndex());
                } else {
                    iNetCircuitEnd = this.getOchncEndPoint(n3, n5, 1, true);
                }
                if (iNetCircuitEnd == null) {
                    throw new Exception("Secondary DST endPoint: the selected Optical Channel is not available");
                }
                if (this.db.on) {
                    this.db.println("Secondary DST endPoint: " + iNetCircuitEnd.getEntityIndex() + " Ckt direction: " + n5);
                }
                int n6 = this.getSourceNode().getNodeId();
                INetElement iNetElement = Network.instance().findNetElem(n6);
                if (this.getCircuitInfo().isEnhancedOchnc()) {
                    routePrefs = RoutePrefs.getOchncRoutePrefs(n3, iNetElement, iNetCircuitEnd4.getEntityIndex(), object.getEntityIndex(), iNetCircuitEnd3.getEntityIndex(), iNetCircuitEnd.getEntityIndex());
                } else {
                    int n7 = this.getCircuitInfo().cktOptDir();
                    routePrefs = RoutePrefs.getOchncRoutePrefs(n3, n7);
                }
                try {
                    this.ckt.routeDrop((INetCircuitEnd)object, iNetCircuitEnd, routePrefs);
                    this.destinationAdded = true;
                }
                catch (Exception exception) {
                    this.addDestinationIfDropIncremented(exception, n);
                    throw new AnnotatedException("Unable to add and route Drops", exception);
                }
                if (this.db.on) {
                    this.db.println("addDestination: OCHNC bidi ckt, add and route Drops succeeded");
                }
            }
        } else if (this.ckt.getCircuitTypeObj().isOchccCircuitType()) {
            Object object;
            OchccCircuit ochccCircuit = (OchccCircuit)this.ckt;
            this.setOchTrailAttrs(ochccCircuit);
            RoutePrefs routePrefs = new RoutePrefs();
            routePrefs.setCircuitType(this.ckt.getCircuitType());
            routePrefs.setSrc(this.getSource().getNetElement());
            routePrefs.setDst(this.getDest().getNetElement());
            routePrefs.setcktOptChannel(this.ckt.getCircuitOptChannel());
            routePrefs.setcktSrcEntityIndex(this.getSource().getEntityIndex());
            routePrefs.setcktDstEntityIndex(this.getDest().getEntityIndex());
            if (this.getCircuitInfo().getProtectionInfo().isProtected()) {
                routePrefs.setPathProt(1);
            }
            int n8 = this.getAdminState() == 0 ? 3 : 1;
            List list = NetCircuitManager.instance().createOchTrailTunnel(this.ckt, routePrefs, n8);
            if (!list.isEmpty()) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    object = (INetCircuit)iterator.next();
                    this.addRelatedCircuit((INetCircuit)object);
                }
            }
            try {
                if (this.getSource().getEntityModel() instanceof ITdmPortModel) {
                    int n9 = this.getDestNode().getNodeId();
                    object = Network.instance().findNetElem(n9);
                    this.ckt.routeNetElement((INetElement)object, routePrefs);
                    this.destinationAdded = true;
                } else {
                    this.ckt.routeDrop(this.getDest(), routePrefs);
                    this.destinationAdded = true;
                }
            }
            catch (Exception exception) {
                this.addDestinationIfDropIncremented(exception, n);
                throw new AnnotatedException("Unable to add and route Drops", exception);
            }
            if (this.db.on) {
                this.db.println("addDestination: ckt." + string + "NetElement(ne) succeeded");
            }
        } else {
            throw new Exception("addDestination: unexpected circuit type: ");
        }
    }

    private void setOchTrailAttrs(OchccCircuit ochccCircuit) throws AnnotatedException {
        IEntityModel iEntityModel;
        IEntityModel iEntityModel2;
        CircuitCreatInfo circuitCreatInfo = this.getCircuitInfo();
        try {
            iEntityModel2 = this.getSource().getEntityModel();
        }
        catch (ObjNotFound objNotFound) {
            throw new AnnotatedException("Unable to get source Entity Model.", (Exception)((Object)objNotFound));
        }
        try {
            iEntityModel = this.getDest().getEntityModel();
        }
        catch (ObjNotFound objNotFound) {
            throw new AnnotatedException("Unable to get destination Entity Model.", (Exception)((Object)objNotFound));
        }
        if (circuitCreatInfo.getProtectionInfo() != null && circuitCreatInfo.getProtectionInfo().isProtected()) {
            try {
                ochccCircuit.applyReversions(iEntityModel2, iEntityModel, circuitCreatInfo.getProtectionInfo().getRevertiveBehavior());
            }
            catch (Exception exception) {
                throw new AnnotatedException("Unable to set reversion attrs", exception);
            }
        }
        if (circuitCreatInfo.getTrunkInfo() != null) {
            try {
                ochccCircuit.applyTrunkAttrs(iEntityModel2, iEntityModel, circuitCreatInfo.getTrunkInfo());
            }
            catch (Exception exception) {
                throw new AnnotatedException("Unable to set trunk attrs", exception);
            }
        }
    }

    protected void deleteDestination() throws Exception {
        if (!this.destinationAdded) {
            if (this.db.on) {
                this.db.println("deleteDestination: no destination added");
            }
            return;
        }
        if (this.ckt == null || this.isInvalidCircuitState()) {
            this.cancel(false);
            throw new Exception("Circuit creation cannot proceed due to changes in\nthe network, which affected the circuit(s) being created.\n\nThe dialog was closed.  Please try again");
        }
        if (this.ckt.getCircuitTypeObj().isHoCircuitType() || this.ckt.getCircuitTypeObj().isLoCircuitType() || this.ckt.getCircuitTypeObj().isVcatCircuitType()) {
            String string = "deleteDrop";
            this.destDebug(string, "Drop 1");
            this.ckt.deleteDrop(this.getDest());
            if (this.getAltDest() != null) {
                this.destDebug(string, "Drop 2");
                this.ckt.deleteDrop(this.getAltDest());
            }
        } else if (this.ckt.getCircuitTypeObj().isEthernetCircuitType() || this.ckt.getCircuitTypeObj().isTunnelCircuitType() || this.ckt.getCircuitTypeObj().isLAPCircuitType()) {
            if (this.getSourceNode() == this.getDestNode()) {
                return;
            }
            if (this.db.on) {
                this.db.println("deleteDestination: deleting net element");
            }
            int n = this.getDestNode().getNodeId();
            INetElement iNetElement = Network.instance().findNetElem(n);
            this.ckt.deleteNetElement(iNetElement);
            if (this.getAltDestNode() != null) {
                INetElement iNetElement2 = Network.instance().findNetElem(this.getAltDestNode().getNodeId());
                if (this.db.on()) {
                    this.db.println("deleteDestination:  altNe = " + iNetElement2.prettyString());
                }
                if (iNetElement2.getNodeId() != n) {
                    this.ckt.deleteNetElement(iNetElement2);
                }
            }
        } else {
            throw new Exception("deleteDestination: unexpected circuit type");
        }
        this.destinationAdded = false;
    }

    private boolean isInvalidCircuitState() {
        return this.ckt != null && this.ckt.getState() != 0 && this.ckt.getState() != 1;
    }

    private void destDebug(String string, String string2) {
        if (this.db.on()) {
            this.db.println("----- " + string + ", op=" + string2 + " -----");
            if (this.getDest() != null) {
                this.db.println("Dest= " + this.getDest().getNodeModel().getName());
            } else {
                this.db.println("Dest= null");
            }
            if (this.getAltDest() != null) {
                this.db.println("AltDest= " + this.getDest().getNodeModel().getName());
            } else {
                this.db.println("AltDest= null");
            }
            this.db.println("circuit info so far:");
            if (this.ckt != null) {
                this.ckt.prettyPrint(this.db);
            } else {
                this.db.println("null!");
            }
            this.db.println("route prefs so far:");
            this.db.println(this.getRoutePrefs().prettyString());
            this.db.println("----- " + string + ", end. -----");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void apply() throws Exception {
        this.destDebug("apply()", "before apply");
        if (this.isPca() && this.ckt.isNonRevertivePca() && this.circuitNumber == 1 && !CerentDialog.yesNoDialog((Component)this, (String)("This PCA circuit is on a non-revertive " + CircuitMapUtil.BLSR_TERM + "." + "\nThe circuit may be pre-empted indefinitely.\n\n" + "OK to continue?"), (String)("Non-Revertive " + CircuitMapUtil.BLSR_TERM))) {
            this.stopDriver = true;
            this.destroyCircuit();
            return;
        }
        try {
            Object object;
            String string;
            if (this.uiToolkit != null) {
                this.uiToolkit.setCursor(3);
            }
            if ((string = this.currentWzPane.getName()).equals("Destination") && this.isVlanCapable()) {
                try {
                    this.ckt.assignVlanSet(new IVlanModel[]{VlanSetManager.instance().defaultVlan()});
                    this.ckt.createWithStpEnabled(true);
                }
                catch (Exception exception) {
                    throw new AnnotatedException("Unable to assign default VLAN to circuit", exception);
                }
            }
            try {
                if (!this.getPortGrouping() && this.ckt != null) {
                    this.ckt.sanityCheck();
                }
                if (this.db.on) {
                    this.db.println("apply: ckt.sanityCheck() succeeded");
                }
            }
            catch (Exception exception) {
                throw new AnnotatedException("Circuit sanity check failed", exception);
            }
            if (!this.ckt.getCircuitTypeObj().isOchncType() && !this.ckt.getCircuitTypeObj().isOchccCircuitType()) {
                this.ckt.setUpsrSelectorAttributes(this.getUpsrReversion(), (short)this.getUpsrSfBerLevel().getIntValue(), (short)this.getUpsrSdBerLevel().getIntValue(), this.getUpsrSwitchOnPdip());
            }
            try {
                if (!this.getPortGrouping() && this.ckt != null) {
                    if (this.db.on) {
                        this.db.println("The circuit before provision:");
                        this.ckt.prettyPrint(this.db);
                    }
                    if (this.isVcatType()) {
                        object = ProgressDialog.start(this, "Circuit Provision", "Circuits are being created.  Please wait...", this, 2000, 10, false, false);
                        Exception exception = ((ProgressDialog)object).getResultException();
                        if (exception != null) {
                            throw exception;
                        }
                    } else {
                        this.ckt.provision();
                    }
                    if (this.db.on) {
                        this.db.println("apply: ckt.provision() succeeded");
                    }
                }
                if (this.ckt != null) {
                    this.destDebug("apply()", "after provision");
                }
            }
            catch (Exception exception) {
                block31: {
                    if (this.db.on && this.ckt != null) {
                        this.db.println("Circuit provision failed, here is the circuit:");
                        this.ckt.prettyPrint(this.db);
                    }
                    if (string.equals("Destination")) {
                        try {
                            this.deleteDestination();
                        }
                        catch (Exception exception2) {
                            if (!this.db.on()) break block31;
                            WzDiagDebug.printStackTrace((Throwable)exception2);
                        }
                    }
                }
                throw new AnnotatedException("Unable to provision circuit", exception);
            }
            if (NetAdminState.circuitAllowsStateApplicationToDrops(this.ckt) && this.applyDropPorts && !this.getPortGrouping()) {
                object = new ArrayList();
                if (!NetCircuitModel.setAdminStateOnDropPorts(this.ckt, this.getPortsState(), (ArrayList)object)) {
                    ++this.numDropPortsNotSet;
                    AdminStatePanel.buildDropPortsNotSet(this.ckt, (ArrayList)object, this.dropPortsNotSet);
                }
            }
            if (this.getPortGrouping()) {
                object = PortGrouping.getInstance();
                ((PortGrouping)((Object)object)).initForCreation(this.getCircuitName(), this.getPgEnd(), this.getDestPgEnd(), this.getRoutePrefs(), this.getUpsrReversion(), (short)this.getUpsrSfBerLevel().getIntValue(), (short)this.getUpsrSdBerLevel().getIntValue(), this.getUpsrSwitchOnPdip(), this.getPortsState(), this.applyDropPorts, this.getUpsrGoReturnRouting());
                this.destroyCircuit();
            } else {
                this.ckt = null;
            }
            this.clearRelatedCircuits();
        }
        finally {
            if (this.uiToolkit != null) {
                this.uiToolkit.setCursor(0);
            }
        }
    }

    private void terminate() {
        ErrorMsg.displayError((Component)this, (EID)NEMC.EID_CHANGES_NET_CKT_ERROR);
        this.cancel(false);
    }

    public void finish() {
        if (this.ckt == null || this.isInvalidCircuitState()) {
            this.terminate();
            return;
        }
        super.finish();
    }

    protected void handleFinish() {
        if (this.currentWzPane != null && this.currentWzPane instanceof WzCcdPane) {
            if (this.db.on()) {
                this.db.fine("WzCcdPane's handleFinish() for " + this.currentWzPane.getName());
            }
            ((WzCcdPane)this.currentWzPane).handleFinish();
        }
        if (this.circuitNumber++ < this.circuitCount && !this.stopDriver) {
            if (this.autoRange) {
                int n = this.circuitCount - this.circuitNumber + 1;
                Autoranger autoranger = new Autoranger(this.arInfo, n, 2);
                if (this.applyDropPorts) {
                    autoranger.setAdminStateOnDrops(true);
                }
                ProgressDialog.start(this, "Autoranged Circuit Progress", "Autoranged Circuit Progress", autoranger, true);
                DetailedLog detailedLog = autoranger.getAutoRangeLog();
                if (detailedLog != null) {
                    int n2 = detailedLog.getChildCount();
                    if (n2 == 0) {
                        CerentDialog.infoDialog((Component)this, (String)("All " + this.circuitCount + " circuits were successfully " + "created."), (String)"Circuit Autorange Complete.");
                    } else {
                        CerentDialog.errorDialog((Component)this, (String)ErrorMsg.getString((EID)NEMC.EID_COULD_NOT_AUTORANGE_ALL_CIRCUITS_PARAM_2, (Object)String.valueOf(n2), (Object)String.valueOf(this.circuitCount)), (String)"Circuit Autorange Complete", (DetailedLog)detailedLog, (boolean)false);
                    }
                }
                this.numDropPortsNotSet += autoranger.getAdminStateOnDropsFailures();
                this.dropPortsNotSet.append(autoranger.getAdminStateOnDropsString());
                AdminStatePanel.showDropPortsFailure(this, this.getPortsState(), this.numDropPortsNotSet, this.dropPortsNotSet);
                super.handleFinish();
            } else {
                Iterator iterator = this.wzPaneMap.keySet().iterator();
                while (iterator.hasNext()) {
                    Object k = iterator.next();
                    WzPane wzPane = (WzPane)this.wzPaneMap.get(k);
                    if (!(wzPane instanceof CcdCircuitDesignPane)) continue;
                    if (this.db.on()) {
                        this.db.info("finished circuit, resetting " + wzPane.getName());
                    }
                    ((CcdCircuitDesignPane)wzPane).recycle();
                }
                this.popEntireStack();
            }
        } else {
            AdminStatePanel.showDropPortsFailure(this, this.getPortsState(), this.numDropPortsNotSet, this.dropPortsNotSet);
            super.handleFinish();
        }
    }

    public boolean handleFinishException(Exception exception) {
        Object[] objectArray;
        if (exception instanceof AnnotatedException) {
            objectArray = (Object[])exception;
            exception = objectArray.getChild();
        }
        if (exception instanceof VlanStpSanityCheckFailed) {
            objectArray = new String[]{"View Table", "Close"};
            int n = CerentDialog.errorDialog((Component)this, (String)VLANSTPVIOLATION_MSG, (String)"VLAN/Spanning Tree Violation", (Object[])objectArray, (Object)objectArray[0]);
            if (n == 0) {
                VlanStpSanityCheckFailed vlanStpSanityCheckFailed = (VlanStpSanityCheckFailed)exception;
                IVlanModel[] iVlanModelArray = this.ckt.getVlans();
                VlanStpDialog vlanStpDialog = new VlanStpDialog((Dialog)this, vlanStpSanityCheckFailed.getNodeModel(), iVlanModelArray);
                vlanStpDialog.show();
            }
            return true;
        }
        return super.handleFinishException(exception);
    }

    AutorangeInfo getAutorangeInfo() {
        return this.arInfo;
    }

    public String getResultString(Exception exception) {
        throw new DeprecatedMethodCalled("ProgressDialogControl.getResultString(Exception)");
    }

    public ProgressDialogResult getResult(Exception exception) {
        ProgressDialogResult progressDialogResult = null;
        if (this.isVcatType()) {
            return progressDialogResult;
        }
        progressDialogResult = exception == null ? new ProgressDialogResult("Successfully created " + this.circuitCount + " circuits") : new ProgressDialogResult(2, NEMC.EID_CHANGES_NET_CKT_ERROR, new String[]{exception.getMessage()});
        return progressDialogResult;
    }

    public void executeTask(Observer observer) throws Exception {
        if (this.ckt != null && this.isVcatType()) {
            this.ckt.provision();
            Iterator iterator = this.getRelatedCircuitList().iterator();
            while (iterator.hasNext()) {
                INetCircuit iNetCircuit = (INetCircuit)iterator.next();
                try {
                    iNetCircuit.destroySanityCheck();
                }
                catch (SanityCheckFailed sanityCheckFailed) {
                    continue;
                }
                iNetCircuit.destroyCircuit();
                this.removeRelatedCircuit(iNetCircuit);
            }
        }
    }

    public void stop() {
    }

    public void suspend() {
    }

    public void resume() {
    }

    public boolean stopRequired() {
        return false;
    }

    public String getDiagString() {
        StringBuffer stringBuffer = new StringBuffer(super.getDiagString());
        stringBuffer.append("Destination Added: " + this.destinationAdded + "\n");
        stringBuffer.append("Apply Drop Ports: " + this.applyDropPorts + "\n");
        stringBuffer.append("TL1 Like Default: " + this.isCircuitTL1Compatible() + "\n");
        stringBuffer.append("Num Drop Ports Not Set: " + this.numDropPortsNotSet + "\n");
        stringBuffer.append("DropPortsNotSet Info:\n");
        stringBuffer.append(this.dropPortsNotSet.toString() + "\n");
        stringBuffer.append("Stop Driver: " + this.stopDriver + "\n");
        return stringBuffer.toString();
    }

    static {
        tl1LikeDefaultInited = false;
    }
}

