/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.Attribute;
import cerent.cms.model.CircuitMergeManager;
import cerent.cms.model.Feature;
import cerent.cms.model.INodeModel;
import cerent.cms.model.circuits.NetCircuitModel;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.IncorrectCircuitState;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.AbstractTabbedView;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.NetworkDefaults;
import cerent.cms.ui.Pane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.circuits.CedCircuitStatePane;
import cerent.cms.ui.circuits.CedDropPane;
import cerent.cms.ui.circuits.CedGeneralPane;
import cerent.cms.ui.circuits.CedMergePane;
import cerent.cms.ui.circuits.CedMonitorPane;
import cerent.cms.ui.circuits.CedNodePane;
import cerent.cms.ui.circuits.CedUpsrPane;
import cerent.cms.ui.circuits.CedUpsrPmPane;
import cerent.cms.ui.circuits.CedVcatMembersPane;
import cerent.cms.ui.circuits.CedVlanPane;
import cerent.cms.ui.circuits.CircuitEditDialog;
import cerent.cms.ui.circuits.CircuitMapUtil;
import cerent.cms.ui.circuits.TunnelCircuitsPane;
import cerent.util.EID;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;

public class CircuitEditTabbedView
extends AbstractTabbedView {
    public static final String GENERAL_TAB = "General";
    public static final String DROP_TAB = "Drops";
    public static final String NODE_TAB = "Nodes";
    public static final String VLAN_TAB = "VLANs";
    public static final String MONITOR_TAB = "Monitors";
    public static final String STATE_TAB = "State";
    public static final String MEMBERS_TAB = "Members";
    public static final String MERGE_TAB = "Merge";
    public static final String TUNNELED_CKT_TAB = "Tunneled Circuits";
    protected TDMTerminology tdmTerm;
    private String UPSR_TERM;
    public final String UPSR_TAB;
    public final String UPSR_PM_TAB;
    private INetCircuit currentCircuit;
    private CircuitEditDialog ced;
    private static final SDebug db = new SDebug("CircuitEditTabbedView");

    public CircuitEditTabbedView(INetCircuit iNetCircuit, CircuitEditDialog circuitEditDialog) throws NullPointerException, UnsupportedOperationException {
        super(new NetCircuitModel(iNetCircuit));
        this.ced = circuitEditDialog;
        this.currentCircuit = iNetCircuit;
        if (this.currentCircuit == null) {
            throw new NullPointerException("CircuitEditTabbedView: circuit is null");
        }
        this.tdmTerm = CircuitMapUtil.getTDMTerminology(this.currentCircuit);
        this.UPSR_TERM = this.tdmTerm.getRingTerms(0);
        this.UPSR_TAB = this.UPSR_TERM + " Selectors";
        this.UPSR_PM_TAB = this.UPSR_TERM + " Switch Counts";
        if (db.on()) {
            db.println("Editing circuit " + this.currentCircuit.getCircuitName());
        }
        if (db.on()) {
            db.println("\tAdding general tab.");
        }
        this.addGeneralEditTab();
        if (db.on()) {
            db.println("\tAdded general tab.");
        }
        boolean bl = false;
        try {
            bl = this.currentCircuit.isVlanCapable();
        }
        catch (IncorrectCircuitState incorrectCircuitState) {
            // empty catch block
        }
        if (this.currentCircuit.getCircuitTypeObj().isEthernetCircuitType()) {
            if (db.on()) {
                db.println("\tAdding drop/node tab.");
            }
            this.addDropTab();
            this.addNodeTab();
            if (db.on()) {
                db.println("\tAdded drop/node tab.");
            }
        } else if (this.currentCircuit.getCircuitTypeObj().isHoCircuitType() || this.currentCircuit.getCircuitTypeObj().isLoCircuitType()) {
            if (this.currentCircuit.getCircuitDir() == 0) {
                if (db.on()) {
                    db.println("\tAdding drop tab.");
                }
                this.addDropTab();
                if (db.on()) {
                    db.println("\tAdded drop tab.");
                }
            } else if (!bl && this.currentCircuit.supportsMonitorCircuits()) {
                if (db.on()) {
                    db.println("\tAdding monitor tab.");
                }
                this.addMonitorTab();
                if (db.on()) {
                    db.println("\tAdded monitor tab.");
                }
            }
        } else if (this.currentCircuit.getCircuitTypeObj().isTunnelCircuitType()) {
            this.addTunneledCircuitsTab();
        } else if (!(this.currentCircuit.getCircuitTypeObj().isOchncType() || this.currentCircuit.getCircuitTypeObj().isOchTrailTunnelCircuitType() || this.currentCircuit.getCircuitTypeObj().isOchccCircuitType() || this.currentCircuit.getCircuitTypeObj().isLAPCircuitType())) {
            if (this.currentCircuit.getCircuitTypeObj().isVcatCircuitType()) {
                this.addVcatMembersTab();
            } else {
                throw new UnsupportedOperationException("CircuitEditTabbedView: unsupported circuit type");
            }
        }
        if (this.hasUpsrSelectors()) {
            if (db.on()) {
                db.println("\tAdding upsr tab.");
            }
            if (!this.currentCircuit.getCircuitTypeObj().isVcatCircuitType()) {
                this.addUpsrTabs();
            }
            if (db.on()) {
                db.println("\tAdded general tab.");
            }
        }
        if (bl) {
            if (db.on()) {
                db.println("\tAdding vlan tab.");
            }
            this.addVlanTab();
            if (db.on()) {
                db.println("\tAdded vlan tab.");
            }
        }
        if (!this.currentCircuit.getCircuitTypeObj().isEthernetCircuitType()) {
            if (db.on()) {
                db.println("\tAdding connstate tab.");
            }
            this.addConnsStateTab();
            if (db.on()) {
                db.println("\tAdded connstate tab.");
            }
        }
        if (this.qualifyForMergeMaster()) {
            if (db.on()) {
                db.println("\tAdding MERGE tab.");
            }
            this.addMergeTab();
            if (db.on()) {
                db.println("\tAdded MERGE tab.");
            }
        }
    }

    boolean hasUpsrSelectors() {
        List list = this.currentCircuit.getCircuitNodes();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            INetCircuitNode iNetCircuitNode = (INetCircuitNode)iterator.next();
            if (!iNetCircuitNode.isUpsrSelector()) continue;
            return true;
        }
        return false;
    }

    private boolean qualifyForMergeMaster() {
        CircuitMergeManager.instance();
        return CircuitMergeManager.qualifyForMergeMaster(this.currentCircuit);
    }

    private void addDropTab() {
        if (this.currentCircuit.getState() != 8) {
            this.addTab(DROP_TAB, (Component)((Object)new CedDropPane(DROP_TAB, this)));
        }
    }

    private void addNodeTab() {
        this.addTab(NODE_TAB, (Component)((Object)new CedNodePane(NODE_TAB, this)));
    }

    private void addMonitorTab() {
        if (!this.monitorDisallowedOnAllNodes() && this.currentCircuit.getState() != 8) {
            this.addTab(MONITOR_TAB, (Component)((Object)new CedMonitorPane(MONITOR_TAB, this)));
        }
    }

    private boolean monitorDisallowedOnAllNodes() {
        Iterator iterator = this.currentCircuit.getCircuitNodes().iterator();
        while (iterator.hasNext()) {
            INetCircuitNode iNetCircuitNode = (INetCircuitNode)iterator.next();
            if (Feature.provides((INodeModel)iNetCircuitNode.getNodeModel(), (Feature)Feature.NO_MONITORS)) continue;
            return false;
        }
        return true;
    }

    private void addConnsStateTab() {
        this.addTab(STATE_TAB, (Component)((Object)new CedCircuitStatePane(STATE_TAB, this)));
    }

    private void addUpsrTabs() {
        this.addTab(this.UPSR_TAB, (Component)((Object)new CedUpsrPane(this.UPSR_TAB, this)));
        this.addTab(this.UPSR_PM_TAB, (Component)((Object)new CedUpsrPmPane(this.UPSR_PM_TAB, this)));
    }

    private void addGeneralEditTab() {
        this.addTab(GENERAL_TAB, (Component)((Object)new CedGeneralPane(GENERAL_TAB, this)));
    }

    private void addVlanTab() {
        this.addTab(VLAN_TAB, (Component)((Object)new CedVlanPane(VLAN_TAB, this, this.ced)));
    }

    private void addVcatMembersTab() {
        this.addTab(MEMBERS_TAB, (Component)((Object)new CedVcatMembersPane(MEMBERS_TAB, this)));
    }

    private void addMergeTab() {
        this.addTab(MERGE_TAB, (Component)((Object)new CedMergePane(this)));
    }

    private void addTunneledCircuitsTab() {
        this.addTab(TUNNELED_CKT_TAB, (Component)((Object)new TunnelCircuitsPane(this, this.currentCircuit)));
    }

    protected Attribute[] getAttributes(String string) {
        return NetworkDefaults.getAttributeMap().getAttributeArray(string);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        return new Dimension(500, 210);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        super.stateChanged(changeEvent);
        Pane pane = this.getCurrentPane();
        if (pane != null && pane instanceof AbstractPane && this.ced != null) {
            AbstractPane abstractPane = (AbstractPane)pane;
            JTable jTable = abstractPane.getTable();
            this.ced.updatePrintableTable(jTable);
            CSHelpID cSHelpID = this.getPaneHelpID(pane);
            if (cSHelpID == null) {
                this.ced.enableHelp(false);
            } else {
                this.ced.enableHelp(true);
            }
        }
    }

    public INetCircuit[] getSelectedVcatCircuits() {
        if (this.getCurrentPane() instanceof CedVcatMembersPane) {
            return ((CedVcatMembersPane)this.getCurrentPane()).getSelectedCircuits();
        }
        return new INetCircuit[0];
    }

    public String getSelectedTitle() {
        int n = this.getSelectedIndex();
        if (n == -1) {
            return GENERAL_TAB;
        }
        return this.getTitleAt(n);
    }

    public boolean gotoTitle(String string) {
        int n = this.indexOfTab(string);
        if (n == -1) {
            return false;
        }
        this.setSelectedIndex(n);
        return true;
    }

    public CSHelpID getHelpID() {
        return this.getPaneHelpID(this.getCurrentPane());
    }

    private CSHelpID getPaneHelpID(Pane pane) {
        if (pane instanceof CedGeneralPane) {
            return NetCSHelpConst.CedGeneralPane;
        }
        if (pane instanceof CedMonitorPane) {
            return NetCSHelpConst.CedMonitorPane;
        }
        if (pane instanceof CedNodePane) {
            return NetCSHelpConst.CedNodePane;
        }
        if (pane instanceof CedUpsrPane) {
            return NetCSHelpConst.CedUpsrPane;
        }
        if (pane instanceof CedUpsrPmPane) {
            return NetCSHelpConst.CedUpsrPmPane;
        }
        if (pane instanceof CedVlanPane) {
            return NetCSHelpConst.CedVlanPane;
        }
        if (pane instanceof CedDropPane) {
            return NetCSHelpConst.CedDropPane;
        }
        if (pane instanceof CedCircuitStatePane) {
            return NetCSHelpConst.CedCircuitStatePane;
        }
        if (pane instanceof CedVcatMembersPane) {
            return NetCSHelpConst.CedVcatMembersPane;
        }
        if (pane instanceof CedMergePane) {
            return NetCSHelpConst.CedMergePane;
        }
        if (pane instanceof TunnelCircuitsPane) {
            return NetCSHelpConst.TunnelCircuitsPane;
        }
        return null;
    }

    public void displayErrorDialog(TabbedView tabbedView, Exception exception, EID eID) {
    }

    void postAddUpsrTabs() {
        boolean bl;
        boolean bl2 = this.indexOfTab(VLAN_TAB) != -1;
        boolean bl3 = this.indexOfTab(STATE_TAB) != -1;
        boolean bl4 = this.indexOfTab(MERGE_TAB) != -1;
        boolean bl5 = bl = this.indexOfTab(this.UPSR_TAB) == -1 && this.indexOfTab(this.UPSR_PM_TAB) == -1;
        if (bl) {
            if (bl2) {
                this.removeTab(VLAN_TAB);
            }
            if (bl3) {
                this.removeTab(STATE_TAB);
            }
            if (bl4) {
                this.removeTab(MERGE_TAB);
            }
            this.addUpsrTabs();
            if (bl2) {
                this.addVlanTab();
            }
            if (bl3) {
                this.addConnsStateTab();
            }
            if (bl4) {
                this.addMergeTab();
            }
        } else if (db.on()) {
            db.println("Request to add UPSR tabs; already present.");
        }
    }

    void postRemoveUpsrTabs() {
        int n = this.indexOfTab(this.UPSR_TAB);
        if (n != -1) {
            this.removeTab(this.UPSR_TAB);
        }
        if ((n = this.indexOfTab(this.UPSR_PM_TAB)) != -1) {
            this.removeTab(this.UPSR_PM_TAB);
        }
        if (db.on()) {
            db.println("Request to remove UPSR tabs.");
        }
    }

    public void upsrUpdate() {
        if (SwingUtilities.isEventDispatchThread()) {
            new UpsrUpdater(this).run();
        } else {
            SwingUtilities.invokeLater(new UpsrUpdater(this));
        }
    }

    private class UpsrUpdater
    implements Runnable {
        CircuitEditTabbedView ctv;

        public UpsrUpdater(CircuitEditTabbedView circuitEditTabbedView2) {
            this.ctv = circuitEditTabbedView2;
        }

        public void run() {
            Pane pane = this.ctv.getCurrentPane();
            if (this.ctv.hasUpsrSelectors()) {
                CircuitEditTabbedView.this.postAddUpsrTabs();
            } else {
                CircuitEditTabbedView.this.postRemoveUpsrTabs();
                if (pane instanceof CedUpsrPane || pane instanceof CedUpsrPmPane) {
                    this.ctv.setSelectedIndex(CircuitEditTabbedView.this.indexOfTab(CircuitEditTabbedView.GENERAL_TAB));
                }
            }
            if (pane instanceof CedMergePane) {
                this.ctv.setSelectedIndex(CircuitEditTabbedView.this.indexOfTab(CircuitEditTabbedView.MERGE_TAB));
            }
        }
    }
}

