/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.AbstractCmsNoSuchElementException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractLinkModel;
import cerent.cms.model.Attribute;
import cerent.cms.model.Feature;
import cerent.cms.model.HoPathDefModel;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IDwdmPortModel;
import cerent.cms.model.IElementModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.IHoPathDefModel;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.ILinkModel;
import cerent.cms.model.ILoAditModel;
import cerent.cms.model.ILoDefModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOchccPathDefModel;
import cerent.cms.model.IYCableModel;
import cerent.cms.model.NoSuchEquipment;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.OchPortsHelper;
import cerent.cms.model.OchTrailHelper;
import cerent.cms.model.UpsrSelector;
import cerent.cms.ncp.DualConnectionCircuitNode;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitDropInfo;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.INetCircuitSpan;
import cerent.cms.ncp.IUpsrOps;
import cerent.cms.ncp.LoCircuitEnd;
import cerent.cms.ncp.LoTunnelNode;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuit;
import cerent.cms.ncp.NetCircuitDropInfo;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.NetCircuitSpanFactory;
import cerent.cms.ncp.NetRoll;
import cerent.cms.ncp.OchccCircuit;
import cerent.cms.ncp.OchncCircuit;
import cerent.cms.ncp.RollManager;
import cerent.cms.route.INetLinkSpan;
import cerent.cms.route.NetLinkSpan;
import cerent.cms.topo.AbstractNetLink;
import cerent.cms.topo.CompositeNetLink;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.NetLink;
import cerent.cms.topo.Network;
import cerent.cms.topo.NonRoutableNetLink;
import cerent.cms.topo.OchTrailTunnelNetLink;
import cerent.cms.topo.VirtualNetLink;
import cerent.cms.ui.NetworkDefaults;
import cerent.cms.ui.circuits.AbstractCircuitMap;
import cerent.cms.ui.circuits.CircuitDropCreationDialog;
import cerent.cms.ui.circuits.CircuitEditDialog;
import cerent.cms.ui.circuits.CircuitEndCellRenderer;
import cerent.cms.ui.circuits.CircuitMapFactory;
import cerent.cms.ui.circuits.CircuitMapUtil;
import cerent.cms.ui.circuits.OchTrailProtectedCircuitMapNode;
import cerent.cms.ui.network.CircuitExternalMapLink;
import cerent.cms.ui.network.CircuitExternalMapLinkCookie;
import cerent.cms.ui.network.CircuitExternalMapNode;
import cerent.cms.ui.network.CircuitMapLine;
import cerent.cms.ui.network.CircuitMapLink;
import cerent.cms.ui.network.CircuitMapLinkCookie;
import cerent.cms.ui.network.CircuitMapNode;
import cerent.cms.ui.network.CircuitMapNodeCookie;
import cerent.cms.ui.network.CircuitMapPort;
import cerent.cms.ui.network.CircuitMapPortCookie;
import cerent.cms.ui.network.CircuitMapSelector;
import cerent.cms.ui.network.NetMapLink;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.EventMaskUtil;
import cerent.util.HoLoComparator;
import cerent.util.IDebugDiag;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import cerent.util.IObservable;
import cerent.util.KDebug;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.gui.ActionOrganizer;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UPopupMenu;
import com.cisco.ctc.util.map.AbstractInternalPG;
import com.cisco.ctc.util.map.DetailedMapLink;
import com.cisco.ctc.util.map.DetailedMapLinkStyle;
import com.cisco.ctc.util.map.DetailedMapNode;
import com.cisco.ctc.util.map.ExternalMapKey;
import com.cisco.ctc.util.map.MapGraph;
import com.cisco.ctc.util.map.MapGraphicsUtil;
import com.cisco.ctc.util.map.MapLink;
import com.cisco.ctc.util.map.MapNode;
import com.cisco.ctc.util.map.MapPort;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public class CircuitMap
extends AbstractCircuitMap {
    private CircuitMapDebug db;
    public boolean LOT_FLAG = false;
    public boolean DWDM_FLAG = false;
    public boolean OCHNC_FLAG = false;
    private static Attribute[] switchStates;
    private static final String GENERIC_DRI_STRING = "DRI";
    private static final String PRIMARY_DRI_STRING = "DRI (Primary)";
    private static final String SECONDARY_DRI_STRING = "DRI (Secondary)";
    private static final String INTERMEDIATE_DRI_STRING = "DRI (Intermediate)";
    private INetCircuit netCircuit;
    private boolean nodesComplete;
    private ArrayList spanList = new ArrayList();
    private ArrayList buildList;
    private static final String CMD_PORT_ADDDROP = "Add Drop";
    private static final String CMD_PORT_REMOVEDROP = "Remove Drop";
    private CircuitEditDialog ced;
    private HashSet registeredDialogSet = new HashSet();
    private ArrayList relatedCircuitsList = new ArrayList();
    private boolean linkAcceptableOverride = false;
    private boolean alreadyCentered = false;
    private MapNode popupMapNode;
    private MapPort popupMapPort;

    public CircuitMap(SDebug sDebug, CircuitEditDialog circuitEditDialog) {
        super(sDebug, 0, CircuitMapFactory.instance());
        this.db = new CircuitMapDebug(sDebug);
        this.ced = circuitEditDialog;
        this.nodesComplete = false;
        if (switchStates == null) {
            try {
                switchStates = NetworkDefaults.getAttributeMap().getAttributeArray("protectionOpApsClear");
            }
            catch (Exception exception) {
                this.db.finer("Exception in CircuitMap() " + exception);
            }
        }
    }

    public void domainRemoved(MapNode mapNode) {
        if (this.isDetailed() && this.netCircuit != null) {
            this.traceDetailedCircuit(this.netCircuit, this.LOT_FLAG, this.DWDM_FLAG, this.OCHNC_FLAG);
        }
    }

    public void nodeDomainChanged(MapNode mapNode, String string, String string2) {
        if (this.isDetailed() && this.netCircuit != null) {
            this.traceDetailedCircuit(this.netCircuit, this.LOT_FLAG, this.DWDM_FLAG, this.OCHNC_FLAG);
        }
    }

    protected boolean updateCreatesNew() {
        return this.nodesComplete;
    }

    public static boolean hasCompositeNetLink(INetCircuit iNetCircuit) {
        Iterator iterator = iNetCircuit.getCircuitSpans().iterator();
        while (iterator.hasNext()) {
            INetLink iNetLink = ((INetCircuitSpan)iterator.next()).getLink();
            if (iNetLink instanceof CompositeNetLink) {
                return true;
            }
            if (!iNetLink.isLOTunnel()) continue;
            Iterator iterator2 = new HashSet(iNetLink.getLinksList()).iterator();
            while (iterator2.hasNext()) {
                if (!(iterator2.next() instanceof CompositeNetLink)) continue;
                return true;
            }
        }
        return false;
    }

    public void registerDialog(JDialog jDialog) {
        if (jDialog != null) {
            this.registeredDialogSet.add(jDialog);
            if (this.db.on()) {
                this.db.println("registered dialog: " + jDialog.getTitle());
            }
        }
    }

    public void deregisterDialog(JDialog jDialog) {
        if (jDialog != null && this.registeredDialogSet.contains(jDialog)) {
            this.registeredDialogSet.remove(jDialog);
            if (this.db.on()) {
                this.db.println("deregistered dialog: " + jDialog.getTitle());
            }
        }
    }

    private void expandLogicalLink(INetCircuitSpan iNetCircuitSpan, int n, INetLink iNetLink, boolean bl, boolean bl2, boolean bl3) {
        Object object;
        IEntityModel[] iEntityModelArray;
        INodeModel iNodeModel;
        Object object2;
        Object object3;
        Iterator iterator = null;
        if (bl2 && iNetLink instanceof CompositeNetLink) {
            bl2 = true;
            iterator = ((CompositeNetLink)iNetLink).getLinks().iterator();
            this.buildList.add("expandLogicalLink logicalLink = " + iNetLink);
        } else if (!bl && iNetLink.isLOTunnel()) {
            object3 = iNetLink.getLinkModel();
            object2 = object3.dst();
            iNodeModel = object3.src();
            iEntityModelArray = CircuitMapUtil.getCircuitEnd(iNodeModel, object3.srcEntityIndex(), iNetCircuitSpan.getSrcHoNum(), iNetCircuitSpan.getLoNum());
            INetCircuit iNetCircuit = this.findLotTunnel((NetCircuitEnd)iEntityModelArray, (NetCircuitEnd)(object = CircuitMapUtil.getCircuitEnd(object2, object3.dstEntityIndex(), iNetCircuitSpan.getDstHoNum(), iNetCircuitSpan.getLoNum())));
            if (iNetCircuit != null) {
                this.relatedCircuitsList.add(iNetCircuit);
            }
            iterator = new HashSet(iNetLink.getLinksList()).iterator();
            this.buildList.add("expandLogicalLink LOTunnel = " + iNetLink);
            this.buildList.add("expandLogicalLink LOCkt = " + iNetCircuit);
            if (iNetCircuit != null) {
                this.buildList.add("expandLogicalLink LOCktName = " + iNetCircuit.getCircuitName());
            }
        } else if (bl3 && iNetLink instanceof OchTrailTunnelNetLink) {
            object3 = this.findOchTrailTunnel(iNetLink);
            if (object3 != null) {
                this.relatedCircuitsList.add(object3);
            }
            iterator = new HashSet(iNetLink.getLinksList()).iterator();
            this.buildList.add("expandLogicalLink OTTLink = " + iNetLink);
            this.buildList.add("expandLogicalLink OTTCkt = " + object3);
            if (object3 != null) {
                this.buildList.add("expandLogicalLink OTTCktName = " + object3.getCircuitName());
            }
        } else if (!bl && iNetLink.isLAP()) {
            object3 = this.findLAP(iNetLink);
            if (object3 != null) {
                this.relatedCircuitsList.add(object3);
            }
            iterator = new HashSet(iNetLink.getLinksList()).iterator();
            this.buildList.add("expandLogicalLink LAP = " + iNetLink);
            this.buildList.add("expandLogicalLink LOCkt = " + object3);
            if (object3 != null) {
                this.buildList.add("expandLogicalLink LOCktName = " + object3.getCircuitName());
            }
        }
        if (iterator == null) {
            return;
        }
        while (iterator.hasNext()) {
            object3 = (INetLink)iterator.next();
            this.buildList.add("expandLogicalLink: true path = " + object3);
            if (!bl2 && object3 instanceof CompositeNetLink) {
                this.expandLogicalLink(iNetCircuitSpan, n, (INetLink)object3, true, bl2, bl3);
                continue;
            }
            object2 = this.getDirectionalMapLink((INetLink)object3);
            if (object2 != null) {
                this.setNetMapLinkState("expandLogicalLink()", (MapLink)object2, n);
            } else {
                this.addLink((INetLink)object3, iNetLink);
            }
            if (object3.getProtectionType() != 7) continue;
            if (this.db.on()) {
                this.db.println("expandLogicalLink: Link has a YCable protection  trying to set color to the protect link ");
            }
            try {
                iNodeModel = this.getYCableProtectPort((INetLink)object3);
                if (iNodeModel != null) {
                    iEntityModelArray = null;
                    iEntityModelArray = OchTrailHelper.getTrunkPorts((IEntityModel)iNodeModel);
                    if (iEntityModelArray != null && iEntityModelArray.length > 0) {
                        object = Network.instance().findNetElem(iEntityModelArray[0].getNodeModel());
                        int n2 = iEntityModelArray[0].getEntityIndex();
                        INetLink iNetLink2 = Network.instance().findNetLinkFromEnt((INetElement)object, n2, true);
                        if (iNetLink2 != null) {
                            object2 = this.getDirectionalMapLink(iNetLink2);
                            int n3 = iNetLink2.getLinkModel().state() == 1 ? 4 : 1;
                            this.setNetMapLinkState("expandLogicalLink()", (MapLink)object2, n3);
                            continue;
                        }
                        if (!this.db.on()) continue;
                        this.db.println("expandLogicalLink: Protect Link not found.");
                        continue;
                    }
                    if (!this.db.on()) continue;
                    this.db.println("expandLogicalLink: Trunk not found to look for a Protect Link.");
                    continue;
                }
                if (!this.db.on()) continue;
                this.db.println("expandLogicalLink: Protect Port not found to set color to the protect link ");
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!this.db.on()) continue;
                abstractCmsNoSuchEntityException.printStackTrace();
            }
            catch (NoSuchEquipment noSuchEquipment) {
                if (!this.db.on()) continue;
                noSuchEquipment.printStackTrace();
            }
        }
        if (!(iNetLink instanceof OchTrailTunnelNetLink)) {
            this.deleteLink(iNetLink);
        }
    }

    private IEntityModel getYCableProtectPort(INetLink iNetLink) {
        IEntityModel iEntityModel;
        block3: {
            int n = iNetLink.getLinkModel().getYCableProtectPortEntityIndex();
            iEntityModel = null;
            INodeModel iNodeModel = iNetLink.getLinkModel().isXcCapable() ? iNetLink.getDst().getNodeModel() : iNetLink.getSrc().getNodeModel();
            IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
            try {
                iEntityModel = iEntityTableModel.getEntityModelByIndex(n);
                if (this.db.on()) {
                    this.db.println("getYCableProtectPort: em is " + iEntityModel);
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!this.db.on()) break block3;
                this.db.println("getYCableProtectPort: entity index invalid - " + abstractCmsNoSuchEntityException.getMessage());
            }
        }
        return iEntityModel;
    }

    private synchronized void removeInactiveLoTDwdmLink(List list, boolean bl, boolean bl2) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            NetMapLink netMapLink;
            INetLink iNetLink = (INetLink)iterator.next();
            MapLink mapLink = this.getMapLink(iNetLink);
            if (mapLink == null || !(mapLink instanceof NetMapLink) || (netMapLink = (NetMapLink)mapLink).getState() != 1) continue;
            Object object = mapLink.getUserObject();
            if (!(bl2 && object instanceof CompositeNetLink || !bl && object instanceof AbstractNetLink && ((AbstractNetLink)object).isLOTunnel()) && (bl || !(object instanceof AbstractNetLink) || !((AbstractNetLink)object).isLAP())) continue;
            this.deleteLink((AbstractNetLink)object);
        }
    }

    private synchronized void removeInactiveOTTLinks(List list, boolean bl) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            MapLink mapLink;
            INetLink iNetLink = (INetLink)iterator.next();
            if (!(iNetLink instanceof OchTrailTunnelNetLink) || (mapLink = this.getMapLink(iNetLink)) == null) continue;
            if (bl) {
                this.deleteLink(iNetLink);
                continue;
            }
            if (!(mapLink instanceof NetMapLink)) continue;
            NetMapLink netMapLink = (NetMapLink)mapLink;
            INetCircuitSpan iNetCircuitSpan = this.getCircuitSpan(this.netCircuit, iNetLink);
            if (iNetCircuitSpan == null) {
                iNetCircuitSpan = this.getCircuitSpan(this.netCircuit, iNetLink.getReverseLink());
            }
            if (iNetCircuitSpan != null) continue;
            this.deleteLink(iNetLink);
        }
    }

    private List orderNetLinks(Collection collection, INodeModel iNodeModel) {
        ArrayList<LinkDataInfo> arrayList = new ArrayList<LinkDataInfo>(collection.size());
        Iterator iterator = collection.iterator();
        this.buildList.add("orderNetLinks: size = " + collection.size() + " srcNode = " + iNodeModel);
        while (iterator.hasNext()) {
            boolean bl;
            AbstractNetLink abstractNetLink = (AbstractNetLink)iterator.next();
            INodeModel iNodeModel2 = abstractNetLink.getSrc().getNodeModel();
            INodeModel iNodeModel3 = abstractNetLink.getDst().getNodeModel();
            if (iNodeModel != iNodeModel2 && iNodeModel != iNodeModel3) continue;
            iterator.remove();
            boolean bl2 = bl = iNodeModel == iNodeModel3;
            if (OchPortsHelper.isOpticPort(iNodeModel2, abstractNetLink.getSrcEntityIndex())) {
                bl = OchPortsHelper.isAddPort(iNodeModel2, abstractNetLink.getSrcEntityIndex());
            } else {
                int n = abstractNetLink.getDstEntityIndex();
                if (OchPortsHelper.isOpticPort(iNodeModel3, n)) {
                    bl = !OchPortsHelper.isAddPort(iNodeModel3, n);
                }
            }
            arrayList.add(new LinkDataInfo(abstractNetLink, bl));
            iNodeModel = iNodeModel == iNodeModel2 ? iNodeModel3 : iNodeModel2;
            iterator = collection.iterator();
            this.buildList.add("=> " + iNodeModel + " reverse = " + bl);
        }
        if (collection.size() > 0) {
            if (this.db.on()) {
                this.db.println(collection.size() + " links won't be sorted");
            }
            iterator = collection.iterator();
            while (iterator.hasNext()) {
                arrayList.add(new LinkDataInfo((AbstractNetLink)iterator.next(), false));
            }
        }
        return arrayList;
    }

    private void expandDetailedLogicalSpan(INetCircuitSpan iNetCircuitSpan, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        Object object;
        Object object2;
        String string = "\texpandDetailedLogicalSpan():";
        INetLink iNetLink = iNetCircuitSpan.getLink();
        CircuitMapLink circuitMapLink = (CircuitMapLink)this.getMapLink(iNetLink);
        boolean bl5 = true;
        if (circuitMapLink == null) {
            this.buildList.add(string + " mapLink was null.  Leaving.");
            return;
        }
        CircuitMapPort circuitMapPort = (CircuitMapPort)circuitMapLink.getSourcePort();
        CircuitMapPort circuitMapPort2 = (CircuitMapPort)circuitMapLink.getTargetPort();
        if (circuitMapPort == null || circuitMapPort2 == null) {
            this.buildList.add(string + " srcPort= " + circuitMapPort + " and " + "dstPort= " + circuitMapPort2 + "; disallow nulls/leaving.");
            return;
        }
        INetCircuitSpan[] iNetCircuitSpanArray = null;
        List list = null;
        INetCircuit iNetCircuit = null;
        if (bl2 && iNetLink instanceof CompositeNetLink) {
            bl2 = true;
            list = this.orderNetLinks(((CompositeNetLink)iNetLink).getLinks(), iNetLink.getSrc().getNodeModel());
            iNetCircuitSpanArray = new INetCircuitSpan[list.size()];
            for (int i = 0; i < iNetCircuitSpanArray.length; ++i) {
                object2 = (LinkDataInfo)list.get(i);
                AbstractNetLink abstractNetLink = ((LinkDataInfo)object2).netLink;
                object = new NetLinkSpan(abstractNetLink, abstractNetLink);
                iNetCircuitSpanArray[i] = NetCircuitSpanFactory.createCircuitSpan(this.netCircuit, (NetLinkSpan)object);
            }
            this.buildList.add(string + " Found composite link, " + "lotSpans.length = " + iNetCircuitSpanArray.length);
        } else if (!bl && iNetLink.isLOTunnel()) {
            iNetCircuit = this.findLotTunnel((NetCircuitEnd)circuitMapPort.getCircuitEnd(), (NetCircuitEnd)circuitMapPort2.getCircuitEnd());
            if (iNetCircuit != null) {
                this.relatedCircuitsList.add(iNetCircuit);
                list = this.orderNetLinks(new LinkedList(iNetLink.getLinksList()), iNetLink.getSrc().getNodeModel());
                iNetCircuitSpanArray = iNetCircuit.getCircuitSpans().toArray(new INetCircuitSpan[0]);
                this.buildList.add(string + " Found lotCkt = " + iNetCircuit + " (" + iNetCircuit.getCircuitName() + "), lotSpans.length = " + iNetCircuitSpanArray.length);
            } else {
                this.buildList.add(string + " No lotCkt found");
            }
        } else if (bl3 && iNetLink instanceof OchTrailTunnelNetLink) {
            iNetCircuit = this.findOchTrailTunnel(iNetLink);
            if (iNetCircuit != null) {
                this.relatedCircuitsList.add(iNetCircuit);
                list = this.orderNetLinks(new LinkedList(iNetLink.getLinksList()), iNetLink.getSrc().getNodeModel());
                iNetCircuitSpanArray = iNetCircuit.getCircuitSpans().toArray(new INetCircuitSpan[0]);
                this.buildList.add(string + " Found ottCkt = " + iNetCircuit + " (" + iNetCircuit.getCircuitName() + "), ottSpans.length = " + iNetCircuitSpanArray.length);
            } else {
                this.buildList.add(string + " No ottCkt found");
            }
        } else if (!bl && iNetLink.isLAP()) {
            iNetCircuit = this.findLAP(iNetLink);
            if (iNetCircuit != null) {
                this.relatedCircuitsList.add(iNetCircuit);
                list = this.orderNetLinks(new LinkedList(iNetLink.getLinksList()), iNetLink.getSrc().getNodeModel());
                iNetCircuitSpanArray = iNetCircuit.getCircuitSpans().toArray(new INetCircuitSpan[0]);
                this.buildList.add(string + " Found lotCkt = " + iNetCircuit + " (" + iNetCircuit.getCircuitName() + "), lapSpans.length = " + iNetCircuitSpanArray.length);
            } else {
                this.buildList.add(string + " No lap found");
            }
        } else if (bl3 && iNetLink instanceof VirtualNetLink) {
            bl5 = false;
            iNetCircuit = null;
            LinkedList<INetLink> linkedList = new LinkedList<INetLink>();
            linkedList.add(iNetLink);
            list = this.orderNetLinks(linkedList, iNetLink.getSrc().getNodeModel());
            this.buildList.add(string + " Found VirtualNetLink: " + iNetLink);
        }
        if (list == null) {
            return;
        }
        DetailedMapLink detailedMapLink = (DetailedMapLink)this.getMapLink(iNetLink);
        object2 = new ArrayList();
        for (int i = 0; i < detailedMapLink.getNumStyles(); ++i) {
            object = detailedMapLink.getStyle(i);
            ((ArrayList)object2).add(object);
        }
        INetCircuitSpan iNetCircuitSpan2 = iNetCircuitSpan;
        object = list.iterator();
        while (object.hasNext()) {
            Object object3;
            Object object4;
            LinkDataInfo linkDataInfo = (LinkDataInfo)object.next();
            AbstractNetLink abstractNetLink = linkDataInfo.netLink;
            if (this.db.on()) {
                this.db.println("\tMapped-from-Logical NetLink: " + abstractNetLink.prettyString() + "\tReverse? " + linkDataInfo.reverse);
            }
            AbstractLinkModel abstractLinkModel = (AbstractLinkModel)abstractNetLink.getLinkModel();
            CircuitMapNodeCookie circuitMapNodeCookie = new CircuitMapNodeCookie(iNetCircuit != null ? iNetCircuit : this.netCircuit);
            DetailedMapNode detailedMapNode = (DetailedMapNode)this.addNode(abstractLinkModel.src(), false, circuitMapNodeCookie);
            DetailedMapNode detailedMapNode2 = (DetailedMapNode)this.addNode(abstractLinkModel.dst(), false, circuitMapNodeCookie);
            if (iNetCircuitSpanArray != null) {
                object4 = abstractNetLink.getReverseLink();
                if (this.db.on()) {
                    this.db.println("Checking LOT spans for following\n\tLink: " + abstractNetLink + "\n\trevLink: " + object4);
                }
                for (int i = 0; i < iNetCircuitSpanArray.length; ++i) {
                    object3 = iNetCircuitSpanArray[i].getLink();
                    if (this.db.on()) {
                        this.db.println("\tLOT Link #" + i + " " + object3);
                    }
                    if (object3 == null || !object3.equals(abstractNetLink) && !object3.equals(object4)) continue;
                    iNetCircuitSpan2 = iNetCircuitSpanArray[i];
                    break;
                }
            }
            object4 = iNetCircuitSpan2.getNetLinkSpan();
            ArrayList<INetCircuitEnd> arrayList = new ArrayList<INetCircuitEnd>();
            arrayList.add(circuitMapPort.getCircuitEnd());
            arrayList.add(circuitMapPort2.getCircuitEnd());
            object3 = new CircuitMapLinkCookie(iNetCircuit != null ? iNetCircuit : this.netCircuit, iNetCircuitSpan2, (INetLinkSpan)object4, arrayList);
            this.addLink(abstractNetLink, object3, bl4);
            CircuitMapLink circuitMapLink2 = (CircuitMapLink)this.getMapLink(abstractNetLink);
            if (circuitMapLink2 == null) {
                if (!this.db.on()) continue;
                this.db.println("Fail to create MapLink for = " + abstractNetLink);
                continue;
            }
            if (iNetCircuitSpanArray != null && abstractNetLink instanceof NetLink) {
                ((NetLink)abstractNetLink).newState(((NetLink)iNetLink).newState());
            }
            if (!this.isNetLinkUpBothDirection(abstractNetLink)) {
                this.setNetMapLinkState("expandDetailedLogicalSpan()", circuitMapLink2, 1);
            }
            circuitMapLink2.clearStyles();
            for (int i = 0; i < ((ArrayList)object2).size(); ++i) {
                DetailedMapLinkStyle detailedMapLinkStyle = (DetailedMapLinkStyle)((ArrayList)object2).get(i);
                if (this.isPeerToPeerVirtualLinkForOchTrail(circuitMapLink2.getNetLink())) {
                    detailedMapLinkStyle = this.getStyleForVirtualLink(circuitMapLink2.getNetLink());
                } else if (this.isOchTrailTunnelExpandedLink()) {
                    detailedMapLinkStyle = new DetailedMapLinkStyle(detailedMapLinkStyle.getDirection(), detailedMapLinkStyle.getColor());
                    if (!this.isOchTrailTunnelExpandedLinkActive(circuitMapLink2.getNetLink())) {
                        detailedMapLinkStyle.setColor(NetMapLink.LINK_STANDBY_COLOR);
                    } else {
                        detailedMapLinkStyle.setColor(NetMapLink.LINK_ACTIVE_COLOR);
                    }
                }
                if (linkDataInfo.reverse) {
                    detailedMapLinkStyle.reverse();
                }
                circuitMapLink2.addStyle(detailedMapLinkStyle);
            }
            if (bl2 || !(iNetCircuitSpan2.getLink() instanceof CompositeNetLink)) continue;
            this.expandDetailedLogicalSpan(iNetCircuitSpan2, bl, bl2, bl3, bl4);
        }
        if (iNetCircuitSpan2 != null) {
            object = iNetCircuitSpan2.getCircuit();
            this.addXmPorts((INetCircuit)object, "ExpandDetailedLogicalSpan: ", false);
        }
        if (bl5) {
            object = circuitMapLink.getSourcePort();
            if (object != null) {
                ((MapPort)object).removeConnector(circuitMapLink.getSourceConnector());
            }
            if ((object = circuitMapLink.getTargetPort()) != null) {
                ((MapPort)object).removeConnector(circuitMapLink.getTargetConnector());
            }
            this.deleteLink(iNetLink);
        }
        if (this.needsInternalPG(iNetLink)) {
            this.addInternalPGs(iNetLink);
        }
    }

    private DetailedMapLinkStyle getStyleForVirtualLink(INetLink iNetLink) {
        CircuitMapLink circuitMapLink = (CircuitMapLink)this.getMapLink(iNetLink);
        boolean bl = OchTrailHelper.isActivePort(iNetLink.getSrc().getNodeModel(), iNetLink.getSrcEntityIndex());
        boolean bl2 = OchTrailHelper.isActivePort(iNetLink.getDst().getNodeModel(), iNetLink.getDstEntityIndex());
        DetailedMapLinkStyle detailedMapLinkStyle = new DetailedMapLinkStyle(3, NetMapLink.LINK_ACTIVE_COLOR);
        if (bl && bl2) {
            detailedMapLinkStyle.setColor(NetMapLink.LINK_ACTIVE_COLOR);
        } else if (bl && !bl2 || !bl && bl2) {
            boolean bl3 = OchTrailHelper.isWorkingPort(iNetLink.getSrc().getNodeModel(), iNetLink.getSrcEntityIndex());
            if (!bl3) {
                detailedMapLinkStyle.setColor(NetMapLink.LINK_STANDBY_COLOR);
            } else if (bl3) {
                detailedMapLinkStyle.setColor(NetMapLink.LINK_ACTIVE_COLOR);
            }
        } else {
            detailedMapLinkStyle.setColor(NetMapLink.LINK_STANDBY_COLOR);
        }
        return detailedMapLinkStyle;
    }

    private void addXmPorts(INetCircuit iNetCircuit, String string, boolean bl) {
        List list = null;
        INetCircuit iNetCircuit2 = iNetCircuit;
        if (iNetCircuit != null) {
            boolean bl2;
            boolean bl3 = bl2 = iNetCircuit.getCircuitTypeObj().isLoCircuitType() && !bl;
            if (bl2 && (iNetCircuit2 = iNetCircuit.useLAP()) == null) {
                return;
            }
            list = iNetCircuit2.getXmCircuitEnds();
            if (list != null && !list.isEmpty()) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    DetailedMapNode detailedMapNode;
                    Object object;
                    boolean bl4;
                    INetCircuitEnd iNetCircuitEnd = (INetCircuitEnd)iterator.next();
                    boolean bl5 = bl4 = iNetCircuitEnd.getEntityIndex() % 2 == 0;
                    if (bl2 && bl4) {
                        object = null;
                        try {
                            object = new LoCircuitEnd(iNetCircuitEnd.getNodeModel(), iNetCircuitEnd.getEntityModel(), iNetCircuitEnd.getHoNum(), iNetCircuit.getLoOverHo(), false);
                            iNetCircuitEnd = object;
                        }
                        catch (ObjNotFound objNotFound) {
                            // empty catch block
                        }
                    }
                    if ((detailedMapNode = (DetailedMapNode)this.getMapNode(object = iNetCircuitEnd.getNodeModel())) == null) continue;
                    CircuitMapPort circuitMapPort = (CircuitMapPort)detailedMapNode.addPort(null, null);
                    CircuitMapPortCookie circuitMapPortCookie = bl4 ? new CircuitMapPortCookie(iNetCircuit, CircuitMap.getSpanLabel(iNetCircuitEnd)) : new CircuitMapPortCookie(iNetCircuit2, CircuitMap.getSpanLabel(iNetCircuitEnd));
                    circuitMapPort.init(iNetCircuitEnd, circuitMapPortCookie);
                    this.buildList.add(string + "Added internal port to " + object.getName() + " -> " + CircuitMap.getSpanLabel(iNetCircuitEnd) + "\t" + iNetCircuitEnd);
                }
            }
        }
    }

    public boolean isLinkAcceptable(INetLink iNetLink) {
        if (this.linkAcceptableOverride) {
            return true;
        }
        return super.isLinkAcceptable(iNetLink);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void traceCircuit(INetCircuit iNetCircuit, boolean bl, boolean bl2, boolean bl3) {
        String string = "traceCircuit():";
        this.spanList.clear();
        this.linkAcceptableOverride = false;
        this.relatedCircuitsList.clear();
        this.LOT_FLAG = bl;
        this.DWDM_FLAG = bl2;
        this.OCHNC_FLAG = bl3;
        String string2 = this.getCurrentDomainName();
        if (iNetCircuit != null) {
            Object object;
            Object object2;
            Object object3;
            this.netCircuit = iNetCircuit;
            if (this.nodesComplete) {
                this.clearNodeMarkers();
            } else {
                this.localDispose();
                this.reInitMap();
                this.initializeMap(1);
                this.nodesComplete = true;
            }
            this.buildList = new ArrayList();
            this.buildList.add("Build Timestamp: " + new Date().toString());
            this.buildList.add(CircuitMapUtil.generalInterest(iNetCircuit));
            boolean bl4 = false;
            boolean bl5 = false;
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(iNetCircuit.getCircuitSpans());
            Object object4 = arrayList.iterator();
            while (object4.hasNext()) {
                object3 = (INetCircuitSpan)object4.next();
                object2 = object3.getLink();
                if (object2.isPca()) {
                    bl4 = true;
                    continue;
                }
                int n = object2.getProtectionType();
                if (n != 0 && n != 4) continue;
                bl5 = true;
            }
            if (bl4 && bl5) {
                this.linkAcceptableOverride = true;
            }
            this.resetLinks(iNetCircuit.getCircuitTypeObj().isLoCircuitType(), bl4);
            object4 = new ArrayList(this.getLinkUserObjects());
            object3 = this;
            synchronized (object3) {
                object2 = object4.iterator();
                while (object2.hasNext()) {
                    INetLink iNetLink = (INetLink)object2.next();
                    object = this.getMapLink(iNetLink);
                    this.setNetMapLinkState("traceCircuit0()", (MapLink)object, 1);
                }
            }
            object3 = arrayList.iterator();
            while (object3.hasNext()) {
                object2 = (INetCircuitSpan)object3.next();
                this.spanList.add(object2);
                this.buildList.add(string + " add " + object2 + " to spanList");
                if (this.db.on) {
                    this.db.println("in traceCircuit adding span=" + object2);
                }
                MapLink mapLink = this.getMapLink(object2.getNetLinkSpan());
                object = (AbstractNetLink)object2.getNetLinkSpan().getLink();
                if (mapLink == null && ((AbstractNetLink)object).isLAP()) {
                    this.addLink((INetLink)object, object2.getNetLinkSpan());
                    mapLink = this.getMapLink(object);
                }
                if (mapLink != null) {
                    if (object != null) {
                        this.buildList.add("AbstractNetLink info: " + ((AbstractNetLink)object).prettyString());
                    }
                    this.buildList.add(string + " attached MapNodes are " + "SRC=" + mapLink.getSourceNode() + ", DST=" + mapLink.getTargetNode());
                    if (this.isNetLinkUpBothDirection((INetLink)object)) {
                        boolean bl6 = object2.active();
                        this.buildList.add(string + "\tSpan Active? " + bl6);
                        this.setNetMapLinkState("traceCircuit1()", mapLink, bl6 ? 4 : 5);
                    }
                    object = (AbstractNetLink)mapLink.getUserObject();
                    if (mapLink instanceof NetMapLink) {
                        this.expandLogicalLink((INetCircuitSpan)object2, mapLink.getState(), (INetLink)object, bl, bl2, bl3);
                        continue;
                    }
                    this.buildList.add("Cannot expand logical link for mapLink: " + mapLink + " since it is " + "not a NetMapLink.");
                    continue;
                }
                if (!this.db.on()) continue;
                this.db.println("traceCircuit link not found");
            }
            this.removeInactiveLoTDwdmLink((List)object4, bl, bl2);
            this.removeInactiveOTTLinks((List)object4, bl3);
            if (this.netCircuit.getCircuitTypeObj().isEthernetCircuitType() || this.netCircuit.getCircuitTypeObj().isTunnelCircuitType()) {
                this.addSourceNodeMarker();
            }
            this.addDriMarker(this.netCircuit.getCircuitNodes());
            this.addSourceNodes(false, false);
            this.addDropNodes(false, false);
            try {
                if (string2 != null) {
                    this.displayDomain(string2);
                } else {
                    this.jumpToSourceNodeDomain();
                }
            }
            catch (Exception exception) {
                CircuitMapDebug.printStackTrace((Throwable)exception);
                this.displayDomain("");
            }
            this.updateView();
            this.setViewToCenter();
        }
    }

    private INetCircuitSpan getCircuitSpan(INetCircuit iNetCircuit, INetLink iNetLink) {
        if (iNetCircuit == null || iNetLink == null) {
            return null;
        }
        if (iNetLink instanceof NonRoutableNetLink) {
            INetLink iNetLink2 = this.netModel.findReverseLink(iNetLink);
            Iterator iterator = iNetCircuit.getCircuitSpans().iterator();
            while (iterator.hasNext()) {
                Collection collection;
                INetCircuitSpan iNetCircuitSpan = (INetCircuitSpan)iterator.next();
                INetLink iNetLink3 = iNetCircuitSpan.getLink();
                if (!(iNetLink3 instanceof CompositeNetLink) || !(collection = ((CompositeNetLink)iNetLink3).getLinks()).contains(iNetLink) && !collection.contains(iNetLink2)) continue;
                return iNetCircuitSpan;
            }
            return null;
        }
        INetLink iNetLink4 = this.netModel.findReverseLink(iNetLink);
        Iterator iterator = iNetCircuit.getCircuitSpans().iterator();
        while (iterator.hasNext()) {
            INetCircuitSpan iNetCircuitSpan = (INetCircuitSpan)iterator.next();
            INetLink iNetLink5 = iNetCircuitSpan.getLink();
            if (iNetLink == iNetLink5) {
                return iNetCircuitSpan;
            }
            if (iNetLink4 == null || iNetLink4 != iNetLink5) continue;
            return iNetCircuitSpan;
        }
        return null;
    }

    protected void updateLinkState(MapLink mapLink) {
        block6: {
            if (mapLink == null || !(mapLink.getUserObject() instanceof INetLink)) {
                return;
            }
            INetLink iNetLink = (INetLink)mapLink.getUserObject();
            try {
                int n = 1;
                if (!(iNetLink instanceof NonRoutableNetLink) || !this.DWDM_FLAG) {
                    INetCircuitSpan iNetCircuitSpan = this.getCircuitSpan(this.netCircuit, iNetLink);
                    if (iNetCircuitSpan != null && this.isNetLinkUpBothDirection(iNetLink)) {
                        int n2 = n = iNetCircuitSpan.active() ? 4 : 5;
                    }
                    if (this.db.on()) {
                        this.db.println("updateLinkState span= " + iNetCircuitSpan + " state = " + n);
                    }
                }
                this.setNetMapLinkState("updateLinkState()", mapLink, n);
            }
            catch (Exception exception) {
                if (!this.db.on()) break block6;
                this.db.println("error in circuitmap updateLinkState");
                CircuitMapDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    void traceDetailedCircuit(INetCircuit iNetCircuit, boolean bl, boolean bl2) {
        this.traceDetailedCircuit(iNetCircuit, bl, bl2, false);
    }

    void traceDetailedCircuit(INetCircuit iNetCircuit, boolean bl, boolean bl2, boolean bl3) {
        String string = "traceDetailedCircuit():";
        this.linkAcceptableOverride = false;
        this.spanList.clear();
        this.relatedCircuitsList.clear();
        if (iNetCircuit != null) {
            if (this.db.on()) {
                this.db.println(string + " ckt=" + iNetCircuit.getCircuitName());
            }
            this.netCircuit = iNetCircuit;
            this.LOT_FLAG = bl;
            this.DWDM_FLAG = bl2;
            this.OCHNC_FLAG = bl3;
            this.localDispose();
            this.nodesComplete = false;
            String string2 = this.getCurrentDomainName();
            this.reInitMapToDetailed();
            this.buildList = new ArrayList();
            this.buildList.add("Build Timestamp: " + new Date().toString());
            this.buildList.add(CircuitMapUtil.generalInterest(iNetCircuit));
            this.drawDetailedNodesAndLinks(iNetCircuit, bl, bl2, bl3, false);
            try {
                if (string2 != null) {
                    this.displayDomain(string2);
                } else {
                    this.jumpToSourceNodeDomain();
                }
            }
            catch (Exception exception) {
                CircuitMapDebug.printStackTrace((Throwable)exception);
                this.displayDomain("");
            }
            this.updateView();
            this.setViewToCenter();
        }
    }

    void traceBridgeRollCircuit(INetCircuit iNetCircuit, boolean bl, boolean bl2) {
        this.spanList = new ArrayList();
        this.relatedCircuitsList.clear();
        String string = this.getCurrentDomainName();
        if (iNetCircuit != null) {
            if (this.db.on()) {
                this.db.println("traceBridgeRollCircuit circuit=" + iNetCircuit.getCircuitName());
            }
            this.netCircuit = iNetCircuit;
            this.LOT_FLAG = bl;
            this.DWDM_FLAG = bl2;
            this.localDispose();
            this.nodesComplete = false;
            this.reInitMapToDetailed();
            this.buildList = new ArrayList();
            this.buildList.add("Build Timestamp: " + new Date().toString());
            this.buildList.add(CircuitMapUtil.generalInterest(iNetCircuit));
            List list = RollManager.instance().getRolls(iNetCircuit);
            if (this.db.on()) {
                this.db.println("Number of rolls this ckt involves in : " + list.size());
            }
            boolean bl3 = false;
            boolean bl4 = false;
            for (int i = 0; i < list.size(); ++i) {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                NetRoll netRoll = (NetRoll)((Object)list.get(i));
                if (this.db.on()) {
                    this.db.println("roll number " + i + " : ");
                }
                if (netRoll == null) continue;
                NetCcatCircuit netCcatCircuit = netRoll.getFromCircuit();
                NetCcatCircuit netCcatCircuit2 = netRoll.getToCircuit();
                NetCircuitEnd netCircuitEnd = netRoll.getRollFromCktEnd();
                NetCircuitEnd netCircuitEnd2 = netRoll.getRollToCktEnd();
                if (this.db.on()) {
                    this.db.println("rollFrom : " + netCircuitEnd.prettyString());
                }
                if (this.db.on()) {
                    this.db.println("rollTo : " + netCircuitEnd2.prettyString());
                }
                if (netCcatCircuit != null && netCcatCircuit2 != null && netCcatCircuit != netCcatCircuit2) {
                    if (this.db.on()) {
                        this.db.println("merge two circuits case");
                    }
                    this.netCircuit = netCcatCircuit;
                    if (!bl3) {
                        if (this.db.on()) {
                            this.db.println("draw rollFromCkt");
                        }
                        this.relatedCircuitsList.add(netCcatCircuit);
                        this.buildList.add("tracebridgeroll:: rollFromCkt= " + netCcatCircuit + " (" + netCcatCircuit.getCircuitName() + ")");
                        this.drawDetailedNodesAndLinks(netCcatCircuit, bl, bl2, false, false);
                        bl3 = true;
                    }
                    object5 = netCircuitEnd.getNetElement();
                    object4 = netCcatCircuit.getCircuitNodeFromNE((INetElement)object5);
                    List list2 = object4.getIngressPoints();
                    object3 = object4.getEgressPoints();
                    if (object3.contains(netCircuitEnd)) {
                        if (this.db.on()) {
                            this.db.println("rollFrom is an egress point");
                        }
                        if ((object2 = this.findSpan(netCircuitEnd2, (INetCircuitEnd)(object = (INetCircuitEnd)netRoll.getToCircuit().getSources().get(0)))) != null) {
                            if (this.db.on()) {
                                this.db.println("found span btw rollTo and newSrcEnd");
                            }
                            this.addSpan((INetCircuitSpan)object2, bl, bl2, false, true);
                            if (!bl4) {
                                this.netCircuit = netCcatCircuit2;
                                if (list.size() == 1) {
                                    if (this.db.on()) {
                                        this.db.println("draw rollToCkt and its drop node");
                                    }
                                    this.relatedCircuitsList.add(netCcatCircuit2);
                                    this.buildList.add("tracebridgeroll:: rollToCkt= " + netCcatCircuit2 + " (" + netCcatCircuit2.getCircuitName() + ")");
                                    this.drawDetailedNodesAndLinks(netCcatCircuit2, bl, bl2, false, true);
                                    this.addDropNodes(true, true);
                                } else if (list.size() == 2) {
                                    this.relatedCircuitsList.add(netCcatCircuit2);
                                    if (this.db.on()) {
                                        this.db.println("draw rollToCkt only");
                                    }
                                    this.buildList.add("tracebridgeroll:: rollToCkt= " + netCcatCircuit2 + " (" + netCcatCircuit2.getCircuitName() + ")");
                                    this.drawDetailedNodesAndLinks(netCcatCircuit2, bl, bl2, false, true);
                                }
                                bl4 = true;
                            }
                        }
                    } else if (list2.contains(netCircuitEnd)) {
                        if (this.db.on()) {
                            this.db.println("rollFrom is an ingress point");
                        }
                        if ((object2 = this.findSpan((INetCircuitEnd)(object = (INetCircuitEnd)netRoll.getToCircuit().getDrops().get(0)), netCircuitEnd2)) != null) {
                            if (this.db.on()) {
                                this.db.println("found span btw newDstEnd and rollTo");
                            }
                            this.addSpan((INetCircuitSpan)object2, bl, bl2, false, true);
                            if (!bl4) {
                                this.netCircuit = netCcatCircuit2;
                                if (list.size() == 1) {
                                    if (this.db.on()) {
                                        this.db.println("draw rollToCkt and its src node");
                                    }
                                    this.relatedCircuitsList.add(netCcatCircuit2);
                                    this.buildList.add("tracebridgeroll:: rollToCkt= " + netCcatCircuit2 + " (" + netCcatCircuit2.getCircuitName() + ")");
                                    this.drawDetailedNodesAndLinks(netCcatCircuit2, bl, bl2, false, true);
                                    this.addSourceNodes(true, true);
                                } else if (list.size() == 2) {
                                    if (this.db.on()) {
                                        this.db.println("draw rollToCkt only");
                                    }
                                    this.relatedCircuitsList.add(netCcatCircuit2);
                                    this.buildList.add("tracebridgeroll:: rollToCkt= " + netCcatCircuit2 + " (" + netCcatCircuit2.getCircuitName() + ")");
                                    this.drawDetailedNodesAndLinks(netCcatCircuit2, bl, bl2, false, true);
                                }
                                bl4 = true;
                            }
                        }
                    }
                } else if (netCcatCircuit != null) {
                    if (this.db.on()) {
                        this.db.println("roll on one circuit case");
                    }
                    this.netCircuit = netCcatCircuit;
                    if (!bl3) {
                        if (this.db.on()) {
                            this.db.println("draw rollFromCkt");
                        }
                        this.relatedCircuitsList.add(netCcatCircuit);
                        this.buildList.add("tracebridgeroll:: rollFromCkt= " + netCcatCircuit + " (" + netCcatCircuit.getCircuitName() + ")");
                        this.drawDetailedNodesAndLinks(netCcatCircuit, bl, bl2, false, false);
                        bl3 = true;
                    }
                    if (list.size() == 1 || list.size() > 1 && !this.shouldAddRollToSpan(iNetCircuit)) {
                        object5 = netCircuitEnd.getNetElement();
                        object4 = netCcatCircuit.getCircuitNodeFromNE((INetElement)object5);
                        List list3 = object4.getIngressPoints();
                        if (list3.contains(netCircuitEnd)) {
                            if (this.db.on()) {
                                this.db.println("draw new src node");
                            }
                            object3 = new ExternalMapKey("Source");
                            this.addExtNode(netCircuitEnd2, "New Source", (ExternalMapKey)object3, true);
                        } else {
                            object3 = object4.getEgressPoints();
                            if (object3.contains(netCircuitEnd)) {
                                if (this.db.on()) {
                                    this.db.println("draw new drop node");
                                }
                                object = new ExternalMapKey("Destination");
                                this.addExtNode(netCircuitEnd2, "New Drop", (ExternalMapKey)object, true);
                            }
                        }
                    } else if (list.size() > 1 && this.shouldAddRollToSpan(iNetCircuit) && (!bl4 || netCcatCircuit2 == null)) {
                        object5 = (NetRoll)((Object)list.get(1));
                        object4 = ((NetRoll)((Object)object5)).getRollToCktEnd();
                        INetCircuitSpan iNetCircuitSpan = null;
                        if (!netCcatCircuit.isBidirectional()) {
                            object3 = netCircuitEnd.getNetElement();
                            object = netCcatCircuit.getCircuitNodeFromNE((INetElement)object3);
                            object2 = object.getIngressPoints();
                            if (object2.contains(netCircuitEnd)) {
                                iNetCircuitSpan = this.findSpan((INetCircuitEnd)object4, netCircuitEnd2);
                            } else {
                                List list4 = object.getEgressPoints();
                                if (list4.contains(netCircuitEnd)) {
                                    iNetCircuitSpan = this.findSpan(netCircuitEnd2, (INetCircuitEnd)object4);
                                }
                            }
                        } else {
                            iNetCircuitSpan = this.findSpan(netCircuitEnd2, (INetCircuitEnd)object4);
                        }
                        if (iNetCircuitSpan != null) {
                            if (this.db.on()) {
                                this.db.println("found span btw rollTo and otherRollTo");
                            }
                            this.addSpan(iNetCircuitSpan, bl, bl2, false, true);
                        }
                        bl4 = true;
                    }
                }
                try {
                    object5 = (CircuitMapNode)this.getMapNode(netCircuitEnd.getNodeModel());
                    if (object5 != null) {
                        object4 = ((DetailedMapNode)object5).getPorts();
                        for (int j = 0; j < ((MapPort[])object4).length; ++j) {
                            object3 = (CircuitMapPort)object4[j];
                            object = ((CircuitMapPort)object3).getCircuitEnd();
                            if (!this.isSameMapPort((INetCircuitEnd)object, netCircuitEnd)) continue;
                            ((CircuitMapPort)object3).setSuffixString(((CircuitMapPort)object3).getSuffixString() + " (RFrom)");
                        }
                    } else {
                        this.buildList.add("could not get rollFrom Node!");
                    }
                }
                catch (Exception exception) {
                    CircuitMapDebug.printStackTrace((Throwable)exception);
                }
                try {
                    object5 = (CircuitMapNode)this.getMapNode(netCircuitEnd2.getNodeModel());
                    if (object5 != null) {
                        object4 = ((DetailedMapNode)object5).getPorts();
                        for (int j = 0; j < ((Object)object4).length; ++j) {
                            object3 = (CircuitMapPort)object4[j];
                            object = ((CircuitMapPort)object3).getCircuitEnd();
                            if (!this.isSameMapPort((INetCircuitEnd)object, netCircuitEnd2)) continue;
                            ((CircuitMapPort)object3).setSuffixString(((CircuitMapPort)object3).getSuffixString() + " (RTo)");
                        }
                        continue;
                    }
                    this.buildList.add("could not get rollTo Node!");
                    continue;
                }
                catch (Exception exception) {
                    CircuitMapDebug.printStackTrace((Throwable)exception);
                }
            }
            if (!bl3 && !bl4) {
                if (this.db.on()) {
                    this.db.println("unable to trace rollFromCkt and rollToCkt and just draw it as normal");
                }
                this.drawDetailedNodesAndLinks(iNetCircuit, bl, bl2, false, false);
            }
            this.netCircuit = iNetCircuit;
            try {
                if (string != null) {
                    this.displayDomain(string);
                } else {
                    this.jumpToSourceNodeDomain();
                }
            }
            catch (Exception exception) {
                CircuitMapDebug.printStackTrace((Throwable)exception);
                this.displayDomain("");
            }
            this.updateView();
        } else if (this.db.on()) {
            this.db.println("traceBridgeRollCircuit circuit==null");
        }
    }

    private boolean shouldAddRollToSpan(INetCircuit iNetCircuit) {
        List list = RollManager.instance().getRolls(iNetCircuit);
        if (list.size() == 1) {
            return false;
        }
        if (list.size() > 1) {
            IObservable iObservable;
            Boolean[] booleanArray = new Boolean[]{false, false};
            NetRoll[] netRollArray = new NetRoll[2];
            INetCircuitNode[] iNetCircuitNodeArray = new INetCircuitNode[2];
            for (int i = 0; i < 2; ++i) {
                netRollArray[i] = (NetRoll)((Object)list.get(i));
                if (netRollArray[i] == null) continue;
                iObservable = netRollArray[i].getFromCircuit();
                NetCircuitEnd netCircuitEnd = netRollArray[i].getRollFromCktEnd();
                INetElement iNetElement = netCircuitEnd.getNetElement();
                iNetCircuitNodeArray[i] = iObservable.getCircuitNodeFromNE(iNetElement);
                List list2 = iNetCircuitNodeArray[i].getIngressPoints();
                if (!list2.contains(netCircuitEnd)) continue;
                booleanArray[i] = true;
            }
            if (netRollArray[0] != null && netRollArray[0].getState() != 4 && netRollArray[1] != null && netRollArray[1].getState() != 4) {
                return true;
            }
            if ((booleanArray[0].booleanValue() && !booleanArray[1].booleanValue() || !booleanArray[0].booleanValue() && booleanArray[1].booleanValue()) && iNetCircuitNodeArray[0] != null && iNetCircuitNodeArray[1] != null) {
                Iterator iterator = ((NetCircuitNode)iNetCircuitNodeArray[0]).getAllSpansList().iterator();
                while (iterator.hasNext()) {
                    iObservable = ((NetCircuitSpan)iterator.next()).getLink();
                    if ((iObservable.getSrc() != iNetCircuitNodeArray[0].getNetElement() || iObservable.getDst() != iNetCircuitNodeArray[1].getNetElement()) && (iObservable.getSrc() != iNetCircuitNodeArray[1].getNetElement() || iObservable.getDst() != iNetCircuitNodeArray[0].getNetElement())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isSameMapPort(INetCircuitEnd iNetCircuitEnd, INetCircuitEnd iNetCircuitEnd2) {
        NetCircuitEnd netCircuitEnd = null;
        NetCircuitEnd netCircuitEnd2 = null;
        if (iNetCircuitEnd instanceof NetCircuitEnd) {
            netCircuitEnd = (NetCircuitEnd)iNetCircuitEnd;
        } else if (iNetCircuitEnd instanceof NetCircuitDropInfo) {
            netCircuitEnd = ((NetCircuitDropInfo)iNetCircuitEnd).getNetCktEnd();
        }
        if (iNetCircuitEnd2 instanceof NetCircuitEnd) {
            netCircuitEnd2 = (NetCircuitEnd)iNetCircuitEnd2;
        } else if (iNetCircuitEnd2 instanceof NetCircuitDropInfo) {
            netCircuitEnd2 = ((NetCircuitDropInfo)iNetCircuitEnd2).getNetCktEnd();
        }
        if (netCircuitEnd != null && netCircuitEnd2 != null) {
            return netCircuitEnd.equals(netCircuitEnd2);
        }
        return false;
    }

    private void drawDetailedNodesAndLinks(INetCircuit iNetCircuit, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        boolean bl5;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String string = "drawDetailedNodesAndLinks():";
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(iNetCircuit.getCircuitSpans());
        Object object5 = arrayList.iterator();
        while (object5.hasNext()) {
            object4 = (INetCircuitSpan)object5.next();
            this.buildList.add(string + " span trace " + object4);
            this.addSpan((INetCircuitSpan)object4, bl, bl2, bl3, bl4);
            this.spanList.add(object4);
        }
        if (iNetCircuit.getCircuitSpans().size() == 0) {
            if (this.db.on()) {
                this.db.println("traceDetail: No primary map node found; creating.");
            }
            if ((object5 = iNetCircuit.getSources()) != null && object5.size() > 0) {
                object4 = (INetCircuitEnd)object5.get(0);
                Object object6 = object3 = object4 != null ? object4.getNodeModel() : null;
                if (this.db.on) {
                    this.db.println("Adding node=" + object3);
                }
                if (object3 != null) {
                    object2 = new CircuitMapNodeCookie(iNetCircuit);
                    this.addNode((INodeModel)object3, false, object2);
                    this.buildList.add(string + " adding node=" + object3.getName() + " manually " + "because there are no circuit spans.");
                }
            }
        }
        object5 = iNetCircuit.getCircuitNodes();
        object4 = object5.iterator();
        while (object4.hasNext()) {
            object3 = (INetCircuitNode)object4.next();
            object2 = object3 != null ? object3.getNodeModel() : null;
            if (object2 == null || this.getMapNode(object2) != null) continue;
            if (this.db.on) {
                this.db.println("Adding node=" + object3.getNodeModel());
            }
            object = new CircuitMapNodeCookie(iNetCircuit);
            this.addNode(object3.getNodeModel(), false, object);
            this.buildList.add(string + " adding extra node=" + object2.getName() + " from CircuitNode=" + object3);
        }
        if (this.netCircuit.getCircuitTypeObj().isEthernetCircuitType() || this.netCircuit.getCircuitTypeObj().isTunnelCircuitType()) {
            object4 = new HashSet<INodeModel>();
            object3 = object5.iterator();
            while (object3.hasNext()) {
                object2 = (INetCircuitNode)object3.next();
                object = object2.getNodeModel();
                if (!object2.isNodeDrop()) continue;
                ((HashSet)object4).add(object);
            }
            object3 = ((HashSet)object4).iterator();
            while (object3.hasNext()) {
                object2 = (INodeModel)object3.next();
                object = (CircuitMapNode)this.getMapNode(object2);
                if (object == null) continue;
                ((CircuitMapNode)object).setCircuitType(this.netCircuit.getCircuitTypeObj());
            }
            this.addSourceNodeMarker();
        }
        if (this.netCircuit.isDiag()) {
            this.addSourceNodeMarker();
        }
        boolean bl6 = bl5 = !bl4;
        if (this.netCircuit.getCircuitTypeObj().isOchTrailTunnelCircuitType()) {
            bl5 = false;
        }
        if (bl5) {
            this.addSourceNodes(true, false);
            this.addDropNodes(true, false);
        }
        boolean bl7 = !iNetCircuit.getCircuitTypeObj().isLoCircuitType();
        object2 = object5.iterator();
        while (object2.hasNext()) {
            DetailedMapNode detailedMapNode;
            Object object7;
            object = (INetCircuitNode)object2.next();
            if (object.isUpsrSelector()) {
                try {
                    object7 = object.getNodeModel();
                    if (object7 != null) {
                        IConnectionModel iConnectionModel = object.getConn();
                        if (!(iConnectionModel instanceof UpsrSelector) && this.ced != null) {
                            this.ced.addObservableObject(iConnectionModel);
                            this.db.println("manually adding obs to " + iConnectionModel + "\t" + iConnectionModel.getClass().toString());
                        }
                        int n = CircuitMapUtil.connectionHasSecondSelector(iConnectionModel) ? 2 : 1;
                        this.buildList.add(string + "Detected " + object7.getName() + " as a UPSR with " + n + " selector(s)");
                        this.addSelectors((INetCircuitNode)object, iConnectionModel);
                        continue;
                    }
                    this.db.println("CircuitNode is null in nodeList!");
                }
                catch (Exception exception) {
                    if (!this.db.on()) continue;
                    CircuitMapDebug.printStackTrace((Throwable)exception);
                }
                continue;
            }
            if (!this.needsInternalPG((INetCircuitNode)object) || (detailedMapNode = (DetailedMapNode)this.getMapNode(object.getNodeModel())) == null) continue;
            object7 = detailedMapNode.addInternalPG(object);
            this.buildList.add(string + "Added internal PG to " + detailedMapNode.getName() + " for cktNode " + object);
        }
        if (this.netCircuit.getCircuitTypeObj().isOchccCircuitType()) {
            if (this.netCircuit.isCircuitProtected()) {
                object2 = (OchccCircuit)this.netCircuit;
                object = (INetCircuitEnd)((NetCircuit)object2).getSources().get(0);
                this.addOchTrailProtectedSelector(((NetCircuit)object2).getSourceNE(), object.getEntityIndex());
                object = (INetCircuitEnd)((NetCircuit)object2).getDrops().get(0);
                this.addOchTrailProtectedSelector(((NetCircuit)object2).getDropNE(), object.getEntityIndex());
            }
            bl5 = false;
        }
        this.addDriMarker((List)object5);
        this.addXmPorts(iNetCircuit, "DrawDetailedNodesAndLinks: ", true);
    }

    private boolean needsInternalPG(INetCircuitNode iNetCircuitNode) {
        return this.netCircuit.getCircuitTypeObj().isOchTrailTunnelCircuitType() && iNetCircuitNode instanceof DualConnectionCircuitNode;
    }

    private boolean needsInternalPG(INetLink iNetLink) {
        OchncCircuit ochncCircuit;
        if (iNetLink instanceof OchTrailTunnelNetLink && (ochncCircuit = (OchncCircuit)this.findOchTrailTunnel(iNetLink)) != null) {
            boolean bl = ochncCircuit.getSrcInternalSpliceLinkEnds().size() > 0 || ochncCircuit.getDstInternalSpliceLinkEnds().size() > 0;
            return bl;
        }
        return false;
    }

    private void addInternalPGs(INetLink iNetLink) {
        String string = "addInternalPGs";
        if (iNetLink instanceof OchTrailTunnelNetLink) {
            AbstractInternalPG abstractInternalPG;
            INetCircuitNode iNetCircuitNode;
            OchncCircuit ochncCircuit = (OchncCircuit)this.findOchTrailTunnel(iNetLink);
            DetailedMapNode detailedMapNode = (DetailedMapNode)this.getMapNode(iNetLink.getSrc().getNodeModel());
            if (detailedMapNode != null && (iNetCircuitNode = ochncCircuit.getCircuitNodeFromNE(iNetLink.getSrc())) instanceof DualConnectionCircuitNode) {
                abstractInternalPG = detailedMapNode.addInternalPG(iNetCircuitNode);
                this.buildList.add(string + "Added internal PG to " + detailedMapNode.getName() + " for cktNode " + iNetCircuitNode);
            }
            if ((detailedMapNode = (DetailedMapNode)this.getMapNode(iNetLink.getDst().getNodeModel())) != null && (iNetCircuitNode = ochncCircuit.getCircuitNodeFromNE(iNetLink.getDst())) instanceof DualConnectionCircuitNode) {
                abstractInternalPG = detailedMapNode.addInternalPG(iNetCircuitNode);
                this.buildList.add(string + "Added internal PG to " + detailedMapNode.getName() + " for cktNode " + iNetCircuitNode);
            }
        }
    }

    private void addDriMarker(List list) {
        boolean bl = !this.netCircuit.getCircuitTypeObj().isLoCircuitType();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            MapNode mapNode;
            INetCircuitNode iNetCircuitNode = (INetCircuitNode)iterator.next();
            INodeModel iNodeModel = iNetCircuitNode.getNodeModel();
            if (iNodeModel == null || !iNetCircuitNode.getDri() || (mapNode = this.getMapNode(iNodeModel)) == null) continue;
            String string = GENERIC_DRI_STRING;
            int n = iNetCircuitNode.getDriNodeType();
            if (n == 1) {
                string = PRIMARY_DRI_STRING;
            } else if (n == 2) {
                string = SECONDARY_DRI_STRING;
            } else if (n == 3) {
                string = INTERMEDIATE_DRI_STRING;
            }
            mapNode.addDesc(string);
        }
    }

    private INetCircuitSpan findSpan(INetCircuitEnd iNetCircuitEnd, INetCircuitEnd iNetCircuitEnd2) {
        INetLink iNetLink;
        INetLink iNetLink2 = this.netModel.findNetLinkFromSourceCktEnd(this.netCircuit.getCircuitTypeObj().isLoCircuitType(), iNetCircuitEnd.getNetElement(), iNetCircuitEnd.getEntityIndex(), iNetCircuitEnd.getHoNum());
        if (iNetLink2 != null && (iNetLink = this.netModel.findReverseLink(iNetLink2)) != null) {
            NetLinkSpan netLinkSpan = new NetLinkSpan(iNetLink2, iNetLink, iNetCircuitEnd.getHoNum(), iNetCircuitEnd2.getHoNum(), iNetCircuitEnd.getLoNum());
            return NetCircuitSpanFactory.createCircuitSpan(this.netCircuit, netLinkSpan);
        }
        return null;
    }

    public IInterfaceModel getInterfaceModel(INetCircuitEnd iNetCircuitEnd) {
        return CircuitMapUtil.getInterfaceModel(this.netCircuit, iNetCircuitEnd);
    }

    public static String getSpanLabel(IEntityModel iEntityModel, IHoNum iHoNum, ILoNum iLoNum) {
        return CircuitEndCellRenderer.asSlashSeparatedString(iEntityModel, iHoNum, iLoNum, 0);
    }

    public static String getSpanLabel(INetCircuitEnd iNetCircuitEnd) {
        return CircuitEndCellRenderer.asSlashSeparatedString(iNetCircuitEnd);
    }

    public String getCircuitName() {
        if (this.netCircuit != null) {
            return this.netCircuit.getCircuitName();
        }
        return null;
    }

    protected boolean netCircuitValidState(int n) {
        return CircuitMapUtil.circuitValidState(this.netCircuit, n);
    }

    protected boolean netCircuitValidState() {
        return this.netCircuitValidState(0);
    }

    INetCircuit getNetCircuit() {
        return this.netCircuit;
    }

    private INetCircuitNode getNetCircuitNode(MapNode mapNode) {
        Object object = mapNode.getUserObject();
        if (!(object instanceof INodeModel)) {
            return null;
        }
        INodeModel iNodeModel = (INodeModel)object;
        INetElement iNetElement = Network.instance().findNetElem(iNodeModel.getNodeId());
        return this.netCircuit.getCircuitNodeFromNE(iNetElement);
    }

    protected INodeModel getCktSrcNodeModel() {
        INetElement iNetElement = this.netCircuit.getSrcNetElement();
        if (iNetElement == null) {
            return null;
        }
        return iNetElement.getNodeModel();
    }

    protected INodeModel getCktDstNodeModel(int n) {
        INetCircuit iNetCircuit = this.netCircuit;
        List list = iNetCircuit.getCircuitNodes();
        ICircuitType iCircuitType = iNetCircuit.getCircuitTypeObj();
        Iterator iterator = list.iterator();
        int n2 = 0;
        int n3 = 0;
        while (iterator.hasNext()) {
            List list2;
            INetCircuitNode iNetCircuitNode = (INetCircuitNode)iterator.next();
            if (iCircuitType.isEthernetCircuitType() || iCircuitType.isTunnelCircuitType()) {
                if (n3 == 0 && n == 1 && (list2 = iNetCircuit.getDrops()).size() == 0) {
                    return this.getCktSrcNodeModel();
                }
                INodeModel iNodeModel = iNetCircuitNode.getNodeModel();
                if (iNodeModel != this.getCktSrcNodeModel() && iNetCircuitNode.isNodeDrop() && n == ++n2) {
                    return iNodeModel;
                }
            }
            ++n3;
            if (iCircuitType.isTunnelCircuitType()) continue;
            list2 = iNetCircuitNode.getDrops();
            Iterator iterator2 = list2.iterator();
            while (iterator2.hasNext()) {
                if (n == ++n2) {
                    return iNetCircuitNode.getNodeModel();
                }
                iterator2.next();
            }
        }
        return null;
    }

    protected INetCircuitEnd getDstDropEndpoint(int n) {
        INetCircuit iNetCircuit = this.netCircuit;
        List list = iNetCircuit.getCircuitNodes();
        ICircuitType iCircuitType = iNetCircuit.getCircuitTypeObj();
        if (!iCircuitType.isTunnelCircuitType()) {
            int n2 = 0;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                List list2 = ((INetCircuitNode)iterator.next()).getDrops();
                Iterator iterator2 = list2.iterator();
                while (iterator2.hasNext()) {
                    if (n == ++n2) {
                        return (INetCircuitEnd)iterator2.next();
                    }
                    iterator2.next();
                }
            }
        }
        return null;
    }

    protected String spanStateToString(int n) {
        String string = "";
        if (n == -1) {
            string = "(possibly because of one-way circuit?)";
        } else if (n == 0) {
            string = "IUpsrSpanState.ACTIVE";
        } else if (n == 1) {
            string = "IUpsrSpanState.STANDBY";
        } else if (n == 2) {
            string = "IUpsrSpanState.BOTH";
        } else if (n == 3) {
            string = "IUpsrSpanState.UNUSED";
        }
        return string;
    }

    private INetCircuit findLotTunnel(NetCircuitEnd netCircuitEnd, NetCircuitEnd netCircuitEnd2) {
        int n = netCircuitEnd.getEntityIndex();
        IHoNum iHoNum = netCircuitEnd.getHoNum();
        int n2 = netCircuitEnd2.getEntityIndex();
        IHoNum iHoNum2 = netCircuitEnd2.getHoNum();
        Iterator iterator = NetCircuitManager.instance().findLoTunnels(netCircuitEnd.getNetElement(), netCircuitEnd2.getNetElement()).iterator();
        while (iterator.hasNext()) {
            INetCircuit iNetCircuit = (INetCircuit)iterator.next();
            boolean bl = false;
            boolean bl2 = false;
            Iterator iterator2 = iNetCircuit.getCircuitNodes().iterator();
            while (iterator2.hasNext()) {
                ILoAditModel iLoAditModel;
                INetCircuitNode iNetCircuitNode = (INetCircuitNode)iterator2.next();
                if (!(iNetCircuitNode instanceof LoTunnelNode) || (iLoAditModel = (ILoAditModel)((LoTunnelNode)iNetCircuitNode).getConn()) == null) continue;
                IHoPathDefModel iHoPathDefModel = iLoAditModel.getHo();
                int n3 = iHoPathDefModel.getPool().getEntityIndex();
                IHoNum iHoNum3 = HoPathDefModel.physicalHo(iHoPathDefModel);
                HoLoComparator hoLoComparator = HoLoComparator.instance();
                if (!bl && n3 == n && hoLoComparator.isEqual(iHoNum3, iHoNum)) {
                    bl = true;
                }
                if (!bl2 && n3 == n2 && hoLoComparator.isEqual(iHoNum3, iHoNum2)) {
                    bl2 = true;
                }
                if (!bl || !bl2) continue;
                return iNetCircuit;
            }
        }
        return null;
    }

    private INetCircuit findOchTrailTunnel(INetLink iNetLink) {
        INetCircuit iNetCircuit = null;
        if (iNetLink instanceof OchTrailTunnelNetLink) {
            OchTrailTunnelNetLink ochTrailTunnelNetLink = (OchTrailTunnelNetLink)iNetLink;
            iNetCircuit = ochTrailTunnelNetLink.getLotCircuit();
        }
        return iNetCircuit;
    }

    public INetCircuit findLAP(INetLink iNetLink) {
        IEntityModel iEntityModel;
        IHoNum iHoNum;
        INodeModel iNodeModel;
        INetCircuit iNetCircuit = null;
        ILinkModel iLinkModel = iNetLink.getLinkModel();
        if (!iNetLink.isSrcExtendable()) {
            iNodeModel = iLinkModel.src();
            iHoNum = iLinkModel.srcHo();
        } else {
            iNodeModel = iLinkModel.dst();
            iHoNum = iLinkModel.dstHo();
        }
        try {
            iEntityModel = !iNetLink.isSrcExtendable() ? iNodeModel.getEntityTable().getEntityModelByIndex(iLinkModel.srcEntityIndex()) : iNodeModel.getEntityTable().getEntityModelByIndex(iLinkModel.dstEntityIndex());
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            iEntityModel = null;
        }
        if (iNodeModel != null && iEntityModel != null && iHoNum != null) {
            iNetCircuit = NetCircuitManager.instance().getLAPHo(iNodeModel, iEntityModel, iHoNum);
        }
        return iNetCircuit;
    }

    private void addSpan(INetCircuitSpan iNetCircuitSpan, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        Object object;
        CircuitMapLink circuitMapLink;
        String string = "\taddSpan():";
        if (this.db.on) {
            this.db.println("addSpan called for span=" + iNetCircuitSpan + ", showLoT=" + bl);
        }
        INetLink iNetLink = iNetCircuitSpan.getLink();
        ILinkModel iLinkModel = iNetLink.getLinkModel();
        INodeModel iNodeModel = iLinkModel.dst();
        INodeModel iNodeModel2 = iLinkModel.src();
        String string2 = iNodeModel2 != null ? iNodeModel2.getName() : "null";
        String string3 = iNodeModel != null ? iNodeModel.getName() : "null";
        this.buildList.add(string + " SRC=" + string2 + "\tDST=" + string3);
        boolean bl5 = false;
        boolean bl6 = false;
        CircuitMapNodeCookie circuitMapNodeCookie = new CircuitMapNodeCookie(this.netCircuit);
        if (this.getMapNode(iNodeModel) == null) {
            this.addNode(iNodeModel, false, circuitMapNodeCookie);
            this.buildList.add(string + " create CTC MapNode for DST=" + (iNodeModel != null ? iNodeModel.getName() : "null?!") + ": it doesn't exist yet.");
        }
        if (this.getMapNode(iNodeModel2) == null) {
            this.addNode(iNodeModel2, false, circuitMapNodeCookie);
            this.buildList.add(string + " create CTC MapNode for SRC=" + (iNodeModel2 != null ? iNodeModel2.getName() : "null?!") + ": it doesn't exist yet.");
        }
        DetailedMapNode detailedMapNode = (DetailedMapNode)this.getMapNode(iNodeModel2);
        DetailedMapNode detailedMapNode2 = (DetailedMapNode)this.getMapNode(iNodeModel);
        INetLinkSpan iNetLinkSpan = iNetCircuitSpan.getNetLinkSpan();
        CircuitMapLinkCookie circuitMapLinkCookie = new CircuitMapLinkCookie(this.netCircuit, iNetCircuitSpan, iNetLinkSpan);
        this.addLink(iNetLink, circuitMapLinkCookie, bl4);
        this.buildList.add(string + " NETLINKSPAN=" + iNetLinkSpan);
        if (iNetLinkSpan != null && iNetLinkSpan instanceof NetLinkSpan) {
            this.buildList.add(string + " linkSpan info: " + ((NetLinkSpan)iNetLinkSpan).prettyString());
        }
        if ((circuitMapLink = (CircuitMapLink)this.getMapLink(iNetLink)) != null && !this.isNetLinkUpBothDirection(iNetLink)) {
            circuitMapLink.clearStyles();
            object = new DetailedMapLinkStyle();
            ((DetailedMapLinkStyle)object).setDirection(0);
            ((DetailedMapLinkStyle)object).setColor(NetMapLink.LINK_DOWN_COLOR);
            circuitMapLink.addStyle((DetailedMapLinkStyle)object);
        }
        try {
            circuitMapLink.setBiDirectionalExternal(this.netCircuit.isBidirectional());
            object = CircuitMapUtil.getCircuitEnd(iNodeModel2, iLinkModel.srcEntityIndex(), iNetCircuitSpan.getSrcHoNum(), iNetCircuitSpan.getLoNum());
            NetCircuitEnd netCircuitEnd = CircuitMapUtil.getCircuitEnd(iNodeModel, iLinkModel.dstEntityIndex(), iNetCircuitSpan.getDstHoNum(), iNetCircuitSpan.getLoNum());
            if (this.db.on()) {
                this.db.println("span info before:");
                this.db.println("------------- DUMP the NETCIRCUIT");
                this.netCircuit.prettyPrint(this.db);
                this.db.println("------------- DUMP SpanInfo");
                this.db.println(CircuitMapUtil.dumpSpanInfo(iNetCircuitSpan));
            }
            int n = iNetCircuitSpan.getSpanState(iNodeModel);
            this.buildList.add(string + " getSpanState(DST)=" + this.spanStateToString(n) + "\t" + n);
            int n2 = this.netCircuit.getCircuitTypeObj().isOchncType() ? -1 : (this.netCircuit.getCircuitTypeObj().isOchTrailTunnelCircuitType() ? -1 : (this.netCircuit.getCircuitTypeObj().isOchccCircuitType() && bl3 ? -1 : iNetCircuitSpan.getSpanState(iNodeModel2)));
            this.buildList.add(string + " getSpanState(SRC)=" + this.spanStateToString(n2) + "\t" + n2);
            if (this.db.on()) {
                this.db.println("LINK CREATE: " + circuitMapLink);
                if (circuitMapLink != null && circuitMapLink instanceof NetMapLink) {
                    this.db.println(((NetMapLink)circuitMapLink).getToolTipText());
                }
                this.db.println("dstArrow=" + n + "\tsrcArrow=" + n2);
            }
            if (circuitMapLink instanceof CircuitMapLink) {
                this.setStateUsingUpsrSpanState(circuitMapLink, n2, n, bl4);
            } else {
                this.db.println("Could not set UPSR span state colors because link is not CircuitMapLink: " + circuitMapLink);
            }
            String string4 = string2 + " " + CircuitMapUtil.getSpanLabel((INetCircuitEnd)object) + " -> " + " " + string3 + CircuitMapUtil.getSpanLabel(netCircuitEnd) + " srcArrow=" + n2 + " dstArrow=" + n;
            if (this.db.on()) {
                this.db.println("add span from " + string4);
            }
            this.buildList.add(string + " [summary] " + string4);
            this.expandDetailedLogicalSpan(iNetCircuitSpan, bl, bl2, bl3, bl4);
        }
        catch (Exception exception) {
            this.db.println("Exception on span:" + iNetCircuitSpan);
            CircuitMapDebug.printStackTrace((Throwable)exception);
        }
    }

    protected void addSourceNodes(boolean bl, boolean bl2) {
        String string = "\taddSourceNodes():";
        ICircuitType iCircuitType = this.netCircuit.getCircuitTypeObj();
        if (iCircuitType.isEthernetCircuitType() || iCircuitType.isTunnelCircuitType()) {
            return;
        }
        List list = this.netCircuit.getSources();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                Object object;
                Object object2;
                INetCircuitEnd iNetCircuitEnd = (INetCircuitEnd)list.get(i);
                if (iNetCircuitEnd == null) continue;
                String string2 = "Source #" + (i + 1);
                if (!this.netCircuit.getCircuitTypeObj().isOchncType() || !this.netCircuit.isBidirectional()) {
                    if (i == 0) {
                        string2 = list.size() == 1 ? (this.netCircuit.isDiag() ? "PRBS Generator" : "Source") : "Primary";
                    }
                    if (i == 1) {
                        string2 = "Secondary";
                    }
                }
                if (bl) {
                    if (this.netCircuit.isDiag()) {
                        return;
                    }
                    object2 = new ExternalMapKey("Source");
                    this.addExtNode(iNetCircuitEnd, !bl2 ? string2 : "New Source", (ExternalMapKey)object2, bl2);
                    object = null;
                    object = iNetCircuitEnd == null ? "[CktEnd is null]" : (iNetCircuitEnd.getNodeModel() == null ? "[CktEnd Node Model is null]" : iNetCircuitEnd.getNodeModel().getName());
                    this.buildList.add(string + " added ext node to " + (String)object + "\t(" + iNetCircuitEnd + ")");
                    continue;
                }
                object2 = iNetCircuitEnd.getNodeModel();
                object = this.getMapNode(object2);
                if (object == null) continue;
                if (this.netCircuit.isDiag()) {
                    ((MapNode)object).addDesc("Source");
                    ((MapNode)object).addDesc(string2);
                } else {
                    ((MapNode)object).addDesc(string2);
                    if (!this.netCircuit.getCircuitTypeObj().isOchTrailTunnelCircuitType()) {
                        ((MapNode)object).addDesc(CircuitEndCellRenderer.asSlashSeparatedString(iNetCircuitEnd));
                    }
                }
                this.buildList.add(string + " added label to " + (object2 != null ? object2.getName() : "null") + "\t(" + iNetCircuitEnd + ")");
            }
        }
    }

    protected void addDropNodes(boolean bl, boolean bl2) {
        Object object;
        String string = "\taddDropNodes():";
        ICircuitType iCircuitType = this.netCircuit.getCircuitTypeObj();
        int n = 0;
        List list = this.netCircuit.getDrops();
        if (iCircuitType.isEthernetCircuitType() && list.size() == 0 && this.netCircuitValidState() && (object = this.netCircuit.getSources()) != null && object.size() == 1) {
            INodeModel iNodeModel = ((INetCircuitEnd)object.get(0)).getNodeModel();
            MapNode mapNode = this.getMapNode(iNodeModel);
            mapNode.addDesc("Drop");
            return;
        }
        object = list.iterator();
        while (object.hasNext()) {
            Object object2;
            Object object3;
            Object object4;
            INetCircuitEnd iNetCircuitEnd = (INetCircuitEnd)object.next();
            if (!this.netCircuit.getCircuitTypeObj().isOchccCircuitType() && NetCircuit.cktEndIsNodeDrop(iNetCircuitEnd)) {
                object4 = iNetCircuitEnd.getNodeModel();
                object3 = object4 != null ? object4.getName() : "null!?";
                this.buildList.add(string + " added " + (String)object3 + " as node drop.\t(" + iNetCircuitEnd + ")");
                object2 = this.getMapNode(object4);
                if (object2 == null) continue;
                ((MapNode)object2).addDesc("Drop");
                continue;
            }
            ++n;
            if (bl) {
                object4 = new ExternalMapKey("Destination");
                if (this.netCircuit.getCircuitTypeObj().isOchncType()) {
                    if (this.netCircuit.isBidirectional()) {
                        this.addExtNode(iNetCircuitEnd, "Drop #" + n, (ExternalMapKey)object4, bl2);
                    } else {
                        this.addExtNode(iNetCircuitEnd, "Drop", (ExternalMapKey)object4, bl2);
                    }
                } else if (this.netCircuit.getCircuitTypeObj().isOchccCircuitType()) {
                    this.addExtNode(iNetCircuitEnd, "Drop", (ExternalMapKey)object4, bl2);
                } else {
                    this.addExtNode(iNetCircuitEnd, !bl2 ? "Drop #" + n : "New Drop", (ExternalMapKey)object4, bl2);
                }
                object3 = null;
                object3 = iNetCircuitEnd == null ? "[Null Circuit End]" : (iNetCircuitEnd.getNodeModel() == null ? "[Null NodeModel from Circuit End]" : iNetCircuitEnd.getNodeModel().getName());
                this.buildList.add(string + " added  " + (String)object3 + " as " + "external drop.\t(" + iNetCircuitEnd + ")");
            } else {
                object4 = iNetCircuitEnd.getNodeModel();
                object3 = this.getMapNode(object4);
                if (object3 != null) {
                    if (this.netCircuit.getCircuitTypeObj().isOchncType()) {
                        if (this.netCircuit.isBidirectional()) {
                            ((MapNode)object3).addDesc("Drop #" + n);
                            ((MapNode)object3).addDesc(CircuitEndCellRenderer.asSlashSeparatedString(iNetCircuitEnd));
                        } else {
                            ((MapNode)object3).addDesc("Drop ");
                            ((MapNode)object3).addDesc(CircuitEndCellRenderer.asSlashSeparatedString(iNetCircuitEnd));
                        }
                    } else if (this.netCircuit.getCircuitTypeObj().isOchccCircuitType()) {
                        ((MapNode)object3).addDesc("Drop");
                        ((MapNode)object3).addDesc(CircuitEndCellRenderer.asSlashSeparatedString(iNetCircuitEnd));
                    } else {
                        ((MapNode)object3).addDesc("Drop #" + n);
                        ((MapNode)object3).addDesc(CircuitEndCellRenderer.asSlashSeparatedString(iNetCircuitEnd));
                    }
                    object2 = object4 != null ? object4.getName() : "null?!";
                    this.buildList.add(string + " added label to " + (String)object2 + "\t(" + iNetCircuitEnd + ")");
                }
            }
            if (!this.db.on()) continue;
            this.db.println("Drop # " + n + " to node " + iNetCircuitEnd.getNodeModel().getName());
        }
    }

    private void addExtNode(INetCircuitEnd iNetCircuitEnd, String string, ExternalMapKey externalMapKey, boolean bl) {
        block10: {
            try {
                Object object;
                INodeModel iNodeModel = iNetCircuitEnd.getNodeModel();
                CircuitMapNode circuitMapNode = (CircuitMapNode)this.getMapNode(iNodeModel);
                if (circuitMapNode == null) {
                    if (this.db.on()) {
                        this.db.println("addExtNode: mapnode was null, mocking one up.");
                    }
                    object = new CircuitMapNodeCookie(this.netCircuit);
                    this.addNode(iNodeModel, "", 0.0, 0.0, object);
                    circuitMapNode = (CircuitMapNode)this.getMapNode(iNodeModel);
                    if (circuitMapNode == null) {
                        if (this.db.on()) {
                            this.db.println("addExtNode: total failure adding ext node, not adding any ext node.");
                        }
                        return;
                    }
                }
                object = CircuitEndCellRenderer.asSlashSeparatedString(iNetCircuitEnd);
                CircuitExternalMapNode circuitExternalMapNode = (CircuitExternalMapNode)this.addNode(externalMapKey, circuitMapNode.getDomainName(), 0.0, 0.0, externalMapKey);
                circuitExternalMapNode.setName(string);
                ExternalMapKey externalMapKey2 = new ExternalMapKey("ExtLink");
                CircuitExternalMapLinkCookie circuitExternalMapLinkCookie = new CircuitExternalMapLinkCookie(this.netCircuit, iNetCircuitEnd);
                DetailedMapLink detailedMapLink = externalMapKey.getName().equals("Source") ? (DetailedMapLink)this.addLink(externalMapKey2, circuitExternalMapNode.getUserObject(), circuitMapNode.getUserObject(), null, circuitExternalMapLinkCookie) : (DetailedMapLink)this.addLink(externalMapKey2, circuitMapNode.getUserObject(), circuitExternalMapNode.getUserObject(), null, circuitExternalMapLinkCookie);
                detailedMapLink.setBiDirectionalExternal(this.netCircuit.isBidirectional());
                detailedMapLink.clearStyles();
                DetailedMapLinkStyle detailedMapLinkStyle = new DetailedMapLinkStyle();
                if (this.netCircuit.isBidirectional() && !this.netCircuit.getCircuitTypeObj().isOchncType()) {
                    detailedMapLinkStyle.setDirection(3);
                } else {
                    detailedMapLinkStyle.setDirection(1);
                }
                if (bl) {
                    detailedMapLinkStyle.setColor(NetMapLink.LINK_ROLL_COLOR);
                } else {
                    detailedMapLinkStyle.setColor(NetMapLink.LINK_ACTIVE_COLOR);
                }
                detailedMapLink.addStyle(detailedMapLinkStyle);
                circuitExternalMapNode.setPositionRelatedToNode(circuitMapNode);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (!this.db.on()) break block10;
                CircuitMapDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    private IUpsrOps getUpsrOps(MapNode mapNode) {
        INetCircuitNode iNetCircuitNode = this.getNetCircuitNode(mapNode);
        if (iNetCircuitNode != null) {
            return iNetCircuitNode.getUpsrOps();
        }
        return null;
    }

    private String stringFromProtectionOp(DetailedMapNode detailedMapNode, int n) {
        try {
            int n2;
            IUpsrOps iUpsrOps = this.getUpsrOps(detailedMapNode);
            if (iUpsrOps == null) {
                if (this.db.on()) {
                    this.db.println(detailedMapNode.getName() + " has null upsrops!");
                }
                return "?";
            }
            if (n == 1) {
                INodeModel iNodeModel;
                Object object = detailedMapNode.getUserObject();
                if (object instanceof INodeModel && !Feature.provides((INodeModel)(iNodeModel = (INodeModel)object), (Feature)Feature.REV_PROT_OP)) {
                    return "?";
                }
                n2 = iUpsrOps.getReverseProtectionOp();
            } else {
                n2 = iUpsrOps.getProtectionOp();
            }
            for (int i = 0; i < switchStates.length; ++i) {
                if (switchStates[i].getIntValue() != n2) continue;
                return switchStates[i].toString();
            }
            return null;
        }
        catch (Exception exception) {
            if (this.db.on()) {
                CircuitMapDebug.printStackTrace((Throwable)exception);
            }
            return null;
        }
    }

    private void addSelectors(INetCircuitNode iNetCircuitNode, IConnectionModel iConnectionModel) {
        int n;
        String string = "\taddSelectors():";
        int n2 = iNetCircuitNode.getConnectionType();
        this.buildList.add(string + iNetCircuitNode.getNodeModel() + " IConnectionType= " + n2);
        INodeModel iNodeModel = iNetCircuitNode.getNodeModel();
        CircuitMapNode circuitMapNode = (CircuitMapNode)this.getMapNode(iNodeModel);
        if (circuitMapNode == null) {
            if (this.db.on()) {
                this.db.println("Can't find mapnode from node model:" + iNodeModel.getName());
            }
            return;
        }
        MapNode[] mapNodeArray = circuitMapNode.getVNodes();
        MapNode[] mapNodeArray2 = new MapNode[mapNodeArray.length + 1];
        mapNodeArray2[0] = circuitMapNode;
        for (n = 1; n < mapNodeArray2.length; ++n) {
            mapNodeArray2[n] = mapNodeArray[n - 1];
        }
        for (n = 0; n < mapNodeArray2.length; ++n) {
            int n3;
            int n4;
            CircuitMapNode circuitMapNode2 = (CircuitMapNode)mapNodeArray2[n];
            HashSet hashSet = new HashSet();
            MapPort[] mapPortArray = circuitMapNode2.getPorts();
            List list = iNetCircuitNode.getPathList();
            List list2 = iNetCircuitNode.getActivePathList();
            int n5 = list.size();
            int n6 = list2.size();
            this.buildList.add(string + " found " + n6 + " active paths/selectors.");
            for (n4 = 0; n4 < n5; ++n4) {
                this.buildList.add(string + " fullpath #" + n4 + " " + list.get(n4));
            }
            for (n4 = 0; n4 < n6; ++n4) {
                this.buildList.add(string + " actvpath #" + n4 + " " + list2.get(n4));
            }
            CircuitMapSelector[] circuitMapSelectorArray = new CircuitMapSelector[n6];
            for (n3 = 0; n3 < n6; ++n3) {
                circuitMapSelectorArray[n3] = (CircuitMapSelector)circuitMapNode2.addSelector();
                circuitMapSelectorArray[n3].setUpsrOps(this.getUpsrOps(circuitMapNode2));
            }
            for (n3 = 0; n3 < n6; ++n3) {
                DetailedMapLinkStyle detailedMapLinkStyle;
                int n7;
                Color color;
                DetailedMapLink detailedMapLink;
                int n8;
                Object object;
                NetCircuitNode netCircuitNode;
                NetCircuitNode netCircuitNode2;
                int n9;
                int n10;
                block27: {
                    block28: {
                        block29: {
                            block25: {
                                block26: {
                                    if (n3 != 0) break block25;
                                    n10 = 0;
                                    n9 = 1;
                                    if (n2 != 13 && n2 != 15 && n2 != 14 && n2 != 16) break block26;
                                    n10 = 0;
                                    n9 = 3;
                                    break block27;
                                }
                                if (!(iNetCircuitNode instanceof DualConnectionCircuitNode) || !(netCircuitNode2 = ((DualConnectionCircuitNode)iNetCircuitNode).getOtherNode(netCircuitNode = ((DualConnectionCircuitNode)iNetCircuitNode).getFstCircuitNode())).isUpsrSelector() || netCircuitNode.isUpsrSelector()) break block27;
                                n10 = 2;
                                n9 = 3;
                                break block27;
                            }
                            if (n3 != 1) break block28;
                            n10 = 2;
                            n9 = 3;
                            if (n2 != 13) break block29;
                            n10 = 2;
                            n9 = 1;
                            break block27;
                        }
                        if (!(iNetCircuitNode instanceof DualConnectionCircuitNode) || !(netCircuitNode2 = ((DualConnectionCircuitNode)iNetCircuitNode).getOtherNode(netCircuitNode = ((DualConnectionCircuitNode)iNetCircuitNode).getFstCircuitNode())).isUpsrSelector() || !netCircuitNode.isUpsrSelector()) break block27;
                        n10 = 3;
                        n9 = 4;
                        break block27;
                    }
                    if (!this.db.on()) continue;
                    this.db.println("Strange, got PS# " + n3);
                    continue;
                }
                this.buildList.add(string + " Path Sel #" + n3 + ", " + "Selector First= " + n10 + ", Selector Second= " + n9);
                netCircuitNode = list.get(n10);
                netCircuitNode2 = list.get(n9);
                Object e = list2.get(n3);
                CircuitMapPort circuitMapPort = (CircuitMapPort)this.getMapPort(mapPortArray, netCircuitNode);
                CircuitMapPort circuitMapPort2 = (CircuitMapPort)this.getMapPort(mapPortArray, netCircuitNode2);
                CircuitMapPort circuitMapPort3 = (CircuitMapPort)this.getMapPort(mapPortArray, e);
                if (this.db.on()) {
                    if (circuitMapPort == circuitMapPort3) {
                        this.db.println("!!! NOTE  Work port = active port: " + circuitMapPort);
                    } else if (circuitMapPort2 == circuitMapPort3) {
                        this.db.println("!!! NOTE  Protect port = active port:" + circuitMapPort2);
                    }
                }
                if (null != circuitMapPort) {
                    circuitMapPort.setSuffixString(circuitMapPort.getSuffixString() + " WRK");
                }
                if (null != circuitMapPort2) {
                    circuitMapPort2.setSuffixString(circuitMapPort2.getSuffixString() + " PRT");
                }
                Color color2 = circuitMapPort == circuitMapPort3 ? NetMapLink.LINK_ACTIVE_COLOR : NetMapLink.LINK_STANDBY_COLOR;
                Color color3 = circuitMapPort == circuitMapPort3 ? NetMapLink.LINK_STANDBY_COLOR : NetMapLink.LINK_ACTIVE_COLOR;
                int n11 = circuitMapPort == circuitMapPort3 ? 4 : 5;
                int n12 = circuitMapPort == circuitMapPort3 ? 5 : 4;
                circuitMapSelectorArray[n3].addPort(circuitMapPort);
                CircuitMapLine circuitMapLine = (CircuitMapLine)circuitMapNode2.addMapLine(circuitMapSelectorArray[n3], circuitMapPort, null);
                if (circuitMapLine != null) {
                    circuitMapLine.setState(n11);
                }
                circuitMapSelectorArray[n3].addPort(circuitMapPort2);
                circuitMapLine = (CircuitMapLine)circuitMapNode2.addMapLine(circuitMapSelectorArray[n3], circuitMapPort2, null);
                if (circuitMapLine != null) {
                    circuitMapLine.setState(n12);
                }
                this.buildList.add(string + " activePath#" + n3 + ", workPort= " + circuitMapPort + ", workColor= " + MapGraphicsUtil.getColorString(color2));
                this.buildList.add(string + " activePath#" + n3 + ", protPort= " + circuitMapPort2 + ", protColor= " + MapGraphicsUtil.getColorString(color3));
                if (circuitMapPort != null) {
                    object = circuitMapNode2.getLinks(circuitMapPort);
                    for (n8 = 0; n8 < ((DetailedMapLink[])object).length; ++n8) {
                        detailedMapLink = object[n8];
                        if (this.db.on()) {
                            this.db.println("workport link: " + detailedMapLink);
                        }
                        if (!(detailedMapLink instanceof CircuitExternalMapLink)) continue;
                        color = color2 == NetMapLink.LINK_ACTIVE_COLOR ? NetMapLink.LINK_ACTIVE_COLOR : NetMapLink.LINK_STANDBY_COLOR;
                        for (n7 = 0; n7 < detailedMapLink.getNumStyles(); ++n7) {
                            detailedMapLinkStyle = detailedMapLink.getStyle(n7);
                            detailedMapLinkStyle.setColor(color);
                        }
                        this.forceLinkToExtNodeColor(circuitMapPort, NetMapLink.LINK_ACTIVE_COLOR, (CircuitExternalMapLink)detailedMapLink);
                    }
                }
                if (circuitMapPort2 != null) {
                    object = circuitMapNode2.getLinks(circuitMapPort2);
                    for (n8 = 0; n8 < ((DetailedMapLink[])object).length; ++n8) {
                        detailedMapLink = object[n8];
                        if (this.db.on()) {
                            this.db.println("protect port link: " + detailedMapLink);
                        }
                        if (!(detailedMapLink instanceof CircuitExternalMapLink)) continue;
                        color = color3 == NetMapLink.LINK_ACTIVE_COLOR ? NetMapLink.LINK_ACTIVE_COLOR : NetMapLink.LINK_STANDBY_COLOR;
                        for (n7 = 0; n7 < detailedMapLink.getNumStyles(); ++n7) {
                            detailedMapLinkStyle = detailedMapLink.getStyle(n7);
                            detailedMapLinkStyle.setColor(color);
                        }
                        this.forceLinkToExtNodeColor(circuitMapPort2, NetMapLink.LINK_ACTIVE_COLOR, (CircuitExternalMapLink)detailedMapLink);
                    }
                }
                if ((object = this.stringFromProtectionOp(circuitMapNode2, n3)) != null) {
                    circuitMapSelectorArray[n3].setLetter(((String)object).charAt(0));
                    circuitMapSelectorArray[n3].setProtectionString((String)object);
                }
                this.buildList.add(string + " sel# " + n3 + " node=" + iNodeModel.getName() + ", Op=" + (String)object);
            }
        }
    }

    private void addOchTrailProtectedSelector(INetElement iNetElement, int n) {
        String string = "\taddOchTrailProtectedSelector():";
        this.buildList.add(string + iNetElement.getNodeModel() + ", " + n);
        INodeModel iNodeModel = iNetElement.getNodeModel();
        CircuitMapNode circuitMapNode = (CircuitMapNode)this.getMapNode(iNodeModel);
        if (circuitMapNode == null) {
            if (this.db.on()) {
                this.db.println("Can't find mapnode from node model:" + iNodeModel.getName());
            }
            return;
        }
        if (!(circuitMapNode instanceof OchTrailProtectedCircuitMapNode)) {
            if (this.db.on()) {
                this.db.println("mapnode for node " + iNodeModel.getName() + " is not a OchTrailProtectedCircuitMapNode");
            }
            return;
        }
        ((OchTrailProtectedCircuitMapNode)circuitMapNode).addSelector(iNodeModel, n);
    }

    private void forceLinkToExtNodeColor(MapPort mapPort, Color color, CircuitExternalMapLink circuitExternalMapLink) {
        boolean bl = mapPort != circuitExternalMapLink.getSourcePort();
        DetailedMapLinkStyle detailedMapLinkStyle = circuitExternalMapLink.getStyle(0);
        int n = detailedMapLinkStyle.getDirection();
        Color color2 = detailedMapLinkStyle.getColor();
        if (bl) {
            if (color2 != color) {
                if (n == 2) {
                    circuitExternalMapLink.clearStyles();
                    detailedMapLinkStyle.setColor(color);
                    circuitExternalMapLink.addStyle(detailedMapLinkStyle);
                } else if (n == 3) {
                    circuitExternalMapLink.clearStyles();
                    detailedMapLinkStyle.setDirection(1);
                    circuitExternalMapLink.addStyle(detailedMapLinkStyle);
                    detailedMapLinkStyle = new DetailedMapLinkStyle(2, color);
                    circuitExternalMapLink.addStyle(detailedMapLinkStyle);
                }
            }
        } else if (color2 != color) {
            if (n == 1) {
                circuitExternalMapLink.clearStyles();
                detailedMapLinkStyle.setColor(color);
                circuitExternalMapLink.addStyle(detailedMapLinkStyle);
            } else if (n == 3) {
                circuitExternalMapLink.clearStyles();
                detailedMapLinkStyle.setDirection(2);
                circuitExternalMapLink.addStyle(detailedMapLinkStyle);
                detailedMapLinkStyle = new DetailedMapLinkStyle(1, color);
                circuitExternalMapLink.addStyle(detailedMapLinkStyle);
            }
        }
    }

    private MapPort getMapPort(MapPort[] mapPortArray, Object object) {
        ILoDefModel iLoDefModel;
        ILoNum iLoNum = null;
        if (this.db.on()) {
            this.db.println("defmodel= " + object + "\t" + object.getClass().toString());
        }
        if (object instanceof IOchccPathDefModel) {
            IOchccPathDefModel iOchccPathDefModel = (IOchccPathDefModel)object;
            int n = iOchccPathDefModel.getPortEntityIdx();
            for (int i = 0; i < mapPortArray.length; ++i) {
                MapPort mapPort = mapPortArray[i];
                CircuitMapNode circuitMapNode = (CircuitMapNode)mapPort.getParentNode();
                if (circuitMapNode.getEntityIndex(mapPort) != n) continue;
                return mapPort;
            }
            return null;
        }
        if (object instanceof ILoDefModel) {
            iLoDefModel = (ILoDefModel)object;
            object = iLoDefModel.getLoAdit().getHo();
            iLoNum = iLoDefModel.getLoNum();
        }
        if (object instanceof IHoPathDefModel) {
            iLoDefModel = (IHoPathDefModel)object;
            try {
                IHoNum iHoNum = HoPathDefModel.physicalHo((IHoPathDefModel)iLoDefModel);
                IEntityModel iEntityModel = iLoDefModel.getPool().getEntityModel();
                String string = CircuitMapUtil.getSpanLabel(iEntityModel, iHoNum, iLoNum);
                if (this.db.on()) {
                    this.db.println("OUR TARGET: " + string);
                }
                for (int i = 0; i < mapPortArray.length; ++i) {
                    MapPort mapPort = mapPortArray[i];
                    INetCircuitEnd iNetCircuitEnd = ((CircuitMapPort)mapPort).getCircuitEnd();
                    if (iEntityModel == null || !iEntityModel.equals(iNetCircuitEnd.getEntityModel()) || !HoLoComparator.instance().isEqual(iNetCircuitEnd.getHoNum(), iHoNum) || !HoLoComparator.instance().isEqual(iNetCircuitEnd.getLoNum(), iLoNum)) continue;
                    return mapPort;
                }
            }
            catch (Exception exception) {
                CircuitMapDebug.printStackTrace((Throwable)exception);
            }
        }
        return null;
    }

    protected void initPopupMenu(Object object, ActionOrganizer actionOrganizer, UPopupMenu uPopupMenu) {
        super.initPopupMenu(object, actionOrganizer, uPopupMenu);
        if (object instanceof MapNode) {
            this.popupMapNode = (MapNode)object;
            this.doInitNodePopup(actionOrganizer, uPopupMenu);
        } else if (object instanceof MapPort) {
            this.popupMapPort = (MapPort)object;
            this.doInitPortPopup(actionOrganizer, uPopupMenu);
        }
    }

    protected void doInitNodePopup(ActionOrganizer actionOrganizer, UPopupMenu uPopupMenu) {
        INetCircuitNode iNetCircuitNode;
        if (this.popupMapNode instanceof CircuitMapNode && this.isProvisioningAllowed() && (iNetCircuitNode = this.getNetCircuitNode(this.popupMapNode)) != null && CircuitMapUtil.dropOpAllowed(1, this.netCircuit, iNetCircuitNode)) {
            uPopupMenu.addSeparator();
            actionOrganizer.addMenuItem((JComponent)uPopupMenu, null, CMD_PORT_ADDDROP, 65);
        }
    }

    protected void doInitPortPopup(ActionOrganizer actionOrganizer, UPopupMenu uPopupMenu) {
        if (this.popupMapPort instanceof CircuitMapPort && CircuitMapUtil.circuitValidState(this.netCircuit, 0)) {
            CircuitMapPort circuitMapPort = (CircuitMapPort)this.popupMapPort;
            DetailedMapNode detailedMapNode = this.popupMapPort.getParentNode();
            INetCircuitNode iNetCircuitNode = this.getNetCircuitNode(detailedMapNode);
            if (circuitMapPort.isDrop() && CircuitMapUtil.dropOpAllowed(-1, this.netCircuit, iNetCircuitNode)) {
                actionOrganizer.addMenuItem((JComponent)uPopupMenu, null, CMD_PORT_REMOVEDROP, 82);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block9: {
            String string = actionEvent.getActionCommand();
            if (string.equals(CMD_PORT_ADDDROP)) {
                boolean bl = EventMaskUtil.isCtrlShiftPressed(actionEvent);
                CircuitDropCreationDialog circuitDropCreationDialog = new CircuitDropCreationDialog(this.getGraphWindow(), this.netCircuit, bl);
                circuitDropCreationDialog.presetNodeSelector((INodeModel)this.popupMapNode.getUserObject());
                circuitDropCreationDialog.show();
            } else if (string.equals(CMD_PORT_REMOVEDROP)) {
                try {
                    CircuitMapPort circuitMapPort;
                    INetCircuitEnd iNetCircuitEnd;
                    if (!CerentDialog.yesNoDialog((Component)this.getGraphWindow(), (String)"Really delete selected drop?", (String)"Delete Circuit Drops") || !(this.popupMapPort instanceof CircuitMapPort) || (iNetCircuitEnd = (circuitMapPort = (CircuitMapPort)this.popupMapPort).getCircuitEnd()) == null) break block9;
                    if (iNetCircuitEnd instanceof INetCircuitDropInfo) {
                        if (this.db.on()) {
                            this.db.println("Remove Drop: INetCircuitDropInfo");
                        }
                        INetCircuitDropInfo iNetCircuitDropInfo = (INetCircuitDropInfo)iNetCircuitEnd;
                        this.netCircuit.deleteDrop(iNetCircuitDropInfo);
                        break block9;
                    }
                    if (this.db.on()) {
                        this.db.println("Remove Drop: INetCircuitEnd");
                    }
                    this.netCircuit.deleteDrop(iNetCircuitEnd);
                }
                catch (Exception exception) {
                    CircuitMapDebug.printStackTrace((Throwable)exception);
                    ErrorMsg.displayError((Component)this.getGraphWindow(), (EID)NEMC.EID_ERROR_DELETING_CKT_DROP);
                }
            } else {
                super.actionPerformed(actionEvent);
            }
        }
    }

    protected void localDispose() {
        if (this.buildList != null) {
            this.buildList.clear();
        }
        if (this.relatedCircuitsList != null) {
            this.relatedCircuitsList.clear();
        }
        if (this.spanList != null) {
            this.spanList.clear();
        }
    }

    public void dispose() {
        this.localDispose();
        HashSet hashSet = (HashSet)this.registeredDialogSet.clone();
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e == null || !(e instanceof JDialog)) continue;
            if (this.db.on()) {
                this.db.println("Dispose() will call dispose on " + ((JDialog)e).getTitle());
            }
            ((JDialog)e).dispose();
        }
        if (this.db != null) {
            this.db.dispose();
        }
        super.dispose();
    }

    protected void updateLink(INetLink iNetLink) {
        String string = "updateLink():";
        if (this.netCircuit != null) {
            Object object;
            super.updateLink(iNetLink);
            INetCircuitSpan iNetCircuitSpan = this.getCircuitSpan(this.netCircuit, iNetLink);
            if (iNetCircuitSpan == null && this.relatedCircuitsList.size() > 0) {
                for (int i = 0; i < this.relatedCircuitsList.size(); ++i) {
                    object = (NetCircuit)this.relatedCircuitsList.get(i);
                    iNetCircuitSpan = this.getCircuitSpan((INetCircuit)object, iNetLink);
                    if (iNetCircuitSpan == null) continue;
                    if (!this.db.on()) break;
                    this.db.println("matched link = " + iNetLink + " and " + "ckt =  " + ((NetCircuit)object).getCircuitName());
                    break;
                }
            }
            if (iNetCircuitSpan == null && !this.isDetailed() && this.DWDM_FLAG) {
                this.updateCompositeLink(iNetLink);
            } else {
                MapLink mapLink = this.getMapLink(iNetLink);
                if (iNetCircuitSpan != null && mapLink != null) {
                    super.updateLink(iNetLink);
                    if (!this.isDetailed()) {
                        this.setNetMapLinkState("updateLink()", mapLink, iNetCircuitSpan.active() ? 4 : 5);
                    } else if (this.isPeerToPeerVirtualLinkForOchTrail(iNetLink)) {
                        object = (DetailedMapLink)mapLink;
                        DetailedMapLinkStyle detailedMapLinkStyle = ((DetailedMapLink)object).getStyle(0);
                        ((DetailedMapLink)object).clearStyles();
                        detailedMapLinkStyle = this.getStyleForVirtualLink(iNetLink);
                        ((DetailedMapLink)object).addStyle(detailedMapLinkStyle);
                    } else if (this.isOchTrailTunnelExpandedLink()) {
                        object = (DetailedMapLink)mapLink;
                        DetailedMapLinkStyle detailedMapLinkStyle = ((DetailedMapLink)object).getStyle(0);
                        ((DetailedMapLink)object).clearStyles();
                        if (!this.isOchTrailTunnelExpandedLinkActive(iNetLink)) {
                            detailedMapLinkStyle.setColor(NetMapLink.LINK_STANDBY_COLOR);
                        } else {
                            detailedMapLinkStyle.setColor(NetMapLink.LINK_ACTIVE_COLOR);
                        }
                        ((DetailedMapLink)object).addStyle(detailedMapLinkStyle);
                    } else {
                        try {
                            object = iNetLink.getLinkModel();
                            INodeModel iNodeModel = object.dst();
                            INodeModel iNodeModel2 = object.src();
                            int n = iNetCircuitSpan.getSpanState(iNodeModel);
                            this.buildList.add(string + " getSpanState(DST)=" + this.spanStateToString(n) + "\t" + n);
                            int n2 = this.netCircuit.getCircuitDir() == 1 ? iNetCircuitSpan.getSpanState(iNodeModel2) : -1;
                            this.buildList.add(string + " getSpanState(SRC)=" + this.spanStateToString(n2) + "\t" + n2);
                            if (this.db.on()) {
                                this.db.println("LINK UPDATE: " + mapLink);
                                if (mapLink != null && mapLink instanceof NetMapLink) {
                                    this.db.println(((NetMapLink)mapLink).getToolTipText());
                                }
                                this.db.println("dstArrow=" + n + "\tsrcArrow=" + n2);
                            }
                            if (mapLink instanceof CircuitMapLink) {
                                boolean bl = false;
                                if (this.netCircuit.getState() == 8 && !this.netCircuit.getCircuitSpans().contains(iNetCircuitSpan)) {
                                    bl = true;
                                }
                                this.setStateUsingUpsrSpanState((CircuitMapLink)mapLink, n2, n, bl);
                            } else {
                                this.db.println("Cannot set link state because link is not CircuitMapLink: " + mapLink);
                            }
                        }
                        catch (Exception exception) {
                            CircuitMapDebug.printStackTrace((Throwable)exception);
                        }
                    }
                }
            }
        }
    }

    private void updateCompositeLink(INetLink iNetLink) {
        block5: {
            try {
                if (iNetLink.isSdccLink()) {
                    MapLink mapLink;
                    int n = iNetLink.getSrcEntityIndex();
                    int n2 = iNetLink.getDstEntityIndex();
                    INodeModel iNodeModel = iNetLink.getSrc().getNodeModel();
                    IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
                    IEntityModel iEntityModel = iEntityTableModel.getEntityModelByIndex(n);
                    INodeModel iNodeModel2 = iNetLink.getDst().getNodeModel();
                    IEntityTableModel iEntityTableModel2 = iNodeModel2.getEntityTable();
                    IEntityModel iEntityModel2 = iEntityTableModel2.getEntityModelByIndex(n2);
                    IEntityModel[] iEntityModelArray = OchTrailHelper.getClientPorts(iEntityModel);
                    IEntityModel[] iEntityModelArray2 = OchTrailHelper.getClientPorts(iEntityModel2);
                    boolean bl = this.existSpanFromClientPorts(iNodeModel, iEntityModelArray);
                    if (!bl) {
                        bl = this.existSpanFromClientPorts(iNodeModel2, iEntityModelArray2);
                    }
                    if (bl && (mapLink = this.getMapLink(iNetLink)) != null) {
                        int n3 = iNetLink.getLinkModel().state() == 1 ? 4 : 1;
                        this.setNetMapLinkState("updateCompositeLink()", mapLink, n3);
                    }
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!this.db.on()) break block5;
                this.db.println("updateCompositeLink: entity index invalid");
            }
        }
    }

    private boolean existSpanFromClientPorts(INodeModel iNodeModel, IEntityModel[] iEntityModelArray) {
        block5: {
            try {
                for (int i = 0; i < iEntityModelArray.length; ++i) {
                    IElementModel iElementModel = ((IDwdmPortModel)iEntityModelArray[i]).getElementModel();
                    if (!(iElementModel instanceof IYCableModel)) continue;
                    int n = ((IYCableModel)iElementModel).getWorkingEntityIndex();
                    INetElement iNetElement = Network.instance().findNetElem(iNodeModel);
                    INetLink iNetLink = Network.instance().findNetLinkFromEnt(iNetElement, n, true);
                    INetCircuitSpan iNetCircuitSpan = this.getCircuitSpan(this.netCircuit, iNetLink);
                    if (iNetCircuitSpan == null) {
                        for (int j = 0; j < this.relatedCircuitsList.size(); ++j) {
                            NetCircuit netCircuit = (NetCircuit)this.relatedCircuitsList.get(j);
                            iNetCircuitSpan = this.getCircuitSpan(netCircuit, iNetLink);
                            if (iNetCircuitSpan == null) continue;
                            return true;
                        }
                        continue;
                    }
                    return true;
                }
            }
            catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
                if (!this.db.on()) break block5;
                this.db.println("existSpanFromClientPorts: no such element for client port");
            }
        }
        return false;
    }

    public void setViewToCenter() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (CircuitMap.this.netCircuit == null || CircuitMap.this.alreadyCentered) {
                    return;
                }
                MapGraph mapGraph = CircuitMap.this.getMapGraph();
                ArrayList<MapNode> arrayList = new ArrayList<MapNode>();
                List list = CircuitMap.this.netCircuit.getCircuitNodes();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    MapNode mapNode;
                    INetCircuitNode iNetCircuitNode = (INetCircuitNode)iterator.next();
                    if (iNetCircuitNode == null || (mapNode = mapGraph.getMapNode(iNetCircuitNode.getNodeModel())) == null) continue;
                    arrayList.add(mapNode);
                }
                if (arrayList.size() > 0) {
                    CircuitMap.this.centerView(arrayList.toArray(new MapNode[0]));
                    CircuitMap.this.alreadyCentered = true;
                }
            }
        });
    }

    private boolean isOchTrailTunnelExpandedLink() {
        return this.isDetailed() && this.OCHNC_FLAG && this.netCircuit.getCircuitTypeObj().isOchccCircuitType();
    }

    private boolean isPeerToPeerVirtualLinkForOchTrail(INetLink iNetLink) {
        return iNetLink instanceof VirtualNetLink && this.findOchTrailTunnelNetLink(iNetLink) == null && this.netCircuit.getCircuitTypeObj().isOchccCircuitType();
    }

    private OchTrailTunnelNetLink findOchTrailTunnelNetLink(INetLink iNetLink) {
        OchTrailTunnelNetLink ochTrailTunnelNetLink = null;
        if (this.netCircuit.getCircuitTypeObj().isOchccCircuitType()) {
            for (int i = 0; i < this.relatedCircuitsList.size(); ++i) {
                NetCircuit netCircuit = (NetCircuit)this.relatedCircuitsList.get(i);
                INetCircuitSpan iNetCircuitSpan = this.getCircuitSpan(netCircuit, iNetLink);
                if (iNetCircuitSpan != null) {
                    if (this.db.on()) {
                        this.db.println("Expanded link = " + iNetLink + " belongs to OTT " + "ckt =  " + netCircuit.getCircuitName());
                    }
                    List list = this.netCircuit.getCircuitSpans();
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext() && ochTrailTunnelNetLink == null) {
                        OchTrailTunnelNetLink ochTrailTunnelNetLink2;
                        INetCircuit iNetCircuit;
                        INetCircuitSpan iNetCircuitSpan2 = (INetCircuitSpan)iterator.next();
                        INetLink iNetLink2 = iNetCircuitSpan2.getLink();
                        if (iNetLink2 instanceof VirtualNetLink || !(iNetCircuit = this.findOchTrailTunnel(ochTrailTunnelNetLink2 = (OchTrailTunnelNetLink)iNetLink2)).equals(netCircuit)) continue;
                        ochTrailTunnelNetLink = ochTrailTunnelNetLink2;
                    }
                    break;
                }
                if (!this.db.on()) continue;
                this.db.println("Cannot find span for " + iNetLink + " on circuit " + netCircuit.getCircuitName());
            }
        }
        return ochTrailTunnelNetLink;
    }

    boolean isOchTrailTunnelExpandedLinkActive(INetLink iNetLink) {
        OchTrailTunnelNetLink ochTrailTunnelNetLink = this.findOchTrailTunnelNetLink(iNetLink);
        if (ochTrailTunnelNetLink != null) {
            return ochTrailTunnelNetLink.isActive(iNetLink);
        }
        if (this.db.on()) {
            this.db.println("Cannot get OTT Link for " + iNetLink);
        }
        return true;
    }

    protected boolean duplicateLinkKey(Object object) {
        return false;
    }

    public class CircuitMapDebug
    extends SDebug
    implements IDebugDiag {
        CircuitMapDebug(SDebug sDebug) {
            super((KDebug)sDebug, "circuitmap");
        }

        public final synchronized void dumpBuildStrings() {
            if (CircuitMap.this.buildList == null || CircuitMap.this.buildList.size() == 0) {
                this.println("Build List is empty!");
            } else {
                for (int i = 0; i < CircuitMap.this.buildList.size(); ++i) {
                    String string = (String)CircuitMap.this.buildList.get(i);
                    this.println(string);
                }
            }
        }

        public void dumpDiag() {
            this.dumpBuildStrings();
        }
    }

    private static class LinkDataInfo {
        AbstractNetLink netLink;
        boolean reverse;

        LinkDataInfo(AbstractNetLink abstractNetLink, boolean bl) {
            this.netLink = abstractNetLink;
            this.reverse = bl;
        }
    }
}

