/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.DeprecatedMethodCalled;
import cerent.cms.model.circuits.NetCircuitModel;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ui.circuits.AdminStatePanel;
import cerent.util.AnnotatedException;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.gui.ProgressDialog;
import cerent.util.gui.ProgressDialogControl;
import cerent.util.gui.ProgressDialogResult;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CircuitStateDialog
extends JDialog
implements ActionListener,
ProgressDialogControl {
    private static final String OK = "OK";
    private static final String CANCEL = "Cancel";
    private static final int PAUSE_INTERVAL = 100;
    private INetCircuit[] circuits;
    private AdminStatePanel adminStatePanel;
    private JButton okButton;
    private JButton cancelButton;
    private StringBuffer failures = new StringBuffer();
    private int failureCount = 0;
    private StringBuffer warnings = new StringBuffer();
    private int warningCount = 0;
    private int numSucc = 0;
    private boolean bAbort = false;
    public static final SDebug db = new SDebug("CircuitStateDialog");

    public CircuitStateDialog(Frame frame, INetCircuit[] iNetCircuitArray) {
        super(frame, "Set Circuit State", true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                CircuitStateDialog.this.dispose();
            }
        });
        this.circuits = iNetCircuitArray;
        JLabel jLabel = new JLabel("  Number of Selected Circuits:  " + iNetCircuitArray.length);
        this.getContentPane().add((Component)jLabel, "North");
        this.adminStatePanel = new AdminStatePanel("Circuit State", iNetCircuitArray, true);
        this.getContentPane().add((Component)this.adminStatePanel, "Center");
        boolean bl = false;
        for (int i = 0; i < iNetCircuitArray.length; ++i) {
            if (iNetCircuitArray[i].getCircuitTypeObj().isTunnelCircuitType() || iNetCircuitArray[i].isMemberOfVcat() || iNetCircuitArray[i].getCircuitTypeObj().isOchncType()) continue;
            bl = true;
        }
        this.adminStatePanel.setApplyDropPortsApplicable(bl);
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.adminStatePanel.registerActionListener(this);
        this.okButton.setEnabled(this.adminStatePanel.isDirty());
        this.adminStatePanel.setApplyDropPorts(Preferences.instance().getBoolean("ctc.circuit.creation", "applyDropPorts", false));
        this.pack();
        this.setLocationRelativeTo(frame);
        this.setVisible(true);
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 10, 10));
        this.okButton = this.makeActionButton(OK);
        jPanel.add(this.okButton);
        this.cancelButton = this.makeActionButton(CANCEL);
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }

    private synchronized boolean isAborted() {
        return this.bAbort;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block9: {
            Object object;
            block6: {
                block8: {
                    block7: {
                        object = actionEvent.getSource();
                        if (object != this.okButton) break block6;
                        Preferences.instance().setBoolean("ctc.circuit.creation", "applyDropPorts", this.adminStatePanel.getApplyDropPorts());
                        int n = this.adminStatePanel.getAdminState();
                        if (n == 0) break block7;
                        if (!AdminStatePanel.ConfirmDialog(null, n, this.adminStatePanel.isDropPortsSelected())) break block8;
                    }
                    ProgressDialog.start(this, "Update Circuit State", "Circuit states are being updated.  Please wait...", this, true);
                    AdminStatePanel.showAdminStateResult(this, this.adminStatePanel.getAdminState(), this.numSucc, this.circuits.length, this.warningCount, this.warnings, this.failureCount, this.failures);
                }
                this.dispose();
                break block9;
            }
            if (object == this.cancelButton) {
                this.dispose();
            } else if (object.equals(this.adminStatePanel.getActionEventSource())) {
                db.info("Enabling OK button to " + this.adminStatePanel.isDirty());
                this.okButton.setEnabled(this.adminStatePanel.isDirty());
            }
        }
    }

    public void executeTask(Observer observer) throws Exception {
        int n = this.adminStatePanel.getAdminState();
        boolean bl = this.adminStatePanel.isDirty();
        boolean bl2 = bl && this.adminStatePanel.isDropPortsSelected();
        int n2 = 0;
        while (n2 < this.circuits.length && !this.isAborted()) {
            INetCircuit iNetCircuit = this.circuits[n2++];
            observer.update(null, "Updating " + iNetCircuit.getCircuitName());
            try {
                ArrayList arrayList;
                iNetCircuit.setAdminState(n);
                ++this.numSucc;
                if (bl2 && !NetCircuitModel.setAdminStateOnDropPorts(iNetCircuit, n, arrayList = new ArrayList())) {
                    String string = "   ";
                    int n3 = 2;
                    ++this.warningCount;
                    this.warnings.append(iNetCircuit.getCircuitName()).append(":");
                    if (arrayList.size() > n3) {
                        this.warnings.append(" (more than two ports not set)\n");
                    } else {
                        this.warnings.append("\n");
                        int n4 = arrayList.size();
                        for (int i = 0; i < n4; ++i) {
                            this.warnings.append(string).append((String)arrayList.get(i)).append("\n");
                        }
                    }
                }
                observer.update(null, new Integer(n2 * 100 / this.circuits.length));
            }
            catch (Exception exception) {
                ++this.failureCount;
                this.failures.append("\n    ");
                this.failures.append(iNetCircuit.getCircuitName());
                this.failures.append(": ");
                this.failures.append(AnnotatedException.getString((Exception)exception));
            }
        }
    }

    public String getResultString(Exception exception) {
        throw new DeprecatedMethodCalled("ProgressDialogControl.getResultString(Exception)");
    }

    public ProgressDialogResult getResult(Exception exception) {
        return null;
    }

    public synchronized void stop() {
        this.bAbort = true;
    }

    public void suspend() {
    }

    public void resume() {
    }

    public boolean stopRequired() {
        return this.bAbort;
    }
}

