/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.ncp.RollManager;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.IPreselectCircuits;
import cerent.cms.ui.Pane;
import cerent.cms.ui.SubTabbedView;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.circuits.CircuitsDisabledPane;
import cerent.cms.ui.circuits.CircuitsPane;
import cerent.cms.ui.circuits.RollsPane;
import cerent.util.SDebug;
import com.cisco.ctc.CtcApplication;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JTable;
import javax.swing.SwingUtilities;

public class CircuitsTabbedView
extends AbstractPane
implements IPreselectCircuits {
    private CktDebug dbg;
    private boolean mountTab = false;
    private CircuitsPane circuitsPane = null;
    private Pane rollsPane = null;

    public CircuitsTabbedView(String string, IModel iModel, TabbedView tabbedView) {
        super(string, iModel, tabbedView);
        this.setLayout(new GridLayout(1, 1));
        String string2 = iModel != null && iModel.getNodeModel() != null ? (iModel.getNodeModel() instanceof INodeModel ? "node" : "card") : "network";
        this.dbg = new CktDebug(string2);
    }

    public void refresh() {
        boolean bl = RollManager.instance().isRollEnabledNetwork();
        if (bl) {
            this.addSubTab();
        } else {
            this.removeSubTab();
        }
    }

    public void enteringPage() throws Exception {
        if (this.circuitsPane == null || CtcApplication.instance().getCktMgtMode()) {
            this.getCircuitsPane();
        }
        RollManager.instance().addObserver((Observer)((Object)this));
        this.refresh();
        if (this.subTabs == null) {
            this.circuitsPane.enteringPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        CircuitsTabbedView circuitsTabbedView = this;
        synchronized (circuitsTabbedView) {
            if (this.subTabs == null) {
                if (this.circuitsPane != null) {
                    this.circuitsPane.destroy();
                }
                if (this.rollsPane != null) {
                    this.rollsPane.destroy();
                }
            }
        }
        super.destroy();
        this.dbg.dispose();
    }

    private synchronized void addSubTab() {
        if (this.subTabs == null) {
            this.mountTab = true;
            if (this.rollsPane == null) {
                this.rollsPane = new RollsPane("Rolls", this.getUiModel(), this.getParentView());
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CircuitsTabbedView.this.runUpdate();
                }
            });
        }
    }

    private synchronized void removeSubTab() {
        if (this.subTabs != null) {
            this.mountTab = false;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CircuitsTabbedView.this.runUpdate();
                }
            });
        }
    }

    public void leavingPage() throws Exception {
        RollManager.instance().deleteObserver((Observer)((Object)this));
        if (this.subTabs == null) {
            this.circuitsPane.leavingPage();
        }
    }

    public JTable getTable() {
        if (this.subTabs == null) {
            return this.circuitsPane.getTable();
        }
        return super.getTable();
    }

    public void update(Observable observable, Object object) {
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runUpdate() {
        boolean bl = false;
        boolean bl2 = false;
        CircuitsTabbedView circuitsTabbedView = this;
        synchronized (circuitsTabbedView) {
            if (this.subTabs != null && !this.mountTab) {
                this.remove((Component)this.subTabs);
                try {
                    this.subTabs.setShowing(false);
                }
                catch (Exception exception) {
                    CktDebug.printStackTrace((Throwable)exception);
                }
                this.subTabs.remove((Component)((Object)this.circuitsPane));
                this.subTabs.remove((Component)this.rollsPane);
                this.subTabs = null;
                this.add((Component)((Object)this.circuitsPane));
                bl = true;
            } else if (this.subTabs == null && this.mountTab) {
                this.remove((Component)((Object)this.circuitsPane));
                try {
                    this.circuitsPane.setShowing(false);
                }
                catch (Exception exception) {
                    CktDebug.printStackTrace((Throwable)exception);
                }
                this.subTabs = new SubTabbedView(this.getUiModel(), this.getParentView());
                this.subTabs.setTabPlacement(2);
                this.subTabs.add((Component)((Object)this.circuitsPane));
                this.subTabs.add((Component)this.rollsPane);
                this.add((Component)this.subTabs);
                bl2 = true;
            }
        }
        if (bl) {
            try {
                this.circuitsPane.setShowing(true);
            }
            catch (Exception exception) {
                CktDebug.printStackTrace((Throwable)exception);
            }
            this.circuitsPane.revalidate();
            this.circuitsPane.repaint();
        }
        if (bl2) {
            try {
                this.subTabs.setShowing(true);
            }
            catch (Exception exception) {
                CktDebug.printStackTrace((Throwable)exception);
            }
            this.subTabs.revalidate();
            this.subTabs.repaint();
        }
    }

    public void setShowing(boolean bl) throws Exception {
        super.setShowing(bl);
    }

    public synchronized CircuitsPane getCircuitsPane() {
        if (this.circuitsPane == null) {
            if (!CtcApplication.instance().getCktMgtMode()) {
                if (this.dbg.on()) {
                    this.dbg.println("get CircuitsDisabledPane");
                }
                this.circuitsPane = new CircuitsDisabledPane("Circuits", this.getUiModel(), this.getParentView());
            } else {
                if (this.dbg.on()) {
                    this.dbg.println("get CircuitsPane");
                }
                this.circuitsPane = new CircuitsPane("Circuits", this.getUiModel(), this.getParentView());
            }
            this.add((Component)((Object)this.circuitsPane));
        } else if (this.circuitsPane instanceof CircuitsDisabledPane && CtcApplication.instance().getCktMgtMode()) {
            if (this.dbg.on()) {
                this.dbg.println("get CircuitsPane after circuits mgmt enabled");
            }
            this.removeAll();
            this.circuitsPane = new CircuitsPane("Circuits", this.getUiModel(), this.getParentView());
            this.add((Component)((Object)this.circuitsPane));
            this.circuitsPane.revalidate();
            if (this.subTabs != null && !this.subTabs.isShowing()) {
                this.subTabs.removeAll();
                this.subTabs = null;
            }
        }
        return this.circuitsPane;
    }

    public void setPreselectedCircuitIds(List list) {
        this.getCircuitsPane().setPreselectedCircuitIds(list);
    }

    public class CktDebug
    extends SDebug {
        public CktDebug(String string) {
            super("CktTab:" + string);
        }

        public final void mountTab() {
            CircuitsTabbedView.this.addSubTab();
        }

        public final void unmountTab() {
            CircuitsTabbedView.this.removeSubTab();
        }
    }
}

