/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.IPortModel;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.circuits.IJTrace;
import cerent.cms.ui.circuits.J1PathTrace;
import cerent.cms.ui.circuits.JnProvPane;
import cerent.util.HoLoFactory;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import java.awt.Component;
import java.util.Iterator;
import java.util.List;

public class Ds3iSonetJnProvPane
extends JnProvPane {
    private static final String message = "Changes have not been applied yet. Provision next port?";
    private static final int NUM_OF_PORTS = 3;
    private IJTrace j1Trace;
    private IInterfaceModel[] portIfModel;
    private IJTrace[] j1PathTraces;
    private static final SDebug db = new SDebug("Ds3iSonetJnProvPane");

    public Ds3iSonetJnProvPane(int n, String string, INetCircuit iNetCircuit, IInterfaceModel[] iInterfaceModelArray, boolean[] blArray, int[] nArray, String[] stringArray, boolean bl, TabbedView tabbedView, INetCircuitEnd[] iNetCircuitEndArray) {
        super(n, string, iNetCircuit, iInterfaceModelArray, blArray, nArray, stringArray, bl, tabbedView, iNetCircuitEndArray);
    }

    protected void setIfModels(IInterfaceModel[] iInterfaceModelArray) {
        this.ifModels = this.getInterfaceModelsForDs3iPortSet(iInterfaceModelArray[0]);
    }

    private IInterfaceModel[] getInterfaceModelsForDs3iPortSet(IInterfaceModel iInterfaceModel) {
        IPortModel iPortModel;
        IInterfaceModel[] iInterfaceModelArray = new IInterfaceModel[3];
        iInterfaceModelArray[0] = iInterfaceModel;
        try {
            iPortModel = iInterfaceModel.getPortModel();
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            db.severe("can't find DS3I port model: " + abstractCmsNoSuchEntityException.getMessage());
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            return iInterfaceModelArray;
        }
        IModuleModel iModuleModel = (IModuleModel)iPortModel.getParent();
        List list = iModuleModel.getPortsInGroup(iPortModel, 2);
        int n = 1;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IPortModel iPortModel2 = (IPortModel)iterator.next();
            if (iPortModel2.equals(iPortModel)) continue;
            iInterfaceModelArray[n++] = iPortModel2.getTdmHoModel(HoLoFactory.createFirstHoNum(0));
        }
        return iInterfaceModelArray;
    }

    protected boolean supportsFormatChange() {
        return true;
    }

    protected void displayPathTraceForSelectedPort() {
        if (this.isProvPaneDirty() && !CerentDialog.yesNoDialog((Component)((Object)this), (String)message, (String)"Confirm ")) {
            this.portBox.setSelectedIndex(this.currentSelectedIndex);
            return;
        }
        this.currentSelectedIndex = this.portBox.getSelectedIndex();
        this.jTrace = this.j1PathTraces[this.currentSelectedIndex];
        this.refreshFromModel();
        this.setDirty(false);
    }

    protected IJTrace createJ1PathTrace(INetCircuit iNetCircuit, boolean bl) {
        this.j1PathTraces = new IJTrace[3];
        for (int i = 0; i < 3; ++i) {
            IInterfaceModel[] iInterfaceModelArray = new IInterfaceModel[]{this.ifModels[i]};
            this.j1PathTraces[i] = new J1PathTrace(iInterfaceModelArray, iNetCircuit, bl);
            if (!db.on()) continue;
            db.println("create path trace " + i + ", model is " + this.ifModels[i].getClass().getName());
        }
        return this.j1PathTraces[this.currentSelectedIndex];
    }
}

