/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.IPortModel;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ui.circuits.CircuitMap;
import cerent.cms.ui.circuits.Ds3iSonetJnProvPane;
import cerent.cms.ui.circuits.JnProvPane;
import cerent.cms.ui.network.CircuitExternalMapLink;
import cerent.cms.ui.network.CircuitExternalMapNode;
import cerent.cms.ui.network.CircuitMapLink;
import cerent.cms.ui.network.CircuitMapNode;
import cerent.cms.ui.network.CircuitMapPort;
import cerent.util.SDebug;
import cerent.util.gui.UDialog;
import com.cisco.ctc.util.map.DetailedMapLink;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class JnDialog
extends UDialog
implements ActionListener {
    public static final String DST_STRING = "D";
    public static final String SRC_STRING = "S";
    public static final String NOTSRCDST_STRING = "I";
    private JButton closeButton;
    private JnProvPane jnPane;
    private int numPorts;
    private int jNum;
    private static final String CLOSE = "Close";
    private CircuitMap circuitMap;
    private static final SDebug db = new SDebug("JnDialog");

    public static JnDialog instance(boolean bl, List list) {
        String string = "Edit Path Trace";
        Frame frame = JOptionPane.getFrameForComponent(null);
        return new JnDialog(frame, string, bl, list);
    }

    JnDialog(Frame frame, String string, boolean bl, List list) {
        super(frame, string, bl, (Object)list);
    }

    public void initContentPane(JPanel jPanel, Object object) {
        List list = (List)object;
        boolean bl = (Boolean)list.get(0);
        INetCircuit iNetCircuit = (INetCircuit)list.get(1);
        List list2 = (List)list.get(2);
        this.jNum = (Integer)list.get(3);
        this.circuitMap = (CircuitMap)list.get(4);
        if (this.circuitMap != null) {
            this.circuitMap.registerDialog((JDialog)((Object)this));
        }
        this.numPorts = list2.size();
        boolean[] blArray = new boolean[this.numPorts];
        int[] nArray = new int[this.numPorts];
        String[] stringArray = new String[this.numPorts];
        IInterfaceModel[] iInterfaceModelArray = new IInterfaceModel[this.numPorts];
        INetCircuitEnd[] iNetCircuitEndArray = new INetCircuitEnd[this.numPorts];
        for (int i = 0; i < this.numPorts; ++i) {
            DetailedMapLink detailedMapLink;
            blArray[i] = false;
            nArray[i] = 0;
            CircuitMapPort circuitMapPort = (CircuitMapPort)list2.get(i);
            CircuitMapNode circuitMapNode = (CircuitMapNode)circuitMapPort.getParentNode();
            stringArray[i] = NOTSRCDST_STRING;
            DetailedMapLink[] detailedMapLinkArray = circuitMapNode.getLinks(circuitMapPort);
            if (detailedMapLinkArray.length > 0) {
                detailedMapLink = detailedMapLinkArray[0];
                if (detailedMapLink.getSourceNode() instanceof CircuitExternalMapNode) {
                    CircuitExternalMapNode circuitExternalMapNode = (CircuitExternalMapNode)detailedMapLink.getSourceNode();
                    if (circuitExternalMapNode.isExternalSource()) {
                        stringArray[i] = SRC_STRING;
                    } else if (circuitExternalMapNode.isExternalDest()) {
                        stringArray[i] = DST_STRING;
                    }
                } else if (detailedMapLink.getTargetNode() instanceof CircuitExternalMapNode) {
                    CircuitExternalMapNode circuitExternalMapNode = (CircuitExternalMapNode)detailedMapLink.getTargetNode();
                    if (circuitExternalMapNode.isExternalSource()) {
                        stringArray[i] = SRC_STRING;
                    } else if (circuitExternalMapNode.isExternalDest()) {
                        stringArray[i] = DST_STRING;
                    }
                }
                if (detailedMapLink instanceof CircuitMapLink) {
                    nArray[i] = ((CircuitMapLink)detailedMapLink).getTransmitExpect(circuitMapPort);
                } else if (detailedMapLink instanceof CircuitExternalMapLink) {
                    boolean bl2 = iNetCircuit.isBidirectional();
                    if (bl2) {
                        nArray[i] = 3;
                    } else if (stringArray[i] == SRC_STRING) {
                        nArray[i] = 1;
                    } else if (stringArray[i] == DST_STRING) {
                        nArray[i] = 2;
                    }
                }
            }
            if (circuitMapPort.isInternalPort()) {
                nArray[i] = 3;
            }
            iNetCircuitEndArray[i] = circuitMapPort.getCircuitEnd();
            iInterfaceModelArray[i] = circuitMapPort.getIfModel();
            try {
                detailedMapLink = iNetCircuitEndArray[i].getEntityModel();
                if (detailedMapLink instanceof IPortModel) {
                    IPortModel iPortModel = (IPortModel)detailedMapLink;
                    blArray[i] = iPortModel.isOptical() || iPortModel.getEqType() == 31;
                }
                String string = detailedMapLink.getNodeModel().getName();
                if (this.jNum == 1) {
                    string = string + " Edit J1 Path Trace";
                } else if (this.jNum == 2) {
                    string = string + " Edit J2 Path Trace";
                } else if (this.jNum == 3) {
                    string = string + " Edit Trace Trail Identifier";
                }
                this.setTitle(string + ": " + circuitMapPort.getInfoString());
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
            if (bl) {
                this.setTitle("Circuit Level Path Trace: ");
            }
            if (!db.on()) continue;
            db.println("Model #" + i + ": " + " isOptical: " + blArray[i] + " transExp: " + nArray[i]);
        }
        this.jnPane = this.isModelOnSonetDs3iPort(iInterfaceModelArray[0]) ? new Ds3iSonetJnProvPane(this.jNum, "", iNetCircuit, iInterfaceModelArray, blArray, nArray, stringArray, bl, null, iNetCircuitEndArray) : new JnProvPane(this.jNum, "", iNetCircuit, iInterfaceModelArray, blArray, nArray, stringArray, bl, null, iNetCircuitEndArray);
        jPanel.add((Component)((Object)this.jnPane), "Center");
        jPanel.add((Component)this.getButtonPanel(), "South");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.closeButton) {
            this.dispose();
        }
    }

    public void dispose() {
        if (db.on()) {
            db.println(this.getTitle() + " disposed");
        }
        if (this.jnPane != null) {
            try {
                this.jnPane.leavingPage();
            }
            catch (Exception exception) {
                this.setDefaultCloseOperation(0);
                return;
            }
            this.jnPane.destroy();
            this.jnPane = null;
        }
        if (this.circuitMap != null) {
            this.circuitMap.deregisterDialog((JDialog)((Object)this));
        }
        super.dispose();
    }

    private JComponent getButtonPanel() {
        this.closeButton = new JButton(CLOSE);
        this.closeButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 50, 0));
        jPanel.add(this.closeButton);
        return jPanel;
    }

    private boolean isModelOnSonetDs3iPort(IInterfaceModel iInterfaceModel) {
        boolean bl;
        block3: {
            bl = false;
            try {
                IPortModel iPortModel = iInterfaceModel.getPortModel();
                if (iPortModel != null && iPortModel.getNodeModel().getFramingType() == 0 && iPortModel.getEqType() == 70) {
                    bl = true;
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!db.on()) break block3;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        return bl;
    }
}

