/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.IEntityModel;
import cerent.cms.model.OchPortsHelper;
import cerent.cms.model.OchTrailHelper;
import cerent.cms.ncp.DualConnectionCircuitNode;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.OchncCircuit;
import cerent.cms.ui.circuits.CircuitEndCellRenderer;
import cerent.cms.ui.circuits.OchTrailProtectedCircuitMapPort;
import cerent.cms.ui.network.CircuitMapNode;
import cerent.cms.ui.network.CircuitMapPort;
import cerent.cms.ui.network.CircuitMapPortCookie;
import cerent.util.SDebug;
import com.cisco.ctc.util.map.AbstractInternalPG;
import com.cisco.ctc.util.map.DetailedMapNode;
import com.cisco.ctc.util.map.MapPolygon;
import com.cisco.ctc.util.map.MapPort;
import com.cisco.ctc.util.map.MapTriangle;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;

public class OchTrailInternalPG
extends AbstractInternalPG {
    private static final SDebug db = new SDebug("OchTrailInternalPG");
    public static final int NORTH = 0;
    public static final int WEST = 1;
    public static final int SOUTH = 2;
    public static final int EAST = 3;
    public static final double LENGTH = 20.0;
    public static final double LENGTH_HALF = 10.0;
    public static final double LENGTH_HALF_XYOFFSET = OchTrailInternalPG.getXYOffset(10.0);
    public static final double HEIGHT = OchTrailInternalPG.getTriangleHeight(20.0, 10.0) - 5.0;
    public static final double HEIGHT_HALF = HEIGHT / 2.0;
    public static final double HEIGHT_HALF_XYOFFSET = LENGTH_HALF_XYOFFSET;
    public static final double BORDER_GAP = 6.0;
    public static final double BORDER_GAP_XYOFFSET = OchTrailInternalPG.getXYOffset(6.0);
    private MapPort ots1;
    private MapPort ots2;
    private MapPort och1;
    private MapPort och2;
    private MapPort trunk;
    private INetCircuitEnd och1Nce;
    private INetCircuitEnd och2Nce;
    private INetCircuitEnd trunkNce;
    private IEntityModel trunkEM;
    private IEntityModel och1EM;
    private IEntityModel och2EM;
    private boolean isOchTrailTunnel;
    private boolean isProtected;

    private static double getTriangleHeight(double d, double d2) {
        return Math.sqrt(d * d + d2 * d2);
    }

    private static double getXYOffset(double d) {
        return d / Math.sqrt(2.0);
    }

    private static final double avg(double d, double d2) {
        return (d + d2) / 2.0;
    }

    public OchTrailInternalPG(DetailedMapNode detailedMapNode) {
        super(detailedMapNode);
        if (detailedMapNode instanceof CircuitMapNode) {
            INetCircuit iNetCircuit = ((CircuitMapNode)detailedMapNode).getNetCircuit();
            this.isOchTrailTunnel = iNetCircuit instanceof OchncCircuit;
        }
    }

    protected MapPolygon getShapeObject() {
        MapTriangle mapTriangle = new MapTriangle();
        mapTriangle.setColor(Color.white);
        mapTriangle.setFillOn(true);
        return mapTriangle;
    }

    protected MapPort[] getInternalPorts() {
        OchTrailInternalPGCookie ochTrailInternalPGCookie = (OchTrailInternalPGCookie)this.getUserCookie();
        INetCircuit iNetCircuit = ochTrailInternalPGCookie.getCktNode().getCircuit();
        String string = this.och1Nce != null ? CircuitEndCellRenderer.asSlashSeparatedString(this.och1EM, null, null, this.och1Nce.getPathIdentifier(), false) : "Unknown och";
        CircuitMapPortCookie circuitMapPortCookie = new CircuitMapPortCookie(iNetCircuit, string);
        this.och1 = new InternalCircuitMapPort(this.getParentNode());
        this.och1.init(this.och1Nce, circuitMapPortCookie);
        string = this.och2Nce != null ? CircuitEndCellRenderer.asSlashSeparatedString(this.och2EM, null, null, this.och2Nce.getPathIdentifier(), false) : "Unknown och";
        circuitMapPortCookie = new CircuitMapPortCookie(iNetCircuit, string);
        this.och2 = new InternalCircuitMapPort(this.getParentNode());
        this.och2.init(this.och2Nce, circuitMapPortCookie);
        string = this.trunkNce != null ? CircuitEndCellRenderer.asSlashSeparatedString(this.trunkEM, null, null, this.trunkNce.getPathIdentifier(), false) : "Unknown trunk";
        circuitMapPortCookie = new CircuitMapPortCookie(iNetCircuit, string);
        if (this.isOchTrailTunnel || !OchTrailHelper.isLineCard(this.trunkEM)) {
            this.trunk = this.isOchTrailTunnel || !this.isProtected ? new InternalCircuitMapPort(this.getParentNode()) : new OchTrailProtectedCircuitMapPort.InternalCircuitMapPort(this, this.getParentNode(), this.trunkEM.getEntityIndex());
            this.trunk.init(this.trunkNce, circuitMapPortCookie);
            return new MapPort[]{this.och1, this.och2, this.trunk};
        }
        return new MapPort[]{this.och1, this.och2};
    }

    protected void graphicallyInit() {
        this.side = 0;
    }

    public void updatePositionInNode() {
        int n;
        if (this.ots1 == null || this.ots2 == null) {
            return;
        }
        int n2 = this.ots1.getSide();
        if (n2 != (n = this.ots2.getSide())) {
            db.warning("Side1 and side2 differs: " + n2 + " != " + n + "\nSide1 will be used.");
        }
        switch (n2) {
            case 1: {
                this.side = 0;
                break;
            }
            case -2: {
                this.side = 1;
                break;
            }
            case -1: {
                this.side = 2;
                break;
            }
            case 2: {
                this.side = 3;
            }
        }
        if (this.och1 != null) {
            this.och1.setSide(this.side);
        }
        if (this.och2 != null) {
            this.och2.setSide(this.side);
        }
        if (this.trunk != null) {
            this.trunk.setSide(this.side);
        }
        if (db.on()) {
            db.println("UpdatePositionInNode:\nOTS1: side " + n2 + "\n" + "OTS2: side " + n + "\n" + "PG: side " + this.side);
        }
        double d = 0.0;
        double d2 = 0.0;
        Rectangle2D rectangle2D = this.ots1.getBounds();
        double d3 = this.ots1.getCenterX();
        double d4 = rectangle2D.getX();
        double d5 = rectangle2D.getMaxX();
        double d6 = this.ots1.getCenterY();
        double d7 = rectangle2D.getY();
        double d8 = rectangle2D.getMaxY();
        Rectangle2D rectangle2D2 = this.ots2.getBounds();
        double d9 = this.ots2.getCenterX();
        double d10 = rectangle2D2.getX();
        double d11 = rectangle2D2.getMaxX();
        double d12 = this.ots2.getCenterY();
        double d13 = rectangle2D2.getY();
        double d14 = rectangle2D2.getMaxY();
        Point2D point2D = null;
        Point2D point2D2 = null;
        Point2D point2D3 = null;
        switch (this.side) {
            case 0: {
                d = OchTrailInternalPG.avg(d3, d9);
                d2 = d8 + 6.0;
                if (d3 < d9) {
                    point2D = this.setVertix(1, d - 10.0, d2);
                    point2D2 = this.setVertix(2, d + 10.0, d2);
                } else {
                    point2D = this.setVertix(1, d + 10.0, d2);
                    point2D2 = this.setVertix(2, d - 10.0, d2);
                }
                point2D3 = this.setVertix(3, d, d2 + HEIGHT);
                break;
            }
            case 1: {
                d = d5 + 6.0;
                d2 = OchTrailInternalPG.avg(d6, d12);
                if (d6 < d12) {
                    point2D = this.setVertix(1, d, d2 - 10.0);
                    point2D2 = this.setVertix(2, d, d2 + 10.0);
                } else {
                    point2D = this.setVertix(1, d, d2 + 10.0);
                    point2D2 = this.setVertix(2, d, d2 - 10.0);
                }
                point2D3 = this.setVertix(3, d + HEIGHT, d2);
                break;
            }
            case 2: {
                d = OchTrailInternalPG.avg(d3, d9);
                d2 = d7 - 6.0;
                if (d3 < d9) {
                    point2D = this.setVertix(1, d - 10.0, d2);
                    point2D2 = this.setVertix(2, d + 10.0, d2);
                } else {
                    point2D = this.setVertix(1, d + 10.0, d2);
                    point2D2 = this.setVertix(2, d - 10.0, d2);
                }
                point2D3 = this.setVertix(3, d, d2 - HEIGHT);
                break;
            }
            case 3: {
                d = d4 - 6.0;
                d2 = OchTrailInternalPG.avg(d6, d12);
                if (d6 < d12) {
                    point2D = this.setVertix(1, d, d2 - 10.0);
                    point2D2 = this.setVertix(2, d, d2 + 10.0);
                } else {
                    point2D = this.setVertix(1, d, d2 + 10.0);
                    point2D2 = this.setVertix(2, d, d2 - 10.0);
                }
                point2D3 = this.setVertix(3, d - HEIGHT, d2);
            }
        }
        if (point2D != null && point2D2 != null && point2D3 != null) {
            if (this.shapeObject != null) {
                MapTriangle mapTriangle = (MapTriangle)this.shapeObject;
                Point2D[] point2DArray = new Point2D[]{point2D, point2D2, point2D3};
                mapTriangle.setVertices(point2DArray);
            }
            if (db.on()) {
                db.println("UpdatePositionInNode:\nOTS1: (" + d3 + ", " + d6 + ")\n" + "OTS2: (" + d9 + ", " + d12 + ")\n" + "PG: (" + d + ", " + d2 + ")\n" + "V1: (" + point2D.getX() + ", " + point2D.getY() + ")\n" + "V2: (" + point2D2.getX() + ", " + point2D2.getY() + ")\n" + "V3: (" + point2D3.getX() + ", " + point2D3.getY() + ")\n");
            }
        }
    }

    private Point2D setVertix(int n, double d, double d2) {
        Point2D.Double double_ = new Point2D.Double();
        switch (n) {
            case 1: {
                double_.setLocation(d, d2);
                this.och1.setCenter(d, d2);
                break;
            }
            case 2: {
                double_.setLocation(d, d2);
                this.och2.setCenter(d, d2);
                break;
            }
            case 3: {
                double_.setLocation(d, d2);
                if (this.trunk == null) break;
                this.trunk.setCenter(d, d2);
                break;
            }
            default: {
                double_ = null;
                db.warning("Called setVertix with invalid index " + n);
            }
        }
        return double_;
    }

    public void init(Object object, Object object2) throws Exception {
        super.init(object, object2);
        OchTrailInternalPGCookie ochTrailInternalPGCookie = (OchTrailInternalPGCookie)object2;
        IEntityModel iEntityModel = null;
        IEntityModel iEntityModel2 = null;
        DualConnectionCircuitNode dualConnectionCircuitNode = ochTrailInternalPGCookie.getCktNode();
        OchncCircuit ochncCircuit = ochTrailInternalPGCookie.getOchncCircuit();
        List list = ochncCircuit.getSrcNetElement().equals(dualConnectionCircuitNode.getNetElement()) ? ochncCircuit.getSrcInternalSpliceLinkEnds() : ochncCircuit.getDstInternalSpliceLinkEnds();
        if (list.size() != 3) {
            throw new Exception("Cannot make OchTrail Internal PG with " + list.size() + " OCHNC ckt ports (3 required)");
        }
        this.trunkNce = (INetCircuitEnd)list.get(0);
        this.trunkEM = this.trunkNce.getEntityModel();
        this.isProtected = OchTrailHelper.isProtected(this.trunkEM);
        this.och1Nce = (INetCircuitEnd)list.get(1);
        this.och1EM = this.och1Nce.getEntityModel();
        this.och2Nce = (INetCircuitEnd)list.get(2);
        this.och2EM = this.och2Nce.getEntityModel();
        if (!this.trunkNce.getNetElement().equals(dualConnectionCircuitNode.getNetElement())) {
            list = ochncCircuit.getSrcNetElement().equals(dualConnectionCircuitNode.getNetElement()) ? ochncCircuit.getDstInternalSpliceLinkEnds() : ochncCircuit.getSrcInternalSpliceLinkEnds();
            if (list.size() == 3) {
                this.trunkNce = (INetCircuitEnd)list.get(0);
                this.trunkEM = this.trunkNce.getEntityModel();
                this.isProtected = OchTrailHelper.isProtected(this.trunkEM);
                this.och1Nce = (INetCircuitEnd)list.get(1);
                this.och1EM = this.och1Nce.getEntityModel();
                this.och2Nce = (INetCircuitEnd)list.get(2);
                this.och2EM = this.och2Nce.getEntityModel();
            } else {
                throw new Exception("Cannot make OchTrail Internal PG with " + list.size() + " OCHNC ckt ports (3 required)");
            }
        }
        if (db.on()) {
            db.println("Found EM Ports: OCH1 = " + this.och1EM + ", OCH2 = " + this.och2EM + ", Trunk = " + this.trunkEM);
        }
        int n = ochTrailInternalPGCookie.getOchncCircuit().getCircuitOptChannel();
        this.ots1 = null;
        this.ots2 = null;
        if (this.och1EM != null) {
            iEntityModel = OchPortsHelper.getOutLinePort(n, this.och1EM);
            this.ots1 = this.getMapPortFromEM(iEntityModel);
        }
        if (this.och2EM != null) {
            iEntityModel2 = OchPortsHelper.getInLinePort(n, this.och2EM);
            this.ots2 = this.getMapPortFromEM(iEntityModel2);
        }
        if (db.on()) {
            db.println("Found OTS EMs: OTS1 = " + iEntityModel + ", OTS22 = " + iEntityModel2);
            db.println("Found OTS MapPorts: ots1 = " + this.ots1 + ", OTS2 = " + this.ots2);
        }
        if (this.ots1 != null && this.ots2 != null) {
            this.setPorts(new MapPort[]{this.ots1, this.ots2});
        }
    }

    private MapPort getMapPortFromEM(IEntityModel iEntityModel) {
        int n = iEntityModel.getEntityIndex();
        MapPort[] mapPortArray = this.parentNode.getPorts();
        if (db.on()) {
            db.println("getMapPortFromEM() seeking from " + mapPortArray.length + " ports");
        }
        for (int i = 0; i < mapPortArray.length; ++i) {
            MapPort mapPort = mapPortArray[i];
            if (db.on()) {
                db.println("getMapPortFromEM() checking with " + mapPort);
            }
            if (((CircuitMapNode)this.parentNode).getEntityIndex(mapPort) != n) continue;
            return mapPort;
        }
        return null;
    }

    public class InternalCircuitMapPort
    extends CircuitMapPort {
        private static final double PORTWIDTH = 8.0;
        private static final double PORTHEIGHT = 8.0;

        public InternalCircuitMapPort(DetailedMapNode detailedMapNode) {
            super(detailedMapNode, null);
            this.setInternalPG(OchTrailInternalPG.this);
        }

        public void graphicallyInitPort() {
            super.graphicallyInitPort();
            this.setSize(8.0, 8.0);
        }
    }

    static class OchTrailInternalPGCookie {
        private DualConnectionCircuitNode cktNode;
        private OchncCircuit ochncCircuit;

        public OchTrailInternalPGCookie(DualConnectionCircuitNode dualConnectionCircuitNode) {
            this.cktNode = dualConnectionCircuitNode;
            this.ochncCircuit = (OchncCircuit)dualConnectionCircuitNode.getCircuit();
        }

        public DualConnectionCircuitNode getCktNode() {
            return this.cktNode;
        }

        public OchncCircuit getOchncCircuit() {
            return this.ochncCircuit;
        }
    }
}

