/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.Attribute;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.OchTrailHelper;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ui.NetworkDefaults;
import cerent.cms.ui.circuits.OchTrailProtectedCircuitMapPort;
import cerent.cms.ui.circuits.OchTrailProtectedMapSelector;
import cerent.cms.ui.network.CircuitMapLine;
import cerent.cms.ui.network.CircuitMapNode;
import cerent.cms.ui.network.CircuitMapPort;
import cerent.cms.ui.network.NetMapLink;
import cerent.util.SDebug;
import com.cisco.ctc.util.map.DetailedMapNode;
import com.cisco.ctc.util.map.MapGraphicsUtil;
import com.cisco.ctc.util.map.MapLinkConnector;
import com.cisco.ctc.util.map.MapPort;
import com.cisco.ctc.util.map.MapSelector;
import com.cisco.ctc.util.map.MapToolkit;
import java.awt.Color;

public class OchTrailProtectedCircuitMapNode
extends CircuitMapNode {
    static Attribute[] switchAttrs;
    private static final SDebug db;
    private MapPort clientPort;
    private MapToolkit mtk;

    public OchTrailProtectedCircuitMapNode(MapToolkit mapToolkit) {
        super(mapToolkit);
        this.mtk = mapToolkit;
        if (switchAttrs == null) {
            try {
                switchAttrs = NetworkDefaults.getAttributeMap().getAttributeArray("protectionOp");
            }
            catch (Exception exception) {
                db.println("Cannot obtain switchAttrs.");
                return;
            }
        }
    }

    static Attribute getAttributeForVal(int n) {
        if (switchAttrs != null) {
            for (int i = 0; i < switchAttrs.length; ++i) {
                if (switchAttrs[i].getIntValue() != n) continue;
                return switchAttrs[i];
            }
        }
        return null;
    }

    protected void deleteObservers() {
        MapSelector[] mapSelectorArray = this.getSelectors();
        for (int i = 0; i < mapSelectorArray.length; ++i) {
            OchTrailProtectedMapSelector ochTrailProtectedMapSelector = (OchTrailProtectedMapSelector)mapSelectorArray[i];
            ochTrailProtectedMapSelector.deleteObserver();
        }
        super.deleteObservers();
    }

    protected CircuitMapPort doCreateCircuitMapPort(DetailedMapNode detailedMapNode, MapLinkConnector mapLinkConnector, INetCircuitEnd iNetCircuitEnd) {
        INodeModel iNodeModel;
        Object object = this.getUserObject();
        if (object != null && object instanceof INodeModel && OchTrailHelper.isTrunkPort(iNodeModel = (INodeModel)object, iNetCircuitEnd.getEntityIndex()) && OchTrailHelper.isProtected(iNodeModel, iNetCircuitEnd.getEntityIndex())) {
            return new OchTrailProtectedCircuitMapPort(detailedMapNode, mapLinkConnector, iNetCircuitEnd.getEntityIndex());
        }
        return super.doCreateCircuitMapPort(detailedMapNode, mapLinkConnector, iNetCircuitEnd);
    }

    protected MapSelector createMapSelector(DetailedMapNode detailedMapNode) {
        OchTrailProtectedMapSelector ochTrailProtectedMapSelector = new OchTrailProtectedMapSelector(detailedMapNode);
        ochTrailProtectedMapSelector.init(new Integer(0), null);
        return ochTrailProtectedMapSelector;
    }

    public void addSelector(INodeModel iNodeModel, int n) {
        IEntityModel[] iEntityModelArray;
        String string = "addSelector():";
        OchTrailProtectedMapSelector ochTrailProtectedMapSelector = (OchTrailProtectedMapSelector)this.addSelector();
        try {
            iEntityModelArray = OchTrailHelper.getTrunkPorts(iNodeModel, n);
        }
        catch (Exception exception) {
            db.println("Cannot get trunk ports for node " + iNodeModel + "client " + Integer.toHexString(n));
            return;
        }
        if (db.on()) {
            db.println(string + " found " + iEntityModelArray.length + " trunk ports.");
        }
        MapPort[] mapPortArray = this.getPorts(true);
        for (int i = 0; i < iEntityModelArray.length; ++i) {
            boolean bl;
            IEntityModel iEntityModel = iEntityModelArray[i];
            int n2 = iEntityModel.getEntityIndex();
            CircuitMapPort circuitMapPort = null;
            for (bl = false; circuitMapPort == null && bl < mapPortArray.length; bl += 1) {
                MapPort mapPort = mapPortArray[bl];
                if (this.getEntityIndex(mapPort) != n2) continue;
                circuitMapPort = (CircuitMapPort)mapPort;
            }
            if (circuitMapPort != null) {
                bl = OchTrailHelper.isWorkingPort(iEntityModel);
                boolean bl2 = OchTrailHelper.isActivePort(iEntityModel);
                ochTrailProtectedMapSelector.addTrunk(circuitMapPort, iEntityModel, bl2);
                if (db.on()) {
                    db.println("Found map port " + circuitMapPort + " for trunk " + iEntityModel + " (is working?  " + bl + ")");
                }
                ochTrailProtectedMapSelector.setSuffixString(circuitMapPort, bl2, bl);
                Color color = bl2 ? NetMapLink.LINK_ACTIVE_COLOR : NetMapLink.LINK_STANDBY_COLOR;
                int n3 = bl2 ? 4 : 5;
                ochTrailProtectedMapSelector.addPort(circuitMapPort);
                CircuitMapLine circuitMapLine = (CircuitMapLine)this.addMapLine(ochTrailProtectedMapSelector, circuitMapPort, null);
                if (circuitMapLine == null) continue;
                circuitMapLine.setState(n3);
                if (!db.on()) continue;
                db.println(string + " added map line,  lineColor= " + MapGraphicsUtil.getColorString(color));
                continue;
            }
            if (!db.on()) continue;
            db.println("Map port not found for trunk " + iEntityModel);
        }
        if (db.on()) {
            db.println(string + " selector=" + ochTrailProtectedMapSelector + " node=" + iNodeModel.getName());
        }
    }

    protected void updateOneSelector() {
        MapSelector mapSelector;
        MapSelector[] mapSelectorArray = this.getSelectors();
        MapSelector mapSelector2 = mapSelector = mapSelectorArray == null && mapSelectorArray.length > 0 ? null : mapSelectorArray[0];
        if (mapSelector == null) {
            if (db.on()) {
                db.println("updateOneSelector(): MapSelector not found");
            }
            return;
        }
        MapPort mapPort = this.getClientPort();
        if (db.on()) {
            db.println("updateOneSelector(): Found client MapPort: " + mapPort);
        }
        int n = 0;
        if (mapPort != null) {
            int n2 = mapPort.getSide();
            n = n2 == 2 ? 14 : (n2 == 1 ? 15 : (n2 == -2 ? 13 : 16));
        }
        mapSelector.setSide(n);
        mapSelector.updatePositionInNode();
    }

    public int getEntityIndex(MapPort mapPort) {
        if (mapPort instanceof OchTrailProtectedCircuitMapPort) {
            return ((OchTrailProtectedCircuitMapPort)mapPort).getTrunkIndex();
        }
        return super.getEntityIndex(mapPort);
    }

    private MapPort getClientPort() {
        if (this.clientPort == null) {
            MapPort[] mapPortArray = this.getPorts();
            INodeModel iNodeModel = (INodeModel)this.getUserObject();
            for (int i = 0; i < mapPortArray.length; ++i) {
                int n;
                MapPort mapPort = mapPortArray[i];
                if (mapPort instanceof OchTrailProtectedCircuitMapPort || !OchTrailHelper.isClientPort(iNodeModel, n = this.getEntityIndex(mapPort))) continue;
                this.clientPort = mapPort;
                break;
            }
        }
        return this.clientPort;
    }

    static {
        db = new SDebug("OchTrailProtectedCircuitMapNode");
    }
}

