/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.AbstractCmsNoSuchElementException;
import cerent.cms.model.Attribute;
import cerent.cms.model.IDwdmTrkLineModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IYCableModel;
import cerent.cms.model.OchTrailHelper;
import cerent.cms.topo.INetLink;
import cerent.cms.ui.circuits.CircuitMap;
import cerent.cms.ui.circuits.OchTrailProtectedCircuitMapNode;
import cerent.cms.ui.circuits.OchTrailProtectedCircuitMapPort;
import cerent.cms.ui.network.CircuitMapLine;
import cerent.cms.ui.network.CircuitMapPort;
import cerent.cms.ui.network.NetMapLink;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.SDebug;
import com.cisco.ctc.util.map.DetailedMapNode;
import com.cisco.ctc.util.map.IMapLineEndpoint;
import com.cisco.ctc.util.map.MapGraphicsUtil;
import com.cisco.ctc.util.map.MapLine;
import com.cisco.ctc.util.map.MapPort;
import com.cisco.ctc.util.map.MapSelector;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Observable;
import javax.swing.SwingUtilities;

class OchTrailProtectedMapSelector
extends MapSelector
implements IObserver {
    private static SDebug db = new SDebug("OchTrailProtectedMapSelector");
    private ArrayList trunkPorts = new ArrayList();
    private ArrayList trunkMapPorts = new ArrayList();
    private IYCableModel ycm;

    public OchTrailProtectedMapSelector(DetailedMapNode detailedMapNode) {
        super(detailedMapNode);
    }

    public void deleteObserver() {
        if (db.on()) {
            db.println("deleteObserver");
        }
        if (this.ycm != null) {
            this.ycm.deleteObserver((IObserver)this);
        }
        MapLine[] mapLineArray = this.parentNode.getLines();
        for (int i = 0; i < mapLineArray.length; ++i) {
            CircuitMapLine circuitMapLine;
            MapLine mapLine = mapLineArray[i];
            IPortModel iPortModel = null;
            if (mapLine instanceof CircuitMapLine) {
                circuitMapLine = (CircuitMapLine)mapLine;
                IMapLineEndpoint iMapLineEndpoint = mapLine.getStartPoint();
                if (iMapLineEndpoint instanceof OchTrailProtectedCircuitMapPort) {
                    iPortModel = (IPortModel)((OchTrailProtectedCircuitMapPort)iMapLineEndpoint).getTrunk();
                } else {
                    iMapLineEndpoint = mapLine.getFinishPoint();
                    if (iMapLineEndpoint instanceof OchTrailProtectedCircuitMapPort) {
                        iPortModel = (IPortModel)((OchTrailProtectedCircuitMapPort)iMapLineEndpoint).getTrunk();
                    }
                }
            }
            if (iPortModel == null) continue;
            circuitMapLine = (IDwdmTrkLineModel)iPortModel.getInterfaceModel();
            circuitMapLine.deleteObserver(this);
        }
    }

    void addTrunk(MapPort mapPort, IEntityModel iEntityModel, boolean bl) {
        block8: {
            String string = this.stringFromProtectionOp(iEntityModel, bl);
            int n = string.indexOf(" ");
            if (n < string.length() - 1) {
                this.setLetter(string.charAt(n + 1));
            } else {
                this.setLetter('\u0000');
            }
            if (mapPort instanceof OchTrailProtectedCircuitMapPort) {
                ((OchTrailProtectedCircuitMapPort)mapPort).setProtectionString(string);
            }
            this.trunkPorts.add(iEntityModel);
            this.trunkMapPorts.add(mapPort);
            if (db.on()) {
                db.println("Added trunk to selector: " + iEntityModel + ", op = " + string);
            }
            if (this.ycm == null) {
                try {
                    this.ycm = OchTrailHelper.getYCableModel(iEntityModel);
                }
                catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
                    if (!db.on()) break block8;
                    db.println("Cannot find YCableModel for " + iEntityModel + ": " + abstractCmsNoSuchElementException.getMessage());
                }
            }
        }
        if (this.ycm != null) {
            this.ycm.addObserver((IObserver)this);
        }
        IDwdmTrkLineModel iDwdmTrkLineModel = (IDwdmTrkLineModel)((IPortModel)iEntityModel).getInterfaceModel();
        iDwdmTrkLineModel.addObserver((IObserver)this);
    }

    public String getToolTipText() {
        return "selector";
    }

    public void update(IObservable iObservable, Object object) {
        this._update(iObservable, object);
    }

    public void update(Observable observable, Object object) {
        this._update(observable, object);
    }

    public void _update(Object object, Object object2) {
        if (db.on()) {
            db.println("Received update from " + object);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                OchTrailProtectedMapSelector.this.updateMapSelector();
                OchTrailProtectedMapSelector.this.updateMapLines();
                OchTrailProtectedMapSelector.this.updateMapLinks();
            }
        });
    }

    private void updateMapSelector() {
        MapPort[] mapPortArray = this.parentNode.getPorts(true);
        char c = '\u0000';
        for (int i = 0; i < mapPortArray.length; ++i) {
            int n;
            MapPort mapPort = mapPortArray[i];
            if (!(mapPort instanceof OchTrailProtectedCircuitMapPort)) continue;
            IEntityModel iEntityModel = ((OchTrailProtectedCircuitMapPort)mapPort).getTrunk();
            boolean bl = OchTrailHelper.isActivePort(iEntityModel);
            String string = this.stringFromProtectionOp(iEntityModel, bl);
            if (c == '\u0000' && (n = string.indexOf(" ")) < string.length() - 1) {
                c = string.charAt(n + 1);
            }
            ((OchTrailProtectedCircuitMapPort)mapPort).setProtectionString(string);
        }
        this.setLetter(c);
    }

    private void updateMapLines() {
        MapLine[] mapLineArray = this.parentNode.getLines();
        for (int i = 0; i < mapLineArray.length; ++i) {
            MapLine mapLine = mapLineArray[i];
            if (!(mapLine instanceof CircuitMapLine)) continue;
            CircuitMapLine circuitMapLine = (CircuitMapLine)mapLine;
            IMapLineEndpoint iMapLineEndpoint = mapLine.getStartPoint();
            if (iMapLineEndpoint instanceof OchTrailProtectedCircuitMapPort) {
                this.updateMapLine(circuitMapLine, (OchTrailProtectedCircuitMapPort)iMapLineEndpoint);
                continue;
            }
            iMapLineEndpoint = mapLine.getFinishPoint();
            if (!(iMapLineEndpoint instanceof OchTrailProtectedCircuitMapPort)) continue;
            this.updateMapLine(circuitMapLine, (OchTrailProtectedCircuitMapPort)iMapLineEndpoint);
        }
    }

    private void updateMapLinks() {
        CircuitMap circuitMap = (CircuitMap)this.mtk;
        Collection collection = circuitMap.getLinkUserObjects();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof INetLink)) continue;
            INetLink iNetLink = (INetLink)e;
            if (db.on()) {
                db.println("Updating link " + iNetLink + " - Is Active = " + circuitMap.isOchTrailTunnelExpandedLinkActive(iNetLink));
            }
            circuitMap.updateLink(iNetLink);
        }
    }

    private void updateMapLine(CircuitMapLine circuitMapLine, OchTrailProtectedCircuitMapPort ochTrailProtectedCircuitMapPort) {
        IEntityModel iEntityModel = ochTrailProtectedCircuitMapPort.getTrunk();
        if (iEntityModel != null) {
            boolean bl = OchTrailHelper.isActivePort(iEntityModel);
            boolean bl2 = OchTrailHelper.isWorkingPort(iEntityModel);
            Color color = bl ? NetMapLink.LINK_ACTIVE_COLOR : NetMapLink.LINK_STANDBY_COLOR;
            int n = bl ? 4 : 5;
            circuitMapLine.setState(n);
            this.setSuffixString(ochTrailProtectedCircuitMapPort, bl, bl2);
            if (db.on()) {
                db.println("Updated map line to trunk " + iEntityModel + " (isActive = " + bl + "),  lineColor = " + MapGraphicsUtil.getColorString(color));
            }
        }
    }

    private String stringFromProtectionOp(IEntityModel iEntityModel, boolean bl) {
        block3: {
            try {
                int n = OchTrailHelper.getProtectionOp(iEntityModel);
                Attribute attribute = OchTrailProtectedCircuitMapNode.getAttributeForVal(n);
                if (attribute != null) {
                    return attribute.toString();
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block3;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return "";
    }

    protected void setSuffixString(CircuitMapPort circuitMapPort, boolean bl, boolean bl2) {
        String string = bl2 ? " WRK" : " PRT";
        String string2 = bl ? "/ACT " : "/STDBY ";
        circuitMapPort.setSuffixString(string + string2);
    }
}

