/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.circuits.SanityCheckException;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.topo.INetElement;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.circuits.AbstractCircuitDialog;
import cerent.cms.ui.circuits.CcdConversionCktPane;
import cerent.cms.ui.circuits.CircuitMapUtil;
import cerent.cms.ui.circuits.RollCreationDialog;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class RollConversionCktPane
extends CcdConversionCktPane {
    public static final String RollConvCkt = "Roll Transmux Conversion Circuit";

    public RollConversionCktPane(AbstractCircuitDialog abstractCircuitDialog, WzDiagDebug wzDiagDebug, String string) {
        super(abstractCircuitDialog, wzDiagDebug, string);
    }

    public void validatePage() throws Exception {
        if (this.nodeModel == null) {
            throw new Exception("Roll Transmux Conversion Circuit node must be selected");
        }
        this.mainPanel.validatePage();
        NetCcatCircuit netCcatCircuit = (NetCcatCircuit)((RollCreationDialog)this.parent).ckt;
        if (netCcatCircuit != null) {
            LinkedList linkedList;
            Object object;
            INetCircuitEnd[] iNetCircuitEndArray = this.getMainPanel().getXmCircuitEnds();
            if (iNetCircuitEndArray != null) {
                object = iNetCircuitEndArray[0].getNetElement();
                linkedList = ((RollCreationDialog)this.parent).changedNodeList;
                List list = netCcatCircuit.getCircuitNodes();
                list.removeAll(linkedList);
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    INetElement iNetElement = ((INetCircuitNode)iterator.next()).getNetElement();
                    if (iNetElement != object) continue;
                    throw new Exception("Please choose transmux on a different node");
                }
                if (object == ((RollCreationDialog)this.parent).rollFrom1.getNetElement() || object == ((RollCreationDialog)this.parent).rollFrom2.getNetElement()) {
                    throw new Exception("Please choose transmux on a different node");
                }
                ((RollCreationDialog)this.parent).xmCircuitEnds = iNetCircuitEndArray;
            }
            if (!this.getAbstractCktDlg().isUrn()) {
                ((RollCreationDialog)this.parent).setExcludeEntities(this.getAbstractCktDlg().getRoutePrefs());
                ((RollCreationDialog)this.parent).routeNewCircuit();
                if (!this.getAbstractCktDlg().isRrbc()) {
                    try {
                        if (((RollCreationDialog)this.parent).checkNewRouteForUPSR()) {
                            throw new Exception(CircuitMapUtil.UPSR_TERM + " ring is detected between Pivot/Fixed Point 1 and Pivot/Fixed Point 2.");
                        }
                        object = new LinkedList();
                        linkedList = new LinkedList();
                        netCcatCircuit.getNewSpanAndNodeList(((RollCreationDialog)this.parent).newRoute, ((RollCreationDialog)this.parent).oldRoute, (List)object, linkedList);
                        ((RollCreationDialog)this.parent).addBlsrDriRoutePrefs();
                        netCcatCircuit.sanityCheckBridgeRollRouting(((RollCreationDialog)this.parent).oldRoute, (List)object, linkedList, this.getAbstractCktDlg().getRoutePrefs());
                        if (this.db.on()) {
                            this.db.println("validatePage: sanityCheckManualRouting succeeded");
                        }
                        ((RollCreationDialog)this.parent).savePostRollCktSpansAndNodes((List)object, linkedList);
                    }
                    catch (SanityCheckFailed sanityCheckFailed) {
                        throw new SanityCheckException("", "spans are", sanityCheckFailed);
                    }
                    ((RollCreationDialog)this.parent).getNewCircuitInfo();
                }
            }
        }
    }

    public boolean handleBack() {
        ((RollCreationDialog)this.parent).xmCircuitEnds = null;
        return super.handleBack();
    }

    public CSHelpID getHelpID() {
        return NetCSHelpConst.RollConversionCktPane;
    }
}

