/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ui.circuits.CircuitEndCellRenderer;
import cerent.util.SDebug;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class RollFromSelectionDialog
extends JDialog
implements ActionListener {
    private static SDebug db = new SDebug("RollFromSelectionDialog");
    public static final String TITLE = "Select Roll From";
    private JButton okButton;
    private ButtonGroup radioButtonGroup;
    private NetCircuitEnd selectedCktEnd;
    private HashMap choices = new HashMap();

    public RollFromSelectionDialog(Frame frame, List list) {
        super(frame, TITLE, true);
        this.setDefaultCloseOperation(0);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel("<html>There are two paths connected to the selected Pivot/Fixed point.<p>Select a path that is intended to be rolled:");
        jPanel.add(jLabel);
        JPanel jPanel2 = new JPanel(new GridLayout(list.size(), 1));
        this.radioButtonGroup = new ButtonGroup();
        for (int i = 0; i < list.size(); ++i) {
            NetCircuitEnd netCircuitEnd = (NetCircuitEnd)list.get(i);
            JRadioButton jRadioButton = new JRadioButton(this.getPortString(netCircuitEnd), i == 0);
            this.radioButtonGroup.add(jRadioButton);
            jPanel2.add(jRadioButton);
            this.choices.put(jRadioButton.getModel(), netCircuitEnd);
        }
        JPanel jPanel3 = new JPanel(new FlowLayout());
        this.okButton = new JButton("Ok");
        this.okButton.addActionListener(this);
        jPanel3.add(this.okButton);
        container.add((Component)jPanel, "North");
        container.add((Component)jPanel2, "Center");
        container.add((Component)jPanel3, "South");
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    private String getPortString(NetCircuitEnd netCircuitEnd) {
        return CircuitEndCellRenderer.asSlashSeparatedString(netCircuitEnd);
    }

    public NetCircuitEnd getChoice() {
        return this.selectedCktEnd;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            this.selectedCktEnd = (NetCircuitEnd)this.choices.get(this.radioButtonGroup.getSelection());
            this.dispose();
        }
    }
}

