/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.circuits.SanityCheckException;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.LoTunnelInfo;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuitFactory;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.NetCircuitSpanFactory;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.route.NetLinkSpan;
import cerent.cms.route.RoutePrefs;
import cerent.cms.topo.INetLink;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.circuits.AbstractCircuitDialog;
import cerent.cms.ui.circuits.CcdLoPane;
import cerent.cms.ui.circuits.CircuitMapUtil;
import cerent.cms.ui.circuits.RollCreationDialog;
import cerent.util.AnnotatedException;
import cerent.util.ILoNum;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;

public class RollLoPane
extends CcdLoPane {
    boolean newTunnelCreated;

    public RollLoPane(AbstractCircuitDialog abstractCircuitDialog, WzDiagDebug wzDiagDebug, String string) {
        super(abstractCircuitDialog, wzDiagDebug, string);
    }

    public void validatePage() throws Exception {
        boolean bl;
        if (this.lotRB.isSelected()) {
            try {
                this.createLoTunnel(true);
            }
            catch (Exception exception) {
                AnnotatedException annotatedException = new AnnotatedException("Unable to create LO tunnel.", exception);
                throw annotatedException;
            }
        } else if (this.noneRB.isSelected() && !this.getAbstractCktDlg().isVcatType() && (bl = this.isLoTunnelNeeded())) {
            this.createLoTunnel(true);
        }
        if (!this.newTunnelCreated) {
            if (this.getAbstractCktDlg().getRoutePrefs().getExcludeSrgs().isEmpty()) {
                ((RollCreationDialog)this.parent).setExcludeEntities(this.getAbstractCktDlg().getRoutePrefs());
            }
            ((RollCreationDialog)this.parent).routeNewCircuit();
        }
        if (!this.getAbstractCktDlg().isRrbc()) {
            try {
                if (((RollCreationDialog)this.parent).checkNewRouteForUPSR()) {
                    throw new Exception(CircuitMapUtil.UPSR_TERM + " ring is detected between Pivot/Fixed Point 1 and Pivot/Fixed Point 2.");
                }
                NetCcatCircuit netCcatCircuit = (NetCcatCircuit)((RollCreationDialog)this.parent).rollFromCkt;
                LinkedList linkedList = new LinkedList();
                LinkedList linkedList2 = new LinkedList();
                netCcatCircuit.getNewSpanAndNodeList(((RollCreationDialog)this.parent).newRoute, ((RollCreationDialog)this.parent).oldRoute, linkedList, linkedList2);
                netCcatCircuit.sanityCheckBridgeRollRouting(((RollCreationDialog)this.parent).oldRoute, linkedList, linkedList2, this.getAbstractCktDlg().getRoutePrefs());
                if (this.db.on()) {
                    this.db.println("validatePage: sanityCheckManualRouting succeeded");
                }
                ((RollCreationDialog)this.parent).savePostRollCktSpansAndNodes(linkedList, linkedList2);
            }
            catch (SanityCheckFailed sanityCheckFailed) {
                throw new SanityCheckException("", "spans are", sanityCheckFailed);
            }
            ((RollCreationDialog)this.parent).getNewCircuitInfo();
        }
    }

    private void createLoTunnel(boolean bl) throws Exception {
        this.newTunnelCreated = false;
        INetCircuit iNetCircuit = ((RollCreationDialog)this.parent).rollFromCkt;
        INetCircuitEnd iNetCircuitEnd = ((RollCreationDialog)this.parent).bNr1;
        INetCircuitEnd iNetCircuitEnd2 = ((RollCreationDialog)this.parent).bNr2;
        CircuitCreatInfo circuitCreatInfo = new CircuitCreatInfo(iNetCircuit.getCircuitType(), iNetCircuit.getCircuitSize(), iNetCircuit.getCircuitDir(), iNetCircuit.getSla());
        INetCircuit iNetCircuit2 = NetCircuitFactory.newCircuit(circuitCreatInfo, iNetCircuitEnd);
        LinkedList<INetCircuitEnd> linkedList = new LinkedList<INetCircuitEnd>();
        linkedList.add(iNetCircuitEnd2);
        RoutePrefs routePrefs = new RoutePrefs(this.getAbstractCktDlg().getRoutePrefs());
        routePrefs.setPathProt(2);
        List list = NetCircuitManager.instance().createLoTunnels(iNetCircuit2, linkedList, routePrefs);
        if (this.db.on()) {
            this.db.info("createLoTunnel got " + list.size() + " tunnel");
        }
        if (list.size() > 0) {
            LoTunnelInfo loTunnelInfo = (LoTunnelInfo)list.get(0);
            boolean bl2 = true;
            AnnotatedException annotatedException = null;
            if (loTunnelInfo.required() || bl) {
                try {
                    if (this.db.on) {
                        this.db.info("createLoTunnel: provisioning required Lo tunnel");
                    }
                    INetCircuit iNetCircuit3 = loTunnelInfo.tunnel();
                    iNetCircuit3.provision();
                    this.getAbstractCktDlg().addRelatedCircuit(loTunnelInfo.tunnel());
                    this.existingTunnelList.add(loTunnelInfo.tunnel());
                    this.newTunnelCreated = true;
                    bl2 = false;
                    INetLink iNetLink = iNetCircuit3.getLotLink();
                    INetLink iNetLink2 = iNetCircuit3.getReverseLotLink();
                    List list2 = iNetLink.getAvailableLoNumbers(iNetLink.getSrcHo(), iNetCircuit.getCircuitSize());
                    NetLinkSpan netLinkSpan = new NetLinkSpan(iNetLink, iNetLink2, iNetLink.getSrcHo(), iNetLink.getDstHo(), (ILoNum)list2.get(0));
                    NetCircuitSpan netCircuitSpan = NetCircuitSpanFactory.createCircuitSpan(iNetCircuit, netLinkSpan);
                    ((RollCreationDialog)this.parent).newRoute = new LinkedList();
                    ((RollCreationDialog)this.parent).newRoute.add(netCircuitSpan);
                }
                catch (Exception exception) {
                    annotatedException = new AnnotatedException("Unable to create required LO tunnel", exception);
                }
                if (bl2) {
                    try {
                        if (this.db.on) {
                            this.db.info("createLoTunnel: destroying LO tunnel");
                        }
                        this.destroyExistingTunnels();
                    }
                    catch (Exception exception) {
                        throw new AnnotatedException("Unable to destroy LO tunnel", exception);
                    }
                    if (annotatedException != null) {
                        throw annotatedException;
                    }
                }
            }
        }
    }

    private boolean isLoTunnelNeeded() {
        INetCircuit iNetCircuit = ((RollCreationDialog)this.parent).rollFromCkt;
        INetCircuitEnd iNetCircuitEnd = ((RollCreationDialog)this.parent).bNr1;
        INetCircuitEnd iNetCircuitEnd2 = ((RollCreationDialog)this.parent).bNr2;
        CircuitCreatInfo circuitCreatInfo = new CircuitCreatInfo(iNetCircuit.getCircuitType(), iNetCircuit.getCircuitSize(), iNetCircuit.getCircuitDir(), iNetCircuit.getSla());
        INetCircuit iNetCircuit2 = NetCircuitFactory.newCircuit(circuitCreatInfo, iNetCircuitEnd);
        LinkedList<INetCircuitEnd> linkedList = new LinkedList<INetCircuitEnd>();
        linkedList.add(iNetCircuitEnd2);
        iNetCircuit2.setMemberPrefs(this.getAbstractCktDlg().getRoutePrefs().getFwdDropPrefs().getFirstMemberGroupPrefs().getMemberPrefs());
        return NetCircuitManager.instance().isLoTunnelNeeded(iNetCircuit2, linkedList, this.getRoutePrefsForLOT());
    }

    private boolean canHaveOptionalLot() {
        INetCircuit iNetCircuit = ((RollCreationDialog)this.parent).rollFromCkt;
        INetCircuitEnd iNetCircuitEnd = ((RollCreationDialog)this.parent).bNr1;
        INetCircuitEnd iNetCircuitEnd2 = ((RollCreationDialog)this.parent).bNr2;
        CircuitCreatInfo circuitCreatInfo = new CircuitCreatInfo(iNetCircuit.getCircuitType(), iNetCircuit.getCircuitSize(), iNetCircuit.getCircuitDir(), iNetCircuit.getSla());
        INetCircuit iNetCircuit2 = NetCircuitFactory.newCircuit(circuitCreatInfo, iNetCircuitEnd);
        LinkedList<INetCircuitEnd> linkedList = new LinkedList<INetCircuitEnd>();
        linkedList.add(iNetCircuitEnd2);
        return NetCircuitManager.instance().canHaveOptionalLot(iNetCircuit2, linkedList, this.getRoutePrefsForLOT());
    }

    private RoutePrefs getRoutePrefsForLOT() {
        RoutePrefs routePrefs = new RoutePrefs(this.getAbstractCktDlg().getRoutePrefs());
        if (((RollCreationDialog)this.parent).isOldRouteUPSR) {
            routePrefs.setPathProt(3);
        } else if (routePrefs.getPathProt() == 0) {
            routePrefs.setPathProt(7);
        }
        return routePrefs;
    }

    protected JComponent getStatusComponent() {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        String string = "LO Choice:";
        if (this.lotRB.isSelected()) {
            arrayList.add(new String[]{string, CircuitMapUtil.LO_TERM + " Tunnel"});
        } else {
            arrayList.add(new String[]{string, "N/A"});
        }
        return RollLoPane.getGridPanel(arrayList);
    }

    protected String getStatusText() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.lotRB.isSelected()) {
            stringBuffer.append("\nCreated " + CircuitMapUtil.LO_TERM + " Tunnel");
        } else {
            stringBuffer.append("No tunnel choice.");
        }
        return stringBuffer.toString();
    }

    public void revalidateData() {
        boolean bl = this.areThereRequiredOrExcluded();
        if (this.db.on) {
            this.db.info("revalidateData()");
        }
        if (this.getAbstractCktDlg().isVcatType()) {
            this.lapRB.setEnabled(false);
            this.lotRB.setEnabled(false);
            this.useDstRB.setEnabled(false);
            this.useSrcRB.setEnabled(false);
            this.noneRB.setSelected(true);
            this.syncButtons();
            return;
        }
        this.noneRB.setSelected(true);
        boolean bl2 = this.canHaveOptionalLot();
        boolean bl3 = this.getAbstractCktDlg().getRoutePrefs().getDri();
        boolean bl4 = bl2 && !bl3;
        this.lotRB.setEnabled(bl4 && !bl);
        if (this.db.on()) {
            this.db.info("lot RB logic\nCan Have Optional:" + bl2 + "\nAre Route Prefs DRI?" + bl3);
        }
        this.lapRB.setEnabled(false);
        if (bl && bl4) {
            this.infoLbl.setText(NONE_BECAUSE_RC_MSG);
        } else {
            this.infoLbl.setText("");
        }
        this.syncButtons();
    }

    public CSHelpID getHelpID() {
        return NetCSHelpConst.RollLoPane;
    }
}

