/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.circuits.VcatMemberCktDataSource;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ui.circuits.CircuitColumnRenderer;
import cerent.cms.ui.circuits.CircuitsByNameTable;
import cerent.cms.ui.circuits.CircuitsTableModel;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.row.RowDataSource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class RollVcatMemberSelectionDialog
extends JDialog
implements ActionListener {
    private static SDebug db = new SDebug("RollVcatMemberSelectionDialog");
    public static final String TITLE = "Select a Member Circuit to Roll";
    private JButton okButton;
    private JButton cancelButton;
    private CircuitsByNameTable table;
    private CircuitsTableModel model;
    private INetCircuit selectedMemberCkt;
    private VcatMemberCktDataSource memCktsDataSource;
    private boolean ok = false;

    public RollVcatMemberSelectionDialog(Frame frame, INetCircuit iNetCircuit) {
        super(frame, TITLE, true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                RollVcatMemberSelectionDialog.this.dispose();
            }
        });
        this.memCktsDataSource = new VcatMemberCktDataSource(iNetCircuit);
        this.memCktsDataSource.setEnabled(true);
        this.model = new CircuitsTableModel((RowDataSource)this.memCktsDataSource, CircuitColumnRenderer.createTableRenderers(1), INetCircuit.class);
        this.table = new CircuitsByNameTable(this.model);
        this.table.setSelectionMode(0);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new UScrollPane((Component)((Object)this.table)));
        JPanel jPanel2 = new JPanel(new FlowLayout());
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        jPanel2.add(this.okButton);
        jPanel2.add(this.cancelButton);
        container.add((Component)jPanel, "Center");
        container.add((Component)jPanel2, "South");
        this.setSize(new Dimension(700, 350));
        this.setLocationRelativeTo(frame);
    }

    public INetCircuit getChoice() {
        return this.selectedMemberCkt;
    }

    public boolean isOk() {
        return this.ok;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            int[] nArray = this.table.getSelectedRows();
            if (nArray.length == 0) {
                ErrorMsg.displayError((Component)this, (EID)NEMC.EID_NO_CIRCUITS_SELECTED_PARAM_1, (Object)"Roll VCAT member circuit.");
            } else {
                this.selectedMemberCkt = (INetCircuit)this.model.getValueAt(nArray[0], 0);
                this.ok = true;
                this.dispose();
            }
        } else if (object == this.cancelButton) {
            this.dispose();
        }
    }
}

