/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.loader.ElementFactoryFinder;
import cerent.cms.model.Attribute;
import cerent.cms.model.AttributeMaps;
import cerent.cms.model.CircuitSize;
import cerent.cms.model.CircuitType;
import cerent.cms.model.ConnCreateAttrs;
import cerent.cms.model.HoUpsrAttributes;
import cerent.cms.model.ICircuitSize;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.IConnCreateAttrs;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IRevertiveBehavior;
import cerent.cms.model.NetAdminState;
import cerent.cms.model.NetworkModel;
import cerent.cms.model.NoMoreLoCapableHo;
import cerent.cms.model.NoMoreVtCapableSts;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.PathInUse;
import cerent.cms.model.PathListIncomplete;
import cerent.cms.model.RevertiveBehavior;
import cerent.cms.model.SelectorAttrsOpt;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.NetCircuitDropInfo;
import cerent.cms.ncp.Unprot2UpsrInServiceUpgradeMgr;
import cerent.cms.route.RoutePrefs;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.Network;
import cerent.cms.ui.IEntityCellRenderer;
import cerent.cms.ui.NetworkDefaults;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.circuits.AbstractCcdAttrsPane;
import cerent.cms.ui.circuits.AbstractCircuitDialog;
import cerent.cms.ui.circuits.CcdAttrsPane;
import cerent.cms.ui.circuits.CcdConversionCktPane;
import cerent.cms.ui.circuits.CcdLoPane;
import cerent.cms.ui.circuits.CcdReviewEditPane;
import cerent.cms.ui.circuits.CcdRoutePane;
import cerent.cms.ui.circuits.CcdVttAttrsPane;
import cerent.cms.ui.circuits.CircuitEndCellRenderer;
import cerent.cms.ui.circuits.CircuitMapUtil;
import cerent.cms.ui.circuits.WzCcdPane;
import cerent.util.AnnotatedException;
import cerent.util.DetailedLog;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.EventBus;
import cerent.util.EventBusServices;
import cerent.util.IAsyncObserver;
import cerent.util.NEMC;
import cerent.util.Preferences;
import cerent.util.TDMTerminology;
import cerent.util.gui.CerentDialog;
import cerent.util.job.JobStatus;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

public class UnprotectedToUpsrDialog
extends AbstractCircuitDialog
implements IAsyncObserver {
    public static final String TITLE = "Unprotected To " + CircuitMapUtil.UPSR_TERM;
    private static final int WIDTH = 850;
    static final int SHORT = 375;
    CcdRoutePane routePane;
    CcdLoPane loPane;
    CcdReviewEditPane revEditPane;
    Unprot2UpsrInServiceUpgradeMgr unprot2UpsrInServiceUpgradeMgr;
    protected CircuitCreatInfo circuitInfo;
    protected boolean dropProtection;
    protected boolean portGrouping;
    protected boolean spanUpdated = false;

    public int getCircuitType() {
        return this.ckt.getCircuitType();
    }

    public boolean getDropProtection() {
        return this.dropProtection;
    }

    public boolean getPortGrouping() {
        return this.portGrouping;
    }

    public CircuitCreatInfo getCircuitInfo() {
        return this.circuitInfo;
    }

    public boolean isAutoRoute() {
        if (this.spanUpdated) {
            return false;
        }
        if (this.routePane != null) {
            return this.routePane.isAutoRoute();
        }
        return false;
    }

    public void setSpanUpdated(boolean bl) {
        this.spanUpdated = bl;
    }

    public boolean isRrbc() {
        if (this.routePane != null) {
            return this.routePane.isRrbc();
        }
        return false;
    }

    public boolean isUrn() {
        if (this.routePane != null) {
            return this.routePane.isUrn();
        }
        return false;
    }

    public boolean isPathProt() {
        if (this.routePane != null) {
            return this.routePane.isPathProt();
        }
        return false;
    }

    public void setPathProt(boolean bl) {
        if (this.routePane != null) {
            this.routePane.setPathProt(bl);
        }
    }

    public boolean isPca() {
        if (this.routePane != null) {
            return this.routePane.isPca();
        }
        return false;
    }

    public void setPca(boolean bl) {
        if (this.routePane != null) {
            this.routePane.setPca(bl);
        } else {
            this.db.severe("could not set PCA!");
        }
    }

    public RoutePrefs getRoutePrefs() {
        if (this.routePane != null) {
            return this.routePane.getRoutePrefs();
        }
        return null;
    }

    public void setRoutePrefs(RoutePrefs routePrefs) {
        if (this.routePane != null) {
            this.routePane.setRoutePrefs(routePrefs);
        }
    }

    public String getCircuitName() {
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null) {
            return abstractCcdAttrsPane.getCircuitName();
        }
        this.db.severe("could not get circuit name ... returning NULL");
        return null;
    }

    public Attribute getUpsrSfBerLevel() {
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null) {
            return abstractCcdAttrsPane.getUpsrSfBerLevel();
        }
        this.db.severe("could not get upsr sf ber level ... returning NULL");
        return null;
    }

    private void setUpsrSfBerLevel(Attribute attribute) {
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null) {
            abstractCcdAttrsPane.setUpsrSfBerLevel(attribute);
        } else {
            this.db.severe("could not set upsr SF Ber Level.");
        }
    }

    public Attribute getUpsrSdBerLevel() {
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null) {
            return abstractCcdAttrsPane.getUpsrSdBerLevel();
        }
        this.db.severe("could not get upsr sd ber level... returning NULL");
        return null;
    }

    private void setUpsrSdBerLevel(Attribute attribute) {
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null) {
            abstractCcdAttrsPane.setUpsrSdBerLevel(attribute);
        } else {
            this.db.severe("could not set upsr SD Ber Level.");
        }
    }

    public IRevertiveBehavior getUpsrReversion() {
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null) {
            return abstractCcdAttrsPane.getUpsrReversion();
        }
        this.db.severe("could not get revertive behavior... returning NULL");
        return null;
    }

    public void setUpsrReversion(IRevertiveBehavior iRevertiveBehavior) {
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null) {
            abstractCcdAttrsPane.setUpsrReversion(iRevertiveBehavior);
        } else {
            this.db.severe("could not set upsr revertive behavior");
        }
    }

    public boolean getUpsrSwitchOnPdip() {
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null) {
            return abstractCcdAttrsPane.getUpsrSwitchOnPdip();
        }
        this.db.severe("could not get UPSR switch... returning false");
        return false;
    }

    public void setUpsrSwitchOnPdip(boolean bl) {
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null) {
            abstractCcdAttrsPane.setUpsrSwitchOnPdip(bl);
        } else {
            this.db.severe("could not set UPSR switch on Pdip");
        }
    }

    public boolean getUpsrGoReturnRouting() {
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null) {
            return abstractCcdAttrsPane.getUpsrGoReturnRouting();
        }
        this.db.severe("could not get UPSR go-ret routing... returning false");
        return false;
    }

    private void setUpsrGoReturnRouting(boolean bl) {
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null) {
            abstractCcdAttrsPane.setUpsrGoReturnRouting(bl);
        } else {
            this.db.severe("could not set UPSR return routing.");
        }
    }

    private boolean getDefaultGoReturnRouting() {
        Iterator iterator = Network.instance().getAllElements().iterator();
        while (iterator.hasNext()) {
            if (((INetElement)iterator.next()).getFramingTypeObj().isSdh()) continue;
            return false;
        }
        return true;
    }

    public ArrayList getVcatMemberPrefs() {
        if (this.db.on()) {
            this.db.println("UnprotectedToUpsrDialog: empty imp getVcatMemberPrefs()");
        }
        return null;
    }

    public void setVcatCommonFiberRouting(boolean bl) {
        if (this.db.on()) {
            this.db.println("UnprotectedToUpsrDialog: empty imp setVcatCommonFiberRouting()");
        }
    }

    public boolean isVcatCommonFiberRouting() {
        if (this.db.on()) {
            this.db.println("UnprotectedToUpsrDialog: empty imp isVcatCommonFiberRouting()");
        }
        return false;
    }

    public int getVcatTxMembers() {
        if (this.db.on()) {
            this.db.println("UnprotectedToUpsrDialog: empty imp getVcatTxMembers");
        }
        return 0;
    }

    public UnprotectedToUpsrDialog(INetCircuit iNetCircuit, JComponent jComponent, boolean bl) {
        super(JOptionPane.getFrameForComponent(jComponent), TITLE, new WzDiagDebug("UnprotectedToUpsrDialog"), bl);
        Frame frame = JOptionPane.getFrameForComponent(jComponent);
        this.setHeight(375);
        this.setFinishEnabled(false);
        this.setCircuit(iNetCircuit);
        this.makeCircuitInfo(iNetCircuit);
        this.createPanesAndSetCurrent();
        this.setLocationRelativeTo(frame);
    }

    protected void errorMsgDisplayError() {
        ErrorMsg.displayError((Component)this, (EID)this.getNoRouteEmcErrorId(), (Object)CircuitMapUtil.UPSR_TERM);
    }

    protected void cerentDialogDisplayError(DetailedLog detailedLog) {
        CerentDialog.errorDialog((Component)this, (String)ErrorMsg.getString((EID)this.getNoRouteEmcErrorId(), (Object)CircuitMapUtil.UPSR_TERM), (String)"Route Error", (DetailedLog)detailedLog, (boolean)false);
    }

    protected void makeCircuitInfo(INetCircuit iNetCircuit) {
        this.circuitInfo = new CircuitCreatInfo(this.ckt.getCircuitType(), this.ckt.getCircuitSize(), this.ckt.isBidirectional() ? 1 : 0, false, this.ckt.getCircuitName(), this.ckt.getAdminState(), false);
    }

    protected void readCircuitPrefs() {
        int n;
        int n2;
        int n3;
        boolean bl;
        Preferences preferences;
        block9: {
            INodeModel iNodeModel;
            RoutePrefs routePrefs = new RoutePrefs();
            routePrefs.setPathProt(2);
            routePrefs.setDiversityOption(1);
            this.setRoutePrefs(routePrefs);
            preferences = Preferences.instance();
            this.setUpsrGoReturnRouting(preferences.getBoolean("ctc.circuit.creation", "upsrGoReturnRouting", this.getDefaultGoReturnRouting()));
            bl = false;
            n3 = 300;
            int n4 = 2;
            n2 = 4;
            n = 6;
            ICircuitType iCircuitType = CircuitType.getCircuitType((int)this.ckt.getCircuitType());
            if (iCircuitType.isLoCircuitType()) {
                n4 = 1;
                n2 = 3;
                n = 5;
            }
            if ((iNodeModel = NetworkModel.instance().getCmsHostModel()) != null && iNodeModel.isInited()) {
                try {
                    IRevertiveBehavior iRevertiveBehavior = iNodeModel.getUpsrReversion();
                    if (iRevertiveBehavior != null) {
                        bl = iRevertiveBehavior.getReversionMode() == 2;
                        n3 = iRevertiveBehavior.getReversionTime();
                    }
                }
                catch (Exception exception) {
                    this.db.println("Can't retrieve default revertive behavior from node");
                    WzDiagDebug.printStackTrace((Throwable)exception);
                }
                try {
                    n2 = iNodeModel.getUpsrSfBerLevel(n4);
                    n = iNodeModel.getUpsrSdBerLevel(n4);
                }
                catch (Exception exception) {
                    this.db.severe("Cannot get default bers:" + exception);
                    n2 = 4;
                    n = 6;
                    if (n4 != 1) break block9;
                    n2 = 3;
                    n = 5;
                }
            }
        }
        int n5 = preferences.getBoolean("ctc.circuit.creation", "revertive", bl) ? 2 : 1;
        int n6 = preferences.getInt("ctc.circuit.creation", "revertTime", n3);
        if (n6 == 0) {
            n6 = 30;
        }
        this.setUpsrReversion(new RevertiveBehavior(n5, n6));
        AttributeMaps attributeMaps = NetworkDefaults.getAttributeMap();
        this.setUpsrSfBerLevel(attributeMaps.getAttributeForVal("declareSfBerLevel", n2));
        this.setUpsrSdBerLevel(attributeMaps.getAttributeForVal("declareSdBerLevel", n));
        this.setUpsrSwitchOnPdip(preferences.getBoolean("ctc.circuit.creation", "pdip", false));
        if (this.revEditPane != null) {
            this.revEditPane.reset();
        }
    }

    private IConnCreateAttrs getConnCreateAttrs() {
        ConnCreateAttrs connCreateAttrs = new ConnCreateAttrs();
        SelectorAttrsOpt selectorAttrsOpt = new SelectorAttrsOpt();
        HoUpsrAttributes hoUpsrAttributes = new HoUpsrAttributes();
        if (this.getUpsrSfBerLevel() != null) {
            hoUpsrAttributes.setUpsrSfBerLevel(this.getUpsrSfBerLevel().getValue().shortValue());
        }
        if (this.getUpsrSdBerLevel() != null) {
            hoUpsrAttributes.setUpsrSdBerLevel(this.getUpsrSdBerLevel().getValue().shortValue());
        }
        hoUpsrAttributes.setUpsrReversion(this.getUpsrReversion());
        hoUpsrAttributes.setUpsrSwitchOnPdiP(this.getUpsrSwitchOnPdip());
        selectorAttrsOpt.setHoUpsrAttributes(hoUpsrAttributes);
        connCreateAttrs.setSelectorAttrsOpt(selectorAttrsOpt);
        String string = this.getCircuitName();
        if (string == null) {
            string = this.ckt.getCircuitName();
        }
        connCreateAttrs.setCktName(string);
        return connCreateAttrs;
    }

    void writeCircuitPrefs() {
        Preferences preferences = Preferences.instance();
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null && abstractCcdAttrsPane.isGoReturnRoutingSpecified()) {
            preferences.setBoolean("ctc.circuit.creation", "upsrGoReturnRouting", this.getUpsrGoReturnRouting());
        }
        preferences.setBoolean("ctc.circuit.creation", "revertive", this.getUpsrReversion().getReversionMode() == 2);
        preferences.setInt("ctc.circuit.creation", "revertTime", this.getUpsrReversion().getReversionTime());
        preferences.setBoolean("ctc.circuit.creation", "pdip", this.getUpsrSwitchOnPdip());
        try {
            preferences.store();
        }
        catch (FileNotFoundException fileNotFoundException) {
            WzDiagDebug.printStackTrace((Throwable)fileNotFoundException);
            ErrorMsg.displayError((Component)this, (EID)NEMC.EID_CANT_SAVE_CKT_PREFS_PARAM_1, (Object)"File not found.");
        }
        catch (IOException iOException) {
            WzDiagDebug.printStackTrace((Throwable)iOException);
            ErrorMsg.displayError((Component)this, (EID)NEMC.EID_CANT_SAVE_CKT_PREFS_PARAM_1, (Object)"I/O error.");
        }
    }

    protected void createPanesAndSetCurrent() {
        if (this.ckt.getCircuitTypeObj().isTunnelCircuitType()) {
            this.wzPaneMap.put("Circuit Attributes", new CcdVttAttrsPane(this, this.makeChildDebug("VttAttrs"), "Circuit Attributes"));
        } else {
            this.wzPaneMap.put("Circuit Attributes", new CcdAttrsPane(this, this.makeChildDebug("Attrs"), "Circuit Attributes"));
        }
        this.routePane = new CcdRoutePane(this, this.makeChildDebug("RoutePrefs"), "Circuit Routing Preferences");
        this.wzPaneMap.put("Circuit Routing Preferences", this.routePane);
        this.wzPaneMap.put("Conversion Circuit Constraints For Automatic Routing", new CcdConversionCktPane(this, this.makeChildDebug("XmRoute"), "Conversion Circuit Constraints For Automatic Routing"));
        this.loPane = new CcdLoPane(this, this.makeChildDebug("LoPane"), WZPANE_GET_LO);
        this.wzPaneMap.put(WZPANE_GET_LO, this.loPane);
        this.revEditPane = new CcdReviewEditPane(this, this.makeChildDebug("ReviewEdit"), "Route Review/Edit", false);
        this.wzPaneMap.put("Route Review/Edit", this.revEditPane);
        this.readCircuitPrefs();
        this.setCurrentPane("Circuit Attributes");
    }

    public void finish() {
        if (this.ckt == null || this.isInvalidCircuitState()) {
            this.terminate();
            return;
        }
        super.finish();
    }

    private void terminate() {
        ErrorMsg.displayError((Component)this, (EID)NEMC.EID_CHANGES_NET_CKT_ERROR);
        this.cancel(false);
    }

    private String getCktEndString(INetCircuitEnd iNetCircuitEnd) {
        try {
            IEntityModel iEntityModel = iNetCircuitEnd.getEntityModel();
            IModuleModel iModuleModel = iEntityModel.getModuleModel();
            INodeModel iNodeModel = iEntityModel.getNodeModel();
            IEntityCellRenderer iEntityCellRenderer = ElementFactoryFinder.getElementFactory(iNodeModel).createEntityCellRenderer(iModuleModel);
            String string = iEntityCellRenderer.getString((Object)iModuleModel, null);
            return string == "Ethergroup" ? string : CircuitEndCellRenderer.asSlashSeparatedString(iNetCircuitEnd);
        }
        catch (ObjNotFound objNotFound) {
            if (this.db.on) {
                this.db.println("Error in getEntityModel");
            }
            return "";
        }
    }

    protected String getCktStatus() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Name: ");
        stringBuffer.append(this.ckt.getCircuitName());
        stringBuffer.append("\nType: ");
        ICircuitType iCircuitType = CircuitType.getCircuitType((int)this.ckt.getCircuitType());
        ICircuitSize iCircuitSize = CircuitSize.getCircuitSize((int)this.ckt.getCircuitSize());
        stringBuffer.append(iCircuitType.getProtocolIndepCktTypeStr());
        stringBuffer.append("\nSize: ");
        stringBuffer.append(iCircuitSize.getCircuitSizeString());
        stringBuffer.append("\nDirection: ");
        stringBuffer.append(NetworkDefaults.circuitDirectionToString(this.ckt.getCircuitDir()));
        stringBuffer.append("\nState: ");
        stringBuffer.append(NetAdminState.getAdminStateStringFromAdminState(this.ckt.getAdminState()));
        stringBuffer.append("\n");
        stringBuffer.append("\nFrom: ");
        stringBuffer.append(this.getSourceNode().getName());
        if (iCircuitType.isHoCircuitType() || iCircuitType.isLoCircuitType() || iCircuitType.isEthernetCircuitType() || iCircuitType.isLAPCircuitType()) {
            stringBuffer.append("/");
            stringBuffer.append(this.getCktEndString(this.getSource()));
            if (this.getAltSourceNode() != null) {
                stringBuffer.append("\n and ");
                if (this.getSourceNode() != this.getAltSourceNode()) {
                    stringBuffer.append(this.getAltSourceNode().getName() + "/");
                }
                stringBuffer.append(this.getCktEndString(this.getAltSource()));
            }
        } else if (this.getAltSourceNode() != null) {
            stringBuffer.append(", " + this.getAltSourceNode().getName());
        }
        stringBuffer.append("\n");
        stringBuffer.append("\nTo: ");
        stringBuffer.append(this.getDestNode().getName());
        if (iCircuitType.isHoCircuitType() || iCircuitType.isLoCircuitType() || iCircuitType.isEthernetCircuitType()) {
            stringBuffer.append("/");
            stringBuffer.append(this.getCktEndString(this.getDest()));
            if (this.getAltDestNode() != null) {
                stringBuffer.append("\n and ");
                if (this.getDestNode() != this.getAltDestNode()) {
                    stringBuffer.append(this.getAltDestNode().getName() + "/");
                }
                stringBuffer.append(this.getCktEndString(this.getAltDest()));
            }
        } else if (this.getAltDestNode() != null) {
            stringBuffer.append(", " + this.getAltDestNode().getName());
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    void setHeight(int n) {
        this.setSize(new Dimension(850, n));
        this.invalidate();
    }

    public INodeModel getSourceNode() {
        INetCircuitEnd iNetCircuitEnd = (INetCircuitEnd)this.ckt.getSources().get(0);
        return iNetCircuitEnd.getNodeModel();
    }

    public INodeModel getDestNode() {
        INetCircuitEnd iNetCircuitEnd = (INetCircuitEnd)this.ckt.getDrops().get(0);
        return iNetCircuitEnd.getNodeModel();
    }

    public INodeModel getAltSourceNode() {
        if (this.ckt.getSources().size() > 1) {
            INetCircuitEnd iNetCircuitEnd = (INetCircuitEnd)this.ckt.getSources().get(1);
            return iNetCircuitEnd.getNodeModel();
        }
        return null;
    }

    public INodeModel getAltDestNode() {
        if (this.ckt.getDrops().size() > 1) {
            INetCircuitEnd iNetCircuitEnd = (INetCircuitEnd)this.ckt.getDrops().get(1);
            return iNetCircuitEnd.getNodeModel();
        }
        return null;
    }

    public INetCircuitEnd getSource() {
        return (INetCircuitEnd)this.ckt.getSources().get(0);
    }

    public INetCircuitEnd getAltSource() {
        if (this.ckt.getSources().size() > 1) {
            return (INetCircuitEnd)this.ckt.getSources().get(1);
        }
        return null;
    }

    public INetCircuitEnd getDest() {
        NetCircuitDropInfo netCircuitDropInfo = (NetCircuitDropInfo)this.ckt.getDrops().get(0);
        return netCircuitDropInfo.getNetCktEnd();
    }

    public INetCircuitEnd getAltDest() {
        if (this.ckt.getDrops().size() > 1) {
            NetCircuitDropInfo netCircuitDropInfo = (NetCircuitDropInfo)this.ckt.getDrops().get(1);
            return netCircuitDropInfo.getNetCktEnd();
        }
        return null;
    }

    protected void setDropProtection(boolean bl) {
        this.dropProtection = bl;
    }

    public String getResultString(Exception exception) {
        String string = null;
        if (exception == null) {
            string = "Successfully upgraded circuit";
        }
        return string;
    }

    protected void localValidation(int n) {
        if (this.isInvalidCircuitState()) {
            this.terminate();
        }
    }

    protected void calculateAlternatePath() throws Exception {
        this.unprot2UpsrInServiceUpgradeMgr = new Unprot2UpsrInServiceUpgradeMgr(this.ckt, this.getRoutePrefs(), this.isAutoRoute(), this.getUpsrGoReturnRouting(), this.getConnCreateAttrs(), this);
        this.unprot2UpsrInServiceUpgradeMgr.calculateAlternatePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void apply() throws Exception {
        try {
            if (this.uiToolkit != null) {
                this.uiToolkit.setCursor(3);
            }
            try {
                if (this.unprot2UpsrInServiceUpgradeMgr == null) {
                    this.unprot2UpsrInServiceUpgradeMgr = new Unprot2UpsrInServiceUpgradeMgr(this.ckt, this.getRoutePrefs(), this.isAutoRoute(), this.getUpsrGoReturnRouting(), this.getConnCreateAttrs(), this);
                } else {
                    this.unprot2UpsrInServiceUpgradeMgr.setGoReturnTrafficDir(this.getUpsrGoReturnRouting());
                    this.unprot2UpsrInServiceUpgradeMgr.setAutoRoute(this.isAutoRoute());
                }
                if (this.db.on) {
                    this.db.println("apply: ckt.sanityCheck() succeeded");
                }
            }
            catch (Exception exception) {
                throw new AnnotatedException("Circuit sanity check failed", exception);
            }
            try {
                this.unprot2UpsrInServiceUpgradeMgr.convert();
                if (this.db.on) {
                    this.db.println("apply: ckt.provision() succeeded");
                }
            }
            catch (Exception exception) {
                throw new AnnotatedException("Unable to convert circuit", exception);
            }
        }
        finally {
            if (this.uiToolkit != null) {
                this.uiToolkit.setCursor(0);
            }
        }
    }

    protected void handleFinish() {
        if (this.currentWzPane != null && this.currentWzPane instanceof WzCcdPane) {
            if (this.db.on()) {
                this.db.fine("WzCcdPane's handleFinish() for " + this.currentWzPane.getName());
            }
            ((WzCcdPane)this.currentWzPane).handleFinish();
        }
        super.handleFinish();
    }

    protected void handleCancel() {
        if (this.db.on) {
            this.db.println("handleCancel: cleaning up");
        }
        if (this.revEditPane != null) {
            this.revEditPane.recycle();
        }
        if (this.unprot2UpsrInServiceUpgradeMgr != null) {
            this.unprot2UpsrInServiceUpgradeMgr.cancel();
            this.unprot2UpsrInServiceUpgradeMgr = null;
        }
        this.destroyRelatedCircuits();
    }

    public void dispose() {
        this.circuitInfo = null;
        this.unprot2UpsrInServiceUpgradeMgr = null;
        super.dispose();
    }

    private boolean isInvalidCircuitState() {
        return this.ckt != null && this.ckt.getState() != 0 && this.ckt.getState() != 1 && this.ckt.getState() != 11 && this.ckt.getState() != 5;
    }

    protected EID getNoRouteEmcErrorId() {
        return NEMC.EID_UNPROTECTED_TO_UPSR_UPGRADE_ROUTE_ERROR_PARAM_1;
    }

    public void asyncUpdate(Object object, JobStatus jobStatus) {
        this.db.fine("asynchronous update received:" + jobStatus.getResult());
        Object object2 = jobStatus.getResult();
        DetailedLog detailedLog = null;
        if (jobStatus.value() == 2) {
            String string = "";
            Exception exception = null;
            if (object2 instanceof String) {
                string = object2.toString();
            } else if (object2 instanceof Exception) {
                exception = (Exception)object2;
            }
            TDMTerminology tDMTerminology = NetworkDefaults.getCmsHostTDMTerms();
            String string2 = tDMTerminology.getGeneralTerms(1);
            String string3 = tDMTerminology.getGeneralTerms(0);
            if (object2 instanceof NoMoreVtCapableSts) {
                ErrorMsg.displayError(this, (EID)NEMC.WID_NO_MORE_LO_CAPABLE_HO_PARAM_4, this.ckt.getCircuitName(), string2, string3, ((NoMoreVtCapableSts)((Object)object2)).getNodeName());
            } else if (object2 instanceof NoMoreLoCapableHo) {
                ErrorMsg.displayError(this, (EID)NEMC.WID_NO_MORE_LO_CAPABLE_HO_PARAM_4, this.ckt.getCircuitName(), string2, string3, ((NoMoreLoCapableHo)((Object)object2)).getNodeName());
            } else if (object2 instanceof PathListIncomplete || object2 instanceof PathInUse) {
                ErrorMsg.displayError((Component)this, (EID)NEMC.EID_UNPROTECTED_TO_UPSR_UPGRADE_ROUTE_ERROR_PARAM_1, (Object)CircuitMapUtil.UPSR_TERM);
            } else if (string.length() > 0) {
                CerentDialog.errorDialog((Component)this, (String)string, (String)"Upgrade Error");
            } else {
                CerentDialog.errorDialog((Component)this, (Exception)exception, (String)"Upgrade Error");
            }
        } else if (object2 instanceof Exception) {
            detailedLog = new DetailedLog(2, object2.toString(), (Exception)object2);
        } else {
            boolean bl = this.ckt.getCircuitType() == 3 || this.ckt.getCircuitType() == 6;
            if (!bl) {
                try {
                    for (int i = 15; i != 0 && !this.ckt.isCircuitProtected(); --i) {
                        Thread.sleep(1000L);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (bl || this.ckt.isCircuitProtected()) {
                detailedLog = new DetailedLog(1, object2.toString());
            } else {
                CerentDialog.warningDialog((Component)this, (String)("Unable to upgrade " + this.ckt.getCircuitName()));
            }
        }
        if (detailedLog != null) {
            EventBus.instance().notifyEvent((Object)EventBusServices.BG_STATUS_COLLECTOR, (Object)detailedLog);
        }
    }
}

