/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.event;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.NetworkModel;
import cerent.cms.model.event.EventInfo;
import cerent.cms.model.event.NetworkAlarmStore;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.Network;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.event.AlarmPane;
import cerent.cms.ui.event.EventPanel;
import cerent.cms.ui.event.FilterDialog;
import cerent.cms.ui.event.IEventPanelController;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.gui.row.RowDataSource;
import java.awt.Component;
import java.util.Collection;
import java.util.Iterator;

public class NetworkAlarmPane
extends AlarmPane {
    public NetworkAlarmPane(String string, TabbedView tabbedView, NetworkAlarmStore networkAlarmStore, IEventPanelController iEventPanelController) {
        super(string, tabbedView.getUiModel(), tabbedView, networkAlarmStore, iEventPanelController);
    }

    protected EventPanel createEventPanel(IEventPanelController iEventPanelController) {
        return new EventPanel((RowDataSource)this.alarmStore, iEventPanelController, 0);
    }

    protected void removeClearedAlarms() {
        try {
            this.alarmStore.removeClearedAlarms();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_COMMUNICATION_ERROR_PARAM_1, (Object)exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void syncAlarms() {
        NetworkAlarmStore networkAlarmStore = (NetworkAlarmStore)this.alarmStore;
        try {
            this.setCursor(3);
            networkAlarmStore.flushAlarmStore();
            networkAlarmStore.getAllPendingAlarms();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_COMMUNICATION_ERROR_PARAM_1, (Object)exception.getMessage());
        }
        finally {
            this.setCursor(0);
        }
    }

    protected void showFilterDialog() {
        try {
            Collection collection = Network.instance().getElements();
            int n = 0;
            INetElement iNetElement = null;
            INodeModel[] iNodeModelArray = new INodeModel[collection.size()];
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                iNetElement = (INetElement)iterator.next();
                if (iNetElement != null) {
                    iNodeModelArray[n] = iNetElement.getNodeModel();
                }
                ++n;
            }
            this.alarmStore.getEventFilter().setNodeModel(iNodeModelArray);
            new FilterDialog(this, this.alarmStore.getEventFilter(), "Alarm Filter").show();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    protected INodeModel getAffectedNodeModel(EventInfo eventInfo) {
        INodeModel iNodeModel = null;
        NetworkModel networkModel = null;
        IModel iModel = this.getUiModel();
        if (iModel instanceof NetworkModel) {
            networkModel = (NetworkModel)iModel;
        }
        if (null != networkModel) {
            try {
                iNodeModel = networkModel.getNodeModel(eventInfo.getNodeId());
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                db.println("AbstractCmsIOException caught trying to find the INodeModel affected by EventInfo=" + eventInfo);
                iNodeModel = null;
            }
        }
        return iNodeModel;
    }

    public CSHelpID getHelpID() {
        return NetCSHelpConst.AlarmPane;
    }
}

