/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.network;

import cerent.cms.model.CircuitEnd;
import cerent.cms.model.ICircuitEnd;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ObjNotFound;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.INetCircuitSpan;
import cerent.cms.ncp.NetCircuitDropInfo;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.Network;
import cerent.cms.ui.circuits.CircuitMapUtil;
import cerent.cms.ui.circuits.InternalPGFactory;
import cerent.cms.ui.network.CircuitExternalMapLink;
import cerent.cms.ui.network.CircuitExternalMapLinkCookie;
import cerent.cms.ui.network.CircuitMapLine;
import cerent.cms.ui.network.CircuitMapLink;
import cerent.cms.ui.network.CircuitMapLinkCookie;
import cerent.cms.ui.network.CircuitMapNodeCookie;
import cerent.cms.ui.network.CircuitMapPort;
import cerent.cms.ui.network.CircuitMapPortCookie;
import cerent.cms.ui.network.CircuitMapSelector;
import cerent.cms.ui.network.NetMapNode;
import cerent.util.HoLoNum;
import cerent.util.IHoNum;
import cerent.util.SDebug;
import com.cisco.ctc.util.map.AbstractInternalPG;
import com.cisco.ctc.util.map.DetailedMapNode;
import com.cisco.ctc.util.map.IMapLineEndpoint;
import com.cisco.ctc.util.map.Link;
import com.cisco.ctc.util.map.MapGraphicsUtil;
import com.cisco.ctc.util.map.MapLine;
import com.cisco.ctc.util.map.MapLink;
import com.cisco.ctc.util.map.MapLinkConnector;
import com.cisco.ctc.util.map.MapPort;
import com.cisco.ctc.util.map.MapSelector;
import com.cisco.ctc.util.map.MapToolkit;
import com.cisco.ctc.util.map.MapTransformer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.util.List;

public class CircuitMapNode
extends NetMapNode {
    private static final SDebug db = new SDebug("CircuitMapNode");
    private ICircuitType circuitType;
    private INetCircuit netCircuit;

    public CircuitMapNode(MapToolkit mapToolkit) {
        super(mapToolkit);
    }

    public void init(Object object, double d, double d2, Object object2) {
        super.init(object, d, d2, object2);
        if (object2 instanceof CircuitMapNodeCookie) {
            CircuitMapNodeCookie circuitMapNodeCookie = (CircuitMapNodeCookie)object2;
            this.setNetCircuit(circuitMapNodeCookie.getCircuit());
        }
    }

    public int getType() {
        Object object = this.getUserCookie();
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return 0;
    }

    public void setCircuitType(ICircuitType iCircuitType) {
        this.circuitType = iCircuitType;
    }

    private boolean isEthernetCircuitType() {
        return this.circuitType != null ? this.circuitType.isEthernetCircuitType() : false;
    }

    private boolean isTunnelCircuitType() {
        return this.circuitType != null ? this.circuitType.isTunnelCircuitType() : false;
    }

    public INetCircuit getNetCircuit() {
        return this.netCircuit;
    }

    private void setNetCircuit(INetCircuit iNetCircuit) {
        this.netCircuit = iNetCircuit;
    }

    public INetCircuitNode getNetCircuitNode() {
        if (this.netCircuit == null) {
            if (db.on()) {
                db.println("can't get a netcircuitnode; " + this + " did not have a set INetCircuit.");
            }
            return null;
        }
        Object object = this.getUserObject();
        if (!(object instanceof INodeModel)) {
            if (db.on()) {
                db.println("can't get a netcircuitnode; " + this + " did not have a set INodeModel.");
            }
            return null;
        }
        INodeModel iNodeModel = (INodeModel)object;
        INetElement iNetElement = Network.instance().findNetElem(iNodeModel.getNodeId());
        return this.netCircuit.getCircuitNodeFromNE(iNetElement);
    }

    protected void drawDetailed(Graphics2D graphics2D, MapTransformer mapTransformer) {
        super.drawDetailed(graphics2D, mapTransformer);
        char c = ' ';
        if (this.isEthernetCircuitType()) {
            c = 'E';
        } else if (this.isTunnelCircuitType()) {
            c = 'T';
        }
        if (c != ' ') {
            Color color = graphics2D.getColor();
            Rectangle2D rectangle2D = this.getBounds(mapTransformer);
            double d = rectangle2D.getWidth();
            double d2 = rectangle2D.getHeight();
            int n = (int)(rectangle2D.getX() + 0.4 * d);
            int n2 = (int)(rectangle2D.getY() + 0.4 * d2);
            int n3 = (int)(0.2 * d);
            int n4 = (int)(0.2 * d2);
            graphics2D.setColor(NetMapNode.OK_COLOR);
            graphics2D.fillOval(n, n2, n3, n4);
            graphics2D.setColor(Color.black);
            graphics2D.drawOval(n, n2, n3, n4);
            MapGraphicsUtil.drawLetter(graphics2D, n, n2, n3, n4, c, false);
            graphics2D.setColor(color);
        }
    }

    protected void receivedAlarmUpdate() {
        MapPort[] mapPortArray = this.getPorts();
        for (int i = 0; i < mapPortArray.length; ++i) {
            CircuitMapPort circuitMapPort = (CircuitMapPort)mapPortArray[i];
            if (!circuitMapPort.supportsHoModel() && !circuitMapPort.supportsLoModel() && !circuitMapPort.supportsOptModel()) continue;
            circuitMapPort.updateColor();
        }
        this.mtk.updateView();
    }

    public String getToolTipText() {
        String string = super.getToolTipText();
        if (this.isEthernetCircuitType()) {
            string = string + " (Ether Bridge)";
        } else if (this.isTunnelCircuitType()) {
            string = string + " (Tunnel)";
        }
        return string;
    }

    protected MapPort createMapPort(DetailedMapNode detailedMapNode, MapLink mapLink, MapLinkConnector mapLinkConnector) {
        Object object;
        Object object2;
        ActionListener actionListener;
        boolean bl;
        INetCircuit iNetCircuit;
        INetCircuitEnd iNetCircuitEnd;
        block15: {
            iNetCircuitEnd = null;
            iNetCircuit = null;
            bl = true;
            if (mapLink != null && mapLink instanceof CircuitMapLink) {
                try {
                    int n;
                    Object object3;
                    INetLink iNetLink;
                    List list;
                    actionListener = (CircuitMapLink)mapLink;
                    object2 = (CircuitMapLinkCookie)((Link)actionListener).getUserCookie();
                    object = ((CircuitMapLinkCookie)object2).getCircuitSpan().getLink();
                    iNetCircuit = ((CircuitMapLink)actionListener).getNetCircuit();
                    if (db.on()) {
                        db.println("Attaching LINK " + actionListener + " to NODE " + this);
                    }
                    if ((list = ((CircuitMapLink)actionListener).getPreExistingCircuitEndsList()) != null) {
                        for (int i = 0; iNetCircuitEnd == null && i < list.size(); ++i) {
                            iNetLink = list.get(i);
                            if (!(iNetLink instanceof NetCircuitEnd) || ((NetCircuitEnd)(object3 = (NetCircuitEnd)((Object)iNetLink))).getNodeModel() != this.getUserObject()) continue;
                            n = 0;
                            if (object.getSrc().getNodeModel().equals(this.getUserObject())) {
                                n = object.getSrcEntityIndex() == ((NetCircuitEnd)object3).getEntityIndex() ? 1 : 0;
                            } else {
                                int n2 = n = object.getDstEntityIndex() == ((NetCircuitEnd)object3).getEntityIndex() ? 1 : 0;
                            }
                            if (n == 0) continue;
                            iNetCircuitEnd = new NetCircuitEnd((INetCircuitEnd)object3);
                            if (!db.on()) continue;
                            db.println("\tusing preexisting circuit end: " + iNetCircuitEnd);
                        }
                    }
                    if (iNetCircuitEnd != null) break block15;
                    INetCircuitSpan iNetCircuitSpan = ((CircuitMapLink)actionListener).getNetCircuitSpan();
                    iNetLink = iNetCircuitSpan.getLink();
                    object3 = iNetLink.getLinkModel();
                    n = this.getNodeRoleInNetLink(iNetLink);
                    if (n == 1) {
                        iNetCircuitEnd = CircuitMapUtil.getCircuitEnd(object3.src(), iNetLink.getSrcEntityIndex(), iNetCircuitSpan.getSrcHoNum(), iNetCircuitSpan.getLoNum());
                        break block15;
                    }
                    if (n == 2) {
                        iNetCircuitEnd = CircuitMapUtil.getCircuitEnd(object3.dst(), iNetLink.getDstEntityIndex(), iNetCircuitSpan.getDstHoNum(), iNetCircuitSpan.getLoNum());
                        break block15;
                    }
                    db.println("could not find role of " + this.getUserObject() + " in the INetLink " + iNetLink);
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                    exception.printStackTrace();
                }
            } else if (mapLink != null && mapLink instanceof CircuitExternalMapLink) {
                actionListener = (CircuitExternalMapLink)mapLink;
                iNetCircuit = ((CircuitExternalMapLink)actionListener).getCircuit();
                iNetCircuitEnd = ((CircuitExternalMapLink)actionListener).getCircuitEnd();
            } else {
                bl = false;
            }
        }
        actionListener = this.doCreateCircuitMapPort(detailedMapNode, mapLinkConnector, iNetCircuitEnd);
        if (bl) {
            object2 = "";
            if (iNetCircuitEnd != null) {
                object2 = CircuitMapUtil.getSpanLabel(iNetCircuitEnd);
            }
            object = new CircuitMapPortCookie(iNetCircuit, (String)object2);
            ((CircuitMapPort)actionListener).init(iNetCircuitEnd, object);
        }
        return actionListener;
    }

    protected CircuitMapPort doCreateCircuitMapPort(DetailedMapNode detailedMapNode, MapLinkConnector mapLinkConnector, INetCircuitEnd iNetCircuitEnd) {
        return new CircuitMapPort(detailedMapNode, mapLinkConnector);
    }

    protected MapLine createMapLine(DetailedMapNode detailedMapNode, IMapLineEndpoint iMapLineEndpoint, IMapLineEndpoint iMapLineEndpoint2) {
        return new CircuitMapLine(detailedMapNode, iMapLineEndpoint, iMapLineEndpoint2);
    }

    protected MapSelector createMapSelector(DetailedMapNode detailedMapNode) {
        int n = 0;
        MapSelector[] mapSelectorArray = this.getSelectors();
        if (mapSelectorArray != null) {
            n = mapSelectorArray.length;
        }
        CircuitMapSelector circuitMapSelector = new CircuitMapSelector(detailedMapNode);
        circuitMapSelector.init(new Integer(n), null);
        return circuitMapSelector;
    }

    protected AbstractInternalPG createInternalPG(Object object) {
        return InternalPGFactory.instance().createInternalPG(this, object);
    }

    public final MapPort addPort(MapLink mapLink, MapLinkConnector mapLinkConnector) {
        MapPort mapPort = null;
        if (mapLink != null) {
            mapPort = this.getMapPortForLink(mapLink);
        }
        if (mapPort == null) {
            mapPort = super.addPort(mapLink, mapLinkConnector);
        } else {
            mapPort.addConnector(mapLinkConnector);
        }
        return mapPort;
    }

    private MapPort getMapPortForLink(MapLink mapLink) {
        Object object;
        if (db.on()) {
            db.println("Called getMapPortForLink() on node " + this.getName() + "- link is: " + mapLink);
        }
        if ((object = mapLink.getUserCookie()) != null && (object instanceof CircuitMapLinkCookie || object instanceof CircuitExternalMapLinkCookie)) {
            ICircuitEnd iCircuitEnd = this.getCircuitEnd(mapLink);
            MapPort mapPort = null;
            MapPort[] mapPortArray = this.getPorts();
            for (int i = 0; mapPort == null && i < mapPortArray.length; ++i) {
                MapPort mapPort2 = mapPortArray[i];
                ICircuitEnd iCircuitEnd2 = this.getCircuitEnd(mapPort2);
                if (!this.areEquals(iCircuitEnd, iCircuitEnd2)) continue;
                mapPort = mapPort2;
            }
            if (db.on()) {
                db.println("getMapPortForLink: port = " + mapPort);
            }
            return mapPort;
        }
        return null;
    }

    public int getEntityIndex(MapPort mapPort) {
        int n = -1;
        Object object = mapPort.getUserObject();
        if (object instanceof NetCircuitEnd) {
            n = ((NetCircuitEnd)object).getEntityIndex();
        } else if (object instanceof NetCircuitDropInfo) {
            n = ((NetCircuitDropInfo)object).getNetCktEnd().getEntityIndex();
        }
        return n;
    }

    private ICircuitEnd getCircuitEnd(MapPort mapPort) {
        Object object = mapPort.getUserObject();
        ICircuitEnd iCircuitEnd = null;
        if (object instanceof NetCircuitEnd) {
            iCircuitEnd = ((NetCircuitEnd)object).getCircuitEnd();
        } else if (object instanceof NetCircuitDropInfo) {
            iCircuitEnd = ((NetCircuitDropInfo)object).getNetCktEnd().getCircuitEnd();
        } else {
            db.warning(mapPort + " does not have a NetCircuitEnd/NetCircuitDropInfo key: " + object);
        }
        if (db.on()) {
            db.println("getCircuitEnd: aPort = " + mapPort + ", ce = " + this.toString(iCircuitEnd));
        }
        return iCircuitEnd;
    }

    private ICircuitEnd getCircuitEnd(MapLink mapLink) {
        ICircuitEnd iCircuitEnd = null;
        Object object = mapLink.getUserCookie();
        Object object2 = mapLink.getUserObject();
        if (object2 instanceof INetLink) {
            INetLink iNetLink = (INetLink)object2;
            int n = -1;
            IHoNum iHoNum = null;
            switch (this.getNodeRoleInNetLink(iNetLink)) {
                case 1: {
                    n = iNetLink.getSrcEntityIndex();
                    iHoNum = iNetLink.getSrcHo();
                    break;
                }
                case 2: {
                    n = iNetLink.getDstEntityIndex();
                    iHoNum = iNetLink.getDstHo();
                }
            }
            int n2 = ((INodeModel)this.getUserObject()).getNodeId();
            iCircuitEnd = new CircuitEnd(n2, n, new HoLoNum(iHoNum, null), false, 0);
        } else if (object instanceof CircuitExternalMapLinkCookie) {
            CircuitExternalMapLinkCookie circuitExternalMapLinkCookie = (CircuitExternalMapLinkCookie)object;
            INetCircuitEnd iNetCircuitEnd = circuitExternalMapLinkCookie.getCircuitEnd();
            if (iNetCircuitEnd instanceof NetCircuitEnd) {
                iCircuitEnd = ((NetCircuitEnd)iNetCircuitEnd).getCircuitEnd();
            } else if (iNetCircuitEnd instanceof NetCircuitDropInfo) {
                iCircuitEnd = ((NetCircuitDropInfo)iNetCircuitEnd).getNetCktEnd().getCircuitEnd();
            } else {
                db.warning(mapLink + " does not have a NetCircuitEnd/NetCircuitDropInfo nce: " + iNetCircuitEnd);
            }
            if (iCircuitEnd != null && iCircuitEnd.getPortNum() == 0) {
                try {
                    iCircuitEnd.setPortNum(iNetCircuitEnd.getEntityModel().getEntityIndex());
                }
                catch (ObjNotFound objNotFound) {
                    SDebug.printStackTrace((Throwable)objNotFound);
                }
            }
        }
        if (db.on()) {
            db.println("getCircuitEnd: aLink = " + mapLink + ", ce = " + this.toString(iCircuitEnd));
        }
        return iCircuitEnd;
    }

    private String toString(ICircuitEnd iCircuitEnd) {
        if (iCircuitEnd != null) {
            return "[" + Integer.toHexString(iCircuitEnd.getNodeId()) + ", " + Integer.toHexString(iCircuitEnd.getPortNum()) + ", " + iCircuitEnd.getHoLoNum().getHoNum() + "-" + iCircuitEnd.getHoLoNum().getLoNum() + "]";
        }
        return "null";
    }

    private boolean areEquals(ICircuitEnd iCircuitEnd, ICircuitEnd iCircuitEnd2) {
        return iCircuitEnd != null && iCircuitEnd2 != null && iCircuitEnd.getNodeId() == iCircuitEnd2.getNodeId() && iCircuitEnd.getPortNum() == iCircuitEnd2.getPortNum() && iCircuitEnd.getHoLoNum().equals(iCircuitEnd2.getHoLoNum());
    }
}

