/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.network;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.Feature;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.IDs123LineModel;
import cerent.cms.model.IDwdmLineModel;
import cerent.cms.model.IDwdmModuleModel;
import cerent.cms.model.IDwdmPortModel;
import cerent.cms.model.IDwdmTrkLineModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IFcmrLineModel;
import cerent.cms.model.IHdGeLineModel;
import cerent.cms.model.IHoPathTraceSupport;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.IL2scLineModel;
import cerent.cms.model.ILoPathTraceSupport;
import cerent.cms.model.ILoopback;
import cerent.cms.model.IML2PosLineModel;
import cerent.cms.model.IModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOpticsModel;
import cerent.cms.model.IPathTraceModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.ISonetStsModel;
import cerent.cms.model.ITdmHoModel;
import cerent.cms.model.ITdmLineModel;
import cerent.cms.model.ITdmLoModel;
import cerent.cms.model.ModelIndirectObservable;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.OchTrailHelper;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.circuits.NetCircuitModel;
import cerent.cms.model.event.IAlarmStatus;
import cerent.cms.model.event.ICardAlarmStore;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.ViewName;
import cerent.cms.ui.circuits.AbstractPathTrace;
import cerent.cms.ui.circuits.CircuitEndCellRenderer;
import cerent.cms.ui.circuits.CircuitMap;
import cerent.cms.ui.circuits.CircuitMapUtil;
import cerent.cms.ui.circuits.JnDialog;
import cerent.cms.ui.circuits.SfSdDialog;
import cerent.cms.ui.network.AbstractNetworkMap;
import cerent.cms.ui.network.CircuitExternalMapLink;
import cerent.cms.ui.network.CircuitExternalMapNode;
import cerent.cms.ui.network.CircuitMapNode;
import cerent.cms.ui.network.CircuitMapPortCookie;
import cerent.cms.ui.network.NetMapNode;
import cerent.util.IObservable;
import cerent.util.PathTraceUtil;
import cerent.util.SDebug;
import cerent.util.gui.UPopupMenu;
import com.cisco.ctc.util.map.DetailedMapLink;
import com.cisco.ctc.util.map.DetailedMapNode;
import com.cisco.ctc.util.map.MapGraphicsUtil;
import com.cisco.ctc.util.map.MapLinkConnector;
import com.cisco.ctc.util.map.MapNode;
import com.cisco.ctc.util.map.MapPort;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

public class CircuitMapPort
extends MapPort
implements Observer {
    protected boolean supportsHoModel = false;
    protected boolean supportsLoModel = false;
    protected boolean supportsOptModel = false;
    protected ITdmHoModel hoModel;
    protected ITdmLoModel loModel;
    protected IOpticsModel optModel;
    protected IHdGeLineModel hdgeModel;
    protected IFcmrLineModel fcmrModel;
    protected IL2scLineModel l2scModel;
    protected IInterfaceModel loopbackModel;
    protected IInterfaceModel lineModel;
    private static final SDebug db = new SDebug("CircuitMapPort");
    protected INetCircuitEnd nce;
    protected String suffixString = "";
    private boolean supportPathTraceCleanup = false;
    private IInterfaceModel ifModel = null;
    private ICardAlarmStore observedAlarmStore = null;
    private ILoopback lpbkModel = null;
    private JnDialog editTTIDlg = null;
    protected INetCircuit netCircuit = null;
    public static final String CMD_PORT_OPEN = "Open Port";
    public static final String CMD_PORT_TTI = "Edit TTI";
    public static final String CMD_PORT_J1PATHTRACE = "Edit J1 Path Trace";
    public static final String CMD_PORT_J2PATHTRACE = "Edit J2 Path Trace";
    public static final String CMD_PORT_SFSD = "Edit SF/SD BER Level";
    private static final String LINK_STATE = "Link State: ";
    private static final String SRVC_STATE = "Service State: ";

    public CircuitMapPort(DetailedMapNode detailedMapNode, MapLinkConnector mapLinkConnector) {
        super(detailedMapNode, mapLinkConnector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Object object, Object object2) {
        block21: {
            block19: {
                super.init(object, object2);
                this.nce = (INetCircuitEnd)object;
                CircuitMapPortCookie circuitMapPortCookie = (CircuitMapPortCookie)object2;
                this.netCircuit = circuitMapPortCookie.getCircuit();
                this.infoString = circuitMapPortCookie.getInfoString();
                this.ifModel = CircuitMapUtil.getInterfaceModel(this.netCircuit, this.nce);
                this.lineModel = CircuitMapUtil.getLineModel(this.netCircuit, this.nce);
                if (this.ifModel != null) {
                    ModelIndirectObservable.instance().addObserver((IObservable)this.ifModel, this);
                }
                try {
                    IInterfaceModel iInterfaceModel;
                    if (this.ifModel instanceof ITdmLoModel && this.nce.getEntityModel().getEqType() == 33 && this.ifModel.getNodeModel().provides(Feature.GET_LINE_INTERFACE_MODEL) && (iInterfaceModel = ((ITdmLoModel)this.ifModel).getLineInterfaceModel()) instanceof ILoopback) {
                        ModelIndirectObservable.instance().addObserver((IObservable)iInterfaceModel, this);
                        this.lpbkModel = (ILoopback)iInterfaceModel;
                    }
                }
                catch (Exception exception) {
                    if (!db.on()) break block19;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            if (this.lineModel != null) {
                ModelIndirectObservable.instance().addObserver((IObservable)this.lineModel, this);
                if (this.lpbkModel == null && this.lineModel instanceof ILoopback) {
                    this.lpbkModel = (ILoopback)this.lineModel;
                }
            }
            if (this.nce != null && (this.infoString == null || this.infoString.length() == 0)) {
                this.setInfoString(CircuitMapUtil.getSpanLabel(this.nce));
            }
            this.addAlarmStatusObserver();
            try {
                this.supportPathTraceCleanup = AbstractPathTrace.isPathTraceCleanupSupported(this.nce.getNodeModel());
            }
            catch (Exception exception) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            finally {
                if (db.on()) {
                    db.println("This port supports Path Trace cleanup = " + this.supportPathTraceCleanup);
                }
            }
            if (this.doesCircuitSupportPathTrace()) {
                if (this.supportPathTraceCleanup) {
                    this.setPathTraceLabel();
                } else {
                    this.oldSetPathTraceLabel();
                }
            }
            this.setLoopbackGraphic();
            try {
                int n = this.getEntityModelState(this.nce);
                this.setColor(this.stateToColor(n));
            }
            catch (Exception exception) {
                if (!db.on()) break block21;
                db.println("setTrace() hits exception");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    public INetCircuitEnd getCircuitEnd() {
        return this.nce;
    }

    public IInterfaceModel getIfModel() {
        return this.ifModel;
    }

    public INetCircuit getCircuit() {
        return this.netCircuit;
    }

    protected Color stateToColor(int n) {
        switch (n) {
            case 0: {
                return CircuitMapNode.OK_COLOR;
            }
            case 1: {
                return CircuitMapNode.MINOR_COLOR;
            }
            case 2: {
                return CircuitMapNode.MAJOR_COLOR;
            }
            case 3: {
                return CircuitMapNode.CRITICAL_COLOR;
            }
            case 6: {
                return CircuitMapNode.OOS_MT_COLOR;
            }
            case 7: {
                return CircuitMapNode.IS_AINS_COLOR;
            }
        }
        return CircuitMapNode.DISCONNECTED_COLOR;
    }

    public void doubleClicked() {
        super.doubleClicked();
        this.jumpToPortView();
    }

    private void jumpToPortView() {
        Object object = this.parentNode.getUserObject();
        if (this.nce != null && object != null && object instanceof INodeModel) {
            INodeModel iNodeModel = (INodeModel)object;
            try {
                IEntityModel iEntityModel = this.nce.getEntityModel();
                int n = 0;
                if (iNodeModel.provides(Feature.MULTISHELF) && iNodeModel.isMultishelf()) {
                    n = iEntityModel.getShelfId();
                }
                ViewName viewName = new ViewName(new int[]{iNodeModel.getNodeId(), n, iEntityModel.getSlot()});
                ((AbstractNetworkMap)this.mtk).tryJumpView(viewName);
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    public boolean supportsSfSdBerLevel(SecurityLevel securityLevel) {
        boolean bl;
        block9: {
            bl = false;
            if (this.nce != null) {
                try {
                    IEntityModel iEntityModel = this.nce.getEntityModel();
                    if (!AbstractPane.isUserAuthorized((IModel)iEntityModel, securityLevel)) {
                        bl = false;
                    } else if (iEntityModel instanceof IPortModel) {
                        IEntityModel iEntityModel2 = iEntityModel.getParent();
                        int n = iEntityModel2.getEqType();
                        if (n == 102 || n == 221 || n == 103 || n == 163 || n == 164 || n == 187) {
                            bl = true;
                        }
                    } else if (db.on()) {
                        db.println("entity=" + iEntityModel + " does not support " + "SF/SD BER");
                    }
                }
                catch (Exception exception) {
                    if (!db.on()) break block9;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        return bl;
    }

    public boolean supportsTTI(SecurityLevel securityLevel) {
        boolean bl;
        block9: {
            bl = false;
            if (this.nce != null && this.netCircuit != null) {
                try {
                    IEntityModel iEntityModel = this.nce.getEntityModel();
                    if (AbstractPane.isUserAuthorized((IModel)iEntityModel, securityLevel)) {
                        IEntityModel iEntityModel2 = iEntityModel.getParent();
                        IModuleModel iModuleModel = iEntityModel2.getModuleModel();
                        boolean bl2 = false;
                        if (iModuleModel instanceof IDwdmModuleModel) {
                            bl2 = ((IDwdmModuleModel)iModuleModel).supportsOTN();
                        }
                        boolean bl3 = false;
                        boolean bl4 = true;
                        boolean bl5 = false;
                        if (iEntityModel instanceof IPortModel) {
                            boolean bl6 = bl3 = iEntityModel.getEqType() == 123;
                            if (bl3) {
                                IInterfaceModel iInterfaceModel = ((IPortModel)iEntityModel).getInterfaceModel();
                                IDwdmTrkLineModel iDwdmTrkLineModel = (IDwdmTrkLineModel)iInterfaceModel;
                                bl5 = iDwdmTrkLineModel.getOTNStatus();
                                if (iEntityModel2.getEqType() == 121) {
                                    bl4 = iDwdmTrkLineModel.isWorkingLine();
                                }
                            }
                        }
                        bl = bl2 && bl3 && bl5 && bl4;
                    }
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    throw abstractCmsIOException;
                }
                catch (Exception exception) {
                    if (!db.on()) break block9;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        return bl;
    }

    public boolean supportsJ1PathTrace(SecurityLevel securityLevel) {
        boolean bl;
        block3: {
            bl = false;
            if (this.nce != null && this.netCircuit != null) {
                try {
                    IEntityModel iEntityModel = this.nce.getEntityModel();
                    bl = !AbstractPane.isUserAuthorized((IModel)iEntityModel, securityLevel) ? false : PathTraceUtil.supportsJ1PathTrace(iEntityModel, this.netCircuit.getCircuitTypeObj(), this.netCircuit.getCircuitSizeObj());
                }
                catch (Exception exception) {
                    if (!db.on()) break block3;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        return bl;
    }

    public boolean supportsJ2PathTrace(SecurityLevel securityLevel) {
        boolean bl;
        block4: {
            bl = false;
            if (this.nce != null && this.netCircuit != null) {
                try {
                    IEntityModel iEntityModel = this.nce.getEntityModel();
                    INodeModel iNodeModel = iEntityModel.getNodeModel();
                    if (iNodeModel.provides(Feature.J2_COMMON) && AbstractPane.isUserAuthorized((IModel)iEntityModel, securityLevel) && this.netCircuit.getCircuitTypeObj().isLoCircuitType()) {
                        bl = PathTraceUtil.supportsJ2PathTrace(iEntityModel, this.netCircuit.getCircuitSizeObj());
                    }
                }
                catch (Exception exception) {
                    if (!db.on()) break block4;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        return bl;
    }

    protected void initPopupMenu(UPopupMenu uPopupMenu) {
        this.actOrg.addMenuItem((JComponent)uPopupMenu, null, CMD_PORT_OPEN, 79);
        if (this.supportsTTI(SecurityLevel.PROVISIONING)) {
            this.actOrg.addMenuItem((JComponent)uPopupMenu, null, CMD_PORT_TTI, 69);
        }
        if (this.supportsJ1PathTrace(SecurityLevel.PROVISIONING)) {
            this.actOrg.addMenuItem((JComponent)uPopupMenu, null, CMD_PORT_J1PATHTRACE, 49);
        }
        if (this.supportsJ2PathTrace(SecurityLevel.PROVISIONING)) {
            this.actOrg.addMenuItem((JComponent)uPopupMenu, null, CMD_PORT_J2PATHTRACE, 50);
        }
        if (this.supportsSfSdBerLevel(SecurityLevel.PROVISIONING)) {
            this.actOrg.addMenuItem((JComponent)uPopupMenu, null, CMD_PORT_SFSD, 83);
        }
    }

    public boolean isDrop() {
        boolean bl = false;
        DetailedMapLink[] detailedMapLinkArray = this.parentNode.getLinks(this);
        for (int i = 0; !bl && i < detailedMapLinkArray.length; ++i) {
            CircuitExternalMapNode circuitExternalMapNode;
            DetailedMapLink detailedMapLink = detailedMapLinkArray[i];
            if (!(detailedMapLink instanceof CircuitExternalMapLink)) continue;
            MapNode mapNode = detailedMapLink.getSourceNode();
            if (mapNode instanceof CircuitExternalMapNode && (circuitExternalMapNode = (CircuitExternalMapNode)mapNode).isExternalDest()) {
                bl = true;
            }
            if (bl || !((mapNode = detailedMapLink.getTargetNode()) instanceof CircuitExternalMapNode) || !(circuitExternalMapNode = (CircuitExternalMapNode)mapNode).isExternalDest()) continue;
            bl = true;
        }
        return bl;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(CMD_PORT_OPEN)) {
            this.jumpToPortView();
        } else if (string.equals(CMD_PORT_J1PATHTRACE)) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(Boolean.FALSE);
            arrayList.add(this.netCircuit);
            ArrayList<CircuitMapPort> arrayList2 = new ArrayList<CircuitMapPort>();
            arrayList2.add(this);
            arrayList.add(arrayList2);
            arrayList.add(new Integer(1));
            CircuitMap circuitMap = null;
            if (this.mtk instanceof CircuitMap) {
                circuitMap = (CircuitMap)this.mtk;
            }
            arrayList.add(circuitMap);
            JnDialog jnDialog = JnDialog.instance(false, arrayList);
            jnDialog.show();
        } else if (string.equals(CMD_PORT_J2PATHTRACE)) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(Boolean.FALSE);
            arrayList.add(this.netCircuit);
            ArrayList<CircuitMapPort> arrayList3 = new ArrayList<CircuitMapPort>();
            arrayList3.add(this);
            arrayList.add(arrayList3);
            arrayList.add(new Integer(2));
            CircuitMap circuitMap = null;
            if (this.mtk instanceof CircuitMap) {
                circuitMap = (CircuitMap)this.mtk;
            }
            arrayList.add(circuitMap);
            JnDialog jnDialog = JnDialog.instance(false, arrayList);
            jnDialog.show();
        } else if (string.equals(CMD_PORT_SFSD)) {
            SfSdDialog sfSdDialog = new SfSdDialog(JOptionPane.getFrameForComponent((Component)((Object)this.mtk)), this);
        } else if (string.equals(CMD_PORT_TTI)) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(Boolean.FALSE);
            arrayList.add(this.netCircuit);
            ArrayList<CircuitMapPort> arrayList4 = new ArrayList<CircuitMapPort>();
            arrayList4.add(this);
            arrayList.add(arrayList4);
            arrayList.add(new Integer(3));
            CircuitMap circuitMap = null;
            if (this.mtk instanceof CircuitMap) {
                circuitMap = (CircuitMap)this.mtk;
            }
            arrayList.add(circuitMap);
            if (this.editTTIDlg != null) {
                this.editTTIDlg.dispose();
                this.editTTIDlg = null;
            }
            this.editTTIDlg = JnDialog.instance(false, arrayList);
            this.editTTIDlg.show();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    private boolean doesCircuitSupportPathTrace() {
        boolean bl;
        block6: {
            bl = true;
            ICircuitType iCircuitType = this.netCircuit.getCircuitTypeObj();
            if (iCircuitType.isOchncType() || iCircuitType.isOchTrailTunnelCircuitType() || iCircuitType.isOchccCircuitType()) {
                bl = false;
            }
            try {
                IEntityModel iEntityModel = this.nce.getEntityModel();
                IEntityModel iEntityModel2 = iEntityModel.getParent();
                IModuleModel iModuleModel = iEntityModel2.getModuleModel();
                if (iModuleModel instanceof IDwdmModuleModel) {
                    bl = false;
                }
            }
            catch (ObjNotFound objNotFound) {
                if (db.on()) {
                    db.println("doesCircuitSupportPathTrace: exception getting em: " + (Object)((Object)objNotFound));
                }
            }
            catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                if (!db.on()) break block6;
                db.println("doesCircuitSupportPathTrace: exception getting em: " + (Object)((Object)abstractCmsObjectNotExistException));
            }
        }
        return bl;
    }

    private void addAlarmStatusObserver() {
        block9: {
            try {
                IEntityModel iEntityModel = this.nce.getEntityModel();
                ICardAlarmStore iCardAlarmStore = this.getCardAlarmStore(iEntityModel);
                if (db.on()) {
                    db.println("addAlarmStatusObs(): CardAlarmStore for " + iEntityModel + " is: " + iCardAlarmStore);
                }
                iCardAlarmStore.addAlarmStatusObserver((Observer)this);
                this.observedAlarmStore = iCardAlarmStore;
                IModuleModel iModuleModel = null;
                if (iEntityModel instanceof IPortModel || iEntityModel instanceof IModuleModel) {
                    if (iEntityModel instanceof IModuleModel) {
                        iModuleModel = (IModuleModel)iEntityModel;
                    } else if (iEntityModel instanceof IPortModel) {
                        iModuleModel = ((IPortModel)iEntityModel).getModuleModel();
                    }
                    if (this.observedAlarmStore != null) {
                        this.observedAlarmStore.enablePortAlarmsStatus(iModuleModel);
                    }
                }
                if (db.on()) {
                    db.println("adding observedAlarmStore= " + this.observedAlarmStore);
                }
            }
            catch (Exception exception) {
                db.println("Caught exception in addAlarmStatusObserver!");
                if (!db.on()) break block9;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    private void setPathTraceLabel() {
        IEntityModel iEntityModel;
        block14: {
            this.setLetter(' ');
            iEntityModel = null;
            try {
                iEntityModel = this.nce.getEntityModel();
            }
            catch (Exception exception) {
                if (!db.on()) break block14;
                db.println("getInterfaceModel encountered exception:");
            }
        }
        if (iEntityModel != null && !PathTraceUtil.supportsJ1PathTrace(iEntityModel, 3) && !PathTraceUtil.supportsJ2PathTrace(iEntityModel)) {
            this.setLetter(' ');
            return;
        }
        if (this.ifModel != null) {
            boolean bl = this.netCircuit.getCircuitTypeObj().isHoCircuitType();
            IPathTraceModel iPathTraceModel = null;
            if (bl && this.ifModel instanceof IHoPathTraceSupport) {
                iPathTraceModel = ((IHoPathTraceSupport)this.ifModel).getHoPathTraceModel();
                this.supportsHoModel = true;
            } else if (!bl && this.ifModel instanceof ILoPathTraceSupport) {
                iPathTraceModel = ((ILoPathTraceSupport)this.ifModel).getLoPathTraceModel();
                this.supportsLoModel = true;
            }
            if (iPathTraceModel != null) {
                try {
                    this.setLetter(this.letterFromPathTraceMode(iPathTraceModel.getPathTraceMode()));
                }
                catch (Exception exception) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)exception);
                    }
                }
            }
        } else if (db.on()) {
            db.println("setPathTraceLabel: ifModel = null");
        }
        if (this.ifModel instanceof IOpticsModel) {
            this.supportsOptModel = true;
        }
        this.invalidateRelatedRegion();
    }

    public String getSuffixString() {
        return this.suffixString;
    }

    public void setSuffixString(String string) {
        this.suffixString = string;
        this.updateLinkText(this.getInfoString() + this.suffixString);
    }

    public boolean supportsHoModel() {
        return this.supportsHoModel;
    }

    public boolean supportsLoModel() {
        return this.supportsLoModel;
    }

    public boolean supportsOptModel() {
        return this.supportsOptModel;
    }

    private int getEntityModelState(INetCircuitEnd iNetCircuitEnd) throws ObjNotFound {
        int n = 0;
        try {
            INodeModel iNodeModel = iNetCircuitEnd.getNodeModel();
            if (iNodeModel == null) {
                if (db.on()) {
                    db.println("null node model for circuitEnd = " + iNetCircuitEnd + ".  Returning DISCONNECTED_STATE");
                }
                n = 4;
                return n;
            }
            if (!iNodeModel.isInited()) {
                if (db.on()) {
                    db.println(iNodeModel.getName() + " not inited for " + "getEntityModelState.  Returning " + "DISCONNECTED_STATE");
                }
                n = 4;
                return n;
            }
            switch (NetCircuitModel.getAdminState(iNetCircuitEnd, this.netCircuit.getCircuitSize())) {
                case 1: {
                    n = 4;
                    break;
                }
                case 2: 
                case 7: {
                    n = 6;
                    break;
                }
                case 3: 
                case 8: {
                    n = 7;
                }
            }
            if (n == 0) {
                IEntityModel iEntityModel = iNetCircuitEnd.getEntityModel();
                IPortModel iPortModel = null;
                if (iEntityModel instanceof IPortModel) {
                    iPortModel = (IPortModel)iEntityModel;
                } else if (iEntityModel instanceof IModuleModel) {
                    iPortModel = CircuitEndCellRenderer.getDs1(iEntityModel, iNetCircuitEnd.getLoNum(), iNetCircuitEnd.getHoNum());
                }
                if (iPortModel != null) {
                    if (iEntityModel.getNodeModel().provides(Feature.ENTITY_ALARM_STATUS)) {
                        IEntityModel iEntityModel2;
                        int n2 = 0;
                        if (iPortModel instanceof IDwdmPortModel && ((IDwdmPortModel)iPortModel).isClientPort() && (iEntityModel2 = OchTrailHelper.getPPM((IEntityModel)iPortModel)) != null) {
                            n2 = NetMapNode.getMapNodeState(this.observedAlarmStore.getEntityAlarmStatus(iEntityModel2));
                        }
                        n = NetMapNode.getMapNodeState(this.observedAlarmStore.getEntityAlarmStatus((IEntityModel)iPortModel));
                        n = Math.max(n2, n);
                    } else {
                        n = NetMapNode.getMapNodeState(this.observedAlarmStore.getPortAlarmStatus(iPortModel.getEqType(), iPortModel.getPort()));
                    }
                }
            }
        }
        catch (Exception exception) {
            this.dbDumpException(exception, "Exception in getEntityModelState(); forcing to DISCONNECTED_STATE");
            n = 4;
        }
        return n;
    }

    private ICardAlarmStore getCardAlarmStore(IEntityModel iEntityModel) throws Exception {
        INodeModel iNodeModel = iEntityModel.getNodeModel();
        if (iNodeModel.provides(Feature.MULTISHELF) && iNodeModel.isMultishelf()) {
            return iNodeModel.getElementAlarmStore().getCardAlarmStore(iEntityModel.getShelfId(), iEntityModel.getSlot());
        }
        return iNodeModel.getElementAlarmStore().getCardAlarmStore(iEntityModel.getSlot());
    }

    protected char letterFromPathTraceMode(int n) {
        if (n == 1 || n == 3) {
            return 'A';
        }
        if (n == 2 || n == 4) {
            return 'M';
        }
        return ' ';
    }

    private void setLoopbackGraphic() {
        block10: {
            if (CircuitMapPort.db.on) {
                db.println("setLoopbackGraphic: ifModel= " + this.ifModel + ", lpbkModel=" + this.lpbkModel);
            }
            if (this.lpbkModel != null) {
                try {
                    switch (this.lpbkModel.getLoopbackAsInt()) {
                        case 0: {
                            this.setDesign(0);
                            break;
                        }
                        case 2: 
                        case 3: {
                            this.setDesign(2);
                            break;
                        }
                        case 1: {
                            this.setDesign(1);
                            break;
                        }
                        default: {
                            this.setDesign(0);
                            break;
                        }
                    }
                }
                catch (Exception exception) {
                    if (!CircuitMapPort.db.on) break block10;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        if (this.hasXcLoopback()) {
            this.setDesign(3);
        }
        this.invalidateRelatedRegion();
    }

    private boolean hasXcLoopback() {
        boolean bl;
        block4: {
            bl = false;
            if (db.on()) {
                db.println("Performing an XC Loopback check on " + this.ifModel);
            }
            try {
                if (this.ifModel instanceof ITdmHoModel) {
                    bl = ((ITdmHoModel)this.ifModel).hasXcLoopback();
                }
            }
            catch (Exception exception) {
                if (!CircuitMapPort.db.on) break block4;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return bl;
    }

    public void updateColor() {
        Color color = this.getColor();
        try {
            int n = this.getEntityModelState(this.nce);
            Color color2 = this.stateToColor(n);
            if (!color.equals(color2)) {
                this.setColor(color2);
                db.info("Update on port " + this.getInfoString() + "/st=" + MapGraphicsUtil.getColorString(color) + " -> " + MapGraphicsUtil.getColorString(color2));
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    public void update(Observable observable, Object object) {
        if (db.on()) {
            db.println("ob=" + observable + "(" + observable.getClass().getName() + ") o=" + object + "(" + object.getClass().getName() + ")");
        }
        if (object instanceof IAlarmStatus) {
            this.updateColor();
        }
        if (object == ModelUpdateType.CHANGED && observable instanceof IInterfaceModel) {
            this.updateColor();
            if (this.doesCircuitSupportPathTrace()) {
                if (this.supportPathTraceCleanup) {
                    this.setPathTraceLabel();
                } else {
                    this.oldUpdatePathTraceLabel(observable, object);
                }
            }
            this.checkMediumChange((IInterfaceModel)observable);
            this.setLoopbackGraphic();
            this.parentNode.invalidate();
        }
    }

    private void checkMediumChange(IInterfaceModel iInterfaceModel) {
        if (iInterfaceModel instanceof ITdmLineModel) {
            String string;
            ITdmLineModel iTdmLineModel = (ITdmLineModel)iInterfaceModel;
            if (db.on()) {
                db.println("medium is: " + iTdmLineModel.getMediumType());
            }
            if ((string = this.getInfoString()).indexOf("(RTo)") != -1) {
                this.setInfoString(CircuitMapUtil.getSpanLabel(this.nce) + "(RTo)");
            } else if (string.indexOf("(RFrom)") != -1) {
                this.setInfoString(CircuitMapUtil.getSpanLabel(this.nce) + "(RFrom)");
            } else {
                this.setInfoString(CircuitMapUtil.getSpanLabel(this.nce));
            }
            this.invalidateRelatedRegion();
        }
    }

    private String getServiceStateString() {
        if (this.nce != null) {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.nce.getNodeModel().provides(Feature.EXTENDED_ESM)) {
                try {
                    int n = this.nce.getEntityModel().getEqType();
                    if (n == 165 || n == 105) {
                        stringBuffer.append(LINK_STATE);
                    } else {
                        stringBuffer.append(SRVC_STATE);
                    }
                }
                catch (ObjNotFound objNotFound) {
                    // empty catch block
                }
            }
            stringBuffer.append(NetCircuitModel.getDetailedServiceStateString(this.nce, this.netCircuit.getCircuitSize()));
            return stringBuffer.toString();
        }
        return "";
    }

    public void invalidateRelatedRegion() {
        NetMapNode netMapNode = (NetMapNode)this.parentNode;
        if (netMapNode != null) {
            netMapNode.invalidate();
        }
    }

    public void dispose() {
        if (this.ifModel != null) {
            ModelIndirectObservable.instance().deleteObserver((IObservable)this.ifModel, this);
        }
        if (this.lineModel != null) {
            ModelIndirectObservable.instance().deleteObserver((IObservable)this.lineModel, this);
        }
        if (this.lpbkModel != null) {
            ModelIndirectObservable.instance().deleteObserver((IObservable)((IInterfaceModel)this.lpbkModel), this);
        }
        try {
            IEntityModel iEntityModel;
            if (this.nce != null && (iEntityModel = this.nce.getEntityModel()) != null) {
                this.observedAlarmStore.disablePortAlarmsStatus();
            }
        }
        catch (Exception exception) {
            this.dbDumpException(exception, "Exception in disabling port alarm status");
        }
        try {
            if (this.observedAlarmStore != null) {
                this.observedAlarmStore.deleteAlarmStatusObserver((Observer)this);
                if (db.on()) {
                    db.println("disposing observedAlarmStore= " + this.observedAlarmStore);
                }
                this.observedAlarmStore = null;
            }
        }
        catch (Exception exception) {
            this.dbDumpException(exception, "Exception in deleting alarm status observer");
        }
    }

    public int getAdminState() {
        return NetCircuitModel.getAdminState(this.nce, this.netCircuit.getCircuitSize());
    }

    public String getToolTipText() {
        StringBuffer stringBuffer = new StringBuffer(64);
        char c = this.getLetter();
        String string = this.getServiceStateString();
        stringBuffer.append(this.getInfoString());
        if (string.length() > 0) {
            stringBuffer.append('(').append(string).append(')');
        }
        if (c == 'A') {
            stringBuffer.append(", Path Trace Mode: Auto/Locked");
        } else if (c == 'M') {
            stringBuffer.append(", Path Trace Mode: Manual");
        }
        int n = this.getDesign();
        if (n == 2) {
            stringBuffer.append(", Facility Loopback");
        } else if (n == 1) {
            stringBuffer.append(", Terminal Loopback");
        } else if (n == 3) {
            stringBuffer.append(", XC Loopback");
        }
        return stringBuffer.toString() + this.suffixString;
    }

    protected void dbDumpException(Exception exception, String string) {
        db.println(string);
        db.println("\tinfoString=" + this.infoString);
        db.println("\tparent node=" + this.parentNode);
        if (db.on()) {
            db.println("\texception =");
            SDebug.printStackTrace((Throwable)exception);
        } else {
            db.println("\tFor exception dump, set debug: " + db.toString());
        }
    }

    private void oldUpdatePathTraceLabel(Observable observable, Object object) {
        try {
            int n = -1;
            n = observable instanceof ITdmHoModel ? ((ITdmHoModel)observable).getHoPathTraceMode() : (observable instanceof ITdmLoModel ? ((ITdmLoModel)observable).getLoPathTraceMode() : (observable instanceof IHdGeLineModel ? ((IHdGeLineModel)observable).getPathTraceMode() : (observable instanceof IFcmrLineModel ? ((IFcmrLineModel)observable).getPathTraceMode() : (observable instanceof IL2scLineModel ? (this.netCircuit.getCircuitTypeObj().isHoCircuitType() ? ((IL2scLineModel)observable).getPathTraceMode() : ((IL2scLineModel)observable).getLoPathTraceMode()) : ((ISonetStsModel)observable).getStsPathTraceMode()))));
            this.setLetter(this.letterFromPathTraceMode(n));
            this.invalidateRelatedRegion();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            db.finer("IllegalArgumentException in update() of " + this + ", ob=" + observable + ", o=" + object + " " + illegalArgumentException);
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            db.finer("AbstractCmsIOException in update() of " + this + ", ob=" + observable + ", o=" + object + " " + (Object)((Object)abstractCmsIOException));
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    private void oldSetPathTraceLabel() {
        try {
            if (this.nce != null && Feature.provides((INodeModel)this.nce.getNodeModel(), (Feature)Feature.STS_IFACE)) {
                IEntityModel iEntityModel = this.nce.getEntityModel();
                if (iEntityModel != null && !PathTraceUtil.supportsJ1PathTrace(iEntityModel, 3) && !PathTraceUtil.supportsJ2PathTrace(iEntityModel)) {
                    this.setLetter(' ');
                }
                IInterfaceModel iInterfaceModel = CircuitMapUtil.getInterfaceModel(this.netCircuit, this.nce);
                if (db.on()) {
                    db.println("tmpModel= " + iInterfaceModel);
                }
                if (iInterfaceModel instanceof ITdmHoModel) {
                    this.supportsHoModel = true;
                    this.hoModel = (ITdmHoModel)iInterfaceModel;
                } else if (iInterfaceModel instanceof IL2scLineModel) {
                    this.l2scModel = (IL2scLineModel)iInterfaceModel;
                    if (this.netCircuit.getCircuitTypeObj().isHoCircuitType()) {
                        this.supportsHoModel = true;
                    } else {
                        this.supportsLoModel = true;
                    }
                } else if (iInterfaceModel instanceof IML2PosLineModel) {
                    if (this.netCircuit.getCircuitTypeObj().isHoCircuitType()) {
                        this.supportsHoModel = true;
                    } else {
                        this.supportsLoModel = true;
                    }
                } else if (iInterfaceModel instanceof ITdmLoModel) {
                    this.supportsLoModel = true;
                    this.loModel = (ITdmLoModel)iInterfaceModel;
                } else if (iInterfaceModel instanceof IHdGeLineModel) {
                    this.supportsHoModel = true;
                    this.hdgeModel = (IHdGeLineModel)iInterfaceModel;
                } else if (iInterfaceModel instanceof IFcmrLineModel) {
                    this.supportsHoModel = true;
                    this.fcmrModel = (IFcmrLineModel)iInterfaceModel;
                } else if (iInterfaceModel instanceof IDwdmLineModel) {
                    this.setLetter(' ');
                } else if (iInterfaceModel instanceof IDs123LineModel) {
                    this.setLetter(' ');
                } else if (iInterfaceModel instanceof IOpticsModel) {
                    this.supportsOptModel = true;
                }
                if (this.hoModel != null) {
                    if (db.on()) {
                        db.println("hoModel= " + this.hoModel);
                    }
                    ModelIndirectObservable.instance().addObserver((IObservable)this.hoModel, this);
                    this.setLetter(this.letterFromPathTraceMode(this.hoModel.getHoPathTraceMode()));
                } else if (this.loModel != null) {
                    this.loModel.addObserver((Observer)this);
                    this.setLetter(this.letterFromPathTraceMode(this.loModel.getLoPathTraceMode()));
                } else if (this.l2scModel != null) {
                    this.l2scModel.addObserver((Observer)this);
                    if (this.netCircuit.getCircuitTypeObj().isHoCircuitType()) {
                        this.setLetter(this.letterFromPathTraceMode(this.l2scModel.getPathTraceMode()));
                    } else {
                        this.setLetter(this.letterFromPathTraceMode(this.l2scModel.getLoPathTraceMode()));
                    }
                } else if (this.hdgeModel != null) {
                    this.hdgeModel.addObserver((Observer)this);
                    this.setLetter(this.letterFromPathTraceMode(this.hdgeModel.getPathTraceMode()));
                } else if (this.fcmrModel != null) {
                    this.fcmrModel.addObserver((Observer)this);
                    try {
                        this.setLetter(this.letterFromPathTraceMode(this.fcmrModel.getPathTraceMode()));
                    }
                    catch (Exception exception) {
                        this.setLetter('X');
                    }
                }
            }
        }
        catch (ObjNotFound objNotFound) {
            db.finer("ObjNotFound in " + this + " " + (Object)((Object)objNotFound));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            db.finer("IllegalArgumentException in " + this + " " + illegalArgumentException);
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            db.finer("AbstractCmsIOException in " + this + " " + (Object)((Object)abstractCmsIOException));
        }
        catch (Exception exception) {
            this.dbDumpException(exception, "Exception in CircuitPort Constructor");
        }
        this.invalidateRelatedRegion();
    }
}

