/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.network;

import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.IDwdmPortModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.LinkModel;
import cerent.cms.topo.INetLink;
import cerent.util.SDebug;
import cerent.util.SONETTDMTerminology;
import cerent.util.TDMTerminology;
import java.util.TreeMap;

public class LinkClass {
    public static final String SONET_DCC = "DCC";
    public static final String SDH_DCC = "DCC";
    public static final String GCC = "GCC";
    public static final String OTS = "OTS";
    public static final String PPC = "PPC";
    public static final String ST = "Server Trail";

    public static String getLinkClass(Object object) {
        if (object instanceof INetLink) {
            INetLink iNetLink = (INetLink)object;
            int n = iNetLink.getLinkModel().physicalLinkType();
            if (n == 5) {
                return OTS;
            }
            if (n == 3) {
                IEntityModel iEntityModel = ((LinkModel)iNetLink.getLinkModel()).getEndEntityModel(true);
                if (iEntityModel instanceof IDwdmPortModel) {
                    try {
                        IDwdmPortModel iDwdmPortModel = (IDwdmPortModel)iEntityModel;
                        if (iDwdmPortModel.isSonetDccTermination()) {
                            return "DCC";
                        }
                        return GCC;
                    }
                    catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                        SDebug.root.warning("Cannot manage Link Class for " + iEntityModel);
                        SDebug.printStackTrace((Throwable)abstractCmsObjectNotExistException);
                    }
                }
                if (iNetLink.isSdccLink()) {
                    return "DCC";
                }
                return GCC;
            }
            if (n == 6) {
                return PPC;
            }
            if (n == 12) {
                return ST;
            }
            if (n == 1) {
                return "DCC";
            }
            if (n == 2) {
                return "DCC";
            }
        }
        return null;
    }

    public static int getLinkType(String string, TDMTerminology tDMTerminology) {
        if (string.equals(OTS)) {
            return 5;
        }
        if (string.equals(GCC)) {
            return 3;
        }
        if (string.equals(PPC)) {
            return 6;
        }
        if (string.equals(ST)) {
            return 12;
        }
        if (string.equals("DCC")) {
            if (tDMTerminology instanceof SONETTDMTerminology) {
                return 1;
            }
            return 2;
        }
        return -1;
    }

    public static TreeMap getLinkClasses(String string, TDMTerminology tDMTerminology) {
        TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>();
        if (string.equals("TDM") || string.equals("All")) {
            if (tDMTerminology instanceof SONETTDMTerminology) {
                treeMap.put("DCC", new Integer(1));
            } else {
                treeMap.put("DCC", new Integer(2));
            }
            treeMap.put(PPC, new Integer(6));
            treeMap.put(ST, new Integer(12));
        }
        if (string.equals("DWDM") || string.equals("All")) {
            treeMap.put(GCC, new Integer(3));
            treeMap.put(OTS, new Integer(5));
            treeMap.put(PPC, new Integer(6));
        }
        return treeMap;
    }
}

