/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.network;

import cerent.cms.loader.ElementFactoryFinder;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.INodeModel;
import cerent.cms.model.INodeType;
import cerent.cms.model.ModelIndirectObservable;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NetworkModel;
import cerent.cms.model.NodeModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.event.IAlarmStatus;
import cerent.cms.model.event.IAlarmStore;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.Network;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.NetworkViewController;
import cerent.cms.ui.network.IVitalStatsPaneObject;
import cerent.cms.ui.network.MapPersist;
import cerent.cms.ui.network.NetworkMap;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.IObservable;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UPopupMenu;
import com.cisco.ctc.util.map.DetailedMapNode;
import com.cisco.ctc.util.map.MapNode;
import com.cisco.ctc.util.map.MapToolkit;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class NetMapNode
extends DetailedMapNode
implements Observer,
IVitalStatsPaneObject {
    protected IAlarmStore alarmStore = null;
    private NodeModel model = null;
    private INetElement ne = null;
    private String nodeName = "";
    private boolean isCmsHost = false;
    private int opticalNodeType = 0;
    protected Image[] cachedIcons = null;
    private String toolTipNodeType = null;
    private int nodeId;
    protected int state = 5;
    public static final int OK_STATE = 0;
    public static final int MINOR_STATE = 1;
    public static final int MAJOR_STATE = 2;
    public static final int CRITICAL_STATE = 3;
    public static final int DISCONNECTED_STATE = 4;
    public static final int UNKNOWN_STATE = 5;
    public static final int OOS_MT_STATE = 6;
    public static final int IS_AINS_STATE = 7;
    public static final String OK_STRING = "OK";
    public static final String MINOR_STRING = "Minor";
    public static final String MAJOR_STRING = "Major";
    public static final String CRITICAL_STRING = "Critical";
    public static final String DISCONNECTED_STRING = "Disconnected";
    public static final String POSITION_XY = "PositionXY";
    public static final String OOS_MT_STRING = "OOS_MT";
    public static final String IS_AINS_STRING = "IS_AINS";
    public static final Color OK_COLOR = Color.green;
    public static final Color MINOR_COLOR = Color.yellow;
    public static final Color MAJOR_COLOR = Color.orange;
    public static final Color CRITICAL_COLOR = Color.red;
    public static final Color DISCONNECTED_COLOR = Color.gray;
    public static final Color OOS_MT_COLOR = Color.cyan;
    public static final Color IS_AINS_COLOR = new Color(205, 205, 255);
    public static final String CMD_NODE_OPEN = "Open Node";
    public static final String CMD_NODE_RESET_POS = "Reset Node Position";
    public static final String CMD_DEL_NODE = "Delete Node";
    public static final String HUB_STR = "Hub";
    public static final String LINE_STR = "Line";
    public static final String EAST_TERM_STR = "EastTerm";
    public static final String WEST_TERM_STR = "WestTerm";
    public static final String OADM_STR = "Oadm";
    public static final String UNKNOWN_STR = "Unknown";
    public static final String HYBRID_SITE = "Amplified TDM";
    public static final String OSC_LINE_STR = "OSC Line";
    public static final String ROADM_STR = "ROADM";
    private boolean instantiated = true;
    private static final SDebug db = new SDebug("NetMapNode");
    private UpdateNodeAttributes updateNodeAttributes = new UpdateNodeAttributes();
    private static final Image[] DEFAULT_UNK_IMAGE = new Image[]{NetMapNode.createImage("/images/icons/unknown/32x32-Unknown_green_dim.gif"), NetMapNode.createImage("/images/icons/unknown/32x32-Unknown_yellow_dim.gif"), NetMapNode.createImage("/images/icons/unknown/32x32-Unknown_orange_dim.gif"), NetMapNode.createImage("/images/icons/unknown/32x32-Unknown_red_dim.gif"), NetMapNode.createImage("/images/icons/unknown/32x32-Unknown_grey_dim.gif"), NetMapNode.createImage("/images/icons/unknown/32x32-Unknown_blue.gif"), NetMapNode.createImage("/images/icons/unknown/32x32-Unknown_dkblue_dim.gif"), NetMapNode.createImage("/images/icons/unknown/32x32-Unknown_magenta_dim.gif"), NetMapNode.createImage("/images/icons/unknown/32x32-Unknown_green_dim.gif"), NetMapNode.createImage("/images/icons/unknown/32x32-Unknown_yellow_dim.gif"), NetMapNode.createImage("/images/icons/unknown/32x32-Unknown_orange_dim.gif"), NetMapNode.createImage("/images/icons/unknown/32x32-Unknown_red_dim.gif"), NetMapNode.createImage("/images/icons/unknown/32x32-Unknown_grey_dim.gif"), NetMapNode.createImage("/images/icons/unknown/32x32-Unknown_blue.gif"), NetMapNode.createImage("/images/icons/unknown/32x32-Unknown_dkblue_dim.gif"), NetMapNode.createImage("/images/icons/unknown/32x32-Unknown_magenta_dim.gif")};

    public NetMapNode(MapToolkit mapToolkit) {
        super(mapToolkit);
    }

    public Color stateToColor(int n) {
        switch (n) {
            case 0: {
                return OK_COLOR;
            }
            case 1: {
                return MINOR_COLOR;
            }
            case 2: {
                return MAJOR_COLOR;
            }
            case 3: {
                return CRITICAL_COLOR;
            }
            case 6: {
                return OOS_MT_COLOR;
            }
            case 7: {
                return IS_AINS_COLOR;
            }
        }
        return DISCONNECTED_COLOR;
    }

    public static String getStateDescription(int n) {
        switch (n) {
            case 0: {
                return OK_STRING;
            }
            case 1: {
                return MINOR_STRING;
            }
            case 2: {
                return MAJOR_STRING;
            }
            case 3: {
                return CRITICAL_STRING;
            }
            case 6: {
                return OOS_MT_STRING;
            }
            case 7: {
                return IS_AINS_STRING;
            }
        }
        return DISCONNECTED_STRING;
    }

    public void init(Object object, double d, double d2, Object object2) {
        if (db.on()) {
            db.println("init() called");
        }
        super.init(object, d, d2, object2);
        if (this.getUserObject() instanceof INodeModel) {
            this.model = (NodeModel)this.getUserObject();
            if (this.model != null) {
                this.nodeId = this.model.getOldNodeId();
                this.isCmsHost = this.model.isCmsHost();
                this.opticalNodeType = this.getModelOpticalType();
                this.addObservers();
                this.updateNodeAttributes();
            }
        }
    }

    protected Image[] fetchIcons(Object object) {
        Image[] imageArray;
        if (object != null && (imageArray = this.getIconSet()) != null) {
            this.cachedIcons = imageArray;
            this.toolTipNodeType = this.getNodeTypeTooltip();
            return imageArray;
        }
        if (this.cachedIcons != null) {
            return this.cachedIcons;
        }
        return DEFAULT_UNK_IMAGE;
    }

    protected Image[] getIconSet() {
        block3: {
            try {
                if (this.model != null) {
                    return ElementFactoryFinder.getElementFactory(this.model).getIconSet((INodeModel)this.model);
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block3;
                db.println("Caught exception in getIconSet()");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return null;
    }

    private boolean isTopoHost() {
        boolean bl = false;
        if (this.ne == null) {
            if (this.model != null) {
                this.ne = Network.instance().findNetElem(this.model.getNodeId());
            } else {
                if (db.on()) {
                    db.println("Unable to aquire reference to NetElement.");
                }
                return bl;
            }
        }
        if (this.ne != null) {
            bl = this.ne.isTopoHost();
        }
        if (db.on()) {
            db.println("Is this a Topo Host? " + bl);
        }
        return bl;
    }

    private void changeNodeName(String string) {
        block4: {
            try {
                if (this.isTopoHost()) {
                    string = string + "*";
                }
                this.setName(string);
                if (this.isCmsHost && this.isNetworkMap()) {
                    this.setFontStyle(1);
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block4;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    private String getNewNodeName() {
        String string;
        block2: {
            string = this.getName();
            try {
                string = this.model.getName();
            }
            catch (Exception exception) {
                if (!db.on()) break block2;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return string;
    }

    protected synchronized void resetPosition() {
        block6: {
            Point2D.Double double_;
            block5: {
                if (!(this.getUserObject() instanceof INodeModel)) {
                    if (NetMapNode.db.on) {
                        db.println("resetPosition: MapNode isn't a INodeModel");
                    }
                    return;
                }
                double_ = NetMapNode.getPositionXY(this.mtk, (INodeModel)this.getUserObject());
                NetMapNode netMapNode = this;
                if (double_.getX() != (double)netMapNode.mtk.getCanvasCenterX()) break block5;
                NetMapNode netMapNode2 = this;
                if (double_.getY() == (double)netMapNode2.mtk.getCanvasCenterY()) break block6;
            }
            this.setCoordinates(MapPersist.toNewX((int)double_.getX()), MapPersist.toNewY((int)double_.getY()));
        }
        this.mtk.updateView();
    }

    public static Point2D.Double getPositionXY(MapToolkit mapToolkit, INodeModel iNodeModel) {
        double d = mapToolkit.getCanvasCenterX();
        double d2 = mapToolkit.getCanvasCenterY();
        if (iNodeModel == null) {
            return new Point2D.Double(d, d2);
        }
        if (!iNodeModel.isInited() || iNodeModel.getNodeId() == 0) {
            return new Point2D.Double(d, d2);
        }
        try {
            String string = iNodeModel.getProperty(POSITION_XY);
            String string2 = string.substring(0, string.indexOf(44));
            String string3 = string.substring(string.indexOf(44) + 1);
            d = Double.parseDouble(string2);
            d2 = Double.parseDouble(string3);
            if (NetMapNode.db.on) {
                db.println("getPositionXY: node=" + iNodeModel.getName() + ", x=" + d + " y=" + d2);
            }
            return new Point2D.Double(d, d2);
        }
        catch (Exception exception) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            try {
                d = mapToolkit.toWorldX(iNodeModel.getLongitude());
                d2 = mapToolkit.toWorldY(iNodeModel.getLatitude());
                if (NetMapNode.db.on) {
                    db.println("getPositionXY: node=" + iNodeModel.getName());
                    db.println("translate longitude=" + iNodeModel.getLongitude() + " to X=" + d);
                    db.println("translate latitude=" + iNodeModel.getLatitude() + " to Y=" + d2);
                }
                return new Point2D.Double(d, d2);
            }
            catch (Exception exception2) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)exception2);
                }
                return new Point2D.Double(d, d2);
            }
        }
    }

    public int getState() {
        if (db.on()) {
            db.println("getState for " + this.getName() + " returning " + this.state);
        }
        if (!this.instantiated) {
            return 5;
        }
        return this.state;
    }

    private int getModelState() {
        IAlarmStore iAlarmStore;
        if (this.model == null || !this.model.neTypeKnown()) {
            return 5;
        }
        if (this.model.isInited() && this.model.getConnectionState() && (iAlarmStore = this.getElementAlarmStore()) != null) {
            return NetMapNode.getMapNodeState(iAlarmStore.getAlarmStatus());
        }
        return 4;
    }

    private void setState(int n) {
        this.state = n;
        this.updateGraphic();
    }

    private int getModelOpticalType() {
        int n;
        block3: {
            n = 0;
            if (this.model != null && this.model.isInited() && (this.model.getNodeType() == 2 || this.model.getNodeType() == 1)) {
                try {
                    n = this.model.getNodeOpticalType();
                }
                catch (Exception exception) {
                    db.severe("Caught " + exception + " in getModelOpticalType()");
                    if (!db.on()) break block3;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        return n;
    }

    protected void updateGraphic() {
        if (this.mtk.isDetailed()) {
            this.setColor(this.stateToColor(this.getState()));
        } else {
            this.setIcon(this.getIcon());
        }
    }

    public static int getMapNodeState(IAlarmStatus iAlarmStatus) {
        int n = 0;
        if (iAlarmStatus != null) {
            switch (iAlarmStatus.getHighestSeverity()) {
                case 0: {
                    n = 0;
                    break;
                }
                case 1: {
                    n = 1;
                    break;
                }
                case 2: {
                    n = 2;
                    break;
                }
                case 3: {
                    n = 3;
                    break;
                }
                default: {
                    db.println("Unexpected AlarmStatus = " + iAlarmStatus);
                    n = 4;
                }
            }
        }
        if (db.on()) {
            db.println("getMapNodeState(" + iAlarmStatus + ") returns " + n);
        }
        return n;
    }

    public static Color getMapNodeColor(IAlarmStatus iAlarmStatus) {
        Color color = OK_COLOR;
        if (iAlarmStatus != null) {
            switch (iAlarmStatus.getHighestSeverity()) {
                case 0: {
                    color = OK_COLOR;
                    break;
                }
                case 1: {
                    color = MINOR_COLOR;
                    break;
                }
                case 2: {
                    color = MAJOR_COLOR;
                    break;
                }
                case 3: {
                    color = CRITICAL_COLOR;
                    break;
                }
                default: {
                    db.println("Unexpected AlarmStatus = " + iAlarmStatus);
                    color = DISCONNECTED_COLOR;
                }
            }
        }
        if (db.on()) {
            db.println("getMapNodeState(" + iAlarmStatus + ") returns " + color);
        }
        return color;
    }

    public void update(Observable observable, Object object) {
        if (db.on()) {
            db.println("update: received an update from:" + observable + " arg=" + object);
        }
        if (observable instanceof NodeModel.ConnectionNotifier || observable instanceof NodeModel && object == ModelUpdateType.CHANGED || observable instanceof INetElement && object == ModelUpdateType.CHANGED || object instanceof IAlarmStatus) {
            SwingUtilities.invokeLater(this.updateNodeAttributes);
            if (this.mtk instanceof NetworkMap) {
                ((NetworkMap)this.mtk).updateVitalStatsPane(this);
            }
        }
    }

    private void updateNodeAttributes() {
        this.checkConnection();
        this.checkNodeNameChanged();
        if (!this.isVirtual()) {
            this.checkNodeAttributes();
        }
        this.updateNodePosition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkConnection() {
        int n;
        int n2;
        int n3 = this.getState();
        if (n3 != (n2 = this.getModelState())) {
            try {
                NetworkViewController networkViewController;
                if (this.mtk instanceof NetworkMap) {
                    ((NetworkMap)this.mtk).updateToolbar();
                }
                if (n3 == 5 || n3 == 4) {
                    if (db.on()) {
                        db.println("Update: " + this.getName() + " no longer " + "disconnected; observing its alarm store.");
                    }
                    this.startObservingAlarmStore();
                } else if (n2 == 4) {
                    if (db.on()) {
                        db.println("Update: " + this.getName() + " no longer " + "connected; stop observing its alarm store.");
                    }
                    this.stopObservingAlarmStore();
                }
                if (db.on()) {
                    db.println("received connection update: node=" + this.getName() + " ST=" + n3 + "->" + n2);
                }
                if ((networkViewController = NetworkViewController.instance()) != null) {
                    boolean bl;
                    boolean bl2 = this.state != 4;
                    boolean bl3 = bl = n2 != 4;
                    if (bl2 != bl) {
                        if (db.on()) {
                            db.println("Notifying NVC of conn state change to " + bl);
                        }
                        networkViewController.nodeConnectionStateChanged(this.model, bl);
                    }
                }
            }
            catch (Exception exception) {
                db.println("checkConnection: caught exception");
                SDebug.printStackTrace((Throwable)exception);
            }
            finally {
                this.setState(n2);
            }
        }
        if (this.opticalNodeType != (n = this.getModelOpticalType())) {
            this.updateGraphic();
            this.opticalNodeType = n;
        }
    }

    private void updateNodePosition() {
        if (!this.mtk.getMapProperty(this, 101)) {
            this.resetPosition();
        }
        this.mtk.updateView();
    }

    void updateNodeName() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                String string = NetMapNode.this.getNewNodeName();
                if (!NetMapNode.this.isVirtual()) {
                    NetMapNode.this.changeNodeName(string);
                } else {
                    MapNode[] mapNodeArray = NetMapNode.this.getVNodes();
                    for (int i = 0; i < mapNodeArray.length; ++i) {
                        ((NetMapNode)mapNodeArray[i]).changeNodeName(string);
                    }
                }
            }
        });
        if (this.mtk instanceof NetworkMap) {
            NetworkMap networkMap = (NetworkMap)this.mtk;
            networkMap.updateVitalStatsPane(this);
        }
    }

    private void checkNodeIdChanged() {
        if (this.model != null) {
            int n = this.model.getNodeId();
            if (NetMapNode.db.on) {
                db.println("oldNodeId=" + this.nodeId + " newNodeId=" + n);
            }
            if (this.nodeId != n && this.nodeId != 0) {
                NetworkViewController.instance().repairHistory(this.nodeId, n);
                NetworkModel.instance().nodeIdChanged(this.nodeId, n);
                String string = ErrorMsg.getString((EID)NEMC.WID_NEED_TO_REPAIR_CKTS_PARAM_1, (Object)this.model.getName());
                CerentDialog.warningDialog((Component)JOptionPane.getFrameForComponent(this.mtk.getGraphWindow()), (String)string, (String)"Node MAC Address Change", (boolean)false);
                this.nodeId = n;
            }
        }
    }

    private void checkNodeNameChanged() {
        block4: {
            try {
                String string = this.getName();
                String string2 = this.getNewNodeName();
                if (!string2.equals(string)) {
                    this.changeNodeName(string2);
                    if (db.on()) {
                        db.println("Update: Node name changed, " + string + " -> " + string2);
                    }
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block4;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    private void checkNodeAttributes() {
        block5: {
            block4: {
                try {
                    this.checkNodeIdChanged();
                }
                catch (Exception exception) {
                    if (!db.on()) break block4;
                    db.println("Caught exception in checkNodeAttributes->checkNodeIdChanged()");
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            try {
                Thread thread = new Thread("DomainThread"){

                    public void run() {
                        block2: {
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException interruptedException) {
                                if (!db.on()) break block2;
                                db.println("Caught InterruptedException in checkNodeAttributes");
                                db;
                                SDebug.printStackTrace((Throwable)interruptedException);
                            }
                        }
                        NetMapNode.this.checkNodeDomainChanged();
                    }
                };
                thread.start();
            }
            catch (Exception exception) {
                if (!db.on()) break block5;
                db.println("Caught exception in checkNodeAttributes->checkNodeDomainChanged()");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkNodeDomainChanged() {
        if (MapPersist.storeDomainInPrefs() || !this.isNetworkMap()) {
            return;
        }
        if (this.model != null) {
            String string = this.getDomainName();
            String string2 = MapPersist.getNodeDomain(this.model);
            if (NetMapNode.db.on) {
                db.println("checkNodeDomainChanged: node=" + this.getName() + " old domain=" + string + " new domain=" + string2);
            }
            if (!string2.equals(string)) {
                MapToolkit mapToolkit = this.mtk;
                synchronized (mapToolkit) {
                    if (!string2.equals("") && !this.mtk.containsDomain(string2)) {
                        this.mtk.createDomain(string2, this.getCenterX(), this.getCenterY(), null);
                    }
                    if (string2.equals("")) {
                        this.mtk.moveNode(this.mtk.getMapNode(this.model));
                    } else {
                        this.mtk.moveNode(this.mtk.getMapNode(this.model), string2);
                    }
                    this.mtk.removeEmptyDomain(string);
                    this.mtk.updateView();
                }
            }
        }
    }

    private void addObservers() {
        if (this.model != null) {
            this.model.getConnectionNotifier().addObserver((Observer)this);
            ModelIndirectObservable.instance().addObserver((IObservable)this.model, this);
        }
        if (this.ne != null) {
            this.ne.addObserver(this);
        }
    }

    private void startObservingAlarmStore() {
        IAlarmStore iAlarmStore;
        if (NetMapNode.db.on) {
            db.println("startObservingAlarmStore: node " + this.getName());
        }
        if ((iAlarmStore = this.getElementAlarmStore()) != null) {
            iAlarmStore.addAlarmStatusObserver((Observer)this);
        }
    }

    private void stopObservingAlarmStore() {
        IAlarmStore iAlarmStore;
        if (NetMapNode.db.on) {
            db.println("stopObservingAlarmStore: node " + this.getName());
        }
        if ((iAlarmStore = this.getElementAlarmStore()) != null) {
            iAlarmStore.deleteAlarmStatusObserver((Observer)this);
            this.resetElementAlarmStore();
        }
    }

    protected void deleteObservers() {
        if (this.model != null) {
            this.model.getConnectionNotifier().deleteObserver((Observer)this);
            ModelIndirectObservable.instance().deleteObserver((IObservable)this.model, this);
            this.stopObservingAlarmStore();
        }
        if (this.ne != null) {
            this.ne.deleteObserver(this);
        }
    }

    public void destroy() {
        block3: {
            if (NetMapNode.db.on) {
                db.println("destroy() called");
            }
            try {
                this.deleteObservers();
            }
            catch (Exception exception) {
                if (!db.on()) break block3;
                db.println("Caught exception in destroy()");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        super.destroy();
    }

    private String getNodeTypeTooltip() {
        String string = null;
        try {
            if (this.model.getNodeType() == 2 || this.model.getNodeType() == 1) {
                string = INodeType.NODE_OPT_TYPES[this.model.getNodeOpticalType()];
                if (db.on()) {
                    db.println("tooltip=" + string);
                }
            }
        }
        catch (Exception exception) {
            db.severe("Caught " + exception + ", please check that INodeType.NODE_OPT_TYPES is up-to-date.");
        }
        return string;
    }

    public String getToolTipText() {
        IAlarmStore iAlarmStore;
        if (this.getState() != 4 && (iAlarmStore = this.getElementAlarmStore()) != null) {
            IAlarmStatus iAlarmStatus = iAlarmStore.getAlarmStatus();
            String string = this.toolTipNodeType != null ? this.toolTipNodeType + ":" : "";
            if (iAlarmStatus != null) {
                StringBuffer stringBuffer = new StringBuffer();
                if (this.isVirtual()) {
                    stringBuffer.append(this.getRealNode().getDomainName() + "(");
                }
                stringBuffer.append(this.getName() + ":");
                stringBuffer.append(string);
                stringBuffer.append(" CR:" + iAlarmStatus.critical());
                stringBuffer.append(" MJ:" + iAlarmStatus.major());
                stringBuffer.append(" MI:" + iAlarmStatus.minor());
                if (this.isVirtual()) {
                    stringBuffer.append(")");
                }
                return stringBuffer.toString();
            }
            if (this.isVirtual()) {
                return "(" + this.getName() + ":" + string + " CR:0 MJ:0 MI:0 )";
            }
            return this.getName() + ":" + string + " CR:0 MJ:0 MI:0";
        }
        return this.getName() + ": Node not responding";
    }

    protected boolean isSuperuser() {
        return AbstractPane.isUserAuthorized(this.model, SecurityLevel.SUPERUSER);
    }

    protected int getNodeRoleInNetLink(INetLink iNetLink) {
        Object object = this.getUserObject();
        if (iNetLink != null && object != null && object instanceof INodeModel) {
            INodeModel iNodeModel = (INodeModel)object;
            INodeModel iNodeModel2 = iNetLink.getSrc().getNodeModel();
            INodeModel iNodeModel3 = iNetLink.getDst().getNodeModel();
            if (iNodeModel == iNodeModel2) {
                return 1;
            }
            if (iNodeModel == iNodeModel3) {
                return 2;
            }
        }
        return 0;
    }

    protected void initPopupMenu(UPopupMenu uPopupMenu) {
        int n = this.getState();
        this.actOrg.addMenuItem((JComponent)uPopupMenu, null, CMD_NODE_OPEN, 79);
        this.actOrg.getAbstractButton(CMD_NODE_OPEN).setEnabled(n != 4 && n != 5);
        this.actOrg.addMenuItem((JComponent)uPopupMenu, null, CMD_NODE_RESET_POS, 82);
        this.actOrg.getAbstractButton(CMD_NODE_RESET_POS).setEnabled(n != 4 && n != 5);
        if (this.isNetworkMap()) {
            uPopupMenu.addSeparator();
            if (!this.isVirtual()) {
                this.actOrg.addMenuItem((JComponent)uPopupMenu, null, CMD_DEL_NODE, 68);
            }
        }
        super.initPopupMenu(uPopupMenu);
        boolean bl = this.isSuperuser() && n != 4 && n != 5 && this.isNetworkMap();
        this.actOrg.setEnabled("Move Node Back To Parent View", bl);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == CMD_NODE_OPEN) {
            this.doOpenNode();
        } else if (string == CMD_NODE_RESET_POS) {
            this.doResetPos();
        } else if (string == CMD_DEL_NODE) {
            this.doDeleteNode();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    protected void doOpenNode() {
        this.doubleClicked();
    }

    protected void doDeleteNode() {
        if (this.getUserObject() instanceof INodeModel) {
            MapPersist.removeNodeFromDomain(this, null);
            NetworkViewController.instance().getNetworkMap().deleteSelectedNetElement((INodeModel)this.getUserObject());
        }
    }

    public synchronized void doResetPos() {
        if (!CerentDialog.yesNoDialog((Component)JOptionPane.getFrameForComponent(this.mtk.getGraphWindow()), (String)"This operation will overwrite the previously saved node position.\nOK to continue?", (String)CMD_NODE_RESET_POS)) {
            return;
        }
        this.resetPosition();
    }

    protected boolean canInsertToDomain() {
        if (!this.isNetworkMap()) {
            return false;
        }
        if (this.getState() == 4 || this.getState() == 5) {
            ErrorMsg.displayWarning(null, (EID)NEMC.WID_UNABLE_INSERT_NODE_INTO_DOMAIN);
            return false;
        }
        if (this.isSuperuser() || MapPersist.storeDomainInPrefs()) {
            return true;
        }
        ErrorMsg.displayWarning(null, (EID)NEMC.WID_INSUFFICIENT_SECURITY_PRIVILEGE);
        return false;
    }

    protected Image getIcon() {
        if (this.mtk.isDetailed()) {
            return null;
        }
        int n = 8;
        try {
            Image[] imageArray = this.fetchIcons(this.getUserObject());
            if (this.isVirtual()) {
                return imageArray[this.getState() + n];
            }
            return imageArray[this.getState()];
        }
        catch (Exception exception) {
            if (NetMapNode.db.on) {
                db.println("getImage: caught exception");
                SDebug.printStackTrace((Throwable)exception);
            }
            return null;
        }
    }

    private IAlarmStore getElementAlarmStore() {
        block5: {
            if (this.alarmStore == null && this.model != null) {
                try {
                    this.alarmStore = this.model.getElementAlarmStore();
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    db.println("Caught exception in getElementAlarmStore()");
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)abstractCmsIOException);
                    }
                }
                catch (Exception exception) {
                    db.println("Caught exception in getElementAlarmStore()");
                    if (!db.on()) break block5;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        return this.alarmStore;
    }

    public String getVitalStatsString() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.model.getName() + " \n");
        if (this.isCmsHost) {
            stringBuffer.append("CTC (login) host\n");
        }
        if (this.isTopoHost()) {
            stringBuffer.append("Topology host\n");
        }
        if (!this.model.isInited() || !this.model.getConnectionState()) {
            stringBuffer.append("Node is disconnected\n");
        }
        try {
            object = this.model.getElementAlarmStore().getAlarmStatus();
            stringBuffer.append("Critical : " + object.critical() + "\n");
            stringBuffer.append("Major    : " + object.major() + "\n");
            stringBuffer.append("Minor    : " + object.minor());
        }
        catch (Exception exception) {
            stringBuffer.append("(N/A alarm status)");
        }
        object = this.getRealNode().getDomainName();
        if (((String)object).length() > 0) {
            stringBuffer.append("\nDomain   : " + (String)object);
        }
        return stringBuffer.toString();
    }

    private void resetElementAlarmStore() {
        this.alarmStore = null;
    }

    private boolean isNetworkMap() {
        return this.mtk instanceof NetworkMap;
    }

    private class UpdateNodeAttributes
    implements Runnable {
        private UpdateNodeAttributes() {
        }

        public void run() {
            NetMapNode.this.updateNodeAttributes();
        }
    }
}

