/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.network;

import cerent.cms.model.ILinkModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModel;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.Network;
import cerent.cms.ui.network.NetMapLink;
import cerent.cms.ui.network.NetworkMap;
import cerent.util.SDebug;
import com.cisco.ctc.util.map.MapImage;
import com.cisco.ctc.util.map.MapImageIcon;
import com.cisco.ctc.util.map.MapToolkit;
import java.awt.Image;
import java.util.Observable;
import java.util.Observer;
import javax.swing.SwingUtilities;

public class ProtectionSwitchState
implements Observer {
    private static SDebug db = new SDebug("ProtectionSwitchState");
    private static final Image MANUAL_ICON = MapImage.createImage("/images/icons/link/manual.gif");
    private static final Image FORCE_ICON = MapImage.createImage("/images/icons/link/force.gif");
    private static final Image LOCKOUT_ICON = MapImage.createImage("/images/icons/link/lockout.gif");
    private static final Image EXERCISE_ICON = MapImage.createImage("/images/icons/link/exercise.gif");
    private static final String CLEAR = "PS_C";
    private static final String PS_E = "PS_E";
    private static final String PS_M = "PS_M";
    private static final String PS_F = "PS_F";
    private static final String PS_L = "PS_L";
    private INodeModel srcModel = null;
    private INodeModel dstModel = null;
    private Network netModel = Network.instance();
    private INetLink fwdLink = null;
    private String pss = "PS_C";
    private Object[][] OnePlusOneOrderedStates = new Object[][]{{new Integer(7), "PS_E"}, {new Integer(5), "PS_M"}, {new Integer(6), "PS_M"}, {new Integer(3), "PS_F"}, {new Integer(4), "PS_F"}, {new Integer(2), "PS_L"}, {new Integer(1), "PS_L"}};
    private Object[][] BlsrOrderedStates = new Object[][]{{new Integer(6), "PS_E"}, {new Integer(7), "PS_E"}, {new Integer(4), "PS_M"}, {new Integer(5), "PS_M"}, {new Integer(2), "PS_F"}, {new Integer(3), "PS_F"}, {new Integer(1), "PS_L"}};
    private MapToolkit mtk;
    private NetMapLink link;

    public ProtectionSwitchState(MapToolkit mapToolkit, NetMapLink netMapLink) {
        this.mtk = mapToolkit;
        this.link = netMapLink;
        Object object = netMapLink.getUserObject();
        if (object instanceof INetLink) {
            this.fwdLink = (INetLink)object;
        }
        if (this.fwdLink == null) {
            return;
        }
        this.addConnectionNotifierObservers();
        this.addNetLinkObservers();
        this.setLinkProtectionAnnotation();
    }

    private void setLinkProtectionAnnotation() {
        String string;
        this.pss = CLEAR;
        this.removeIcons(this.link);
        int n = this.getProtectionType();
        if (n == -1) {
            return;
        }
        boolean bl = n == 1;
        INetLink iNetLink = this.fwdLink.getReverseLink();
        int n2 = this.fwdLink.getEndProtectionSwitchState(true);
        int n3 = -1;
        if (iNetLink != null) {
            n3 = iNetLink.getEndProtectionSwitchState(true);
        }
        if (db.on()) {
            db.println(this.fwdLink + ", ProtectionSwitchState=" + n2);
            db.println(iNetLink + ", ProtectionSwitchState=" + n3);
        }
        n2 = this.getPsState(n2, bl);
        n3 = this.getPsState(n3, bl);
        if (n2 != -1) {
            string = this.getPsString(n2, bl);
            if (db.on()) {
                db.println(this.fwdLink + ", ProtectionSwitchStateString=" + string);
            }
            this.showIcon(string, true);
        }
        if (n3 != -1) {
            string = this.getPsString(n3, bl);
            if (db.on()) {
                db.println(iNetLink + ", ProtectionSwitchStateString=" + string);
            }
            this.showIcon(string, false);
        }
        if (n2 != -1 || n3 != -1) {
            this.pss = this.getPsString(n2 > n3 ? n2 : n3, bl);
            if (db.on()) {
                db.println("link: resultant Protection Switch State=" + this.pss);
            }
        }
    }

    private void removeIcons(final NetMapLink netMapLink) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                netMapLink.removeAllDecorativeIcons();
            }
        });
    }

    private void showIcon(final String string, final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ProtectionSwitchState.this.addIcon(string, bl);
            }
        });
    }

    private void addIcon(String string, boolean bl) {
        MapImageIcon mapImageIcon = null;
        if (string == PS_M) {
            mapImageIcon = new MapImageIcon(MANUAL_ICON);
        } else if (string == PS_F) {
            mapImageIcon = new MapImageIcon(FORCE_ICON);
        } else if (string == PS_L) {
            mapImageIcon = new MapImageIcon(LOCKOUT_ICON);
        } else if (string == PS_E) {
            mapImageIcon = new MapImageIcon(EXERCISE_ICON);
        }
        if (mapImageIcon != null) {
            if (bl) {
                this.link.addSrcDecorativeIcon(string, mapImageIcon);
            } else {
                this.link.addTargetDecorativeIcon(string, mapImageIcon);
            }
        }
    }

    private int getPsState(int n, boolean bl) {
        if (bl) {
            for (int i = 0; i < this.OnePlusOneOrderedStates.length; ++i) {
                Object[] objectArray = this.OnePlusOneOrderedStates[i];
                if (n != (Integer)objectArray[0]) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.BlsrOrderedStates.length; ++i) {
                Object[] objectArray = this.BlsrOrderedStates[i];
                if (n != (Integer)objectArray[0]) continue;
                return i;
            }
        }
        return -1;
    }

    private String getPsString(int n, boolean bl) {
        String string = CLEAR;
        try {
            if (bl) {
                Object[] objectArray = this.OnePlusOneOrderedStates[n];
                string = (String)objectArray[1];
            } else {
                Object[] objectArray = this.BlsrOrderedStates[n];
                string = (String)objectArray[1];
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        return string;
    }

    public String getProtectionSwitchStateString() {
        if (this.pss == PS_E) {
            return "Execise";
        }
        if (this.pss == PS_M) {
            return "Manual";
        }
        if (this.pss == PS_F) {
            return "Force";
        }
        if (this.pss == PS_L) {
            return "Lockout";
        }
        return null;
    }

    private void addConnectionNotifierObservers() {
        ILinkModel iLinkModel = this.fwdLink.getLinkModel();
        this.srcModel = iLinkModel.src();
        this.dstModel = iLinkModel.dst();
        if (this.srcModel != null && this.srcModel.getConnectionNotifier() != null) {
            this.srcModel.getConnectionNotifier().addObserver((Observer)this);
        }
        if (this.dstModel != null && this.dstModel.getConnectionNotifier() != null) {
            this.dstModel.getConnectionNotifier().addObserver((Observer)this);
        }
    }

    private void addNetLinkObservers() {
        this.fwdLink.addObserver(this);
        INetLink iNetLink = this.fwdLink.getReverseLink();
        if (iNetLink == null) {
            this.netModel.getNetLinkCreationNotifier().addObserver(this);
        } else {
            iNetLink.addObserver(this);
        }
    }

    private int getProtectionType() {
        int n = -1;
        if (this.fwdLink.getProtectionType() == 1 || this.fwdLink.getProtectionType() == 0 || this.fwdLink.getProtectionType() == 4) {
            return this.fwdLink.getProtectionType();
        }
        INetLink iNetLink = this.fwdLink.getReverseLink();
        if (n == -1 && iNetLink != null && (iNetLink.getProtectionType() == 1 || iNetLink.getProtectionType() == 0 || iNetLink.getProtectionType() == 4)) {
            return iNetLink.getProtectionType();
        }
        return n;
    }

    public synchronized void update(Observable observable, Object object) {
        Object object2;
        if (db.on()) {
            db.println("received notify msg from " + observable + " o=" + object);
        }
        if (observable instanceof Network.NetLinkCreationNotifier) {
            if (object instanceof INetLink && (object2 = (INetLink)object).getReverseLink() == this.fwdLink) {
                object2.addObserver((Observer)this);
                this.setLinkProtectionAnnotation();
            }
        } else if (observable instanceof NodeModel.ConnectionNotifier) {
            object2 = (NodeModel.ConnectionNotifier)((Object)observable);
            if (((NodeModel.ConnectionNotifier)object2).getNodeModel().getConnectionState()) {
                if (ProtectionSwitchState.db.on) {
                    db.println("received connection update");
                }
                this.setLinkProtectionAnnotation();
            } else {
                if (ProtectionSwitchState.db.on) {
                    db.println("received disconnection update");
                }
                this.removeIcons(this.link);
            }
        } else if (observable instanceof INetLink) {
            if (object == ModelUpdateType.DELETED) {
                object2 = (INetLink)((Object)observable);
                if (object2.getReverseLink() == this.fwdLink) {
                    object2.deleteObserver((Observer)this);
                }
            } else {
                this.setLinkProtectionAnnotation();
            }
        }
        if (this.mtk instanceof NetworkMap) {
            object2 = (NetworkMap)this.mtk;
            ((NetworkMap)object2).updateVitalStatsPane(this.link);
        }
    }

    public void destroy() {
        this.deleteNetLinkObservers();
        this.deleteConnectionNotifierObservers();
    }

    private void deleteNetLinkObservers() {
        try {
            this.fwdLink.deleteObserver(this);
            INetLink iNetLink = this.fwdLink.getReverseLink();
            if (iNetLink != null) {
                iNetLink.addObserver(this);
            }
            this.netModel.getNetLinkCreationNotifier().deleteObserver(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void deleteConnectionNotifierObservers() {
        try {
            if (this.srcModel != null) {
                this.srcModel.getConnectionNotifier().deleteObserver((Observer)this);
            }
            if (this.dstModel != null) {
                this.dstModel.getConnectionNotifier().deleteObserver((Observer)this);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

