/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ohcircuits;

import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.UdcRate;
import cerent.cms.model.ohcircuits.OhNetCircuitModel;
import cerent.cms.ncp.CircuitProvError;
import cerent.cms.ocm.OhCircuit;
import cerent.cms.ocm.UdcF1Circuit;
import cerent.cms.ui.NetworkProvPane;
import cerent.cms.ui.TabbedView;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.gui.TextPanel;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class OhCedGeneralPane
extends NetworkProvPane
implements DocumentListener,
Runnable {
    private OhCircuit curCircuit;
    private JTextField nameTF;
    private JLabel typeLabel;
    private static final SDebug db = new SDebug("OhCedGeneralPane");

    public OhCedGeneralPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        UdcRate udcRate;
        OhNetCircuitModel ohNetCircuitModel = (OhNetCircuitModel)tabbedView.getUiModel();
        this.curCircuit = ohNetCircuitModel.getOhCircuit();
        this.curCircuit.addObserver((Observer)((Object)this));
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(2, 1));
        TextPanel textPanel = new TextPanel("Name: ", 48);
        this.nameTF = textPanel.getTextField();
        this.nameTF.getDocument().addDocumentListener(this);
        this.enableComponent(this.nameTF);
        jPanel.add(textPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(4, 1));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(new JLabel("Circuit Type:  "));
        this.typeLabel = new JLabel();
        jPanel3.add(this.typeLabel);
        jPanel2.add(jPanel3);
        if (this.curCircuit.getCircuitType() == 0 && (udcRate = ((UdcF1Circuit)this.curCircuit).getUdcRate()) != null) {
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new BoxLayout(jPanel4, 0));
            jPanel4.add(new JLabel("UDC Rate: "));
            jPanel4.add(new JLabel(udcRate.getName()));
            jPanel2.add(jPanel4);
        }
        jPanel.add(jPanel2);
        this.add(jPanel);
        this.updateInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (db.on()) {
            db.println("dispose");
        }
        OhCedGeneralPane ohCedGeneralPane = this;
        synchronized (ohCedGeneralPane) {
            this.curCircuit.deleteObserver((Observer)((Object)this));
            this.curCircuit = null;
        }
        super.destroy();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.setDirty();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.setDirty();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.setDirty();
    }

    public void applyChangesToModel() throws Exception {
        if (db.on()) {
            db.println("applyChangesToModel: start");
        }
        try {
            this.curCircuit.rename(this.nameTF.getText());
        }
        catch (CircuitProvError circuitProvError) {
            String string = circuitProvError.getMessage();
            string = string + ".\nIt is possible that the name " + "contains illegal characters,\nis too long, or cannot be " + "renamed in its current state.";
            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_INVALID_CKT_NAME_PARAM_1, (Object)string);
        }
        if (db.on()) {
            db.println("Circuit renamed to: " + this.nameTF.getText());
        }
        if (db.on()) {
            db.println("applyChangesToModel: finish");
        }
    }

    public void refreshFromModel() throws Exception {
        if (db.on()) {
            db.println("refreshFromModel: start");
        }
        if (this.curCircuit != null) {
            this.nameTF.setText(this.curCircuit.getCircuitName());
        }
        if (db.on()) {
            db.println("refreshFromModel: finish");
        }
    }

    public void update(Observable observable, Object object) {
        if (object != ModelUpdateType.DELETED) {
            this.updateInfo();
        }
    }

    private synchronized void updateInfo() {
        if (this.curCircuit == null) {
            return;
        }
        SwingUtilities.invokeLater(this);
    }

    public void run() {
        block3: {
            if (OhCedGeneralPane.db.on) {
                db.println("CedGeneralPane.updateInfo() runnable");
            }
            try {
                this.typeLabel.setText(this.curCircuit.getCircuitTypeObj().getLongName());
            }
            catch (NullPointerException nullPointerException) {
                if (!OhCedGeneralPane.db.on) break block3;
                db.println("CedGeneralPane.updateInfo(): Circuit has been set to null while trying to update Pane.");
            }
        }
    }
}

